/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.ime;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.PrintStreamPrinter;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.view.IInputMethodManager;
import java.util.List;

public final class Ime {
    IInputMethodManager mImm;
    private String[] mArgs;
    private int mNextArg;
    private String mCurArgData;
    private static final String IMM_NOT_RUNNING_ERR = "Error: Could not access the Input Method Manager.  Is the system running?";

    public static void main(String[] args) {
        new Ime().run(args);
    }

    public void run(String[] args) {
        if (args.length < 1) {
            Ime.showUsage();
            return;
        }
        this.mImm = IInputMethodManager.Stub.asInterface(ServiceManager.getService("input_method"));
        if (this.mImm == null) {
            System.err.println(IMM_NOT_RUNNING_ERR);
            return;
        }
        this.mArgs = args;
        String op = args[0];
        this.mNextArg = 1;
        if ("list".equals(op)) {
            this.runList();
            return;
        }
        if ("enable".equals(op)) {
            this.runSetEnabled(true);
            return;
        }
        if ("disable".equals(op)) {
            this.runSetEnabled(false);
            return;
        }
        if ("set".equals(op)) {
            this.runSet();
            return;
        }
        if (op != null) {
            System.err.println("Error: unknown command '" + op + "'");
        }
        Ime.showUsage();
    }

    private void runList() {
        List<InputMethodInfo> methods;
        String opt;
        boolean all = false;
        boolean brief = false;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("-a")) {
                all = true;
                continue;
            }
            if (opt.equals("-s")) {
                brief = true;
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            Ime.showUsage();
            return;
        }
        if (!all) {
            try {
                methods = this.mImm.getEnabledInputMethodList();
            }
            catch (RemoteException e) {
                System.err.println(e.toString());
                System.err.println(IMM_NOT_RUNNING_ERR);
                return;
            }
        }
        try {
            methods = this.mImm.getInputMethodList();
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(IMM_NOT_RUNNING_ERR);
            return;
        }
        if (methods != null) {
            PrintStreamPrinter pr = new PrintStreamPrinter(System.out);
            for (int i = 0; i < methods.size(); ++i) {
                InputMethodInfo imi = methods.get(i);
                if (brief) {
                    System.out.println(imi.getId());
                    continue;
                }
                System.out.println(imi.getId() + ":");
                imi.dump(pr, "  ");
            }
        }
    }

    private void runSetEnabled(boolean state) {
        String id2 = this.nextArg();
        if (id2 == null) {
            System.err.println("Error: no input method ID specified");
            Ime.showUsage();
            return;
        }
        try {
            boolean res = this.mImm.setInputMethodEnabled(id2, state);
            if (state) {
                System.out.println("Input method " + id2 + ": " + (res ? "already enabled" : "now enabled"));
            } else {
                System.out.println("Input method " + id2 + ": " + (res ? "now disabled" : "already disabled"));
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return;
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(IMM_NOT_RUNNING_ERR);
            return;
        }
    }

    private void runSet() {
        String id2 = this.nextArg();
        if (id2 == null) {
            System.err.println("Error: no input method ID specified");
            Ime.showUsage();
            return;
        }
        try {
            this.mImm.setInputMethod(null, id2);
            System.out.println("Input method " + id2 + " selected");
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return;
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(IMM_NOT_RUNNING_ERR);
            return;
        }
    }

    private String nextOption() {
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        if (!arg.startsWith("-")) {
            return null;
        }
        ++this.mNextArg;
        if (arg.equals("--")) {
            return null;
        }
        if (arg.length() > 1 && arg.charAt(1) != '-') {
            if (arg.length() > 2) {
                this.mCurArgData = arg.substring(2);
                return arg.substring(0, 2);
            }
            this.mCurArgData = null;
            return arg;
        }
        this.mCurArgData = null;
        return arg;
    }

    private String nextOptionData() {
        if (this.mCurArgData != null) {
            return this.mCurArgData;
        }
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String data = this.mArgs[this.mNextArg];
        ++this.mNextArg;
        return data;
    }

    private String nextArg() {
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        ++this.mNextArg;
        return arg;
    }

    private static void showUsage() {
        System.err.println("usage: ime list [-a] [-s]");
        System.err.println("       ime enable ID");
        System.err.println("       ime disable ID");
        System.err.println("       ime set ID");
        System.err.println("");
        System.err.println("The list command prints all enabled input methods.  Use");
        System.err.println("the -a option to see all input methods.  Use");
        System.err.println("the -s option to see only a single summary line of each.");
        System.err.println("");
        System.err.println("The enable command allows the given input method ID to be used.");
        System.err.println("");
        System.err.println("The disable command disallows the given input method ID from use.");
        System.err.println("");
        System.err.println("The set command switches to the given input method ID.");
    }
}

