/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.input;

import android.hardware.input.InputManager;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.HashMap;
import java.util.Map;

public class Input {
    private static final String TAG = "Input";
    private static final String INVALID_ARGUMENTS = "Error: Invalid arguments for command: ";
    private static final Map<String, Integer> SOURCES = new HashMap<String, Integer>(){
        {
            this.put("keyboard", 257);
            this.put("dpad", 513);
            this.put("gamepad", 1025);
            this.put("touchscreen", 4098);
            this.put("mouse", 8194);
            this.put("stylus", 16386);
            this.put("trackball", 65540);
            this.put("touchpad", 0x100008);
            this.put("touchnavigation", 0x200000);
            this.put("joystick", 0x1000010);
        }
    };

    public static void main(String[] args) {
        new Input().run(args);
    }

    private void run(String[] args) {
        String command;
        block22: {
            if (args.length < 1) {
                this.showUsage();
                return;
            }
            int index = 0;
            command = args[index];
            int inputSource = 0;
            if (SOURCES.containsKey(command)) {
                inputSource = SOURCES.get(command);
                command = args[++index];
            }
            int length = args.length - index;
            try {
                if (command.equals("text")) {
                    if (length == 2) {
                        inputSource = Input.getSource(inputSource, 257);
                        this.sendText(inputSource, args[index + 1]);
                        return;
                    }
                    break block22;
                }
                if (command.equals("keyevent")) {
                    if (length >= 2) {
                        boolean longpress = "--longpress".equals(args[index + 1]);
                        int start = longpress ? index + 2 : index + 1;
                        inputSource = Input.getSource(inputSource, 257);
                        if (length > start) {
                            for (int i = start; i < length; ++i) {
                                int keyCode = KeyEvent.keyCodeFromString(args[i]);
                                if (keyCode == 0) {
                                    keyCode = KeyEvent.keyCodeFromString("KEYCODE_" + args[i]);
                                }
                                this.sendKeyEvent(inputSource, keyCode, longpress);
                            }
                            return;
                        }
                    }
                    break block22;
                }
                if (command.equals("tap")) {
                    if (length == 3) {
                        inputSource = Input.getSource(inputSource, 4098);
                        this.sendTap(inputSource, Float.parseFloat(args[index + 1]), Float.parseFloat(args[index + 2]));
                        return;
                    }
                    break block22;
                }
                if (command.equals("swipe")) {
                    int duration = -1;
                    inputSource = Input.getSource(inputSource, 4098);
                    switch (length) {
                        case 6: {
                            duration = Integer.parseInt(args[index + 5]);
                        }
                        case 5: {
                            this.sendSwipe(inputSource, Float.parseFloat(args[index + 1]), Float.parseFloat(args[index + 2]), Float.parseFloat(args[index + 3]), Float.parseFloat(args[index + 4]), duration);
                            return;
                        }
                    }
                    break block22;
                }
                if (command.equals("press")) {
                    inputSource = Input.getSource(inputSource, 65540);
                    if (length == 1) {
                        this.sendTap(inputSource, 0.0f, 0.0f);
                        return;
                    }
                    break block22;
                }
                if (command.equals("roll")) {
                    inputSource = Input.getSource(inputSource, 65540);
                    if (length == 3) {
                        this.sendMove(inputSource, Float.parseFloat(args[index + 1]), Float.parseFloat(args[index + 2]));
                        return;
                    }
                    break block22;
                }
                System.err.println("Error: Unknown command: " + command);
                this.showUsage();
                return;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        System.err.println(INVALID_ARGUMENTS + command);
        this.showUsage();
    }

    private void sendText(int source, String text) {
        StringBuffer buff = new StringBuffer(text);
        boolean escapeFlag = false;
        for (int i = 0; i < buff.length(); ++i) {
            if (escapeFlag) {
                escapeFlag = false;
                if (buff.charAt(i) == 's') {
                    buff.setCharAt(i, ' ');
                    buff.deleteCharAt(--i);
                }
            }
            if (buff.charAt(i) != '%') continue;
            escapeFlag = true;
        }
        char[] chars = buff.toString().toCharArray();
        KeyCharacterMap kcm = KeyCharacterMap.load(-1);
        KeyEvent[] events = kcm.getEvents(chars);
        for (int i = 0; i < events.length; ++i) {
            KeyEvent e = events[i];
            if (source != e.getSource()) {
                e.setSource(source);
            }
            this.injectKeyEvent(e);
        }
    }

    private void sendKeyEvent(int inputSource, int keyCode, boolean longpress) {
        long now = SystemClock.uptimeMillis();
        this.injectKeyEvent(new KeyEvent(now, now, 0, keyCode, 0, 0, -1, 0, 0, inputSource));
        if (longpress) {
            this.injectKeyEvent(new KeyEvent(now, now, 0, keyCode, 1, 0, -1, 0, 128, inputSource));
        }
        this.injectKeyEvent(new KeyEvent(now, now, 1, keyCode, 0, 0, -1, 0, 0, inputSource));
    }

    private void sendTap(int inputSource, float x, float y) {
        long now = SystemClock.uptimeMillis();
        this.injectMotionEvent(inputSource, 0, now, x, y, 1.0f);
        this.injectMotionEvent(inputSource, 1, now, x, y, 0.0f);
    }

    private void sendSwipe(int inputSource, float x1, float y1, float x2, float y2, int duration) {
        if (duration < 0) {
            duration = 300;
        }
        long now = SystemClock.uptimeMillis();
        this.injectMotionEvent(inputSource, 0, now, x1, y1, 1.0f);
        long startTime = now;
        long endTime = startTime + (long)duration;
        while (now < endTime) {
            long elapsedTime = now - startTime;
            float alpha = (float)elapsedTime / (float)duration;
            this.injectMotionEvent(inputSource, 2, now, Input.lerp(x1, x2, alpha), Input.lerp(y1, y2, alpha), 1.0f);
            now = SystemClock.uptimeMillis();
        }
        this.injectMotionEvent(inputSource, 1, now, x2, y2, 0.0f);
    }

    private void sendMove(int inputSource, float dx, float dy) {
        long now = SystemClock.uptimeMillis();
        this.injectMotionEvent(inputSource, 2, now, dx, dy, 0.0f);
    }

    private void injectKeyEvent(KeyEvent event) {
        Log.i(TAG, "injectKeyEvent: " + event);
        InputManager.getInstance().injectInputEvent(event, 2);
    }

    private void injectMotionEvent(int inputSource, int action, long when, float x, float y, float pressure) {
        float DEFAULT_SIZE = 1.0f;
        boolean DEFAULT_META_STATE = false;
        float DEFAULT_PRECISION_X = 1.0f;
        float DEFAULT_PRECISION_Y = 1.0f;
        boolean DEFAULT_DEVICE_ID = false;
        boolean DEFAULT_EDGE_FLAGS = false;
        MotionEvent event = MotionEvent.obtain(when, when, action, x, y, pressure, 1.0f, 0, 1.0f, 1.0f, 0, 0);
        event.setSource(inputSource);
        Log.i(TAG, "injectMotionEvent: " + event);
        InputManager.getInstance().injectInputEvent(event, 2);
    }

    private static final float lerp(float a, float b, float alpha) {
        return (b - a) * alpha + a;
    }

    private static final int getSource(int inputSource, int defaultSource) {
        return inputSource == 0 ? defaultSource : inputSource;
    }

    private void showUsage() {
        System.err.println("Usage: input [<source>] <command> [<arg>...]");
        System.err.println();
        System.err.println("The sources are: ");
        for (String src : SOURCES.keySet()) {
            System.err.println("      " + src);
        }
        System.err.println();
        System.err.println("The commands and default sources are:");
        System.err.println("      text <string> (Default: touchscreen)");
        System.err.println("      keyevent [--longpress] <key code number or name> ... (Default: keyboard)");
        System.err.println("      tap <x> <y> (Default: touchscreen)");
        System.err.println("      swipe <x1> <y1> <x2> <y2> [duration(ms)] (Default: touchscreen)");
        System.err.println("      press (Default: trackball)");
        System.err.println("      roll <dx> <dy> (Default: trackball)");
    }
}

