/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.media;

import android.app.PendingIntent;
import android.graphics.Bitmap;
import android.media.IAudioService;
import android.media.IRemoteControlDisplay;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.AndroidException;
import android.view.KeyEvent;
import com.android.internal.os.BaseCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Media
extends BaseCommand {
    private IAudioService mAudioService;

    public static void main(String[] args) {
        new Media().run(args);
    }

    public void onShowUsage(PrintStream out) {
        out.println("usage: media [subcommand] [options]\n       media dispatch KEY\n       media remote-display\n\nmedia dispatch: dispatch a media key to the current media client.\n                KEY may be: play, pause, play-pause, mute, headsethook,\n                stop, next, previous, rewind, recordm fast-forword.\nmedia remote-display: monitor remote display updates.\n");
    }

    public void onRun() throws Exception {
        this.mAudioService = IAudioService.Stub.asInterface(ServiceManager.checkService("audio"));
        if (this.mAudioService == null) {
            System.err.println("Error type 2");
            throw new AndroidException("Can't connect to audio service; is the system running?");
        }
        String op = this.nextArgRequired();
        if (op.equals("dispatch")) {
            this.runDispatch();
        } else if (op.equals("remote-display")) {
            this.runRemoteDisplay();
        } else {
            this.showError("Error: unknown command '" + op + "'");
            return;
        }
    }

    private void sendMediaKey(KeyEvent event) {
        try {
            this.mAudioService.dispatchMediaKeyEvent(event);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void runDispatch() throws Exception {
        int keycode;
        String cmd = this.nextArgRequired();
        if ("play".equals(cmd)) {
            keycode = 126;
        } else if ("pause".equals(cmd)) {
            keycode = 127;
        } else if ("play-pause".equals(cmd)) {
            keycode = 85;
        } else if ("mute".equals(cmd)) {
            keycode = 91;
        } else if ("headsethook".equals(cmd)) {
            keycode = 79;
        } else if ("stop".equals(cmd)) {
            keycode = 86;
        } else if ("next".equals(cmd)) {
            keycode = 87;
        } else if ("previous".equals(cmd)) {
            keycode = 88;
        } else if ("rewind".equals(cmd)) {
            keycode = 89;
        } else if ("record".equals(cmd)) {
            keycode = 130;
        } else if ("fast-forward".equals(cmd)) {
            keycode = 90;
        } else {
            this.showError("Error: unknown dispatch code '" + cmd + "'");
            return;
        }
        long now = SystemClock.uptimeMillis();
        this.sendMediaKey(new KeyEvent(now, now, 0, keycode, 0, 0, -1, 0, 0, 257));
        this.sendMediaKey(new KeyEvent(now, now, 1, keycode, 0, 0, -1, 0, 0, 257));
    }

    private void runRemoteDisplay() throws Exception {
        RemoteDisplayMonitor monitor = new RemoteDisplayMonitor();
        monitor.run();
    }

    class RemoteDisplayMonitor
    extends IRemoteControlDisplay.Stub {
        RemoteDisplayMonitor() {
        }

        public void setCurrentClientId(int clientGeneration, PendingIntent clientMediaIntent, boolean clearing) {
            System.out.println("New client: id=" + clientGeneration + " intent=" + clientMediaIntent + " clearing=" + clearing);
        }

        public void setEnabled(boolean enabled) {
            System.out.println("New enable state= " + (enabled ? "enabled" : "disabled"));
        }

        public void setPlaybackState(int generationId, int state, long stateChangeTimeMs, long currentPosMs, float speed) {
            System.out.println("New state: id=" + generationId + " state=" + state + " time=" + stateChangeTimeMs + " pos=" + currentPosMs + " speed=" + speed);
        }

        public void setTransportControlInfo(int generationId, int transportControlFlags, int posCapabilities) {
            System.out.println("New control info: id=" + generationId + " flags=0x" + Integer.toHexString(transportControlFlags) + " cap=0x" + Integer.toHexString(posCapabilities));
        }

        public void setMetadata(int generationId, Bundle metadata) {
            System.out.println("New metadata: id=" + generationId + " data=" + metadata);
        }

        public void setArtwork(int generationId, Bitmap artwork) {
            System.out.println("New artwork: id=" + generationId + " art=" + artwork);
        }

        public void setAllMetadata(int generationId, Bundle metadata, Bitmap artwork) {
            System.out.println("New metadata+artwork: id=" + generationId + " data=" + metadata + " art=" + artwork);
        }

        void printUsageMessage() {
            System.out.println("Monitoring remote control displays...  available commands:");
            System.out.println("(q)uit: finish monitoring");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void run() throws RemoteException {
            this.printUsageMessage();
            Media.this.mAudioService.registerRemoteControlDisplay(this, 0, 0);
            try {
                String line;
                InputStreamReader converter = new InputStreamReader(System.in);
                BufferedReader in = new BufferedReader(converter);
                while ((line = in.readLine()) != null) {
                    boolean addNewline = true;
                    if (line.length() <= 0) {
                        addNewline = false;
                    } else {
                        if ("q".equals(line)) return;
                        if ("quit".equals(line)) {
                            return;
                        }
                        System.out.println("Invalid command: " + line);
                    }
                    RemoteDisplayMonitor remoteDisplayMonitor = this;
                    synchronized (remoteDisplayMonitor) {
                        if (addNewline) {
                            System.out.println("");
                        }
                        this.printUsageMessage();
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                Media.this.mAudioService.unregisterRemoteControlDisplay(this);
            }
        }
    }
}

