/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.ActivityManagerNative;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Debug;
import android.os.Environment;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.UserHandle;
import android.view.IWindowManager;
import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeyEventSource;
import com.android.commands.monkey.MonkeyFlipEvent;
import com.android.commands.monkey.MonkeyKeyEvent;
import com.android.commands.monkey.MonkeyMotionEvent;
import com.android.commands.monkey.MonkeyNetworkMonitor;
import com.android.commands.monkey.MonkeyRotationEvent;
import com.android.commands.monkey.MonkeySourceNetwork;
import com.android.commands.monkey.MonkeySourceRandom;
import com.android.commands.monkey.MonkeySourceRandomScript;
import com.android.commands.monkey.MonkeySourceScript;
import com.android.commands.monkey.MonkeyThrottleEvent;
import com.android.commands.monkey.MonkeyUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monkey {
    private static final int DEBUG_ALLOW_ANY_STARTS = 0;
    private static final int DEBUG_ALLOW_ANY_RESTARTS = 0;
    private IActivityManager mAm;
    private IWindowManager mWm;
    private IPackageManager mPm;
    private String[] mArgs;
    private int mNextArg;
    private String mCurArgData;
    private int mVerbose;
    private boolean mIgnoreCrashes;
    private boolean mIgnoreTimeouts;
    private boolean mIgnoreSecurityExceptions;
    private boolean mMonitorNativeCrashes;
    private boolean mIgnoreNativeCrashes;
    private boolean mSendNoEvents;
    private boolean mAbort;
    private boolean mCountEvents = true;
    private boolean mRequestAnrTraces = false;
    private boolean mRequestDumpsysMemInfo = false;
    private boolean mRequestAnrBugreport = false;
    private boolean mRequestWatchdogBugreport = false;
    private boolean mWatchdogWaiting = false;
    private boolean mRequestAppCrashBugreport = false;
    private boolean mGetPeriodicBugreport = false;
    private boolean mRequestPeriodicBugreport = false;
    private long mBugreportFrequency = 10L;
    private String mReportProcessName;
    private boolean mRequestProcRank = false;
    private boolean mKillProcessAfterError;
    private boolean mGenerateHprof;
    private String mPkgBlacklistFile;
    private String mPkgWhitelistFile;
    private HashSet<String> mValidPackages = new HashSet();
    private HashSet<String> mInvalidPackages = new HashSet();
    private ArrayList<String> mMainCategories = new ArrayList();
    private ArrayList<ComponentName> mMainApps = new ArrayList();
    long mThrottle = 0L;
    boolean mRandomizeThrottle = false;
    int mCount = 1000;
    long mSeed = 0L;
    Random mRandom = null;
    long mDroppedKeyEvents = 0L;
    long mDroppedPointerEvents = 0L;
    long mDroppedTrackballEvents = 0L;
    long mDroppedFlipEvents = 0L;
    long mDroppedRotationEvents = 0L;
    long mProfileWaitTime = 5000L;
    long mDeviceSleepTime = 30000L;
    boolean mRandomizeScript = false;
    boolean mScriptLog = false;
    private boolean mRequestBugreport = false;
    private String mSetupFileName = null;
    private ArrayList<String> mScriptFileNames = new ArrayList();
    private int mServerPort = -1;
    private static final File TOMBSTONES_PATH = new File("/data/tombstones");
    private HashSet<String> mTombstones = null;
    float[] mFactors = new float[11];
    MonkeyEventSource mEventSource;
    private MonkeyNetworkMonitor mNetworkMonitor = new MonkeyNetworkMonitor();
    public static Intent currentIntent;
    public static String currentPackage;

    private boolean checkEnteringPackage(String pkg) {
        return !(this.mInvalidPackages.size() > 0 ? this.mInvalidPackages.contains(pkg) : this.mValidPackages.size() > 0 && !this.mValidPackages.contains(pkg));
    }

    private void reportProcRank() {
        this.commandLineReport("procrank", "procrank");
    }

    private void reportAnrTraces() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.commandLineReport("anr traces", "cat /data/anr/traces.txt");
    }

    private void reportDumpsysMemInfo() {
        this.commandLineReport("meminfo", "dumpsys meminfo");
    }

    private void commandLineReport(String reportName, String command) {
        System.err.println(reportName + ":");
        Runtime rt = Runtime.getRuntime();
        BufferedWriter logOutput = null;
        try {
            String s;
            Process p = Runtime.getRuntime().exec(command);
            if (this.mRequestBugreport) {
                logOutput = new BufferedWriter(new FileWriter(new File(Environment.getLegacyExternalStorageDirectory(), reportName), true));
            }
            InputStream inStream = p.getInputStream();
            InputStreamReader inReader = new InputStreamReader(inStream);
            BufferedReader inBuffer = new BufferedReader(inReader);
            while ((s = inBuffer.readLine()) != null) {
                if (this.mRequestBugreport) {
                    logOutput.write(s);
                    logOutput.write("\n");
                    continue;
                }
                System.err.println(s);
            }
            int status = p.waitFor();
            System.err.println("// " + reportName + " status was " + status);
            if (logOutput != null) {
                ((Writer)logOutput).close();
            }
        }
        catch (Exception e) {
            System.err.println("// Exception from " + reportName + ":");
            System.err.println(e.toString());
        }
    }

    private void writeScriptLog(int count) {
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(new File(Environment.getLegacyExternalStorageDirectory(), "scriptlog.txt"), true));
            output.write("iteration: " + count + " time: " + MonkeyUtils.toCalendarTime(System.currentTimeMillis()) + "\n");
            ((Writer)output).close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    private void getBugreport(String reportName) {
        reportName = reportName + MonkeyUtils.toCalendarTime(System.currentTimeMillis());
        String bugreportName = reportName.replaceAll("[ ,:]", "_");
        this.commandLineReport(bugreportName + ".txt", "bugreport");
    }

    public static void main(String[] args) {
        android.os.Process.setArgV0("com.android.commands.monkey");
        int resultCode = new Monkey().run(args);
        System.exit(resultCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) {
        int crashedAtCycle;
        block51: {
            for (String s : args) {
                if (!"--wait-dbg".equals(s)) continue;
                Debug.waitForDebugger();
            }
            this.mVerbose = 0;
            this.mCount = 1000;
            this.mSeed = 0L;
            this.mThrottle = 0L;
            this.mArgs = args;
            this.mNextArg = 0;
            for (int i = 0; i < 11; ++i) {
                this.mFactors[i] = 1.0f;
            }
            if (!this.processOptions()) {
                return -1;
            }
            if (!this.loadPackageLists()) {
                return -1;
            }
            if (this.mMainCategories.size() == 0) {
                this.mMainCategories.add("android.intent.category.LAUNCHER");
                this.mMainCategories.add("android.intent.category.MONKEY");
            }
            if (this.mSeed == 0L) {
                this.mSeed = System.currentTimeMillis() + (long)System.identityHashCode(this);
            }
            if (this.mVerbose > 0) {
                System.out.println(":Monkey: seed=" + this.mSeed + " count=" + this.mCount);
                if (this.mValidPackages.size() > 0) {
                    Iterator<String> it = this.mValidPackages.iterator();
                    while (it.hasNext()) {
                        System.out.println(":AllowPackage: " + it.next());
                    }
                }
                if (this.mInvalidPackages.size() > 0) {
                    Iterator<String> it = this.mInvalidPackages.iterator();
                    while (it.hasNext()) {
                        System.out.println(":DisallowPackage: " + it.next());
                    }
                }
                if (this.mMainCategories.size() != 0) {
                    Iterator<String> it = this.mMainCategories.iterator();
                    while (it.hasNext()) {
                        System.out.println(":IncludeCategory: " + it.next());
                    }
                }
            }
            if (!this.checkInternalConfiguration()) {
                return -2;
            }
            if (!this.getSystemInterfaces()) {
                return -3;
            }
            if (!this.getMainApps()) {
                return -4;
            }
            this.mRandom = new Random(this.mSeed);
            if (this.mScriptFileNames != null && this.mScriptFileNames.size() == 1) {
                this.mEventSource = new MonkeySourceScript(this.mRandom, this.mScriptFileNames.get(0), this.mThrottle, this.mRandomizeThrottle, this.mProfileWaitTime, this.mDeviceSleepTime);
                this.mEventSource.setVerbose(this.mVerbose);
                this.mCountEvents = false;
            } else if (this.mScriptFileNames != null && this.mScriptFileNames.size() > 1) {
                if (this.mSetupFileName != null) {
                    this.mEventSource = new MonkeySourceRandomScript(this.mSetupFileName, this.mScriptFileNames, this.mThrottle, this.mRandomizeThrottle, this.mRandom, this.mProfileWaitTime, this.mDeviceSleepTime, this.mRandomizeScript);
                    ++this.mCount;
                } else {
                    this.mEventSource = new MonkeySourceRandomScript(this.mScriptFileNames, this.mThrottle, this.mRandomizeThrottle, this.mRandom, this.mProfileWaitTime, this.mDeviceSleepTime, this.mRandomizeScript);
                }
                this.mEventSource.setVerbose(this.mVerbose);
                this.mCountEvents = false;
            } else if (this.mServerPort != -1) {
                try {
                    this.mEventSource = new MonkeySourceNetwork(this.mServerPort);
                }
                catch (IOException e) {
                    System.out.println("Error binding to network socket.");
                    return -5;
                }
                this.mCount = Integer.MAX_VALUE;
            } else {
                if (this.mVerbose >= 2) {
                    System.out.println("// Seeded: " + this.mSeed);
                }
                this.mEventSource = new MonkeySourceRandom(this.mRandom, this.mMainApps, this.mThrottle, this.mRandomizeThrottle);
                this.mEventSource.setVerbose(this.mVerbose);
                for (int i = 0; i < 11; ++i) {
                    if (!(this.mFactors[i] <= 0.0f)) continue;
                    ((MonkeySourceRandom)this.mEventSource).setFactors(i, this.mFactors[i]);
                }
                ((MonkeySourceRandom)this.mEventSource).generateActivity();
            }
            if (!this.mEventSource.validate()) {
                return -5;
            }
            if (this.mGenerateHprof) {
                this.signalPersistentProcesses();
            }
            this.mNetworkMonitor.start();
            crashedAtCycle = 0;
            try {
                crashedAtCycle = this.runMonkeyCycles();
            }
            finally {
                new MonkeyRotationEvent(0, false).injectEvent(this.mWm, this.mAm, this.mVerbose);
            }
            this.mNetworkMonitor.stop();
            Monkey len$ = this;
            synchronized (len$) {
                if (this.mRequestAnrTraces) {
                    this.reportAnrTraces();
                    this.mRequestAnrTraces = false;
                }
                if (this.mRequestAnrBugreport) {
                    System.out.println("Print the anr report");
                    this.getBugreport("anr_" + this.mReportProcessName + "_");
                    this.mRequestAnrBugreport = false;
                }
                if (this.mRequestWatchdogBugreport) {
                    System.out.println("Print the watchdog report");
                    this.getBugreport("anr_watchdog_");
                    this.mRequestWatchdogBugreport = false;
                }
                if (this.mRequestAppCrashBugreport) {
                    this.getBugreport("app_crash" + this.mReportProcessName + "_");
                    this.mRequestAppCrashBugreport = false;
                }
                if (this.mRequestDumpsysMemInfo) {
                    this.reportDumpsysMemInfo();
                    this.mRequestDumpsysMemInfo = false;
                }
                if (this.mRequestPeriodicBugreport) {
                    this.getBugreport("Bugreport_");
                    this.mRequestPeriodicBugreport = false;
                }
                if (this.mWatchdogWaiting) {
                    this.mWatchdogWaiting = false;
                    this.notifyAll();
                }
            }
            if (this.mGenerateHprof) {
                this.signalPersistentProcesses();
                if (this.mVerbose > 0) {
                    System.out.println("// Generated profiling reports in /data/misc");
                }
            }
            try {
                this.mAm.setActivityController(null);
                this.mNetworkMonitor.unregister(this.mAm);
            }
            catch (RemoteException e) {
                if (crashedAtCycle < this.mCount) break block51;
                crashedAtCycle = this.mCount - 1;
            }
        }
        if (this.mVerbose > 0) {
            System.out.print(":Dropped: keys=");
            System.out.print(this.mDroppedKeyEvents);
            System.out.print(" pointers=");
            System.out.print(this.mDroppedPointerEvents);
            System.out.print(" trackballs=");
            System.out.print(this.mDroppedTrackballEvents);
            System.out.print(" flips=");
            System.out.print(this.mDroppedFlipEvents);
            System.out.print(" rotations=");
            System.out.println(this.mDroppedRotationEvents);
        }
        this.mNetworkMonitor.dump();
        if (crashedAtCycle < this.mCount - 1) {
            System.err.println("** System appears to have crashed at event " + crashedAtCycle + " of " + this.mCount + " using seed " + this.mSeed);
            return crashedAtCycle;
        }
        if (this.mVerbose > 0) {
            System.out.println("// Monkey finished");
        }
        return 0;
    }

    private boolean processOptions() {
        if (this.mArgs.length < 1) {
            this.showUsage();
            return false;
        }
        try {
            String opt;
            while ((opt = this.nextOption()) != null) {
                int i;
                if (opt.equals("-s")) {
                    this.mSeed = this.nextOptionLong("Seed");
                    continue;
                }
                if (opt.equals("-p")) {
                    this.mValidPackages.add(this.nextOptionData());
                    continue;
                }
                if (opt.equals("-c")) {
                    this.mMainCategories.add(this.nextOptionData());
                    continue;
                }
                if (opt.equals("-v")) {
                    ++this.mVerbose;
                    continue;
                }
                if (opt.equals("--ignore-crashes")) {
                    this.mIgnoreCrashes = true;
                    continue;
                }
                if (opt.equals("--ignore-timeouts")) {
                    this.mIgnoreTimeouts = true;
                    continue;
                }
                if (opt.equals("--ignore-security-exceptions")) {
                    this.mIgnoreSecurityExceptions = true;
                    continue;
                }
                if (opt.equals("--monitor-native-crashes")) {
                    this.mMonitorNativeCrashes = true;
                    continue;
                }
                if (opt.equals("--ignore-native-crashes")) {
                    this.mIgnoreNativeCrashes = true;
                    continue;
                }
                if (opt.equals("--kill-process-after-error")) {
                    this.mKillProcessAfterError = true;
                    continue;
                }
                if (opt.equals("--hprof")) {
                    this.mGenerateHprof = true;
                    continue;
                }
                if (opt.equals("--pct-touch")) {
                    i = 0;
                    this.mFactors[i] = -this.nextOptionLong("touch events percentage");
                    continue;
                }
                if (opt.equals("--pct-motion")) {
                    i = 1;
                    this.mFactors[i] = -this.nextOptionLong("motion events percentage");
                    continue;
                }
                if (opt.equals("--pct-trackball")) {
                    i = 3;
                    this.mFactors[i] = -this.nextOptionLong("trackball events percentage");
                    continue;
                }
                if (opt.equals("--pct-rotation")) {
                    i = 4;
                    this.mFactors[i] = -this.nextOptionLong("screen rotation events percentage");
                    continue;
                }
                if (opt.equals("--pct-syskeys")) {
                    i = 7;
                    this.mFactors[i] = -this.nextOptionLong("system (key) operations percentage");
                    continue;
                }
                if (opt.equals("--pct-nav")) {
                    i = 5;
                    this.mFactors[i] = -this.nextOptionLong("nav events percentage");
                    continue;
                }
                if (opt.equals("--pct-majornav")) {
                    i = 6;
                    this.mFactors[i] = -this.nextOptionLong("major nav events percentage");
                    continue;
                }
                if (opt.equals("--pct-appswitch")) {
                    i = 8;
                    this.mFactors[i] = -this.nextOptionLong("app switch events percentage");
                    continue;
                }
                if (opt.equals("--pct-flip")) {
                    i = 9;
                    this.mFactors[i] = -this.nextOptionLong("keyboard flip percentage");
                    continue;
                }
                if (opt.equals("--pct-anyevent")) {
                    i = 10;
                    this.mFactors[i] = -this.nextOptionLong("any events percentage");
                    continue;
                }
                if (opt.equals("--pct-pinchzoom")) {
                    i = 2;
                    this.mFactors[i] = -this.nextOptionLong("pinch zoom events percentage");
                    continue;
                }
                if (opt.equals("--pkg-blacklist-file")) {
                    this.mPkgBlacklistFile = this.nextOptionData();
                    continue;
                }
                if (opt.equals("--pkg-whitelist-file")) {
                    this.mPkgWhitelistFile = this.nextOptionData();
                    continue;
                }
                if (opt.equals("--throttle")) {
                    this.mThrottle = this.nextOptionLong("delay (in milliseconds) to wait between events");
                    continue;
                }
                if (opt.equals("--randomize-throttle")) {
                    this.mRandomizeThrottle = true;
                    continue;
                }
                if (opt.equals("--wait-dbg")) continue;
                if (opt.equals("--dbg-no-events")) {
                    this.mSendNoEvents = true;
                    continue;
                }
                if (opt.equals("--port")) {
                    this.mServerPort = (int)this.nextOptionLong("Server port to listen on for commands");
                    continue;
                }
                if (opt.equals("--setup")) {
                    this.mSetupFileName = this.nextOptionData();
                    continue;
                }
                if (opt.equals("-f")) {
                    this.mScriptFileNames.add(this.nextOptionData());
                    continue;
                }
                if (opt.equals("--profile-wait")) {
                    this.mProfileWaitTime = this.nextOptionLong("Profile delay (in milliseconds) to wait between user action");
                    continue;
                }
                if (opt.equals("--device-sleep-time")) {
                    this.mDeviceSleepTime = this.nextOptionLong("Device sleep time(in milliseconds)");
                    continue;
                }
                if (opt.equals("--randomize-script")) {
                    this.mRandomizeScript = true;
                    continue;
                }
                if (opt.equals("--script-log")) {
                    this.mScriptLog = true;
                    continue;
                }
                if (opt.equals("--bugreport")) {
                    this.mRequestBugreport = true;
                    continue;
                }
                if (opt.equals("--periodic-bugreport")) {
                    this.mGetPeriodicBugreport = true;
                    this.mBugreportFrequency = this.nextOptionLong("Number of iterations");
                    continue;
                }
                if (opt.equals("-h")) {
                    this.showUsage();
                    return false;
                }
                System.err.println("** Error: Unknown option: " + opt);
                this.showUsage();
                return false;
            }
        }
        catch (RuntimeException ex) {
            System.err.println("** Error: " + ex.toString());
            this.showUsage();
            return false;
        }
        if (this.mServerPort == -1) {
            String countStr = this.nextArg();
            if (countStr == null) {
                System.err.println("** Error: Count not specified");
                this.showUsage();
                return false;
            }
            try {
                this.mCount = Integer.parseInt(countStr);
            }
            catch (NumberFormatException e) {
                System.err.println("** Error: Count is not a number");
                this.showUsage();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadPackageListFromFile(String fileName, HashSet<String> list) {
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new FileReader(fileName));
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.startsWith("#")) continue;
                list.add(s);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                }
            }
        }
        return true;
    }

    private boolean loadPackageLists() {
        if ((this.mPkgWhitelistFile != null || this.mValidPackages.size() > 0) && this.mPkgBlacklistFile != null) {
            System.err.println("** Error: you can not specify a package blacklist together with a whitelist or individual packages (via -p).");
            return false;
        }
        if (this.mPkgWhitelistFile != null && !Monkey.loadPackageListFromFile(this.mPkgWhitelistFile, this.mValidPackages)) {
            return false;
        }
        return this.mPkgBlacklistFile == null || Monkey.loadPackageListFromFile(this.mPkgBlacklistFile, this.mInvalidPackages);
    }

    private boolean checkInternalConfiguration() {
        return true;
    }

    private boolean getSystemInterfaces() {
        this.mAm = ActivityManagerNative.getDefault();
        if (this.mAm == null) {
            System.err.println("** Error: Unable to connect to activity manager; is the system running?");
            return false;
        }
        this.mWm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        if (this.mWm == null) {
            System.err.println("** Error: Unable to connect to window manager; is the system running?");
            return false;
        }
        this.mPm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        if (this.mPm == null) {
            System.err.println("** Error: Unable to connect to package manager; is the system running?");
            return false;
        }
        try {
            this.mAm.setActivityController(new ActivityController());
            this.mNetworkMonitor.register(this.mAm);
        }
        catch (RemoteException e) {
            System.err.println("** Failed talking with activity manager!");
            return false;
        }
        return true;
    }

    private boolean getMainApps() {
        try {
            int N = this.mMainCategories.size();
            for (int i = 0; i < N; ++i) {
                List<ResolveInfo> mainApps;
                Intent intent = new Intent("android.intent.action.MAIN");
                String category = this.mMainCategories.get(i);
                if (category.length() > 0) {
                    intent.addCategory(category);
                }
                if ((mainApps = this.mPm.queryIntentActivities(intent, null, 0, UserHandle.myUserId())) == null || mainApps.size() == 0) {
                    System.err.println("// Warning: no activities found for category " + category);
                    continue;
                }
                if (this.mVerbose >= 2) {
                    System.out.println("// Selecting main activities from category " + category);
                }
                int NA = mainApps.size();
                for (int a = 0; a < NA; ++a) {
                    ResolveInfo r = mainApps.get(a);
                    String packageName = r.activityInfo.applicationInfo.packageName;
                    if (this.checkEnteringPackage(packageName)) {
                        if (this.mVerbose >= 2) {
                            System.out.println("//   + Using main activity " + r.activityInfo.name + " (from package " + packageName + ")");
                        }
                        this.mMainApps.add(new ComponentName(packageName, r.activityInfo.name));
                        continue;
                    }
                    if (this.mVerbose < 3) continue;
                    System.out.println("//   - NOT USING main activity " + r.activityInfo.name + " (from package " + packageName + ")");
                }
            }
        }
        catch (RemoteException e) {
            System.err.println("** Failed talking with package manager!");
            return false;
        }
        if (this.mMainApps.size() == 0) {
            System.out.println("** No activities found to run, monkey aborted.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runMonkeyCycles() {
        int eventCounter = 0;
        int cycleCounter = 0;
        boolean shouldReportAnrTraces = false;
        boolean shouldReportDumpsysMemInfo = false;
        boolean shouldAbort = false;
        boolean systemCrashed = false;
        while (!systemCrashed && cycleCounter < this.mCount) {
            MonkeyEvent ev;
            Monkey monkey = this;
            synchronized (monkey) {
                if (this.mRequestProcRank) {
                    this.reportProcRank();
                    this.mRequestProcRank = false;
                }
                if (this.mRequestAnrTraces) {
                    this.mRequestAnrTraces = false;
                    shouldReportAnrTraces = true;
                }
                if (this.mRequestAnrBugreport) {
                    this.getBugreport("anr_" + this.mReportProcessName + "_");
                    this.mRequestAnrBugreport = false;
                }
                if (this.mRequestWatchdogBugreport) {
                    System.out.println("Print the watchdog report");
                    this.getBugreport("anr_watchdog_");
                    this.mRequestWatchdogBugreport = false;
                }
                if (this.mRequestAppCrashBugreport) {
                    this.getBugreport("app_crash" + this.mReportProcessName + "_");
                    this.mRequestAppCrashBugreport = false;
                }
                if (this.mRequestPeriodicBugreport) {
                    this.getBugreport("Bugreport_");
                    this.mRequestPeriodicBugreport = false;
                }
                if (this.mRequestDumpsysMemInfo) {
                    this.mRequestDumpsysMemInfo = false;
                    shouldReportDumpsysMemInfo = true;
                }
                if (this.mMonitorNativeCrashes && this.checkNativeCrashes() && eventCounter > 0) {
                    System.out.println("** New native crash detected.");
                    if (this.mRequestBugreport) {
                        this.getBugreport("native_crash_");
                    }
                    boolean bl = this.mAbort = this.mAbort || !this.mIgnoreNativeCrashes || this.mKillProcessAfterError;
                }
                if (this.mAbort) {
                    shouldAbort = true;
                }
                if (this.mWatchdogWaiting) {
                    this.mWatchdogWaiting = false;
                    this.notifyAll();
                }
            }
            if (shouldReportAnrTraces) {
                shouldReportAnrTraces = false;
                this.reportAnrTraces();
            }
            if (shouldReportDumpsysMemInfo) {
                shouldReportDumpsysMemInfo = false;
                this.reportDumpsysMemInfo();
            }
            if (shouldAbort) {
                shouldAbort = false;
                System.out.println("** Monkey aborted due to error.");
                System.out.println("Events injected: " + eventCounter);
                return eventCounter;
            }
            if (this.mSendNoEvents) {
                ++eventCounter;
                ++cycleCounter;
                continue;
            }
            if (this.mVerbose > 0 && eventCounter % 100 == 0 && eventCounter != 0) {
                String calendarTime = MonkeyUtils.toCalendarTime(System.currentTimeMillis());
                long systemUpTime = SystemClock.elapsedRealtime();
                System.out.println("    //[calendar_time:" + calendarTime + " system_uptime:" + systemUpTime + "]");
                System.out.println("    // Sending event #" + eventCounter);
            }
            if ((ev = this.mEventSource.getNextEvent()) != null) {
                int injectCode = ev.injectEvent(this.mWm, this.mAm, this.mVerbose);
                if (injectCode == 0) {
                    if (ev instanceof MonkeyKeyEvent) {
                        ++this.mDroppedKeyEvents;
                    } else if (ev instanceof MonkeyMotionEvent) {
                        ++this.mDroppedPointerEvents;
                    } else if (ev instanceof MonkeyFlipEvent) {
                        ++this.mDroppedFlipEvents;
                    } else if (ev instanceof MonkeyRotationEvent) {
                        ++this.mDroppedRotationEvents;
                    }
                } else if (injectCode == -1) {
                    systemCrashed = true;
                    System.err.println("** Error: RemoteException while injecting event.");
                } else if (injectCode == -2) {
                    boolean bl = systemCrashed = !this.mIgnoreSecurityExceptions;
                    if (systemCrashed) {
                        System.err.println("** Error: SecurityException while injecting event.");
                    }
                }
                if (ev instanceof MonkeyThrottleEvent) continue;
                ++eventCounter;
                if (!this.mCountEvents) continue;
                ++cycleCounter;
                continue;
            }
            if (this.mCountEvents) break;
            this.writeScriptLog(++cycleCounter);
            if (!this.mGetPeriodicBugreport || (long)cycleCounter % this.mBugreportFrequency != 0L) continue;
            this.mRequestPeriodicBugreport = true;
        }
        System.out.println("Events injected: " + eventCounter);
        return eventCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalPersistentProcesses() {
        try {
            this.mAm.signalPersistentProcesses(10);
            Monkey monkey = this;
            synchronized (monkey) {
                this.wait(2000L);
            }
        }
        catch (RemoteException e) {
            System.err.println("** Failed talking with activity manager!");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean checkNativeCrashes() {
        String[] tombstones = TOMBSTONES_PATH.list();
        if (tombstones == null || tombstones.length == 0) {
            this.mTombstones = null;
            return false;
        }
        HashSet<String> newStones = new HashSet<String>();
        for (String x : tombstones) {
            newStones.add(x);
        }
        boolean result = this.mTombstones == null || !this.mTombstones.containsAll(newStones);
        this.mTombstones = newStones;
        return result;
    }

    private String nextOption() {
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        if (!arg.startsWith("-")) {
            return null;
        }
        ++this.mNextArg;
        if (arg.equals("--")) {
            return null;
        }
        if (arg.length() > 1 && arg.charAt(1) != '-') {
            if (arg.length() > 2) {
                this.mCurArgData = arg.substring(2);
                return arg.substring(0, 2);
            }
            this.mCurArgData = null;
            return arg;
        }
        this.mCurArgData = null;
        return arg;
    }

    private String nextOptionData() {
        if (this.mCurArgData != null) {
            return this.mCurArgData;
        }
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String data = this.mArgs[this.mNextArg];
        ++this.mNextArg;
        return data;
    }

    private long nextOptionLong(String opt) {
        long result;
        try {
            result = Long.parseLong(this.nextOptionData());
        }
        catch (NumberFormatException e) {
            System.err.println("** Error: " + opt + " is not a number");
            throw e;
        }
        return result;
    }

    private String nextArg() {
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        ++this.mNextArg;
        return arg;
    }

    private void showUsage() {
        StringBuffer usage = new StringBuffer();
        usage.append("usage: monkey [-p ALLOWED_PACKAGE [-p ALLOWED_PACKAGE] ...]\n");
        usage.append("              [-c MAIN_CATEGORY [-c MAIN_CATEGORY] ...]\n");
        usage.append("              [--ignore-crashes] [--ignore-timeouts]\n");
        usage.append("              [--ignore-security-exceptions]\n");
        usage.append("              [--monitor-native-crashes] [--ignore-native-crashes]\n");
        usage.append("              [--kill-process-after-error] [--hprof]\n");
        usage.append("              [--pct-touch PERCENT] [--pct-motion PERCENT]\n");
        usage.append("              [--pct-trackball PERCENT] [--pct-syskeys PERCENT]\n");
        usage.append("              [--pct-nav PERCENT] [--pct-majornav PERCENT]\n");
        usage.append("              [--pct-appswitch PERCENT] [--pct-flip PERCENT]\n");
        usage.append("              [--pct-anyevent PERCENT] [--pct-pinchzoom PERCENT]\n");
        usage.append("              [--pkg-blacklist-file PACKAGE_BLACKLIST_FILE]\n");
        usage.append("              [--pkg-whitelist-file PACKAGE_WHITELIST_FILE]\n");
        usage.append("              [--wait-dbg] [--dbg-no-events]\n");
        usage.append("              [--setup scriptfile] [-f scriptfile [-f scriptfile] ...]\n");
        usage.append("              [--port port]\n");
        usage.append("              [-s SEED] [-v [-v] ...]\n");
        usage.append("              [--throttle MILLISEC] [--randomize-throttle]\n");
        usage.append("              [--profile-wait MILLISEC]\n");
        usage.append("              [--device-sleep-time MILLISEC]\n");
        usage.append("              [--randomize-script]\n");
        usage.append("              [--script-log]\n");
        usage.append("              [--bugreport]\n");
        usage.append("              [--periodic-bugreport]\n");
        usage.append("              COUNT\n");
        System.err.println(usage.toString());
    }

    private class ActivityController
    extends IActivityController.Stub {
        private ActivityController() {
        }

        public boolean activityStarting(Intent intent, String pkg) {
            boolean allow;
            boolean bl = Monkey.this.checkEnteringPackage(pkg) ? true : (allow = false);
            if (Monkey.this.mVerbose > 0) {
                StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskWrites();
                System.out.println("    // " + (allow ? "Allowing" : "Rejecting") + " start of " + intent + " in package " + pkg);
                StrictMode.setThreadPolicy(savedPolicy);
            }
            currentPackage = pkg;
            currentIntent = intent;
            return allow;
        }

        public boolean activityResuming(String pkg) {
            boolean allow;
            StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskWrites();
            System.out.println("    // activityResuming(" + pkg + ")");
            boolean bl = Monkey.this.checkEnteringPackage(pkg) ? true : (allow = false);
            if (!allow && Monkey.this.mVerbose > 0) {
                System.out.println("    // " + (allow ? "Allowing" : "Rejecting") + " resume of package " + pkg);
            }
            currentPackage = pkg;
            StrictMode.setThreadPolicy(savedPolicy);
            return allow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean appCrashed(String processName, int pid, String shortMsg, String longMsg, long timeMillis, String stackTrace) {
            StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskWrites();
            System.err.println("// CRASH: " + processName + " (pid " + pid + ")");
            System.err.println("// Short Msg: " + shortMsg);
            System.err.println("// Long Msg: " + longMsg);
            System.err.println("// Build Label: " + Build.FINGERPRINT);
            System.err.println("// Build Changelist: " + Build.VERSION.INCREMENTAL);
            System.err.println("// Build Time: " + Build.TIME);
            System.err.println("// " + stackTrace.replace("\n", "\n// "));
            StrictMode.setThreadPolicy(savedPolicy);
            if (!Monkey.this.mIgnoreCrashes || Monkey.this.mRequestBugreport) {
                Monkey monkey = Monkey.this;
                synchronized (monkey) {
                    if (!Monkey.this.mIgnoreCrashes) {
                        Monkey.this.mAbort = true;
                    }
                    if (Monkey.this.mRequestBugreport) {
                        Monkey.this.mRequestAppCrashBugreport = true;
                        Monkey.this.mReportProcessName = processName;
                    }
                }
                return !Monkey.this.mKillProcessAfterError;
            }
            return false;
        }

        public int appEarlyNotResponding(String processName, int pid, String annotation) {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int appNotResponding(String processName, int pid, String processStats) {
            StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskWrites();
            System.err.println("// NOT RESPONDING: " + processName + " (pid " + pid + ")");
            System.err.println(processStats);
            StrictMode.setThreadPolicy(savedPolicy);
            Monkey monkey = Monkey.this;
            synchronized (monkey) {
                Monkey.this.mRequestAnrTraces = true;
                Monkey.this.mRequestDumpsysMemInfo = true;
                Monkey.this.mRequestProcRank = true;
                if (Monkey.this.mRequestBugreport) {
                    Monkey.this.mRequestAnrBugreport = true;
                    Monkey.this.mReportProcessName = processName;
                }
            }
            if (!Monkey.this.mIgnoreTimeouts) {
                monkey = Monkey.this;
                synchronized (monkey) {
                    Monkey.this.mAbort = true;
                }
            }
            return Monkey.this.mKillProcessAfterError ? -1 : 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int systemNotResponding(String message) {
            StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskWrites();
            System.err.println("// WATCHDOG: " + message);
            StrictMode.setThreadPolicy(savedPolicy);
            Monkey monkey = Monkey.this;
            synchronized (monkey) {
                if (!Monkey.this.mIgnoreCrashes) {
                    Monkey.this.mAbort = true;
                }
                if (Monkey.this.mRequestBugreport) {
                    Monkey.this.mRequestWatchdogBugreport = true;
                }
                Monkey.this.mWatchdogWaiting = true;
            }
            monkey = Monkey.this;
            synchronized (monkey) {
                while (Monkey.this.mWatchdogWaiting) {
                    try {
                        Monkey.this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            return Monkey.this.mKillProcessAfterError ? -1 : 1;
        }
    }
}

