/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeyThrottleEvent;
import java.util.LinkedList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeyEventQueue
extends LinkedList<MonkeyEvent> {
    private Random mRandom;
    private long mThrottle;
    private boolean mRandomizeThrottle;

    public MonkeyEventQueue(Random random, long throttle, boolean randomizeThrottle) {
        this.mRandom = random;
        this.mThrottle = throttle;
        this.mRandomizeThrottle = randomizeThrottle;
    }

    @Override
    public void addLast(MonkeyEvent e) {
        super.add(e);
        if (e.isThrottlable()) {
            long throttle = this.mThrottle;
            if (this.mRandomizeThrottle && this.mThrottle > 0L) {
                throttle = this.mRandom.nextLong();
                if (throttle < 0L) {
                    throttle = -throttle;
                }
                throttle %= this.mThrottle;
                ++throttle;
            }
            super.add(new MonkeyThrottleEvent(throttle));
        }
    }
}

