/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.IActivityManager;
import android.os.Environment;
import android.util.Log;
import android.view.IWindowManager;
import com.android.commands.monkey.MonkeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonkeyGetAppFrameRateEvent
extends MonkeyEvent {
    private String GET_APP_FRAMERATE_TMPL = "dumpsys gfxinfo %s";
    private String mStatus;
    private static long sStartTime;
    private static long sEndTime;
    private static float sDuration;
    private static String sActivityName;
    private static String sTestCaseName;
    private static int sStartFrameNo;
    private static int sEndFrameNo;
    private static final String TAG = "MonkeyGetAppFrameRateEvent";
    private static final String LOG_FILE;
    private static final Pattern NO_OF_FRAMES_PATTERN;

    public MonkeyGetAppFrameRateEvent(String status, String activityName, String testCaseName) {
        super(4);
        this.mStatus = status;
        sActivityName = activityName;
        sTestCaseName = testCaseName;
    }

    public MonkeyGetAppFrameRateEvent(String status, String activityName) {
        super(4);
        this.mStatus = status;
        sActivityName = activityName;
    }

    public MonkeyGetAppFrameRateEvent(String status) {
        super(4);
        this.mStatus = status;
    }

    private float getAverageFrameRate(int totalNumberOfFrame, float duration) {
        float avgFrameRate = 0.0f;
        if (duration > 0.0f) {
            avgFrameRate = (float)totalNumberOfFrame / duration;
        }
        return avgFrameRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAverageFrameRate() {
        OutputStreamWriter writer = null;
        int totalNumberOfFrame = 0;
        try {
            Log.w(TAG, "file: " + LOG_FILE);
            writer = new FileWriter(LOG_FILE, true);
            totalNumberOfFrame = sEndFrameNo - sStartFrameNo;
            float avgFrameRate = this.getAverageFrameRate(totalNumberOfFrame, sDuration);
            writer.write(String.format("%s:%.2f\n", sTestCaseName, Float.valueOf(avgFrameRate)));
        }
        catch (IOException e) {
            Log.w(TAG, "Can't write sdcard log file", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException " + e.toString());
            }
        }
    }

    private String getNumberOfFrames(BufferedReader reader) throws IOException {
        String noOfFrames = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            Matcher m = NO_OF_FRAMES_PATTERN.matcher(line);
            if (!m.matches()) continue;
            noOfFrames = m.group(1);
            break;
        }
        return noOfFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectEvent(IWindowManager iwm, IActivityManager iam, int verbose) {
        Process p = null;
        BufferedReader result = null;
        String cmd = String.format(this.GET_APP_FRAMERATE_TMPL, sActivityName);
        try {
            String output;
            p = Runtime.getRuntime().exec(cmd);
            int status = p.waitFor();
            if (status != 0) {
                System.err.println(String.format("// Shell command %s status was %s", cmd, status));
            }
            if ((output = this.getNumberOfFrames(result = new BufferedReader(new InputStreamReader(p.getInputStream())))) != null) {
                if ("start".equals(this.mStatus)) {
                    sStartFrameNo = Integer.parseInt(output);
                    sStartTime = System.currentTimeMillis();
                } else if ("end".equals(this.mStatus)) {
                    sEndFrameNo = Integer.parseInt(output);
                    sEndTime = System.currentTimeMillis();
                    long diff = sEndTime - sStartTime;
                    sDuration = (float)((double)diff / 1000.0);
                    this.writeAverageFrameRate();
                }
            }
        }
        catch (Exception e) {
            System.err.println("// Exception from " + cmd + ":");
            System.err.println(e.toString());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (p != null) {
                    p.destroy();
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
        return 1;
    }

    static {
        sActivityName = null;
        sTestCaseName = null;
        LOG_FILE = new File(Environment.getExternalStorageDirectory(), "avgAppFrameRateOut.txt").getAbsolutePath();
        NO_OF_FRAMES_PATTERN = Pattern.compile(".* ([0-9]*) frames rendered");
    }
}

