/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.IActivityManager;
import android.util.Log;
import android.view.IWindowManager;
import com.android.commands.monkey.MonkeyEvent;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonkeyGetFrameRateEvent
extends MonkeyEvent {
    private String GET_FRAMERATE_CMD = "service call SurfaceFlinger 1013";
    private String mStatus;
    private static long mStartTime;
    private static long mEndTime;
    private static float mDuration;
    private static String mTestCaseName;
    private static int mStartFrameNo;
    private static int mEndFrameNo;
    private static final String TAG = "MonkeyGetFrameRateEvent";
    private static final String LOG_FILE = "/sdcard/avgFrameRateOut.txt";
    private static final Pattern NO_OF_FRAMES_PATTERN;

    public MonkeyGetFrameRateEvent(String status, String testCaseName) {
        super(4);
        this.mStatus = status;
        mTestCaseName = testCaseName;
    }

    public MonkeyGetFrameRateEvent(String status) {
        super(4);
        this.mStatus = status;
    }

    private float getAverageFrameRate(int totalNumberOfFrame, float duration) {
        float avgFrameRate = 0.0f;
        if (duration > 0.0f) {
            avgFrameRate = (float)totalNumberOfFrame / duration;
        }
        return avgFrameRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAverageFrameRate() {
        FileWriter writer = null;
        int totalNumberOfFrame = 0;
        try {
            writer = new FileWriter(LOG_FILE, true);
            totalNumberOfFrame = mEndFrameNo - mStartFrameNo;
            float avgFrameRate = this.getAverageFrameRate(totalNumberOfFrame, mDuration);
            writer.write(String.format("%s:%.2f\n", mTestCaseName, Float.valueOf(avgFrameRate)));
            writer.close();
        }
        catch (IOException e) {
            Log.w(TAG, "Can't write sdcard log file", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException " + e.toString());
            }
        }
    }

    private String getNumberOfFrames(String input) {
        String noOfFrames = null;
        Matcher m = NO_OF_FRAMES_PATTERN.matcher(input);
        if (m.matches()) {
            noOfFrames = m.group(1);
        }
        return noOfFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectEvent(IWindowManager iwm, IActivityManager iam, int verbose) {
        Process p = null;
        BufferedReader result = null;
        try {
            String output;
            p = Runtime.getRuntime().exec(this.GET_FRAMERATE_CMD);
            int status = p.waitFor();
            if (status != 0) {
                System.err.println(String.format("// Shell command %s status was %s", this.GET_FRAMERATE_CMD, status));
            }
            if ((output = (result = new BufferedReader(new InputStreamReader(p.getInputStream()))).readLine()) != null) {
                if (this.mStatus == "start") {
                    mStartFrameNo = Integer.parseInt(this.getNumberOfFrames(output), 16);
                    mStartTime = System.currentTimeMillis();
                } else if (this.mStatus == "end") {
                    mEndFrameNo = Integer.parseInt(this.getNumberOfFrames(output), 16);
                    mEndTime = System.currentTimeMillis();
                    long diff = mEndTime - mStartTime;
                    mDuration = (float)((double)diff / 1000.0);
                    this.writeAverageFrameRate();
                }
            }
        }
        catch (Exception e) {
            System.err.println("// Exception from " + this.GET_FRAMERATE_CMD + ":");
            System.err.println(e.toString());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (p != null) {
                    p.destroy();
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
        return 1;
    }

    static {
        mTestCaseName = null;
        NO_OF_FRAMES_PATTERN = Pattern.compile(".*\\(([a-f[A-F][0-9]].*?)\\s.*\\)");
    }
}

