/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.IActivityManager;
import android.content.ComponentName;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.IWindowManager;
import com.android.commands.monkey.MonkeyEvent;

public class MonkeyInstrumentationEvent
extends MonkeyEvent {
    String mRunnerName;
    String mTestCaseName;

    public MonkeyInstrumentationEvent(String testCaseName, String runnerName) {
        super(4);
        this.mTestCaseName = testCaseName;
        this.mRunnerName = runnerName;
    }

    public int injectEvent(IWindowManager iwm, IActivityManager iam, int verbose) {
        ComponentName cn = ComponentName.unflattenFromString(this.mRunnerName);
        if (cn == null || this.mTestCaseName == null) {
            throw new IllegalArgumentException("Bad component name");
        }
        Bundle args = new Bundle();
        args.putString("class", this.mTestCaseName);
        try {
            iam.startInstrumentation(cn, null, 0, args, null, null, 0);
        }
        catch (RemoteException e) {
            System.err.println("** Failed talking with activity manager!");
            return -1;
        }
        return 1;
    }
}

