/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.IActivityManager;
import android.hardware.input.InputManager;
import android.os.SystemClock;
import android.view.IWindowManager;
import android.view.KeyEvent;
import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeySourceRandom;

public class MonkeyKeyEvent
extends MonkeyEvent {
    private int mDeviceId;
    private long mEventTime;
    private long mDownTime;
    private int mAction;
    private int mKeyCode;
    private int mScanCode;
    private int mMetaState;
    private int mRepeatCount;
    private KeyEvent mKeyEvent;

    public MonkeyKeyEvent(int action, int keyCode) {
        this(-1L, -1L, action, keyCode, 0, 0, -1, 0);
    }

    public MonkeyKeyEvent(long downTime, long eventTime, int action, int keyCode, int repeatCount, int metaState, int device, int scanCode) {
        super(0);
        this.mDownTime = downTime;
        this.mEventTime = eventTime;
        this.mAction = action;
        this.mKeyCode = keyCode;
        this.mRepeatCount = repeatCount;
        this.mMetaState = metaState;
        this.mDeviceId = device;
        this.mScanCode = scanCode;
    }

    public MonkeyKeyEvent(KeyEvent e) {
        super(0);
        this.mKeyEvent = e;
    }

    public int getKeyCode() {
        return this.mKeyEvent != null ? this.mKeyEvent.getKeyCode() : this.mKeyCode;
    }

    public int getAction() {
        return this.mKeyEvent != null ? this.mKeyEvent.getAction() : this.mAction;
    }

    public long getDownTime() {
        return this.mKeyEvent != null ? this.mKeyEvent.getDownTime() : this.mDownTime;
    }

    public long getEventTime() {
        return this.mKeyEvent != null ? this.mKeyEvent.getEventTime() : this.mEventTime;
    }

    public void setDownTime(long downTime) {
        if (this.mKeyEvent != null) {
            throw new IllegalStateException("Cannot modify down time of this key event.");
        }
        this.mDownTime = downTime;
    }

    public void setEventTime(long eventTime) {
        if (this.mKeyEvent != null) {
            throw new IllegalStateException("Cannot modify event time of this key event.");
        }
        this.mEventTime = eventTime;
    }

    public boolean isThrottlable() {
        return this.getAction() == 1;
    }

    public int injectEvent(IWindowManager iwm, IActivityManager iam, int verbose) {
        KeyEvent keyEvent;
        if (verbose > 1) {
            String note = this.mAction == 1 ? "ACTION_UP" : "ACTION_DOWN";
            try {
                System.out.println(":Sending Key (" + note + "): " + this.mKeyCode + "    // " + MonkeySourceRandom.getKeyName(this.mKeyCode));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println(":Sending Key (" + note + "): " + this.mKeyCode + "    // Unknown key event");
            }
        }
        if ((keyEvent = this.mKeyEvent) == null) {
            long downTime;
            long eventTime = this.mEventTime;
            if (eventTime <= 0L) {
                eventTime = SystemClock.uptimeMillis();
            }
            if ((downTime = this.mDownTime) <= 0L) {
                downTime = eventTime;
            }
            keyEvent = new KeyEvent(downTime, eventTime, this.mAction, this.mKeyCode, this.mRepeatCount, this.mMetaState, this.mDeviceId, this.mScanCode, 8, 257);
        }
        if (!InputManager.getInstance().injectInputEvent(keyEvent, 1)) {
            return 0;
        }
        return 1;
    }
}

