/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.IActivityManager;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;

public class MonkeyNetworkMonitor
extends IIntentReceiver.Stub {
    private static final boolean LDEBUG = false;
    private final IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    private long mCollectionStartTime;
    private long mEventTime;
    private int mLastNetworkType = -1;
    private long mWifiElapsedTime = 0L;
    private long mMobileElapsedTime = 0L;
    private long mElapsedTime = 0L;

    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
        NetworkInfo ni = (NetworkInfo)intent.getParcelableExtra("networkInfo");
        this.updateNetworkStats();
        if (NetworkInfo.State.CONNECTED == ni.getState()) {
            this.mLastNetworkType = ni.getType();
        } else if (NetworkInfo.State.DISCONNECTED == ni.getState()) {
            this.mLastNetworkType = -1;
        }
        this.mEventTime = SystemClock.elapsedRealtime();
    }

    private void updateNetworkStats() {
        long timeNow = SystemClock.elapsedRealtime();
        long delta = timeNow - this.mEventTime;
        switch (this.mLastNetworkType) {
            case 0: {
                this.mMobileElapsedTime += delta;
                break;
            }
            case 1: {
                this.mWifiElapsedTime += delta;
                break;
            }
        }
        this.mElapsedTime = timeNow - this.mCollectionStartTime;
    }

    public void start() {
        this.mWifiElapsedTime = 0L;
        this.mMobileElapsedTime = 0L;
        this.mElapsedTime = 0L;
        this.mEventTime = this.mCollectionStartTime = SystemClock.elapsedRealtime();
    }

    public void register(IActivityManager am) throws RemoteException {
        am.registerReceiver(null, null, this, this.filter, null, -1);
    }

    public void unregister(IActivityManager am) throws RemoteException {
        am.unregisterReceiver(this);
    }

    public void stop() {
        this.updateNetworkStats();
    }

    public void dump() {
        System.out.println("## Network stats: elapsed time=" + this.mElapsedTime + "ms (" + this.mMobileElapsedTime + "ms mobile, " + this.mWifiElapsedTime + "ms wifi, " + (this.mElapsedTime - this.mMobileElapsedTime - this.mWifiElapsedTime) + "ms not connected)");
    }
}

