/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.IActivityManager;
import android.content.ContentValues;
import android.os.Build;
import android.util.Log;
import android.view.IWindowManager;
import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeyUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class MonkeyPowerEvent
extends MonkeyEvent {
    private static final String TAG = "PowerTester";
    private static final String LOG_FILE = "/sdcard/autotester.log";
    private static ArrayList<ContentValues> mLogEvents = new ArrayList();
    private static final String TEST_SEQ_BEGIN = "AUTOTEST_SEQUENCE_BEGIN";
    private static final String TEST_STARTED = "AUTOTEST_TEST_BEGIN";
    private static final String TEST_DELAY_STARTED = "AUTOTEST_TEST_BEGIN_DELAY";
    private static final String TEST_ENDED = "AUTOTEST_TEST_SUCCESS";
    private static final String TEST_IDLE_ENDED = "AUTOTEST_IDLE_SUCCESS";
    private static long mTestStartTime;
    private String mPowerLogTag;
    private String mTestResult;
    private static final long USB_DELAY_TIME = 10000L;

    public MonkeyPowerEvent(String powerLogTag, String powerTestResult) {
        super(4);
        this.mPowerLogTag = powerLogTag;
        this.mTestResult = powerTestResult;
    }

    public MonkeyPowerEvent(String powerLogTag) {
        super(4);
        this.mPowerLogTag = powerLogTag;
        this.mTestResult = null;
    }

    public MonkeyPowerEvent() {
        super(4);
        this.mPowerLogTag = null;
        this.mTestResult = null;
    }

    private void bufferLogEvent(String tag, String value) {
        long tagTime = System.currentTimeMillis();
        if (tag.compareTo(TEST_STARTED) == 0) {
            mTestStartTime = tagTime;
        } else if (tag.compareTo(TEST_IDLE_ENDED) == 0) {
            long lagTime = Long.parseLong(value);
            tagTime = mTestStartTime + lagTime;
            tag = TEST_ENDED;
        } else if (tag.compareTo(TEST_DELAY_STARTED) == 0) {
            tagTime = mTestStartTime = tagTime + 10000L;
            tag = TEST_STARTED;
        }
        ContentValues event = new ContentValues();
        event.put("date", tagTime);
        event.put("tag", tag);
        if (value != null) {
            event.put("value", value);
        }
        mLogEvents.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogEvents() {
        ContentValues[] events = mLogEvents.toArray(new ContentValues[0]);
        mLogEvents.clear();
        OutputStreamWriter writer = null;
        try {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < events.length; ++i) {
                ContentValues event = events[i];
                buffer.append(MonkeyUtils.toCalendarTime(event.getAsLong("date")));
                buffer.append(event.getAsString("tag"));
                if (event.containsKey("value")) {
                    String value = event.getAsString("value");
                    buffer.append(" ");
                    buffer.append(value.replace('\n', '/'));
                }
                buffer.append("\n");
            }
            writer = new FileWriter(LOG_FILE, true);
            writer.write(buffer.toString());
        }
        catch (IOException e) {
            Log.w(TAG, "Can't write sdcard log file", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public int injectEvent(IWindowManager iwm, IActivityManager iam, int verbose) {
        if (this.mPowerLogTag != null) {
            if (this.mPowerLogTag.compareTo(TEST_SEQ_BEGIN) == 0) {
                this.bufferLogEvent(this.mPowerLogTag, Build.FINGERPRINT);
            } else if (this.mTestResult != null) {
                this.bufferLogEvent(this.mPowerLogTag, this.mTestResult);
            }
        } else {
            this.writeLogEvents();
        }
        return 1;
    }
}

