/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.app.UiAutomation;
import android.app.UiAutomationConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.graphics.Rect;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.commands.monkey.MonkeySourceNetwork;
import com.android.commands.monkey.MonkeyViewException;
import dalvik.system.DexClassLoader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeySourceNetworkViews {
    protected static UiAutomation sUiTestAutomationBridge;
    private static IPackageManager sPm;
    private static Map<String, Class<?>> sClassMap;
    private static final String HANDLER_THREAD_NAME = "UiAutomationHandlerThread";
    private static final String REMOTE_ERROR = "Unable to retrieve application info from PackageManager";
    private static final String CLASS_NOT_FOUND = "Error retrieving class information";
    private static final String NO_ACCESSIBILITY_EVENT = "No accessibility event has occured yet";
    private static final String NO_NODE = "Node with given ID does not exist";
    private static final String NO_CONNECTION = "Failed to connect to AccessibilityService, try restarting Monkey";
    private static final Map<String, ViewIntrospectionCommand> COMMAND_MAP;
    private static final HandlerThread sHandlerThread;

    public static void setup() {
        sHandlerThread.setDaemon(true);
        sHandlerThread.start();
        sUiTestAutomationBridge = new UiAutomation(sHandlerThread.getLooper(), new UiAutomationConnection());
        sUiTestAutomationBridge.connect();
    }

    public static void teardown() {
        sHandlerThread.quit();
    }

    private static Class<?> getIdClass(String packageName, String sourceDir) throws ClassNotFoundException {
        Class<?> klass = sClassMap.get(packageName);
        if (klass == null) {
            DexClassLoader classLoader = new DexClassLoader(sourceDir, "/data/local/tmp", null, ClassLoader.getSystemClassLoader());
            klass = classLoader.loadClass(packageName + ".R$id");
            sClassMap.put(packageName, klass);
        }
        return klass;
    }

    private static AccessibilityNodeInfo getNodeByAccessibilityIds(String windowString, String viewString) {
        int windowId = Integer.parseInt(windowString);
        int viewId = Integer.parseInt(viewString);
        int connectionId = sUiTestAutomationBridge.getConnectionId();
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(connectionId, windowId, viewId, false, 0);
    }

    private static AccessibilityNodeInfo getNodeByViewId(String viewId) throws MonkeyViewException {
        int connectionId = sUiTestAutomationBridge.getConnectionId();
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        List<AccessibilityNodeInfo> infos = client.findAccessibilityNodeInfosByViewId(connectionId, -1, AccessibilityNodeInfo.ROOT_NODE_ID, viewId);
        return !infos.isEmpty() ? infos.get(0) : null;
    }

    static {
        sPm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        sClassMap = new HashMap();
        COMMAND_MAP = new HashMap<String, ViewIntrospectionCommand>();
        COMMAND_MAP.put("getlocation", new GetLocation());
        COMMAND_MAP.put("gettext", new GetText());
        COMMAND_MAP.put("getclass", new GetClass());
        COMMAND_MAP.put("getchecked", new GetChecked());
        COMMAND_MAP.put("getenabled", new GetEnabled());
        COMMAND_MAP.put("getselected", new GetSelected());
        COMMAND_MAP.put("setselected", new SetSelected());
        COMMAND_MAP.put("getfocused", new GetFocused());
        COMMAND_MAP.put("setfocused", new SetFocused());
        COMMAND_MAP.put("getparent", new GetParent());
        COMMAND_MAP.put("getchildren", new GetChildren());
        COMMAND_MAP.put("getaccessibilityids", new GetAccessibilityIds());
        sHandlerThread = new HandlerThread(HANDLER_THREAD_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetChildren
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                GetAccessibilityIds idGetter = new GetAccessibilityIds();
                ArrayList<String> emptyArgs = new ArrayList<String>();
                StringBuilder ids = new StringBuilder();
                int totalChildren = node.getChildCount();
                for (int i = 0; i < totalChildren; ++i) {
                    MonkeySourceNetwork.MonkeyCommandReturn result = idGetter.query(node.getChild(i), emptyArgs);
                    if (!result.wasSuccessful()) {
                        return result;
                    }
                    ids.append(result.getMessage()).append(" ");
                }
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, ids.toString());
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetParent
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                AccessibilityNodeInfo parent = node.getParent();
                if (parent == null) {
                    return new MonkeySourceNetwork.MonkeyCommandReturn(false, "Given node has no parent");
                }
                return new GetAccessibilityIds().query(parent, new ArrayList<String>());
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetAccessibilityIds
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                int viewId;
                try {
                    Class<?> klass = node.getClass();
                    Field field = klass.getDeclaredField("mAccessibilityViewId");
                    field.setAccessible(true);
                    viewId = (Integer)field.get(node);
                }
                catch (NoSuchFieldException e) {
                    return new MonkeySourceNetwork.MonkeyCommandReturn(false, MonkeySourceNetworkViews.NO_NODE);
                }
                catch (IllegalAccessException e) {
                    return new MonkeySourceNetwork.MonkeyCommandReturn(false, "Access exception");
                }
                String ids = node.getWindowId() + " " + viewId;
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, ids);
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetFocused
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 1) {
                boolean actionPerformed;
                if (Boolean.valueOf(args.get(0)).booleanValue()) {
                    actionPerformed = node.performAction(1);
                } else if (!Boolean.valueOf(args.get(0)).booleanValue()) {
                    actionPerformed = node.performAction(2);
                } else {
                    return MonkeySourceNetwork.EARG;
                }
                return new MonkeySourceNetwork.MonkeyCommandReturn(actionPerformed);
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetFocused
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, Boolean.toString(node.isFocused()));
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetSelected
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 1) {
                boolean actionPerformed;
                if (Boolean.valueOf(args.get(0)).booleanValue()) {
                    actionPerformed = node.performAction(4);
                } else if (!Boolean.valueOf(args.get(0)).booleanValue()) {
                    actionPerformed = node.performAction(8);
                } else {
                    return MonkeySourceNetwork.EARG;
                }
                return new MonkeySourceNetwork.MonkeyCommandReturn(actionPerformed);
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetSelected
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, Boolean.toString(node.isSelected()));
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetEnabled
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, Boolean.toString(node.isEnabled()));
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetChecked
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, Boolean.toString(node.isChecked()));
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetClass
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, ((Object)node.getClassName()).toString());
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetText
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                if (node.isPassword()) {
                    return new MonkeySourceNetwork.MonkeyCommandReturn(false, "Node contains a password");
                }
                if (node.getText() == null) {
                    return new MonkeySourceNetwork.MonkeyCommandReturn(true, "");
                }
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, ((Object)node.getText()).toString());
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetLocation
    implements ViewIntrospectionCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo node, List<String> args) {
            if (args.size() == 0) {
                Rect nodePosition = new Rect();
                node.getBoundsInScreen(nodePosition);
                StringBuilder positions = new StringBuilder();
                positions.append(nodePosition.left).append(" ").append(nodePosition.top);
                positions.append(" ").append(nodePosition.right - nodePosition.left).append(" ");
                positions.append(nodePosition.bottom - nodePosition.top);
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, positions.toString());
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetViewsWithTextCommand
    implements MonkeySourceNetwork.MonkeyCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn translateCommand(List<String> command, MonkeySourceNetwork.CommandQueue queue) {
            if (command.size() == 2) {
                String text = command.get(1);
                int connectionId = sUiTestAutomationBridge.getConnectionId();
                List<AccessibilityNodeInfo> nodes = AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfosByText(connectionId, -1, AccessibilityNodeInfo.ROOT_NODE_ID, text);
                GetAccessibilityIds idGetter = new GetAccessibilityIds();
                ArrayList<String> emptyArgs = new ArrayList<String>();
                StringBuilder ids = new StringBuilder();
                for (AccessibilityNodeInfo node : nodes) {
                    MonkeySourceNetwork.MonkeyCommandReturn result = idGetter.query(node, emptyArgs);
                    if (!result.wasSuccessful()) {
                        return result;
                    }
                    ids.append(result.getMessage()).append(" ");
                }
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, ids.toString());
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetRootViewCommand
    implements MonkeySourceNetwork.MonkeyCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn translateCommand(List<String> command, MonkeySourceNetwork.CommandQueue queue) {
            AccessibilityNodeInfo node = sUiTestAutomationBridge.getRootInActiveWindow();
            return new GetAccessibilityIds().query(node, new ArrayList<String>());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryViewCommand
    implements MonkeySourceNetwork.MonkeyCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn translateCommand(List<String> command, MonkeySourceNetwork.CommandQueue queue) {
            if (command.size() > 2) {
                List<String> args;
                String viewQuery;
                AccessibilityNodeInfo node;
                String idType = command.get(1);
                if ("viewid".equals(idType)) {
                    try {
                        node = MonkeySourceNetworkViews.getNodeByViewId(command.get(2));
                        viewQuery = command.get(3);
                        args = command.subList(4, command.size());
                    }
                    catch (MonkeyViewException e) {
                        return new MonkeySourceNetwork.MonkeyCommandReturn(false, e.getMessage());
                    }
                } else if (idType.equals("accessibilityids")) {
                    try {
                        node = MonkeySourceNetworkViews.getNodeByAccessibilityIds(command.get(2), command.get(3));
                        viewQuery = command.get(4);
                        args = command.subList(5, command.size());
                    }
                    catch (NumberFormatException e) {
                        return MonkeySourceNetwork.EARG;
                    }
                } else {
                    return MonkeySourceNetwork.EARG;
                }
                if (node == null) {
                    return new MonkeySourceNetwork.MonkeyCommandReturn(false, MonkeySourceNetworkViews.NO_NODE);
                }
                ViewIntrospectionCommand getter = (ViewIntrospectionCommand)COMMAND_MAP.get(viewQuery);
                if (getter != null) {
                    return getter.query(node, args);
                }
                return MonkeySourceNetwork.EARG;
            }
            return MonkeySourceNetwork.EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListViewsCommand
    implements MonkeySourceNetwork.MonkeyCommand {
        @Override
        public MonkeySourceNetwork.MonkeyCommandReturn translateCommand(List<String> command, MonkeySourceNetwork.CommandQueue queue) {
            AccessibilityNodeInfo node = sUiTestAutomationBridge.getRootInActiveWindow();
            if (node == null) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(false, MonkeySourceNetworkViews.NO_ACCESSIBILITY_EVENT);
            }
            String packageName = ((Object)node.getPackageName()).toString();
            try {
                Field[] fields;
                ApplicationInfo appInfo = sPm.getApplicationInfo(packageName, 0, UserHandle.myUserId());
                Class klass = MonkeySourceNetworkViews.getIdClass(packageName, appInfo.sourceDir);
                StringBuilder fieldBuilder = new StringBuilder();
                for (Field field : fields = klass.getFields()) {
                    fieldBuilder.append(field.getName() + " ");
                }
                return new MonkeySourceNetwork.MonkeyCommandReturn(true, fieldBuilder.toString());
            }
            catch (RemoteException e) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(false, MonkeySourceNetworkViews.REMOTE_ERROR);
            }
            catch (ClassNotFoundException e) {
                return new MonkeySourceNetwork.MonkeyCommandReturn(false, MonkeySourceNetworkViews.CLASS_NOT_FOUND);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ViewIntrospectionCommand {
        public MonkeySourceNetwork.MonkeyCommandReturn query(AccessibilityNodeInfo var1, List<String> var2);
    }
}

