/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeyEventSource;
import com.android.commands.monkey.MonkeySourceScript;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeySourceRandomScript
implements MonkeyEventSource {
    private int mVerbose = 0;
    private MonkeySourceScript mSetupSource = null;
    private ArrayList<MonkeySourceScript> mScriptSources = new ArrayList();
    private MonkeySourceScript mCurrentSource = null;
    private Random mRandom;
    private boolean mRandomizeScript = false;
    private int mScriptCount = 0;

    public MonkeySourceRandomScript(String setupFileName, ArrayList<String> scriptFileNames, long throttle, boolean randomizeThrottle, Random random, long profileWaitTime, long deviceSleepTime, boolean randomizeScript) {
        if (setupFileName != null) {
            this.mCurrentSource = this.mSetupSource = new MonkeySourceScript(random, setupFileName, throttle, randomizeThrottle, profileWaitTime, deviceSleepTime);
        }
        for (String fileName : scriptFileNames) {
            this.mScriptSources.add(new MonkeySourceScript(random, fileName, throttle, randomizeThrottle, profileWaitTime, deviceSleepTime));
        }
        this.mRandom = random;
        this.mRandomizeScript = randomizeScript;
    }

    public MonkeySourceRandomScript(ArrayList<String> scriptFileNames, long throttle, boolean randomizeThrottle, Random random, long profileWaitTime, long deviceSleepTime, boolean randomizeScript) {
        this(null, scriptFileNames, throttle, randomizeThrottle, random, profileWaitTime, deviceSleepTime, randomizeScript);
    }

    @Override
    public MonkeyEvent getNextEvent() {
        if (this.mCurrentSource == null) {
            int numSources = this.mScriptSources.size();
            if (numSources == 1) {
                this.mCurrentSource = this.mScriptSources.get(0);
            } else if (numSources > 1) {
                if (this.mRandomizeScript) {
                    this.mCurrentSource = this.mScriptSources.get(this.mRandom.nextInt(numSources));
                } else {
                    this.mCurrentSource = this.mScriptSources.get(this.mScriptCount % numSources);
                    ++this.mScriptCount;
                }
            }
        }
        if (this.mCurrentSource != null) {
            MonkeyEvent nextEvent = this.mCurrentSource.getNextEvent();
            if (nextEvent == null) {
                this.mCurrentSource = null;
            }
            return nextEvent;
        }
        return null;
    }

    @Override
    public void setVerbose(int verbose) {
        this.mVerbose = verbose;
        if (this.mSetupSource != null) {
            this.mSetupSource.setVerbose(verbose);
        }
        for (MonkeySourceScript source : this.mScriptSources) {
            source.setVerbose(verbose);
        }
    }

    @Override
    public boolean validate() {
        if (this.mSetupSource != null && !this.mSetupSource.validate()) {
            return false;
        }
        for (MonkeySourceScript source : this.mScriptSources) {
            if (source.validate()) continue;
            return false;
        }
        return true;
    }
}

