/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.svc;

import android.hardware.usb.IUsbManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import com.android.commands.svc.Svc;

public class UsbCommand
extends Svc.Command {
    public UsbCommand() {
        super("usb");
    }

    public String shortHelp() {
        return "Control Usb state";
    }

    public String longHelp() {
        return this.shortHelp() + "\n" + "\n" + "usage: svc usb setFunction [function]\n" + "         Set the current usb function.\n\n" + "       svc usb getFunction\n" + "          Gets the list of currently enabled functions\n";
    }

    public void run(String[] args) {
        boolean validCommand = false;
        if (args.length >= 2) {
            if ("setFunction".equals(args[1])) {
                IUsbManager usbMgr = IUsbManager.Stub.asInterface(ServiceManager.getService("usb"));
                try {
                    usbMgr.setCurrentFunction(args.length >= 3 ? args[2] : null, false);
                }
                catch (RemoteException e) {
                    System.err.println("Error communicating with UsbManager: " + e);
                }
                return;
            }
            if ("getFunction".equals(args[1])) {
                System.err.println(SystemProperties.get("sys.usb.config"));
                return;
            }
        }
        System.err.println(this.longHelp());
    }
}

