/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.uiautomator;

import android.app.UiAutomation;
import android.view.accessibility.AccessibilityEvent;
import com.android.commands.uiautomator.Launcher;
import com.android.uiautomator.core.UiAutomationShellWrapper;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EventsCommand
extends Launcher.Command {
    private Object mQuitLock = new Object();

    public EventsCommand() {
        super("events");
    }

    public String shortHelp() {
        return "prints out accessibility events until terminated";
    }

    public String detailedOptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        UiAutomationShellWrapper automationWrapper = new UiAutomationShellWrapper();
        automationWrapper.connect();
        automationWrapper.getUiAutomation().setOnAccessibilityEventListener(new UiAutomation.OnAccessibilityEventListener(){

            public void onAccessibilityEvent(AccessibilityEvent event) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
                System.out.println(String.format("%s %s", formatter.format(new Date()), event.toString()));
            }
        });
        Object object = this.mQuitLock;
        synchronized (object) {
            try {
                this.mQuitLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        automationWrapper.disconnect();
    }
}

