/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.os.FileUtils;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;

public class PackageHelper {
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int RECOMMEND_FAILED_INVALID_APK = -2;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    public static final int RECOMMEND_FAILED_INVALID_URI = -6;
    public static final int RECOMMEND_FAILED_VERSION_DOWNGRADE = -7;
    private static final boolean localLOGV = false;
    private static final String TAG = "PackageHelper";
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int APP_INSTALL_EXTERNAL = 2;

    public static IMountService getMountService() throws RemoteException {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IMountService.Stub.asInterface(service);
        }
        Log.e(TAG, "Can't get mount service");
        throw new RemoteException("Could not contact mount service");
    }

    public static String createSdDir(int sizeMb, String cid, String sdEncKey, int uid, boolean isExternal) {
        try {
            IMountService mountService = PackageHelper.getMountService();
            int rc = mountService.createSecureContainer(cid, sizeMb, "ext4", sdEncKey, uid, isExternal);
            if (rc != 0) {
                Log.e(TAG, "Failed to create secure container " + cid);
                return null;
            }
            String cachePath = mountService.getSecureContainerPath(cid);
            return cachePath;
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return null;
        }
    }

    public static String mountSdDir(String cid, String key, int ownerUid) {
        try {
            int rc = PackageHelper.getMountService().mountSecureContainer(cid, key, ownerUid);
            if (rc != 0) {
                Log.i(TAG, "Failed to mount container " + cid + " rc : " + rc);
                return null;
            }
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return null;
        }
    }

    public static boolean unMountSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().unmountSecureContainer(cid, true);
            if (rc != 0) {
                Log.e(TAG, "Failed to unmount " + cid + " with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return false;
        }
    }

    public static boolean renameSdDir(String oldId, String newId) {
        try {
            int rc = PackageHelper.getMountService().renameSecureContainer(oldId, newId);
            if (rc != 0) {
                Log.e(TAG, "Failed to rename " + oldId + " to " + newId + "with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.i(TAG, "Failed ot rename  " + oldId + " to " + newId + " with exception : " + e);
            return false;
        }
    }

    public static String getSdDir(String cid) {
        try {
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    public static String getSdFilesystem(String cid) {
        try {
            return PackageHelper.getMountService().getSecureContainerFilesystemPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    public static boolean finalizeSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().finalizeSecureContainer(cid);
            if (rc != 0) {
                Log.i(TAG, "Failed to finalize container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to finalize container " + cid + " with exception " + e);
            return false;
        }
    }

    public static boolean destroySdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().destroySecureContainer(cid, true);
            if (rc != 0) {
                Log.i(TAG, "Failed to destroy container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to destroy container " + cid + " with exception " + e);
            return false;
        }
    }

    public static String[] getSecureContainerList() {
        try {
            return PackageHelper.getMountService().getSecureContainerList();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get secure container list with exception" + e);
            return null;
        }
    }

    public static boolean isContainerMounted(String cid) {
        try {
            return PackageHelper.getMountService().isSecureContainerMounted(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to find out if container " + cid + " mounted");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int extractPublicFiles(String packagePath, File publicZipFile) throws IOException {
        ZipOutputStream publicZipOutStream;
        FileOutputStream fstr;
        if (publicZipFile == null) {
            fstr = null;
            publicZipOutStream = null;
        } else {
            fstr = new FileOutputStream(publicZipFile);
            publicZipOutStream = new ZipOutputStream(fstr);
        }
        int size = 0;
        try {
            ZipFile privateZip = new ZipFile(packagePath);
            try {
                for (ZipEntry zipEntry : Collections.list(privateZip.entries())) {
                    String zipEntryName = zipEntry.getName();
                    if (!"AndroidManifest.xml".equals(zipEntryName) && !"resources.arsc".equals(zipEntryName) && !zipEntryName.startsWith("res/")) continue;
                    size = (int)((long)size + zipEntry.getSize());
                    if (publicZipFile == null) continue;
                    PackageHelper.copyZipEntry(zipEntry, privateZip, publicZipOutStream);
                }
            }
            finally {
                try {
                    privateZip.close();
                }
                catch (IOException e) {}
            }
            if (publicZipFile != null) {
                publicZipOutStream.finish();
                publicZipOutStream.flush();
                FileUtils.sync(fstr);
                publicZipOutStream.close();
                FileUtils.setPermissions(publicZipFile.getAbsolutePath(), 420, -1, -1);
            }
        }
        finally {
            IoUtils.closeQuietly(publicZipOutStream);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyZipEntry(ZipEntry zipEntry, ZipFile inZipFile, ZipOutputStream outZipStream) throws IOException {
        byte[] buffer = new byte[4096];
        ZipEntry newEntry = zipEntry.getMethod() == 0 ? new ZipEntry(zipEntry) : new ZipEntry(zipEntry.getName());
        outZipStream.putNextEntry(newEntry);
        InputStream data = inZipFile.getInputStream(zipEntry);
        try {
            int num;
            while ((num = data.read(buffer)) > 0) {
                outZipStream.write(buffer, 0, num);
            }
            outZipStream.flush();
        }
        finally {
            IoUtils.closeQuietly(data);
        }
    }

    public static boolean fixSdPermissions(String cid, int gid, String filename) {
        try {
            int rc = PackageHelper.getMountService().fixPermissionsSecureContainer(cid, gid, filename);
            if (rc != 0) {
                Log.i(TAG, "Failed to fixperms container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to fixperms container " + cid + " with exception " + e);
            return false;
        }
    }
}

