/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Slog;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.TextServicesManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMethodUtils {
    public static final boolean DEBUG = false;
    public static final int NOT_A_SUBTYPE_ID = -1;
    public static final String SUBTYPE_MODE_KEYBOARD = "keyboard";
    public static final String SUBTYPE_MODE_VOICE = "voice";
    private static final String TAG = "InputMethodUtils";
    private static final Locale ENGLISH_LOCALE = new Locale("en");
    private static final String NOT_A_SUBTYPE_ID_STR = String.valueOf(-1);
    private static final String TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE = "EnabledWhenDefaultIsNotAsciiCapable";
    private static final String TAG_ASCII_CAPABLE = "AsciiCapable";

    private InputMethodUtils() {
    }

    public static String getStackTrace() {
        StringBuilder sb = new StringBuilder();
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                sb.append(frames[j].toString() + "\n");
            }
            return sb.toString();
        }
    }

    public static String getApiCallStack() {
        String apiCallStack = "";
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                String tempCallStack = frames[j].toString();
                if (TextUtils.isEmpty(apiCallStack)) {
                    apiCallStack = tempCallStack;
                    continue;
                }
                if (tempCallStack.indexOf("Transact(") >= 0) break;
                apiCallStack = tempCallStack;
            }
            return apiCallStack;
        }
    }

    public static boolean isSystemIme(InputMethodInfo inputMethod) {
        return (inputMethod.getServiceInfo().applicationInfo.flags & 1) != 0;
    }

    public static boolean isSystemImeThatHasEnglishKeyboardSubtype(InputMethodInfo imi) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        return InputMethodUtils.containsSubtypeOf(imi, ENGLISH_LOCALE.getLanguage(), SUBTYPE_MODE_KEYBOARD);
    }

    private static boolean isSystemAuxilialyImeThatHashAutomaticSubtype(InputMethodInfo imi) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (!imi.isAuxiliaryIme()) {
            return false;
        }
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype s = imi.getSubtypeAt(i);
            if (!s.overridesImplicitlyEnabledSubtype()) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<InputMethodInfo> getDefaultEnabledImes(Context context, boolean isSystemReady, ArrayList<InputMethodInfo> imis) {
        InputMethodInfo imi;
        int i;
        ArrayList<InputMethodInfo> retval = new ArrayList<InputMethodInfo>();
        boolean auxilialyImeAdded = false;
        for (i = 0; i < imis.size(); ++i) {
            imi = imis.get(i);
            if (!InputMethodUtils.isDefaultEnabledIme(isSystemReady, imi, context)) continue;
            retval.add(imi);
            if (!imi.isAuxiliaryIme()) continue;
            auxilialyImeAdded = true;
        }
        if (auxilialyImeAdded) {
            return retval;
        }
        for (i = 0; i < imis.size(); ++i) {
            imi = imis.get(i);
            if (!InputMethodUtils.isSystemAuxilialyImeThatHashAutomaticSubtype(imi)) continue;
            retval.add(imi);
        }
        return retval;
    }

    public static boolean isValidSystemDefaultIme(boolean isSystemReady, InputMethodInfo imi, Context context) {
        if (!isSystemReady) {
            return false;
        }
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (imi.getIsDefaultResourceId() != 0) {
            try {
                if (imi.isDefault(context) && InputMethodUtils.containsSubtypeOf(imi, context.getResources().getConfiguration().locale.getLanguage(), null)) {
                    return true;
                }
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (imi.getSubtypeCount() == 0) {
            Slog.w(TAG, "Found no subtypes in a system IME: " + imi.getPackageName());
        }
        return false;
    }

    public static boolean isDefaultEnabledIme(boolean isSystemReady, InputMethodInfo imi, Context context) {
        return InputMethodUtils.isValidSystemDefaultIme(isSystemReady, imi, context) || InputMethodUtils.isSystemImeThatHasEnglishKeyboardSubtype(imi);
    }

    public static boolean containsSubtypeOf(InputMethodInfo imi, String language, String mode) {
        int N = imi.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            if (!imi.getSubtypeAt(i).getLocale().startsWith(language) || !TextUtils.isEmpty(mode) && !imi.getSubtypeAt(i).getMode().equalsIgnoreCase(mode)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<InputMethodSubtype> getSubtypes(InputMethodInfo imi) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            subtypes.add(imi.getSubtypeAt(i));
        }
        return subtypes;
    }

    public static ArrayList<InputMethodSubtype> getOverridingImplicitlyEnabledSubtypes(InputMethodInfo imi, String mode) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || !subtype.getMode().equals(mode)) continue;
            subtypes.add(subtype);
        }
        return subtypes;
    }

    public static InputMethodInfo getMostApplicableDefaultIME(List<InputMethodInfo> enabledImes) {
        if (enabledImes != null && enabledImes.size() > 0) {
            int i = enabledImes.size();
            int firstFoundSystemIme = -1;
            while (i > 0) {
                InputMethodInfo imi;
                if (InputMethodUtils.isSystemImeThatHasEnglishKeyboardSubtype(imi = enabledImes.get(--i)) && !imi.isAuxiliaryIme()) {
                    return imi;
                }
                if (firstFoundSystemIme >= 0 || !InputMethodUtils.isSystemIme(imi) || imi.isAuxiliaryIme()) continue;
                firstFoundSystemIme = i;
            }
            return enabledImes.get(Math.max(firstFoundSystemIme, 0));
        }
        return null;
    }

    public static boolean isValidSubtypeId(InputMethodInfo imi, int subtypeHashCode) {
        return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode) != -1;
    }

    public static int getSubtypeIdFromHashCode(InputMethodInfo imi, int subtypeHashCode) {
        if (imi != null) {
            int subtypeCount = imi.getSubtypeCount();
            for (int i = 0; i < subtypeCount; ++i) {
                InputMethodSubtype ims = imi.getSubtypeAt(i);
                if (subtypeHashCode != ims.hashCode()) continue;
                return i;
            }
        }
        return -1;
    }

    private static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLocked(Resources res, InputMethodInfo imi) {
        InputMethodSubtype lastResortKeyboardSubtype;
        InputMethodSubtype subtype;
        int i;
        ArrayList<InputMethodSubtype> subtypes = InputMethodUtils.getSubtypes(imi);
        String systemLocale = res.getConfiguration().locale.toString();
        if (TextUtils.isEmpty(systemLocale)) {
            return new ArrayList<InputMethodSubtype>();
        }
        HashMap<String, InputMethodSubtype> applicableModeAndSubtypesMap = new HashMap<String, InputMethodSubtype>();
        int N = subtypes.size();
        for (i = 0; i < N; ++i) {
            String mode;
            subtype = (InputMethodSubtype)subtypes.get(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || applicableModeAndSubtypesMap.containsKey(mode = subtype.getMode())) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
        }
        if (applicableModeAndSubtypesMap.size() > 0) {
            return new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        }
        for (i = 0; i < N; ++i) {
            InputMethodSubtype applicableSubtype;
            subtype = (InputMethodSubtype)subtypes.get(i);
            String locale = subtype.getLocale();
            String mode = subtype.getMode();
            if (!systemLocale.startsWith(locale) || (applicableSubtype = (InputMethodSubtype)applicableModeAndSubtypesMap.get(mode)) != null && (systemLocale.equals(applicableSubtype.getLocale()) || !systemLocale.equals(locale))) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
        }
        InputMethodSubtype keyboardSubtype = (InputMethodSubtype)applicableModeAndSubtypesMap.get(SUBTYPE_MODE_KEYBOARD);
        ArrayList<InputMethodSubtype> applicableSubtypes = new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        if (keyboardSubtype != null && !keyboardSubtype.containsExtraValueKey(TAG_ASCII_CAPABLE)) {
            for (int i2 = 0; i2 < N; ++i2) {
                InputMethodSubtype subtype2 = (InputMethodSubtype)subtypes.get(i2);
                String mode = subtype2.getMode();
                if (!SUBTYPE_MODE_KEYBOARD.equals(mode) || !subtype2.containsExtraValueKey(TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE)) continue;
                applicableSubtypes.add(subtype2);
            }
        }
        if (keyboardSubtype == null && (lastResortKeyboardSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(res, subtypes, SUBTYPE_MODE_KEYBOARD, systemLocale, true)) != null) {
            applicableSubtypes.add(lastResortKeyboardSubtype);
        }
        return applicableSubtypes;
    }

    private static List<InputMethodSubtype> getEnabledInputMethodSubtypeList(Context context, InputMethodInfo imi, List<InputMethodSubtype> enabledSubtypes, boolean allowsImplicitlySelectedSubtypes) {
        if (allowsImplicitlySelectedSubtypes && enabledSubtypes.isEmpty()) {
            enabledSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), imi);
        }
        return InputMethodSubtype.sort(context, 0, imi, enabledSubtypes);
    }

    public static InputMethodSubtype findLastResortApplicableSubtypeLocked(Resources res, List<InputMethodSubtype> subtypes, String mode, String locale, boolean canIgnoreLocaleAsLastResort) {
        if (subtypes == null || subtypes.size() == 0) {
            return null;
        }
        if (TextUtils.isEmpty(locale)) {
            locale = res.getConfiguration().locale.toString();
        }
        String language = locale.substring(0, 2);
        boolean partialMatchFound = false;
        InputMethodSubtype applicableSubtype = null;
        InputMethodSubtype firstMatchedModeSubtype = null;
        int N = subtypes.size();
        for (int i = 0; i < N; ++i) {
            InputMethodSubtype subtype = subtypes.get(i);
            String subtypeLocale = subtype.getLocale();
            if (mode != null && !subtypes.get(i).getMode().equalsIgnoreCase(mode)) continue;
            if (firstMatchedModeSubtype == null) {
                firstMatchedModeSubtype = subtype;
            }
            if (locale.equals(subtypeLocale)) {
                applicableSubtype = subtype;
                break;
            }
            if (partialMatchFound || !subtypeLocale.startsWith(language)) continue;
            applicableSubtype = subtype;
            partialMatchFound = true;
        }
        if (applicableSubtype == null && canIgnoreLocaleAsLastResort) {
            return firstMatchedModeSubtype;
        }
        return applicableSubtype;
    }

    public static boolean canAddToLastInputMethod(InputMethodSubtype subtype) {
        if (subtype == null) {
            return true;
        }
        return !subtype.isAuxiliary();
    }

    public static void setNonSelectedSystemImesDisabledUntilUsed(PackageManager packageManager, List<InputMethodInfo> enabledImis) {
        String[] systemImesDisabledUntilUsed = Resources.getSystem().getStringArray(17236011);
        if (systemImesDisabledUntilUsed == null || systemImesDisabledUntilUsed.length == 0) {
            return;
        }
        SpellCheckerInfo currentSpellChecker = TextServicesManager.getInstance().getCurrentSpellChecker();
        for (String packageName : systemImesDisabledUntilUsed) {
            boolean isSystemPackage;
            boolean enabledIme = false;
            for (int j = 0; j < enabledImis.size(); ++j) {
                InputMethodInfo imi = enabledImis.get(j);
                if (!packageName.equals(imi.getPackageName())) continue;
                enabledIme = true;
                break;
            }
            if (enabledIme || currentSpellChecker != null && packageName.equals(currentSpellChecker.getPackageName())) continue;
            ApplicationInfo ai = null;
            try {
                ai = packageManager.getApplicationInfo(packageName, 32768);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(TAG, "NameNotFoundException: " + packageName, e);
            }
            if (ai == null) continue;
            boolean bl = isSystemPackage = (ai.flags & 1) != 0;
            if (!isSystemPackage) continue;
            InputMethodUtils.setDisabledUntilUsed(packageManager, packageName);
        }
    }

    private static void setDisabledUntilUsed(PackageManager packageManager, String packageName) {
        int state = packageManager.getApplicationEnabledSetting(packageName);
        if (state == 0 || state == 1) {
            packageManager.setApplicationEnabledSetting(packageName, 4, 0);
        }
    }

    public static CharSequence getImeAndSubtypeDisplayName(Context context, InputMethodInfo imi, InputMethodSubtype subtype) {
        CharSequence imiLabel = imi.loadLabel(context.getPackageManager());
        return subtype != null ? TextUtils.concat(subtype.getDisplayName(context, imi.getPackageName(), imi.getServiceInfo().applicationInfo), TextUtils.isEmpty(imiLabel) ? "" : " - " + imiLabel) : imiLabel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputMethodSettings {
        private static final char INPUT_METHOD_SEPARATER = ':';
        private static final char INPUT_METHOD_SUBTYPE_SEPARATER = ';';
        private final TextUtils.SimpleStringSplitter mInputMethodSplitter = new TextUtils.SimpleStringSplitter(':');
        private final TextUtils.SimpleStringSplitter mSubtypeSplitter = new TextUtils.SimpleStringSplitter(';');
        private final Resources mRes;
        private final ContentResolver mResolver;
        private final HashMap<String, InputMethodInfo> mMethodMap;
        private final ArrayList<InputMethodInfo> mMethodList;
        private String mEnabledInputMethodsStrCache;
        private int mCurrentUserId;

        private static void buildEnabledInputMethodsSettingString(StringBuilder builder, Pair<String, ArrayList<String>> pair) {
            String id2 = (String)pair.first;
            ArrayList subtypes = (ArrayList)pair.second;
            builder.append(id2);
            for (String subtypeId : subtypes) {
                builder.append(';').append(subtypeId);
            }
        }

        public InputMethodSettings(Resources res, ContentResolver resolver, HashMap<String, InputMethodInfo> methodMap, ArrayList<InputMethodInfo> methodList, int userId) {
            this.setCurrentUserId(userId);
            this.mRes = res;
            this.mResolver = resolver;
            this.mMethodMap = methodMap;
            this.mMethodList = methodList;
        }

        public void setCurrentUserId(int userId) {
            this.mCurrentUserId = userId;
        }

        public List<InputMethodInfo> getEnabledInputMethodListLocked() {
            return this.createEnabledInputMethodListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        public List<Pair<InputMethodInfo, ArrayList<String>>> getEnabledInputMethodAndSubtypeHashCodeListLocked() {
            return this.createEnabledInputMethodAndSubtypeHashCodeListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(Context context, InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
            ArrayList enabledSubtypes = this.getEnabledInputMethodSubtypeListLocked(imi);
            if (allowsImplicitlySelectedSubtypes && enabledSubtypes.isEmpty()) {
                enabledSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), imi);
            }
            return InputMethodSubtype.sort(context, 0, imi, enabledSubtypes);
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(InputMethodInfo imi) {
            List<Pair<String, ArrayList<String>>> imsList = this.getEnabledInputMethodsAndSubtypeListLocked();
            ArrayList<InputMethodSubtype> enabledSubtypes = new ArrayList<InputMethodSubtype>();
            if (imi != null) {
                for (Pair<String, ArrayList<String>> imsPair : imsList) {
                    InputMethodInfo info = this.mMethodMap.get(imsPair.first);
                    if (info == null || !info.getId().equals(imi.getId())) continue;
                    int subtypeCount = info.getSubtypeCount();
                    for (int i = 0; i < subtypeCount; ++i) {
                        InputMethodSubtype ims = info.getSubtypeAt(i);
                        for (String s : (ArrayList)imsPair.second) {
                            if (!String.valueOf(ims.hashCode()).equals(s)) continue;
                            enabledSubtypes.add(ims);
                        }
                    }
                }
            }
            return enabledSubtypes;
        }

        public void enableAllIMEsIfThereIsNoEnabledIME() {
            if (TextUtils.isEmpty(this.getEnabledInputMethodsStr())) {
                StringBuilder sb = new StringBuilder();
                int N = this.mMethodList.size();
                for (int i = 0; i < N; ++i) {
                    InputMethodInfo imi = this.mMethodList.get(i);
                    Slog.i(InputMethodUtils.TAG, "Adding: " + imi.getId());
                    if (i > 0) {
                        sb.append(':');
                    }
                    sb.append(imi.getId());
                }
                this.putEnabledInputMethodsStr(sb.toString());
            }
        }

        public List<Pair<String, ArrayList<String>>> getEnabledInputMethodsAndSubtypeListLocked() {
            ArrayList<Pair<String, ArrayList<String>>> imsList = new ArrayList<Pair<String, ArrayList<String>>>();
            String enabledInputMethodsStr = this.getEnabledInputMethodsStr();
            if (TextUtils.isEmpty(enabledInputMethodsStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(enabledInputMethodsStr);
            while (this.mInputMethodSplitter.hasNext()) {
                String nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString(nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                ArrayList<String> subtypeHashes = new ArrayList<String>();
                String imeId = this.mSubtypeSplitter.next();
                while (this.mSubtypeSplitter.hasNext()) {
                    subtypeHashes.add(this.mSubtypeSplitter.next());
                }
                imsList.add(new Pair(imeId, subtypeHashes));
            }
            return imsList;
        }

        public void appendAndPutEnabledInputMethodLocked(String id2, boolean reloadInputMethodStr) {
            if (reloadInputMethodStr) {
                this.getEnabledInputMethodsStr();
            }
            if (TextUtils.isEmpty(this.mEnabledInputMethodsStrCache)) {
                this.putEnabledInputMethodsStr(id2);
            } else {
                this.putEnabledInputMethodsStr(this.mEnabledInputMethodsStrCache + ':' + id2);
            }
        }

        public boolean buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder builder, List<Pair<String, ArrayList<String>>> imsList, String id2) {
            boolean isRemoved = false;
            boolean needsAppendSeparator = false;
            for (Pair<String, ArrayList<String>> ims : imsList) {
                String curId = (String)ims.first;
                if (curId.equals(id2)) {
                    isRemoved = true;
                    continue;
                }
                if (needsAppendSeparator) {
                    builder.append(':');
                } else {
                    needsAppendSeparator = true;
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(builder, ims);
            }
            if (isRemoved) {
                this.putEnabledInputMethodsStr(builder.toString());
            }
            return isRemoved;
        }

        private List<InputMethodInfo> createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<InputMethodInfo> res = new ArrayList<InputMethodInfo>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add(info);
            }
            return res;
        }

        private List<Pair<InputMethodInfo, ArrayList<String>>> createEnabledInputMethodAndSubtypeHashCodeListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<Pair<InputMethodInfo, ArrayList<String>>> res = new ArrayList<Pair<InputMethodInfo, ArrayList<String>>>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add(new Pair(info, ims.second));
            }
            return res;
        }

        private void putEnabledInputMethodsStr(String str) {
            Settings.Secure.putStringForUser(this.mResolver, "enabled_input_methods", str, this.mCurrentUserId);
            this.mEnabledInputMethodsStrCache = str;
        }

        public String getEnabledInputMethodsStr() {
            this.mEnabledInputMethodsStrCache = Settings.Secure.getStringForUser(this.mResolver, "enabled_input_methods", this.mCurrentUserId);
            return this.mEnabledInputMethodsStrCache;
        }

        private void saveSubtypeHistory(List<Pair<String, String>> savedImes, String newImeId, String newSubtypeId) {
            StringBuilder builder = new StringBuilder();
            boolean isImeAdded = false;
            if (!TextUtils.isEmpty(newImeId) && !TextUtils.isEmpty(newSubtypeId)) {
                builder.append(newImeId).append(';').append(newSubtypeId);
                isImeAdded = true;
            }
            for (Pair<String, String> ime : savedImes) {
                String imeId = (String)ime.first;
                String subtypeId = (String)ime.second;
                if (TextUtils.isEmpty(subtypeId)) {
                    subtypeId = NOT_A_SUBTYPE_ID_STR;
                }
                if (isImeAdded) {
                    builder.append(':');
                } else {
                    isImeAdded = true;
                }
                builder.append(imeId).append(';').append(subtypeId);
            }
            this.putSubtypeHistoryStr(builder.toString());
        }

        private void addSubtypeToHistory(String imeId, String subtypeId) {
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> ime : subtypeHistory) {
                if (!((String)ime.first).equals(imeId)) continue;
                subtypeHistory.remove(ime);
                break;
            }
            this.saveSubtypeHistory(subtypeHistory, imeId, subtypeId);
        }

        private void putSubtypeHistoryStr(String str) {
            Settings.Secure.putStringForUser(this.mResolver, "input_methods_subtype_history", str, this.mCurrentUserId);
        }

        public Pair<String, String> getLastInputMethodAndSubtypeLocked() {
            return this.getLastSubtypeForInputMethodLockedInternal(null);
        }

        public String getLastSubtypeForInputMethodLocked(String imeId) {
            Pair<String, String> ime = this.getLastSubtypeForInputMethodLockedInternal(imeId);
            if (ime != null) {
                return (String)ime.second;
            }
            return null;
        }

        private Pair<String, String> getLastSubtypeForInputMethodLockedInternal(String imeId) {
            List<Pair<String, ArrayList<String>>> enabledImes = this.getEnabledInputMethodsAndSubtypeListLocked();
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> imeAndSubtype : subtypeHistory) {
                String subtypeInTheHistory;
                String subtypeHashCode;
                String imeInTheHistory = (String)imeAndSubtype.first;
                if (!TextUtils.isEmpty(imeId) && !imeInTheHistory.equals(imeId) || TextUtils.isEmpty(subtypeHashCode = this.getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(enabledImes, imeInTheHistory, subtypeInTheHistory = (String)imeAndSubtype.second))) continue;
                return new Pair<String, String>(imeInTheHistory, subtypeHashCode);
            }
            return null;
        }

        private String getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> enabledImes, String imeId, String subtypeHashCode) {
            for (Pair<String, ArrayList<String>> enabledIme : enabledImes) {
                if (!((String)enabledIme.first).equals(imeId)) continue;
                ArrayList explicitlyEnabledSubtypes = (ArrayList)enabledIme.second;
                InputMethodInfo imi = this.mMethodMap.get(imeId);
                if (explicitlyEnabledSubtypes.size() == 0) {
                    ArrayList implicitlySelectedSubtypes;
                    if (imi != null && imi.getSubtypeCount() > 0 && (implicitlySelectedSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(this.mRes, imi)) != null) {
                        int N = implicitlySelectedSubtypes.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype st = (InputMethodSubtype)implicitlySelectedSubtypes.get(i);
                            if (!String.valueOf(st.hashCode()).equals(subtypeHashCode)) continue;
                            return subtypeHashCode;
                        }
                    }
                } else {
                    for (String s : explicitlyEnabledSubtypes) {
                        if (!s.equals(subtypeHashCode)) continue;
                        try {
                            int hashCode = Integer.valueOf(subtypeHashCode);
                            if (InputMethodUtils.isValidSubtypeId(imi, hashCode)) {
                                return s;
                            }
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                        catch (NumberFormatException e) {
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                    }
                }
                return NOT_A_SUBTYPE_ID_STR;
            }
            return null;
        }

        private List<Pair<String, String>> loadInputMethodAndSubtypeHistoryLocked() {
            ArrayList<Pair<String, String>> imsList = new ArrayList<Pair<String, String>>();
            String subtypeHistoryStr = this.getSubtypeHistoryStr();
            if (TextUtils.isEmpty(subtypeHistoryStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(subtypeHistoryStr);
            while (this.mInputMethodSplitter.hasNext()) {
                String nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString(nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                String subtypeId = NOT_A_SUBTYPE_ID_STR;
                String imeId = this.mSubtypeSplitter.next();
                if (this.mSubtypeSplitter.hasNext()) {
                    subtypeId = this.mSubtypeSplitter.next();
                }
                imsList.add(new Pair<String, String>(imeId, subtypeId));
            }
            return imsList;
        }

        private String getSubtypeHistoryStr() {
            return Settings.Secure.getStringForUser(this.mResolver, "input_methods_subtype_history", this.mCurrentUserId);
        }

        public void putSelectedInputMethod(String imeId) {
            Settings.Secure.putStringForUser(this.mResolver, "default_input_method", imeId, this.mCurrentUserId);
        }

        public void putSelectedSubtype(int subtypeId) {
            Settings.Secure.putIntForUser(this.mResolver, "selected_input_method_subtype", subtypeId, this.mCurrentUserId);
        }

        public String getDisabledSystemInputMethods() {
            return Settings.Secure.getStringForUser(this.mResolver, "disabled_system_input_methods", this.mCurrentUserId);
        }

        public String getSelectedInputMethod() {
            return Settings.Secure.getStringForUser(this.mResolver, "default_input_method", this.mCurrentUserId);
        }

        public boolean isSubtypeSelected() {
            return this.getSelectedInputMethodSubtypeHashCode() != -1;
        }

        private int getSelectedInputMethodSubtypeHashCode() {
            try {
                return Settings.Secure.getIntForUser(this.mResolver, "selected_input_method_subtype", this.mCurrentUserId);
            }
            catch (Settings.SettingNotFoundException e) {
                return -1;
            }
        }

        public int getCurrentUserId() {
            return this.mCurrentUserId;
        }

        public int getSelectedInputMethodSubtypeId(String selectedImiId) {
            InputMethodInfo imi = this.mMethodMap.get(selectedImiId);
            if (imi == null) {
                return -1;
            }
            int subtypeHashCode = this.getSelectedInputMethodSubtypeHashCode();
            return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode);
        }

        public void saveCurrentInputMethodAndSubtypeToHistory(String curMethodId, InputMethodSubtype currentSubtype) {
            String subtypeId = NOT_A_SUBTYPE_ID_STR;
            if (currentSubtype != null) {
                subtypeId = String.valueOf(currentSubtype.hashCode());
            }
            if (InputMethodUtils.canAddToLastInputMethod(currentSubtype)) {
                this.addSubtypeToHistory(curMethodId, subtypeId);
            }
        }
    }
}

