/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.net.ConnectivityManager;
import android.net.NetworkStats;
import android.os.BatteryStats;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.telephony.SignalStrength;
import android.util.Log;
import android.util.LogWriter;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.JournaledFile;
import com.google.android.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatteryStatsImpl
extends BatteryStats {
    private static final String TAG = "BatteryStatsImpl";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_HISTORY = false;
    private static final boolean USE_OLD_HISTORY = false;
    private static final int MAGIC = -1166707595;
    private static final int VERSION = 67;
    private static final int MAX_HISTORY_ITEMS = 2000;
    private static final int MAX_MAX_HISTORY_ITEMS = 3000;
    private static final int MAX_WAKELOCKS_PER_UID = 50;
    private static final String BATCHED_WAKELOCK_NAME = "*overflow*";
    private static int sNumSpeedSteps;
    private final JournaledFile mFile;
    static final int MSG_UPDATE_WAKELOCKS = 1;
    static final int MSG_REPORT_POWER_CHANGE = 2;
    static final long DELAY_UPDATE_WAKELOCKS = 5000L;
    private final MyHandler mHandler;
    private BatteryCallback mCallback;
    final SparseArray<Uid> mUidStats = new SparseArray();
    final ArrayList<StopwatchTimer> mPartialTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFullTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWindowTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mSensorTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mWifiRunningTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFullWifiLockTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiMulticastTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiScanTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mWifiBatchedScanTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mLastPartialTimers = new ArrayList();
    final ArrayList<Unpluggable> mUnpluggables = new ArrayList();
    boolean mShuttingDown;
    long mHistoryBaseTime;
    boolean mHaveBatteryLevel = false;
    boolean mRecordingHistory = true;
    int mNumHistoryItems;
    static final int MAX_HISTORY_BUFFER = 131072;
    static final int MAX_MAX_HISTORY_BUFFER = 147456;
    final Parcel mHistoryBuffer = Parcel.obtain();
    final BatteryStats.HistoryItem mHistoryLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryLastLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryReadTmp = new BatteryStats.HistoryItem();
    int mHistoryBufferLastPos = -1;
    boolean mHistoryOverflow = false;
    long mLastHistoryTime = 0L;
    final BatteryStats.HistoryItem mHistoryCur = new BatteryStats.HistoryItem();
    BatteryStats.HistoryItem mHistory;
    BatteryStats.HistoryItem mHistoryEnd;
    BatteryStats.HistoryItem mHistoryLastEnd;
    BatteryStats.HistoryItem mHistoryCache;
    private BatteryStats.HistoryItem mHistoryIterator;
    private boolean mReadOverflow;
    private boolean mIteratingHistory;
    int mStartCount;
    long mBatteryUptime;
    long mBatteryLastUptime;
    long mBatteryRealtime;
    long mBatteryLastRealtime;
    long mUptime;
    long mUptimeStart;
    long mLastUptime;
    long mRealtime;
    long mRealtimeStart;
    long mLastRealtime;
    boolean mScreenOn;
    StopwatchTimer mScreenOnTimer;
    int mScreenBrightnessBin = -1;
    final StopwatchTimer[] mScreenBrightnessTimer = new StopwatchTimer[5];
    Counter mInputEventCounter;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    boolean mAudioOn;
    StopwatchTimer mAudioOnTimer;
    boolean mVideoOn;
    StopwatchTimer mVideoOnTimer;
    int mPhoneSignalStrengthBin = -1;
    int mPhoneSignalStrengthBinRaw = -1;
    final StopwatchTimer[] mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneDataConnectionType = -1;
    final StopwatchTimer[] mPhoneDataConnectionsTimer = new StopwatchTimer[17];
    final LongSamplingCounter[] mNetworkActivityCounters = new LongSamplingCounter[4];
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    int mWifiOnUid = -1;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    boolean mBluetoothOn;
    StopwatchTimer mBluetoothOnTimer;
    BluetoothHeadset mBtHeadset;
    boolean mOnBattery;
    boolean mOnBatteryInternal;
    long mTrackBatteryPastUptime;
    long mTrackBatteryUptimeStart;
    long mTrackBatteryPastRealtime;
    long mTrackBatteryRealtimeStart;
    long mUnpluggedBatteryUptime;
    long mUnpluggedBatteryRealtime;
    int mDischargeStartLevel;
    int mDischargeUnplugLevel;
    int mDischargeCurrentLevel;
    int mLowDischargeAmountSinceCharge;
    int mHighDischargeAmountSinceCharge;
    int mDischargeScreenOnUnplugLevel;
    int mDischargeScreenOffUnplugLevel;
    int mDischargeAmountScreenOn;
    int mDischargeAmountScreenOnSinceCharge;
    int mDischargeAmountScreenOff;
    int mDischargeAmountScreenOffSinceCharge;
    long mLastWriteTime = 0L;
    private long mRadioDataUptime;
    private long mRadioDataStart;
    private int mBluetoothPingCount;
    private int mBluetoothPingStart = -1;
    private int mPhoneServiceState = -1;
    private int mPhoneServiceStateRaw = -1;
    private int mPhoneSimStateRaw = -1;
    private final HashMap<String, SamplingTimer> mKernelWakelockStats = new HashMap();
    private static int sKernelWakelockUpdateVersion;
    private static final int[] PROC_WAKELOCKS_FORMAT;
    private static final int[] WAKEUP_SOURCES_FORMAT;
    private final String[] mProcWakelocksName = new String[3];
    private final long[] mProcWakelocksData = new long[3];
    private final Map<String, KernelWakelockStats> mProcWakelockFileStats = new HashMap<String, KernelWakelockStats>();
    private HashMap<String, Integer> mUidCache = new HashMap();
    private final NetworkStatsFactory mNetworkStatsFactory = new NetworkStatsFactory();
    private NetworkStats mLastSnapshot;
    @GuardedBy(value="this")
    private HashSet<String> mMobileIfaces = Sets.newHashSet();
    @GuardedBy(value="this")
    private HashSet<String> mWifiIfaces = Sets.newHashSet();
    int mChangedBufferStates = 0;
    int mChangedStates = 0;
    int mWakeLockNesting;
    int mSensorNesting;
    int mGpsNesting;
    int mWifiFullLockNesting = 0;
    int mWifiScanNesting = 0;
    int mWifiMulticastNesting = 0;
    private static final int BATTERY_PLUGGED_NONE = 0;
    Parcel mPendingWrite = null;
    final ReentrantLock mWriteLock = new ReentrantLock();
    public static final Parcelable.Creator<BatteryStatsImpl> CREATOR;

    public Map<String, ? extends SamplingTimer> getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    public BatteryStatsImpl() {
        this.mFile = null;
        this.mHandler = null;
    }

    private final Map<String, KernelWakelockStats> readKernelWakelockStats() {
        int len;
        byte[] buffer = new byte[8192];
        boolean wakeup_sources = false;
        try {
            FileInputStream is;
            try {
                is = new FileInputStream("/proc/wakelocks");
            }
            catch (FileNotFoundException e) {
                try {
                    is = new FileInputStream("/d/wakeup_sources");
                    wakeup_sources = true;
                }
                catch (FileNotFoundException e2) {
                    return null;
                }
            }
            len = is.read(buffer);
            is.close();
        }
        catch (IOException e) {
            return null;
        }
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (buffer[i] != 0) continue;
                len = i;
                break;
            }
        }
        return this.parseProcWakelocks(buffer, len, wakeup_sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, KernelWakelockStats> parseProcWakelocks(byte[] wlBuffer, int len, boolean wakeup_sources) {
        int endIndex;
        int i;
        int numUpdatedWlNames = 0;
        for (i = 0; i < len && wlBuffer[i] != 10 && wlBuffer[i] != 0; ++i) {
        }
        int startIndex = endIndex = i + 1;
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            Map<String, KernelWakelockStats> m = this.mProcWakelockFileStats;
            ++sKernelWakelockUpdateVersion;
            while (endIndex < len) {
                for (endIndex = startIndex; endIndex < len && wlBuffer[endIndex] != 10 && wlBuffer[endIndex] != 0; ++endIndex) {
                }
                if (++endIndex >= len - 1) {
                    return m;
                }
                String[] nameStringArray = this.mProcWakelocksName;
                long[] wlData = this.mProcWakelocksData;
                for (int j = startIndex; j < endIndex; ++j) {
                    if ((wlBuffer[j] & 0x80) == 0) continue;
                    wlBuffer[j] = 63;
                }
                boolean parsed = Process.parseProcLine(wlBuffer, startIndex, endIndex, wakeup_sources ? WAKEUP_SOURCES_FORMAT : PROC_WAKELOCKS_FORMAT, nameStringArray, wlData, null);
                String name = nameStringArray[0];
                int count = (int)wlData[1];
                long totalTime = wakeup_sources ? wlData[2] * 1000L : (wlData[2] + 500L) / 1000L;
                if (parsed && name.length() > 0) {
                    if (!m.containsKey(name)) {
                        m.put(name, new KernelWakelockStats(count, totalTime, sKernelWakelockUpdateVersion));
                        ++numUpdatedWlNames;
                    } else {
                        KernelWakelockStats kwlStats = m.get(name);
                        if (kwlStats.mVersion == sKernelWakelockUpdateVersion) {
                            kwlStats.mCount += count;
                            kwlStats.mTotalTime += totalTime;
                        } else {
                            kwlStats.mCount = count;
                            kwlStats.mTotalTime = totalTime;
                            kwlStats.mVersion = sKernelWakelockUpdateVersion;
                            ++numUpdatedWlNames;
                        }
                    }
                }
                startIndex = endIndex;
            }
            if (m.size() != numUpdatedWlNames) {
                Iterator<KernelWakelockStats> itr = m.values().iterator();
                while (itr.hasNext()) {
                    if (itr.next().mVersion == sKernelWakelockUpdateVersion) continue;
                    itr.remove();
                }
            }
            return m;
        }
    }

    public SamplingTimer getKernelWakelockTimerLocked(String name) {
        SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
        if (kwlt == null) {
            kwlt = new SamplingTimer(this.mUnpluggables, this.mOnBatteryInternal, true);
            this.mKernelWakelockStats.put(name, kwlt);
        }
        return kwlt;
    }

    private long getCurrentRadioDataUptime() {
        try {
            File awakeTimeFile = new File("/sys/devices/virtual/net/rmnet0/awake_time_ms");
            if (!awakeTimeFile.exists()) {
                return 0L;
            }
            BufferedReader br = new BufferedReader(new FileReader(awakeTimeFile));
            String line = br.readLine();
            br.close();
            return Long.parseLong(line) * 1000L;
        }
        catch (NumberFormatException nfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public long getRadioDataUptimeMs() {
        return this.getRadioDataUptime() / 1000L;
    }

    @Override
    public long getRadioDataUptime() {
        if (this.mRadioDataStart == -1L) {
            return this.mRadioDataUptime;
        }
        return this.getCurrentRadioDataUptime() - this.mRadioDataStart;
    }

    private int getCurrentBluetoothPingCount() {
        List<BluetoothDevice> deviceList;
        if (this.mBtHeadset != null && (deviceList = this.mBtHeadset.getConnectedDevices()).size() > 0) {
            return this.mBtHeadset.getBatteryUsageHint(deviceList.get(0));
        }
        return -1;
    }

    public int getBluetoothPingCount() {
        if (this.mBluetoothPingStart == -1) {
            return this.mBluetoothPingCount;
        }
        if (this.mBtHeadset != null) {
            return this.getCurrentBluetoothPingCount() - this.mBluetoothPingStart;
        }
        return 0;
    }

    public void setBtHeadset(BluetoothHeadset headset) {
        if (headset != null && this.mBtHeadset == null && this.isOnBattery() && this.mBluetoothPingStart == -1) {
            this.mBluetoothPingStart = this.getCurrentBluetoothPingCount();
        }
        this.mBtHeadset = headset;
    }

    void addHistoryBufferLocked(long curTime) {
        if (!this.mHaveBatteryLevel || !this.mRecordingHistory) {
            return;
        }
        long timeDiff = this.mHistoryBaseTime + curTime - this.mHistoryLastWritten.time;
        if (this.mHistoryBufferLastPos >= 0 && this.mHistoryLastWritten.cmd == 1 && timeDiff < 2000L && ((this.mHistoryLastWritten.states ^ this.mHistoryCur.states) & this.mChangedBufferStates) == 0) {
            this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
            this.mHistoryBufferLastPos = -1;
            if (this.mHistoryLastLastWritten.cmd == 1 && timeDiff < 500L && this.mHistoryLastLastWritten.same(this.mHistoryCur)) {
                this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
                this.mHistoryLastLastWritten.cmd = 0;
                return;
            }
            this.mChangedBufferStates |= this.mHistoryLastWritten.states ^ this.mHistoryCur.states;
            curTime = this.mHistoryLastWritten.time - this.mHistoryBaseTime;
            this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
        } else {
            this.mChangedBufferStates = 0;
        }
        int dataSize = this.mHistoryBuffer.dataSize();
        if (dataSize >= 131072) {
            if (!this.mHistoryOverflow) {
                this.mHistoryOverflow = true;
                this.addHistoryBufferLocked(curTime, (byte)3);
            }
            if (this.mHistoryLastWritten.batteryLevel == this.mHistoryCur.batteryLevel && (dataSize >= 147456 || ((this.mHistoryLastWritten.states ^ this.mHistoryCur.states) & 0x101C0000) == 0)) {
                return;
            }
        }
        this.addHistoryBufferLocked(curTime, (byte)1);
    }

    void addHistoryBufferLocked(long curTime, byte cmd) {
        int origPos = 0;
        if (this.mIteratingHistory) {
            origPos = this.mHistoryBuffer.dataPosition();
            this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        this.mHistoryLastWritten.setTo(this.mHistoryBaseTime + curTime, cmd, this.mHistoryCur);
        this.mHistoryLastWritten.writeDelta(this.mHistoryBuffer, this.mHistoryLastLastWritten);
        this.mLastHistoryTime = curTime;
        if (this.mIteratingHistory) {
            this.mHistoryBuffer.setDataPosition(origPos);
        }
    }

    void addHistoryRecordLocked(long curTime) {
        this.addHistoryBufferLocked(curTime);
    }

    void addHistoryRecordLocked(long curTime, byte cmd) {
        BatteryStats.HistoryItem rec = this.mHistoryCache;
        if (rec != null) {
            this.mHistoryCache = rec.next;
        } else {
            rec = new BatteryStats.HistoryItem();
        }
        rec.setTo(this.mHistoryBaseTime + curTime, cmd, this.mHistoryCur);
        this.addHistoryRecordLocked(rec);
    }

    void addHistoryRecordLocked(BatteryStats.HistoryItem rec) {
        ++this.mNumHistoryItems;
        rec.next = null;
        this.mHistoryLastEnd = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = rec;
            this.mHistoryEnd = rec;
        } else {
            this.mHistory = this.mHistoryEnd = rec;
        }
    }

    void clearHistoryLocked() {
        this.mHistoryBaseTime = 0L;
        this.mLastHistoryTime = 0L;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(65536);
        this.mHistoryLastLastWritten.cmd = 0;
        this.mHistoryLastWritten.cmd = 0;
        this.mHistoryBufferLastPos = -1;
        this.mHistoryOverflow = false;
    }

    public void doUnplugLocked(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
        for (int i = this.mUnpluggables.size() - 1; i >= 0; --i) {
            this.mUnpluggables.get(i).unplug(elapsedRealtime, batteryUptime, batteryRealtime);
        }
        this.mRadioDataStart = this.getCurrentRadioDataUptime();
        this.mRadioDataUptime = 0L;
        this.mBluetoothPingStart = this.getCurrentBluetoothPingCount();
        this.mBluetoothPingCount = 0;
    }

    public void doPlugLocked(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
        for (int i = this.mUnpluggables.size() - 1; i >= 0; --i) {
            this.mUnpluggables.get(i).plug(elapsedRealtime, batteryUptime, batteryRealtime);
        }
        this.mRadioDataUptime = this.getRadioDataUptime();
        this.mRadioDataStart = -1L;
        this.mBluetoothPingCount = this.getBluetoothPingCount();
        this.mBluetoothPingStart = -1;
    }

    public void noteStartWakeLocked(int uid, int pid, String name, int type) {
        if (type == 0) {
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states |= 0x40000000;
                this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            }
            ++this.mWakeLockNesting;
        }
        if (uid >= 0) {
            if (!this.mHandler.hasMessages(1)) {
                Message m = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(m, 5000L);
            }
            this.getUidStatsLocked(uid).noteStartWakeLocked(pid, name, type);
        }
    }

    public void noteStopWakeLocked(int uid, int pid, String name, int type) {
        if (type == 0) {
            --this.mWakeLockNesting;
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states &= 0xBFFFFFFF;
                this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            }
        }
        if (uid >= 0) {
            if (!this.mHandler.hasMessages(1)) {
                Message m = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(m, 5000L);
            }
            this.getUidStatsLocked(uid).noteStopWakeLocked(pid, name, type);
        }
    }

    public void noteStartWakeFromSourceLocked(WorkSource ws, int pid, String name, int type) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStartWakeLocked(ws.get(i), pid, name, type);
        }
    }

    public void noteStopWakeFromSourceLocked(WorkSource ws, int pid, String name, int type) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStopWakeLocked(ws.get(i), pid, name, type);
        }
    }

    public int startAddingCpuLocked() {
        this.mHandler.removeMessages(1);
        if (this.mScreenOn) {
            return 0;
        }
        int N = this.mPartialTimers.size();
        if (N == 0) {
            this.mLastPartialTimers.clear();
            return 0;
        }
        for (int i = 0; i < N; ++i) {
            Uid uid;
            StopwatchTimer st = this.mPartialTimers.get(i);
            if (!st.mInList || (uid = st.mUid) == null || uid.mUid == 1000) continue;
            return 50;
        }
        return 0;
    }

    public void finishAddingCpuLocked(int perc, int utime, int stime, long[] cpuSpeedTimes) {
        int i;
        int NL;
        int N = this.mPartialTimers.size();
        if (perc != 0) {
            Uid uid;
            Uid uid2;
            StopwatchTimer st;
            int i2;
            int num = 0;
            for (i2 = 0; i2 < N; ++i2) {
                st = this.mPartialTimers.get(i2);
                if (!st.mInList || (uid2 = st.mUid) == null || uid2.mUid == 1000) continue;
                ++num;
            }
            if (num != 0) {
                for (i2 = 0; i2 < N; ++i2) {
                    st = this.mPartialTimers.get(i2);
                    if (!st.mInList || (uid2 = st.mUid) == null || uid2.mUid == 1000) continue;
                    int myUTime = utime / num;
                    int mySTime = stime / num;
                    utime -= myUTime;
                    stime -= mySTime;
                    --num;
                    Uid.Proc proc = uid2.getProcessStatsLocked("*wakelock*");
                    proc.addCpuTimeLocked(myUTime, mySTime);
                    proc.addSpeedStepTimes(cpuSpeedTimes);
                }
            }
            if ((utime != 0 || stime != 0) && (uid = this.getUidStatsLocked(1000)) != null) {
                Uid.Proc proc = uid.getProcessStatsLocked("*lost*");
                proc.addCpuTimeLocked(utime, stime);
                proc.addSpeedStepTimes(cpuSpeedTimes);
            }
        }
        boolean diff = N != (NL = this.mLastPartialTimers.size());
        for (i = 0; i < NL && !diff; diff |= this.mPartialTimers.get(i) != this.mLastPartialTimers.get(i), ++i) {
        }
        if (!diff) {
            for (i = 0; i < NL; ++i) {
                this.mPartialTimers.get((int)i).mInList = true;
            }
            return;
        }
        for (i = 0; i < NL; ++i) {
            this.mLastPartialTimers.get((int)i).mInList = false;
        }
        this.mLastPartialTimers.clear();
        for (i = 0; i < N; ++i) {
            StopwatchTimer st = this.mPartialTimers.get(i);
            st.mInList = true;
            this.mLastPartialTimers.add(st);
        }
    }

    public void noteProcessDiedLocked(int uid, int pid) {
        Uid u = this.mUidStats.get(uid);
        if (u != null) {
            u.mPids.remove(pid);
        }
    }

    public long getProcessWakeTime(int uid, int pid, long realtime) {
        BatteryStats.Uid.Pid p;
        Uid u = this.mUidStats.get(uid);
        if (u != null && (p = u.mPids.get(pid)) != null) {
            return p.mWakeSum + (p.mWakeStart != 0L ? realtime - p.mWakeStart : 0L);
        }
        return 0L;
    }

    public void reportExcessiveWakeLocked(int uid, String proc, long overTime, long usedTime) {
        Uid u = this.mUidStats.get(uid);
        if (u != null) {
            u.reportExcessiveWakeLocked(proc, overTime, usedTime);
        }
    }

    public void reportExcessiveCpuLocked(int uid, String proc, long overTime, long usedTime) {
        Uid u = this.mUidStats.get(uid);
        if (u != null) {
            u.reportExcessiveCpuLocked(proc, overTime, usedTime);
        }
    }

    public void noteStartSensorLocked(int uid, int sensor) {
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states |= 0x20000000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        ++this.mSensorNesting;
        this.getUidStatsLocked(uid).noteStartSensor(sensor);
    }

    public void noteStopSensorLocked(int uid, int sensor) {
        --this.mSensorNesting;
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(uid).noteStopSensor(sensor);
    }

    public void noteStartGpsLocked(int uid) {
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states |= 0x10000000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        ++this.mGpsNesting;
        this.getUidStatsLocked(uid).noteStartGps();
    }

    public void noteStopGpsLocked(int uid) {
        --this.mGpsNesting;
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(uid).noteStopGps();
    }

    public void noteScreenOnLocked() {
        if (!this.mScreenOn) {
            this.mHistoryCur.states |= 0x100000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mScreenOn = true;
            this.mScreenOnTimer.startRunningLocked(this);
            if (this.mScreenBrightnessBin >= 0) {
                this.mScreenBrightnessTimer[this.mScreenBrightnessBin].startRunningLocked(this);
            }
            this.noteStartWakeLocked(-1, -1, "dummy", 0);
            if (this.mOnBatteryInternal) {
                this.updateDischargeScreenLevelsLocked(false, true);
            }
        }
    }

    public void noteScreenOffLocked() {
        if (this.mScreenOn) {
            this.mHistoryCur.states &= 0xFFEFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mScreenOn = false;
            this.mScreenOnTimer.stopRunningLocked(this);
            if (this.mScreenBrightnessBin >= 0) {
                this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(this);
            }
            this.noteStopWakeLocked(-1, -1, "dummy", 0);
            if (this.mOnBatteryInternal) {
                this.updateDischargeScreenLevelsLocked(true, false);
            }
        }
    }

    public void noteScreenBrightnessLocked(int brightness) {
        int bin = brightness / 51;
        if (bin < 0) {
            bin = 0;
        } else if (bin >= 5) {
            bin = 4;
        }
        if (this.mScreenBrightnessBin != bin) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFF0 | bin << 0;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            if (this.mScreenOn) {
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(this);
                }
                this.mScreenBrightnessTimer[bin].startRunningLocked(this);
            }
            this.mScreenBrightnessBin = bin;
        }
    }

    public void noteInputEventAtomic() {
        this.mInputEventCounter.stepAtomic();
    }

    public void noteUserActivityLocked(int uid, int event) {
        this.getUidStatsLocked(uid).noteUserActivityLocked(event);
    }

    public void notePhoneOnLocked() {
        if (!this.mPhoneOn) {
            this.mHistoryCur.states |= 0x40000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mPhoneOn = true;
            this.mPhoneOnTimer.startRunningLocked(this);
        }
    }

    public void notePhoneOffLocked() {
        if (this.mPhoneOn) {
            this.mHistoryCur.states &= 0xFFFBFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mPhoneOn = false;
            this.mPhoneOnTimer.stopRunningLocked(this);
        }
    }

    void stopAllSignalStrengthTimersLocked(int except) {
        for (int i = 0; i < 5; ++i) {
            if (i == except) continue;
            while (this.mPhoneSignalStrengthsTimer[i].isRunningLocked()) {
                this.mPhoneSignalStrengthsTimer[i].stopRunningLocked(this);
            }
        }
    }

    private int fixPhoneServiceState(int state, int signalBin) {
        if (this.mPhoneSimStateRaw == 1 && state == 1 && signalBin > 0) {
            state = 0;
        }
        return state;
    }

    private void updateAllPhoneStateLocked(int state, int simState, int bin) {
        boolean scanning = false;
        boolean newHistory = false;
        this.mPhoneServiceStateRaw = state;
        this.mPhoneSimStateRaw = simState;
        this.mPhoneSignalStrengthBinRaw = bin;
        if (simState == 1 && state == 1 && bin > 0) {
            state = 0;
        }
        if (state == 3) {
            bin = -1;
        } else if (state != 0 && state == 1) {
            scanning = true;
            bin = 0;
            if (!this.mPhoneSignalScanningTimer.isRunningLocked()) {
                this.mHistoryCur.states |= 0x8000000;
                newHistory = true;
                this.mPhoneSignalScanningTimer.startRunningLocked(this);
            }
        }
        if (!scanning && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            this.mHistoryCur.states &= 0xF7FFFFFF;
            newHistory = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(this);
        }
        if (this.mPhoneServiceState != state) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFF0FF | state << 8;
            newHistory = true;
            this.mPhoneServiceState = state;
        }
        if (this.mPhoneSignalStrengthBin != bin) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                this.mPhoneSignalStrengthsTimer[this.mPhoneSignalStrengthBin].stopRunningLocked(this);
            }
            if (bin >= 0) {
                if (!this.mPhoneSignalStrengthsTimer[bin].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[bin].startRunningLocked(this);
                }
                this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFF0F | bin << 4;
                newHistory = true;
            } else {
                this.stopAllSignalStrengthTimersLocked(-1);
            }
            this.mPhoneSignalStrengthBin = bin;
        }
        if (newHistory) {
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
    }

    public void notePhoneStateLocked(int state, int simState) {
        this.updateAllPhoneStateLocked(state, simState, this.mPhoneSignalStrengthBinRaw);
    }

    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        int bin = signalStrength.getLevel();
        this.updateAllPhoneStateLocked(this.mPhoneServiceStateRaw, this.mPhoneSimStateRaw, bin);
    }

    public void notePhoneDataConnectionStateLocked(int dataType, boolean hasData) {
        int bin = 0;
        if (hasData) {
            switch (dataType) {
                case 2: {
                    bin = 2;
                    break;
                }
                case 1: {
                    bin = 1;
                    break;
                }
                case 3: {
                    bin = 3;
                    break;
                }
                case 4: {
                    bin = 4;
                    break;
                }
                case 5: {
                    bin = 5;
                    break;
                }
                case 6: {
                    bin = 6;
                    break;
                }
                case 7: {
                    bin = 7;
                    break;
                }
                case 8: {
                    bin = 8;
                    break;
                }
                case 9: {
                    bin = 9;
                    break;
                }
                case 10: {
                    bin = 10;
                    break;
                }
                case 11: {
                    bin = 11;
                    break;
                }
                case 12: {
                    bin = 12;
                    break;
                }
                case 13: {
                    bin = 13;
                    break;
                }
                case 14: {
                    bin = 14;
                    break;
                }
                case 15: {
                    bin = 15;
                    break;
                }
                default: {
                    bin = 16;
                }
            }
        }
        if (this.mPhoneDataConnectionType != bin) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFF0FFF | bin << 12;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            if (this.mPhoneDataConnectionType >= 0) {
                this.mPhoneDataConnectionsTimer[this.mPhoneDataConnectionType].stopRunningLocked(this);
            }
            this.mPhoneDataConnectionType = bin;
            this.mPhoneDataConnectionsTimer[bin].startRunningLocked(this);
        }
    }

    public void noteWifiOnLocked() {
        if (!this.mWifiOn) {
            this.mHistoryCur.states |= 0x20000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mWifiOn = true;
            this.mWifiOnTimer.startRunningLocked(this);
        }
    }

    public void noteWifiOffLocked() {
        if (this.mWifiOn) {
            this.mHistoryCur.states &= 0xFFFDFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(this);
        }
        if (this.mWifiOnUid >= 0) {
            this.getUidStatsLocked(this.mWifiOnUid).noteWifiStoppedLocked();
            this.mWifiOnUid = -1;
        }
    }

    public void noteAudioOnLocked(int uid) {
        if (!this.mAudioOn) {
            this.mHistoryCur.states |= 0x400000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mAudioOn = true;
            this.mAudioOnTimer.startRunningLocked(this);
        }
        this.getUidStatsLocked(uid).noteAudioTurnedOnLocked();
    }

    public void noteAudioOffLocked(int uid) {
        if (this.mAudioOn) {
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mAudioOn = false;
            this.mAudioOnTimer.stopRunningLocked(this);
        }
        this.getUidStatsLocked(uid).noteAudioTurnedOffLocked();
    }

    public void noteVideoOnLocked(int uid) {
        if (!this.mVideoOn) {
            this.mHistoryCur.states |= 0x200000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mVideoOn = true;
            this.mVideoOnTimer.startRunningLocked(this);
        }
        this.getUidStatsLocked(uid).noteVideoTurnedOnLocked();
    }

    public void noteVideoOffLocked(int uid) {
        if (this.mVideoOn) {
            this.mHistoryCur.states &= 0xFFDFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mVideoOn = false;
            this.mVideoOnTimer.stopRunningLocked(this);
        }
        this.getUidStatsLocked(uid).noteVideoTurnedOffLocked();
    }

    public void noteActivityResumedLocked(int uid) {
        this.getUidStatsLocked(uid).noteActivityResumedLocked();
    }

    public void noteActivityPausedLocked(int uid) {
        this.getUidStatsLocked(uid).noteActivityPausedLocked();
    }

    public void noteVibratorOnLocked(int uid, long durationMillis) {
        this.getUidStatsLocked(uid).noteVibratorOnLocked(durationMillis);
    }

    public void noteVibratorOffLocked(int uid) {
        this.getUidStatsLocked(uid).noteVibratorOffLocked();
    }

    public void noteWifiRunningLocked(WorkSource ws) {
        if (!this.mGlobalWifiRunning) {
            this.mHistoryCur.states |= 0x4000000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(this);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                this.getUidStatsLocked(ws.get(i)).noteWifiRunningLocked();
            }
        } else {
            Log.w(TAG, "noteWifiRunningLocked -- called while WIFI running");
        }
    }

    public void noteWifiRunningChangedLocked(WorkSource oldWs, WorkSource newWs) {
        if (this.mGlobalWifiRunning) {
            int i;
            int N = oldWs.size();
            for (i = 0; i < N; ++i) {
                this.getUidStatsLocked(oldWs.get(i)).noteWifiStoppedLocked();
            }
            N = newWs.size();
            for (i = 0; i < N; ++i) {
                this.getUidStatsLocked(newWs.get(i)).noteWifiRunningLocked();
            }
        } else {
            Log.w(TAG, "noteWifiRunningChangedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiStoppedLocked(WorkSource ws) {
        if (this.mGlobalWifiRunning) {
            this.mHistoryCur.states &= 0xFBFFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(this);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                this.getUidStatsLocked(ws.get(i)).noteWifiStoppedLocked();
            }
        } else {
            Log.w(TAG, "noteWifiStoppedLocked -- called while WIFI not running");
        }
    }

    public void noteBluetoothOnLocked() {
        if (!this.mBluetoothOn) {
            this.mHistoryCur.states |= 0x10000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mBluetoothOn = true;
            this.mBluetoothOnTimer.startRunningLocked(this);
        }
    }

    public void noteBluetoothOffLocked() {
        if (this.mBluetoothOn) {
            this.mHistoryCur.states &= 0xFFFEFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mBluetoothOn = false;
            this.mBluetoothOnTimer.stopRunningLocked(this);
        }
    }

    public void noteFullWifiLockAcquiredLocked(int uid) {
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states |= 0x2000000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        ++this.mWifiFullLockNesting;
        this.getUidStatsLocked(uid).noteFullWifiLockAcquiredLocked();
    }

    public void noteFullWifiLockReleasedLocked(int uid) {
        --this.mWifiFullLockNesting;
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states &= 0xFDFFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(uid).noteFullWifiLockReleasedLocked();
    }

    public void noteWifiScanStartedLocked(int uid) {
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states |= 0x1000000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        ++this.mWifiScanNesting;
        this.getUidStatsLocked(uid).noteWifiScanStartedLocked();
    }

    public void noteWifiScanStoppedLocked(int uid) {
        --this.mWifiScanNesting;
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states &= 0xFEFFFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(uid).noteWifiScanStoppedLocked();
    }

    public void noteWifiBatchedScanStartedLocked(int uid, int csph) {
        this.getUidStatsLocked(uid).noteWifiBatchedScanStartedLocked(csph);
    }

    public void noteWifiBatchedScanStoppedLocked(int uid) {
        this.getUidStatsLocked(uid).noteWifiBatchedScanStoppedLocked();
    }

    public void noteWifiMulticastEnabledLocked(int uid) {
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states |= 0x800000;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        ++this.mWifiMulticastNesting;
        this.getUidStatsLocked(uid).noteWifiMulticastEnabledLocked();
    }

    public void noteWifiMulticastDisabledLocked(int uid) {
        --this.mWifiMulticastNesting;
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(uid).noteWifiMulticastDisabledLocked();
    }

    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteFullWifiLockAcquiredLocked(ws.get(i));
        }
    }

    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteFullWifiLockReleasedLocked(ws.get(i));
        }
    }

    public void noteWifiScanStartedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiScanStartedLocked(ws.get(i));
        }
    }

    public void noteWifiScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiScanStoppedLocked(ws.get(i));
        }
    }

    public void noteWifiBatchedScanStartedFromSourceLocked(WorkSource ws, int csph) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStartedLocked(ws.get(i), csph);
        }
    }

    public void noteWifiBatchedScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStoppedLocked(ws.get(i));
        }
    }

    public void noteWifiMulticastEnabledFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiMulticastEnabledLocked(ws.get(i));
        }
    }

    public void noteWifiMulticastDisabledFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiMulticastDisabledLocked(ws.get(i));
        }
    }

    public void noteNetworkInterfaceTypeLocked(String iface, int networkType) {
        if (ConnectivityManager.isNetworkTypeMobile(networkType)) {
            this.mMobileIfaces.add(iface);
        } else {
            this.mMobileIfaces.remove(iface);
        }
        if (ConnectivityManager.isNetworkTypeWifi(networkType)) {
            this.mWifiIfaces.add(iface);
        } else {
            this.mWifiIfaces.remove(iface);
        }
    }

    public void noteNetworkStatsEnabledLocked() {
        this.updateNetworkActivityLocked();
    }

    @Override
    public long getScreenOnTime(long batteryRealtime, int which) {
        return this.mScreenOnTimer.getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public long getScreenBrightnessTime(int brightnessBin, long batteryRealtime, int which) {
        return this.mScreenBrightnessTimer[brightnessBin].getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public int getInputEventCount(int which) {
        return this.mInputEventCounter.getCountLocked(which);
    }

    @Override
    public long getPhoneOnTime(long batteryRealtime, int which) {
        return this.mPhoneOnTimer.getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public long getPhoneSignalStrengthTime(int strengthBin, long batteryRealtime, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public long getPhoneSignalScanningTime(long batteryRealtime, int which) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public int getPhoneSignalStrengthCount(int strengthBin, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    @Override
    public long getPhoneDataConnectionTime(int dataType, long batteryRealtime, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public int getPhoneDataConnectionCount(int dataType, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getCountLocked(which);
    }

    @Override
    public long getWifiOnTime(long batteryRealtime, int which) {
        return this.mWifiOnTimer.getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public long getGlobalWifiRunningTime(long batteryRealtime, int which) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public long getBluetoothOnTime(long batteryRealtime, int which) {
        return this.mBluetoothOnTimer.getTotalTimeLocked(batteryRealtime, which);
    }

    @Override
    public long getNetworkActivityCount(int type, int which) {
        if (type >= 0 && type < this.mNetworkActivityCounters.length) {
            return this.mNetworkActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public boolean getIsOnBattery() {
        return this.mOnBattery;
    }

    @Override
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return this.mUidStats;
    }

    public BatteryStatsImpl(String filename) {
        int i;
        this.mFile = new JournaledFile(new File(filename), new File(filename + ".tmp"));
        this.mHandler = new MyHandler();
        ++this.mStartCount;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mUnpluggables);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mUnpluggables);
        }
        this.mInputEventCounter = new Counter(this.mUnpluggables);
        this.mPhoneOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mUnpluggables);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mUnpluggables);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mUnpluggables);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkActivityCounters[i] = new LongSamplingCounter(this.mUnpluggables);
        }
        this.mWifiOnTimer = new StopwatchTimer(null, -3, null, this.mUnpluggables);
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -4, null, this.mUnpluggables);
        this.mBluetoothOnTimer = new StopwatchTimer(null, -5, null, this.mUnpluggables);
        this.mAudioOnTimer = new StopwatchTimer(null, -6, null, this.mUnpluggables);
        this.mVideoOnTimer = new StopwatchTimer(null, -7, null, this.mUnpluggables);
        this.mOnBatteryInternal = false;
        this.mOnBattery = false;
        this.initTimes();
        this.mTrackBatteryPastUptime = 0L;
        this.mTrackBatteryPastRealtime = 0L;
        this.mUptimeStart = this.mTrackBatteryUptimeStart = SystemClock.uptimeMillis() * 1000L;
        this.mRealtimeStart = this.mTrackBatteryRealtimeStart = SystemClock.elapsedRealtime() * 1000L;
        this.mUnpluggedBatteryUptime = this.getBatteryUptimeLocked(this.mUptimeStart);
        this.mUnpluggedBatteryRealtime = this.getBatteryRealtimeLocked(this.mRealtimeStart);
        this.mDischargeStartLevel = 0;
        this.mDischargeUnplugLevel = 0;
        this.mDischargeCurrentLevel = 0;
        this.initDischarge();
        this.clearHistoryLocked();
    }

    public BatteryStatsImpl(Parcel p) {
        this.mFile = null;
        this.mHandler = null;
        this.clearHistoryLocked();
        this.readFromParcel(p);
    }

    public void setCallback(BatteryCallback cb) {
        this.mCallback = cb;
    }

    public void setNumSpeedSteps(int steps) {
        if (sNumSpeedSteps == 0) {
            sNumSpeedSteps = steps;
        }
    }

    public void setRadioScanningTimeout(long timeout) {
        if (this.mPhoneSignalScanningTimer != null) {
            this.mPhoneSignalScanningTimer.setTimeout(timeout);
        }
    }

    @Override
    public boolean startIteratingOldHistoryLocked() {
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryReadTmp.clear();
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        this.mHistoryIterator = this.mHistory;
        return this.mHistoryIterator != null;
    }

    @Override
    public boolean getNextOldHistoryLocked(BatteryStats.HistoryItem out) {
        BatteryStats.HistoryItem cur;
        boolean end;
        boolean bl = end = this.mHistoryBuffer.dataPosition() >= this.mHistoryBuffer.dataSize();
        if (!end) {
            this.mHistoryReadTmp.readDelta(this.mHistoryBuffer);
            this.mReadOverflow |= this.mHistoryReadTmp.cmd == 3;
        }
        if ((cur = this.mHistoryIterator) == null) {
            if (!this.mReadOverflow && !end) {
                Slog.w(TAG, "Old history ends before new history!");
            }
            return false;
        }
        out.setTo(cur);
        this.mHistoryIterator = cur.next;
        if (!this.mReadOverflow) {
            if (end) {
                Slog.w(TAG, "New history ends before old history!");
            } else if (!out.same(this.mHistoryReadTmp)) {
                long now = this.getHistoryBaseTime() + SystemClock.elapsedRealtime();
                FastPrintWriter pw = new FastPrintWriter(new LogWriter(5, TAG));
                pw.println("Histories differ!");
                pw.println("Old history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, out, now);
                pw.println("New history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, this.mHistoryReadTmp, now);
                ((PrintWriter)pw).flush();
            }
        }
        return true;
    }

    @Override
    public void finishIteratingOldHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
    }

    @Override
    public boolean startIteratingHistoryLocked() {
        this.mHistoryBuffer.setDataPosition(0);
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        return this.mHistoryBuffer.dataSize() > 0;
    }

    @Override
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem out) {
        boolean end;
        int pos = this.mHistoryBuffer.dataPosition();
        if (pos == 0) {
            out.clear();
        }
        boolean bl = end = pos >= this.mHistoryBuffer.dataSize();
        if (end) {
            return false;
        }
        out.readDelta(this.mHistoryBuffer);
        return true;
    }

    @Override
    public void finishIteratingHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
    }

    @Override
    public long getHistoryBaseTime() {
        return this.mHistoryBaseTime;
    }

    @Override
    public int getStartCount() {
        return this.mStartCount;
    }

    public boolean isOnBattery() {
        return this.mOnBattery;
    }

    public boolean isScreenOn() {
        return this.mScreenOn;
    }

    void initTimes() {
        this.mTrackBatteryPastUptime = 0L;
        this.mBatteryRealtime = 0L;
        this.mTrackBatteryPastRealtime = 0L;
        this.mBatteryUptime = 0L;
        this.mUptimeStart = this.mTrackBatteryUptimeStart = SystemClock.uptimeMillis() * 1000L;
        this.mRealtimeStart = this.mTrackBatteryRealtimeStart = SystemClock.elapsedRealtime() * 1000L;
        this.mUnpluggedBatteryUptime = this.getBatteryUptimeLocked(this.mUptimeStart);
        this.mUnpluggedBatteryRealtime = this.getBatteryRealtimeLocked(this.mRealtimeStart);
    }

    void initDischarge() {
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.mDischargeAmountScreenOn = 0;
        this.mDischargeAmountScreenOnSinceCharge = 0;
        this.mDischargeAmountScreenOff = 0;
        this.mDischargeAmountScreenOffSinceCharge = 0;
    }

    public void resetAllStatsLocked() {
        int i;
        this.mStartCount = 0;
        this.initTimes();
        this.mScreenOnTimer.reset(this, false);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].reset(this, false);
        }
        this.mInputEventCounter.reset(false);
        this.mPhoneOnTimer.reset(this, false);
        this.mAudioOnTimer.reset(this, false);
        this.mVideoOnTimer.reset(this, false);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].reset(this, false);
        }
        this.mPhoneSignalScanningTimer.reset(this, false);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].reset(this, false);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkActivityCounters[i].reset(false);
        }
        this.mWifiOnTimer.reset(this, false);
        this.mGlobalWifiRunningTimer.reset(this, false);
        this.mBluetoothOnTimer.reset(this, false);
        for (i = 0; i < this.mUidStats.size(); ++i) {
            if (!this.mUidStats.valueAt(i).reset()) continue;
            this.mUidStats.remove(this.mUidStats.keyAt(i));
            --i;
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer timer : this.mKernelWakelockStats.values()) {
                this.mUnpluggables.remove(timer);
            }
            this.mKernelWakelockStats.clear();
        }
        this.initDischarge();
        this.clearHistoryLocked();
    }

    void updateDischargeScreenLevelsLocked(boolean oldScreenOn, boolean newScreenOn) {
        if (oldScreenOn) {
            int diff = this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            if (diff > 0) {
                this.mDischargeAmountScreenOn += diff;
                this.mDischargeAmountScreenOnSinceCharge += diff;
            }
        } else {
            int diff = this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            if (diff > 0) {
                this.mDischargeAmountScreenOff += diff;
                this.mDischargeAmountScreenOffSinceCharge += diff;
            }
        }
        if (newScreenOn) {
            this.mDischargeScreenOnUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
        } else {
            this.mDischargeScreenOnUnplugLevel = 0;
            this.mDischargeScreenOffUnplugLevel = this.mDischargeCurrentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnBattery(boolean onBattery, int oldStatus, int level) {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            this.setOnBatteryLocked(onBattery, oldStatus, level);
        }
    }

    void setOnBatteryLocked(boolean onBattery, int oldStatus, int level) {
        boolean doWrite = false;
        Message m = this.mHandler.obtainMessage(2);
        m.arg1 = onBattery ? 1 : 0;
        this.mHandler.sendMessage(m);
        this.mOnBattery = this.mOnBatteryInternal = onBattery;
        long uptime = SystemClock.uptimeMillis() * 1000L;
        long mSecRealtime = SystemClock.elapsedRealtime();
        long realtime = mSecRealtime * 1000L;
        if (onBattery) {
            if (oldStatus == 5 || level >= 90 || this.mDischargeCurrentLevel < 20 && level >= 80) {
                doWrite = true;
                this.resetAllStatsLocked();
                this.mDischargeStartLevel = level;
            }
            this.updateKernelWakelocksLocked();
            this.updateNetworkActivityLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states &= 0xFFF7FFFF;
            this.addHistoryRecordLocked(mSecRealtime);
            this.mTrackBatteryUptimeStart = uptime;
            this.mTrackBatteryRealtimeStart = realtime;
            this.mUnpluggedBatteryUptime = this.getBatteryUptimeLocked(uptime);
            this.mUnpluggedBatteryRealtime = this.getBatteryRealtimeLocked(realtime);
            this.mDischargeCurrentLevel = this.mDischargeUnplugLevel = level;
            if (this.mScreenOn) {
                this.mDischargeScreenOnUnplugLevel = level;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = level;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
            this.doUnplugLocked(realtime, this.mUnpluggedBatteryUptime, this.mUnpluggedBatteryRealtime);
        } else {
            this.updateKernelWakelocksLocked();
            this.updateNetworkActivityLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states |= 0x80000;
            this.addHistoryRecordLocked(mSecRealtime);
            this.mTrackBatteryPastUptime += uptime - this.mTrackBatteryUptimeStart;
            this.mTrackBatteryPastRealtime += realtime - this.mTrackBatteryRealtimeStart;
            this.mDischargeCurrentLevel = level;
            if (level < this.mDischargeUnplugLevel) {
                this.mLowDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level - 1;
                this.mHighDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level;
            }
            this.updateDischargeScreenLevelsLocked(this.mScreenOn, this.mScreenOn);
            this.doPlugLocked(realtime, this.getBatteryUptimeLocked(uptime), this.getBatteryRealtimeLocked(realtime));
        }
        if ((doWrite || this.mLastWriteTime + 60000L < mSecRealtime) && this.mFile != null) {
            this.writeAsyncLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatteryState(int status, int health, int plugType, int level, int temp, int volt) {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            boolean onBattery = plugType == 0;
            int oldStatus = this.mHistoryCur.batteryStatus;
            if (!this.mHaveBatteryLevel) {
                this.mHaveBatteryLevel = true;
                if (onBattery == this.mOnBattery) {
                    this.mHistoryCur.states = onBattery ? (this.mHistoryCur.states &= 0xFFF7FFFF) : (this.mHistoryCur.states |= 0x80000);
                }
                oldStatus = status;
            }
            if (onBattery) {
                this.mDischargeCurrentLevel = level;
                this.mRecordingHistory = true;
            }
            if (onBattery != this.mOnBattery) {
                this.mHistoryCur.batteryLevel = (byte)level;
                this.mHistoryCur.batteryStatus = (byte)status;
                this.mHistoryCur.batteryHealth = (byte)health;
                this.mHistoryCur.batteryPlugType = (byte)plugType;
                this.mHistoryCur.batteryTemperature = (short)temp;
                this.mHistoryCur.batteryVoltage = (char)volt;
                this.setOnBatteryLocked(onBattery, oldStatus, level);
            } else {
                boolean changed = false;
                if (this.mHistoryCur.batteryLevel != level) {
                    this.mHistoryCur.batteryLevel = (byte)level;
                    changed = true;
                }
                if (this.mHistoryCur.batteryStatus != status) {
                    this.mHistoryCur.batteryStatus = (byte)status;
                    changed = true;
                }
                if (this.mHistoryCur.batteryHealth != health) {
                    this.mHistoryCur.batteryHealth = (byte)health;
                    changed = true;
                }
                if (this.mHistoryCur.batteryPlugType != plugType) {
                    this.mHistoryCur.batteryPlugType = (byte)plugType;
                    changed = true;
                }
                if (temp >= this.mHistoryCur.batteryTemperature + 10 || temp <= this.mHistoryCur.batteryTemperature - 10) {
                    this.mHistoryCur.batteryTemperature = (short)temp;
                    changed = true;
                }
                if (volt > this.mHistoryCur.batteryVoltage + 20 || volt < this.mHistoryCur.batteryVoltage - 20) {
                    this.mHistoryCur.batteryVoltage = (char)volt;
                    changed = true;
                }
                if (changed) {
                    this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
                }
            }
            if (!onBattery && status == 5) {
                this.mRecordingHistory = false;
            }
        }
    }

    public void updateKernelWakelocksLocked() {
        Map<String, KernelWakelockStats> m = this.readKernelWakelockStats();
        if (m == null) {
            Slog.w(TAG, "Couldn't get kernel wake lock stats");
            return;
        }
        for (Map.Entry<String, KernelWakelockStats> entry : m.entrySet()) {
            String name = entry.getKey();
            KernelWakelockStats kws = entry.getValue();
            SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
            if (kwlt == null) {
                kwlt = new SamplingTimer(this.mUnpluggables, this.mOnBatteryInternal, true);
                this.mKernelWakelockStats.put(name, kwlt);
            }
            kwlt.updateCurrentReportedCount(kws.mCount);
            kwlt.updateCurrentReportedTotalTime(kws.mTotalTime);
            kwlt.setUpdateVersion(sKernelWakelockUpdateVersion);
        }
        if (m.size() != this.mKernelWakelockStats.size()) {
            for (Map.Entry<String, Object> entry : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer st = (SamplingTimer)entry.getValue();
                if (st.getUpdateVersion() == sKernelWakelockUpdateVersion) continue;
                st.setStale();
            }
        }
    }

    private void updateNetworkActivityLocked() {
        NetworkStats snapshot;
        if (!SystemProperties.getBoolean("net.qtaguid_enabled", false)) {
            return;
        }
        try {
            snapshot = this.mNetworkStatsFactory.readNetworkStatsDetail();
        }
        catch (IOException e) {
            Log.wtf(TAG, "Failed to read network stats", e);
            return;
        }
        if (this.mLastSnapshot == null) {
            this.mLastSnapshot = snapshot;
            return;
        }
        NetworkStats delta = snapshot.subtract(this.mLastSnapshot);
        this.mLastSnapshot = snapshot;
        NetworkStats.Entry entry = null;
        int size = delta.size();
        for (int i = 0; i < size; ++i) {
            entry = delta.getValues(i, entry);
            if (entry.rxBytes == 0L || entry.txBytes == 0L || entry.tag != 0) continue;
            Uid u = this.getUidStatsLocked(entry.uid);
            if (this.mMobileIfaces.contains(entry.iface)) {
                u.noteNetworkActivityLocked(0, entry.rxBytes);
                u.noteNetworkActivityLocked(1, entry.txBytes);
                this.mNetworkActivityCounters[0].addCountLocked(entry.rxBytes);
                this.mNetworkActivityCounters[1].addCountLocked(entry.txBytes);
                continue;
            }
            if (!this.mWifiIfaces.contains(entry.iface)) continue;
            u.noteNetworkActivityLocked(2, entry.rxBytes);
            u.noteNetworkActivityLocked(3, entry.txBytes);
            this.mNetworkActivityCounters[2].addCountLocked(entry.rxBytes);
            this.mNetworkActivityCounters[3].addCountLocked(entry.txBytes);
        }
    }

    public long getAwakeTimeBattery() {
        return this.computeBatteryUptime(this.getBatteryUptimeLocked(), 2);
    }

    public long getAwakeTimePlugged() {
        return SystemClock.uptimeMillis() * 1000L - this.getAwakeTimeBattery();
    }

    @Override
    public long computeUptime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mUptime + (curTime - this.mUptimeStart);
            }
            case 1: {
                return this.mLastUptime;
            }
            case 2: {
                return curTime - this.mUptimeStart;
            }
            case 3: {
                return curTime - this.mTrackBatteryUptimeStart;
            }
        }
        return 0L;
    }

    @Override
    public long computeRealtime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mRealtime + (curTime - this.mRealtimeStart);
            }
            case 1: {
                return this.mLastRealtime;
            }
            case 2: {
                return curTime - this.mRealtimeStart;
            }
            case 3: {
                return curTime - this.mTrackBatteryRealtimeStart;
            }
        }
        return 0L;
    }

    @Override
    public long computeBatteryUptime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mBatteryUptime + this.getBatteryUptime(curTime);
            }
            case 1: {
                return this.mBatteryLastUptime;
            }
            case 2: {
                return this.getBatteryUptime(curTime);
            }
            case 3: {
                return this.getBatteryUptimeLocked(curTime) - this.mUnpluggedBatteryUptime;
            }
        }
        return 0L;
    }

    @Override
    public long computeBatteryRealtime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mBatteryRealtime + this.getBatteryRealtimeLocked(curTime);
            }
            case 1: {
                return this.mBatteryLastRealtime;
            }
            case 2: {
                return this.getBatteryRealtimeLocked(curTime);
            }
            case 3: {
                return this.getBatteryRealtimeLocked(curTime) - this.mUnpluggedBatteryRealtime;
            }
        }
        return 0L;
    }

    long getBatteryUptimeLocked(long curTime) {
        long time = this.mTrackBatteryPastUptime;
        if (this.mOnBatteryInternal) {
            time += curTime - this.mTrackBatteryUptimeStart;
        }
        return time;
    }

    long getBatteryUptimeLocked() {
        return this.getBatteryUptime(SystemClock.uptimeMillis() * 1000L);
    }

    @Override
    public long getBatteryUptime(long curTime) {
        return this.getBatteryUptimeLocked(curTime);
    }

    long getBatteryRealtimeLocked(long curTime) {
        long time = this.mTrackBatteryPastRealtime;
        if (this.mOnBatteryInternal) {
            time += curTime - this.mTrackBatteryRealtimeStart;
        }
        return time;
    }

    @Override
    public long getBatteryRealtime(long curTime) {
        return this.getBatteryRealtimeLocked(curTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeStartLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeStartLevelLocked();
        }
    }

    public int getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeCurrentLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeCurrentLevelLocked();
        }
    }

    public int getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLowDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel - 1;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOn() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOn;
            if (this.mOnBattery && this.mScreenOn && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOnSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOnSinceCharge;
            if (this.mOnBattery && this.mScreenOn && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOff() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOff;
            if (this.mOnBattery && !this.mScreenOn && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOffSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOffSinceCharge;
            if (this.mOnBattery && !this.mScreenOn && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    @Override
    public int getCpuSpeedSteps() {
        return sNumSpeedSteps;
    }

    public Uid getUidStatsLocked(int uid) {
        Uid u = this.mUidStats.get(uid);
        if (u == null) {
            u = new Uid(uid);
            this.mUidStats.put(uid, u);
        }
        return u;
    }

    public void removeUidStatsLocked(int uid) {
        this.mUidStats.remove(uid);
    }

    public Uid.Proc getProcessStatsLocked(int uid, String name) {
        Uid u = this.getUidStatsLocked(uid);
        return u.getProcessStatsLocked(name);
    }

    public Uid.Proc getProcessStatsLocked(String name, int pid) {
        int uid;
        if (this.mUidCache.containsKey(name)) {
            uid = this.mUidCache.get(name);
        } else {
            uid = Process.getUidForPid(pid);
            this.mUidCache.put(name, uid);
        }
        Uid u = this.getUidStatsLocked(uid);
        return u.getProcessStatsLocked(name);
    }

    public Uid.Pkg getPackageStatsLocked(int uid, String pkg) {
        Uid u = this.getUidStatsLocked(uid);
        return u.getPackageStatsLocked(pkg);
    }

    public Uid.Pkg.Serv getServiceStatsLocked(int uid, String pkg, String name) {
        Uid u = this.getUidStatsLocked(uid);
        return u.getServiceStatsLocked(pkg, name);
    }

    public void distributeWorkLocked(int which) {
        Uid wifiUid = this.mUidStats.get(1010);
        if (wifiUid != null) {
            long uSecTime = this.computeBatteryRealtime(SystemClock.elapsedRealtime() * 1000L, which);
            for (Uid.Proc proc : wifiUid.mProcessStats.values()) {
                long totalRunningTime = this.getGlobalWifiRunningTime(uSecTime, which);
                for (int i = 0; i < this.mUidStats.size(); ++i) {
                    long uidRunningTime;
                    Uid uid = this.mUidStats.valueAt(i);
                    if (uid.mUid == 1010 || (uidRunningTime = uid.getWifiRunningTime(uSecTime, which)) <= 0L) continue;
                    Uid.Proc uidProc = uid.getProcessStatsLocked("*wifi*");
                    long time = proc.getUserTime(which);
                    time = time * uidRunningTime / totalRunningTime;
                    uidProc.mUserTime += time;
                    proc.mUserTime -= time;
                    time = proc.getSystemTime(which);
                    time = time * uidRunningTime / totalRunningTime;
                    uidProc.mSystemTime += time;
                    proc.mSystemTime -= time;
                    time = proc.getForegroundTime(which);
                    time = time * uidRunningTime / totalRunningTime;
                    uidProc.mForegroundTime += time;
                    proc.mForegroundTime -= time;
                    for (int sb = 0; sb < proc.mSpeedBins.length; ++sb) {
                        SamplingCounter sc = proc.mSpeedBins[sb];
                        if (sc == null) continue;
                        time = sc.getCountLocked(which);
                        time = time * uidRunningTime / totalRunningTime;
                        SamplingCounter uidSc = uidProc.mSpeedBins[sb];
                        if (uidSc == null) {
                            uidProc.mSpeedBins[sb] = uidSc = new SamplingCounter(this.mUnpluggables);
                        }
                        uidSc.mCount.addAndGet((int)time);
                        sc.mCount.addAndGet((int)(-time));
                    }
                    totalRunningTime -= uidRunningTime;
                }
            }
        }
    }

    public void shutdownLocked() {
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    public void writeAsyncLocked() {
        this.writeLocked(false);
    }

    public void writeSyncLocked() {
        this.writeLocked(true);
    }

    void writeLocked(boolean sync) {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "writeLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel out = Parcel.obtain();
        this.writeSummaryToParcel(out);
        this.mLastWriteTime = SystemClock.elapsedRealtime();
        if (this.mPendingWrite != null) {
            this.mPendingWrite.recycle();
        }
        this.mPendingWrite = out;
        if (sync) {
            this.commitPendingDataToDisk();
        } else {
            Thread thr = new Thread("BatteryStats-Write"){

                public void run() {
                    Process.setThreadPriority(10);
                    BatteryStatsImpl.this.commitPendingDataToDisk();
                }
            };
            thr.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitPendingDataToDisk() {
        Parcel next;
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            next = this.mPendingWrite;
            this.mPendingWrite = null;
            if (next == null) {
                return;
            }
            this.mWriteLock.lock();
        }
        try {
            FileOutputStream stream = new FileOutputStream(this.mFile.chooseForWrite());
            stream.write(next.marshall());
            stream.flush();
            FileUtils.sync(stream);
            stream.close();
            this.mFile.commit();
        }
        catch (IOException e) {
            Slog.w("BatteryStats", "Error writing battery statistics", e);
            this.mFile.rollback();
        }
        finally {
            next.recycle();
            this.mWriteLock.unlock();
        }
    }

    static byte[] readFully(FileInputStream stream) throws IOException {
        int pos = 0;
        int avail = stream.available();
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            System.arraycopy(data, 0, newData, 0, pos);
            data = newData;
        }
        return data;
    }

    public void readLocked() {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "readLocked: no file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        try {
            File file = this.mFile.chooseForRead();
            if (!file.exists()) {
                return;
            }
            FileInputStream stream = new FileInputStream(file);
            byte[] raw2 = BatteryStatsImpl.readFully(stream);
            Parcel in = Parcel.obtain();
            in.unmarshall(raw2, 0, raw2.length);
            in.setDataPosition(0);
            stream.close();
            this.readSummaryFromParcel(in);
        }
        catch (IOException e) {
            Slog.e("BatteryStats", "Error reading battery statistics", e);
        }
        long now = SystemClock.elapsedRealtime();
        this.addHistoryBufferLocked(now, (byte)2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    void readHistory(Parcel in, boolean andOldHistory) {
        long historyBaseTime = in.readLong();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        int bufSize = in.readInt();
        int curPos = in.dataPosition();
        if (bufSize >= 442368) {
            Slog.w(TAG, "File corrupt: history data buffer too large " + bufSize);
        } else if ((bufSize & 0xFFFFFFFC) != bufSize) {
            Slog.w(TAG, "File corrupt: history data buffer not aligned " + bufSize);
        } else {
            this.mHistoryBuffer.appendFrom(in, curPos, bufSize);
            in.setDataPosition(curPos + bufSize);
        }
        if (andOldHistory) {
            this.readOldHistory(in);
        }
        this.mHistoryBaseTime = historyBaseTime;
        if (this.mHistoryBaseTime > 0L) {
            long oldnow = SystemClock.elapsedRealtime();
            this.mHistoryBaseTime = this.mHistoryBaseTime - oldnow + 60000L;
        }
    }

    void readOldHistory(Parcel in) {
    }

    void writeHistory(Parcel out, boolean andOldHistory) {
        out.writeLong(this.mHistoryBaseTime + this.mLastHistoryTime);
        out.writeInt(this.mHistoryBuffer.dataSize());
        out.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
        if (andOldHistory) {
            this.writeOldHistory(out);
        }
    }

    void writeOldHistory(Parcel out) {
    }

    private void readSummaryFromParcel(Parcel in) {
        int i;
        int version = in.readInt();
        if (version != 67) {
            Slog.w("BatteryStats", "readFromParcel: version got " + version + ", expected " + 67 + "; erasing old stats");
            return;
        }
        this.readHistory(in, true);
        this.mStartCount = in.readInt();
        this.mBatteryUptime = in.readLong();
        this.mBatteryRealtime = in.readLong();
        this.mUptime = in.readLong();
        this.mRealtime = in.readLong();
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        ++this.mStartCount;
        this.mScreenOn = false;
        this.mScreenOnTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mInputEventCounter.readSummaryFromParcelLocked(in);
        this.mPhoneOn = false;
        this.mPhoneOnTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mPhoneSignalScanningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkActivityCounters[i].readSummaryFromParcelLocked(in);
        }
        this.mWifiOn = false;
        this.mWifiOnTimer.readSummaryFromParcelLocked(in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer.readSummaryFromParcelLocked(in);
        this.mBluetoothOn = false;
        this.mBluetoothOnTimer.readSummaryFromParcelLocked(in);
        int NKW = in.readInt();
        if (NKW > 10000) {
            Slog.w(TAG, "File corrupt: too many kernel wake locks " + NKW);
            return;
        }
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String kwltName = in.readString();
            this.getKernelWakelockTimerLocked(kwltName).readSummaryFromParcelLocked(in);
        }
        sNumSpeedSteps = in.readInt();
        int NU = in.readInt();
        if (NU > 10000) {
            Slog.w(TAG, "File corrupt: too many uids " + NU);
            return;
        }
        for (int iu = 0; iu < NU; ++iu) {
            Unpluggable p;
            int ip;
            int NW;
            int i2;
            int uid = in.readInt();
            Uid u = new Uid(uid);
            this.mUidStats.put(uid, u);
            u.mWifiRunning = false;
            if (in.readInt() != 0) {
                u.mWifiRunningTimer.readSummaryFromParcelLocked(in);
            }
            u.mFullWifiLockOut = false;
            if (in.readInt() != 0) {
                u.mFullWifiLockTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiScanStarted = false;
            if (in.readInt() != 0) {
                u.mWifiScanTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiBatchedScanBinStarted = -1;
            for (i2 = 0; i2 < 5; ++i2) {
                if (in.readInt() == 0) continue;
                u.makeWifiBatchedScanBin(i2, null);
                u.mWifiBatchedScanTimer[i2].readSummaryFromParcelLocked(in);
            }
            u.mWifiMulticastEnabled = false;
            if (in.readInt() != 0) {
                u.mWifiMulticastTimer.readSummaryFromParcelLocked(in);
            }
            u.mAudioTurnedOn = false;
            if (in.readInt() != 0) {
                u.createAudioTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            u.mVideoTurnedOn = false;
            if (in.readInt() != 0) {
                u.createVideoTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createForegroundActivityTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVibratorOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                if (u.mUserActivityCounters == null) {
                    u.initUserActivityLocked();
                }
                for (i2 = 0; i2 < 3; ++i2) {
                    u.mUserActivityCounters[i2].readSummaryFromParcelLocked(in);
                }
            }
            if (in.readInt() != 0) {
                if (u.mNetworkActivityCounters == null) {
                    u.initNetworkActivityLocked();
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    u.mNetworkActivityCounters[i2].readSummaryFromParcelLocked(in);
                }
            }
            if ((NW = in.readInt()) > 100) {
                Slog.w(TAG, "File corrupt: too many wake locks " + NW);
                return;
            }
            for (int iw = 0; iw < NW; ++iw) {
                String wlName = in.readString();
                if (in.readInt() != 0) {
                    u.getWakeTimerLocked(wlName, 1).readSummaryFromParcelLocked(in);
                }
                if (in.readInt() != 0) {
                    u.getWakeTimerLocked(wlName, 0).readSummaryFromParcelLocked(in);
                }
                if (in.readInt() == 0) continue;
                u.getWakeTimerLocked(wlName, 2).readSummaryFromParcelLocked(in);
            }
            int NP = in.readInt();
            if (NP > 1000) {
                Slog.w(TAG, "File corrupt: too many sensors " + NP);
                return;
            }
            for (int is = 0; is < NP; ++is) {
                int seNumber = in.readInt();
                if (in.readInt() == 0) continue;
                u.getSensorTimerLocked(seNumber, true).readSummaryFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 1000) {
                Slog.w(TAG, "File corrupt: too many processes " + NP);
                return;
            }
            for (ip = 0; ip < NP; ++ip) {
                String procName = in.readString();
                p = u.getProcessStatsLocked(procName);
                ((Uid.Proc)p).mUserTime = ((Uid.Proc)p).mLoadedUserTime = in.readLong();
                ((Uid.Proc)p).mSystemTime = ((Uid.Proc)p).mLoadedSystemTime = in.readLong();
                ((Uid.Proc)p).mForegroundTime = ((Uid.Proc)p).mLoadedForegroundTime = in.readLong();
                ((Uid.Proc)p).mStarts = ((Uid.Proc)p).mLoadedStarts = in.readInt();
                int NSB = in.readInt();
                if (NSB > 100) {
                    Slog.w(TAG, "File corrupt: too many speed bins " + NSB);
                    return;
                }
                ((Uid.Proc)p).mSpeedBins = new SamplingCounter[NSB];
                for (int i3 = 0; i3 < NSB; ++i3) {
                    if (in.readInt() == 0) continue;
                    ((Uid.Proc)p).mSpeedBins[i3] = new SamplingCounter(this.mUnpluggables);
                    ((Uid.Proc)p).mSpeedBins[i3].readSummaryFromParcelLocked(in);
                }
                if (((Uid.Proc)p).readExcessivePowerFromParcelLocked(in)) continue;
                return;
            }
            NP = in.readInt();
            if (NP > 10000) {
                Slog.w(TAG, "File corrupt: too many packages " + NP);
                return;
            }
            for (ip = 0; ip < NP; ++ip) {
                String pkgName = in.readString();
                p = u.getPackageStatsLocked(pkgName);
                ((Uid.Pkg)p).mWakeups = ((Uid.Pkg)p).mLoadedWakeups = in.readInt();
                int NS = in.readInt();
                if (NS > 1000) {
                    Slog.w(TAG, "File corrupt: too many services " + NS);
                    return;
                }
                for (int is = 0; is < NS; ++is) {
                    String servName = in.readString();
                    Uid.Pkg.Serv s = u.getServiceStatsLocked(pkgName, servName);
                    s.mStartTime = s.mLoadedStartTime = in.readLong();
                    s.mStarts = s.mLoadedStarts = in.readInt();
                    s.mLaunches = s.mLoadedLaunches = in.readInt();
                }
            }
        }
    }

    public void writeSummaryToParcel(Parcel out) {
        int i;
        this.updateKernelWakelocksLocked();
        this.updateNetworkActivityLocked();
        long NOW_SYS = SystemClock.uptimeMillis() * 1000L;
        long NOWREAL_SYS = SystemClock.elapsedRealtime() * 1000L;
        long NOW = this.getBatteryUptimeLocked(NOW_SYS);
        long NOWREAL = this.getBatteryRealtimeLocked(NOWREAL_SYS);
        out.writeInt(67);
        this.writeHistory(out, true);
        out.writeInt(this.mStartCount);
        out.writeLong(this.computeBatteryUptime(NOW_SYS, 0));
        out.writeLong(this.computeBatteryRealtime(NOWREAL_SYS, 0));
        out.writeLong(this.computeUptime(NOW_SYS, 0));
        out.writeLong(this.computeRealtime(NOWREAL_SYS, 0));
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.getLowDischargeAmountSinceCharge());
        out.writeInt(this.getHighDischargeAmountSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOnSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOffSinceCharge());
        this.mScreenOnTimer.writeSummaryFromParcelLocked(out, NOWREAL);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeSummaryFromParcelLocked(out, NOWREAL);
        }
        this.mInputEventCounter.writeSummaryFromParcelLocked(out);
        this.mPhoneOnTimer.writeSummaryFromParcelLocked(out, NOWREAL);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL);
        }
        this.mPhoneSignalScanningTimer.writeSummaryFromParcelLocked(out, NOWREAL);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkActivityCounters[i].writeSummaryFromParcelLocked(out);
        }
        this.mWifiOnTimer.writeSummaryFromParcelLocked(out, NOWREAL);
        this.mGlobalWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL);
        this.mBluetoothOnTimer.writeSummaryFromParcelLocked(out, NOWREAL);
        out.writeInt(this.mKernelWakelockStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            Timer kwlt = ent.getValue();
            if (kwlt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                ent.getValue().writeSummaryFromParcelLocked(out, NOWREAL);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(sNumSpeedSteps);
        int NU = this.mUidStats.size();
        out.writeInt(NU);
        for (int iu = 0; iu < NU; ++iu) {
            Unpluggable ps;
            int i2;
            out.writeInt(this.mUidStats.keyAt(iu));
            Uid u = this.mUidStats.valueAt(iu);
            if (u.mWifiRunningTimer != null) {
                out.writeInt(1);
                u.mWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            if (u.mFullWifiLockTimer != null) {
                out.writeInt(1);
                u.mFullWifiLockTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            if (u.mWifiScanTimer != null) {
                out.writeInt(1);
                u.mWifiScanTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            for (int i22 = 0; i22 < 5; ++i22) {
                if (u.mWifiBatchedScanTimer[i22] != null) {
                    out.writeInt(1);
                    u.mWifiBatchedScanTimer[i22].writeSummaryFromParcelLocked(out, NOWREAL);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mWifiMulticastTimer != null) {
                out.writeInt(1);
                u.mWifiMulticastTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            if (u.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                u.mAudioTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            if (u.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                u.mVideoTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            if (u.mForegroundActivityTimer != null) {
                out.writeInt(1);
                u.mForegroundActivityTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            if (u.mVibratorOnTimer != null) {
                out.writeInt(1);
                u.mVibratorOnTimer.writeSummaryFromParcelLocked(out, NOWREAL);
            } else {
                out.writeInt(0);
            }
            if (u.mUserActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i2 = 0; i2 < 3; ++i2) {
                    u.mUserActivityCounters[i2].writeSummaryFromParcelLocked(out);
                }
            }
            if (u.mNetworkActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i2 = 0; i2 < 4; ++i2) {
                    u.mNetworkActivityCounters[i2].writeSummaryFromParcelLocked(out);
                }
            }
            int NW = u.mWakelockStats.size();
            out.writeInt(NW);
            if (NW > 0) {
                for (Map.Entry<String, Uid.Wakelock> ent : u.mWakelockStats.entrySet()) {
                    out.writeString(ent.getKey());
                    Uid.Wakelock wl = ent.getValue();
                    if (wl.mTimerFull != null) {
                        out.writeInt(1);
                        wl.mTimerFull.writeSummaryFromParcelLocked(out, NOWREAL);
                    } else {
                        out.writeInt(0);
                    }
                    if (wl.mTimerPartial != null) {
                        out.writeInt(1);
                        wl.mTimerPartial.writeSummaryFromParcelLocked(out, NOWREAL);
                    } else {
                        out.writeInt(0);
                    }
                    if (wl.mTimerWindow != null) {
                        out.writeInt(1);
                        wl.mTimerWindow.writeSummaryFromParcelLocked(out, NOWREAL);
                        continue;
                    }
                    out.writeInt(0);
                }
            }
            int NSE = u.mSensorStats.size();
            out.writeInt(NSE);
            if (NSE > 0) {
                for (Map.Entry<Integer, Uid.Sensor> ent : u.mSensorStats.entrySet()) {
                    out.writeInt(ent.getKey());
                    Uid.Sensor sensor = ent.getValue();
                    if (sensor.mTimer != null) {
                        out.writeInt(1);
                        sensor.mTimer.writeSummaryFromParcelLocked(out, NOWREAL);
                        continue;
                    }
                    out.writeInt(0);
                }
            }
            int NP = u.mProcessStats.size();
            out.writeInt(NP);
            if (NP > 0) {
                for (Map.Entry<String, Uid.Proc> entry : u.mProcessStats.entrySet()) {
                    out.writeString(entry.getKey());
                    ps = entry.getValue();
                    out.writeLong(((Uid.Proc)ps).mUserTime);
                    out.writeLong(((Uid.Proc)ps).mSystemTime);
                    out.writeLong(((Uid.Proc)ps).mForegroundTime);
                    out.writeInt(((Uid.Proc)ps).mStarts);
                    int N = ((Uid.Proc)ps).mSpeedBins.length;
                    out.writeInt(N);
                    for (int i3 = 0; i3 < N; ++i3) {
                        if (((Uid.Proc)ps).mSpeedBins[i3] != null) {
                            out.writeInt(1);
                            ((Uid.Proc)ps).mSpeedBins[i3].writeSummaryFromParcelLocked(out);
                            continue;
                        }
                        out.writeInt(0);
                    }
                    ((Uid.Proc)ps).writeExcessivePowerToParcelLocked(out);
                }
            }
            NP = u.mPackageStats.size();
            out.writeInt(NP);
            if (NP <= 0) continue;
            for (Map.Entry<String, Unpluggable> entry : u.mPackageStats.entrySet()) {
                out.writeString(entry.getKey());
                ps = (Uid.Pkg)entry.getValue();
                out.writeInt(((Uid.Pkg)ps).mWakeups);
                int NS = ((Uid.Pkg)ps).mServiceStats.size();
                out.writeInt(NS);
                if (NS <= 0) continue;
                for (Map.Entry<String, Uid.Pkg.Serv> sent : ((Uid.Pkg)ps).mServiceStats.entrySet()) {
                    out.writeString(sent.getKey());
                    Uid.Pkg.Serv ss = sent.getValue();
                    long time = ss.getStartTimeToNowLocked(NOW);
                    out.writeLong(time);
                    out.writeInt(ss.mStarts);
                    out.writeInt(ss.mLaunches);
                }
            }
        }
    }

    public void readFromParcel(Parcel in) {
        this.readFromParcelLocked(in);
    }

    void readFromParcelLocked(Parcel in) {
        int i;
        int magic = in.readInt();
        if (magic != -1166707595) {
            throw new ParcelFormatException("Bad magic number");
        }
        this.readHistory(in, false);
        this.mStartCount = in.readInt();
        this.mBatteryUptime = in.readLong();
        this.mBatteryLastUptime = 0L;
        this.mBatteryRealtime = in.readLong();
        this.mBatteryLastRealtime = 0L;
        this.mScreenOn = false;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mUnpluggables, in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mUnpluggables, in);
        }
        this.mInputEventCounter = new Counter(this.mUnpluggables, in);
        this.mPhoneOn = false;
        this.mPhoneOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, in);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mUnpluggables, in);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mUnpluggables, in);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mUnpluggables, in);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkActivityCounters[i] = new LongSamplingCounter(this.mUnpluggables, in);
        }
        this.mWifiOn = false;
        this.mWifiOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, in);
        this.mBluetoothOn = false;
        this.mBluetoothOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, in);
        this.mUptime = in.readLong();
        this.mUptimeStart = in.readLong();
        this.mLastUptime = 0L;
        this.mRealtime = in.readLong();
        this.mRealtimeStart = in.readLong();
        this.mLastRealtime = 0L;
        this.mOnBattery = in.readInt() != 0;
        this.mOnBatteryInternal = false;
        this.mTrackBatteryPastUptime = in.readLong();
        this.mTrackBatteryUptimeStart = in.readLong();
        this.mTrackBatteryPastRealtime = in.readLong();
        this.mTrackBatteryRealtimeStart = in.readLong();
        this.mUnpluggedBatteryUptime = in.readLong();
        this.mUnpluggedBatteryRealtime = in.readLong();
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOn = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOff = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mLastWriteTime = in.readLong();
        this.mRadioDataUptime = in.readLong();
        this.mRadioDataStart = -1L;
        this.mBluetoothPingCount = in.readInt();
        this.mBluetoothPingStart = -1;
        this.mKernelWakelockStats.clear();
        int NKW = in.readInt();
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String wakelockName = in.readString();
            in.readInt();
            SamplingTimer kwlt = new SamplingTimer(this.mUnpluggables, this.mOnBattery, in);
            this.mKernelWakelockStats.put(wakelockName, kwlt);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mWifiScanTimers.clear();
        this.mWifiBatchedScanTimers.clear();
        this.mWifiMulticastTimers.clear();
        sNumSpeedSteps = in.readInt();
        int numUids = in.readInt();
        this.mUidStats.clear();
        for (int i2 = 0; i2 < numUids; ++i2) {
            int uid = in.readInt();
            Uid u = new Uid(uid);
            u.readFromParcelLocked(this.mUnpluggables, in);
            this.mUidStats.append(uid, u);
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.writeToParcelLocked(out, true, flags);
    }

    public void writeToParcelWithoutUids(Parcel out, int flags) {
        this.writeToParcelLocked(out, false, flags);
    }

    void writeToParcelLocked(Parcel out, boolean inclUids, int flags) {
        int i;
        this.updateKernelWakelocksLocked();
        this.updateNetworkActivityLocked();
        long uSecUptime = SystemClock.uptimeMillis() * 1000L;
        long uSecRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryUptime = this.getBatteryUptimeLocked(uSecUptime);
        long batteryRealtime = this.getBatteryRealtimeLocked(uSecRealtime);
        out.writeInt(-1166707595);
        this.writeHistory(out, false);
        out.writeInt(this.mStartCount);
        out.writeLong(this.mBatteryUptime);
        out.writeLong(this.mBatteryRealtime);
        this.mScreenOnTimer.writeToParcel(out, batteryRealtime);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeToParcel(out, batteryRealtime);
        }
        this.mInputEventCounter.writeToParcel(out);
        this.mPhoneOnTimer.writeToParcel(out, batteryRealtime);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeToParcel(out, batteryRealtime);
        }
        this.mPhoneSignalScanningTimer.writeToParcel(out, batteryRealtime);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeToParcel(out, batteryRealtime);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkActivityCounters[i].writeToParcel(out);
        }
        this.mWifiOnTimer.writeToParcel(out, batteryRealtime);
        this.mGlobalWifiRunningTimer.writeToParcel(out, batteryRealtime);
        this.mBluetoothOnTimer.writeToParcel(out, batteryRealtime);
        out.writeLong(this.mUptime);
        out.writeLong(this.mUptimeStart);
        out.writeLong(this.mRealtime);
        out.writeLong(this.mRealtimeStart);
        out.writeInt(this.mOnBattery ? 1 : 0);
        out.writeLong(batteryUptime);
        out.writeLong(this.mTrackBatteryUptimeStart);
        out.writeLong(batteryRealtime);
        out.writeLong(this.mTrackBatteryRealtimeStart);
        out.writeLong(this.mUnpluggedBatteryUptime);
        out.writeLong(this.mUnpluggedBatteryRealtime);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mLowDischargeAmountSinceCharge);
        out.writeInt(this.mHighDischargeAmountSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOn);
        out.writeInt(this.mDischargeAmountScreenOnSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOff);
        out.writeInt(this.mDischargeAmountScreenOffSinceCharge);
        out.writeLong(this.mLastWriteTime);
        out.writeLong(this.getRadioDataUptime());
        out.writeInt(this.getBluetoothPingCount());
        if (inclUids) {
            out.writeInt(this.mKernelWakelockStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer kwlt = ent.getValue();
                if (kwlt != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    Timer.writeTimerToParcel(out, kwlt, batteryRealtime);
                    continue;
                }
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(sNumSpeedSteps);
        if (inclUids) {
            int size = this.mUidStats.size();
            out.writeInt(size);
            for (int i2 = 0; i2 < size; ++i2) {
                out.writeInt(this.mUidStats.keyAt(i2));
                Uid uid = this.mUidStats.valueAt(i2);
                uid.writeToParcelLocked(out, batteryRealtime);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void prepareForDumpLocked() {
        this.updateKernelWakelocksLocked();
        this.updateNetworkActivityLocked();
    }

    @Override
    public void dumpLocked(PrintWriter pw, boolean isUnpluggedOnly, int reqUid) {
        super.dumpLocked(pw, isUnpluggedOnly, reqUid);
    }

    static {
        sKernelWakelockUpdateVersion = 0;
        PROC_WAKELOCKS_FORMAT = new int[]{5129, 8201, 9, 9, 9, 8201};
        WAKEUP_SOURCES_FORMAT = new int[]{4105, 8457, 265, 265, 265, 265, 8457};
        CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){

            @Override
            public BatteryStatsImpl createFromParcel(Parcel in) {
                return new BatteryStatsImpl(in);
            }

            public BatteryStatsImpl[] newArray(int size) {
                return new BatteryStatsImpl[size];
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Uid
    extends BatteryStats.Uid {
        final int mUid;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        boolean mWifiScanStarted;
        StopwatchTimer mWifiScanTimer;
        private static final int NO_BATCHED_SCAN_STARTED = -1;
        int mWifiBatchedScanBinStarted = -1;
        StopwatchTimer[] mWifiBatchedScanTimer;
        boolean mWifiMulticastEnabled;
        StopwatchTimer mWifiMulticastTimer;
        boolean mAudioTurnedOn;
        StopwatchTimer mAudioTurnedOnTimer;
        boolean mVideoTurnedOn;
        StopwatchTimer mVideoTurnedOnTimer;
        StopwatchTimer mForegroundActivityTimer;
        BatchTimer mVibratorOnTimer;
        Counter[] mUserActivityCounters;
        LongSamplingCounter[] mNetworkActivityCounters;
        final HashMap<String, Wakelock> mWakelockStats = new HashMap();
        final HashMap<Integer, Sensor> mSensorStats = new HashMap();
        final HashMap<String, Proc> mProcessStats = new HashMap();
        final HashMap<String, Pkg> mPackageStats = new HashMap();
        final SparseArray<BatteryStats.Uid.Pid> mPids = new SparseArray();

        public Uid(int uid) {
            this.mUid = uid;
            this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mUnpluggables);
            this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mUnpluggables);
            this.mWifiScanTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mUnpluggables);
            this.mWifiBatchedScanTimer = new StopwatchTimer[5];
            this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mUnpluggables);
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return this.mWakelockStats;
        }

        @Override
        public Map<Integer, ? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return this.mSensorStats;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return this.mProcessStats;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return this.mPackageStats;
        }

        @Override
        public int getUid() {
            return this.mUid;
        }

        @Override
        public void noteWifiRunningLocked() {
            if (!this.mWifiRunning) {
                this.mWifiRunning = true;
                if (this.mWifiRunningTimer == null) {
                    this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mWifiRunningTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiStoppedLocked() {
            if (this.mWifiRunning) {
                this.mWifiRunning = false;
                this.mWifiRunningTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteFullWifiLockAcquiredLocked() {
            if (!this.mFullWifiLockOut) {
                this.mFullWifiLockOut = true;
                if (this.mFullWifiLockTimer == null) {
                    this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mFullWifiLockTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteFullWifiLockReleasedLocked() {
            if (this.mFullWifiLockOut) {
                this.mFullWifiLockOut = false;
                this.mFullWifiLockTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiScanStartedLocked() {
            if (!this.mWifiScanStarted) {
                this.mWifiScanStarted = true;
                if (this.mWifiScanTimer == null) {
                    this.mWifiScanTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mWifiScanTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiScanStoppedLocked() {
            if (this.mWifiScanStarted) {
                this.mWifiScanStarted = false;
                this.mWifiScanTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiBatchedScanStartedLocked(int csph) {
            int bin;
            for (bin = 0; csph > 8 && bin < 5; csph >>= 3, ++bin) {
            }
            if (this.mWifiBatchedScanBinStarted == bin) {
                return;
            }
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(BatteryStatsImpl.this);
            }
            this.mWifiBatchedScanBinStarted = bin;
            if (this.mWifiBatchedScanTimer[bin] == null) {
                this.makeWifiBatchedScanBin(bin, null);
            }
            this.mWifiBatchedScanTimer[bin].startRunningLocked(BatteryStatsImpl.this);
        }

        @Override
        public void noteWifiBatchedScanStoppedLocked() {
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(BatteryStatsImpl.this);
                this.mWifiBatchedScanBinStarted = -1;
            }
        }

        @Override
        public void noteWifiMulticastEnabledLocked() {
            if (!this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = true;
                if (this.mWifiMulticastTimer == null) {
                    this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mWifiMulticastTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiMulticastDisabledLocked() {
            if (this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = false;
                this.mWifiMulticastTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        public StopwatchTimer createAudioTurnedOnTimerLocked() {
            if (this.mAudioTurnedOnTimer == null) {
                this.mAudioTurnedOnTimer = new StopwatchTimer(this, 7, null, BatteryStatsImpl.this.mUnpluggables);
            }
            return this.mAudioTurnedOnTimer;
        }

        @Override
        public void noteAudioTurnedOnLocked() {
            if (!this.mAudioTurnedOn) {
                this.mAudioTurnedOn = true;
                this.createAudioTurnedOnTimerLocked().startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteAudioTurnedOffLocked() {
            if (this.mAudioTurnedOn) {
                this.mAudioTurnedOn = false;
                if (this.mAudioTurnedOnTimer != null) {
                    this.mAudioTurnedOnTimer.stopRunningLocked(BatteryStatsImpl.this);
                }
            }
        }

        public StopwatchTimer createVideoTurnedOnTimerLocked() {
            if (this.mVideoTurnedOnTimer == null) {
                this.mVideoTurnedOnTimer = new StopwatchTimer(this, 8, null, BatteryStatsImpl.this.mUnpluggables);
            }
            return this.mVideoTurnedOnTimer;
        }

        @Override
        public void noteVideoTurnedOnLocked() {
            if (!this.mVideoTurnedOn) {
                this.mVideoTurnedOn = true;
                this.createVideoTurnedOnTimerLocked().startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteVideoTurnedOffLocked() {
            if (this.mVideoTurnedOn) {
                this.mVideoTurnedOn = false;
                if (this.mVideoTurnedOnTimer != null) {
                    this.mVideoTurnedOnTimer.stopRunningLocked(BatteryStatsImpl.this);
                }
            }
        }

        public StopwatchTimer createForegroundActivityTimerLocked() {
            if (this.mForegroundActivityTimer == null) {
                this.mForegroundActivityTimer = new StopwatchTimer(this, 10, null, BatteryStatsImpl.this.mUnpluggables);
            }
            return this.mForegroundActivityTimer;
        }

        @Override
        public void noteActivityResumedLocked() {
            this.createForegroundActivityTimerLocked().startRunningLocked(BatteryStatsImpl.this);
        }

        @Override
        public void noteActivityPausedLocked() {
            if (this.mForegroundActivityTimer != null) {
                this.mForegroundActivityTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        public BatchTimer createVibratorOnTimerLocked() {
            if (this.mVibratorOnTimer == null) {
                this.mVibratorOnTimer = new BatchTimer(this, 9, BatteryStatsImpl.this.mUnpluggables, BatteryStatsImpl.this.mOnBatteryInternal);
            }
            return this.mVibratorOnTimer;
        }

        public void noteVibratorOnLocked(long durationMillis) {
            this.createVibratorOnTimerLocked().addDuration(BatteryStatsImpl.this, durationMillis);
        }

        public void noteVibratorOffLocked() {
            if (this.mVibratorOnTimer != null) {
                this.mVibratorOnTimer.abortLastDuration(BatteryStatsImpl.this);
            }
        }

        @Override
        public long getWifiRunningTime(long batteryRealtime, int which) {
            if (this.mWifiRunningTimer == null) {
                return 0L;
            }
            return this.mWifiRunningTimer.getTotalTimeLocked(batteryRealtime, which);
        }

        @Override
        public long getFullWifiLockTime(long batteryRealtime, int which) {
            if (this.mFullWifiLockTimer == null) {
                return 0L;
            }
            return this.mFullWifiLockTimer.getTotalTimeLocked(batteryRealtime, which);
        }

        @Override
        public long getWifiScanTime(long batteryRealtime, int which) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            return this.mWifiScanTimer.getTotalTimeLocked(batteryRealtime, which);
        }

        @Override
        public long getWifiBatchedScanTime(int csphBin, long batteryRealtime, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0L;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0L;
            }
            return this.mWifiBatchedScanTimer[csphBin].getTotalTimeLocked(batteryRealtime, which);
        }

        @Override
        public long getWifiMulticastTime(long batteryRealtime, int which) {
            if (this.mWifiMulticastTimer == null) {
                return 0L;
            }
            return this.mWifiMulticastTimer.getTotalTimeLocked(batteryRealtime, which);
        }

        @Override
        public long getAudioTurnedOnTime(long batteryRealtime, int which) {
            if (this.mAudioTurnedOnTimer == null) {
                return 0L;
            }
            return this.mAudioTurnedOnTimer.getTotalTimeLocked(batteryRealtime, which);
        }

        @Override
        public long getVideoTurnedOnTime(long batteryRealtime, int which) {
            if (this.mVideoTurnedOnTimer == null) {
                return 0L;
            }
            return this.mVideoTurnedOnTimer.getTotalTimeLocked(batteryRealtime, which);
        }

        @Override
        public Timer getForegroundActivityTimer() {
            return this.mForegroundActivityTimer;
        }

        @Override
        public Timer getVibratorOnTimer() {
            return this.mVibratorOnTimer;
        }

        @Override
        public void noteUserActivityLocked(int type) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (type >= 0 && type < 3) {
                this.mUserActivityCounters[type].stepAtomic();
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown user activity type " + type + " was specified.", new Throwable());
            }
        }

        @Override
        public boolean hasUserActivity() {
            return this.mUserActivityCounters != null;
        }

        @Override
        public int getUserActivityCount(int type, int which) {
            if (this.mUserActivityCounters == null) {
                return 0;
            }
            return this.mUserActivityCounters[type].getCountLocked(which);
        }

        void makeWifiBatchedScanBin(int i, Parcel in) {
            if (i < 0 || i >= 5) {
                return;
            }
            ArrayList<StopwatchTimer> collected = BatteryStatsImpl.this.mWifiBatchedScanTimers.get(i);
            if (collected == null) {
                collected = new ArrayList();
                BatteryStatsImpl.this.mWifiBatchedScanTimers.put(i, collected);
            }
            this.mWifiBatchedScanTimer[i] = in == null ? new StopwatchTimer(this, 11, collected, BatteryStatsImpl.this.mUnpluggables) : new StopwatchTimer(this, 11, collected, BatteryStatsImpl.this.mUnpluggables, in);
        }

        void initUserActivityLocked() {
            this.mUserActivityCounters = new Counter[3];
            for (int i = 0; i < 3; ++i) {
                this.mUserActivityCounters[i] = new Counter(BatteryStatsImpl.this.mUnpluggables);
            }
        }

        void noteNetworkActivityLocked(int type, long delta) {
            if (this.mNetworkActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            if (type >= 0 && type < 4) {
                this.mNetworkActivityCounters[type].addCountLocked(delta);
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown network activity type " + type + " was specified.", new Throwable());
            }
        }

        @Override
        public boolean hasNetworkActivity() {
            return this.mNetworkActivityCounters != null;
        }

        @Override
        public long getNetworkActivityCount(int type, int which) {
            if (this.mNetworkActivityCounters != null && type >= 0 && type < this.mNetworkActivityCounters.length) {
                return this.mNetworkActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        void initNetworkActivityLocked() {
            this.mNetworkActivityCounters = new LongSamplingCounter[4];
            for (int i = 0; i < 4; ++i) {
                this.mNetworkActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mUnpluggables);
            }
        }

        boolean reset() {
            int i;
            boolean active = false;
            if (this.mWifiRunningTimer != null) {
                active |= !this.mWifiRunningTimer.reset(BatteryStatsImpl.this, false);
                active |= this.mWifiRunning;
            }
            if (this.mFullWifiLockTimer != null) {
                active |= !this.mFullWifiLockTimer.reset(BatteryStatsImpl.this, false);
                active |= this.mFullWifiLockOut;
            }
            if (this.mWifiScanTimer != null) {
                active |= !this.mWifiScanTimer.reset(BatteryStatsImpl.this, false);
                active |= this.mWifiScanStarted;
            }
            if (this.mWifiBatchedScanTimer != null) {
                for (i = 0; i < 5; ++i) {
                    if (this.mWifiBatchedScanTimer[i] == null) continue;
                    active |= !this.mWifiBatchedScanTimer[i].reset(BatteryStatsImpl.this, false);
                }
                active |= this.mWifiBatchedScanBinStarted != -1;
            }
            if (this.mWifiMulticastTimer != null) {
                active |= !this.mWifiMulticastTimer.reset(BatteryStatsImpl.this, false);
                active |= this.mWifiMulticastEnabled;
            }
            if (this.mAudioTurnedOnTimer != null) {
                active |= !this.mAudioTurnedOnTimer.reset(BatteryStatsImpl.this, false);
                active |= this.mAudioTurnedOn;
            }
            if (this.mVideoTurnedOnTimer != null) {
                active |= !this.mVideoTurnedOnTimer.reset(BatteryStatsImpl.this, false);
                active |= this.mVideoTurnedOn;
            }
            if (this.mForegroundActivityTimer != null) {
                active |= !this.mForegroundActivityTimer.reset(BatteryStatsImpl.this, false);
            }
            if (this.mVibratorOnTimer != null) {
                if (this.mVibratorOnTimer.reset(BatteryStatsImpl.this, false)) {
                    this.mVibratorOnTimer.detach();
                    this.mVibratorOnTimer = null;
                } else {
                    active = true;
                }
            }
            if (this.mUserActivityCounters != null) {
                for (i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i].reset(false);
                }
            }
            if (this.mNetworkActivityCounters != null) {
                for (i = 0; i < 4; ++i) {
                    this.mNetworkActivityCounters[i].reset(false);
                }
            }
            if (this.mWakelockStats.size() > 0) {
                Iterator<Map.Entry<String, Wakelock>> it = this.mWakelockStats.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Wakelock> wakelockEntry = it.next();
                    Wakelock wl = wakelockEntry.getValue();
                    if (wl.reset()) {
                        it.remove();
                        continue;
                    }
                    active = true;
                }
            }
            if (this.mSensorStats.size() > 0) {
                Iterator<Map.Entry<Integer, Sensor>> it = this.mSensorStats.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, Sensor> sensorEntry = it.next();
                    Sensor s = sensorEntry.getValue();
                    if (s.reset()) {
                        it.remove();
                        continue;
                    }
                    active = true;
                }
            }
            if (this.mProcessStats.size() > 0) {
                for (Map.Entry<String, Proc> procEntry : this.mProcessStats.entrySet()) {
                    procEntry.getValue().detach();
                }
                this.mProcessStats.clear();
            }
            if (this.mPids.size() > 0) {
                for (int i2 = 0; !active && i2 < this.mPids.size(); ++i2) {
                    BatteryStats.Uid.Pid pid = this.mPids.valueAt(i2);
                    if (pid.mWakeStart == 0L) continue;
                    active = true;
                }
            }
            if (this.mPackageStats.size() > 0) {
                for (Map.Entry<String, Pkg> pkgEntry : this.mPackageStats.entrySet()) {
                    Pkg p = pkgEntry.getValue();
                    p.detach();
                    if (p.mServiceStats.size() <= 0) continue;
                    for (Map.Entry<String, Pkg.Serv> servEntry : p.mServiceStats.entrySet()) {
                        servEntry.getValue().detach();
                    }
                }
                this.mPackageStats.clear();
            }
            this.mPids.clear();
            if (!active) {
                int i3;
                if (this.mWifiRunningTimer != null) {
                    this.mWifiRunningTimer.detach();
                }
                if (this.mFullWifiLockTimer != null) {
                    this.mFullWifiLockTimer.detach();
                }
                if (this.mWifiScanTimer != null) {
                    this.mWifiScanTimer.detach();
                }
                for (i3 = 0; i3 < 5; ++i3) {
                    if (this.mWifiBatchedScanTimer[i3] == null) continue;
                    this.mWifiBatchedScanTimer[i3].detach();
                }
                if (this.mWifiMulticastTimer != null) {
                    this.mWifiMulticastTimer.detach();
                }
                if (this.mAudioTurnedOnTimer != null) {
                    this.mAudioTurnedOnTimer.detach();
                    this.mAudioTurnedOnTimer = null;
                }
                if (this.mVideoTurnedOnTimer != null) {
                    this.mVideoTurnedOnTimer.detach();
                    this.mVideoTurnedOnTimer = null;
                }
                if (this.mForegroundActivityTimer != null) {
                    this.mForegroundActivityTimer.detach();
                    this.mForegroundActivityTimer = null;
                }
                if (this.mUserActivityCounters != null) {
                    for (i3 = 0; i3 < 3; ++i3) {
                        this.mUserActivityCounters[i3].detach();
                    }
                }
                if (this.mNetworkActivityCounters != null) {
                    for (i3 = 0; i3 < 4; ++i3) {
                        this.mNetworkActivityCounters[i3].detach();
                    }
                }
            }
            return !active;
        }

        void writeToParcelLocked(Parcel out, long batteryRealtime) {
            int i;
            out.writeInt(this.mWakelockStats.size());
            for (Map.Entry<String, Wakelock> entry : this.mWakelockStats.entrySet()) {
                out.writeString(entry.getKey());
                Wakelock wakelock = entry.getValue();
                wakelock.writeToParcelLocked(out, batteryRealtime);
            }
            out.writeInt(this.mSensorStats.size());
            for (Map.Entry<Object, Object> entry : this.mSensorStats.entrySet()) {
                out.writeInt((Integer)entry.getKey());
                Sensor sensor = (Sensor)entry.getValue();
                sensor.writeToParcelLocked(out, batteryRealtime);
            }
            out.writeInt(this.mProcessStats.size());
            for (Map.Entry<Object, Object> entry : this.mProcessStats.entrySet()) {
                out.writeString((String)entry.getKey());
                Proc proc = (Proc)entry.getValue();
                proc.writeToParcelLocked(out);
            }
            out.writeInt(this.mPackageStats.size());
            for (Map.Entry<Object, Object> entry : this.mPackageStats.entrySet()) {
                out.writeString((String)entry.getKey());
                Pkg pkg = (Pkg)entry.getValue();
                pkg.writeToParcelLocked(out);
            }
            if (this.mWifiRunningTimer != null) {
                out.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                out.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiScanTimer != null) {
                out.writeInt(1);
                this.mWifiScanTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 5; ++i) {
                if (this.mWifiBatchedScanTimer[i] != null) {
                    out.writeInt(1);
                    this.mWifiBatchedScanTimer[i].writeToParcel(out, batteryRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                out.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            if (this.mForegroundActivityTimer != null) {
                out.writeInt(1);
                this.mForegroundActivityTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            if (this.mVibratorOnTimer != null) {
                out.writeInt(1);
                this.mVibratorOnTimer.writeToParcel(out, batteryRealtime);
            } else {
                out.writeInt(0);
            }
            if (this.mUserActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i].writeToParcel(out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.mNetworkActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 4; ++i) {
                    this.mNetworkActivityCounters[i].writeToParcel(out);
                }
            } else {
                out.writeInt(0);
            }
        }

        void readFromParcelLocked(ArrayList<Unpluggable> unpluggables, Parcel in) {
            int i;
            int numWakelocks = in.readInt();
            this.mWakelockStats.clear();
            for (int j = 0; j < numWakelocks; ++j) {
                String wakelockName = in.readString();
                Wakelock wakelock = new Wakelock();
                wakelock.readFromParcelLocked(unpluggables, in);
                this.mWakelockStats.put(wakelockName, wakelock);
            }
            int numSensors = in.readInt();
            this.mSensorStats.clear();
            for (int k = 0; k < numSensors; ++k) {
                int sensorNumber = in.readInt();
                Sensor sensor = new Sensor(sensorNumber);
                sensor.readFromParcelLocked(BatteryStatsImpl.this.mUnpluggables, in);
                this.mSensorStats.put(sensorNumber, sensor);
            }
            int numProcs = in.readInt();
            this.mProcessStats.clear();
            for (int k = 0; k < numProcs; ++k) {
                String processName = in.readString();
                Proc proc = new Proc();
                proc.readFromParcelLocked(in);
                this.mProcessStats.put(processName, proc);
            }
            int numPkgs = in.readInt();
            this.mPackageStats.clear();
            for (int l = 0; l < numPkgs; ++l) {
                String packageName = in.readString();
                Pkg pkg = new Pkg();
                pkg.readFromParcelLocked(in);
                this.mPackageStats.put(packageName, pkg);
            }
            this.mWifiRunning = false;
            this.mWifiRunningTimer = in.readInt() != 0 ? new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mUnpluggables, in) : null;
            this.mFullWifiLockOut = false;
            this.mFullWifiLockTimer = in.readInt() != 0 ? new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mUnpluggables, in) : null;
            this.mWifiScanStarted = false;
            this.mWifiScanTimer = in.readInt() != 0 ? new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mUnpluggables, in) : null;
            this.mWifiBatchedScanBinStarted = -1;
            for (i = 0; i < 5; ++i) {
                if (in.readInt() != 0) {
                    this.makeWifiBatchedScanBin(i, in);
                    continue;
                }
                this.mWifiBatchedScanTimer[i] = null;
            }
            this.mWifiMulticastEnabled = false;
            this.mWifiMulticastTimer = in.readInt() != 0 ? new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mUnpluggables, in) : null;
            this.mAudioTurnedOn = false;
            this.mAudioTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this, 7, null, BatteryStatsImpl.this.mUnpluggables, in) : null;
            this.mVideoTurnedOn = false;
            this.mVideoTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this, 8, null, BatteryStatsImpl.this.mUnpluggables, in) : null;
            this.mForegroundActivityTimer = in.readInt() != 0 ? new StopwatchTimer(this, 10, null, BatteryStatsImpl.this.mUnpluggables, in) : null;
            this.mVibratorOnTimer = in.readInt() != 0 ? new BatchTimer(this, 9, BatteryStatsImpl.this.mUnpluggables, BatteryStatsImpl.this.mOnBatteryInternal, in) : null;
            if (in.readInt() != 0) {
                this.mUserActivityCounters = new Counter[3];
                for (i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i] = new Counter(BatteryStatsImpl.this.mUnpluggables, in);
                }
            } else {
                this.mUserActivityCounters = null;
            }
            if (in.readInt() != 0) {
                this.mNetworkActivityCounters = new LongSamplingCounter[4];
                for (i = 0; i < 4; ++i) {
                    this.mNetworkActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mUnpluggables, in);
                }
            } else {
                this.mNetworkActivityCounters = null;
            }
        }

        public Proc getProcessStatsLocked(String name) {
            Proc ps = this.mProcessStats.get(name);
            if (ps == null) {
                ps = new Proc();
                this.mProcessStats.put(name, ps);
            }
            return ps;
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return this.mPids;
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int pid) {
            BatteryStats.Uid.Pid p = this.mPids.get(pid);
            if (p == null) {
                p = new BatteryStats.Uid.Pid();
                this.mPids.put(pid, p);
            }
            return p;
        }

        public Pkg getPackageStatsLocked(String name) {
            Pkg ps = this.mPackageStats.get(name);
            if (ps == null) {
                ps = new Pkg();
                this.mPackageStats.put(name, ps);
            }
            return ps;
        }

        public Pkg.Serv getServiceStatsLocked(String pkg, String serv) {
            Pkg ps = this.getPackageStatsLocked(pkg);
            Pkg.Serv ss = ps.mServiceStats.get(serv);
            if (ss == null) {
                ss = ps.newServiceStatsLocked();
                ps.mServiceStats.put(serv, ss);
            }
            return ss;
        }

        public StopwatchTimer getWakeTimerLocked(String name, int type) {
            Wakelock wl = this.mWakelockStats.get(name);
            if (wl == null) {
                int N = this.mWakelockStats.size();
                if (N > 50) {
                    name = BatteryStatsImpl.BATCHED_WAKELOCK_NAME;
                    wl = this.mWakelockStats.get(name);
                }
                if (wl == null) {
                    wl = new Wakelock();
                    this.mWakelockStats.put(name, wl);
                }
            }
            StopwatchTimer t = null;
            switch (type) {
                case 0: {
                    t = wl.mTimerPartial;
                    if (t == null) {
                        wl.mTimerPartial = t = new StopwatchTimer(this, 0, BatteryStatsImpl.this.mPartialTimers, BatteryStatsImpl.this.mUnpluggables);
                    }
                    return t;
                }
                case 1: {
                    t = wl.mTimerFull;
                    if (t == null) {
                        wl.mTimerFull = t = new StopwatchTimer(this, 1, BatteryStatsImpl.this.mFullTimers, BatteryStatsImpl.this.mUnpluggables);
                    }
                    return t;
                }
                case 2: {
                    t = wl.mTimerWindow;
                    if (t == null) {
                        wl.mTimerWindow = t = new StopwatchTimer(this, 2, BatteryStatsImpl.this.mWindowTimers, BatteryStatsImpl.this.mUnpluggables);
                    }
                    return t;
                }
            }
            throw new IllegalArgumentException("type=" + type);
        }

        public StopwatchTimer getSensorTimerLocked(int sensor, boolean create) {
            StopwatchTimer t;
            Sensor se = this.mSensorStats.get(sensor);
            if (se == null) {
                if (!create) {
                    return null;
                }
                se = new Sensor(sensor);
                this.mSensorStats.put(sensor, se);
            }
            if ((t = se.mTimer) != null) {
                return t;
            }
            ArrayList<StopwatchTimer> timers = BatteryStatsImpl.this.mSensorTimers.get(sensor);
            if (timers == null) {
                timers = new ArrayList();
                BatteryStatsImpl.this.mSensorTimers.put(sensor, timers);
            }
            se.mTimer = t = new StopwatchTimer(this, 3, timers, BatteryStatsImpl.this.mUnpluggables);
            return t;
        }

        public void noteStartWakeLocked(int pid, String name, int type) {
            StopwatchTimer t = this.getWakeTimerLocked(name, type);
            if (t != null) {
                t.startRunningLocked(BatteryStatsImpl.this);
            }
            if (pid >= 0 && type == 0) {
                BatteryStats.Uid.Pid p = this.getPidStatsLocked(pid);
                if (p.mWakeStart == 0L) {
                    p.mWakeStart = SystemClock.elapsedRealtime();
                }
            }
        }

        public void noteStopWakeLocked(int pid, String name, int type) {
            BatteryStats.Uid.Pid p;
            StopwatchTimer t = this.getWakeTimerLocked(name, type);
            if (t != null) {
                t.stopRunningLocked(BatteryStatsImpl.this);
            }
            if (pid >= 0 && type == 0 && (p = this.mPids.get(pid)) != null && p.mWakeStart != 0L) {
                p.mWakeSum += SystemClock.elapsedRealtime() - p.mWakeStart;
                p.mWakeStart = 0L;
            }
        }

        public void reportExcessiveWakeLocked(String proc, long overTime, long usedTime) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveWake(overTime, usedTime);
            }
        }

        public void reportExcessiveCpuLocked(String proc, long overTime, long usedTime) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveCpu(overTime, usedTime);
            }
        }

        public void noteStartSensor(int sensor) {
            StopwatchTimer t = this.getSensorTimerLocked(sensor, true);
            if (t != null) {
                t.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStopSensor(int sensor) {
            StopwatchTimer t = this.getSensorTimerLocked(sensor, false);
            if (t != null) {
                t.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStartGps() {
            StopwatchTimer t = this.getSensorTimerLocked(-10000, true);
            if (t != null) {
                t.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStopGps() {
            StopwatchTimer t = this.getSensorTimerLocked(-10000, false);
            if (t != null) {
                t.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        public BatteryStatsImpl getBatteryStats() {
            return BatteryStatsImpl.this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public final class Pkg
        extends BatteryStats.Uid.Pkg
        implements Unpluggable {
            int mWakeups;
            int mLoadedWakeups;
            int mLastWakeups;
            int mUnpluggedWakeups;
            final HashMap<String, Serv> mServiceStats = new HashMap();

            Pkg() {
                BatteryStatsImpl.this.mUnpluggables.add(this);
            }

            @Override
            public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
                this.mUnpluggedWakeups = this.mWakeups;
            }

            @Override
            public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            }

            void detach() {
                BatteryStatsImpl.this.mUnpluggables.remove(this);
            }

            void readFromParcelLocked(Parcel in) {
                this.mWakeups = in.readInt();
                this.mLoadedWakeups = in.readInt();
                this.mLastWakeups = 0;
                this.mUnpluggedWakeups = in.readInt();
                int numServs = in.readInt();
                this.mServiceStats.clear();
                for (int m = 0; m < numServs; ++m) {
                    String serviceName = in.readString();
                    Serv serv = new Serv();
                    this.mServiceStats.put(serviceName, serv);
                    serv.readFromParcelLocked(in);
                }
            }

            void writeToParcelLocked(Parcel out) {
                out.writeInt(this.mWakeups);
                out.writeInt(this.mLoadedWakeups);
                out.writeInt(this.mUnpluggedWakeups);
                out.writeInt(this.mServiceStats.size());
                for (Map.Entry<String, Serv> servEntry : this.mServiceStats.entrySet()) {
                    out.writeString(servEntry.getKey());
                    Serv serv = servEntry.getValue();
                    serv.writeToParcelLocked(out);
                }
            }

            @Override
            public Map<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return this.mServiceStats;
            }

            @Override
            public int getWakeups(int which) {
                int val;
                if (which == 1) {
                    val = this.mLastWakeups;
                } else {
                    val = this.mWakeups;
                    if (which == 2) {
                        val -= this.mLoadedWakeups;
                    } else if (which == 3) {
                        val -= this.mUnpluggedWakeups;
                    }
                }
                return val;
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            public void incWakeupsLocked() {
                ++this.mWakeups;
            }

            final Serv newServiceStatsLocked() {
                return new Serv();
            }

            public final class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements Unpluggable {
                long mStartTime;
                long mRunningSince;
                boolean mRunning;
                int mStarts;
                long mLaunchedTime;
                long mLaunchedSince;
                boolean mLaunched;
                int mLaunches;
                long mLoadedStartTime;
                int mLoadedStarts;
                int mLoadedLaunches;
                long mLastStartTime;
                int mLastStarts;
                int mLastLaunches;
                long mUnpluggedStartTime;
                int mUnpluggedStarts;
                int mUnpluggedLaunches;

                Serv() {
                    BatteryStatsImpl.this.mUnpluggables.add(this);
                }

                public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
                    this.mUnpluggedStartTime = this.getStartTimeToNowLocked(batteryUptime);
                    this.mUnpluggedStarts = this.mStarts;
                    this.mUnpluggedLaunches = this.mLaunches;
                }

                public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
                }

                void detach() {
                    BatteryStatsImpl.this.mUnpluggables.remove(this);
                }

                void readFromParcelLocked(Parcel in) {
                    this.mStartTime = in.readLong();
                    this.mRunningSince = in.readLong();
                    this.mRunning = in.readInt() != 0;
                    this.mStarts = in.readInt();
                    this.mLaunchedTime = in.readLong();
                    this.mLaunchedSince = in.readLong();
                    this.mLaunched = in.readInt() != 0;
                    this.mLaunches = in.readInt();
                    this.mLoadedStartTime = in.readLong();
                    this.mLoadedStarts = in.readInt();
                    this.mLoadedLaunches = in.readInt();
                    this.mLastStartTime = 0L;
                    this.mLastStarts = 0;
                    this.mLastLaunches = 0;
                    this.mUnpluggedStartTime = in.readLong();
                    this.mUnpluggedStarts = in.readInt();
                    this.mUnpluggedLaunches = in.readInt();
                }

                void writeToParcelLocked(Parcel out) {
                    out.writeLong(this.mStartTime);
                    out.writeLong(this.mRunningSince);
                    out.writeInt(this.mRunning ? 1 : 0);
                    out.writeInt(this.mStarts);
                    out.writeLong(this.mLaunchedTime);
                    out.writeLong(this.mLaunchedSince);
                    out.writeInt(this.mLaunched ? 1 : 0);
                    out.writeInt(this.mLaunches);
                    out.writeLong(this.mLoadedStartTime);
                    out.writeInt(this.mLoadedStarts);
                    out.writeInt(this.mLoadedLaunches);
                    out.writeLong(this.mUnpluggedStartTime);
                    out.writeInt(this.mUnpluggedStarts);
                    out.writeInt(this.mUnpluggedLaunches);
                }

                long getLaunchTimeToNowLocked(long batteryUptime) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTime;
                    }
                    return this.mLaunchedTime + batteryUptime - this.mLaunchedSince;
                }

                long getStartTimeToNowLocked(long batteryUptime) {
                    if (!this.mRunning) {
                        return this.mStartTime;
                    }
                    return this.mStartTime + batteryUptime - this.mRunningSince;
                }

                public void startLaunchedLocked() {
                    if (!this.mLaunched) {
                        ++this.mLaunches;
                        this.mLaunchedSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mLaunched = true;
                    }
                }

                public void stopLaunchedLocked() {
                    if (this.mLaunched) {
                        long time = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mLaunchedSince;
                        if (time > 0L) {
                            this.mLaunchedTime += time;
                        } else {
                            --this.mLaunches;
                        }
                        this.mLaunched = false;
                    }
                }

                public void startRunningLocked() {
                    if (!this.mRunning) {
                        ++this.mStarts;
                        this.mRunningSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mRunning = true;
                    }
                }

                public void stopRunningLocked() {
                    if (this.mRunning) {
                        long time = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mRunningSince;
                        if (time > 0L) {
                            this.mStartTime += time;
                        } else {
                            --this.mStarts;
                        }
                        this.mRunning = false;
                    }
                }

                public BatteryStatsImpl getBatteryStats() {
                    return BatteryStatsImpl.this;
                }

                public int getLaunches(int which) {
                    int val;
                    if (which == 1) {
                        val = this.mLastLaunches;
                    } else {
                        val = this.mLaunches;
                        if (which == 2) {
                            val -= this.mLoadedLaunches;
                        } else if (which == 3) {
                            val -= this.mUnpluggedLaunches;
                        }
                    }
                    return val;
                }

                public long getStartTime(long now, int which) {
                    long val;
                    if (which == 1) {
                        val = this.mLastStartTime;
                    } else {
                        val = this.getStartTimeToNowLocked(now);
                        if (which == 2) {
                            val -= this.mLoadedStartTime;
                        } else if (which == 3) {
                            val -= this.mUnpluggedStartTime;
                        }
                    }
                    return val;
                }

                public int getStarts(int which) {
                    int val;
                    if (which == 1) {
                        val = this.mLastStarts;
                    } else {
                        val = this.mStarts;
                        if (which == 2) {
                            val -= this.mLoadedStarts;
                        } else if (which == 3) {
                            val -= this.mUnpluggedStarts;
                        }
                    }
                    return val;
                }
            }
        }

        public final class Proc
        extends BatteryStats.Uid.Proc
        implements Unpluggable {
            long mUserTime;
            long mSystemTime;
            long mForegroundTime;
            int mStarts;
            long mLoadedUserTime;
            long mLoadedSystemTime;
            long mLoadedForegroundTime;
            int mLoadedStarts;
            long mLastUserTime;
            long mLastSystemTime;
            long mLastForegroundTime;
            int mLastStarts;
            long mUnpluggedUserTime;
            long mUnpluggedSystemTime;
            long mUnpluggedForegroundTime;
            int mUnpluggedStarts;
            SamplingCounter[] mSpeedBins;
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;

            Proc() {
                BatteryStatsImpl.this.mUnpluggables.add(this);
                this.mSpeedBins = new SamplingCounter[BatteryStatsImpl.this.getCpuSpeedSteps()];
            }

            public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
                this.mUnpluggedUserTime = this.mUserTime;
                this.mUnpluggedSystemTime = this.mSystemTime;
                this.mUnpluggedForegroundTime = this.mForegroundTime;
                this.mUnpluggedStarts = this.mStarts;
            }

            public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            }

            void detach() {
                BatteryStatsImpl.this.mUnpluggables.remove(this);
                for (int i = 0; i < this.mSpeedBins.length; ++i) {
                    SamplingCounter c = this.mSpeedBins[i];
                    if (c == null) continue;
                    BatteryStatsImpl.this.mUnpluggables.remove(c);
                    this.mSpeedBins[i] = null;
                }
            }

            public int countExcessivePowers() {
                return this.mExcessivePower != null ? this.mExcessivePower.size() : 0;
            }

            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int i) {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.get(i);
                }
                return null;
            }

            public void addExcessiveWake(long overTime, long usedTime) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 1;
                ew.overTime = overTime;
                ew.usedTime = usedTime;
                this.mExcessivePower.add(ew);
            }

            public void addExcessiveCpu(long overTime, long usedTime) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 2;
                ew.overTime = overTime;
                ew.usedTime = usedTime;
                this.mExcessivePower.add(ew);
            }

            void writeExcessivePowerToParcelLocked(Parcel out) {
                if (this.mExcessivePower == null) {
                    out.writeInt(0);
                    return;
                }
                int N = this.mExcessivePower.size();
                out.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = this.mExcessivePower.get(i);
                    out.writeInt(ew.type);
                    out.writeLong(ew.overTime);
                    out.writeLong(ew.usedTime);
                }
            }

            boolean readExcessivePowerFromParcelLocked(Parcel in) {
                int N = in.readInt();
                if (N == 0) {
                    this.mExcessivePower = null;
                    return true;
                }
                if (N > 10000) {
                    Slog.w(BatteryStatsImpl.TAG, "File corrupt: too many excessive power entries " + N);
                    return false;
                }
                this.mExcessivePower = new ArrayList();
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                    ew.type = in.readInt();
                    ew.overTime = in.readLong();
                    ew.usedTime = in.readLong();
                    this.mExcessivePower.add(ew);
                }
                return true;
            }

            void writeToParcelLocked(Parcel out) {
                out.writeLong(this.mUserTime);
                out.writeLong(this.mSystemTime);
                out.writeLong(this.mForegroundTime);
                out.writeInt(this.mStarts);
                out.writeLong(this.mLoadedUserTime);
                out.writeLong(this.mLoadedSystemTime);
                out.writeLong(this.mLoadedForegroundTime);
                out.writeInt(this.mLoadedStarts);
                out.writeLong(this.mUnpluggedUserTime);
                out.writeLong(this.mUnpluggedSystemTime);
                out.writeLong(this.mUnpluggedForegroundTime);
                out.writeInt(this.mUnpluggedStarts);
                out.writeInt(this.mSpeedBins.length);
                for (int i = 0; i < this.mSpeedBins.length; ++i) {
                    SamplingCounter c = this.mSpeedBins[i];
                    if (c != null) {
                        out.writeInt(1);
                        c.writeToParcel(out);
                        continue;
                    }
                    out.writeInt(0);
                }
                this.writeExcessivePowerToParcelLocked(out);
            }

            void readFromParcelLocked(Parcel in) {
                int steps;
                this.mUserTime = in.readLong();
                this.mSystemTime = in.readLong();
                this.mForegroundTime = in.readLong();
                this.mStarts = in.readInt();
                this.mLoadedUserTime = in.readLong();
                this.mLoadedSystemTime = in.readLong();
                this.mLoadedForegroundTime = in.readLong();
                this.mLoadedStarts = in.readInt();
                this.mLastUserTime = 0L;
                this.mLastSystemTime = 0L;
                this.mLastForegroundTime = 0L;
                this.mLastStarts = 0;
                this.mUnpluggedUserTime = in.readLong();
                this.mUnpluggedSystemTime = in.readLong();
                this.mUnpluggedForegroundTime = in.readLong();
                this.mUnpluggedStarts = in.readInt();
                int bins = in.readInt();
                this.mSpeedBins = new SamplingCounter[bins >= (steps = BatteryStatsImpl.this.getCpuSpeedSteps()) ? bins : steps];
                for (int i = 0; i < bins; ++i) {
                    if (in.readInt() == 0) continue;
                    this.mSpeedBins[i] = new SamplingCounter(BatteryStatsImpl.this.mUnpluggables, in);
                }
                this.readExcessivePowerFromParcelLocked(in);
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            public void addCpuTimeLocked(int utime, int stime) {
                this.mUserTime += (long)utime;
                this.mSystemTime += (long)stime;
            }

            public void addForegroundTimeLocked(long ttime) {
                this.mForegroundTime += ttime;
            }

            public void incStartsLocked() {
                ++this.mStarts;
            }

            public long getUserTime(int which) {
                long val;
                if (which == 1) {
                    val = this.mLastUserTime;
                } else {
                    val = this.mUserTime;
                    if (which == 2) {
                        val -= this.mLoadedUserTime;
                    } else if (which == 3) {
                        val -= this.mUnpluggedUserTime;
                    }
                }
                return val;
            }

            public long getSystemTime(int which) {
                long val;
                if (which == 1) {
                    val = this.mLastSystemTime;
                } else {
                    val = this.mSystemTime;
                    if (which == 2) {
                        val -= this.mLoadedSystemTime;
                    } else if (which == 3) {
                        val -= this.mUnpluggedSystemTime;
                    }
                }
                return val;
            }

            public long getForegroundTime(int which) {
                long val;
                if (which == 1) {
                    val = this.mLastForegroundTime;
                } else {
                    val = this.mForegroundTime;
                    if (which == 2) {
                        val -= this.mLoadedForegroundTime;
                    } else if (which == 3) {
                        val -= this.mUnpluggedForegroundTime;
                    }
                }
                return val;
            }

            public int getStarts(int which) {
                int val;
                if (which == 1) {
                    val = this.mLastStarts;
                } else {
                    val = this.mStarts;
                    if (which == 2) {
                        val -= this.mLoadedStarts;
                    } else if (which == 3) {
                        val -= this.mUnpluggedStarts;
                    }
                }
                return val;
            }

            public void addSpeedStepTimes(long[] values) {
                for (int i = 0; i < this.mSpeedBins.length && i < values.length; ++i) {
                    long amt = values[i];
                    if (amt == 0L) continue;
                    SamplingCounter c = this.mSpeedBins[i];
                    if (c == null) {
                        this.mSpeedBins[i] = c = new SamplingCounter(BatteryStatsImpl.this.mUnpluggables);
                    }
                    c.addCountAtomic(values[i]);
                }
            }

            public long getTimeAtCpuSpeedStep(int speedStep, int which) {
                if (speedStep < this.mSpeedBins.length) {
                    SamplingCounter c = this.mSpeedBins[speedStep];
                    return c != null ? (long)c.getCountLocked(which) : 0L;
                }
                return 0L;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public final class Sensor
        extends BatteryStats.Uid.Sensor {
            final int mHandle;
            StopwatchTimer mTimer;

            public Sensor(int handle) {
                this.mHandle = handle;
            }

            private StopwatchTimer readTimerFromParcel(ArrayList<Unpluggable> unpluggables, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                ArrayList<StopwatchTimer> pool = BatteryStatsImpl.this.mSensorTimers.get(this.mHandle);
                if (pool == null) {
                    pool = new ArrayList();
                    BatteryStatsImpl.this.mSensorTimers.put(this.mHandle, pool);
                }
                return new StopwatchTimer(Uid.this, 0, pool, unpluggables, in);
            }

            boolean reset() {
                if (this.mTimer.reset(BatteryStatsImpl.this, true)) {
                    this.mTimer = null;
                    return true;
                }
                return false;
            }

            void readFromParcelLocked(ArrayList<Unpluggable> unpluggables, Parcel in) {
                this.mTimer = this.readTimerFromParcel(unpluggables, in);
            }

            void writeToParcelLocked(Parcel out, long batteryRealtime) {
                Timer.writeTimerToParcel(out, this.mTimer, batteryRealtime);
            }

            @Override
            public Timer getSensorTime() {
                return this.mTimer;
            }

            @Override
            public int getHandle() {
                return this.mHandle;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public final class Wakelock
        extends BatteryStats.Uid.Wakelock {
            StopwatchTimer mTimerPartial;
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerWindow;

            private StopwatchTimer readTimerFromParcel(int type, ArrayList<StopwatchTimer> pool, ArrayList<Unpluggable> unpluggables, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                return new StopwatchTimer(Uid.this, type, pool, unpluggables, in);
            }

            boolean reset() {
                boolean wlactive = false;
                if (this.mTimerFull != null) {
                    wlactive |= !this.mTimerFull.reset(BatteryStatsImpl.this, false);
                }
                if (this.mTimerPartial != null) {
                    wlactive |= !this.mTimerPartial.reset(BatteryStatsImpl.this, false);
                }
                if (this.mTimerWindow != null) {
                    wlactive |= !this.mTimerWindow.reset(BatteryStatsImpl.this, false);
                }
                if (!wlactive) {
                    if (this.mTimerFull != null) {
                        this.mTimerFull.detach();
                        this.mTimerFull = null;
                    }
                    if (this.mTimerPartial != null) {
                        this.mTimerPartial.detach();
                        this.mTimerPartial = null;
                    }
                    if (this.mTimerWindow != null) {
                        this.mTimerWindow.detach();
                        this.mTimerWindow = null;
                    }
                }
                return !wlactive;
            }

            void readFromParcelLocked(ArrayList<Unpluggable> unpluggables, Parcel in) {
                this.mTimerPartial = this.readTimerFromParcel(0, BatteryStatsImpl.this.mPartialTimers, unpluggables, in);
                this.mTimerFull = this.readTimerFromParcel(1, BatteryStatsImpl.this.mFullTimers, unpluggables, in);
                this.mTimerWindow = this.readTimerFromParcel(2, BatteryStatsImpl.this.mWindowTimers, unpluggables, in);
            }

            void writeToParcelLocked(Parcel out, long batteryRealtime) {
                Timer.writeTimerToParcel(out, this.mTimerPartial, batteryRealtime);
                Timer.writeTimerToParcel(out, this.mTimerFull, batteryRealtime);
                Timer.writeTimerToParcel(out, this.mTimerWindow, batteryRealtime);
            }

            @Override
            public Timer getWakeTime(int type) {
                switch (type) {
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: {
                        return this.mTimerWindow;
                    }
                }
                throw new IllegalArgumentException("type = " + type);
            }
        }
    }

    private class KernelWakelockStats {
        public int mCount;
        public long mTotalTime;
        public int mVersion;

        KernelWakelockStats(int count, long totalTime, int version) {
            this.mCount = count;
            this.mTotalTime = totalTime;
            this.mVersion = version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StopwatchTimer
    extends Timer {
        final Uid mUid;
        final ArrayList<StopwatchTimer> mTimerPool;
        int mNesting;
        long mUpdateTime;
        long mAcquireTime;
        long mTimeout;
        boolean mInList;

        StopwatchTimer(Uid uid, int type, ArrayList<StopwatchTimer> timerPool, ArrayList<Unpluggable> unpluggables, Parcel in) {
            super(type, unpluggables, in);
            this.mUid = uid;
            this.mTimerPool = timerPool;
            this.mUpdateTime = in.readLong();
        }

        StopwatchTimer(Uid uid, int type, ArrayList<StopwatchTimer> timerPool, ArrayList<Unpluggable> unpluggables) {
            super(type, unpluggables);
            this.mUid = uid;
            this.mTimerPool = timerPool;
        }

        void setTimeout(long timeout) {
            this.mTimeout = timeout;
        }

        @Override
        public void writeToParcel(Parcel out, long batteryRealtime) {
            super.writeToParcel(out, batteryRealtime);
            out.writeLong(this.mUpdateTime);
        }

        @Override
        public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            if (this.mNesting > 0) {
                super.plug(elapsedRealtime, batteryUptime, batteryRealtime);
                this.mUpdateTime = batteryRealtime;
            }
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mNesting=" + this.mNesting + " mUpdateTime=" + this.mUpdateTime + " mAcquireTime=" + this.mAcquireTime);
        }

        void startRunningLocked(BatteryStatsImpl stats) {
            if (this.mNesting++ == 0) {
                this.mUpdateTime = stats.getBatteryRealtimeLocked(SystemClock.elapsedRealtime() * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(stats, this.mTimerPool);
                    this.mTimerPool.add(this);
                }
                ++this.mCount;
                this.mAcquireTime = this.mTotalTime;
            }
        }

        boolean isRunningLocked() {
            return this.mNesting > 0;
        }

        void stopRunningLocked(BatteryStatsImpl stats) {
            if (this.mNesting == 0) {
                return;
            }
            if (--this.mNesting == 0) {
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(stats, this.mTimerPool);
                    this.mTimerPool.remove(this);
                } else {
                    long realtime = SystemClock.elapsedRealtime() * 1000L;
                    long batteryRealtime = stats.getBatteryRealtimeLocked(realtime);
                    this.mNesting = 1;
                    this.mTotalTime = this.computeRunTimeLocked(batteryRealtime);
                    this.mNesting = 0;
                }
                if (this.mTotalTime == this.mAcquireTime) {
                    --this.mCount;
                }
            }
        }

        private static void refreshTimersLocked(BatteryStatsImpl stats, ArrayList<StopwatchTimer> pool) {
            long realtime = SystemClock.elapsedRealtime() * 1000L;
            long batteryRealtime = stats.getBatteryRealtimeLocked(realtime);
            int N = pool.size();
            for (int i = N - 1; i >= 0; --i) {
                StopwatchTimer t = pool.get(i);
                long heldTime = batteryRealtime - t.mUpdateTime;
                if (heldTime > 0L) {
                    t.mTotalTime += heldTime / (long)N;
                }
                t.mUpdateTime = batteryRealtime;
            }
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            if (this.mTimeout > 0L && curBatteryRealtime > this.mUpdateTime + this.mTimeout) {
                curBatteryRealtime = this.mUpdateTime + this.mTimeout;
            }
            return this.mTotalTime + (this.mNesting > 0 ? (curBatteryRealtime - this.mUpdateTime) / (long)(this.mTimerPool != null ? this.mTimerPool.size() : 1) : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        boolean reset(BatteryStatsImpl stats, boolean detachIfReset) {
            boolean canDetach = this.mNesting <= 0;
            super.reset(stats, canDetach && detachIfReset);
            if (this.mNesting > 0) {
                this.mUpdateTime = stats.getBatteryRealtimeLocked(SystemClock.elapsedRealtime() * 1000L);
            }
            this.mAcquireTime = this.mTotalTime;
            return canDetach;
        }

        @Override
        void detach() {
            super.detach();
            if (this.mTimerPool != null) {
                this.mTimerPool.remove(this);
            }
        }

        @Override
        void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mNesting = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BatchTimer
    extends Timer {
        final Uid mUid;
        long mLastAddedTime;
        long mLastAddedDuration;
        boolean mInDischarge;

        BatchTimer(Uid uid, int type, ArrayList<Unpluggable> unpluggables, boolean inDischarge, Parcel in) {
            super(type, unpluggables, in);
            this.mUid = uid;
            this.mLastAddedTime = in.readLong();
            this.mLastAddedDuration = in.readLong();
            this.mInDischarge = inDischarge;
        }

        BatchTimer(Uid uid, int type, ArrayList<Unpluggable> unpluggables, boolean inDischarge) {
            super(type, unpluggables);
            this.mUid = uid;
            this.mInDischarge = inDischarge;
        }

        @Override
        public void writeToParcel(Parcel out, long batteryRealtime) {
            super.writeToParcel(out, batteryRealtime);
            out.writeLong(this.mLastAddedTime);
            out.writeLong(this.mLastAddedDuration);
        }

        @Override
        public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.recomputeLastDuration(SystemClock.elapsedRealtime() * 1000L, false);
            this.mInDischarge = false;
            super.plug(elapsedRealtime, batteryUptime, batteryRealtime);
        }

        @Override
        public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.recomputeLastDuration(elapsedRealtime, false);
            this.mInDischarge = true;
            if (this.mLastAddedTime == elapsedRealtime) {
                this.mTotalTime += this.mLastAddedDuration;
            }
            super.unplug(elapsedRealtime, batteryUptime, batteryRealtime);
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mLastAddedTime=" + this.mLastAddedTime + " mLastAddedDuration=" + this.mLastAddedDuration);
        }

        private long computeOverage(long curTime) {
            if (this.mLastAddedTime > 0L) {
                return this.mLastTime + this.mLastAddedDuration - curTime;
            }
            return 0L;
        }

        private void recomputeLastDuration(long curTime, boolean abort) {
            long overage = this.computeOverage(curTime);
            if (overage > 0L) {
                if (this.mInDischarge) {
                    this.mTotalTime -= overage;
                }
                if (abort) {
                    this.mLastAddedTime = 0L;
                } else {
                    this.mLastAddedTime = curTime;
                    this.mLastAddedDuration -= overage;
                }
            }
        }

        public void addDuration(BatteryStatsImpl stats, long durationMillis) {
            long now = SystemClock.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            this.mLastAddedTime = now;
            this.mLastAddedDuration = durationMillis * 1000L;
            if (this.mInDischarge) {
                this.mTotalTime += this.mLastAddedDuration;
                ++this.mCount;
            }
        }

        public void abortLastDuration(BatteryStatsImpl stats) {
            long now = SystemClock.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            long overage = this.computeOverage(SystemClock.elapsedRealtime() * 1000L);
            if (overage > 0L) {
                this.mTotalTime = overage;
                return this.mTotalTime;
            }
            return this.mTotalTime;
        }

        @Override
        boolean reset(BatteryStatsImpl stats, boolean detachIfReset) {
            long now = SystemClock.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            boolean stillActive = this.mLastAddedTime == now;
            super.reset(stats, !stillActive && detachIfReset);
            return !stillActive;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SamplingTimer
    extends Timer {
        int mCurrentReportedCount;
        int mUnpluggedReportedCount;
        long mCurrentReportedTotalTime;
        long mUnpluggedReportedTotalTime;
        boolean mInDischarge;
        boolean mTrackingReportedValues;
        int mUpdateVersion;

        SamplingTimer(ArrayList<Unpluggable> unpluggables, boolean inDischarge, Parcel in) {
            super(0, unpluggables, in);
            this.mCurrentReportedCount = in.readInt();
            this.mUnpluggedReportedCount = in.readInt();
            this.mCurrentReportedTotalTime = in.readLong();
            this.mUnpluggedReportedTotalTime = in.readLong();
            this.mTrackingReportedValues = in.readInt() == 1;
            this.mInDischarge = inDischarge;
        }

        SamplingTimer(ArrayList<Unpluggable> unpluggables, boolean inDischarge, boolean trackReportedValues) {
            super(0, unpluggables);
            this.mTrackingReportedValues = trackReportedValues;
            this.mInDischarge = inDischarge;
        }

        public void setStale() {
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mUnpluggedReportedCount = 0;
        }

        public void setUpdateVersion(int version) {
            this.mUpdateVersion = version;
        }

        public int getUpdateVersion() {
            return this.mUpdateVersion;
        }

        public void updateCurrentReportedCount(int count) {
            if (this.mInDischarge && this.mUnpluggedReportedCount == 0) {
                this.mUnpluggedReportedCount = count;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedCount = count;
        }

        public void updateCurrentReportedTotalTime(long totalTime) {
            if (this.mInDischarge && this.mUnpluggedReportedTotalTime == 0L) {
                this.mUnpluggedReportedTotalTime = totalTime;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedTotalTime = totalTime;
        }

        @Override
        public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            super.unplug(elapsedRealtime, batteryUptime, batteryRealtime);
            if (this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime;
                this.mUnpluggedReportedCount = this.mCurrentReportedCount;
            }
            this.mInDischarge = true;
        }

        @Override
        public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            super.plug(elapsedRealtime, batteryUptime, batteryRealtime);
            this.mInDischarge = false;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mCurrentReportedCount=" + this.mCurrentReportedCount + " mUnpluggedReportedCount=" + this.mUnpluggedReportedCount + " mCurrentReportedTotalTime=" + this.mCurrentReportedTotalTime + " mUnpluggedReportedTotalTime=" + this.mUnpluggedReportedTotalTime);
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            return this.mTotalTime + (this.mInDischarge && this.mTrackingReportedValues ? this.mCurrentReportedTotalTime - this.mUnpluggedReportedTotalTime : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount + (this.mInDischarge && this.mTrackingReportedValues ? this.mCurrentReportedCount - this.mUnpluggedReportedCount : 0);
        }

        @Override
        public void writeToParcel(Parcel out, long batteryRealtime) {
            super.writeToParcel(out, batteryRealtime);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mUnpluggedReportedCount);
            out.writeLong(this.mCurrentReportedTotalTime);
            out.writeLong(this.mUnpluggedReportedTotalTime);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        @Override
        boolean reset(BatteryStatsImpl stats, boolean detachIfReset) {
            super.reset(stats, detachIfReset);
            this.setStale();
            return true;
        }

        @Override
        void writeSummaryFromParcelLocked(Parcel out, long batteryRealtime) {
            super.writeSummaryFromParcelLocked(out, batteryRealtime);
            out.writeLong(this.mCurrentReportedTotalTime);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        @Override
        void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime = in.readLong();
            this.mUnpluggedReportedCount = this.mCurrentReportedCount = in.readInt();
            this.mTrackingReportedValues = in.readInt() == 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Timer
    extends BatteryStats.Timer
    implements Unpluggable {
        final int mType;
        final ArrayList<Unpluggable> mUnpluggables;
        int mCount;
        int mLoadedCount;
        int mLastCount;
        int mUnpluggedCount;
        long mTotalTime;
        long mLoadedTime;
        long mLastTime;
        long mUnpluggedTime;

        Timer(int type, ArrayList<Unpluggable> unpluggables, Parcel in) {
            this.mType = type;
            this.mUnpluggables = unpluggables;
            this.mCount = in.readInt();
            this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = in.readInt();
            this.mTotalTime = in.readLong();
            this.mLoadedTime = in.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = in.readLong();
            unpluggables.add(this);
        }

        Timer(int type, ArrayList<Unpluggable> unpluggables) {
            this.mType = type;
            this.mUnpluggables = unpluggables;
            unpluggables.add(this);
        }

        protected abstract long computeRunTimeLocked(long var1);

        protected abstract int computeCurrentCountLocked();

        boolean reset(BatteryStatsImpl stats, boolean detachIfReset) {
            this.mLastTime = 0L;
            this.mLoadedTime = 0L;
            this.mTotalTime = 0L;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            this.mCount = 0;
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        void detach() {
            this.mUnpluggables.remove(this);
        }

        public void writeToParcel(Parcel out, long batteryRealtime) {
            out.writeInt(this.mCount);
            out.writeInt(this.mLoadedCount);
            out.writeInt(this.mUnpluggedCount);
            out.writeLong(this.computeRunTimeLocked(batteryRealtime));
            out.writeLong(this.mLoadedTime);
            out.writeLong(this.mUnpluggedTime);
        }

        @Override
        public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.mUnpluggedTime = this.computeRunTimeLocked(batteryRealtime);
            this.mUnpluggedCount = this.mCount;
        }

        @Override
        public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.mTotalTime = this.computeRunTimeLocked(batteryRealtime);
            this.mCount = this.computeCurrentCountLocked();
        }

        public static void writeTimerToParcel(Parcel out, Timer timer, long batteryRealtime) {
            if (timer == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            timer.writeToParcel(out, batteryRealtime);
        }

        @Override
        public long getTotalTimeLocked(long batteryRealtime, int which) {
            long val;
            if (which == 1) {
                val = this.mLastTime;
            } else {
                val = this.computeRunTimeLocked(batteryRealtime);
                if (which == 3) {
                    val -= this.mUnpluggedTime;
                } else if (which != 0) {
                    val -= this.mLoadedTime;
                }
            }
            return val;
        }

        @Override
        public int getCountLocked(int which) {
            int val;
            if (which == 1) {
                val = this.mLastCount;
            } else {
                val = this.computeCurrentCountLocked();
                if (which == 3) {
                    val -= this.mUnpluggedCount;
                } else if (which != 0) {
                    val -= this.mLoadedCount;
                }
            }
            return val;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount);
            pw.println(prefix + "mTotalTime=" + this.mTotalTime + " mLoadedTime=" + this.mLoadedTime);
            pw.println(prefix + "mLastTime=" + this.mLastTime + " mUnpluggedTime=" + this.mUnpluggedTime);
        }

        void writeSummaryFromParcelLocked(Parcel out, long batteryRealtime) {
            long runTime = this.computeRunTimeLocked(batteryRealtime);
            out.writeLong((runTime + 500L) / 1000L);
            out.writeInt(this.mCount);
        }

        void readSummaryFromParcelLocked(Parcel in) {
            this.mTotalTime = this.mLoadedTime = in.readLong() * 1000L;
            this.mLastTime = 0L;
            this.mUnpluggedTime = this.mTotalTime;
            this.mCount = this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongSamplingCounter
    implements Unpluggable {
        final ArrayList<Unpluggable> mUnpluggables;
        long mCount;
        long mLoadedCount;
        long mLastCount;
        long mUnpluggedCount;
        long mPluggedCount;

        LongSamplingCounter(ArrayList<Unpluggable> unpluggables, Parcel in) {
            this.mUnpluggables = unpluggables;
            this.mCount = this.mPluggedCount = in.readLong();
            this.mLoadedCount = in.readLong();
            this.mLastCount = 0L;
            this.mUnpluggedCount = in.readLong();
            unpluggables.add(this);
        }

        LongSamplingCounter(ArrayList<Unpluggable> unpluggables) {
            this.mUnpluggables = unpluggables;
            unpluggables.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeLong(this.mCount);
            out.writeLong(this.mLoadedCount);
            out.writeLong(this.mUnpluggedCount);
        }

        @Override
        public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount = this.mPluggedCount;
        }

        @Override
        public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.mPluggedCount = this.mCount;
        }

        public long getCountLocked(int which) {
            long val;
            if (which == 1) {
                val = this.mLastCount;
            } else {
                val = this.mCount;
                if (which == 3) {
                    val -= this.mUnpluggedCount;
                } else if (which != 0) {
                    val -= this.mLoadedCount;
                }
            }
            return val;
        }

        void addCountLocked(long count) {
            this.mCount += count;
        }

        void reset(boolean detachIfReset) {
            this.mCount = 0L;
            this.mUnpluggedCount = 0L;
            this.mPluggedCount = 0L;
            this.mLastCount = 0L;
            this.mLoadedCount = 0L;
            if (detachIfReset) {
                this.detach();
            }
        }

        void detach() {
            this.mUnpluggables.remove(this);
        }

        void writeSummaryFromParcelLocked(Parcel out) {
            out.writeLong(this.mCount);
        }

        void readSummaryFromParcelLocked(Parcel in) {
            this.mCount = this.mLoadedCount = in.readLong();
            this.mLastCount = 0L;
            this.mUnpluggedCount = this.mPluggedCount = this.mLoadedCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SamplingCounter
    extends Counter {
        SamplingCounter(ArrayList<Unpluggable> unpluggables, Parcel in) {
            super(unpluggables, in);
        }

        SamplingCounter(ArrayList<Unpluggable> unpluggables) {
            super(unpluggables);
        }

        public void addCountAtomic(long count) {
            this.mCount.addAndGet((int)count);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Counter
    extends BatteryStats.Counter
    implements Unpluggable {
        final AtomicInteger mCount = new AtomicInteger();
        final ArrayList<Unpluggable> mUnpluggables;
        int mLoadedCount;
        int mLastCount;
        int mUnpluggedCount;
        int mPluggedCount;

        Counter(ArrayList<Unpluggable> unpluggables, Parcel in) {
            this.mUnpluggables = unpluggables;
            this.mPluggedCount = in.readInt();
            this.mCount.set(this.mPluggedCount);
            this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = in.readInt();
            unpluggables.add(this);
        }

        Counter(ArrayList<Unpluggable> unpluggables) {
            this.mUnpluggables = unpluggables;
            unpluggables.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeInt(this.mCount.get());
            out.writeInt(this.mLoadedCount);
            out.writeInt(this.mUnpluggedCount);
        }

        @Override
        public void unplug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount.set(this.mPluggedCount);
        }

        @Override
        public void plug(long elapsedRealtime, long batteryUptime, long batteryRealtime) {
            this.mPluggedCount = this.mCount.get();
        }

        public static void writeCounterToParcel(Parcel out, Counter counter) {
            if (counter == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            counter.writeToParcel(out);
        }

        @Override
        public int getCountLocked(int which) {
            int val;
            if (which == 1) {
                val = this.mLastCount;
            } else {
                val = this.mCount.get();
                if (which == 3) {
                    val -= this.mUnpluggedCount;
                } else if (which != 0) {
                    val -= this.mLoadedCount;
                }
            }
            return val;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount.get() + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        void stepAtomic() {
            this.mCount.incrementAndGet();
        }

        void reset(boolean detachIfReset) {
            this.mCount.set(0);
            this.mUnpluggedCount = 0;
            this.mPluggedCount = 0;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            if (detachIfReset) {
                this.detach();
            }
        }

        void detach() {
            this.mUnpluggables.remove(this);
        }

        void writeSummaryFromParcelLocked(Parcel out) {
            int count = this.mCount.get();
            out.writeInt(count);
        }

        void readSummaryFromParcelLocked(Parcel in) {
            this.mLoadedCount = in.readInt();
            this.mCount.set(this.mLoadedCount);
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mPluggedCount = this.mLoadedCount;
        }
    }

    public static interface Unpluggable {
        public void unplug(long var1, long var3, long var5);

        public void plug(long var1, long var3, long var5);
    }

    final class MyHandler
    extends Handler {
        MyHandler() {
        }

        public void handleMessage(Message msg) {
            BatteryCallback cb = BatteryStatsImpl.this.mCallback;
            switch (msg.what) {
                case 1: {
                    if (cb == null) break;
                    cb.batteryNeedsCpuUpdate();
                    break;
                }
                case 2: {
                    if (cb == null) break;
                    cb.batteryPowerChanged(msg.arg1 != 0);
                }
            }
        }
    }

    public static interface BatteryCallback {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);
    }
}

