/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.FrameLayout;
import java.util.Arrays;

public class ImmersiveModeConfirmation {
    private static final String TAG = "ImmersiveModeConfirmation";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_SHOW_EVERY_TIME = false;
    private final Context mContext;
    private final H mHandler;
    private final ArraySet<String> mConfirmedPackages = new ArraySet();
    private final long mShowDelayMs;
    private final long mPanicThresholdMs;
    private ClingWindowView mClingWindow;
    private String mLastPackage;
    private String mPromptPackage;
    private long mPanicTime;
    private String mPanicPackage;
    private WindowManager mWindowManager;

    public ImmersiveModeConfirmation(Context context) {
        this.mContext = context;
        this.mHandler = new H();
        this.mShowDelayMs = this.getNavBarExitDuration() * 3L;
        this.mPanicThresholdMs = context.getResources().getInteger(17694791);
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
    }

    private long getNavBarExitDuration() {
        Animation exit = AnimationUtils.loadAnimation(this.mContext, 17432597);
        return exit != null ? exit.getDuration() : 0L;
    }

    public void loadSetting() {
        this.mConfirmedPackages.clear();
        String packages = null;
        try {
            packages = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "immersive_mode_confirmations", -2);
            if (packages != null) {
                this.mConfirmedPackages.addAll(Arrays.asList(packages.split(",")));
            }
        }
        catch (Throwable t) {
            Slog.w(TAG, "Error loading confirmations, packages=" + packages, t);
        }
    }

    private void saveSetting() {
        try {
            String packages = TextUtils.join((CharSequence)",", this.mConfirmedPackages);
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "immersive_mode_confirmations", packages, -2);
        }
        catch (Throwable t) {
            Slog.w(TAG, "Error saving confirmations, mConfirmedPackages=" + this.mConfirmedPackages, t);
        }
    }

    public void immersiveModeChanged(String pkg, boolean isImmersiveMode) {
        if (pkg == null) {
            return;
        }
        this.mHandler.removeMessages(0);
        if (isImmersiveMode) {
            this.mLastPackage = pkg;
            if (!this.mConfirmedPackages.contains(pkg)) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0, pkg), this.mShowDelayMs);
            }
        } else {
            this.mLastPackage = null;
            this.mHandler.sendEmptyMessage(1);
        }
    }

    public void onPowerKeyDown(boolean isScreenOn, long time, boolean inImmersiveMode) {
        if (this.mPanicPackage != null && !isScreenOn && time - this.mPanicTime < this.mPanicThresholdMs) {
            this.unconfirmPackage(this.mPanicPackage);
        }
        if (isScreenOn && inImmersiveMode) {
            this.mPanicTime = time;
            this.mPanicPackage = this.mLastPackage;
        } else {
            this.mPanicTime = 0L;
            this.mPanicPackage = null;
        }
    }

    public void confirmCurrentPrompt() {
        this.mHandler.post(this.confirmAction(this.mPromptPackage));
    }

    private void unconfirmPackage(String pkg) {
        if (pkg != null) {
            this.mConfirmedPackages.remove(pkg);
            this.saveSetting();
        }
    }

    private void handleHide() {
        if (this.mClingWindow != null) {
            this.mWindowManager.removeView(this.mClingWindow);
            this.mClingWindow = null;
        }
    }

    public WindowManager.LayoutParams getClingWindowLayoutParams() {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1, 2005, 0x1000108, -3);
        lp.setTitle(TAG);
        lp.windowAnimations = 16974325;
        lp.gravity = 119;
        return lp;
    }

    public FrameLayout.LayoutParams getBubbleLayoutParams() {
        return new FrameLayout.LayoutParams(this.mContext.getResources().getDimensionPixelSize(17105021), -2, 49);
    }

    private void handleShow(String pkg) {
        this.mPromptPackage = pkg;
        this.mClingWindow = new ClingWindowView(this.mContext, this.confirmAction(pkg));
        this.mClingWindow.setSystemUiVisibility(768);
        WindowManager.LayoutParams lp = this.getClingWindowLayoutParams();
        this.mWindowManager.addView(this.mClingWindow, lp);
    }

    private Runnable confirmAction(final String pkg) {
        return new Runnable(){

            public void run() {
                if (pkg != null && !ImmersiveModeConfirmation.this.mConfirmedPackages.contains(pkg)) {
                    ImmersiveModeConfirmation.this.mConfirmedPackages.add(pkg);
                    ImmersiveModeConfirmation.this.saveSetting();
                }
                ImmersiveModeConfirmation.this.handleHide();
            }
        };
    }

    private final class H
    extends Handler {
        private static final int SHOW = 0;
        private static final int HIDE = 1;

        private H() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    ImmersiveModeConfirmation.this.handleShow((String)msg.obj);
                    break;
                }
                case 1: {
                    ImmersiveModeConfirmation.this.handleHide();
                }
            }
        }
    }

    private class ClingWindowView
    extends FrameLayout {
        private static final int BGCOLOR = Integer.MIN_VALUE;
        private static final int OFFSET_DP = 48;
        private final Runnable mConfirm;
        private final ColorDrawable mColor;
        private ValueAnimator mColorAnim;
        private ViewGroup mClingLayout;
        private Runnable mUpdateLayoutRunnable;
        private BroadcastReceiver mReceiver;

        public ClingWindowView(Context context, Runnable confirm) {
            super(context);
            this.mColor = new ColorDrawable(0);
            this.mUpdateLayoutRunnable = new Runnable(){

                public void run() {
                    if (ClingWindowView.this.mClingLayout != null && ClingWindowView.this.mClingLayout.getParent() != null) {
                        ClingWindowView.this.mClingLayout.setLayoutParams(ImmersiveModeConfirmation.this.getBubbleLayoutParams());
                    }
                }
            };
            this.mReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                        ClingWindowView.this.post(ClingWindowView.this.mUpdateLayoutRunnable);
                    }
                }
            };
            this.mConfirm = confirm;
            this.setClickable(true);
            this.setBackground(this.mColor);
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            DisplayMetrics metrics = new DisplayMetrics();
            ImmersiveModeConfirmation.this.mWindowManager.getDefaultDisplay().getMetrics(metrics);
            float density = metrics.density;
            this.mClingLayout = (ViewGroup)View.inflate(this.getContext(), 17367115, null);
            Button ok = (Button)this.mClingLayout.findViewById(16908977);
            ok.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ClingWindowView.this.mConfirm.run();
                }
            });
            this.addView((View)this.mClingLayout, ImmersiveModeConfirmation.this.getBubbleLayoutParams());
            if (ActivityManager.isHighEndGfx()) {
                View bubble = this.mClingLayout.findViewById(16908358);
                bubble.setAlpha(0.0f);
                bubble.setTranslationY(-48.0f * density);
                bubble.animate().alpha(1.0f).translationY(0.0f).setDuration(300L).setInterpolator(new DecelerateInterpolator()).start();
                ok.setAlpha(0.0f);
                ok.setTranslationY(-48.0f * density);
                ok.animate().alpha(1.0f).translationY(0.0f).setDuration(300L).setStartDelay(200L).setInterpolator(new DecelerateInterpolator()).start();
                this.mColorAnim = ValueAnimator.ofObject(new ArgbEvaluator(), 0, Integer.MIN_VALUE);
                this.mColorAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int c = (Integer)animation.getAnimatedValue();
                        ClingWindowView.this.mColor.setColor(c);
                    }
                });
                this.mColorAnim.setDuration(1000L);
                this.mColorAnim.start();
            } else {
                this.mColor.setColor(Integer.MIN_VALUE);
            }
            this.mContext.registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
        }

        public void onDetachedFromWindow() {
            this.mContext.unregisterReceiver(this.mReceiver);
        }

        public boolean onTouchEvent(MotionEvent motion) {
            Slog.v(ImmersiveModeConfirmation.TAG, "ClingWindowView.onTouchEvent");
            return true;
        }
    }
}

