/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManager;
import android.app.Dialog;
import android.app.StatusBarManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.android.internal.policy.impl.IconUtilities;
import java.util.List;

public class RecentApplicationsDialog
extends Dialog
implements View.OnClickListener {
    private static final boolean DBG_FORCE_EMPTY_LIST = false;
    private static StatusBarManager sStatusBar;
    private static final int NUM_BUTTONS = 8;
    private static final int MAX_RECENT_TASKS = 16;
    final TextView[] mIcons = new TextView[8];
    View mNoAppsText;
    IntentFilter mBroadcastIntentFilter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
    Handler mHandler = new Handler();
    Runnable mCleanup = new Runnable(){

        public void run() {
            for (TextView icon : RecentApplicationsDialog.this.mIcons) {
                icon.setCompoundDrawables(null, null, null, null);
                icon.setTag(null);
            }
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String reason;
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) && !"recentapps".equals(reason = intent.getStringExtra("reason"))) {
                RecentApplicationsDialog.this.dismiss();
            }
        }
    };

    public RecentApplicationsDialog(Context context) {
        super(context, 16974600);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Context context = this.getContext();
        if (sStatusBar == null) {
            sStatusBar = (StatusBarManager)context.getSystemService("statusbar");
        }
        Window window = this.getWindow();
        window.requestFeature(1);
        window.setType(2028);
        window.setFlags(131072, 131072);
        window.setTitle("Recents");
        this.setContentView(17367172);
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.height = -1;
        window.setAttributes(params);
        window.setFlags(0, 2);
        this.mIcons[0] = (TextView)this.findViewById(16909054);
        this.mIcons[1] = (TextView)this.findViewById(16908313);
        this.mIcons[2] = (TextView)this.findViewById(16908314);
        this.mIcons[3] = (TextView)this.findViewById(16908315);
        this.mIcons[4] = (TextView)this.findViewById(16909055);
        this.mIcons[5] = (TextView)this.findViewById(16909056);
        this.mIcons[6] = (TextView)this.findViewById(16909057);
        this.mIcons[7] = (TextView)this.findViewById(16909058);
        this.mNoAppsText = this.findViewById(16909053);
        for (TextView b : this.mIcons) {
            b.setOnClickListener(this);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 61) {
            int numButtons;
            boolean backward = event.isShiftPressed();
            int numIcons = this.mIcons.length;
            for (numButtons = 0; numButtons < numIcons && this.mIcons[numButtons].getVisibility() == 0; ++numButtons) {
            }
            if (numButtons != 0) {
                int direction;
                int nextFocus = backward ? numButtons - 1 : 0;
                for (int i = 0; i < numButtons; ++i) {
                    if (!this.mIcons[i].hasFocus()) continue;
                    if (backward) {
                        nextFocus = (i + numButtons - 1) % numButtons;
                        break;
                    }
                    nextFocus = (i + 1) % numButtons;
                    break;
                }
                int n = direction = backward ? 1 : 2;
                if (this.mIcons[nextFocus].requestFocus(direction)) {
                    this.mIcons[nextFocus].playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
                }
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void dismissAndSwitch() {
        int numIcons = this.mIcons.length;
        RecentTag tag = null;
        for (int i = 0; i < numIcons && this.mIcons[i].getVisibility() == 0; ++i) {
            if (i != 0 && !this.mIcons[i].hasFocus()) continue;
            tag = (RecentTag)this.mIcons[i].getTag();
            if (this.mIcons[i].hasFocus()) break;
        }
        if (tag != null) {
            this.switchTo(tag);
        }
        this.dismiss();
    }

    public void onClick(View v) {
        for (TextView b : this.mIcons) {
            if (b != v) continue;
            RecentTag tag = (RecentTag)b.getTag();
            this.switchTo(tag);
            break;
        }
        this.dismiss();
    }

    private void switchTo(RecentTag tag) {
        if (tag.info.id >= 0) {
            ActivityManager am = (ActivityManager)this.getContext().getSystemService("activity");
            am.moveTaskToFront(tag.info.id, 1);
        } else if (tag.intent != null) {
            tag.intent.addFlags(0x104000);
            try {
                this.getContext().startActivity(tag.intent);
            }
            catch (ActivityNotFoundException e) {
                Log.w("Recent", "Unable to launch recent task", e);
            }
        }
    }

    public void onStart() {
        super.onStart();
        this.reloadButtons();
        if (sStatusBar != null) {
            sStatusBar.disable(65536);
        }
        this.getContext().registerReceiver(this.mBroadcastReceiver, this.mBroadcastIntentFilter);
        this.mHandler.removeCallbacks(this.mCleanup);
    }

    public void onStop() {
        super.onStop();
        if (sStatusBar != null) {
            sStatusBar.disable(0);
        }
        this.getContext().unregisterReceiver(this.mBroadcastReceiver);
        this.mHandler.postDelayed(this.mCleanup, 100L);
    }

    private void reloadButtons() {
        Context context = this.getContext();
        PackageManager pm = context.getPackageManager();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List<ActivityManager.RecentTaskInfo> recentTasks = am.getRecentTasks(16, 2);
        ActivityInfo homeInfo = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME").resolveActivityInfo(pm, 0);
        IconUtilities iconUtilities = new IconUtilities(this.getContext());
        int index = 0;
        int numTasks = recentTasks.size();
        for (int i = 0; i < numTasks && index < 8; ++i) {
            ActivityManager.RecentTaskInfo info = recentTasks.get(i);
            Intent intent = new Intent(info.baseIntent);
            if (info.origActivity != null) {
                intent.setComponent(info.origActivity);
            }
            if (homeInfo != null && homeInfo.packageName.equals(intent.getComponent().getPackageName()) && homeInfo.name.equals(intent.getComponent().getClassName())) continue;
            intent.setFlags(intent.getFlags() & 0xFFDFFFFF | 0x10000000);
            ResolveInfo resolveInfo = pm.resolveActivity(intent, 0);
            if (resolveInfo == null) continue;
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            String title = ((Object)activityInfo.loadLabel(pm)).toString();
            Drawable icon = activityInfo.loadIcon(pm);
            if (title == null || title.length() <= 0 || icon == null) continue;
            TextView tv = this.mIcons[index];
            tv.setText(title);
            icon = iconUtilities.createIconDrawable(icon);
            tv.setCompoundDrawables(null, icon, null, null);
            RecentTag tag = new RecentTag();
            tag.info = info;
            tag.intent = intent;
            tv.setTag(tag);
            tv.setVisibility(0);
            tv.setPressed(false);
            tv.clearFocus();
            ++index;
        }
        this.mNoAppsText.setVisibility(index == 0 ? 0 : 8);
        while (index < 8) {
            this.mIcons[index].setVisibility(8);
            ++index;
        }
    }

    class RecentTag {
        ActivityManager.RecentTaskInfo info;
        Intent intent;

        RecentTag() {
        }
    }
}

