/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class IccCardProxy
extends Handler
implements IccCard {
    private static final boolean DBG = true;
    private static final String LOG_TAG = "IccCardProxy";
    private static final int EVENT_RADIO_OFF_OR_UNAVAILABLE = 1;
    private static final int EVENT_RADIO_ON = 2;
    private static final int EVENT_ICC_CHANGED = 3;
    private static final int EVENT_ICC_ABSENT = 4;
    private static final int EVENT_ICC_LOCKED = 5;
    private static final int EVENT_APP_READY = 6;
    private static final int EVENT_RECORDS_LOADED = 7;
    private static final int EVENT_IMSI_READY = 8;
    private static final int EVENT_NETWORK_LOCKED = 9;
    private static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 11;
    private final Object mLock = new Object();
    private Context mContext;
    private CommandsInterface mCi;
    private RegistrantList mAbsentRegistrants = new RegistrantList();
    private RegistrantList mPinLockedRegistrants = new RegistrantList();
    private RegistrantList mNetworkLockedRegistrants = new RegistrantList();
    private int mCurrentAppType = 1;
    private UiccController mUiccController = null;
    private UiccCard mUiccCard = null;
    private UiccCardApplication mUiccApplication = null;
    private IccRecords mIccRecords = null;
    private CdmaSubscriptionSourceManager mCdmaSSM = null;
    private boolean mRadioOn = false;
    private boolean mQuietMode = false;
    private boolean mInitialized = false;
    private IccCardConstants.State mExternalState = IccCardConstants.State.UNKNOWN;

    public IccCardProxy(Context context, CommandsInterface ci) {
        this.log("Creating");
        this.mContext = context;
        this.mCi = ci;
        this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(context, ci, this, 11, null);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 3, null);
        ci.registerForOn(this, 2, null);
        ci.registerForOffOrNotAvailable(this, 1, null);
        this.setExternalState(IccCardConstants.State.NOT_READY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Disposing");
            this.mUiccController.unregisterForIccChanged(this);
            this.mUiccController = null;
            this.mCi.unregisterForOn(this);
            this.mCi.unregisterForOffOrNotAvailable(this);
            this.mCdmaSSM.dispose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceRadioTech(int radioTech) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Setting radio tech " + ServiceState.rilRadioTechnologyToString(radioTech));
            this.mCurrentAppType = ServiceState.isGsm(radioTech) ? 1 : 2;
            this.updateQuietMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuietMode() {
        Object object = this.mLock;
        synchronized (object) {
            boolean newQuietMode;
            boolean isLteOnCdmaMode;
            boolean oldQuietMode = this.mQuietMode;
            int cdmaSource = -1;
            boolean bl = isLteOnCdmaMode = TelephonyManager.getLteOnCdmaModeStatic() == 1;
            if (this.mCurrentAppType == 1) {
                newQuietMode = false;
                this.log("updateQuietMode: 3GPP subscription -> newQuietMode=" + newQuietMode);
            } else {
                if (isLteOnCdmaMode) {
                    this.log("updateQuietMode: is cdma/lte device, force IccCardProxy into 3gpp mode");
                    this.mCurrentAppType = 1;
                }
                cdmaSource = this.mCdmaSSM != null ? this.mCdmaSSM.getCdmaSubscriptionSource() : -1;
                boolean bl2 = newQuietMode = cdmaSource == 1 && this.mCurrentAppType == 2 && !isLteOnCdmaMode;
            }
            if (!this.mQuietMode && newQuietMode) {
                this.log("Switching to QuietMode.");
                this.setExternalState(IccCardConstants.State.READY);
                this.mQuietMode = newQuietMode;
            } else if (this.mQuietMode && !newQuietMode) {
                this.log("updateQuietMode: Switching out from QuietMode. Force broadcast of current state=" + (Object)((Object)this.mExternalState));
                this.mQuietMode = newQuietMode;
                this.setExternalState(this.mExternalState, true);
            }
            this.log("updateQuietMode: QuietMode is " + this.mQuietMode + " (app_type=" + this.mCurrentAppType + " isLteOnCdmaMode=" + isLteOnCdmaMode + " cdmaSource=" + cdmaSource + ")");
            this.mInitialized = true;
            this.sendMessage(this.obtainMessage(3));
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.mRadioOn = false;
                break;
            }
            case 2: {
                this.mRadioOn = true;
                if (this.mInitialized) break;
                this.updateQuietMode();
                break;
            }
            case 3: {
                if (!this.mInitialized) break;
                this.updateIccAvailability();
                break;
            }
            case 4: {
                this.mAbsentRegistrants.notifyRegistrants();
                this.setExternalState(IccCardConstants.State.ABSENT);
                break;
            }
            case 5: {
                this.processLockedState();
                break;
            }
            case 6: {
                this.setExternalState(IccCardConstants.State.READY);
                break;
            }
            case 7: {
                this.broadcastIccStateChangedIntent("LOADED", null);
                break;
            }
            case 8: {
                this.broadcastIccStateChangedIntent("IMSI", null);
                break;
            }
            case 9: {
                this.mNetworkLockedRegistrants.notifyRegistrants();
                this.setExternalState(IccCardConstants.State.NETWORK_LOCKED);
                break;
            }
            case 11: {
                this.updateQuietMode();
                break;
            }
            default: {
                this.loge("Unhandled message with number: " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIccAvailability() {
        Object object = this.mLock;
        synchronized (object) {
            UiccCard newCard = this.mUiccController.getUiccCard();
            IccCardStatus.CardState state = IccCardStatus.CardState.CARDSTATE_ABSENT;
            UiccCardApplication newApp = null;
            IccRecords newRecords = null;
            if (newCard != null) {
                state = newCard.getCardState();
                newApp = newCard.getApplication(this.mCurrentAppType);
                if (newApp != null) {
                    newRecords = newApp.getIccRecords();
                }
            }
            if (this.mIccRecords != newRecords || this.mUiccApplication != newApp || this.mUiccCard != newCard) {
                this.log("Icc changed. Reregestering.");
                this.unregisterUiccCardEvents();
                this.mUiccCard = newCard;
                this.mUiccApplication = newApp;
                this.mIccRecords = newRecords;
                this.registerUiccCardEvents();
            }
            this.updateExternalState();
        }
    }

    private void updateExternalState() {
        if (this.mUiccCard == null || this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ABSENT) {
            if (this.mRadioOn) {
                this.setExternalState(IccCardConstants.State.ABSENT);
            } else {
                this.setExternalState(IccCardConstants.State.NOT_READY);
            }
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ERROR || this.mUiccApplication == null) {
            this.setExternalState(IccCardConstants.State.UNKNOWN);
            return;
        }
        switch (this.mUiccApplication.getState()) {
            case APPSTATE_UNKNOWN: 
            case APPSTATE_DETECTED: {
                this.setExternalState(IccCardConstants.State.UNKNOWN);
                break;
            }
            case APPSTATE_PIN: {
                this.setExternalState(IccCardConstants.State.PIN_REQUIRED);
                break;
            }
            case APPSTATE_PUK: {
                this.setExternalState(IccCardConstants.State.PUK_REQUIRED);
                break;
            }
            case APPSTATE_SUBSCRIPTION_PERSO: {
                if (this.mUiccApplication.getPersoSubState() == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
                    this.setExternalState(IccCardConstants.State.NETWORK_LOCKED);
                    break;
                }
                this.setExternalState(IccCardConstants.State.UNKNOWN);
                break;
            }
            case APPSTATE_READY: {
                this.setExternalState(IccCardConstants.State.READY);
            }
        }
    }

    private void registerUiccCardEvents() {
        if (this.mUiccCard != null) {
            this.mUiccCard.registerForAbsent(this, 4, null);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.registerForReady(this, 6, null);
            this.mUiccApplication.registerForLocked(this, 5, null);
            this.mUiccApplication.registerForNetworkLocked(this, 9, null);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.registerForImsiReady(this, 8, null);
            this.mIccRecords.registerForRecordsLoaded(this, 7, null);
        }
    }

    private void unregisterUiccCardEvents() {
        if (this.mUiccCard != null) {
            this.mUiccCard.unregisterForAbsent(this);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.unregisterForReady(this);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.unregisterForLocked(this);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.unregisterForNetworkLocked(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForImsiReady(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForRecordsLoaded(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastIccStateChangedIntent(String value, String reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mQuietMode) {
                this.log("QuietMode: NOT Broadcasting intent ACTION_SIM_STATE_CHANGED " + value + " reason " + reason);
                return;
            }
            Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
            intent.addFlags(0x20000000);
            intent.putExtra("phoneName", "Phone");
            intent.putExtra("ss", value);
            intent.putExtra("reason", reason);
            this.log("Broadcasting intent ACTION_SIM_STATE_CHANGED " + value + " reason " + reason);
            ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE", -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLockedState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication == null) {
                return;
            }
            IccCardStatus.PinState pin1State = this.mUiccApplication.getPin1State();
            if (pin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
                this.setExternalState(IccCardConstants.State.PERM_DISABLED);
                return;
            }
            IccCardApplicationStatus.AppState appState = this.mUiccApplication.getState();
            switch (appState) {
                case APPSTATE_PIN: {
                    this.mPinLockedRegistrants.notifyRegistrants();
                    this.setExternalState(IccCardConstants.State.PIN_REQUIRED);
                    break;
                }
                case APPSTATE_PUK: {
                    this.setExternalState(IccCardConstants.State.PUK_REQUIRED);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExternalState(IccCardConstants.State newState, boolean override) {
        Object object = this.mLock;
        synchronized (object) {
            if (!override && newState == this.mExternalState) {
                return;
            }
            this.mExternalState = newState;
            SystemProperties.set("gsm.sim.state", this.mExternalState.toString());
            this.broadcastIccStateChangedIntent(this.getIccStateIntentString(this.mExternalState), this.getIccStateReason(this.mExternalState));
        }
    }

    private void setExternalState(IccCardConstants.State newState) {
        this.setExternalState(newState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIccRecordsLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getRecordsLoaded();
            }
            return false;
        }
    }

    private String getIccStateIntentString(IccCardConstants.State state) {
        switch (state) {
            case ABSENT: {
                return "ABSENT";
            }
            case PIN_REQUIRED: {
                return "LOCKED";
            }
            case PUK_REQUIRED: {
                return "LOCKED";
            }
            case NETWORK_LOCKED: {
                return "LOCKED";
            }
            case READY: {
                return "READY";
            }
            case NOT_READY: {
                return "NOT_READY";
            }
            case PERM_DISABLED: {
                return "LOCKED";
            }
        }
        return "UNKNOWN";
    }

    private String getIccStateReason(IccCardConstants.State state) {
        switch (state) {
            case PIN_REQUIRED: {
                return "PIN";
            }
            case PUK_REQUIRED: {
                return "PUK";
            }
            case NETWORK_LOCKED: {
                return "NETWORK";
            }
            case PERM_DISABLED: {
                return "PERM_DISABLED";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardConstants.State getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExternalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccRecords getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccFileHandler getIccFileHandler() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                return this.mUiccApplication.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForAbsent(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mAbsentRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.ABSENT) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForAbsent(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAbsentRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.NETWORK_LOCKED) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mPinLockedRegistrants.add(r);
            if (this.getState().isPinLocked()) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk(puk, newPin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin2(pin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk2(puk2, newPin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyNetworkDepersonalization(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("CommandsInterface is not set.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIccLockEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccLockEnabled() : false;
            return retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccFdnEnabled() : false;
            return retValue;
        }
    }

    public boolean getIccFdnAvailable() {
        boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccFdnAvailable() : false;
        return retValue;
    }

    public boolean getIccPin2Blocked() {
        Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccPin2Blocked() : false;
        return retValue;
    }

    public boolean getIccPuk2Blocked() {
        Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccPuk2Blocked() : false;
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccLockEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccFdnEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccLockPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccFdnPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceProviderName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getServiceProviderName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccCard != null ? this.mUiccCard.isApplicationOnIcc(type) : false;
            return retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIccCard() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccCard != null && this.mUiccCard.getCardState() != IccCardStatus.CardState.CARDSTATE_ABSENT;
            {
            }
        }
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("IccCardProxy: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mAbsentRegistrants: size=" + this.mAbsentRegistrants.size());
        for (i = 0; i < this.mAbsentRegistrants.size(); ++i) {
            pw.println("  mAbsentRegistrants[" + i + "]=" + ((Registrant)this.mAbsentRegistrants.get(i)).getHandler());
        }
        pw.println(" mPinLockedRegistrants: size=" + this.mPinLockedRegistrants.size());
        for (i = 0; i < this.mPinLockedRegistrants.size(); ++i) {
            pw.println("  mPinLockedRegistrants[" + i + "]=" + ((Registrant)this.mPinLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mCurrentAppType=" + this.mCurrentAppType);
        pw.println(" mUiccController=" + this.mUiccController);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mUiccApplication=" + this.mUiccApplication);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mRadioOn=" + this.mRadioOn);
        pw.println(" mQuietMode=" + this.mQuietMode);
        pw.println(" mInitialized=" + this.mInitialized);
        pw.println(" mExternalState=" + (Object)((Object)this.mExternalState));
        pw.flush();
    }
}

