/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.cat.CatService;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UiccCard {
    protected static final String LOG_TAG = "UiccCard";
    protected static final boolean DBG = true;
    private final Object mLock = new Object();
    private IccCardStatus.CardState mCardState;
    private IccCardStatus.PinState mUniversalPinState;
    private int mGsmUmtsSubscriptionAppIndex;
    private int mCdmaSubscriptionAppIndex;
    private int mImsSubscriptionAppIndex;
    private UiccCardApplication[] mUiccApplications = new UiccCardApplication[8];
    private Context mContext;
    private CommandsInterface mCi;
    private CatService mCatService;
    private boolean mDestroyed = false;
    private CommandsInterface.RadioState mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
    private RegistrantList mAbsentRegistrants = new RegistrantList();
    private static final int EVENT_CARD_REMOVED = 13;
    private static final int EVENT_CARD_ADDED = 14;
    protected Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (UiccCard.this.mDestroyed) {
                UiccCard.this.loge("Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
                return;
            }
            switch (msg.what) {
                case 13: {
                    UiccCard.this.onIccSwap(false);
                    break;
                }
                case 14: {
                    UiccCard.this.onIccSwap(true);
                    break;
                }
                default: {
                    UiccCard.this.loge("Unknown Event " + msg.what);
                }
            }
        }
    };

    public UiccCard(Context c, CommandsInterface ci, IccCardStatus ics) {
        this.log("Creating");
        this.mCardState = ics.mCardState;
        this.update(c, ci, ics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Disposing card");
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            for (UiccCardApplication app : this.mUiccApplications) {
                if (app == null) continue;
                app.dispose();
            }
            this.mCatService = null;
            this.mUiccApplications = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Context c, CommandsInterface ci, IccCardStatus ics) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                this.loge("Updated after destroyed! Fix me!");
                return;
            }
            IccCardStatus.CardState oldState = this.mCardState;
            this.mCardState = ics.mCardState;
            this.mUniversalPinState = ics.mUniversalPinState;
            this.mGsmUmtsSubscriptionAppIndex = ics.mGsmUmtsSubscriptionAppIndex;
            this.mCdmaSubscriptionAppIndex = ics.mCdmaSubscriptionAppIndex;
            this.mImsSubscriptionAppIndex = ics.mImsSubscriptionAppIndex;
            this.mContext = c;
            this.mCi = ci;
            this.log(ics.mApplications.length + " applications");
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null) {
                    if (i >= ics.mApplications.length) continue;
                    this.mUiccApplications[i] = new UiccCardApplication(this, ics.mApplications[i], this.mContext, this.mCi);
                    continue;
                }
                if (i >= ics.mApplications.length) {
                    this.mUiccApplications[i].dispose();
                    this.mUiccApplications[i] = null;
                    continue;
                }
                this.mUiccApplications[i].update(ics.mApplications[i], this.mContext, this.mCi);
            }
            if (this.mUiccApplications.length > 0 && this.mUiccApplications[0] != null) {
                this.mCatService = CatService.getInstance(this.mCi, this.mContext, this);
            } else {
                if (this.mCatService != null) {
                    this.mCatService.dispose();
                }
                this.mCatService = null;
            }
            this.sanitizeApplicationIndexes();
            CommandsInterface.RadioState radioState = this.mCi.getRadioState();
            this.log("update: radioState=" + (Object)((Object)radioState) + " mLastRadioState=" + (Object)((Object)this.mLastRadioState));
            if (radioState == CommandsInterface.RadioState.RADIO_ON && this.mLastRadioState == CommandsInterface.RadioState.RADIO_ON) {
                if (oldState != IccCardStatus.CardState.CARDSTATE_ABSENT && this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT) {
                    this.log("update: notify card removed");
                    this.mAbsentRegistrants.notifyRegistrants();
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(13, null));
                } else if (oldState == IccCardStatus.CardState.CARDSTATE_ABSENT && this.mCardState != IccCardStatus.CardState.CARDSTATE_ABSENT) {
                    this.log("update: notify card added");
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(14, null));
                }
            }
            this.mLastRadioState = radioState;
        }
    }

    protected void finalize() {
        this.log("UiccCard finalized");
    }

    private void sanitizeApplicationIndexes() {
        this.mGsmUmtsSubscriptionAppIndex = this.checkIndex(this.mGsmUmtsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_SIM, IccCardApplicationStatus.AppType.APPTYPE_USIM);
        this.mCdmaSubscriptionAppIndex = this.checkIndex(this.mCdmaSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_RUIM, IccCardApplicationStatus.AppType.APPTYPE_CSIM);
        this.mImsSubscriptionAppIndex = this.checkIndex(this.mImsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_ISIM, null);
    }

    private int checkIndex(int index, IccCardApplicationStatus.AppType expectedAppType, IccCardApplicationStatus.AppType altExpectedAppType) {
        if (this.mUiccApplications == null || index >= this.mUiccApplications.length) {
            this.loge("App index " + index + " is invalid since there are no applications");
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (this.mUiccApplications[index].getType() != expectedAppType && this.mUiccApplications[index].getType() != altExpectedAppType) {
            this.loge("App index " + index + " is invalid since it's not " + (Object)((Object)expectedAppType) + " and not " + (Object)((Object)altExpectedAppType));
            return -1;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForAbsent(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mAbsentRegistrants.add(r);
            if (this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForAbsent(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAbsentRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onIccSwap(boolean isAdded) {
        Object object = this.mLock;
        synchronized (object) {
            DialogInterface.OnClickListener listener = null;
            listener = new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick(DialogInterface dialog, int which) {
                    Object object = UiccCard.this.mLock;
                    synchronized (object) {
                        if (which == -1) {
                            UiccCard.this.log("Reboot due to SIM swap");
                            PowerManager pm = (PowerManager)UiccCard.this.mContext.getSystemService("power");
                            pm.reboot("SIM is added.");
                        }
                    }
                }
            };
            Resources r = Resources.getSystem();
            String title = isAdded ? r.getString(17040469) : r.getString(17040466);
            String message = isAdded ? r.getString(17040470) : r.getString(17040467);
            String buttonTxt = r.getString(17040471);
            AlertDialog dialog = new AlertDialog.Builder(this.mContext).setTitle(title).setMessage(message).setPositiveButton(buttonTxt, listener).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType() != type) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardStatus.CardState getCardState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCardState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardStatus.PinState getUniversalPinState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUniversalPinState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplication(int family) {
        Object object = this.mLock;
        synchronized (object) {
            int index = 8;
            switch (family) {
                case 1: {
                    index = this.mGsmUmtsSubscriptionAppIndex;
                    break;
                }
                case 2: {
                    index = this.mCdmaSubscriptionAppIndex;
                    break;
                }
                case 3: {
                    index = this.mImsSubscriptionAppIndex;
                }
            }
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplicationIndex(int index) {
        Object object = this.mLock;
        synchronized (object) {
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    private void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccCard:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mDestroyed=" + this.mDestroyed);
        pw.println(" mLastRadioState=" + (Object)((Object)this.mLastRadioState));
        pw.println(" mCatService=" + this.mCatService);
        pw.println(" mAbsentRegistrants: size=" + this.mAbsentRegistrants.size());
        for (i = 0; i < this.mAbsentRegistrants.size(); ++i) {
            pw.println("  mAbsentRegistrants[" + i + "]=" + ((Registrant)this.mAbsentRegistrants.get(i)).getHandler());
        }
        pw.println(" mCardState=" + (Object)((Object)this.mCardState));
        pw.println(" mUniversalPinState=" + (Object)((Object)this.mUniversalPinState));
        pw.println(" mGsmUmtsSubscriptionAppIndex=" + this.mGsmUmtsSubscriptionAppIndex);
        pw.println(" mCdmaSubscriptionAppIndex=" + this.mCdmaSubscriptionAppIndex);
        pw.println(" mImsSubscriptionAppIndex=" + this.mImsSubscriptionAppIndex);
        pw.println(" mImsSubscriptionAppIndex=" + this.mImsSubscriptionAppIndex);
        pw.println(" mUiccApplications: length=" + this.mUiccApplications.length);
        for (i = 0; i < this.mUiccApplications.length; ++i) {
            if (this.mUiccApplications[i] == null) {
                pw.println("  mUiccApplications[" + i + "]=" + null);
                continue;
            }
            pw.println("  mUiccApplications[" + i + "]=" + (Object)((Object)this.mUiccApplications[i].getType()) + " " + this.mUiccApplications[i]);
        }
        pw.println();
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.dump(fd, pw, args);
            pw.println();
        }
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null) continue;
            ir.dump(fd, pw, args);
            pw.println();
        }
        pw.flush();
    }
}

