/*
 * Decompiled with CFR 0.152.
 */
package com.android.media.remotedisplay;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.IRemoteDisplayCallback;
import android.media.IRemoteDisplayProvider;
import android.media.RemoteDisplayState;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.media.remotedisplay.RemoteDisplay;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteDisplayProvider {
    private static final int MSG_SET_CALLBACK = 1;
    private static final int MSG_SET_DISCOVERY_MODE = 2;
    private static final int MSG_CONNECT = 3;
    private static final int MSG_DISCONNECT = 4;
    private static final int MSG_SET_VOLUME = 5;
    private static final int MSG_ADJUST_VOLUME = 6;
    private final Context mContext;
    private final ProviderStub mStub;
    private final ProviderHandler mHandler;
    private final ArrayMap<String, RemoteDisplay> mDisplays = new ArrayMap();
    private IRemoteDisplayCallback mCallback;
    private int mDiscoveryMode = 0;
    private PendingIntent mSettingsPendingIntent;
    public static final String SERVICE_INTERFACE = "com.android.media.remotedisplay.RemoteDisplayProvider";
    public static final int DISCOVERY_MODE_NONE = 0;
    public static final int DISCOVERY_MODE_PASSIVE = 1;
    public static final int DISCOVERY_MODE_ACTIVE = 2;

    public RemoteDisplayProvider(Context context) {
        this.mContext = context;
        this.mStub = new ProviderStub();
        this.mHandler = new ProviderHandler(context.getMainLooper());
    }

    public final Context getContext() {
        return this.mContext;
    }

    public IBinder getBinder() {
        return this.mStub;
    }

    public void onDiscoveryModeChanged(int mode) {
    }

    public void onConnect(RemoteDisplay display) {
    }

    public void onDisconnect(RemoteDisplay display) {
    }

    public void onSetVolume(RemoteDisplay display, int volume) {
    }

    public void onAdjustVolume(RemoteDisplay display, int delta) {
    }

    public int getDiscoveryMode() {
        return this.mDiscoveryMode;
    }

    public Collection<RemoteDisplay> getDisplays() {
        return this.mDisplays.values();
    }

    public void addDisplay(RemoteDisplay display) {
        if (display == null || this.mDisplays.containsKey(display.getId())) {
            throw new IllegalArgumentException("display");
        }
        this.mDisplays.put(display.getId(), display);
        this.publishState();
    }

    public void updateDisplay(RemoteDisplay display) {
        if (display == null || this.mDisplays.get(display.getId()) != display) {
            throw new IllegalArgumentException("display");
        }
        this.publishState();
    }

    public void removeDisplay(RemoteDisplay display) {
        if (display == null || this.mDisplays.get(display.getId()) != display) {
            throw new IllegalArgumentException("display");
        }
        this.mDisplays.remove(display.getId());
        this.publishState();
    }

    public RemoteDisplay findRemoteDisplay(String id2) {
        return this.mDisplays.get(id2);
    }

    public PendingIntent getSettingsPendingIntent() {
        if (this.mSettingsPendingIntent == null) {
            Intent settingsIntent = new Intent("android.settings.WIFI_DISPLAY_SETTINGS");
            settingsIntent.setFlags(337641472);
            this.mSettingsPendingIntent = PendingIntent.getActivity(this.mContext, 0, settingsIntent, 0, null);
        }
        return this.mSettingsPendingIntent;
    }

    void setCallback(IRemoteDisplayCallback callback) {
        this.mCallback = callback;
        this.publishState();
    }

    void setDiscoveryMode(int mode) {
        if (this.mDiscoveryMode != mode) {
            this.mDiscoveryMode = mode;
            this.onDiscoveryModeChanged(mode);
        }
    }

    void publishState() {
        if (this.mCallback != null) {
            RemoteDisplayState state = new RemoteDisplayState();
            int count = this.mDisplays.size();
            for (int i = 0; i < count; ++i) {
                RemoteDisplay display = this.mDisplays.valueAt(i);
                state.displays.add(display.getInfo());
            }
            try {
                this.mCallback.onStateChanged(state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    final class ProviderHandler
    extends Handler {
        public ProviderHandler(Looper looper) {
            super(looper, null, true);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    RemoteDisplayProvider.this.setCallback((IRemoteDisplayCallback)msg.obj);
                    break;
                }
                case 2: {
                    RemoteDisplayProvider.this.setDiscoveryMode(msg.arg1);
                    break;
                }
                case 3: {
                    RemoteDisplay display = RemoteDisplayProvider.this.findRemoteDisplay((String)msg.obj);
                    if (display == null) break;
                    RemoteDisplayProvider.this.onConnect(display);
                    break;
                }
                case 4: {
                    RemoteDisplay display = RemoteDisplayProvider.this.findRemoteDisplay((String)msg.obj);
                    if (display == null) break;
                    RemoteDisplayProvider.this.onDisconnect(display);
                    break;
                }
                case 5: {
                    RemoteDisplay display = RemoteDisplayProvider.this.findRemoteDisplay((String)msg.obj);
                    if (display == null) break;
                    RemoteDisplayProvider.this.onSetVolume(display, msg.arg1);
                    break;
                }
                case 6: {
                    RemoteDisplay display = RemoteDisplayProvider.this.findRemoteDisplay((String)msg.obj);
                    if (display == null) break;
                    RemoteDisplayProvider.this.onAdjustVolume(display, msg.arg1);
                    break;
                }
            }
        }
    }

    final class ProviderStub
    extends IRemoteDisplayProvider.Stub {
        ProviderStub() {
        }

        public void setCallback(IRemoteDisplayCallback callback) {
            RemoteDisplayProvider.this.mHandler.obtainMessage(1, callback).sendToTarget();
        }

        public void setDiscoveryMode(int mode) {
            RemoteDisplayProvider.this.mHandler.obtainMessage(2, mode, 0).sendToTarget();
        }

        public void connect(String id2) {
            RemoteDisplayProvider.this.mHandler.obtainMessage(3, id2).sendToTarget();
        }

        public void disconnect(String id2) {
            RemoteDisplayProvider.this.mHandler.obtainMessage(4, id2).sendToTarget();
        }

        public void setVolume(String id2, int volume) {
            RemoteDisplayProvider.this.mHandler.obtainMessage(5, volume, 0, id2).sendToTarget();
        }

        public void adjustVolume(String id2, int delta) {
            RemoteDisplayProvider.this.mHandler.obtainMessage(6, delta, 0, id2).sendToTarget();
        }
    }
}

