/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.util.LocalLog;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AlarmManagerService
extends IAlarmManager.Stub {
    private static final long LATE_ALARM_THRESHOLD = 10000L;
    private static final int RTC_WAKEUP_MASK = 1;
    private static final int RTC_MASK = 2;
    private static final int ELAPSED_REALTIME_WAKEUP_MASK = 4;
    private static final int ELAPSED_REALTIME_MASK = 8;
    private static final int TIME_CHANGED_MASK = 65536;
    private static final int IS_WAKEUP_MASK = 5;
    private static final int TYPE_NONWAKEUP_MASK = 1;
    private static final String TAG = "AlarmManager";
    private static final String ClockReceiver_TAG = "ClockReceiver";
    private static final boolean localLOGV = false;
    private static final boolean DEBUG_BATCH = false;
    private static final boolean DEBUG_VALIDATE = false;
    private static final int ALARM_EVENT = 1;
    private static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    private static final Intent mBackgroundIntent = new Intent().addFlags(4);
    private static final IncreasingTimeOrder sIncreasingTimeOrder = new IncreasingTimeOrder();
    private static final boolean WAKEUP_STATS = false;
    private final Context mContext;
    private final LocalLog mLog = new LocalLog("AlarmManager");
    private Object mLock = new Object();
    private long mNativeData;
    private long mNextWakeup;
    private long mNextNonWakeup;
    private int mBroadcastRefCount = 0;
    private PowerManager.WakeLock mWakeLock;
    private ArrayList<InFlight> mInFlight = new ArrayList();
    private final AlarmThread mWaitThread = new AlarmThread();
    private final AlarmHandler mHandler = new AlarmHandler();
    private ClockReceiver mClockReceiver;
    private UninstallReceiver mUninstallReceiver;
    private final ResultReceiver mResultReceiver = new ResultReceiver();
    private final PendingIntent mTimeTickSender;
    private final PendingIntent mDateChangeSender;
    private final LinkedList<WakeupEvent> mRecentWakeups = new LinkedList();
    private final long RECENT_WAKEUP_PERIOD = 86400000L;
    private static final long MIN_FUZZABLE_INTERVAL = 10000L;
    private static final BatchTimeOrder sBatchOrder = new BatchTimeOrder();
    private final ArrayList<Batch> mAlarmBatches = new ArrayList();
    private final HashMap<String, BroadcastStats> mBroadcastStats = new HashMap();

    static long convertToElapsed(long when, int type) {
        boolean isRtc;
        boolean bl = isRtc = type == 1 || type == 0;
        if (isRtc) {
            when -= System.currentTimeMillis() - SystemClock.elapsedRealtime();
        }
        return when;
    }

    static long maxTriggerTime(long now, long triggerAtTime, long interval) {
        long futurity;
        long l = futurity = interval == 0L ? triggerAtTime - now : interval;
        if (futurity < 10000L) {
            futurity = 0L;
        }
        return triggerAtTime + (long)(0.75 * (double)futurity);
    }

    static boolean addBatchLocked(ArrayList<Batch> list, Batch newBatch) {
        int index = Collections.binarySearch(list, newBatch, sBatchOrder);
        if (index < 0) {
            index = 0 - index - 1;
        }
        list.add(index, newBatch);
        return index == 0;
    }

    int attemptCoalesceLocked(long whenElapsed, long maxWhen) {
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (b.standalone || !b.canHold(whenElapsed, maxWhen)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebatchAllAlarms() {
        Object object = this.mLock;
        synchronized (object) {
            this.rebatchAllAlarmsLocked(true);
        }
    }

    void rebatchAllAlarmsLocked(boolean doValidate) {
        ArrayList oldSet = (ArrayList)this.mAlarmBatches.clone();
        this.mAlarmBatches.clear();
        long nowElapsed = SystemClock.elapsedRealtime();
        int oldBatches = oldSet.size();
        for (int batchNum = 0; batchNum < oldBatches; ++batchNum) {
            Batch batch = (Batch)oldSet.get(batchNum);
            int N = batch.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = batch.get(i);
                long whenElapsed = AlarmManagerService.convertToElapsed(a.when, a.type);
                long maxElapsed = a.whenElapsed == a.maxWhen ? whenElapsed : (a.windowLength > 0L ? whenElapsed + a.windowLength : AlarmManagerService.maxTriggerTime(nowElapsed, whenElapsed, a.repeatInterval));
                this.setImplLocked(a.type, a.when, whenElapsed, a.windowLength, maxElapsed, a.repeatInterval, a.operation, batch.standalone, doValidate, a.workSource);
            }
        }
    }

    public AlarmManagerService(Context context) {
        this.mContext = context;
        this.mNativeData = this.init();
        this.mNextNonWakeup = 0L;
        this.mNextWakeup = 0L;
        String tz = SystemProperties.get(TIMEZONE_PROPERTY);
        if (tz != null) {
            this.setTimeZone(tz);
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, TAG);
        this.mTimeTickSender = PendingIntent.getBroadcastAsUser(context, 0, new Intent("android.intent.action.TIME_TICK").addFlags(0x50000000), 0, UserHandle.ALL);
        Intent intent = new Intent("android.intent.action.DATE_CHANGED");
        intent.addFlags(0x20000000);
        this.mDateChangeSender = PendingIntent.getBroadcastAsUser(context, 0, intent, 0x4000000, UserHandle.ALL);
        this.mClockReceiver = new ClockReceiver();
        this.mClockReceiver.scheduleTimeTickEvent();
        this.mClockReceiver.scheduleDateChangedEvent();
        this.mUninstallReceiver = new UninstallReceiver();
        if (this.mNativeData != 0L) {
            this.mWaitThread.start();
        } else {
            Slog.w(TAG, "Failed to open alarm driver. Falling back to a handler.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalize() throws Throwable {
        try {
            this.close(this.mNativeData);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void set(int type, long triggerAtTime, long windowLength, long interval, PendingIntent operation, WorkSource workSource) {
        if (workSource != null) {
            this.mContext.enforceCallingPermission("android.permission.UPDATE_DEVICE_STATS", "AlarmManager.set");
        }
        this.set(type, triggerAtTime, windowLength, interval, operation, false, workSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int type, long triggerAtTime, long windowLength, long interval, PendingIntent operation, boolean isStandalone, WorkSource workSource) {
        if (operation == null) {
            Slog.w(TAG, "set/setRepeating ignored because there is no intent");
            return;
        }
        if (windowLength > 43200000L) {
            Slog.w(TAG, "Window length " + windowLength + "ms suspiciously long; limiting to 1 hour");
            windowLength = 3600000L;
        }
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Invalid alarm type " + type);
        }
        if (triggerAtTime < 0L) {
            long who = Binder.getCallingUid();
            long what = Binder.getCallingPid();
            Slog.w(TAG, "Invalid alarm trigger time! " + triggerAtTime + " from uid=" + who + " pid=" + what);
            triggerAtTime = 0L;
        }
        long nowElapsed = SystemClock.elapsedRealtime();
        long triggerElapsed = AlarmManagerService.convertToElapsed(triggerAtTime, type);
        long maxElapsed = windowLength == 0L ? triggerElapsed : (windowLength < 0L ? AlarmManagerService.maxTriggerTime(nowElapsed, triggerElapsed, interval) : triggerElapsed + windowLength);
        Object object = this.mLock;
        synchronized (object) {
            this.setImplLocked(type, triggerAtTime, triggerElapsed, windowLength, maxElapsed, interval, operation, isStandalone, true, workSource);
        }
    }

    private void setImplLocked(int type, long when, long whenElapsed, long windowLength, long maxWhen, long interval, PendingIntent operation, boolean isStandalone, boolean doValidate, WorkSource workSource) {
        int whichBatch;
        Alarm a = new Alarm(type, when, whenElapsed, windowLength, maxWhen, interval, operation, workSource);
        this.removeLocked(operation);
        int n = whichBatch = isStandalone ? -1 : this.attemptCoalesceLocked(whenElapsed, maxWhen);
        if (whichBatch < 0) {
            Batch batch = new Batch(a);
            batch.standalone = isStandalone;
            AlarmManagerService.addBatchLocked(this.mAlarmBatches, batch);
        } else {
            Batch batch = this.mAlarmBatches.get(whichBatch);
            if (batch.add(a)) {
                this.mAlarmBatches.remove(whichBatch);
                AlarmManagerService.addBatchLocked(this.mAlarmBatches, batch);
            }
        }
        this.rescheduleKernelAlarmsLocked();
    }

    private void logBatchesLocked() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(2048);
        PrintWriter pw = new PrintWriter(bs);
        long nowRTC = System.currentTimeMillis();
        long nowELAPSED = SystemClock.elapsedRealtime();
        int NZ = this.mAlarmBatches.size();
        for (int iz = 0; iz < NZ; ++iz) {
            Batch bz = this.mAlarmBatches.get(iz);
            pw.append("Batch ");
            pw.print(iz);
            pw.append(": ");
            pw.println(bz);
            AlarmManagerService.dumpAlarmList(pw, bz.alarms, "  ", nowELAPSED, nowRTC);
            pw.flush();
            Slog.v(TAG, bs.toString());
            bs.reset();
        }
    }

    private boolean validateConsistencyLocked() {
        return true;
    }

    private Batch findFirstWakeupBatchLocked() {
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (!b.hasWakeups()) continue;
            return b;
        }
        return null;
    }

    private void rescheduleKernelAlarmsLocked() {
        if (this.mAlarmBatches.size() > 0) {
            Batch firstWakeup = this.findFirstWakeupBatchLocked();
            Batch firstBatch = this.mAlarmBatches.get(0);
            if (firstWakeup != null && this.mNextWakeup != firstWakeup.start) {
                this.mNextWakeup = firstWakeup.start;
                this.setLocked(2, firstWakeup.start);
            }
            if (firstBatch != firstWakeup && this.mNextNonWakeup != firstBatch.start) {
                this.mNextNonWakeup = firstBatch.start;
                this.setLocked(3, firstBatch.start);
            }
        }
    }

    @Override
    public void setTime(long millis) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_TIME", "setTime");
        SystemClock.setCurrentTimeMillis(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeZone(String tz) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_TIME_ZONE", "setTimeZone");
        long oldId = Binder.clearCallingIdentity();
        try {
            if (TextUtils.isEmpty(tz)) {
                return;
            }
            TimeZone zone = TimeZone.getTimeZone(tz);
            boolean timeZoneWasChanged = false;
            AlarmManagerService alarmManagerService = this;
            synchronized (alarmManagerService) {
                String current = SystemProperties.get(TIMEZONE_PROPERTY);
                if (current == null || !current.equals(zone.getID())) {
                    timeZoneWasChanged = true;
                    SystemProperties.set(TIMEZONE_PROPERTY, zone.getID());
                }
                int gmtOffset = zone.getOffset(System.currentTimeMillis());
                this.setKernelTimezone(this.mNativeData, -(gmtOffset / 60000));
            }
            TimeZone.setDefault(null);
            if (timeZoneWasChanged) {
                Intent intent = new Intent("android.intent.action.TIMEZONE_CHANGED");
                intent.addFlags(0x20000000);
                intent.putExtra("time-zone", zone.getID());
                this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(PendingIntent operation) {
        if (operation == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeLocked(operation);
        }
    }

    public void removeLocked(PendingIntent operation) {
        boolean didRemove = false;
        for (int i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(operation);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
        }
    }

    public void removeLocked(String packageName) {
        boolean didRemove = false;
        for (int i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(packageName);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
        }
    }

    public void removeUserLocked(int userHandle) {
        boolean didRemove = false;
        for (int i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(userHandle);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
        }
    }

    public boolean lookForPackageLocked(String packageName) {
        for (int i = 0; i < this.mAlarmBatches.size(); ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (!b.hasPackage(packageName)) continue;
            return true;
        }
        return false;
    }

    private void setLocked(int type, long when) {
        if (this.mNativeData != 0L) {
            long alarmNanoseconds;
            long alarmSeconds;
            if (when < 0L) {
                alarmSeconds = 0L;
                alarmNanoseconds = 0L;
            } else {
                alarmSeconds = when / 1000L;
                alarmNanoseconds = when % 1000L * 1000L * 1000L;
            }
            this.set(this.mNativeData, type, alarmSeconds, alarmNanoseconds);
        } else {
            Message msg = Message.obtain();
            msg.what = 1;
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump AlarmManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            FilterStats fs;
            pw.println("Current Alarm Manager state:");
            long nowRTC = System.currentTimeMillis();
            long nowELAPSED = SystemClock.elapsedRealtime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            pw.print("nowRTC=");
            pw.print(nowRTC);
            pw.print("=");
            pw.print(sdf.format(new Date(nowRTC)));
            pw.print(" nowELAPSED=");
            pw.println(nowELAPSED);
            long nextWakeupRTC = this.mNextWakeup + (nowRTC - nowELAPSED);
            long nextNonWakeupRTC = this.mNextNonWakeup + (nowRTC - nowELAPSED);
            pw.print("Next alarm: ");
            pw.print(this.mNextNonWakeup);
            pw.print(" = ");
            pw.println(sdf.format(new Date(nextNonWakeupRTC)));
            pw.print("Next wakeup: ");
            pw.print(this.mNextWakeup);
            pw.print(" = ");
            pw.println(sdf.format(new Date(nextWakeupRTC)));
            if (this.mAlarmBatches.size() > 0) {
                pw.println();
                pw.print("Pending alarm batches: ");
                pw.println(this.mAlarmBatches.size());
                for (Batch b : this.mAlarmBatches) {
                    pw.print(b);
                    pw.println(':');
                    AlarmManagerService.dumpAlarmList(pw, b.alarms, "  ", nowELAPSED, nowRTC);
                }
            }
            pw.println();
            pw.print("  Broadcast ref count: ");
            pw.println(this.mBroadcastRefCount);
            pw.println();
            if (this.mLog.dump(pw, "  Recent problems", "    ")) {
                pw.println();
            }
            FilterStats[] topFilters = new FilterStats[10];
            Comparator<FilterStats> comparator = new Comparator<FilterStats>(){

                @Override
                public int compare(FilterStats lhs, FilterStats rhs) {
                    if (lhs.aggregateTime < rhs.aggregateTime) {
                        return 1;
                    }
                    if (lhs.aggregateTime > rhs.aggregateTime) {
                        return -1;
                    }
                    return 0;
                }
            };
            int len = 0;
            for (Map.Entry<String, BroadcastStats> be : this.mBroadcastStats.entrySet()) {
                BroadcastStats bs = be.getValue();
                for (Map.Entry<Pair<String, ComponentName>, FilterStats> fe : bs.filterStats.entrySet()) {
                    int pos;
                    fs = fe.getValue();
                    int n = pos = len > 0 ? Arrays.binarySearch(topFilters, 0, len, fs, comparator) : 0;
                    if (pos < 0) {
                        pos = -pos - 1;
                    }
                    if (pos >= topFilters.length) continue;
                    int copylen = topFilters.length - pos - 1;
                    if (copylen > 0) {
                        System.arraycopy(topFilters, pos, topFilters, pos + 1, copylen);
                    }
                    topFilters[pos] = fs;
                    if (len >= topFilters.length) continue;
                    ++len;
                }
            }
            if (len > 0) {
                pw.println("  Top Alarms:");
                for (int i = 0; i < len; ++i) {
                    FilterStats fs2 = topFilters[i];
                    pw.print("    ");
                    if (fs2.nesting > 0) {
                        pw.print("*ACTIVE* ");
                    }
                    TimeUtils.formatDuration(fs2.aggregateTime, pw);
                    pw.print(" running, ");
                    pw.print(fs2.numWakeup);
                    pw.print(" wakeups, ");
                    pw.print(fs2.count);
                    pw.print(" alarms: ");
                    pw.print(fs2.mBroadcastStats.mPackageName);
                    pw.println();
                    pw.print("      ");
                    if (fs2.mTarget.first != null) {
                        pw.print(" act=");
                        pw.print((String)fs2.mTarget.first);
                    }
                    if (fs2.mTarget.second != null) {
                        pw.print(" cmp=");
                        pw.print(((ComponentName)fs2.mTarget.second).toShortString());
                    }
                    pw.println();
                }
            }
            pw.println(" ");
            pw.println("  Alarm Stats:");
            ArrayList<FilterStats> tmpFilters = new ArrayList<FilterStats>();
            for (Map.Entry<String, BroadcastStats> be : this.mBroadcastStats.entrySet()) {
                BroadcastStats bs = be.getValue();
                pw.print("  ");
                if (bs.nesting > 0) {
                    pw.print("*ACTIVE* ");
                }
                pw.print(be.getKey());
                pw.print(" ");
                TimeUtils.formatDuration(bs.aggregateTime, pw);
                pw.print(" running, ");
                pw.print(bs.numWakeup);
                pw.println(" wakeups:");
                tmpFilters.clear();
                for (Map.Entry<Pair<String, ComponentName>, FilterStats> fe : bs.filterStats.entrySet()) {
                    tmpFilters.add(fe.getValue());
                }
                Collections.sort(tmpFilters, comparator);
                for (int i = 0; i < tmpFilters.size(); ++i) {
                    fs = (FilterStats)tmpFilters.get(i);
                    pw.print("    ");
                    if (fs.nesting > 0) {
                        pw.print("*ACTIVE* ");
                    }
                    TimeUtils.formatDuration(fs.aggregateTime, pw);
                    pw.print(" ");
                    pw.print(fs.numWakeup);
                    pw.print(" wakes ");
                    pw.print(fs.count);
                    pw.print(" alarms:");
                    if (fs.mTarget.first != null) {
                        pw.print(" act=");
                        pw.print((String)fs.mTarget.first);
                    }
                    if (fs.mTarget.second != null) {
                        pw.print(" cmp=");
                        pw.print(((ComponentName)fs.mTarget.second).toShortString());
                    }
                    pw.println();
                }
            }
        }
    }

    private static final void dumpAlarmList(PrintWriter pw, ArrayList<Alarm> list, String prefix, String label, long now) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Alarm a = list.get(i);
            pw.print(prefix);
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(a);
            a.dump(pw, prefix + "  ", now);
        }
    }

    private static final String labelForType(int type) {
        switch (type) {
            case 1: {
                return "RTC";
            }
            case 0: {
                return "RTC_WAKEUP";
            }
            case 3: {
                return "ELAPSED";
            }
            case 2: {
                return "ELAPSED_WAKEUP";
            }
        }
        return "--unknown--";
    }

    private static final void dumpAlarmList(PrintWriter pw, ArrayList<Alarm> list, String prefix, long nowELAPSED, long nowRTC) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Alarm a = list.get(i);
            String label = AlarmManagerService.labelForType(a.type);
            long now = a.type <= 1 ? nowRTC : nowELAPSED;
            pw.print(prefix);
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(a);
            a.dump(pw, prefix + "  ", now);
        }
    }

    private native long init();

    private native void close(long var1);

    private native void set(long var1, int var3, long var4, long var6);

    private native int waitForAlarm(long var1);

    private native int setKernelTimezone(long var1, int var3);

    private void triggerAlarmsLocked(ArrayList<Alarm> triggerList, long nowELAPSED, long nowRTC) {
        while (this.mAlarmBatches.size() > 0) {
            Batch batch = this.mAlarmBatches.get(0);
            if (batch.start > nowELAPSED) break;
            this.mAlarmBatches.remove(0);
            int N = batch.size();
            for (int i = 0; i < N; ++i) {
                Alarm alarm = batch.get(i);
                alarm.count = 1;
                triggerList.add(alarm);
                if (alarm.repeatInterval <= 0L) continue;
                alarm.count = (int)((long)alarm.count + (nowELAPSED - alarm.whenElapsed) / alarm.repeatInterval);
                long delta = (long)alarm.count * alarm.repeatInterval;
                long nextElapsed = alarm.whenElapsed + delta;
                this.setImplLocked(alarm.type, alarm.when + delta, nextElapsed, alarm.windowLength, AlarmManagerService.maxTriggerTime(nowELAPSED, nextElapsed, alarm.repeatInterval), alarm.repeatInterval, alarm.operation, batch.standalone, true, alarm.workSource);
            }
        }
    }

    void recordWakeupAlarms(ArrayList<Batch> batches, long nowELAPSED, long nowRTC) {
        int numBatches = batches.size();
        for (int nextBatch = 0; nextBatch < numBatches; ++nextBatch) {
            Batch b = batches.get(nextBatch);
            if (b.start > nowELAPSED) break;
            int numAlarms = b.alarms.size();
            for (int nextAlarm = 0; nextAlarm < numAlarms; ++nextAlarm) {
                Alarm a = b.alarms.get(nextAlarm);
                WakeupEvent e = new WakeupEvent(nowRTC, a.operation.getCreatorUid(), a.operation.getIntent().getAction());
                this.mRecentWakeups.add(e);
            }
        }
    }

    void setWakelockWorkSource(PendingIntent pi, WorkSource ws) {
        try {
            if (ws != null) {
                this.mWakeLock.setWorkSource(ws);
                return;
            }
            int uid = ActivityManagerNative.getDefault().getUidForIntentSender(pi.getTarget());
            if (uid >= 0) {
                this.mWakeLock.setWorkSource(new WorkSource(uid));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWakeLock.setWorkSource(null);
    }

    private final BroadcastStats getStatsLocked(PendingIntent pi) {
        String pkg = pi.getTargetPackage();
        BroadcastStats bs = this.mBroadcastStats.get(pkg);
        if (bs == null) {
            bs = new BroadcastStats(pkg);
            this.mBroadcastStats.put(pkg, bs);
        }
        return bs;
    }

    class ResultReceiver
    implements PendingIntent.OnFinished {
        ResultReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSendFinished(PendingIntent pi, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                InFlight inflight = null;
                for (int i = 0; i < AlarmManagerService.this.mInFlight.size(); ++i) {
                    if (((InFlight)((AlarmManagerService)AlarmManagerService.this).mInFlight.get((int)i)).mPendingIntent != pi) continue;
                    inflight = (InFlight)AlarmManagerService.this.mInFlight.remove(i);
                    break;
                }
                if (inflight != null) {
                    long nowELAPSED = SystemClock.elapsedRealtime();
                    BroadcastStats bs = inflight.mBroadcastStats;
                    --bs.nesting;
                    if (bs.nesting <= 0) {
                        bs.nesting = 0;
                        bs.aggregateTime += nowELAPSED - bs.startTime;
                    }
                    FilterStats fs = inflight.mFilterStats;
                    --fs.nesting;
                    if (fs.nesting <= 0) {
                        fs.nesting = 0;
                        fs.aggregateTime += nowELAPSED - fs.startTime;
                    }
                } else {
                    AlarmManagerService.this.mLog.w("No in-flight alarm for " + pi + " " + intent);
                }
                AlarmManagerService.this.mBroadcastRefCount--;
                if (AlarmManagerService.this.mBroadcastRefCount == 0) {
                    AlarmManagerService.this.mWakeLock.release();
                    if (AlarmManagerService.this.mInFlight.size() > 0) {
                        AlarmManagerService.this.mLog.w("Finished all broadcasts with " + AlarmManagerService.this.mInFlight.size() + " remaining inflights");
                        for (int i = 0; i < AlarmManagerService.this.mInFlight.size(); ++i) {
                            AlarmManagerService.this.mLog.w("  Remaining #" + i + ": " + AlarmManagerService.this.mInFlight.get(i));
                        }
                        AlarmManagerService.this.mInFlight.clear();
                    }
                } else if (AlarmManagerService.this.mInFlight.size() > 0) {
                    InFlight inFlight = (InFlight)AlarmManagerService.this.mInFlight.get(0);
                    AlarmManagerService.this.setWakelockWorkSource(inFlight.mPendingIntent, inFlight.mWorkSource);
                } else {
                    AlarmManagerService.this.mLog.w("Alarm wakelock still held but sent queue empty");
                    AlarmManagerService.this.mWakeLock.setWorkSource(null);
                }
            }
        }
    }

    class UninstallReceiver
    extends BroadcastReceiver {
        public UninstallReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
            filter.addDataScheme("package");
            AlarmManagerService.this.mContext.registerReceiver(this, filter);
            IntentFilter sdFilter = new IntentFilter();
            sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
            sdFilter.addAction("android.intent.action.USER_STOPPED");
            AlarmManagerService.this.mContext.registerReceiver(this, sdFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                String action = intent.getAction();
                String[] pkgList = null;
                if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
                    for (String packageName : pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES")) {
                        if (!AlarmManagerService.this.lookForPackageLocked(packageName)) continue;
                        this.setResultCode(-1);
                        return;
                    }
                    return;
                }
                if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                    int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                    if (userHandle >= 0) {
                        AlarmManagerService.this.removeUserLocked(userHandle);
                    }
                } else {
                    String pkg;
                    if ("android.intent.action.PACKAGE_REMOVED".equals(action) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                        return;
                    }
                    Uri data = intent.getData();
                    if (data != null && (pkg = data.getSchemeSpecificPart()) != null) {
                        pkgList = new String[]{pkg};
                    }
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkg : pkgList) {
                        AlarmManagerService.this.removeLocked(pkg);
                        AlarmManagerService.this.mBroadcastStats.remove(pkg);
                    }
                }
            }
        }
    }

    class ClockReceiver
    extends BroadcastReceiver {
        public ClockReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.DATE_CHANGED");
            AlarmManagerService.this.mContext.registerReceiver(this, filter);
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIME_TICK")) {
                this.scheduleTimeTickEvent();
            } else if (intent.getAction().equals("android.intent.action.DATE_CHANGED")) {
                TimeZone zone = TimeZone.getTimeZone(SystemProperties.get(AlarmManagerService.TIMEZONE_PROPERTY));
                int gmtOffset = zone.getOffset(System.currentTimeMillis());
                AlarmManagerService.this.setKernelTimezone(AlarmManagerService.this.mNativeData, -(gmtOffset / 60000));
                this.scheduleDateChangedEvent();
            }
        }

        public void scheduleTimeTickEvent() {
            long currentTime = System.currentTimeMillis();
            long nextTime = 60000L * (currentTime / 60000L + 1L);
            long tickEventDelay = nextTime - currentTime;
            WorkSource workSource = null;
            AlarmManagerService.this.set(3, SystemClock.elapsedRealtime() + tickEventDelay, 0L, 0L, AlarmManagerService.this.mTimeTickSender, true, workSource);
        }

        public void scheduleDateChangedEvent() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(5, 1);
            WorkSource workSource = null;
            AlarmManagerService.this.set(1, calendar.getTimeInMillis(), 0L, 0L, AlarmManagerService.this.mDateChangeSender, true, workSource);
        }
    }

    private class AlarmHandler
    extends Handler {
        public static final int ALARM_EVENT = 1;
        public static final int MINUTE_CHANGE_EVENT = 2;
        public static final int DATE_CHANGE_EVENT = 3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                ArrayList triggerList = new ArrayList();
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    long nowRTC = System.currentTimeMillis();
                    long nowELAPSED = SystemClock.elapsedRealtime();
                    AlarmManagerService.this.triggerAlarmsLocked(triggerList, nowELAPSED, nowRTC);
                }
                for (int i = 0; i < triggerList.size(); ++i) {
                    Alarm alarm = (Alarm)triggerList.get(i);
                    try {
                        alarm.operation.send();
                        continue;
                    }
                    catch (PendingIntent.CanceledException e) {
                        if (alarm.repeatInterval <= 0L) continue;
                        AlarmManagerService.this.remove(alarm.operation);
                    }
                }
            }
        }
    }

    private class AlarmThread
    extends Thread {
        public AlarmThread() {
            super(AlarmManagerService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList triggerList = new ArrayList();
            while (true) {
                int result = AlarmManagerService.this.waitForAlarm(AlarmManagerService.this.mNativeData);
                triggerList.clear();
                if ((result & 0x10000) != 0) {
                    AlarmManagerService.this.remove(AlarmManagerService.this.mTimeTickSender);
                    AlarmManagerService.this.rebatchAllAlarms();
                    AlarmManagerService.this.mClockReceiver.scheduleTimeTickEvent();
                    Intent intent = new Intent("android.intent.action.TIME_SET");
                    intent.addFlags(0x24000000);
                    AlarmManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
                }
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    long nowRTC = System.currentTimeMillis();
                    long nowELAPSED = SystemClock.elapsedRealtime();
                    AlarmManagerService.this.triggerAlarmsLocked(triggerList, nowELAPSED, nowRTC);
                    AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                    for (int i = 0; i < triggerList.size(); ++i) {
                        Alarm alarm = (Alarm)triggerList.get(i);
                        try {
                            alarm.operation.send(AlarmManagerService.this.mContext, 0, mBackgroundIntent.putExtra("android.intent.extra.ALARM_COUNT", alarm.count), AlarmManagerService.this.mResultReceiver, AlarmManagerService.this.mHandler);
                            if (AlarmManagerService.this.mBroadcastRefCount == 0) {
                                AlarmManagerService.this.setWakelockWorkSource(alarm.operation, alarm.workSource);
                                AlarmManagerService.this.mWakeLock.acquire();
                            }
                            InFlight inflight = new InFlight(AlarmManagerService.this, alarm.operation, alarm.workSource);
                            AlarmManagerService.this.mInFlight.add(inflight);
                            AlarmManagerService.this.mBroadcastRefCount++;
                            BroadcastStats bs = inflight.mBroadcastStats;
                            ++bs.count;
                            if (bs.nesting == 0) {
                                bs.nesting = 1;
                                bs.startTime = nowELAPSED;
                            } else {
                                ++bs.nesting;
                            }
                            FilterStats fs = inflight.mFilterStats;
                            ++fs.count;
                            if (fs.nesting == 0) {
                                fs.nesting = 1;
                                fs.startTime = nowELAPSED;
                            } else {
                                ++fs.nesting;
                            }
                            if (alarm.type != 2 && alarm.type != 0) continue;
                            ++bs.numWakeup;
                            ++fs.numWakeup;
                            ActivityManagerNative.noteWakeupAlarm(alarm.operation);
                            continue;
                        }
                        catch (PendingIntent.CanceledException e) {
                            if (alarm.repeatInterval <= 0L) continue;
                            AlarmManagerService.this.remove(alarm.operation);
                            continue;
                        }
                        catch (RuntimeException e) {
                            Slog.w(AlarmManagerService.TAG, "Failure sending alarm.", e);
                        }
                    }
                }
            }
        }
    }

    private static class Alarm {
        public int type;
        public int count;
        public long when;
        public long windowLength;
        public long whenElapsed;
        public long maxWhen;
        public long repeatInterval;
        public PendingIntent operation;
        public WorkSource workSource;

        public Alarm(int _type, long _when, long _whenElapsed, long _windowLength, long _maxWhen, long _interval, PendingIntent _op, WorkSource _ws) {
            this.type = _type;
            this.when = _when;
            this.whenElapsed = _whenElapsed;
            this.windowLength = _windowLength;
            this.maxWhen = _maxWhen;
            this.repeatInterval = _interval;
            this.operation = _op;
            this.workSource = _ws;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Alarm{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" type ");
            sb.append(this.type);
            sb.append(" ");
            sb.append(this.operation.getTargetPackage());
            sb.append('}');
            return sb.toString();
        }

        public void dump(PrintWriter pw, String prefix, long now) {
            pw.print(prefix);
            pw.print("type=");
            pw.print(this.type);
            pw.print(" whenElapsed=");
            pw.print(this.whenElapsed);
            pw.print(" when=");
            TimeUtils.formatDuration(this.when, now, pw);
            pw.print(" window=");
            pw.print(this.windowLength);
            pw.print(" repeatInterval=");
            pw.print(this.repeatInterval);
            pw.print(" count=");
            pw.println(this.count);
            pw.print(prefix);
            pw.print("operation=");
            pw.println(this.operation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncreasingTimeOrder
    implements Comparator<Alarm> {
        @Override
        public int compare(Alarm a1, Alarm a2) {
            long when1 = a1.when;
            long when2 = a2.when;
            if (when1 - when2 > 0L) {
                return 1;
            }
            if (when1 - when2 < 0L) {
                return -1;
            }
            return 0;
        }
    }

    private static final class BroadcastStats {
        final String mPackageName;
        long aggregateTime;
        int count;
        int numWakeup;
        long startTime;
        int nesting;
        final HashMap<Pair<String, ComponentName>, FilterStats> filterStats = new HashMap();

        BroadcastStats(String packageName) {
            this.mPackageName = packageName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilterStats {
        final BroadcastStats mBroadcastStats;
        final Pair<String, ComponentName> mTarget;
        long aggregateTime;
        int count;
        int numWakeup;
        long startTime;
        int nesting;

        FilterStats(BroadcastStats broadcastStats, Pair<String, ComponentName> target) {
            this.mBroadcastStats = broadcastStats;
            this.mTarget = target;
        }
    }

    private static final class InFlight
    extends Intent {
        final PendingIntent mPendingIntent;
        final WorkSource mWorkSource;
        final Pair<String, ComponentName> mTarget;
        final BroadcastStats mBroadcastStats;
        final FilterStats mFilterStats;

        InFlight(AlarmManagerService service, PendingIntent pendingIntent, WorkSource workSource) {
            this.mPendingIntent = pendingIntent;
            this.mWorkSource = workSource;
            Intent intent = pendingIntent.getIntent();
            this.mTarget = intent != null ? new Pair<String, ComponentName>(intent.getAction(), intent.getComponent()) : null;
            this.mBroadcastStats = service.getStatsLocked(pendingIntent);
            FilterStats fs = this.mBroadcastStats.filterStats.get(this.mTarget);
            if (fs == null) {
                fs = new FilterStats(this.mBroadcastStats, this.mTarget);
                this.mBroadcastStats.filterStats.put(this.mTarget, fs);
            }
            this.mFilterStats = fs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BatchTimeOrder
    implements Comparator<Batch> {
        BatchTimeOrder() {
        }

        @Override
        public int compare(Batch b1, Batch b2) {
            long when1 = b1.start;
            long when2 = b2.start;
            if (when1 - when2 > 0L) {
                return 1;
            }
            if (when1 - when2 < 0L) {
                return -1;
            }
            return 0;
        }
    }

    static final class Batch {
        long start;
        long end;
        boolean standalone;
        final ArrayList<Alarm> alarms = new ArrayList();

        Batch() {
            this.start = 0L;
            this.end = Long.MAX_VALUE;
        }

        Batch(Alarm seed) {
            this.start = seed.whenElapsed;
            this.end = seed.maxWhen;
            this.alarms.add(seed);
        }

        int size() {
            return this.alarms.size();
        }

        Alarm get(int index) {
            return this.alarms.get(index);
        }

        boolean canHold(long whenElapsed, long maxWhen) {
            return this.end >= whenElapsed && this.start <= maxWhen;
        }

        boolean add(Alarm alarm) {
            boolean newStart = false;
            int index = Collections.binarySearch(this.alarms, alarm, sIncreasingTimeOrder);
            if (index < 0) {
                index = 0 - index - 1;
            }
            this.alarms.add(index, alarm);
            if (alarm.whenElapsed > this.start) {
                this.start = alarm.whenElapsed;
                newStart = true;
            }
            if (alarm.maxWhen < this.end) {
                this.end = alarm.maxWhen;
            }
            return newStart;
        }

        boolean remove(PendingIntent operation) {
            boolean didRemove = false;
            long newStart = 0L;
            long newEnd = Long.MAX_VALUE;
            int i = 0;
            while (i < this.alarms.size()) {
                Alarm alarm = this.alarms.get(i);
                if (alarm.operation.equals(operation)) {
                    this.alarms.remove(i);
                    didRemove = true;
                    continue;
                }
                if (alarm.whenElapsed > newStart) {
                    newStart = alarm.whenElapsed;
                }
                if (alarm.maxWhen < newEnd) {
                    newEnd = alarm.maxWhen;
                }
                ++i;
            }
            if (didRemove) {
                this.start = newStart;
                this.end = newEnd;
            }
            return didRemove;
        }

        boolean remove(String packageName) {
            boolean didRemove = false;
            long newStart = 0L;
            long newEnd = Long.MAX_VALUE;
            int i = 0;
            while (i < this.alarms.size()) {
                Alarm alarm = this.alarms.get(i);
                if (alarm.operation.getTargetPackage().equals(packageName)) {
                    this.alarms.remove(i);
                    didRemove = true;
                    continue;
                }
                if (alarm.whenElapsed > newStart) {
                    newStart = alarm.whenElapsed;
                }
                if (alarm.maxWhen < newEnd) {
                    newEnd = alarm.maxWhen;
                }
                ++i;
            }
            if (didRemove) {
                this.start = newStart;
                this.end = newEnd;
            }
            return didRemove;
        }

        boolean remove(int userHandle) {
            boolean didRemove = false;
            long newStart = 0L;
            long newEnd = Long.MAX_VALUE;
            int i = 0;
            while (i < this.alarms.size()) {
                Alarm alarm = this.alarms.get(i);
                if (UserHandle.getUserId(alarm.operation.getCreatorUid()) == userHandle) {
                    this.alarms.remove(i);
                    didRemove = true;
                    continue;
                }
                if (alarm.whenElapsed > newStart) {
                    newStart = alarm.whenElapsed;
                }
                if (alarm.maxWhen < newEnd) {
                    newEnd = alarm.maxWhen;
                }
                ++i;
            }
            if (didRemove) {
                this.start = newStart;
                this.end = newEnd;
            }
            return didRemove;
        }

        boolean hasPackage(String packageName) {
            int N = this.alarms.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = this.alarms.get(i);
                if (!a.operation.getTargetPackage().equals(packageName)) continue;
                return true;
            }
            return false;
        }

        boolean hasWakeups() {
            int N = this.alarms.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = this.alarms.get(i);
                if ((a.type & 1) != 0) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(40);
            b.append("Batch{");
            b.append(Integer.toHexString(this.hashCode()));
            b.append(" num=");
            b.append(this.size());
            b.append(" start=");
            b.append(this.start);
            b.append(" end=");
            b.append(this.end);
            if (this.standalone) {
                b.append(" STANDALONE");
            }
            b.append('}');
            return b.toString();
        }
    }

    class WakeupEvent {
        public long when;
        public int uid;
        public String action;

        public WakeupEvent(long theTime, int theUid, String theAction) {
            this.when = theTime;
            this.uid = theUid;
            this.action = theAction;
        }
    }
}

