/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.EventLog;

public class EventLogTags {
    public static final int BATTERY_LEVEL = 2722;
    public static final int BATTERY_STATUS = 2723;
    public static final int BATTERY_DISCHARGE = 2730;
    public static final int POWER_SLEEP_REQUESTED = 2724;
    public static final int POWER_SCREEN_BROADCAST_SEND = 2725;
    public static final int POWER_SCREEN_BROADCAST_DONE = 2726;
    public static final int POWER_SCREEN_BROADCAST_STOP = 2727;
    public static final int POWER_SCREEN_STATE = 2728;
    public static final int POWER_PARTIAL_WAKE_STATE = 2729;
    public static final int FREE_STORAGE_CHANGED = 2744;
    public static final int LOW_STORAGE = 2745;
    public static final int FREE_STORAGE_LEFT = 2746;
    public static final int CACHE_FILE_DELETED = 2748;
    public static final int NOTIFICATION_ENQUEUE = 2750;
    public static final int NOTIFICATION_CANCEL = 2751;
    public static final int NOTIFICATION_CANCEL_ALL = 2752;
    public static final int WATCHDOG = 2802;
    public static final int WATCHDOG_PROC_PSS = 2803;
    public static final int WATCHDOG_SOFT_RESET = 2804;
    public static final int WATCHDOG_HARD_RESET = 2805;
    public static final int WATCHDOG_PSS_STATS = 2806;
    public static final int WATCHDOG_PROC_STATS = 2807;
    public static final int WATCHDOG_SCHEDULED_REBOOT = 2808;
    public static final int WATCHDOG_MEMINFO = 2809;
    public static final int WATCHDOG_VMSTAT = 2810;
    public static final int WATCHDOG_REQUESTED_REBOOT = 2811;
    public static final int BACKUP_DATA_CHANGED = 2820;
    public static final int BACKUP_START = 2821;
    public static final int BACKUP_TRANSPORT_FAILURE = 2822;
    public static final int BACKUP_AGENT_FAILURE = 2823;
    public static final int BACKUP_PACKAGE = 2824;
    public static final int BACKUP_SUCCESS = 2825;
    public static final int BACKUP_RESET = 2826;
    public static final int BACKUP_INITIALIZE = 2827;
    public static final int RESTORE_START = 2830;
    public static final int RESTORE_TRANSPORT_FAILURE = 2831;
    public static final int RESTORE_AGENT_FAILURE = 2832;
    public static final int RESTORE_PACKAGE = 2833;
    public static final int RESTORE_SUCCESS = 2834;
    public static final int BOOT_PROGRESS_SYSTEM_RUN = 3010;
    public static final int BOOT_PROGRESS_PMS_START = 3060;
    public static final int BOOT_PROGRESS_PMS_SYSTEM_SCAN_START = 3070;
    public static final int BOOT_PROGRESS_PMS_DATA_SCAN_START = 3080;
    public static final int BOOT_PROGRESS_PMS_SCAN_END = 3090;
    public static final int BOOT_PROGRESS_PMS_READY = 3100;
    public static final int UNKNOWN_SOURCES_ENABLED = 3110;
    public static final int WM_NO_SURFACE_MEMORY = 31000;
    public static final int WM_TASK_CREATED = 31001;
    public static final int WM_TASK_MOVED = 31002;
    public static final int WM_TASK_REMOVED = 31003;
    public static final int WM_STACK_CREATED = 31004;
    public static final int WM_HOME_STACK_MOVED = 31005;
    public static final int WM_STACK_REMOVED = 31006;
    public static final int IMF_FORCE_RECONNECT_IME = 32000;
    public static final int CONNECTIVITY_STATE_CHANGED = 50020;
    public static final int NETSTATS_MOBILE_SAMPLE = 51100;
    public static final int NETSTATS_WIFI_SAMPLE = 51101;
    public static final int LOCKDOWN_VPN_CONNECTING = 51200;
    public static final int LOCKDOWN_VPN_CONNECTED = 51201;
    public static final int LOCKDOWN_VPN_ERROR = 51202;
    public static final int CONFIG_INSTALL_FAILED = 51300;
    public static final int IFW_INTENT_MATCHED = 51400;
    public static final int IDLE_MAINTENANCE_WINDOW_START = 2753;
    public static final int IDLE_MAINTENANCE_WINDOW_FINISH = 2754;
    public static final int FSTRIM_START = 2755;
    public static final int FSTRIM_FINISH = 2756;

    private EventLogTags() {
    }

    public static void writeBatteryLevel(int level, int voltage, int temperature) {
        EventLog.writeEvent(2722, level, voltage, temperature);
    }

    public static void writeBatteryStatus(int status, int health, int present, int plugged, String technology) {
        EventLog.writeEvent(2723, status, health, present, plugged, technology);
    }

    public static void writeBatteryDischarge(long duration, int minlevel, int maxlevel) {
        EventLog.writeEvent(2730, duration, minlevel, maxlevel);
    }

    public static void writePowerSleepRequested(int wakelockscleared) {
        EventLog.writeEvent(2724, wakelockscleared);
    }

    public static void writePowerScreenBroadcastSend(int wakelockcount) {
        EventLog.writeEvent(2725, wakelockcount);
    }

    public static void writePowerScreenBroadcastDone(int on, long broadcastduration, int wakelockcount) {
        EventLog.writeEvent(2726, on, broadcastduration, wakelockcount);
    }

    public static void writePowerScreenBroadcastStop(int which, int wakelockcount) {
        EventLog.writeEvent(2727, which, wakelockcount);
    }

    public static void writePowerScreenState(int offoron, int becauseofuser, long totaltouchdowntime, int touchcycles) {
        EventLog.writeEvent(2728, offoron, becauseofuser, totaltouchdowntime, touchcycles);
    }

    public static void writePowerPartialWakeState(int releasedoracquired, String tag) {
        EventLog.writeEvent(2729, releasedoracquired, tag);
    }

    public static void writeFreeStorageChanged(long data) {
        EventLog.writeEvent(2744, data);
    }

    public static void writeLowStorage(long data) {
        EventLog.writeEvent(2745, data);
    }

    public static void writeFreeStorageLeft(long data, long system, long cache) {
        EventLog.writeEvent(2746, data, system, cache);
    }

    public static void writeCacheFileDeleted(String path) {
        EventLog.writeEvent(2748, path);
    }

    public static void writeNotificationEnqueue(String pkg, int id2, String tag, int userid, String notification) {
        EventLog.writeEvent(2750, pkg, id2, tag, userid, notification);
    }

    public static void writeNotificationCancel(String pkg, int id2, String tag, int userid, int requiredFlags, int forbiddenFlags) {
        EventLog.writeEvent(2751, pkg, id2, tag, userid, requiredFlags, forbiddenFlags);
    }

    public static void writeNotificationCancelAll(String pkg, int userid, int requiredFlags, int forbiddenFlags) {
        EventLog.writeEvent(2752, pkg, userid, requiredFlags, forbiddenFlags);
    }

    public static void writeWatchdog(String service) {
        EventLog.writeEvent(2802, service);
    }

    public static void writeWatchdogProcPss(String process, int pid, int pss) {
        EventLog.writeEvent(2803, process, pid, pss);
    }

    public static void writeWatchdogSoftReset(String process, int pid, int maxpss, int pss, String skip) {
        EventLog.writeEvent(2804, process, pid, maxpss, pss, skip);
    }

    public static void writeWatchdogHardReset(String process, int pid, int maxpss, int pss) {
        EventLog.writeEvent(2805, process, pid, maxpss, pss);
    }

    public static void writeWatchdogPssStats(int emptypss, int emptycount, int backgroundpss, int backgroundcount, int servicepss, int servicecount, int visiblepss, int visiblecount, int foregroundpss, int foregroundcount, int nopsscount) {
        EventLog.writeEvent(2806, emptypss, emptycount, backgroundpss, backgroundcount, servicepss, servicecount, visiblepss, visiblecount, foregroundpss, foregroundcount, nopsscount);
    }

    public static void writeWatchdogProcStats(int deathsinone, int deathsintwo, int deathsinthree, int deathsinfour, int deathsinfive) {
        EventLog.writeEvent(2807, deathsinone, deathsintwo, deathsinthree, deathsinfour, deathsinfive);
    }

    public static void writeWatchdogScheduledReboot(long now, int interval, int starttime, int window, String skip) {
        EventLog.writeEvent(2808, now, interval, starttime, window, skip);
    }

    public static void writeWatchdogMeminfo(int memfree, int buffers, int cached, int active, int inactive, int anonpages, int mapped, int slab, int sreclaimable, int sunreclaim, int pagetables) {
        EventLog.writeEvent(2809, memfree, buffers, cached, active, inactive, anonpages, mapped, slab, sreclaimable, sunreclaim, pagetables);
    }

    public static void writeWatchdogVmstat(long runtime, int pgfree, int pgactivate, int pgdeactivate, int pgfault, int pgmajfault) {
        EventLog.writeEvent(2810, runtime, pgfree, pgactivate, pgdeactivate, pgfault, pgmajfault);
    }

    public static void writeWatchdogRequestedReboot(int nowait, int scheduleinterval, int recheckinterval, int starttime, int window, int minscreenoff, int minnextalarm) {
        EventLog.writeEvent(2811, nowait, scheduleinterval, recheckinterval, starttime, window, minscreenoff, minnextalarm);
    }

    public static void writeBackupDataChanged(String package_) {
        EventLog.writeEvent(2820, package_);
    }

    public static void writeBackupStart(String transport) {
        EventLog.writeEvent(2821, transport);
    }

    public static void writeBackupTransportFailure(String package_) {
        EventLog.writeEvent(2822, package_);
    }

    public static void writeBackupAgentFailure(String package_, String message) {
        EventLog.writeEvent(2823, package_, message);
    }

    public static void writeBackupPackage(String package_, int size) {
        EventLog.writeEvent(2824, package_, size);
    }

    public static void writeBackupSuccess(int packages, int time) {
        EventLog.writeEvent(2825, packages, time);
    }

    public static void writeBackupReset(String transport) {
        EventLog.writeEvent(2826, transport);
    }

    public static void writeBackupInitialize() {
        EventLog.writeEvent(2827, new Object[0]);
    }

    public static void writeRestoreStart(String transport, long source) {
        EventLog.writeEvent(2830, transport, source);
    }

    public static void writeRestoreTransportFailure() {
        EventLog.writeEvent(2831, new Object[0]);
    }

    public static void writeRestoreAgentFailure(String package_, String message) {
        EventLog.writeEvent(2832, package_, message);
    }

    public static void writeRestorePackage(String package_, int size) {
        EventLog.writeEvent(2833, package_, size);
    }

    public static void writeRestoreSuccess(int packages, int time) {
        EventLog.writeEvent(2834, packages, time);
    }

    public static void writeBootProgressSystemRun(long time) {
        EventLog.writeEvent(3010, time);
    }

    public static void writeBootProgressPmsStart(long time) {
        EventLog.writeEvent(3060, time);
    }

    public static void writeBootProgressPmsSystemScanStart(long time) {
        EventLog.writeEvent(3070, time);
    }

    public static void writeBootProgressPmsDataScanStart(long time) {
        EventLog.writeEvent(3080, time);
    }

    public static void writeBootProgressPmsScanEnd(long time) {
        EventLog.writeEvent(3090, time);
    }

    public static void writeBootProgressPmsReady(long time) {
        EventLog.writeEvent(3100, time);
    }

    public static void writeUnknownSourcesEnabled(int value) {
        EventLog.writeEvent(3110, value);
    }

    public static void writeWmNoSurfaceMemory(String window, int pid, String operation) {
        EventLog.writeEvent(31000, window, pid, operation);
    }

    public static void writeWmTaskCreated(int taskid, int stackid) {
        EventLog.writeEvent(31001, taskid, stackid);
    }

    public static void writeWmTaskMoved(int taskid, int totop, int index) {
        EventLog.writeEvent(31002, taskid, totop, index);
    }

    public static void writeWmTaskRemoved(int taskid, String reason) {
        EventLog.writeEvent(31003, taskid, reason);
    }

    public static void writeWmStackCreated(int stackid, int relativeboxid, int position, int weight) {
        EventLog.writeEvent(31004, stackid, relativeboxid, position, weight);
    }

    public static void writeWmHomeStackMoved(int totop) {
        EventLog.writeEvent(31005, totop);
    }

    public static void writeWmStackRemoved(int stackid) {
        EventLog.writeEvent(31006, stackid);
    }

    public static void writeImfForceReconnectIme(Object[] ime, long timeSinceConnect, int showing) {
        EventLog.writeEvent(32000, ime, timeSinceConnect, showing);
    }

    public static void writeConnectivityStateChanged(int type, int subtype, int state) {
        EventLog.writeEvent(50020, type, subtype, state);
    }

    public static void writeNetstatsMobileSample(long devRxBytes, long devTxBytes, long devRxPkts, long devTxPkts, long xtRxBytes, long xtTxBytes, long xtRxPkts, long xtTxPkts, long uidRxBytes, long uidTxBytes, long uidRxPkts, long uidTxPkts, long trustedTime) {
        EventLog.writeEvent(51100, devRxBytes, devTxBytes, devRxPkts, devTxPkts, xtRxBytes, xtTxBytes, xtRxPkts, xtTxPkts, uidRxBytes, uidTxBytes, uidRxPkts, uidTxPkts, trustedTime);
    }

    public static void writeNetstatsWifiSample(long devRxBytes, long devTxBytes, long devRxPkts, long devTxPkts, long xtRxBytes, long xtTxBytes, long xtRxPkts, long xtTxPkts, long uidRxBytes, long uidTxBytes, long uidRxPkts, long uidTxPkts, long trustedTime) {
        EventLog.writeEvent(51101, devRxBytes, devTxBytes, devRxPkts, devTxPkts, xtRxBytes, xtTxBytes, xtRxPkts, xtTxPkts, uidRxBytes, uidTxBytes, uidRxPkts, uidTxPkts, trustedTime);
    }

    public static void writeLockdownVpnConnecting(int egressNet) {
        EventLog.writeEvent(51200, egressNet);
    }

    public static void writeLockdownVpnConnected(int egressNet) {
        EventLog.writeEvent(51201, egressNet);
    }

    public static void writeLockdownVpnError(int egressNet) {
        EventLog.writeEvent(51202, egressNet);
    }

    public static void writeConfigInstallFailed(String dir) {
        EventLog.writeEvent(51300, dir);
    }

    public static void writeIfwIntentMatched(int intentType, String componentName, int callerUid, int callerPkgCount, String callerPkgs, String action, String mimeType, String uri, int flags) {
        EventLog.writeEvent(51400, intentType, componentName, callerUid, callerPkgCount, callerPkgs, action, mimeType, uri, flags);
    }

    public static void writeIdleMaintenanceWindowStart(long time, long lastuseractivity, int batterylevel, int batterycharging) {
        EventLog.writeEvent(2753, time, lastuseractivity, batterylevel, batterycharging);
    }

    public static void writeIdleMaintenanceWindowFinish(long time, long lastuseractivity, int batterylevel, int batterycharging) {
        EventLog.writeEvent(2754, time, lastuseractivity, batterylevel, batterycharging);
    }

    public static void writeFstrimStart(long time) {
        EventLog.writeEvent(2755, time);
    }

    public static void writeFstrimFinish(long time) {
        EventLog.writeEvent(2756, time);
    }
}

