/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.app.AppGlobals;
import android.app.IUserSwitchObserver;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.style.SuggestionSpan;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.LruCache;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.InputChannel;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.Switch;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.content.PackageMonitor;
import com.android.internal.inputmethod.InputMethodUtils;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;
import com.android.internal.view.InputBindResult;
import com.android.server.StatusBarManagerService;
import com.android.server.wm.WindowManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMethodManagerService
extends IInputMethodManager.Stub
implements ServiceConnection,
Handler.Callback {
    static final boolean DEBUG = false;
    static final String TAG = "InputMethodManagerService";
    static final int MSG_SHOW_IM_PICKER = 1;
    static final int MSG_SHOW_IM_SUBTYPE_PICKER = 2;
    static final int MSG_SHOW_IM_SUBTYPE_ENABLER = 3;
    static final int MSG_SHOW_IM_CONFIG = 4;
    static final int MSG_UNBIND_INPUT = 1000;
    static final int MSG_BIND_INPUT = 1010;
    static final int MSG_SHOW_SOFT_INPUT = 1020;
    static final int MSG_HIDE_SOFT_INPUT = 1030;
    static final int MSG_ATTACH_TOKEN = 1040;
    static final int MSG_CREATE_SESSION = 1050;
    static final int MSG_START_INPUT = 2000;
    static final int MSG_RESTART_INPUT = 2010;
    static final int MSG_UNBIND_METHOD = 3000;
    static final int MSG_BIND_METHOD = 3010;
    static final int MSG_SET_ACTIVE = 3020;
    static final int MSG_HARD_KEYBOARD_SWITCH_CHANGED = 4000;
    static final long TIME_TO_RECONNECT = 10000L;
    static final int SECURE_SUGGESTION_SPANS_MAX_SIZE = 20;
    private static final int NOT_A_SUBTYPE_ID = -1;
    private static final String TAG_TRY_SUPPRESSING_IME_SWITCHER = "TrySuppressingImeSwitcher";
    final Context mContext;
    final Resources mRes;
    final Handler mHandler;
    final InputMethodUtils.InputMethodSettings mSettings;
    final SettingsObserver mSettingsObserver;
    final IWindowManager mIWindowManager;
    final HandlerCaller mCaller;
    final boolean mHasFeature;
    private InputMethodFileManager mFileManager;
    private InputMethodAndSubtypeListManager mImListManager;
    private final HardKeyboardListener mHardKeyboardListener;
    private final WindowManagerService mWindowManagerService;
    final InputBindResult mNoBinding = new InputBindResult(null, null, null, -1);
    final ArrayList<InputMethodInfo> mMethodList = new ArrayList();
    final HashMap<String, InputMethodInfo> mMethodMap = new HashMap();
    private final LruCache<SuggestionSpan, InputMethodInfo> mSecureSuggestionSpans = new LruCache(20);
    final ServiceConnection mVisibleConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    };
    boolean mVisibleBound = false;
    private NotificationManager mNotificationManager;
    private KeyguardManager mKeyguardManager;
    private StatusBarManagerService mStatusBar;
    private Notification mImeSwitcherNotification;
    private PendingIntent mImeSwitchPendingIntent;
    private boolean mShowOngoingImeSwitcherForPhones;
    private boolean mNotificationShown;
    private final boolean mImeSelectedOnBoot;
    final HashMap<IBinder, ClientState> mClients = new HashMap();
    boolean mSystemReady;
    String mCurMethodId;
    int mCurSeq;
    ClientState mCurClient;
    IBinder mCurFocusedWindow;
    IInputContext mCurInputContext;
    EditorInfo mCurAttribute;
    String mCurId;
    private InputMethodSubtype mCurrentSubtype;
    private final HashMap<InputMethodInfo, ArrayList<InputMethodSubtype>> mShortcutInputMethodsAndSubtypes = new HashMap();
    private boolean mCurClientInKeyguard;
    boolean mHaveConnection;
    boolean mShowRequested;
    boolean mShowExplicitlyRequested;
    boolean mShowForced;
    boolean mInputShown;
    Intent mCurIntent;
    IBinder mCurToken;
    IInputMethod mCurMethod;
    long mLastBindTime;
    boolean mBoundToMethod;
    SessionState mEnabledSession;
    boolean mScreenOn = true;
    int mBackDisposition = 0;
    int mImeWindowVis;
    private AlertDialog.Builder mDialogBuilder;
    private AlertDialog mSwitchingDialog;
    private View mSwitchingDialogTitleView;
    private InputMethodInfo[] mIms;
    private int[] mSubtypeIds;
    private Locale mLastSystemLocale;
    private final MyPackageMonitor mMyPackageMonitor = new MyPackageMonitor();
    private final IPackageManager mIPackageManager = AppGlobals.getPackageManager();

    public InputMethodManagerService(Context context, WindowManagerService windowManager) {
        this.mContext = context;
        this.mRes = context.getResources();
        this.mHandler = new Handler(this);
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mCaller = new HandlerCaller(context, null, new HandlerCaller.Callback(){

            public void executeMessage(Message msg) {
                InputMethodManagerService.this.handleMessage(msg);
            }
        }, true);
        this.mWindowManagerService = windowManager;
        this.mHardKeyboardListener = new HardKeyboardListener();
        this.mHasFeature = context.getPackageManager().hasSystemFeature("android.software.input_methods");
        this.mImeSwitcherNotification = new Notification();
        this.mImeSwitcherNotification.icon = 17302380;
        this.mImeSwitcherNotification.when = 0L;
        this.mImeSwitcherNotification.flags = 2;
        this.mImeSwitcherNotification.tickerText = null;
        this.mImeSwitcherNotification.defaults = 0;
        this.mImeSwitcherNotification.sound = null;
        this.mImeSwitcherNotification.vibrate = null;
        this.mImeSwitcherNotification.kind = new String[]{"android.system.imeswitcher"};
        Intent intent = new Intent("android.settings.SHOW_INPUT_METHOD_PICKER");
        this.mImeSwitchPendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.mShowOngoingImeSwitcherForPhones = false;
        IntentFilter broadcastFilter = new IntentFilter();
        broadcastFilter.addAction("android.intent.action.SCREEN_ON");
        broadcastFilter.addAction("android.intent.action.SCREEN_OFF");
        broadcastFilter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.mContext.registerReceiver(new ImmsBroadcastReceiver(), broadcastFilter);
        this.mNotificationShown = false;
        int userId = 0;
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver(new IUserSwitchObserver.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onUserSwitching(int newUserId, IRemoteCallback reply) {
                    HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
                    synchronized (hashMap) {
                        InputMethodManagerService.this.switchUserLocked(newUserId);
                    }
                    if (reply != null) {
                        try {
                            reply.sendResult(null);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                public void onUserSwitchComplete(int newUserId) throws RemoteException {
                }
            });
            userId = ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Couldn't get current user ID; guessing it's 0", e);
        }
        this.mMyPackageMonitor.register(this.mContext, null, UserHandle.ALL, true);
        this.mSettings = new InputMethodUtils.InputMethodSettings(this.mRes, context.getContentResolver(), this.mMethodMap, this.mMethodList, userId);
        this.mFileManager = new InputMethodFileManager(this.mMethodMap, userId);
        this.mImListManager = new InputMethodAndSubtypeListManager(context, this);
        String defaultImiId = this.mSettings.getSelectedInputMethod();
        this.mImeSelectedOnBoot = !TextUtils.isEmpty(defaultImiId);
        this.buildInputMethodListLocked(this.mMethodList, this.mMethodMap, !this.mImeSelectedOnBoot);
        this.mSettings.enableAllIMEsIfThereIsNoEnabledIME();
        if (!this.mImeSelectedOnBoot) {
            Slog.w(TAG, "No IME selected. Choose the most applicable IME.");
            this.resetDefaultImeLocked(context);
        }
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.updateFromSettingsLocked(true);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.LOCALE_CHANGED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
                synchronized (hashMap) {
                    InputMethodManagerService.this.resetStateIfCurrentLocaleChangedLocked();
                }
            }
        }, filter);
    }

    private void resetDefaultImeLocked(Context context) {
        if (this.mCurMethodId != null && !InputMethodUtils.isSystemIme(this.mMethodMap.get(this.mCurMethodId))) {
            return;
        }
        InputMethodInfo defIm = null;
        for (InputMethodInfo imi : this.mMethodList) {
            if (defIm != null || !InputMethodUtils.isValidSystemDefaultIme(this.mSystemReady, imi, context)) continue;
            defIm = imi;
            Slog.i(TAG, "Selected default: " + imi.getId());
        }
        if (defIm == null && this.mMethodList.size() > 0) {
            defIm = InputMethodUtils.getMostApplicableDefaultIME(this.mSettings.getEnabledInputMethodListLocked());
            Slog.i(TAG, "No default found, using " + defIm.getId());
        }
        if (defIm != null) {
            this.setSelectedInputMethodAndSubtypeLocked(defIm, -1, false);
        }
    }

    private void resetAllInternalStateLocked(boolean updateOnlyWhenLocaleChanged, boolean resetDefaultEnabledIme) {
        if (!this.mSystemReady) {
            return;
        }
        Locale newLocale = this.mRes.getConfiguration().locale;
        if (!updateOnlyWhenLocaleChanged || newLocale != null && !newLocale.equals(this.mLastSystemLocale)) {
            if (!updateOnlyWhenLocaleChanged) {
                this.hideCurrentInputLocked(0, null);
                this.mCurMethodId = null;
                this.unbindCurrentMethodLocked(true, false);
            }
            this.mImListManager = new InputMethodAndSubtypeListManager(this.mContext, this);
            this.buildInputMethodListLocked(this.mMethodList, this.mMethodMap, resetDefaultEnabledIme);
            if (!updateOnlyWhenLocaleChanged) {
                String selectedImiId = this.mSettings.getSelectedInputMethod();
                if (TextUtils.isEmpty(selectedImiId)) {
                    this.resetDefaultImeLocked(this.mContext);
                }
            } else {
                this.resetDefaultImeLocked(this.mContext);
            }
            this.updateFromSettingsLocked(true);
            this.mLastSystemLocale = newLocale;
            if (!updateOnlyWhenLocaleChanged) {
                try {
                    this.startInputInnerLocked();
                }
                catch (RuntimeException e) {
                    Slog.w(TAG, "Unexpected exception", e);
                }
            }
        }
    }

    private void resetStateIfCurrentLocaleChangedLocked() {
        this.resetAllInternalStateLocked(true, true);
    }

    private void switchUserLocked(int newUserId) {
        this.mSettings.setCurrentUserId(newUserId);
        this.mFileManager = new InputMethodFileManager(this.mMethodMap, newUserId);
        String defaultImiId = this.mSettings.getSelectedInputMethod();
        boolean initialUserSwitch = TextUtils.isEmpty(defaultImiId);
        this.resetAllInternalStateLocked(false, initialUserSwitch);
        if (initialUserSwitch) {
            InputMethodUtils.setNonSelectedSystemImesDisabledUntilUsed(this.mContext.getPackageManager(), this.mSettings.getEnabledInputMethodListLocked());
        }
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Input Method Manager Crash", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemRunning(StatusBarManagerService statusBar) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!this.mSystemReady) {
                this.mSystemReady = true;
                this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
                this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                this.mStatusBar = statusBar;
                statusBar.setIconVisibility("ime", false);
                this.updateImeWindowStatusLocked();
                this.mShowOngoingImeSwitcherForPhones = this.mRes.getBoolean(0x1110008);
                if (this.mShowOngoingImeSwitcherForPhones) {
                    this.mWindowManagerService.setOnHardKeyboardStatusChangeListener(this.mHardKeyboardListener);
                }
                this.buildInputMethodListLocked(this.mMethodList, this.mMethodMap, !this.mImeSelectedOnBoot);
                if (!this.mImeSelectedOnBoot) {
                    Slog.w(TAG, "Reset the default IME as \"Resource\" is ready here.");
                    this.resetStateIfCurrentLocaleChangedLocked();
                    InputMethodUtils.setNonSelectedSystemImesDisabledUntilUsed(this.mContext.getPackageManager(), this.mSettings.getEnabledInputMethodListLocked());
                }
                this.mLastSystemLocale = this.mRes.getConfiguration().locale;
                try {
                    this.startInputInnerLocked();
                }
                catch (RuntimeException e) {
                    Slog.w(TAG, "Unexpected exception", e);
                }
            }
        }
    }

    private void setImeWindowVisibilityStatusHiddenLocked() {
        this.mImeWindowVis = 0;
        this.updateImeWindowStatusLocked();
    }

    private void refreshImeWindowVisibilityLocked() {
        Configuration conf = this.mRes.getConfiguration();
        boolean haveHardKeyboard = conf.keyboard != 1;
        boolean hardKeyShown = haveHardKeyboard && conf.hardKeyboardHidden != 2;
        boolean isScreenLocked = this.isKeyguardLocked();
        boolean inputActive = !isScreenLocked && (this.mInputShown || hardKeyShown);
        boolean inputVisible = inputActive && !hardKeyShown;
        this.mImeWindowVis = (inputActive ? 1 : 0) | (inputVisible ? 2 : 0);
        this.updateImeWindowStatusLocked();
    }

    private void updateImeWindowStatusLocked() {
        this.setImeWindowStatus(this.mCurToken, this.mImeWindowVis, this.mBackDisposition);
    }

    private boolean calledFromValidUser() {
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(uid);
        if (uid == 1000 || userId == this.mSettings.getCurrentUserId()) {
            return true;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0) {
            return true;
        }
        Slog.w(TAG, "--- IPC called from background users. Ignore. \n" + InputMethodUtils.getStackTrace());
        return false;
    }

    private boolean bindCurrentInputMethodService(Intent service, ServiceConnection conn, int flags) {
        if (service == null || conn == null) {
            Slog.e(TAG, "--- bind failed: service = " + service + ", conn = " + conn);
            return false;
        }
        return this.mContext.bindServiceAsUser(service, conn, flags, new UserHandle(this.mSettings.getCurrentUserId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodInfo> getInputMethodList() {
        if (!this.calledFromValidUser()) {
            return Collections.emptyList();
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return new ArrayList<InputMethodInfo>(this.mMethodList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodInfo> getEnabledInputMethodList() {
        if (!this.calledFromValidUser()) {
            return Collections.emptyList();
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return this.mSettings.getEnabledInputMethodListLocked();
        }
    }

    private HashMap<InputMethodInfo, List<InputMethodSubtype>> getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked() {
        HashMap<InputMethodInfo, List<InputMethodSubtype>> enabledInputMethodAndSubtypes = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
        for (InputMethodInfo imi : this.mSettings.getEnabledInputMethodListLocked()) {
            enabledInputMethodAndSubtypes.put(imi, this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true));
        }
        return enabledInputMethodAndSubtypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlySelectedSubtypes) {
        if (!this.calledFromValidUser()) {
            return Collections.emptyList();
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo imi = imiId == null && this.mCurMethodId != null ? this.mMethodMap.get(this.mCurMethodId) : this.mMethodMap.get(imiId);
            if (imi == null) {
                return Collections.emptyList();
            }
            return this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, allowsImplicitlySelectedSubtypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClient(IInputMethodClient client, IInputContext inputContext, int uid, int pid) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mClients.put(client.asBinder(), new ClientState(client, inputContext, uid, pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClient(IInputMethodClient client) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ClientState cs = this.mClients.remove(client.asBinder());
            if (cs != null) {
                this.clearClientSessionLocked(cs);
            }
        }
    }

    void executeOrSendMessage(IInterface target, Message msg) {
        if (target.asBinder() instanceof Binder) {
            this.mCaller.sendMessage(msg);
        } else {
            this.handleMessage(msg);
            msg.recycle();
        }
    }

    void unbindCurrentClientLocked() {
        if (this.mCurClient != null) {
            if (this.mBoundToMethod) {
                this.mBoundToMethod = false;
                if (this.mCurMethod != null) {
                    this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageO(1000, this.mCurMethod));
                }
            }
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3020, 0, this.mCurClient));
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3000, this.mCurSeq, this.mCurClient.client));
            this.mCurClient.sessionRequested = false;
            this.mCurClient = null;
            this.hideInputMethodMenuLocked();
        }
    }

    private int getImeShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 3;
        } else if (this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    private int getAppShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 2;
        } else if (!this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    InputBindResult attachNewInputLocked(boolean initial) {
        if (!this.mBoundToMethod) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1010, this.mCurMethod, this.mCurClient.binding));
            this.mBoundToMethod = true;
        }
        SessionState session = this.mCurClient.curSession;
        if (initial) {
            this.executeOrSendMessage(session.method, this.mCaller.obtainMessageOOO(2000, session, this.mCurInputContext, this.mCurAttribute));
        } else {
            this.executeOrSendMessage(session.method, this.mCaller.obtainMessageOOO(2010, session, this.mCurInputContext, this.mCurAttribute));
        }
        if (this.mShowRequested) {
            this.showCurrentInputLocked(this.getAppShowFlags(), null);
        }
        return new InputBindResult(session.session, session.channel != null ? session.channel.dup() : null, this.mCurId, this.mCurSeq);
    }

    InputBindResult startInputLocked(IInputMethodClient client, IInputContext inputContext, EditorInfo attribute, int controlFlags) {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        ClientState cs = this.mClients.get(client.asBinder());
        if (cs == null) {
            throw new IllegalArgumentException("unknown client " + client.asBinder());
        }
        try {
            if (!this.mIWindowManager.inputMethodClientHasFocus(cs.client)) {
                Slog.w(TAG, "Starting input on non-focused client " + cs.client + " (uid=" + cs.uid + " pid=" + cs.pid + ")");
                return null;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return this.startInputUncheckedLocked(cs, inputContext, attribute, controlFlags);
    }

    InputBindResult startInputUncheckedLocked(ClientState cs, IInputContext inputContext, EditorInfo attribute, int controlFlags) {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        if (this.mCurClient != cs) {
            this.mCurClientInKeyguard = this.isKeyguardLocked();
            this.unbindCurrentClientLocked();
            if (this.mScreenOn) {
                this.executeOrSendMessage(cs.client, this.mCaller.obtainMessageIO(3020, this.mScreenOn ? 1 : 0, cs));
            }
        }
        ++this.mCurSeq;
        if (this.mCurSeq <= 0) {
            this.mCurSeq = 1;
        }
        this.mCurClient = cs;
        this.mCurInputContext = inputContext;
        this.mCurAttribute = attribute;
        if (this.mCurId != null && this.mCurId.equals(this.mCurMethodId)) {
            if (cs.curSession != null) {
                return this.attachNewInputLocked((controlFlags & 0x100) != 0);
            }
            if (this.mHaveConnection) {
                if (this.mCurMethod != null) {
                    this.requestClientSessionLocked(cs);
                    return new InputBindResult(null, null, this.mCurId, this.mCurSeq);
                }
                if (SystemClock.uptimeMillis() < this.mLastBindTime + 10000L) {
                    return new InputBindResult(null, null, this.mCurId, this.mCurSeq);
                }
                EventLog.writeEvent(32000, this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 0);
            }
        }
        return this.startInputInnerLocked();
    }

    InputBindResult startInputInnerLocked() {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        if (!this.mSystemReady) {
            return new InputBindResult(null, null, this.mCurMethodId, this.mCurSeq);
        }
        InputMethodInfo info = this.mMethodMap.get(this.mCurMethodId);
        if (info == null) {
            throw new IllegalArgumentException("Unknown id: " + this.mCurMethodId);
        }
        this.unbindCurrentMethodLocked(false, true);
        this.mCurIntent = new Intent("android.view.InputMethod");
        this.mCurIntent.setComponent(info.getComponent());
        this.mCurIntent.putExtra("android.intent.extra.client_label", 17040558);
        this.mCurIntent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(this.mContext, 0, new Intent("android.settings.INPUT_METHOD_SETTINGS"), 0));
        if (this.bindCurrentInputMethodService(this.mCurIntent, this, 0x60000001)) {
            this.mLastBindTime = SystemClock.uptimeMillis();
            this.mHaveConnection = true;
            this.mCurId = info.getId();
            this.mCurToken = new Binder();
            try {
                Slog.v(TAG, "Adding window token: " + this.mCurToken);
                this.mIWindowManager.addWindowToken(this.mCurToken, 2011);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return new InputBindResult(null, null, this.mCurId, this.mCurSeq);
        }
        this.mCurIntent = null;
        Slog.w(TAG, "Failure connecting to input method service: " + this.mCurIntent);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputBindResult startInput(IInputMethodClient client, IInputContext inputContext, EditorInfo attribute, int controlFlags) {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputBindResult inputBindResult;
            long ident = Binder.clearCallingIdentity();
            try {
                inputBindResult = this.startInputLocked(client, inputContext, attribute, controlFlags);
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return inputBindResult;
        }
    }

    @Override
    public void finishInput(IInputMethodClient client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurIntent != null && name.equals(this.mCurIntent.getComponent())) {
                this.mCurMethod = IInputMethod.Stub.asInterface(service);
                if (this.mCurToken == null) {
                    Slog.w(TAG, "Service connected without a token!");
                    this.unbindCurrentMethodLocked(false, false);
                    return;
                }
                this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1040, this.mCurMethod, this.mCurToken));
                if (this.mCurClient != null) {
                    this.clearClientSessionLocked(this.mCurClient);
                    this.requestClientSessionLocked(this.mCurClient);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionCreated(IInputMethod method, IInputMethodSession session, InputChannel channel) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurMethod != null && method != null && this.mCurMethod.asBinder() == method.asBinder() && this.mCurClient != null) {
                this.clearClientSessionLocked(this.mCurClient);
                this.mCurClient.curSession = new SessionState(this.mCurClient, method, session, channel);
                InputBindResult res = this.attachNewInputLocked(true);
                if (res.method != null) {
                    this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageOO(3010, this.mCurClient.client, res));
                }
                return;
            }
        }
        channel.dispose();
    }

    void unbindCurrentMethodLocked(boolean reportToClient, boolean savePosition) {
        if (this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        if (this.mHaveConnection) {
            this.mContext.unbindService(this);
            this.mHaveConnection = false;
        }
        if (this.mCurToken != null) {
            try {
                if ((this.mImeWindowVis & 1) != 0 && savePosition) {
                    this.mWindowManagerService.saveLastInputMethodWindowForTransition();
                }
                this.mIWindowManager.removeWindowToken(this.mCurToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurToken = null;
        }
        this.mCurId = null;
        this.clearCurMethodLocked();
        if (reportToClient && this.mCurClient != null) {
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3000, this.mCurSeq, this.mCurClient.client));
        }
    }

    void requestClientSessionLocked(ClientState cs) {
        if (!cs.sessionRequested) {
            InputChannel[] channels = InputChannel.openInputChannelPair(cs.toString());
            cs.sessionRequested = true;
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOOO(1050, this.mCurMethod, channels[1], new MethodCallback(this, this.mCurMethod, channels[0])));
        }
    }

    void clearClientSessionLocked(ClientState cs) {
        this.finishSessionLocked(cs.curSession);
        cs.curSession = null;
        cs.sessionRequested = false;
    }

    private void finishSessionLocked(SessionState sessionState) {
        if (sessionState != null) {
            if (sessionState.session != null) {
                try {
                    sessionState.session.finishSession();
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Session failed to close due to remote exception", e);
                    this.setImeWindowVisibilityStatusHiddenLocked();
                }
                sessionState.session = null;
            }
            if (sessionState.channel != null) {
                sessionState.channel.dispose();
                sessionState.channel = null;
            }
        }
    }

    void clearCurMethodLocked() {
        if (this.mCurMethod != null) {
            for (ClientState cs : this.mClients.values()) {
                this.clearClientSessionLocked(cs);
            }
            this.finishSessionLocked(this.mEnabledSession);
            this.mEnabledSession = null;
            this.mCurMethod = null;
        }
        if (this.mStatusBar != null) {
            this.mStatusBar.setIconVisibility("ime", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName name) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurMethod != null && this.mCurIntent != null && name.equals(this.mCurIntent.getComponent())) {
                this.clearCurMethodLocked();
                this.mLastBindTime = SystemClock.uptimeMillis();
                this.mShowRequested = this.mInputShown;
                this.mInputShown = false;
                if (this.mCurClient != null) {
                    this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3000, this.mCurSeq, this.mCurClient.client));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateStatusIcon(IBinder token, String packageName, int iconId) {
        long ident;
        block13: {
            block12: {
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    if (token == null || this.mCurToken != token) {
                        Slog.w(TAG, "Ignoring setInputMethod of uid " + uid + " token: " + token);
                        Object var12_6 = null;
                        break block12;
                    }
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        if (iconId == 0) {
                            if (this.mStatusBar != null) {
                                this.mStatusBar.setIconVisibility("ime", false);
                            }
                        } else if (packageName != null) {
                            CharSequence contentDescription = null;
                            try {
                                PackageManager packageManager = this.mContext.getPackageManager();
                                contentDescription = packageManager.getApplicationLabel(this.mIPackageManager.getApplicationInfo(packageName, 0, this.mSettings.getCurrentUserId()));
                            }
                            catch (RemoteException e) {
                                // empty catch block
                            }
                            if (this.mStatusBar != null) {
                                this.mStatusBar.setIcon("ime", packageName, iconId, 0, contentDescription != null ? ((Object)contentDescription).toString() : null);
                                this.mStatusBar.setIconVisibility("ime", true);
                            }
                        }
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(ident);
            return;
        }
        Object var12_7 = null;
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsToShowImeSwitchOngoingNotification() {
        if (!this.mShowOngoingImeSwitcherForPhones) {
            return false;
        }
        if (this.isScreenLocked()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            List<InputMethodInfo> imis = this.mSettings.getEnabledInputMethodListLocked();
            int N = imis.size();
            if (N > 2) {
                return true;
            }
            if (N < 1) {
                return false;
            }
            int nonAuxCount = 0;
            int auxCount = 0;
            InputMethodSubtype nonAuxSubtype = null;
            InputMethodSubtype auxSubtype = null;
            for (int i = 0; i < N; ++i) {
                InputMethodInfo imi = imis.get(i);
                List<InputMethodSubtype> subtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
                int subtypeCount = subtypes.size();
                if (subtypeCount == 0) {
                    ++nonAuxCount;
                    continue;
                }
                for (int j = 0; j < subtypeCount; ++j) {
                    InputMethodSubtype subtype = subtypes.get(j);
                    if (!subtype.isAuxiliary()) {
                        ++nonAuxCount;
                        nonAuxSubtype = subtype;
                        continue;
                    }
                    ++auxCount;
                    auxSubtype = subtype;
                }
            }
            if (nonAuxCount > 1 || auxCount > 1) {
                return true;
            }
            if (nonAuxCount == 1 && auxCount == 1) {
                return nonAuxSubtype == null || auxSubtype == null || !nonAuxSubtype.getLocale().equals(auxSubtype.getLocale()) && !auxSubtype.overridesImplicitlyEnabledSubtype() && !nonAuxSubtype.overridesImplicitlyEnabledSubtype() || !nonAuxSubtype.containsExtraValueKey(TAG_TRY_SUPPRESSING_IME_SWITCHER);
                {
                }
            }
            return false;
        }
    }

    private boolean isKeyguardLocked() {
        return this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setImeWindowStatus(IBinder token, int vis, int backDisposition) {
        long ident;
        block12: {
            block11: {
                ident = Binder.clearCallingIdentity();
                try {
                    if (token == null || this.mCurToken != token) {
                        int uid = Binder.getCallingUid();
                        Slog.w(TAG, "Ignoring setImeWindowStatus of uid " + uid + " token: " + token);
                        Object var13_7 = null;
                        break block11;
                    }
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        if (vis != 0 && this.isKeyguardLocked() && !this.mCurClientInKeyguard) {
                            vis = 0;
                        }
                        this.mImeWindowVis = vis;
                        this.mBackDisposition = backDisposition;
                        if (this.mStatusBar != null) {
                            this.mStatusBar.setImeWindowStatus(token, vis, backDisposition);
                        }
                        boolean iconVisibility = (vis & 1) != 0 && (this.mWindowManagerService.isHardKeyboardAvailable() || (vis & 2) != 0);
                        InputMethodInfo imi = this.mMethodMap.get(this.mCurMethodId);
                        if (imi != null && iconVisibility && this.needsToShowImeSwitchOngoingNotification()) {
                            CharSequence title = this.mRes.getText(17040508);
                            CharSequence summary = InputMethodUtils.getImeAndSubtypeDisplayName(this.mContext, imi, this.mCurrentSubtype);
                            this.mImeSwitcherNotification.setLatestEventInfo(this.mContext, title, summary, this.mImeSwitchPendingIntent);
                            if (this.mNotificationManager != null) {
                                this.mNotificationManager.notifyAsUser(null, 17040508, this.mImeSwitcherNotification, UserHandle.ALL);
                                this.mNotificationShown = true;
                            }
                        } else if (this.mNotificationShown && this.mNotificationManager != null) {
                            this.mNotificationManager.cancelAsUser(null, 17040508, UserHandle.ALL);
                            this.mNotificationShown = false;
                        }
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var13_9 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(ident);
            return;
        }
        Object var13_8 = null;
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSuggestionSpansForNotification(SuggestionSpan[] spans) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo currentImi = this.mMethodMap.get(this.mCurMethodId);
            for (int i = 0; i < spans.length; ++i) {
                SuggestionSpan ss = spans[i];
                if (TextUtils.isEmpty(ss.getNotificationTargetClassName())) continue;
                this.mSecureSuggestionSpans.put(ss, currentImi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifySuggestionPicked(SuggestionSpan span, String originalString, int index) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo targetImi = this.mSecureSuggestionSpans.get(span);
            if (targetImi != null) {
                String[] suggestions = span.getSuggestions();
                if (index < 0 || index >= suggestions.length) {
                    return false;
                }
                String className = span.getNotificationTargetClassName();
                Intent intent = new Intent();
                intent.setClassName(targetImi.getPackageName(), className);
                intent.setAction("android.text.style.SUGGESTION_PICKED");
                intent.putExtra("before", originalString);
                intent.putExtra("after", suggestions[index]);
                intent.putExtra("hashcode", span.hashCode());
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mContext.sendBroadcastAsUser(intent, UserHandle.CURRENT);
                    Object var12_10 = null;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(ident);
                return true;
            }
        }
        return false;
    }

    void updateFromSettingsLocked(boolean enabledMayChange) {
        String id2;
        if (enabledMayChange) {
            List<InputMethodInfo> enabled = this.mSettings.getEnabledInputMethodListLocked();
            for (int i = 0; i < enabled.size(); ++i) {
                InputMethodInfo imm = enabled.get(i);
                try {
                    ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(imm.getPackageName(), 32768, this.mSettings.getCurrentUserId());
                    if (ai == null || ai.enabledSetting != 4) continue;
                    this.mIPackageManager.setApplicationEnabledSetting(imm.getPackageName(), 0, 1, this.mSettings.getCurrentUserId(), this.mContext.getBasePackageName());
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        if (TextUtils.isEmpty(id2 = this.mSettings.getSelectedInputMethod()) && this.chooseNewDefaultIMELocked()) {
            id2 = this.mSettings.getSelectedInputMethod();
        }
        if (!TextUtils.isEmpty(id2)) {
            try {
                this.setInputMethodLocked(id2, this.mSettings.getSelectedInputMethodSubtypeId(id2));
            }
            catch (IllegalArgumentException e) {
                Slog.w(TAG, "Unknown input method from prefs: " + id2, e);
                this.mCurMethodId = null;
                this.unbindCurrentMethodLocked(true, false);
            }
            this.mShortcutInputMethodsAndSubtypes.clear();
        } else {
            this.mCurMethodId = null;
            this.unbindCurrentMethodLocked(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputMethodLocked(String id2, int subtypeId) {
        InputMethodInfo info = this.mMethodMap.get(id2);
        if (info == null) {
            throw new IllegalArgumentException("Unknown id: " + id2);
        }
        if (id2.equals(this.mCurMethodId)) {
            int subtypeCount = info.getSubtypeCount();
            if (subtypeCount <= 0) {
                return;
            }
            InputMethodSubtype oldSubtype = this.mCurrentSubtype;
            InputMethodSubtype newSubtype = subtypeId >= 0 && subtypeId < subtypeCount ? info.getSubtypeAt(subtypeId) : this.getCurrentInputMethodSubtypeLocked();
            if (newSubtype == null || oldSubtype == null) {
                Slog.w(TAG, "Illegal subtype state: old subtype = " + oldSubtype + ", new subtype = " + newSubtype);
                return;
            }
            if (newSubtype != oldSubtype) {
                this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, true);
                if (this.mCurMethod != null) {
                    try {
                        this.refreshImeWindowVisibilityLocked();
                        this.mCurMethod.changeInputMethodSubtype(newSubtype);
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "Failed to call changeInputMethodSubtype");
                    }
                }
            }
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, false);
            this.mCurMethodId = id2;
            if (ActivityManagerNative.isSystemReady()) {
                Intent intent = new Intent("android.intent.action.INPUT_METHOD_CHANGED");
                intent.addFlags(0x20000000);
                intent.putExtra("input_method_id", id2);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.CURRENT);
            }
            this.unbindCurrentClientLocked();
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean showSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        boolean bl;
        long ident;
        block13: {
            boolean bl2;
            block12: {
                if (!this.calledFromValidUser()) {
                    return false;
                }
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        block11: {
                            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                                try {
                                    if (this.mIWindowManager.inputMethodClientHasFocus(client)) break block11;
                                    Slog.w(TAG, "Ignoring showSoftInput of uid " + uid + ": " + client);
                                    bl2 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 2, 5, 10] lbl14 : MonitorExitStatement: MONITOREXIT : var7_6
                                }
                                catch (RemoteException e) {
                                    boolean bl3 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 10] lbl18 : MonitorExitStatement: MONITOREXIT : var7_6
                                    Object var12_11 = null;
                                    Binder.restoreCallingIdentity(ident);
                                    return bl3;
                                }
                                Object var12_10 = null;
                                break block12;
                            }
                        }
                        bl = this.showCurrentInputLocked(flags, resultReceiver);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(ident);
            return bl2;
        }
        Object var12_12 = null;
        Binder.restoreCallingIdentity(ident);
        return bl;
    }

    boolean showCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        this.mShowRequested = true;
        if ((flags & 1) == 0) {
            this.mShowExplicitlyRequested = true;
        }
        if ((flags & 2) != 0) {
            this.mShowExplicitlyRequested = true;
            this.mShowForced = true;
        }
        if (!this.mSystemReady) {
            return false;
        }
        boolean res = false;
        if (this.mCurMethod != null) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageIOO(1020, this.getImeShowFlags(), this.mCurMethod, resultReceiver));
            this.mInputShown = true;
            if (this.mHaveConnection && !this.mVisibleBound) {
                this.bindCurrentInputMethodService(this.mCurIntent, this.mVisibleConnection, 1);
                this.mVisibleBound = true;
            }
            res = true;
        } else if (this.mHaveConnection && SystemClock.uptimeMillis() >= this.mLastBindTime + 10000L) {
            EventLog.writeEvent(32000, this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 1);
            Slog.w(TAG, "Force disconnect/connect to the IME in showCurrentInputLocked()");
            this.mContext.unbindService(this);
            this.bindCurrentInputMethodService(this.mCurIntent, this, 0x40000001);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hideSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        boolean bl;
        long ident;
        block13: {
            boolean bl2;
            block12: {
                if (!this.calledFromValidUser()) {
                    return false;
                }
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        block11: {
                            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                                try {
                                    if (this.mIWindowManager.inputMethodClientHasFocus(client)) break block11;
                                    this.setImeWindowVisibilityStatusHiddenLocked();
                                    bl2 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 2, 5, 10] lbl13 : MonitorExitStatement: MONITOREXIT : var7_6
                                }
                                catch (RemoteException e) {
                                    this.setImeWindowVisibilityStatusHiddenLocked();
                                    boolean bl3 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 10] lbl18 : MonitorExitStatement: MONITOREXIT : var7_6
                                    Object var12_11 = null;
                                    Binder.restoreCallingIdentity(ident);
                                    return bl3;
                                }
                                Object var12_10 = null;
                                break block12;
                            }
                        }
                        bl = this.hideCurrentInputLocked(flags, resultReceiver);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(ident);
            return bl2;
        }
        Object var12_12 = null;
        Binder.restoreCallingIdentity(ident);
        return bl;
    }

    boolean hideCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        boolean res;
        if ((flags & 1) != 0 && (this.mShowExplicitlyRequested || this.mShowForced)) {
            return false;
        }
        if (this.mShowForced && (flags & 2) != 0) {
            return false;
        }
        if (this.mInputShown && this.mCurMethod != null) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1030, this.mCurMethod, resultReceiver));
            res = true;
        } else {
            res = false;
        }
        if (this.mHaveConnection && this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        this.mInputShown = false;
        this.mShowRequested = false;
        this.mShowExplicitlyRequested = false;
        this.mShowForced = false;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public InputBindResult windowGainedFocus(IInputMethodClient client, IBinder windowToken, int controlFlags, int softInputMode, int windowFlags, EditorInfo attribute, IInputContext inputContext) {
        boolean calledFromValidUser = this.calledFromValidUser();
        InputBindResult res = null;
        long ident = Binder.clearCallingIdentity();
        try {
            ClientState cs;
            block27: {
                InputBindResult inputBindResult;
                HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                // MONITORENTER : hashMap
                cs = this.mClients.get(client.asBinder());
                if (cs == null) {
                    throw new IllegalArgumentException("unknown client " + client.asBinder());
                }
                try {
                    if (this.mIWindowManager.inputMethodClientHasFocus(cs.client)) break block27;
                    Slog.w(TAG, "Focus gain on non-focused client " + cs.client + " (uid=" + cs.uid + " pid=" + cs.pid + ")");
                    inputBindResult = null;
                    // MONITOREXIT : hashMap
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                Object var19_19 = null;
                Binder.restoreCallingIdentity(ident);
                return inputBindResult;
            }
            if (!calledFromValidUser) {
                Slog.w(TAG, "A background user is requesting window. Hiding IME.");
                Slog.w(TAG, "If you want to interect with IME, you need android.permission.INTERACT_ACROSS_USERS_FULL");
                this.hideCurrentInputLocked(0, null);
                InputBindResult e = null;
                // MONITOREXIT : hashMap
                Object var19_20 = null;
                Binder.restoreCallingIdentity(ident);
                return e;
            }
            if (this.mCurFocusedWindow == windowToken) {
                Slog.w(TAG, "Window already focused, ignoring focus gain of: " + client + " attribute=" + attribute + ", token = " + windowToken);
                if (attribute != null) {
                    InputBindResult e = this.startInputUncheckedLocked(cs, inputContext, attribute, controlFlags);
                    // MONITOREXIT : hashMap
                    Object var19_21 = null;
                    Binder.restoreCallingIdentity(ident);
                    return e;
                }
                InputBindResult e = null;
                // MONITOREXIT : hashMap
                Object var19_22 = null;
                Binder.restoreCallingIdentity(ident);
                return e;
            }
            this.mCurFocusedWindow = windowToken;
            boolean doAutoShow = (softInputMode & 0xF0) == 16 || this.mRes.getConfiguration().isLayoutSizeAtLeast(3);
            boolean isTextEditor = (controlFlags & 2) != 0;
            boolean didStart = false;
            switch (softInputMode & 0xF) {
                case 0: {
                    if (!isTextEditor || !doAutoShow) {
                        if (!WindowManager.LayoutParams.mayUseInputMethod(windowFlags)) break;
                        this.hideCurrentInputLocked(2, null);
                        break;
                    }
                    if (!isTextEditor || !doAutoShow || (softInputMode & 0x100) == 0) break;
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, attribute, controlFlags);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if ((softInputMode & 0x100) == 0) break;
                    this.hideCurrentInputLocked(0, null);
                    break;
                }
                case 3: {
                    this.hideCurrentInputLocked(0, null);
                    break;
                }
                case 4: {
                    if ((softInputMode & 0x100) == 0) break;
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, attribute, controlFlags);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
                case 5: {
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, attribute, controlFlags);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
            }
            if (!didStart && attribute != null) {
                res = this.startInputUncheckedLocked(cs, inputContext, attribute, controlFlags);
            }
            // MONITOREXIT : hashMap
            Object var19_23 = null;
            Binder.restoreCallingIdentity(ident);
            return res;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showInputMethodPickerFromClient(IInputMethodClient client) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                Slog.w(TAG, "Ignoring showInputMethodPickerFromClient of uid " + Binder.getCallingUid() + ": " + client);
            }
            this.mHandler.sendEmptyMessage(2);
        }
    }

    @Override
    public void setInputMethod(IBinder token, String id2) {
        if (!this.calledFromValidUser()) {
            return;
        }
        this.setInputMethodWithSubtypeId(token, id2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInputMethodAndSubtype(IBinder token, String id2, InputMethodSubtype subtype) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (subtype != null) {
                this.setInputMethodWithSubtypeId(token, id2, InputMethodUtils.getSubtypeIdFromHashCode(this.mMethodMap.get(id2), subtype.hashCode()));
            } else {
                this.setInputMethod(token, id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient client, String inputMethodId) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                Slog.w(TAG, "Ignoring showInputMethodAndSubtypeEnablerFromClient of: " + client);
            }
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageO(3, inputMethodId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchToLastInputMethod(IBinder token) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            List<InputMethodInfo> enabled;
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            InputMethodInfo lastImi = lastIme != null ? this.mMethodMap.get(lastIme.first) : null;
            String targetLastImiId = null;
            int subtypeId = -1;
            if (lastIme != null && lastImi != null) {
                int currentSubtypeHash;
                boolean imiIdIsSame = lastImi.getId().equals(this.mCurMethodId);
                int lastSubtypeHash = Integer.valueOf((String)lastIme.second);
                int n = currentSubtypeHash = this.mCurrentSubtype == null ? -1 : this.mCurrentSubtype.hashCode();
                if (!imiIdIsSame || lastSubtypeHash != currentSubtypeHash) {
                    targetLastImiId = (String)lastIme.first;
                    subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                }
            }
            if (TextUtils.isEmpty(targetLastImiId) && !InputMethodUtils.canAddToLastInputMethod(this.mCurrentSubtype) && (enabled = this.mSettings.getEnabledInputMethodListLocked()) != null) {
                int N = enabled.size();
                String locale = this.mCurrentSubtype == null ? this.mRes.getConfiguration().locale.toString() : this.mCurrentSubtype.getLocale();
                for (int i = 0; i < N; ++i) {
                    InputMethodSubtype keyboardSubtype;
                    InputMethodInfo imi = enabled.get(i);
                    if (imi.getSubtypeCount() <= 0 || !InputMethodUtils.isSystemIme(imi) || (keyboardSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, InputMethodUtils.getSubtypes(imi), "keyboard", locale, true)) == null) continue;
                    targetLastImiId = imi.getId();
                    subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi, keyboardSubtype.hashCode());
                    if (keyboardSubtype.getLocale().equals(locale)) break;
                }
            }
            if (!TextUtils.isEmpty(targetLastImiId)) {
                this.setInputMethodWithSubtypeId(token, targetLastImiId, subtypeId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchToNextInputMethod(IBinder token, boolean onlyCurrentIme) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ImeSubtypeListItem nextSubtype = this.mImListManager.getNextInputMethod(onlyCurrentIme, this.mMethodMap.get(this.mCurMethodId), this.mCurrentSubtype);
            if (nextSubtype == null) {
                return false;
            }
            this.setInputMethodWithSubtypeId(token, nextSubtype.mImi.getId(), nextSubtype.mSubtypeId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldOfferSwitchingToNextInputMethod(IBinder token) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ImeSubtypeListItem nextSubtype = this.mImListManager.getNextInputMethod(false, this.mMethodMap.get(this.mCurMethodId), this.mCurrentSubtype);
            return nextSubtype != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputMethodSubtype getLastInputMethodSubtype() {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            if (lastIme == null || TextUtils.isEmpty((CharSequence)lastIme.first) || TextUtils.isEmpty((CharSequence)lastIme.second)) {
                return null;
            }
            InputMethodInfo lastImi = this.mMethodMap.get(lastIme.first);
            if (lastImi == null) {
                return null;
            }
            try {
                int lastSubtypeHash = Integer.valueOf((String)lastIme.second);
                int lastSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                if (lastSubtypeId < 0 || lastSubtypeId >= lastImi.getSubtypeCount()) {
                    return null;
                }
                return lastImi.getSubtypeAt(lastSubtypeId);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
        if (!this.calledFromValidUser()) {
            return;
        }
        if (TextUtils.isEmpty(imiId) || subtypes == null || subtypes.length == 0) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            String[] packageInfos;
            InputMethodInfo imi = this.mMethodMap.get(imiId);
            if (imi == null) {
                return;
            }
            try {
                packageInfos = this.mIPackageManager.getPackagesForUid(Binder.getCallingUid());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to get package infos");
                return;
            }
            if (packageInfos != null) {
                int packageNum = packageInfos.length;
                for (int i = 0; i < packageNum; ++i) {
                    if (!packageInfos[i].equals(imi.getPackageName())) continue;
                    this.mFileManager.addInputMethodSubtypes(imi, subtypes);
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.buildInputMethodListLocked(this.mMethodList, this.mMethodMap, false);
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        Binder.restoreCallingIdentity(ident);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity(ident);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputMethodWithSubtypeId(IBinder token, String id2, int subtypeId) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (token == null) {
                if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                    throw new SecurityException("Using null token requires permission android.permission.WRITE_SECURE_SETTINGS");
                }
            } else if (this.mCurToken != token) {
                Slog.w(TAG, "Ignoring setInputMethod of uid " + Binder.getCallingUid() + " token: " + token);
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.setInputMethodLocked(id2, subtypeId);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideMySoftInput(IBinder token, int flags) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (token == null || this.mCurToken != token) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.hideCurrentInputLocked(flags, null);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showMySoftInput(IBinder token, int flags) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (token == null || this.mCurToken != token) {
                Slog.w(TAG, "Ignoring showMySoftInput of uid " + Binder.getCallingUid() + " token: " + token);
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.showCurrentInputLocked(flags, null);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    void setEnabledSessionInMainThread(SessionState session) {
        if (this.mEnabledSession != session) {
            if (this.mEnabledSession != null) {
                try {
                    this.mEnabledSession.method.setSessionEnabled(this.mEnabledSession.session, false);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mEnabledSession = session;
            try {
                session.method.setSessionEnabled(session.session, true);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.showInputMethodMenu();
                return true;
            }
            case 2: {
                this.showInputMethodSubtypeMenu();
                return true;
            }
            case 3: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.showInputMethodAndSubtypeEnabler((String)args.arg1);
                args.recycle();
                return true;
            }
            case 4: {
                this.showConfigureInputMethods();
                return true;
            }
            case 1000: {
                try {
                    ((IInputMethod)msg.obj).unbindInput();
                    return true;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 1010: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).bindInput((InputBinding)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1020: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).showSoftInput(msg.arg1, (ResultReceiver)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1030: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).hideSoftInput(0, (ResultReceiver)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1040: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).attachToken((IBinder)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1050: {
                SomeArgs args = (SomeArgs)msg.obj;
                IInputMethod method = (IInputMethod)args.arg1;
                InputChannel channel = (InputChannel)args.arg2;
                try {
                    try {
                        method.createSession(channel, (IInputSessionCallback)args.arg3);
                    }
                    catch (RemoteException e) {
                        Object var7_27 = null;
                        if (channel != null && Binder.isProxy(method)) {
                            channel.dispose();
                        }
                    }
                    Object var7_26 = null;
                    if (channel != null && Binder.isProxy(method)) {
                        channel.dispose();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_28 = null;
                    if (channel == null) throw throwable;
                    if (!Binder.isProxy(method)) throw throwable;
                    channel.dispose();
                    throw throwable;
                }
                args.recycle();
                return true;
            }
            case 2000: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    SessionState session = (SessionState)args.arg1;
                    this.setEnabledSessionInMainThread(session);
                    session.method.startInput((IInputContext)args.arg2, (EditorInfo)args.arg3);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 2010: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    SessionState session = (SessionState)args.arg1;
                    this.setEnabledSessionInMainThread(session);
                    session.method.restartInput((IInputContext)args.arg2, (EditorInfo)args.arg3);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 3000: {
                try {
                    ((IInputMethodClient)msg.obj).onUnbindMethod(msg.arg1);
                    return true;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 3010: {
                SomeArgs args = (SomeArgs)msg.obj;
                IInputMethodClient client = (IInputMethodClient)args.arg1;
                InputBindResult res = (InputBindResult)args.arg2;
                try {
                    try {
                        client.onBindMethod(res);
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "Client died receiving input method " + args.arg2);
                        Object var9_33 = null;
                        if (res.channel != null && Binder.isProxy(client)) {
                            res.channel.dispose();
                        }
                    }
                    Object var9_32 = null;
                    if (res.channel != null && Binder.isProxy(client)) {
                        res.channel.dispose();
                    }
                }
                catch (Throwable throwable) {
                    Object var9_34 = null;
                    if (res.channel == null) throw throwable;
                    if (!Binder.isProxy(client)) throw throwable;
                    res.channel.dispose();
                    throw throwable;
                }
                args.recycle();
                return true;
            }
            case 3020: {
                try {
                    ((ClientState)msg.obj).client.setActive(msg.arg1 != 0);
                    return true;
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Got RemoteException sending setActive(false) notification to pid " + ((ClientState)msg.obj).pid + " uid " + ((ClientState)msg.obj).uid);
                }
                return true;
            }
            case 4000: {
                this.mHardKeyboardListener.handleHardKeyboardStatusChange(msg.arg1 == 1, msg.arg2 == 1);
                return true;
            }
        }
        return false;
    }

    private boolean chooseNewDefaultIMELocked() {
        InputMethodInfo imi = InputMethodUtils.getMostApplicableDefaultIME(this.mSettings.getEnabledInputMethodListLocked());
        if (imi != null) {
            this.resetSelectedInputMethodAndSubtypeLocked(imi.getId());
            return true;
        }
        return false;
    }

    void buildInputMethodListLocked(ArrayList<InputMethodInfo> list, HashMap<String, InputMethodInfo> map, boolean resetDefaultEnabledIme) {
        String defaultImiId;
        list.clear();
        map.clear();
        PackageManager pm = this.mContext.getPackageManager();
        String disabledSysImes = this.mSettings.getDisabledSystemInputMethods();
        if (disabledSysImes == null) {
            disabledSysImes = "";
        }
        List<ResolveInfo> services = pm.queryIntentServicesAsUser(new Intent("android.view.InputMethod"), 32896, this.mSettings.getCurrentUserId());
        HashMap<String, List<InputMethodSubtype>> additionalSubtypes = this.mFileManager.getAllAdditionalInputMethodSubtypes();
        for (int i = 0; i < services.size(); ++i) {
            ResolveInfo ri = services.get(i);
            ServiceInfo si = ri.serviceInfo;
            ComponentName compName = new ComponentName(si.packageName, si.name);
            if (!"android.permission.BIND_INPUT_METHOD".equals(si.permission)) {
                Slog.w(TAG, "Skipping input method " + compName + ": it does not require the permission " + "android.permission.BIND_INPUT_METHOD");
                continue;
            }
            try {
                InputMethodInfo p = new InputMethodInfo(this.mContext, ri, additionalSubtypes);
                list.add(p);
                String id2 = p.getId();
                map.put(id2, p);
                continue;
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Unable to load input method " + compName, e);
                continue;
            }
            catch (IOException e) {
                Slog.w(TAG, "Unable to load input method " + compName, e);
            }
        }
        if (resetDefaultEnabledIme) {
            ArrayList<InputMethodInfo> defaultEnabledIme = InputMethodUtils.getDefaultEnabledImes(this.mContext, this.mSystemReady, list);
            for (int i = 0; i < defaultEnabledIme.size(); ++i) {
                InputMethodInfo imi = defaultEnabledIme.get(i);
                this.setInputMethodEnabledLocked(imi.getId(), true);
            }
        }
        if (!TextUtils.isEmpty(defaultImiId = this.mSettings.getSelectedInputMethod())) {
            if (!map.containsKey(defaultImiId)) {
                Slog.w(TAG, "Default IME is uninstalled. Choose new default IME.");
                if (this.chooseNewDefaultIMELocked()) {
                    this.updateFromSettingsLocked(true);
                }
            } else {
                this.setInputMethodEnabledLocked(defaultImiId, true);
            }
        }
    }

    private void showInputMethodMenu() {
        this.showInputMethodMenuInternal(false);
    }

    private void showInputMethodSubtypeMenu() {
        this.showInputMethodMenuInternal(true);
    }

    private void showInputMethodAndSubtypeEnabler(String inputMethodId) {
        Intent intent = new Intent("android.settings.INPUT_METHOD_SUBTYPE_SETTINGS");
        intent.setFlags(337641472);
        if (!TextUtils.isEmpty(inputMethodId)) {
            intent.putExtra("input_method_id", inputMethodId);
        }
        this.mContext.startActivityAsUser(intent, null, UserHandle.CURRENT);
    }

    private void showConfigureInputMethods() {
        Intent intent = new Intent("android.settings.INPUT_METHOD_SETTINGS");
        intent.setFlags(337641472);
        this.mContext.startActivityAsUser(intent, null, UserHandle.CURRENT);
    }

    private boolean isScreenLocked() {
        return this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked() && this.mKeyguardManager.isKeyguardSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputMethodMenuInternal(boolean showSubtypes) {
        Context context = this.mContext;
        boolean isScreenLocked = this.isScreenLocked();
        String lastInputMethodId = this.mSettings.getSelectedInputMethod();
        int lastInputMethodSubtypeId = this.mSettings.getSelectedInputMethodSubtypeId(lastInputMethodId);
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodSubtype currentSubtype;
            HashMap<InputMethodInfo, List<InputMethodSubtype>> immis = this.getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked();
            if (immis == null || immis.size() == 0) {
                return;
            }
            this.hideInputMethodMenuLocked();
            List<ImeSubtypeListItem> imList = this.mImListManager.getSortedInputMethodAndSubtypeList(showSubtypes, this.mInputShown, isScreenLocked);
            if (lastInputMethodSubtypeId == -1 && (currentSubtype = this.getCurrentInputMethodSubtypeLocked()) != null) {
                InputMethodInfo currentImi = this.mMethodMap.get(this.mCurMethodId);
                lastInputMethodSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(currentImi, currentSubtype.hashCode());
            }
            int N = imList.size();
            this.mIms = new InputMethodInfo[N];
            this.mSubtypeIds = new int[N];
            int checkedItem = 0;
            for (int i = 0; i < N; ++i) {
                int subtypeId;
                ImeSubtypeListItem item = imList.get(i);
                this.mIms[i] = item.mImi;
                this.mSubtypeIds[i] = item.mSubtypeId;
                if (!this.mIms[i].getId().equals(lastInputMethodId) || (subtypeId = this.mSubtypeIds[i]) != -1 && (lastInputMethodSubtypeId != -1 || subtypeId != 0) && subtypeId != lastInputMethodSubtypeId) continue;
                checkedItem = i;
            }
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.DialogPreference, 16842845, 0);
            this.mDialogBuilder = new AlertDialog.Builder(context).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    InputMethodManagerService.this.hideInputMethodMenu();
                }
            }).setIcon(a.getDrawable(0));
            a.recycle();
            LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            View tv = inflater.inflate(17367118, null);
            this.mDialogBuilder.setCustomTitle(tv);
            this.mSwitchingDialogTitleView = tv;
            this.mSwitchingDialogTitleView.findViewById(16908982).setVisibility(this.mWindowManagerService.isHardKeyboardAvailable() ? 0 : 8);
            Switch hardKeySwitch = (Switch)this.mSwitchingDialogTitleView.findViewById(16908983);
            hardKeySwitch.setChecked(this.mWindowManagerService.isHardKeyboardEnabled());
            hardKeySwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    InputMethodManagerService.this.mWindowManagerService.setHardKeyboardEnabled(isChecked);
                    InputMethodManagerService.this.hideInputMethodMenu();
                }
            });
            final ImeSubtypeListAdapter adapter = new ImeSubtypeListAdapter(context, 17367200, imList, checkedItem);
            this.mDialogBuilder.setSingleChoiceItems(adapter, checkedItem, new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick(DialogInterface dialog, int which) {
                    HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
                    synchronized (hashMap) {
                        if (InputMethodManagerService.this.mIms == null || InputMethodManagerService.this.mIms.length <= which || InputMethodManagerService.this.mSubtypeIds == null || InputMethodManagerService.this.mSubtypeIds.length <= which) {
                            return;
                        }
                        InputMethodInfo im = InputMethodManagerService.this.mIms[which];
                        int subtypeId = InputMethodManagerService.this.mSubtypeIds[which];
                        adapter.mCheckedItem = which;
                        adapter.notifyDataSetChanged();
                        InputMethodManagerService.this.hideInputMethodMenu();
                        if (im != null) {
                            if (subtypeId < 0 || subtypeId >= im.getSubtypeCount()) {
                                subtypeId = -1;
                            }
                            InputMethodManagerService.this.setInputMethodLocked(im.getId(), subtypeId);
                        }
                    }
                }
            });
            if (showSubtypes && !isScreenLocked) {
                this.mDialogBuilder.setPositiveButton(17040509, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        InputMethodManagerService.this.showConfigureInputMethods();
                    }
                });
            }
            this.mSwitchingDialog = this.mDialogBuilder.create();
            this.mSwitchingDialog.setCanceledOnTouchOutside(true);
            this.mSwitchingDialog.getWindow().setType(2012);
            this.mSwitchingDialog.getWindow().getAttributes().privateFlags |= 0x10;
            this.mSwitchingDialog.getWindow().getAttributes().setTitle("Select input method");
            this.mSwitchingDialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideInputMethodMenu() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.hideInputMethodMenuLocked();
        }
    }

    void hideInputMethodMenuLocked() {
        if (this.mSwitchingDialog != null) {
            this.mSwitchingDialog.dismiss();
            this.mSwitchingDialog = null;
        }
        this.mDialogBuilder = null;
        this.mIms = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setInputMethodEnabled(String id2, boolean enabled) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            boolean bl;
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.setInputMethodEnabledLocked(id2, enabled);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
    }

    boolean setInputMethodEnabledLocked(String id2, boolean enabled) {
        InputMethodInfo imm = this.mMethodMap.get(id2);
        if (imm == null) {
            throw new IllegalArgumentException("Unknown id: " + this.mCurMethodId);
        }
        List<Pair<String, ArrayList<String>>> enabledInputMethodsList = this.mSettings.getEnabledInputMethodsAndSubtypeListLocked();
        if (enabled) {
            for (Pair<String, ArrayList<String>> pair : enabledInputMethodsList) {
                if (!((String)pair.first).equals(id2)) continue;
                return true;
            }
            this.mSettings.appendAndPutEnabledInputMethodLocked(id2, false);
            return false;
        }
        StringBuilder builder = new StringBuilder();
        if (this.mSettings.buildAndPutEnabledInputMethodsStrRemovingIdLocked(builder, enabledInputMethodsList, id2)) {
            String selId = this.mSettings.getSelectedInputMethod();
            if (id2.equals(selId) && !this.chooseNewDefaultIMELocked()) {
                Slog.i(TAG, "Can't find new IME, unsetting the current input method.");
                this.resetSelectedInputMethodAndSubtypeLocked("");
            }
            return true;
        }
        return false;
    }

    private void setSelectedInputMethodAndSubtypeLocked(InputMethodInfo imi, int subtypeId, boolean setSubtypeOnly) {
        this.mSettings.saveCurrentInputMethodAndSubtypeToHistory(this.mCurMethodId, this.mCurrentSubtype);
        if (imi == null || subtypeId < 0) {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = null;
        } else if (subtypeId < imi.getSubtypeCount()) {
            InputMethodSubtype subtype = imi.getSubtypeAt(subtypeId);
            this.mSettings.putSelectedSubtype(subtype.hashCode());
            this.mCurrentSubtype = subtype;
        } else {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = this.getCurrentInputMethodSubtypeLocked();
        }
        if (this.mSystemReady && !setSubtypeOnly) {
            this.mSettings.putSelectedInputMethod(imi != null ? imi.getId() : "");
        }
    }

    private void resetSelectedInputMethodAndSubtypeLocked(String newDefaultIme) {
        String subtypeHashCode;
        InputMethodInfo imi = this.mMethodMap.get(newDefaultIme);
        int lastSubtypeId = -1;
        if (imi != null && !TextUtils.isEmpty(newDefaultIme) && (subtypeHashCode = this.mSettings.getLastSubtypeForInputMethodLocked(newDefaultIme)) != null) {
            try {
                lastSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi, Integer.valueOf(subtypeHashCode));
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "HashCode for subtype looks broken: " + subtypeHashCode, e);
            }
        }
        this.setSelectedInputMethodAndSubtypeLocked(imi, lastSubtypeId, false);
    }

    private Pair<InputMethodInfo, InputMethodSubtype> findLastResortApplicableShortcutInputMethodAndSubtypeLocked(String mode) {
        List<InputMethodInfo> imis = this.mSettings.getEnabledInputMethodListLocked();
        InputMethodInfo mostApplicableIMI = null;
        InputMethodSubtype mostApplicableSubtype = null;
        boolean foundInSystemIME = false;
        for (InputMethodInfo imi : imis) {
            ArrayList<InputMethodSubtype> overridingImplicitlyEnabledSubtypes;
            ArrayList<InputMethodSubtype> subtypesForSearch;
            String imiId = imi.getId();
            if (foundInSystemIME && !imiId.equals(this.mCurMethodId)) continue;
            InputMethodSubtype subtype = null;
            List<InputMethodSubtype> enabledSubtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
            if (this.mCurrentSubtype != null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, enabledSubtypes, mode, this.mCurrentSubtype.getLocale(), false);
            }
            if (subtype == null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, enabledSubtypes, mode, null, true);
            }
            ArrayList<InputMethodSubtype> arrayList = subtypesForSearch = (overridingImplicitlyEnabledSubtypes = InputMethodUtils.getOverridingImplicitlyEnabledSubtypes(imi, mode)).isEmpty() ? InputMethodUtils.getSubtypes(imi) : overridingImplicitlyEnabledSubtypes;
            if (subtype == null && this.mCurrentSubtype != null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, subtypesForSearch, mode, this.mCurrentSubtype.getLocale(), false);
            }
            if (subtype == null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, subtypesForSearch, mode, null, true);
            }
            if (subtype == null) continue;
            if (imiId.equals(this.mCurMethodId)) {
                mostApplicableIMI = imi;
                mostApplicableSubtype = subtype;
                break;
            }
            if (foundInSystemIME) continue;
            mostApplicableIMI = imi;
            mostApplicableSubtype = subtype;
            if ((imi.getServiceInfo().applicationInfo.flags & 1) == 0) continue;
            foundInSystemIME = true;
        }
        if (mostApplicableIMI != null) {
            return new Pair<Object, Object>(mostApplicableIMI, mostApplicableSubtype);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputMethodSubtype getCurrentInputMethodSubtype() {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return this.getCurrentInputMethodSubtypeLocked();
        }
    }

    private InputMethodSubtype getCurrentInputMethodSubtypeLocked() {
        if (this.mCurMethodId == null) {
            return null;
        }
        boolean subtypeIsSelected = this.mSettings.isSubtypeSelected();
        InputMethodInfo imi = this.mMethodMap.get(this.mCurMethodId);
        if (imi == null || imi.getSubtypeCount() == 0) {
            return null;
        }
        if (!subtypeIsSelected || this.mCurrentSubtype == null || !InputMethodUtils.isValidSubtypeId(imi, this.mCurrentSubtype.hashCode())) {
            int subtypeId = this.mSettings.getSelectedInputMethodSubtypeId(this.mCurMethodId);
            if (subtypeId == -1) {
                List<InputMethodSubtype> explicitlyOrImplicitlyEnabledSubtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
                if (explicitlyOrImplicitlyEnabledSubtypes.size() == 1) {
                    this.mCurrentSubtype = explicitlyOrImplicitlyEnabledSubtypes.get(0);
                } else if (explicitlyOrImplicitlyEnabledSubtypes.size() > 1) {
                    this.mCurrentSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, "keyboard", null, true);
                    if (this.mCurrentSubtype == null) {
                        this.mCurrentSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, null, null, true);
                    }
                }
            } else {
                this.mCurrentSubtype = InputMethodUtils.getSubtypes(imi).get(subtypeId);
            }
        }
        return this.mCurrentSubtype;
    }

    private void addShortcutInputMethodAndSubtypes(InputMethodInfo imi, InputMethodSubtype subtype) {
        if (this.mShortcutInputMethodsAndSubtypes.containsKey(imi)) {
            this.mShortcutInputMethodsAndSubtypes.get(imi).add(subtype);
        } else {
            ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
            subtypes.add(subtype);
            this.mShortcutInputMethodsAndSubtypes.put(imi, subtypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getShortcutInputMethodsAndSubtypes() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (this.mShortcutInputMethodsAndSubtypes.size() == 0) {
                Pair<InputMethodInfo, InputMethodSubtype> info = this.findLastResortApplicableShortcutInputMethodAndSubtypeLocked("voice");
                if (info != null) {
                    ret.add(info.first);
                    ret.add(info.second);
                }
                return ret;
            }
            for (InputMethodInfo imi : this.mShortcutInputMethodsAndSubtypes.keySet()) {
                ret.add(imi);
                for (InputMethodSubtype subtype : this.mShortcutInputMethodsAndSubtypes.get(imi)) {
                    ret.add(subtype);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCurrentInputMethodSubtype(InputMethodSubtype subtype) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo imi;
            int subtypeId;
            if (subtype != null && this.mCurMethodId != null && (subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi = this.mMethodMap.get(this.mCurMethodId), subtype.hashCode())) != -1) {
                this.setInputMethodLocked(this.mCurMethodId, subtypeId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IInputMethod method;
        ClientState client;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            p.println("Current Input Method Manager state:");
            int N = this.mMethodList.size();
            p.println("  Input Methods:");
            for (int i = 0; i < N; ++i) {
                InputMethodInfo info = this.mMethodList.get(i);
                p.println("  InputMethod #" + i + ":");
                info.dump(p, "    ");
            }
            p.println("  Clients:");
            for (ClientState ci : this.mClients.values()) {
                p.println("  Client " + ci + ":");
                p.println("    client=" + ci.client);
                p.println("    inputContext=" + ci.inputContext);
                p.println("    sessionRequested=" + ci.sessionRequested);
                p.println("    curSession=" + ci.curSession);
            }
            p.println("  mCurMethodId=" + this.mCurMethodId);
            client = this.mCurClient;
            p.println("  mCurClient=" + client + " mCurSeq=" + this.mCurSeq);
            p.println("  mCurFocusedWindow=" + this.mCurFocusedWindow);
            p.println("  mCurId=" + this.mCurId + " mHaveConnect=" + this.mHaveConnection + " mBoundToMethod=" + this.mBoundToMethod);
            p.println("  mCurToken=" + this.mCurToken);
            p.println("  mCurIntent=" + this.mCurIntent);
            method = this.mCurMethod;
            p.println("  mCurMethod=" + this.mCurMethod);
            p.println("  mEnabledSession=" + this.mEnabledSession);
            p.println("  mShowRequested=" + this.mShowRequested + " mShowExplicitlyRequested=" + this.mShowExplicitlyRequested + " mShowForced=" + this.mShowForced + " mInputShown=" + this.mInputShown);
            p.println("  mSystemReady=" + this.mSystemReady + " mScreenOn=" + this.mScreenOn);
        }
        p.println(" ");
        if (client != null) {
            pw.flush();
            try {
                client.client.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                p.println("Input method client dead: " + e);
            }
        } else {
            p.println("No input method client.");
        }
        p.println(" ");
        if (method != null) {
            pw.flush();
            try {
                method.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                p.println("Input method service dead: " + e);
            }
        } else {
            p.println("No input method service.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputMethodFileManager {
        private static final String SYSTEM_PATH = "system";
        private static final String INPUT_METHOD_PATH = "inputmethod";
        private static final String ADDITIONAL_SUBTYPES_FILE_NAME = "subtypes.xml";
        private static final String NODE_SUBTYPES = "subtypes";
        private static final String NODE_SUBTYPE = "subtype";
        private static final String NODE_IMI = "imi";
        private static final String ATTR_ID = "id";
        private static final String ATTR_LABEL = "label";
        private static final String ATTR_ICON = "icon";
        private static final String ATTR_IME_SUBTYPE_LOCALE = "imeSubtypeLocale";
        private static final String ATTR_IME_SUBTYPE_MODE = "imeSubtypeMode";
        private static final String ATTR_IME_SUBTYPE_EXTRA_VALUE = "imeSubtypeExtraValue";
        private static final String ATTR_IS_AUXILIARY = "isAuxiliary";
        private final AtomicFile mAdditionalInputMethodSubtypeFile;
        private final HashMap<String, InputMethodInfo> mMethodMap;
        private final HashMap<String, List<InputMethodSubtype>> mAdditionalSubtypesMap = new HashMap();

        public InputMethodFileManager(HashMap<String, InputMethodInfo> methodMap, int userId) {
            if (methodMap == null) {
                throw new NullPointerException("methodMap is null");
            }
            this.mMethodMap = methodMap;
            File systemDir = userId == 0 ? new File(Environment.getDataDirectory(), SYSTEM_PATH) : Environment.getUserSystemDirectory(userId);
            File inputMethodDir = new File(systemDir, INPUT_METHOD_PATH);
            if (!inputMethodDir.mkdirs()) {
                Slog.w(InputMethodManagerService.TAG, "Couldn't create dir.: " + inputMethodDir.getAbsolutePath());
            }
            File subtypeFile = new File(inputMethodDir, ADDITIONAL_SUBTYPES_FILE_NAME);
            this.mAdditionalInputMethodSubtypeFile = new AtomicFile(subtypeFile);
            if (!subtypeFile.exists()) {
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile, methodMap);
            } else {
                InputMethodFileManager.readAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteAllInputMethodSubtypes(String imiId) {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                this.mAdditionalSubtypesMap.remove(imiId);
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile, this.mMethodMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInputMethodSubtypes(InputMethodInfo imi, InputMethodSubtype[] additionalSubtypes) {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
                for (InputMethodSubtype subtype : additionalSubtypes) {
                    if (!subtypes.contains(subtype)) {
                        subtypes.add(subtype);
                        continue;
                    }
                    Slog.w(InputMethodManagerService.TAG, "Duplicated subtype definition found: " + subtype.getLocale() + ", " + subtype.getMode());
                }
                this.mAdditionalSubtypesMap.put(imi.getId(), subtypes);
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile, this.mMethodMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashMap<String, List<InputMethodSubtype>> getAllAdditionalInputMethodSubtypes() {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                return this.mAdditionalSubtypesMap;
            }
        }

        private static void writeAdditionalInputMethodSubtypes(HashMap<String, List<InputMethodSubtype>> allSubtypes, AtomicFile subtypesFile, HashMap<String, InputMethodInfo> methodMap) {
            block5: {
                boolean isSetMethodMap = methodMap != null && methodMap.size() > 0;
                FileOutputStream fos = null;
                try {
                    fos = subtypesFile.startWrite();
                    FastXmlSerializer out = new FastXmlSerializer();
                    out.setOutput(fos, "utf-8");
                    out.startDocument(null, true);
                    out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    out.startTag(null, NODE_SUBTYPES);
                    for (String imiId : allSubtypes.keySet()) {
                        if (isSetMethodMap && !methodMap.containsKey(imiId)) {
                            Slog.w(InputMethodManagerService.TAG, "IME uninstalled or not valid.: " + imiId);
                            continue;
                        }
                        out.startTag(null, NODE_IMI);
                        out.attribute(null, ATTR_ID, imiId);
                        List<InputMethodSubtype> subtypesList = allSubtypes.get(imiId);
                        int N = subtypesList.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype subtype = subtypesList.get(i);
                            out.startTag(null, NODE_SUBTYPE);
                            out.attribute(null, ATTR_ICON, String.valueOf(subtype.getIconResId()));
                            out.attribute(null, ATTR_LABEL, String.valueOf(subtype.getNameResId()));
                            out.attribute(null, ATTR_IME_SUBTYPE_LOCALE, subtype.getLocale());
                            out.attribute(null, ATTR_IME_SUBTYPE_MODE, subtype.getMode());
                            out.attribute(null, ATTR_IME_SUBTYPE_EXTRA_VALUE, subtype.getExtraValue());
                            out.attribute(null, ATTR_IS_AUXILIARY, String.valueOf(subtype.isAuxiliary() ? 1 : 0));
                            out.endTag(null, NODE_SUBTYPE);
                        }
                        out.endTag(null, NODE_IMI);
                    }
                    out.endTag(null, NODE_SUBTYPES);
                    out.endDocument();
                    subtypesFile.finishWrite(fos);
                }
                catch (IOException e) {
                    Slog.w(InputMethodManagerService.TAG, "Error writing subtypes", e);
                    if (fos == null) break block5;
                    subtypesFile.failWrite(fos);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void readAdditionalInputMethodSubtypes(HashMap<String, List<InputMethodSubtype>> allSubtypes, AtomicFile subtypesFile) {
            if (allSubtypes == null || subtypesFile == null) {
                return;
            }
            allSubtypes.clear();
            FileInputStream fis = null;
            fis = subtypesFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            int type = parser.getEventType();
            while ((type = parser.next()) != 2 && type != 1) {
            }
            String firstNodeName = parser.getName();
            if (!NODE_SUBTYPES.equals(firstNodeName)) {
                throw new XmlPullParserException("Xml doesn't start with subtypes");
            }
            int depth = parser.getDepth();
            String currentImiId = null;
            ArrayList<InputMethodSubtype> tempSubtypesArray = null;
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                String nodeName = parser.getName();
                if (NODE_IMI.equals(nodeName)) {
                    currentImiId = parser.getAttributeValue(null, ATTR_ID);
                    if (TextUtils.isEmpty(currentImiId)) {
                        Slog.w(InputMethodManagerService.TAG, "Invalid imi id found in subtypes.xml");
                        continue;
                    }
                    tempSubtypesArray = new ArrayList<InputMethodSubtype>();
                    allSubtypes.put(currentImiId, tempSubtypesArray);
                    continue;
                }
                if (!NODE_SUBTYPE.equals(nodeName)) continue;
                if (TextUtils.isEmpty(currentImiId) || tempSubtypesArray == null) {
                    Slog.w(InputMethodManagerService.TAG, "IME uninstalled or not valid.: " + currentImiId);
                    continue;
                }
                int icon = Integer.valueOf(parser.getAttributeValue(null, ATTR_ICON));
                int label = Integer.valueOf(parser.getAttributeValue(null, ATTR_LABEL));
                String imeSubtypeLocale = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_LOCALE);
                String imeSubtypeMode = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_MODE);
                String imeSubtypeExtraValue = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_EXTRA_VALUE);
                boolean isAuxiliary = "1".equals(String.valueOf(parser.getAttributeValue(null, ATTR_IS_AUXILIARY)));
                InputMethodSubtype subtype = new InputMethodSubtype(label, icon, imeSubtypeLocale, imeSubtypeMode, imeSubtypeExtraValue, isAuxiliary);
                tempSubtypesArray.add(subtype);
            }
            Object var18_20 = null;
            if (fis == null) return;
            try {
                fis.close();
                return;
            }
            catch (IOException e1) {
                Slog.w(InputMethodManagerService.TAG, "Failed to close.");
            }
            return;
            {
                catch (XmlPullParserException e) {
                    Slog.w(InputMethodManagerService.TAG, "Error reading subtypes: " + e);
                    Object var18_21 = null;
                    if (fis == null) return;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException e1) {
                        Slog.w(InputMethodManagerService.TAG, "Failed to close.");
                    }
                    return;
                }
                catch (IOException e) {
                    Slog.w(InputMethodManagerService.TAG, "Error reading subtypes: " + e);
                    Object var18_22 = null;
                    if (fis == null) return;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException e1) {
                        Slog.w(InputMethodManagerService.TAG, "Failed to close.");
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    Slog.w(InputMethodManagerService.TAG, "Error reading subtypes: " + e);
                    Object var18_23 = null;
                    if (fis == null) return;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException e1) {
                        Slog.w(InputMethodManagerService.TAG, "Failed to close.");
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var18_24 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException e1) {
                    Slog.w(InputMethodManagerService.TAG, "Failed to close.");
                }
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputMethodAndSubtypeListManager {
        private final Context mContext;
        private final PackageManager mPm;
        private final InputMethodManagerService mImms;
        private final String mSystemLocaleStr;
        private final TreeMap<InputMethodInfo, List<InputMethodSubtype>> mSortedImmis = new TreeMap(new Comparator<InputMethodInfo>(){

            @Override
            public int compare(InputMethodInfo imi1, InputMethodInfo imi2) {
                if (imi2 == null) {
                    return 0;
                }
                if (imi1 == null) {
                    return 1;
                }
                if (InputMethodAndSubtypeListManager.this.mPm == null) {
                    return imi1.getId().compareTo(imi2.getId());
                }
                String imiId1 = imi1.loadLabel(InputMethodAndSubtypeListManager.this.mPm) + "/" + imi1.getId();
                String imiId2 = imi2.loadLabel(InputMethodAndSubtypeListManager.this.mPm) + "/" + imi2.getId();
                return imiId1.toString().compareTo(imiId2.toString());
            }
        });

        public InputMethodAndSubtypeListManager(Context context, InputMethodManagerService imms) {
            this.mContext = context;
            this.mPm = context.getPackageManager();
            this.mImms = imms;
            Locale locale = context.getResources().getConfiguration().locale;
            this.mSystemLocaleStr = locale != null ? locale.toString() : "";
        }

        public ImeSubtypeListItem getNextInputMethod(boolean onlyCurrentIme, InputMethodInfo imi, InputMethodSubtype subtype) {
            if (imi == null) {
                return null;
            }
            List<ImeSubtypeListItem> imList = this.getSortedInputMethodAndSubtypeList();
            if (imList.size() <= 1) {
                return null;
            }
            int N = imList.size();
            int currentSubtypeId = subtype != null ? InputMethodUtils.getSubtypeIdFromHashCode(imi, subtype.hashCode()) : -1;
            for (int i = 0; i < N; ++i) {
                ImeSubtypeListItem isli = imList.get(i);
                if (!isli.mImi.equals(imi) || isli.mSubtypeId != currentSubtypeId) continue;
                if (!onlyCurrentIme) {
                    return imList.get((i + 1) % N);
                }
                for (int j = 0; j < N - 1; ++j) {
                    ImeSubtypeListItem candidate = imList.get((i + j + 1) % N);
                    if (!candidate.mImi.equals(imi)) continue;
                    return candidate;
                }
                return null;
            }
            return null;
        }

        public List<ImeSubtypeListItem> getSortedInputMethodAndSubtypeList() {
            return this.getSortedInputMethodAndSubtypeList(true, false, false);
        }

        public List<ImeSubtypeListItem> getSortedInputMethodAndSubtypeList(boolean showSubtypes, boolean inputShown, boolean isScreenLocked) {
            ArrayList<ImeSubtypeListItem> imList = new ArrayList<ImeSubtypeListItem>();
            HashMap immis = this.mImms.getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked();
            if (immis == null || immis.size() == 0) {
                return Collections.emptyList();
            }
            this.mSortedImmis.clear();
            this.mSortedImmis.putAll(immis);
            for (InputMethodInfo imi : this.mSortedImmis.keySet()) {
                if (imi == null) continue;
                List explicitlyOrImplicitlyEnabledSubtypeList = (List)immis.get(imi);
                HashSet<String> enabledSubtypeSet = new HashSet<String>();
                for (InputMethodSubtype subtype : explicitlyOrImplicitlyEnabledSubtypeList) {
                    enabledSubtypeSet.add(String.valueOf(subtype.hashCode()));
                }
                CharSequence imeLabel = imi.loadLabel(this.mPm);
                if (showSubtypes && enabledSubtypeSet.size() > 0) {
                    int subtypeCount = imi.getSubtypeCount();
                    for (int j = 0; j < subtypeCount; ++j) {
                        InputMethodSubtype subtype = imi.getSubtypeAt(j);
                        String subtypeHashCode = String.valueOf(subtype.hashCode());
                        if (!enabledSubtypeSet.contains(subtypeHashCode) || (!inputShown || isScreenLocked) && subtype.isAuxiliary()) continue;
                        CharSequence subtypeLabel = subtype.overridesImplicitlyEnabledSubtype() ? null : subtype.getDisplayName(this.mContext, imi.getPackageName(), imi.getServiceInfo().applicationInfo);
                        imList.add(new ImeSubtypeListItem(imeLabel, subtypeLabel, imi, j, subtype.getLocale(), this.mSystemLocaleStr));
                        enabledSubtypeSet.remove(subtypeHashCode);
                    }
                    continue;
                }
                imList.add(new ImeSubtypeListItem(imeLabel, null, imi, -1, null, this.mSystemLocaleStr));
            }
            Collections.sort(imList);
            return imList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImeSubtypeListAdapter
    extends ArrayAdapter<ImeSubtypeListItem> {
        private final LayoutInflater mInflater;
        private final int mTextViewResourceId;
        private final List<ImeSubtypeListItem> mItemsList;
        public int mCheckedItem;

        public ImeSubtypeListAdapter(Context context, int textViewResourceId, List<ImeSubtypeListItem> itemsList, int checkedItem) {
            super(context, textViewResourceId, itemsList);
            this.mTextViewResourceId = textViewResourceId;
            this.mItemsList = itemsList;
            this.mCheckedItem = checkedItem;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            View view2 = view = convertView != null ? convertView : this.mInflater.inflate(this.mTextViewResourceId, null);
            if (position < 0 || position >= this.mItemsList.size()) {
                return view;
            }
            ImeSubtypeListItem item = this.mItemsList.get(position);
            CharSequence imeName = item.mImeName;
            CharSequence subtypeName = item.mSubtypeName;
            TextView firstTextView = (TextView)view.findViewById(16908308);
            TextView secondTextView = (TextView)view.findViewById(16908309);
            if (TextUtils.isEmpty(subtypeName)) {
                firstTextView.setText(imeName);
                secondTextView.setVisibility(8);
            } else {
                firstTextView.setText(subtypeName);
                secondTextView.setText(imeName);
                secondTextView.setVisibility(0);
            }
            RadioButton radioButton = (RadioButton)view.findViewById(16908994);
            radioButton.setChecked(position == this.mCheckedItem);
            return view;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImeSubtypeListItem
    implements Comparable<ImeSubtypeListItem> {
        public final CharSequence mImeName;
        public final CharSequence mSubtypeName;
        public final InputMethodInfo mImi;
        public final int mSubtypeId;
        private final boolean mIsSystemLocale;
        private final boolean mIsSystemLanguage;

        public ImeSubtypeListItem(CharSequence imeName, CharSequence subtypeName, InputMethodInfo imi, int subtypeId, String subtypeLocale, String systemLocale) {
            this.mImeName = imeName;
            this.mSubtypeName = subtypeName;
            this.mImi = imi;
            this.mSubtypeId = subtypeId;
            if (TextUtils.isEmpty(subtypeLocale)) {
                this.mIsSystemLocale = false;
                this.mIsSystemLanguage = false;
            } else {
                this.mIsSystemLocale = subtypeLocale.equals(systemLocale);
                this.mIsSystemLanguage = this.mIsSystemLocale || subtypeLocale.startsWith(systemLocale.substring(0, 2));
            }
        }

        @Override
        public int compareTo(ImeSubtypeListItem other) {
            if (TextUtils.isEmpty(this.mImeName)) {
                return 1;
            }
            if (TextUtils.isEmpty(other.mImeName)) {
                return -1;
            }
            if (!TextUtils.equals(this.mImeName, other.mImeName)) {
                return ((Object)this.mImeName).toString().compareTo(((Object)other.mImeName).toString());
            }
            if (TextUtils.equals(this.mSubtypeName, other.mSubtypeName)) {
                return 0;
            }
            if (this.mIsSystemLocale) {
                return -1;
            }
            if (other.mIsSystemLocale) {
                return 1;
            }
            if (this.mIsSystemLanguage) {
                return -1;
            }
            if (other.mIsSystemLanguage) {
                return 1;
            }
            if (TextUtils.isEmpty(this.mSubtypeName)) {
                return 1;
            }
            if (TextUtils.isEmpty(other.mSubtypeName)) {
                return -1;
            }
            return ((Object)this.mSubtypeName).toString().compareTo(((Object)other.mSubtypeName).toString());
        }
    }

    private class HardKeyboardListener
    implements WindowManagerService.OnHardKeyboardStatusChangeListener {
        private HardKeyboardListener() {
        }

        public void onHardKeyboardStatusChange(boolean available, boolean enabled) {
            InputMethodManagerService.this.mHandler.sendMessage(InputMethodManagerService.this.mHandler.obtainMessage(4000, available ? 1 : 0, enabled ? 1 : 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleHardKeyboardStatusChange(boolean available, boolean enabled) {
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                if (InputMethodManagerService.this.mSwitchingDialog != null && InputMethodManagerService.this.mSwitchingDialogTitleView != null && InputMethodManagerService.this.mSwitchingDialog.isShowing()) {
                    InputMethodManagerService.this.mSwitchingDialogTitleView.findViewById(16908982).setVisibility(available ? 0 : 8);
                }
            }
        }
    }

    private static final class MethodCallback
    extends IInputSessionCallback.Stub {
        private final InputMethodManagerService mParentIMMS;
        private final IInputMethod mMethod;
        private final InputChannel mChannel;

        MethodCallback(InputMethodManagerService imms, IInputMethod method, InputChannel channel) {
            this.mParentIMMS = imms;
            this.mMethod = method;
            this.mChannel = channel;
        }

        public void sessionCreated(IInputMethodSession session) {
            this.mParentIMMS.onSessionCreated(this.mMethod, session, this.mChannel);
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        private boolean isChangingPackagesOfCurrentUser() {
            int userId = this.getChangingUserId();
            boolean retval = userId == InputMethodManagerService.this.mSettings.getCurrentUserId();
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (!this.isChangingPackagesOfCurrentUser()) {
                return false;
            }
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                String curInputMethodId = InputMethodManagerService.this.mSettings.getSelectedInputMethod();
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        if (!imi.getId().equals(curInputMethodId)) continue;
                        for (String pkg : packages) {
                            if (!imi.getPackageName().equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                            InputMethodManagerService.this.chooseNewDefaultIMELocked();
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSomePackagesChanged() {
            if (!this.isChangingPackagesOfCurrentUser()) {
                return;
            }
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                int change;
                InputMethodInfo curIm = null;
                String curInputMethodId = InputMethodManagerService.this.mSettings.getSelectedInputMethod();
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        String imiId = imi.getId();
                        if (imiId.equals(curInputMethodId)) {
                            curIm = imi;
                        }
                        int change2 = this.isPackageDisappearing(imi.getPackageName());
                        if (this.isPackageModified(imi.getPackageName())) {
                            InputMethodManagerService.this.mFileManager.deleteAllInputMethodSubtypes(imiId);
                        }
                        if (change2 != 2 && change2 != 3) continue;
                        Slog.i(InputMethodManagerService.TAG, "Input method uninstalled, disabling: " + imi.getComponent());
                        InputMethodManagerService.this.setInputMethodEnabledLocked(imi.getId(), false);
                    }
                }
                InputMethodManagerService.this.buildInputMethodListLocked(InputMethodManagerService.this.mMethodList, InputMethodManagerService.this.mMethodMap, false);
                boolean changed = false;
                if (curIm != null && ((change = this.isPackageDisappearing(curIm.getPackageName())) == 2 || change == 3)) {
                    ServiceInfo si = null;
                    try {
                        si = InputMethodManagerService.this.mIPackageManager.getServiceInfo(curIm.getComponent(), 0, InputMethodManagerService.this.mSettings.getCurrentUserId());
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                    if (si == null) {
                        Slog.i(InputMethodManagerService.TAG, "Current input method removed: " + curInputMethodId);
                        InputMethodManagerService.this.setImeWindowVisibilityStatusHiddenLocked();
                        if (!InputMethodManagerService.this.chooseNewDefaultIMELocked()) {
                            changed = true;
                            curIm = null;
                            Slog.i(InputMethodManagerService.TAG, "Unsetting current input method");
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                        }
                    }
                }
                if (curIm == null) {
                    changed = InputMethodManagerService.this.chooseNewDefaultIMELocked();
                }
                if (changed) {
                    InputMethodManagerService.this.updateFromSettingsLocked(false);
                }
            }
        }
    }

    class ImmsBroadcastReceiver
    extends BroadcastReceiver {
        ImmsBroadcastReceiver() {
        }

        private void updateActive() {
            if (InputMethodManagerService.this.mCurClient != null && InputMethodManagerService.this.mCurClient.client != null) {
                InputMethodManagerService.this.executeOrSendMessage(InputMethodManagerService.this.mCurClient.client, InputMethodManagerService.this.mCaller.obtainMessageIO(3020, InputMethodManagerService.this.mScreenOn ? 1 : 0, InputMethodManagerService.this.mCurClient));
            }
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.SCREEN_ON".equals(action)) {
                InputMethodManagerService.this.mScreenOn = true;
                InputMethodManagerService.this.refreshImeWindowVisibilityLocked();
                this.updateActive();
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(action)) {
                InputMethodManagerService.this.mScreenOn = false;
                InputMethodManagerService.this.setImeWindowVisibilityStatusHiddenLocked();
                this.updateActive();
                return;
            }
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action)) {
                InputMethodManagerService.this.hideInputMethodMenu();
                return;
            }
            Slog.w(InputMethodManagerService.TAG, "Unexpected intent " + intent);
        }
    }

    class SettingsObserver
    extends ContentObserver {
        String mLastEnabled;

        SettingsObserver(Handler handler) {
            super(handler);
            this.mLastEnabled = "";
            ContentResolver resolver = InputMethodManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("default_input_method"), false, this);
            resolver.registerContentObserver(Settings.Secure.getUriFor("enabled_input_methods"), false, this);
            resolver.registerContentObserver(Settings.Secure.getUriFor("selected_input_method_subtype"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                boolean enabledChanged = false;
                String newEnabled = InputMethodManagerService.this.mSettings.getEnabledInputMethodsStr();
                if (!this.mLastEnabled.equals(newEnabled)) {
                    this.mLastEnabled = newEnabled;
                    enabledChanged = true;
                }
                InputMethodManagerService.this.updateFromSettingsLocked(enabledChanged);
            }
        }
    }

    static final class ClientState {
        final IInputMethodClient client;
        final IInputContext inputContext;
        final int uid;
        final int pid;
        final InputBinding binding;
        boolean sessionRequested;
        SessionState curSession;

        public String toString() {
            return "ClientState{" + Integer.toHexString(System.identityHashCode(this)) + " uid " + this.uid + " pid " + this.pid + "}";
        }

        ClientState(IInputMethodClient _client, IInputContext _inputContext, int _uid, int _pid) {
            this.client = _client;
            this.inputContext = _inputContext;
            this.uid = _uid;
            this.pid = _pid;
            this.binding = new InputBinding(null, this.inputContext.asBinder(), this.uid, this.pid);
        }
    }

    class SessionState {
        final ClientState client;
        final IInputMethod method;
        IInputMethodSession session;
        InputChannel channel;

        public String toString() {
            return "SessionState{uid " + this.client.uid + " pid " + this.client.pid + " method " + Integer.toHexString(System.identityHashCode(this.method)) + " session " + Integer.toHexString(System.identityHashCode(this.session)) + " channel " + this.channel + "}";
        }

        SessionState(ClientState _client, IInputMethod _method, IInputMethodSession _session, InputChannel _channel) {
            this.client = _client;
            this.method = _method;
            this.session = _session;
            this.channel = _channel;
        }
    }
}

