/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.notification.StatusBarNotification;
import android.util.Slog;
import com.android.internal.statusbar.IStatusBar;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.statusbar.StatusBarIcon;
import com.android.internal.statusbar.StatusBarIconList;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusBarManagerService
extends IStatusBarService.Stub
implements WindowManagerService.OnHardKeyboardStatusChangeListener {
    static final String TAG = "StatusBarManagerService";
    static final boolean SPEW = false;
    final Context mContext;
    final WindowManagerService mWindowManager;
    Handler mHandler = new Handler();
    NotificationCallbacks mNotificationCallbacks;
    volatile IStatusBar mBar;
    StatusBarIconList mIcons = new StatusBarIconList();
    HashMap<IBinder, StatusBarNotification> mNotifications = new HashMap();
    final ArrayList<DisableRecord> mDisableRecords = new ArrayList();
    IBinder mSysUiVisToken = new Binder();
    int mDisabled = 0;
    Object mLock = new Object();
    int mSystemUiVisibility = 0;
    boolean mMenuVisible = false;
    int mImeWindowVis = 0;
    int mImeBackDisposition;
    IBinder mImeToken = null;
    int mCurrentUserId;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) || "android.intent.action.SCREEN_OFF".equals(action)) {
                StatusBarManagerService.this.collapsePanels();
            }
        }
    };

    public StatusBarManagerService(Context context, WindowManagerService windowManager) {
        this.mContext = context;
        this.mWindowManager = windowManager;
        this.mWindowManager.setOnHardKeyboardStatusChangeListener(this);
        Resources res = context.getResources();
        this.mIcons.defineSlots(res.getStringArray(17235977));
    }

    public void setNotificationCallbacks(NotificationCallbacks listener) {
        this.mNotificationCallbacks = listener;
    }

    @Override
    public void expandNotificationsPanel() {
        this.enforceExpandStatusBar();
        if (this.mBar != null) {
            try {
                this.mBar.animateExpandNotificationsPanel();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void collapsePanels() {
        this.enforceExpandStatusBar();
        if (this.mBar != null) {
            try {
                this.mBar.animateCollapsePanels();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void expandSettingsPanel() {
        this.enforceExpandStatusBar();
        if (this.mBar != null) {
            try {
                this.mBar.animateExpandSettingsPanel();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void disable(int what, IBinder token, String pkg) {
        this.disableInternal(this.mCurrentUserId, what, token, pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableInternal(int userId, int what, IBinder token, String pkg) {
        this.enforceStatusBar();
        Object object = this.mLock;
        synchronized (object) {
            this.disableLocked(userId, what, token, pkg);
        }
    }

    private void disableLocked(int userId, int what, IBinder token, String pkg) {
        this.manageDisableListLocked(userId, what, token, pkg);
        final int net = this.gatherDisableActionsLocked(this.mCurrentUserId);
        if (net != this.mDisabled) {
            this.mDisabled = net;
            this.mHandler.post(new Runnable(){

                public void run() {
                    StatusBarManagerService.this.mNotificationCallbacks.onSetDisabled(net);
                }
            });
            if (this.mBar != null) {
                try {
                    this.mBar.disable(net);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIcon(String slot, String iconPackage, int iconId, int iconLevel, String contentDescription) {
        this.enforceStatusBar();
        StatusBarIconList statusBarIconList = this.mIcons;
        synchronized (statusBarIconList) {
            int index = this.mIcons.getSlotIndex(slot);
            if (index < 0) {
                throw new SecurityException("invalid status bar icon slot: " + slot);
            }
            StatusBarIcon icon = new StatusBarIcon(iconPackage, UserHandle.OWNER, iconId, iconLevel, 0, contentDescription);
            this.mIcons.setIcon(index, icon);
            if (this.mBar != null) {
                try {
                    this.mBar.setIcon(index, icon);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIconVisibility(String slot, boolean visible) {
        this.enforceStatusBar();
        StatusBarIconList statusBarIconList = this.mIcons;
        synchronized (statusBarIconList) {
            int index = this.mIcons.getSlotIndex(slot);
            if (index < 0) {
                throw new SecurityException("invalid status bar icon slot: " + slot);
            }
            StatusBarIcon icon = this.mIcons.getIcon(index);
            if (icon == null) {
                return;
            }
            if (icon.visible != visible) {
                icon.visible = visible;
                if (this.mBar != null) {
                    try {
                        this.mBar.setIcon(index, icon);
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIcon(String slot) {
        this.enforceStatusBar();
        StatusBarIconList statusBarIconList = this.mIcons;
        synchronized (statusBarIconList) {
            int index = this.mIcons.getSlotIndex(slot);
            if (index < 0) {
                throw new SecurityException("invalid status bar icon slot: " + slot);
            }
            this.mIcons.removeIcon(index);
            if (this.mBar != null) {
                try {
                    this.mBar.removeIcon(index);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void topAppWindowChanged(final boolean menuVisible) {
        this.enforceStatusBar();
        Object object = this.mLock;
        synchronized (object) {
            this.mMenuVisible = menuVisible;
            this.mHandler.post(new Runnable(){

                public void run() {
                    if (StatusBarManagerService.this.mBar != null) {
                        try {
                            StatusBarManagerService.this.mBar.topAppWindowChanged(menuVisible);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImeWindowStatus(final IBinder token, final int vis, final int backDisposition) {
        this.enforceStatusBar();
        Object object = this.mLock;
        synchronized (object) {
            this.mImeWindowVis = vis;
            this.mImeBackDisposition = backDisposition;
            this.mImeToken = token;
            this.mHandler.post(new Runnable(){

                public void run() {
                    if (StatusBarManagerService.this.mBar != null) {
                        try {
                            StatusBarManagerService.this.mBar.setImeWindowStatus(token, vis, backDisposition);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemUiVisibility(int vis, int mask) {
        this.enforceStatusBarService();
        Object object = this.mLock;
        synchronized (object) {
            this.updateUiVisibilityLocked(vis, mask);
            this.disableLocked(this.mCurrentUserId, vis & 0x3FF0000, this.mSysUiVisToken, "WindowManager.LayoutParams");
        }
    }

    private void updateUiVisibilityLocked(final int vis, final int mask) {
        if (this.mSystemUiVisibility != vis) {
            this.mSystemUiVisibility = vis;
            this.mHandler.post(new Runnable(){

                public void run() {
                    if (StatusBarManagerService.this.mBar != null) {
                        try {
                            StatusBarManagerService.this.mBar.setSystemUiVisibility(vis, mask);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    @Override
    public void setHardKeyboardEnabled(final boolean enabled) {
        this.mHandler.post(new Runnable(){

            public void run() {
                StatusBarManagerService.this.mWindowManager.setHardKeyboardEnabled(enabled);
            }
        });
    }

    @Override
    public void onHardKeyboardStatusChange(final boolean available, final boolean enabled) {
        this.mHandler.post(new Runnable(){

            public void run() {
                if (StatusBarManagerService.this.mBar != null) {
                    try {
                        StatusBarManagerService.this.mBar.setHardKeyboardStatus(available, enabled);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public void toggleRecentApps() {
        if (this.mBar != null) {
            try {
                this.mBar.toggleRecentApps();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void preloadRecentApps() {
        if (this.mBar != null) {
            try {
                this.mBar.preloadRecentApps();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancelPreloadRecentApps() {
        if (this.mBar != null) {
            try {
                this.mBar.cancelPreloadRecentApps();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setCurrentUser(int newUserId) {
        this.mCurrentUserId = newUserId;
    }

    @Override
    public void setWindowState(int window, int state) {
        if (this.mBar != null) {
            try {
                this.mBar.setWindowState(window, state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void enforceStatusBar() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR", TAG);
    }

    private void enforceExpandStatusBar() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.EXPAND_STATUS_BAR", TAG);
    }

    private void enforceStatusBarService() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStatusBar(IStatusBar bar, StatusBarIconList iconList, List<IBinder> notificationKeys, List<StatusBarNotification> notifications, int[] switches, List<IBinder> binders) {
        this.enforceStatusBarService();
        Slog.i(TAG, "registerStatusBar bar=" + bar);
        this.mBar = bar;
        Object object = this.mIcons;
        synchronized (object) {
            iconList.copyFrom(this.mIcons);
        }
        object = this.mNotifications;
        synchronized (object) {
            for (Map.Entry<IBinder, StatusBarNotification> e : this.mNotifications.entrySet()) {
                notificationKeys.add(e.getKey());
                notifications.add(e.getValue());
            }
        }
        object = this.mLock;
        synchronized (object) {
            switches[0] = this.gatherDisableActionsLocked(this.mCurrentUserId);
            switches[1] = this.mSystemUiVisibility;
            switches[2] = this.mMenuVisible ? 1 : 0;
            switches[3] = this.mImeWindowVis;
            switches[4] = this.mImeBackDisposition;
            binders.add(this.mImeToken);
        }
        switches[5] = this.mWindowManager.isHardKeyboardAvailable() ? 1 : 0;
        switches[6] = this.mWindowManager.isHardKeyboardEnabled() ? 1 : 0;
    }

    @Override
    public void onPanelRevealed() {
        this.enforceStatusBarService();
        this.mNotificationCallbacks.onPanelRevealed();
    }

    @Override
    public void onNotificationClick(String pkg, String tag, int id2) {
        this.enforceStatusBarService();
        this.mNotificationCallbacks.onNotificationClick(pkg, tag, id2);
    }

    @Override
    public void onNotificationError(String pkg, String tag, int id2, int uid, int initialPid, String message) {
        this.enforceStatusBarService();
        this.mNotificationCallbacks.onNotificationError(pkg, tag, id2, uid, initialPid, message);
    }

    @Override
    public void onNotificationClear(String pkg, String tag, int id2) {
        this.enforceStatusBarService();
        this.mNotificationCallbacks.onNotificationClear(pkg, tag, id2);
    }

    @Override
    public void onClearAllNotifications() {
        this.enforceStatusBarService();
        this.mNotificationCallbacks.onClearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder addNotification(StatusBarNotification notification) {
        HashMap<IBinder, StatusBarNotification> hashMap = this.mNotifications;
        synchronized (hashMap) {
            Binder key = new Binder();
            this.mNotifications.put(key, notification);
            if (this.mBar != null) {
                try {
                    this.mBar.addNotification(key, notification);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNotification(IBinder key, StatusBarNotification notification) {
        HashMap<IBinder, StatusBarNotification> hashMap = this.mNotifications;
        synchronized (hashMap) {
            if (!this.mNotifications.containsKey(key)) {
                throw new IllegalArgumentException("updateNotification key not found: " + key);
            }
            this.mNotifications.put(key, notification);
            if (this.mBar != null) {
                try {
                    this.mBar.updateNotification(key, notification);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotification(IBinder key) {
        HashMap<IBinder, StatusBarNotification> hashMap = this.mNotifications;
        synchronized (hashMap) {
            StatusBarNotification n = this.mNotifications.remove(key);
            if (n == null) {
                Slog.e(TAG, "removeNotification key not found: " + key);
                return;
            }
            if (this.mBar != null) {
                try {
                    this.mBar.removeNotification(key);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
        }
    }

    void manageDisableListLocked(int userId, int what, IBinder token, String pkg) {
        int i;
        int N = this.mDisableRecords.size();
        DisableRecord tok = null;
        for (i = 0; i < N; ++i) {
            DisableRecord t = this.mDisableRecords.get(i);
            if (t.token != token || t.userId != userId) continue;
            tok = t;
            break;
        }
        if (what == 0 || !token.isBinderAlive()) {
            if (tok != null) {
                this.mDisableRecords.remove(i);
                tok.token.unlinkToDeath(tok, 0);
            }
        } else {
            if (tok == null) {
                tok = new DisableRecord();
                tok.userId = userId;
                try {
                    token.linkToDeath(tok, 0);
                }
                catch (RemoteException ex) {
                    return;
                }
                this.mDisableRecords.add(tok);
            }
            tok.what = what;
            tok.token = token;
            tok.pkg = pkg;
        }
    }

    int gatherDisableActionsLocked(int userId) {
        int N = this.mDisableRecords.size();
        int net = 0;
        for (int i = 0; i < N; ++i) {
            DisableRecord rec = this.mDisableRecords.get(i);
            if (rec.userId != userId) continue;
            net |= rec.what;
        }
        return net;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump StatusBar from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mIcons;
        synchronized (object) {
            this.mIcons.dump(pw);
        }
        object = this.mNotifications;
        synchronized (object) {
            int i = 0;
            pw.println("Notification list:");
            for (Map.Entry<IBinder, StatusBarNotification> e : this.mNotifications.entrySet()) {
                pw.printf("  %2d: %s\n", i, e.getValue().toString());
                ++i;
            }
        }
        object = this.mLock;
        synchronized (object) {
            pw.println("  mDisabled=0x" + Integer.toHexString(this.mDisabled));
            int N = this.mDisableRecords.size();
            pw.println("  mDisableRecords.size=" + N);
            for (int i = 0; i < N; ++i) {
                DisableRecord tok = this.mDisableRecords.get(i);
                pw.println("    [" + i + "] userId=" + tok.userId + " what=0x" + Integer.toHexString(tok.what) + " pkg=" + tok.pkg + " token=" + tok.token);
            }
        }
    }

    public static interface NotificationCallbacks {
        public void onSetDisabled(int var1);

        public void onClearAll();

        public void onNotificationClick(String var1, String var2, int var3);

        public void onNotificationClear(String var1, String var2, int var3);

        public void onPanelRevealed();

        public void onNotificationError(String var1, String var2, int var3, int var4, int var5, String var6);
    }

    private class DisableRecord
    implements IBinder.DeathRecipient {
        int userId;
        String pkg;
        int what;
        IBinder token;

        private DisableRecord() {
        }

        public void binderDied() {
            Slog.i(StatusBarManagerService.TAG, "binder died for pkg=" + this.pkg);
            StatusBarManagerService.this.disableInternal(this.userId, 0, this.token, this.pkg);
            this.token.unlinkToDeath(this, 0);
        }
    }
}

