/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.AlertDialog;
import android.app.AppGlobals;
import android.app.ApplicationErrorReport;
import android.app.ContextImpl;
import android.app.Dialog;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.INotificationManager;
import android.app.IProcessObserver;
import android.app.IServiceConnection;
import android.app.IStopUserCallback;
import android.app.IThumbnailReceiver;
import android.app.IUiAutomationConnection;
import android.app.IUserSwitchObserver;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.backup.IBackupManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.ProxyProperties;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPermissionController;
import android.os.IRemoteCallback;
import android.os.IUserManager;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UpdateLock;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.ProcessMap;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.ProcessCpuTracker;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.MemInfoReader;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.AppOpsService;
import com.android.server.AttributeCache;
import com.android.server.IntentResolver;
import com.android.server.Watchdog;
import com.android.server.am.ActiveServices;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppErrorDialog;
import com.android.server.am.AppErrorResult;
import com.android.server.am.AppNotRespondingDialog;
import com.android.server.am.AppWaitingForDebuggerDialog;
import com.android.server.am.BackupRecord;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.BatteryStatsService;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastQueue;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.CompatModeDialog;
import com.android.server.am.CompatModePackages;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.CoreSettingsObserver;
import com.android.server.am.EventLogTags;
import com.android.server.am.FactoryErrorDialog;
import com.android.server.am.LaunchWarningWindow;
import com.android.server.am.NativeCrashListener;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.PendingThumbnailsRecord;
import com.android.server.am.ProcessList;
import com.android.server.am.ProcessMemInfo;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ProcessStatsService;
import com.android.server.am.ProviderMap;
import com.android.server.am.ReceiverList;
import com.android.server.am.ServiceRecord;
import com.android.server.am.StrictModeViolationDialog;
import com.android.server.am.TaskRecord;
import com.android.server.am.UriPermission;
import com.android.server.am.UriPermissionOwner;
import com.android.server.am.UsageStatsService;
import com.android.server.am.UserStartedState;
import com.android.server.firewall.IntentFirewall;
import com.android.server.pm.UserManagerService;
import com.android.server.wm.WindowManagerService;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import dalvik.system.Zygote;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivityManagerService
extends ActivityManagerNative
implements Watchdog.Monitor,
BatteryStatsImpl.BatteryCallback {
    private static final String USER_DATA_DIR = "/data/user/";
    static final String TAG = "ActivityManager";
    static final String TAG_MU = "ActivityManagerServiceMU";
    static final boolean DEBUG = false;
    static final boolean localLOGV = false;
    static final boolean DEBUG_BACKUP = false;
    static final boolean DEBUG_BROADCAST = false;
    static final boolean DEBUG_BROADCAST_LIGHT = false;
    static final boolean DEBUG_BACKGROUND_BROADCAST = false;
    static final boolean DEBUG_CLEANUP = false;
    static final boolean DEBUG_CONFIGURATION = false;
    static final boolean DEBUG_FOCUS = false;
    static final boolean DEBUG_IMMERSIVE = false;
    static final boolean DEBUG_MU = false;
    static final boolean DEBUG_OOM_ADJ = false;
    static final boolean DEBUG_LRU = false;
    static final boolean DEBUG_PAUSE = false;
    static final boolean DEBUG_POWER = false;
    static final boolean DEBUG_POWER_QUICK = false;
    static final boolean DEBUG_PROCESS_OBSERVERS = false;
    static final boolean DEBUG_PROCESSES = false;
    static final boolean DEBUG_PROVIDER = false;
    static final boolean DEBUG_RESULTS = false;
    static final boolean DEBUG_SERVICE = false;
    static final boolean DEBUG_SERVICE_EXECUTING = false;
    static final boolean DEBUG_STACK = false;
    static final boolean DEBUG_SWITCH = false;
    static final boolean DEBUG_TASKS = false;
    static final boolean DEBUG_THUMBNAILS = false;
    static final boolean DEBUG_TRANSITION = false;
    static final boolean DEBUG_URI_PERMISSION = false;
    static final boolean DEBUG_USER_LEAVING = false;
    static final boolean DEBUG_VISBILITY = false;
    static final boolean DEBUG_PSS = false;
    static final boolean DEBUG_LOCKSCREEN = false;
    static final boolean VALIDATE_TOKENS = false;
    static final boolean SHOW_ACTIVITY_START_TIME = true;
    static final long BATTERY_STATS_TIME = 1800000L;
    static final boolean MONITOR_CPU_USAGE = true;
    static final long MONITOR_CPU_MIN_TIME = 5000L;
    static final long MONITOR_CPU_MAX_TIME = 0xFFFFFFFL;
    static final boolean MONITOR_THREAD_CPU_USAGE = false;
    static final int STOCK_PM_FLAGS = 1024;
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    static final boolean IS_USER_BUILD = "user".equals(Build.TYPE);
    static final int MAX_RECENT_TASKS = ActivityManager.isLowRamDeviceStatic() ? 10 : 20;
    static final long APP_SWITCH_DELAY_TIME = 5000L;
    static final int PROC_START_TIMEOUT = 10000;
    static final int PROC_START_TIMEOUT_WITH_WRAPPER = 300000;
    static final int GC_TIMEOUT = 5000;
    static final int GC_MIN_INTERVAL = 60000;
    static final int FULL_PSS_MIN_INTERVAL = 600000;
    static final int FULL_PSS_LOWERED_INTERVAL = 120000;
    static final int POWER_CHECK_DELAY = 900000;
    static final int WAKE_LOCK_MIN_CHECK_DURATION = 300000;
    static final int CPU_MIN_CHECK_DURATION = 300000;
    static final int BROADCAST_FG_TIMEOUT = 10000;
    static final int BROADCAST_BG_TIMEOUT = 60000;
    static final int KEY_DISPATCHING_TIMEOUT = 5000;
    static final int INSTRUMENTATION_KEY_DISPATCHING_TIMEOUT = 60000;
    static final int USER_SWITCH_TIMEOUT = 2000;
    static final int MAX_RUNNING_USERS = 3;
    static final int PENDING_ASSIST_EXTRAS_TIMEOUT = 500;
    static final int MAX_PERSISTED_URI_GRANTS = 128;
    static final int MY_PID = Process.myPid();
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final int DROPBOX_MAX_SIZE = 262144;
    ActivityStackSupervisor mStackSupervisor;
    public IntentFirewall mIntentFirewall;
    private final boolean mHeadless;
    private boolean mShowDialogs = true;
    final ArrayList<PendingActivityLaunch> mPendingActivityLaunches = new ArrayList();
    BroadcastQueue mFgBroadcastQueue;
    BroadcastQueue mBgBroadcastQueue;
    final BroadcastQueue[] mBroadcastQueues = new BroadcastQueue[2];
    ActivityRecord mFocusedActivity = null;
    private final ArrayList<TaskRecord> mRecentTasks = new ArrayList();
    final ArrayList<PendingAssistExtras> mPendingAssistExtras = new ArrayList();
    final ProcessList mProcessList = new ProcessList();
    final ProcessMap<ProcessRecord> mProcessNames = new ProcessMap();
    final ProcessStatsService mProcessStats;
    final SparseArray<ProcessRecord> mIsolatedProcesses = new SparseArray();
    int mNextIsolatedProcessUid = 0;
    ProcessRecord mHeavyWeightProcess = null;
    final ProcessMap<Long> mProcessCrashTimes = new ProcessMap();
    final ProcessMap<BadProcessInfo> mBadProcesses = new ProcessMap();
    final SparseArray<ProcessRecord> mPidsSelfLocked = new SparseArray();
    final SparseArray<ForegroundToken> mForegroundProcesses = new SparseArray();
    final ArrayList<ProcessRecord> mProcessesOnHold = new ArrayList();
    final ArrayList<ProcessRecord> mPersistentStartingProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mRemovedProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mLruProcesses = new ArrayList();
    int mLruProcessActivityStart = 0;
    int mLruProcessServiceStart = 0;
    final ArrayList<ProcessRecord> mProcessesToGc = new ArrayList();
    final ArrayList<ProcessRecord> mPendingPssProcesses = new ArrayList();
    long mLastFullPssTime = SystemClock.uptimeMillis();
    ProcessRecord mHomeProcess;
    ProcessRecord mPreviousProcess;
    long mPreviousProcessVisibleTime;
    final SparseArray<UserStartedState> mStartedUsers = new SparseArray();
    final ArrayList<Integer> mUserLru = new ArrayList();
    int[] mStartedUserArray = new int[]{0};
    final RemoteCallbackList<IUserSwitchObserver> mUserSwitchObservers = new RemoteCallbackList();
    Object mCurUserSwitchCallback;
    final CompatModePackages mCompatModePackages;
    final HashMap<PendingIntentRecord.Key, WeakReference<PendingIntentRecord>> mIntentSenderRecords = new HashMap();
    private final HashSet<Integer> mAlreadyLoggedViolatedStacks = new HashSet();
    private static final int MAX_DUP_SUPPRESSED_STACKS = 5000;
    private final StringBuilder mStrictModeBuffer = new StringBuilder();
    final HashMap<IBinder, ReceiverList> mRegisteredReceivers = new HashMap();
    final IntentResolver<BroadcastFilter, BroadcastFilter> mReceiverResolver = new IntentResolver<BroadcastFilter, BroadcastFilter>(){

        @Override
        protected boolean allowFilterResult(BroadcastFilter filter, List<BroadcastFilter> dest) {
            IBinder target = filter.receiverList.receiver.asBinder();
            for (int i = dest.size() - 1; i >= 0; --i) {
                if (dest.get((int)i).receiverList.receiver.asBinder() != target) continue;
                return false;
            }
            return true;
        }

        @Override
        protected BroadcastFilter newResult(BroadcastFilter filter, int match, int userId) {
            if (userId == -1 || filter.owningUserId == -1 || userId == filter.owningUserId) {
                return (BroadcastFilter)super.newResult(filter, match, userId);
            }
            return null;
        }

        protected BroadcastFilter[] newArray(int size) {
            return new BroadcastFilter[size];
        }

        @Override
        protected boolean isPackageForFilter(String packageName, BroadcastFilter filter) {
            return packageName.equals(filter.packageName);
        }
    };
    final SparseArray<ArrayMap<String, ArrayList<Intent>>> mStickyBroadcasts = new SparseArray();
    final ActiveServices mServices;
    String mBackupAppName = null;
    BackupRecord mBackupTarget = null;
    final ArrayList<PendingThumbnailsRecord> mPendingThumbnails = new ArrayList();
    final ProviderMap mProviderMap;
    final ArrayList<ContentProviderRecord> mLaunchingProviders = new ArrayList();
    private final AtomicFile mGrantFile;
    private static final String TAG_URI_GRANTS = "uri-grants";
    private static final String TAG_URI_GRANT = "uri-grant";
    private static final String ATTR_USER_HANDLE = "userHandle";
    private static final String ATTR_SOURCE_PKG = "sourcePkg";
    private static final String ATTR_TARGET_PKG = "targetPkg";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_MODE_FLAGS = "modeFlags";
    private static final String ATTR_CREATED_TIME = "createdTime";
    @GuardedBy(value="this")
    private final SparseArray<ArrayMap<Uri, UriPermission>> mGrantedUriPermissions = new SparseArray();
    CoreSettingsObserver mCoreSettingsObserver;
    private static ThreadLocal<Identity> sCallerIdentity = new ThreadLocal();
    final BatteryStatsService mBatteryStatsService;
    final UsageStatsService mUsageStatsService;
    final AppOpsService mAppOpsService;
    Configuration mConfiguration = new Configuration();
    int mConfigurationSeq = 0;
    final int GL_ES_VERSION;
    HashMap<String, IBinder> mAppBindArgs;
    final StringBuilder mStringBuilder = new StringBuilder(256);
    boolean mStartRunning = false;
    ComponentName mTopComponent;
    String mTopAction;
    String mTopData;
    boolean mProcessesReady = false;
    boolean mSystemReady = false;
    boolean mBooting = false;
    boolean mWaitingUpdate = false;
    boolean mDidUpdate = false;
    boolean mOnBattery = false;
    boolean mLaunchWarningShown = false;
    Context mContext;
    int mFactoryTest;
    boolean mCheckedForSetup;
    long mAppSwitchesAllowedTime;
    boolean mDidAppSwitch;
    long mLastPowerCheckRealtime;
    long mLastPowerCheckUptime;
    boolean mSleeping = false;
    boolean mWentToSleep = false;
    boolean mLockScreenShown = false;
    boolean mShuttingDown = false;
    int mAdjSeq = 0;
    int mLruSeq = 0;
    int mNumNonCachedProcs = 0;
    int mNumCachedHiddenProcs = 0;
    int mNumServiceProcs = 0;
    int mNewNumAServiceProcs = 0;
    int mNewNumServiceProcs = 0;
    boolean mAllowLowerMemLevel = false;
    int mLastMemoryLevel = 0;
    int mLastNumProcesses;
    long mLastIdleTime = SystemClock.uptimeMillis();
    long mLowRamTimeSinceLastIdle = 0L;
    long mLowRamStartTime = 0L;
    boolean mDidDexOpt;
    String mDebugApp = null;
    boolean mWaitForDebugger = false;
    boolean mDebugTransient = false;
    String mOrigDebugApp = null;
    boolean mOrigWaitForDebugger = false;
    boolean mAlwaysFinishActivities = false;
    IActivityController mController = null;
    String mProfileApp = null;
    ProcessRecord mProfileProc = null;
    String mProfileFile;
    ParcelFileDescriptor mProfileFd;
    int mProfileType = 0;
    boolean mAutoStopProfiler = false;
    String mOpenGlTraceApp = null;
    final RemoteCallbackList<IProcessObserver> mProcessObservers = new RemoteCallbackList();
    ProcessChangeItem[] mActiveProcessChanges = new ProcessChangeItem[5];
    final ArrayList<ProcessChangeItem> mPendingProcessChanges = new ArrayList();
    final ArrayList<ProcessChangeItem> mAvailProcessChanges = new ArrayList();
    final Thread mProcessCpuThread;
    final ProcessCpuTracker mProcessCpuTracker = new ProcessCpuTracker(false);
    final AtomicLong mLastCpuTime = new AtomicLong(0L);
    final AtomicBoolean mProcessCpuMutexFree = new AtomicBoolean(true);
    long mLastWriteTime = 0L;
    final UpdateLock mUpdateLock = new UpdateLock("immersive");
    boolean mBooted = false;
    int mProcessLimit = 24;
    int mProcessLimitOverride = -1;
    WindowManagerService mWindowManager;
    static ActivityManagerService mSelf;
    static ActivityThread mSystemThread;
    int mCurrentUserId = 0;
    private UserManagerService mUserManager;
    static final int SHOW_ERROR_MSG = 1;
    static final int SHOW_NOT_RESPONDING_MSG = 2;
    static final int SHOW_FACTORY_ERROR_MSG = 3;
    static final int UPDATE_CONFIGURATION_MSG = 4;
    static final int GC_BACKGROUND_PROCESSES_MSG = 5;
    static final int WAIT_FOR_DEBUGGER_MSG = 6;
    static final int SERVICE_TIMEOUT_MSG = 12;
    static final int UPDATE_TIME_ZONE = 13;
    static final int SHOW_UID_ERROR_MSG = 14;
    static final int IM_FEELING_LUCKY_MSG = 15;
    static final int PROC_START_TIMEOUT_MSG = 20;
    static final int DO_PENDING_ACTIVITY_LAUNCHES_MSG = 21;
    static final int KILL_APPLICATION_MSG = 22;
    static final int FINALIZE_PENDING_INTENT_MSG = 23;
    static final int POST_HEAVY_NOTIFICATION_MSG = 24;
    static final int CANCEL_HEAVY_NOTIFICATION_MSG = 25;
    static final int SHOW_STRICT_MODE_VIOLATION_MSG = 26;
    static final int CHECK_EXCESSIVE_WAKE_LOCKS_MSG = 27;
    static final int CLEAR_DNS_CACHE_MSG = 28;
    static final int UPDATE_HTTP_PROXY_MSG = 29;
    static final int SHOW_COMPAT_MODE_DIALOG_MSG = 30;
    static final int DISPATCH_PROCESSES_CHANGED = 31;
    static final int DISPATCH_PROCESS_DIED = 32;
    static final int REPORT_MEM_USAGE_MSG = 33;
    static final int REPORT_USER_SWITCH_MSG = 34;
    static final int CONTINUE_USER_SWITCH_MSG = 35;
    static final int USER_SWITCH_TIMEOUT_MSG = 36;
    static final int IMMERSIVE_MODE_LOCK_MSG = 37;
    static final int PERSIST_URI_GRANTS_MSG = 38;
    static final int REQUEST_ALL_PSS_MSG = 39;
    static final int FIRST_ACTIVITY_STACK_MSG = 100;
    static final int FIRST_BROADCAST_QUEUE_MSG = 200;
    static final int FIRST_COMPAT_MODE_MSG = 300;
    static final int FIRST_SUPERVISOR_STACK_MSG = 100;
    AlertDialog mUidAlert;
    CompatModeDialog mCompatModeDialog;
    long mLastMemUsageReportTime = 0L;
    private boolean mUserIsMonkey;
    final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    HashMap data = (HashMap)msg.obj;
                    boolean showBackground = Settings.Secure.getInt(ActivityManagerService.this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ProcessRecord proc = (ProcessRecord)data.get("app");
                        AppErrorResult res = (AppErrorResult)data.get("result");
                        if (proc != null && proc.crashDialog != null) {
                            Slog.e(ActivityManagerService.TAG, "App already has crash dialog: " + proc);
                            if (res != null) {
                                res.set(0);
                            }
                            return;
                        }
                        if (!showBackground && UserHandle.getAppId(proc.uid) >= 10000 && proc.userId != ActivityManagerService.this.mCurrentUserId && proc.pid != MY_PID) {
                            Slog.w(ActivityManagerService.TAG, "Skipping crash dialog of " + proc + ": background");
                            if (res != null) {
                                res.set(0);
                            }
                            return;
                        }
                        if (ActivityManagerService.this.mShowDialogs && !ActivityManagerService.this.mSleeping && !ActivityManagerService.this.mShuttingDown) {
                            AppErrorDialog d = new AppErrorDialog(ActivityManagerService.this.mContext, ActivityManagerService.this, res, proc);
                            d.show();
                            proc.crashDialog = d;
                        } else if (res != null) {
                            res.set(0);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 2: {
                    ActivityManagerService data = ActivityManagerService.this;
                    synchronized (data) {
                        HashMap data2 = (HashMap)msg.obj;
                        ProcessRecord proc = (ProcessRecord)data2.get("app");
                        if (proc != null && proc.anrDialog != null) {
                            Slog.e(ActivityManagerService.TAG, "App already has anr dialog: " + proc);
                            return;
                        }
                        Intent intent = new Intent("android.intent.action.ANR");
                        if (!ActivityManagerService.this.mProcessesReady) {
                            intent.addFlags(0x50000000);
                        }
                        ActivityManagerService.this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, 0);
                        if (ActivityManagerService.this.mShowDialogs) {
                            AppNotRespondingDialog d = new AppNotRespondingDialog(ActivityManagerService.this, ActivityManagerService.this.mContext, proc, (ActivityRecord)data2.get("activity"), msg.arg1 != 0);
                            d.show();
                            proc.anrDialog = d;
                        } else {
                            ActivityManagerService.this.killAppAtUsersRequest(proc, null);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 26: {
                    HashMap data = (HashMap)msg.obj;
                    ActivityManagerService data2 = ActivityManagerService.this;
                    synchronized (data2) {
                        ProcessRecord proc = (ProcessRecord)data.get("app");
                        if (proc == null) {
                            Slog.e(ActivityManagerService.TAG, "App not found when showing strict mode dialog.");
                            break;
                        }
                        if (proc.crashDialog != null) {
                            Slog.e(ActivityManagerService.TAG, "App already has strict mode dialog: " + proc);
                            return;
                        }
                        AppErrorResult res = (AppErrorResult)data.get("result");
                        if (ActivityManagerService.this.mShowDialogs && !ActivityManagerService.this.mSleeping && !ActivityManagerService.this.mShuttingDown) {
                            StrictModeViolationDialog d = new StrictModeViolationDialog(ActivityManagerService.this.mContext, ActivityManagerService.this, res, proc);
                            d.show();
                            proc.crashDialog = d;
                        } else {
                            res.set(0);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 3: {
                    FactoryErrorDialog d = new FactoryErrorDialog(ActivityManagerService.this.mContext, msg.getData().getCharSequence("msg"));
                    d.show();
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 4: {
                    ContentResolver resolver = ActivityManagerService.this.mContext.getContentResolver();
                    Settings.System.putConfiguration(resolver, (Configuration)msg.obj);
                    break;
                }
                case 5: {
                    ActivityManagerService resolver = ActivityManagerService.this;
                    synchronized (resolver) {
                        ActivityManagerService.this.performAppGcsIfAppropriateLocked();
                        break;
                    }
                }
                case 6: {
                    ActivityManagerService resolver = ActivityManagerService.this;
                    synchronized (resolver) {
                        ProcessRecord app = (ProcessRecord)msg.obj;
                        if (msg.arg1 != 0) {
                            if (!app.waitedForDebugger) {
                                AppWaitingForDebuggerDialog d = new AppWaitingForDebuggerDialog(ActivityManagerService.this, ActivityManagerService.this.mContext, app);
                                app.waitDialog = d;
                                app.waitedForDebugger = true;
                                d.show();
                            }
                        } else if (app.waitDialog != null) {
                            app.waitDialog.dismiss();
                            app.waitDialog = null;
                        }
                        break;
                    }
                }
                case 12: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(12);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 20000L);
                        return;
                    }
                    ActivityManagerService.this.mServices.serviceTimeout((ProcessRecord)msg.obj);
                    break;
                }
                case 13: {
                    ActivityManagerService nmsg = ActivityManagerService.this;
                    synchronized (nmsg) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.updateTimeZone();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w(ActivityManagerService.TAG, "Failed to update time zone for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 28: {
                    ActivityManagerService nmsg = ActivityManagerService.this;
                    synchronized (nmsg) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.clearDnsCache();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w(ActivityManagerService.TAG, "Failed to clear dns cache for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 29: {
                    ProxyProperties proxy = (ProxyProperties)msg.obj;
                    String host = "";
                    String port = "";
                    String exclList = "";
                    String pacFileUrl = null;
                    if (proxy != null) {
                        host = proxy.getHost();
                        port = Integer.toString(proxy.getPort());
                        exclList = proxy.getExclusionList();
                        pacFileUrl = proxy.getPacFileUrl();
                    }
                    ActivityManagerService d = ActivityManagerService.this;
                    synchronized (d) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.setHttpProxy(host, port, exclList, pacFileUrl);
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w(ActivityManagerService.TAG, "Failed to update http proxy for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 14: {
                    String title = "System UIDs Inconsistent";
                    String text = "UIDs on the system are inconsistent, you need to wipe your data partition or your device will be unstable.";
                    Log.e(ActivityManagerService.TAG, title + ": " + text);
                    if (!ActivityManagerService.this.mShowDialogs) break;
                    BaseErrorDialog d = new BaseErrorDialog(ActivityManagerService.this.mContext);
                    d.getWindow().setType(2010);
                    d.setCancelable(false);
                    d.setTitle(title);
                    d.setMessage(text);
                    d.setButton(-1, (CharSequence)"I'm Feeling Lucky", ActivityManagerService.this.mHandler.obtainMessage(15));
                    ActivityManagerService.this.mUidAlert = d;
                    d.show();
                    break;
                }
                case 15: {
                    if (ActivityManagerService.this.mUidAlert == null) break;
                    ActivityManagerService.this.mUidAlert.dismiss();
                    ActivityManagerService.this.mUidAlert = null;
                    break;
                }
                case 20: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(20);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    ProcessRecord app = (ProcessRecord)msg.obj;
                    ActivityManagerService text = ActivityManagerService.this;
                    synchronized (text) {
                        ActivityManagerService.this.processStartTimedOutLocked(app);
                        break;
                    }
                }
                case 21: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        ActivityManagerService.this.doPendingActivityLaunchesLocked(true);
                        break;
                    }
                }
                case 22: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        int appid = msg.arg1;
                        boolean restart = msg.arg2 == 1;
                        Bundle bundle = (Bundle)msg.obj;
                        String pkg = bundle.getString("pkg");
                        String reason = bundle.getString("reason");
                        ActivityManagerService.this.forceStopPackageLocked(pkg, appid, restart, false, true, false, -1, reason);
                        break;
                    }
                }
                case 23: {
                    ((PendingIntentRecord)msg.obj).completeFinalize();
                    break;
                }
                case 24: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    ActivityRecord root = (ActivityRecord)msg.obj;
                    ProcessRecord process = root.app;
                    if (process == null) {
                        return;
                    }
                    try {
                        Context context = ActivityManagerService.this.mContext.createPackageContext(process.info.packageName, 0);
                        String text = ActivityManagerService.this.mContext.getString(0x1040414, context.getApplicationInfo().loadLabel(context.getPackageManager()));
                        Notification notification = new Notification();
                        notification.icon = 17302925;
                        notification.when = 0L;
                        notification.flags = 2;
                        notification.tickerText = text;
                        notification.defaults = 0;
                        notification.sound = null;
                        notification.vibrate = null;
                        notification.setLatestEventInfo(context, text, ActivityManagerService.this.mContext.getText(17040405), PendingIntent.getActivityAsUser(ActivityManagerService.this.mContext, 0, root.intent, 0x10000000, null, new UserHandle(root.userId)));
                        try {
                            int[] outId = new int[1];
                            inm.enqueueNotificationWithTag("android", "android", null, 0x1040414, notification, outId, root.userId);
                        }
                        catch (RuntimeException e) {
                            Slog.w(ActivityManagerService.TAG, "Error showing notification for heavy-weight app", e);
                        }
                        catch (RemoteException e) {
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w(ActivityManagerService.TAG, "Unable to create context for heavy notification", e);
                    }
                    break;
                }
                case 25: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    try {
                        inm.cancelNotificationWithTag("android", null, 0x1040414, msg.arg1);
                    }
                    catch (RuntimeException e) {
                        Slog.w(ActivityManagerService.TAG, "Error canceling notification for service", e);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 27: {
                    ActivityManagerService inm = ActivityManagerService.this;
                    synchronized (inm) {
                        ActivityManagerService.this.checkExcessivePowerUsageLocked(true);
                        this.removeMessages(27);
                        Message nmsg = this.obtainMessage(27);
                        this.sendMessageDelayed(nmsg, 900000L);
                        break;
                    }
                }
                case 30: {
                    ActivityManagerService inm = ActivityManagerService.this;
                    synchronized (inm) {
                        ActivityRecord ar = (ActivityRecord)msg.obj;
                        if (ActivityManagerService.this.mCompatModeDialog != null) {
                            if (ActivityManagerService.this.mCompatModeDialog.mAppInfo.packageName.equals(ar.info.applicationInfo.packageName)) {
                                return;
                            }
                            ActivityManagerService.this.mCompatModeDialog.dismiss();
                            ActivityManagerService.this.mCompatModeDialog = null;
                        }
                        if (ar != null) {
                            // empty if block
                        }
                        break;
                    }
                }
                case 31: {
                    ActivityManagerService.this.dispatchProcessesChanged();
                    break;
                }
                case 32: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    ActivityManagerService.this.dispatchProcessDied(pid, uid);
                    break;
                }
                case 33: {
                    final ArrayList memInfos = (ArrayList)msg.obj;
                    Thread thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            int i;
                            SparseArray<ProcessMemInfo> infoMap = new SparseArray<ProcessMemInfo>(memInfos.size());
                            int N = memInfos.size();
                            for (int i2 = 0; i2 < N; ++i2) {
                                ProcessMemInfo mi = (ProcessMemInfo)memInfos.get(i2);
                                infoMap.put(mi.pid, mi);
                            }
                            ActivityManagerService.this.updateCpuStatsNow();
                            Thread i2 = ActivityManagerService.this.mProcessCpuThread;
                            synchronized (i2) {
                                N = ActivityManagerService.this.mProcessCpuTracker.countStats();
                                for (i = 0; i < N; ++i) {
                                    long pss;
                                    ProcessCpuTracker.Stats st = ActivityManagerService.this.mProcessCpuTracker.getStats(i);
                                    if (st.vsize <= 0L || (pss = Debug.getPss(st.pid, null)) <= 0L || infoMap.indexOfKey(st.pid) >= 0) continue;
                                    ProcessMemInfo mi = new ProcessMemInfo(st.name, st.pid, -17, -1, "native", null);
                                    mi.pss = pss;
                                    memInfos.add(mi);
                                }
                            }
                            long totalPss = 0L;
                            int N2 = memInfos.size();
                            for (i = 0; i < N2; ++i) {
                                ProcessMemInfo mi = (ProcessMemInfo)memInfos.get(i);
                                if (mi.pss == 0L) {
                                    mi.pss = Debug.getPss(mi.pid, null);
                                }
                                totalPss += mi.pss;
                            }
                            Collections.sort(memInfos, new Comparator<ProcessMemInfo>(){

                                @Override
                                public int compare(ProcessMemInfo lhs, ProcessMemInfo rhs) {
                                    if (lhs.oomAdj != rhs.oomAdj) {
                                        return lhs.oomAdj < rhs.oomAdj ? -1 : 1;
                                    }
                                    if (lhs.pss != rhs.pss) {
                                        return lhs.pss < rhs.pss ? 1 : -1;
                                    }
                                    return 0;
                                }
                            });
                            StringBuilder tag = new StringBuilder(128);
                            StringBuilder stack = new StringBuilder(128);
                            tag.append("Low on memory -- ");
                            ActivityManagerService.appendMemBucket(tag, totalPss, "total", false);
                            ActivityManagerService.appendMemBucket(stack, totalPss, "total", true);
                            StringBuilder logBuilder = new StringBuilder(1024);
                            logBuilder.append("Low on memory:\n");
                            boolean firstLine = true;
                            int lastOomAdj = Integer.MIN_VALUE;
                            int N3 = memInfos.size();
                            for (int i3 = 0; i3 < N3; ++i3) {
                                ProcessMemInfo mi = (ProcessMemInfo)memInfos.get(i3);
                                if (mi.oomAdj != -17 && (mi.oomAdj < 5 || mi.oomAdj == 6 || mi.oomAdj == 7)) {
                                    if (lastOomAdj != mi.oomAdj) {
                                        lastOomAdj = mi.oomAdj;
                                        if (mi.oomAdj <= 0) {
                                            tag.append(" / ");
                                        }
                                        if (mi.oomAdj >= 0) {
                                            if (firstLine) {
                                                stack.append(":");
                                                firstLine = false;
                                            }
                                            stack.append("\n\t at ");
                                        } else {
                                            stack.append("$");
                                        }
                                    } else {
                                        tag.append(" ");
                                        stack.append("$");
                                    }
                                    if (mi.oomAdj <= 0) {
                                        ActivityManagerService.appendMemBucket(tag, mi.pss, mi.name, false);
                                    }
                                    ActivityManagerService.appendMemBucket(stack, mi.pss, mi.name, true);
                                    if (mi.oomAdj >= 0 && (i3 + 1 >= N3 || ((ProcessMemInfo)memInfos.get((int)(i3 + 1))).oomAdj != lastOomAdj)) {
                                        stack.append("(");
                                        for (int k = 0; k < DUMP_MEM_OOM_ADJ.length; ++k) {
                                            if (DUMP_MEM_OOM_ADJ[k] != mi.oomAdj) continue;
                                            stack.append(DUMP_MEM_OOM_LABEL[k]);
                                            stack.append(":");
                                            stack.append(DUMP_MEM_OOM_ADJ[k]);
                                        }
                                        stack.append(")");
                                    }
                                }
                                logBuilder.append("  ");
                                logBuilder.append(ProcessList.makeOomAdjString(mi.oomAdj));
                                logBuilder.append(' ');
                                logBuilder.append(ProcessList.makeProcStateString(mi.procState));
                                logBuilder.append(' ');
                                ProcessList.appendRamKb(logBuilder, mi.pss);
                                logBuilder.append(" kB: ");
                                logBuilder.append(mi.name);
                                logBuilder.append(" (");
                                logBuilder.append(mi.pid);
                                logBuilder.append(") ");
                                logBuilder.append(mi.adjType);
                                logBuilder.append('\n');
                                if (mi.adjReason == null) continue;
                                logBuilder.append("                      ");
                                logBuilder.append(mi.adjReason);
                                logBuilder.append('\n');
                            }
                            logBuilder.append("           ");
                            ProcessList.appendRamKb(logBuilder, totalPss);
                            logBuilder.append(" kB: TOTAL\n");
                            long[] infos = new long[9];
                            Debug.getMemInfo(infos);
                            logBuilder.append("  MemInfo: ");
                            logBuilder.append(infos[5]).append(" kB slab, ");
                            logBuilder.append(infos[4]).append(" kB shmem, ");
                            logBuilder.append(infos[2]).append(" kB buffers, ");
                            logBuilder.append(infos[3]).append(" kB cached, ");
                            logBuilder.append(infos[1]).append(" kB free\n");
                            if (infos[8] != 0L) {
                                logBuilder.append("  ZRAM: ");
                                logBuilder.append(infos[8]);
                                logBuilder.append(" kB RAM, ");
                                logBuilder.append(infos[6]);
                                logBuilder.append(" kB swap total, ");
                                logBuilder.append(infos[7]);
                                logBuilder.append(" kB swap free\n");
                            }
                            Slog.i(ActivityManagerService.TAG, logBuilder.toString());
                            StringBuilder dropBuilder = new StringBuilder(1024);
                            dropBuilder.append(stack);
                            dropBuilder.append('\n');
                            dropBuilder.append('\n');
                            dropBuilder.append(logBuilder);
                            dropBuilder.append('\n');
                            StringWriter catSw = new StringWriter();
                            ActivityManagerService activityManagerService = ActivityManagerService.this;
                            synchronized (activityManagerService) {
                                FastPrintWriter catPw = new FastPrintWriter(catSw, false, 256);
                                String[] emptyArgs = new String[]{};
                                ((PrintWriter)catPw).println();
                                ActivityManagerService.this.dumpProcessesLocked(null, catPw, emptyArgs, 0, false, null);
                                ((PrintWriter)catPw).println();
                                ActivityManagerService.this.mServices.dumpServicesLocked(null, catPw, emptyArgs, 0, false, false, null);
                                ((PrintWriter)catPw).println();
                                ActivityManagerService.this.dumpActivitiesLocked(null, catPw, emptyArgs, 0, false, false, null);
                                ((PrintWriter)catPw).flush();
                            }
                            dropBuilder.append(catSw.toString());
                            ActivityManagerService.this.addErrorToDropBox("lowmem", null, "system_server", null, null, tag.toString(), dropBuilder.toString(), null, null);
                            activityManagerService = ActivityManagerService.this;
                            synchronized (activityManagerService) {
                                long now = SystemClock.uptimeMillis();
                                if (ActivityManagerService.this.mLastMemUsageReportTime < now) {
                                    ActivityManagerService.this.mLastMemUsageReportTime = now;
                                }
                            }
                        }
                    };
                    thread.start();
                    break;
                }
                case 34: {
                    ActivityManagerService.this.dispatchUserSwitch((UserStartedState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 35: {
                    ActivityManagerService.this.continueUserSwitch((UserStartedState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 36: {
                    ActivityManagerService.this.timeoutUserSwitch((UserStartedState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 37: {
                    boolean nextState;
                    boolean bl = nextState = msg.arg1 != 0;
                    if (ActivityManagerService.this.mUpdateLock.isHeld() == nextState) break;
                    if (nextState) {
                        ActivityManagerService.this.mUpdateLock.acquire();
                        break;
                    }
                    ActivityManagerService.this.mUpdateLock.release();
                    break;
                }
                case 38: {
                    ActivityManagerService.this.writeGrantedUriPermissions();
                    break;
                }
                case 39: {
                    ActivityManagerService.this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, false);
                }
            }
        }
    };
    static final int COLLECT_PSS_BG_MSG = 1;
    final Handler mBgHandler = new Handler(BackgroundThread.getHandler().getLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int i = 0;
                    int num = 0;
                    long start = SystemClock.uptimeMillis();
                    long[] tmp = new long[1];
                    while (true) {
                        int pid;
                        int procState;
                        ProcessRecord proc;
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            if (i >= ActivityManagerService.this.mPendingPssProcesses.size()) {
                                ActivityManagerService.this.mPendingPssProcesses.clear();
                                return;
                            }
                            proc = ActivityManagerService.this.mPendingPssProcesses.get(i);
                            procState = proc.pssProcState;
                            if (proc.thread != null && procState == proc.setProcState) {
                                pid = proc.pid;
                            } else {
                                proc = null;
                                pid = 0;
                            }
                            ++i;
                            if (proc == null) continue;
                        }
                        long pss = Debug.getPss(pid, tmp);
                        ActivityManagerService activityManagerService2 = ActivityManagerService.this;
                        synchronized (activityManagerService2) {
                            if (proc.thread != null && proc.setProcState == procState && proc.pid == pid) {
                                ++num;
                                proc.lastPssTime = SystemClock.uptimeMillis();
                                proc.baseProcessTracker.addPss(pss, tmp[0], true, proc.pkgList);
                                if (proc.initialIdlePss == 0L) {
                                    proc.initialIdlePss = pss;
                                }
                                proc.lastPss = pss;
                                if (procState >= 9) {
                                    proc.lastCachedPss = pss;
                                }
                            }
                        }
                    }
                }
            }
        }
    };
    static final int LAST_DONE_VERSION = 10000;
    static final long[] DUMP_MEM_BUCKETS;
    static final int[] DUMP_MEM_OOM_ADJ;
    static final String[] DUMP_MEM_OOM_LABEL;
    static final String[] DUMP_MEM_OOM_COMPACT_LABEL;

    BroadcastQueue broadcastQueueForIntent(Intent intent) {
        boolean isFg = (intent.getFlags() & 0x10000000) != 0;
        return isFg ? this.mFgBroadcastQueue : this.mBgBroadcastQueue;
    }

    BroadcastRecord broadcastRecordForReceiverLocked(IBinder receiver) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            BroadcastRecord r = queue.getMatchingOrderedReceiver(receiver);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSystemProcess() {
        try {
            ActivityManagerService m = mSelf;
            ServiceManager.addService("activity", m, true);
            ServiceManager.addService("procstats", m.mProcessStats);
            ServiceManager.addService("meminfo", new MemBinder(m));
            ServiceManager.addService("gfxinfo", new GraphicsBinder(m));
            ServiceManager.addService("dbinfo", new DbBinder(m));
            ServiceManager.addService("cpuinfo", new CpuBinder(m));
            ServiceManager.addService("permission", new PermissionController(m));
            ApplicationInfo info = ActivityManagerService.mSelf.mContext.getPackageManager().getApplicationInfo("android", 1024);
            mSystemThread.installSystemApplicationInfo(info);
            ActivityManagerService activityManagerService = mSelf;
            synchronized (activityManagerService) {
                ProcessRecord app = mSelf.newProcessRecordLocked(info, info.processName, false);
                app.persistent = true;
                app.pid = MY_PID;
                app.maxAdj = -16;
                app.makeActive(mSystemThread.getApplicationThread(), ActivityManagerService.mSelf.mProcessStats);
                ActivityManagerService.mSelf.mProcessNames.put(app.processName, app.uid, app);
                SparseArray<ProcessRecord> sparseArray = ActivityManagerService.mSelf.mPidsSelfLocked;
                synchronized (sparseArray) {
                    ActivityManagerService.mSelf.mPidsSelfLocked.put(app.pid, app);
                }
                mSelf.updateLruProcessLocked(app, false, null);
                mSelf.updateOomAdjLocked();
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find android system package", e);
        }
    }

    public void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
        this.mStackSupervisor.setWindowManager(wm);
        wm.createStack(0, -1, 6, 1.0f);
    }

    public void startObservingNativeCrashes() {
        NativeCrashListener ncl = new NativeCrashListener();
        ncl.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Context main(int factoryTest) {
        ActivityThread at;
        ActivityManagerService m;
        AThread thr = new AThread();
        thr.start();
        AThread aThread = thr;
        synchronized (aThread) {
            while (thr.mService == null) {
                try {
                    thr.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        mSelf = m = thr.mService;
        mSystemThread = at = ActivityThread.systemMain();
        ContextImpl context = at.getSystemContext();
        ((Context)context).setTheme(16973931);
        m.mContext = context;
        m.mFactoryTest = factoryTest;
        m.mIntentFirewall = new IntentFirewall(m.new IntentFirewallInterface());
        m.mStackSupervisor = new ActivityStackSupervisor(m, context, thr.mLooper);
        m.mBatteryStatsService.publish(context);
        m.mUsageStatsService.publish(context);
        m.mAppOpsService.publish(context);
        AThread aThread2 = thr;
        synchronized (aThread2) {
            thr.mReady = true;
            thr.notifyAll();
        }
        m.startRunning(null, null, null, null);
        return context;
    }

    public static ActivityManagerService self() {
        return mSelf;
    }

    public IAppOpsService getAppOpsService() {
        return this.mAppOpsService;
    }

    private ActivityManagerService() {
        Slog.i(TAG, "Memory class: " + ActivityManager.staticGetMemoryClass());
        this.mFgBroadcastQueue = new BroadcastQueue(this, "foreground", 10000L, false);
        this.mBgBroadcastQueue = new BroadcastQueue(this, "background", 60000L, true);
        this.mBroadcastQueues[0] = this.mFgBroadcastQueue;
        this.mBroadcastQueues[1] = this.mBgBroadcastQueue;
        this.mServices = new ActiveServices(this);
        this.mProviderMap = new ProviderMap(this);
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        systemDir.mkdirs();
        this.mBatteryStatsService = new BatteryStatsService(new File(systemDir, "batterystats.bin").toString());
        this.mBatteryStatsService.getActiveStatistics().readLocked();
        this.mBatteryStatsService.getActiveStatistics().writeAsyncLocked();
        this.mOnBattery = this.mBatteryStatsService.getActiveStatistics().getIsOnBattery();
        this.mBatteryStatsService.getActiveStatistics().setCallback(this);
        this.mProcessStats = new ProcessStatsService(this, new File(systemDir, "procstats"));
        this.mUsageStatsService = new UsageStatsService(new File(systemDir, "usagestats").toString());
        this.mAppOpsService = new AppOpsService(new File(systemDir, "appops.xml"));
        this.mGrantFile = new AtomicFile(new File(systemDir, "urigrants.xml"));
        this.mHeadless = "1".equals(SystemProperties.get("ro.config.headless", "0"));
        this.mStartedUsers.put(0, new UserStartedState(new UserHandle(0), true));
        this.mUserLru.add(0);
        this.updateStartedUserArrayLocked();
        this.GL_ES_VERSION = SystemProperties.getInt("ro.opengles.version", 0);
        this.mConfiguration.setToDefaults();
        this.mConfiguration.setLocale(Locale.getDefault());
        this.mConfiguration.seq = 1;
        this.mConfigurationSeq = 1;
        this.mProcessCpuTracker.init();
        this.mCompatModePackages = new CompatModePackages(this, systemDir);
        Watchdog.getInstance().addMonitor(this);
        this.mProcessCpuThread = new Thread("CpuTracker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            try {
                                4 var1_1 = this;
                                synchronized (var1_1) {
                                    long now = SystemClock.uptimeMillis();
                                    long nextCpuDelay = ActivityManagerService.this.mLastCpuTime.get() + 0xFFFFFFFL - now;
                                    long nextWriteDelay = ActivityManagerService.this.mLastWriteTime + 1800000L - now;
                                    if (nextWriteDelay < nextCpuDelay) {
                                        nextCpuDelay = nextWriteDelay;
                                    }
                                    if (nextCpuDelay > 0L) {
                                        ActivityManagerService.this.mProcessCpuMutexFree.set(true);
                                        this.wait(nextCpuDelay);
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            ActivityManagerService.this.updateCpuStatsNow();
                        }
                    }
                    catch (Exception e) {
                        Slog.e(ActivityManagerService.TAG, "Unexpected exception collecting process stats", e);
                        continue;
                    }
                    break;
                }
            }
        };
        this.mProcessCpuThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1599295570) {
            ArrayList<IBinder> procs = new ArrayList<IBinder>();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int NP = this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.thread == null) continue;
                        procs.add(app.thread.asBinder());
                    }
                }
            }
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                Parcel data2 = Parcel.obtain();
                try {
                    ((IBinder)procs.get(i)).transact(1599295570, data2, null, 0);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                data2.recycle();
            }
        }
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Activity Manager Crash", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStats() {
        long now = SystemClock.uptimeMillis();
        if (this.mLastCpuTime.get() >= now - 5000L) {
            return;
        }
        if (this.mProcessCpuMutexFree.compareAndSet(true, false)) {
            Thread thread = this.mProcessCpuThread;
            synchronized (thread) {
                this.mProcessCpuThread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStatsNow() {
        Thread thread = this.mProcessCpuThread;
        synchronized (thread) {
            BatteryStatsImpl bstats;
            this.mProcessCpuMutexFree.set(false);
            long now = SystemClock.uptimeMillis();
            boolean haveNewCpuStats = false;
            if (this.mLastCpuTime.get() < now - 5000L) {
                this.mLastCpuTime.set(now);
                haveNewCpuStats = true;
                this.mProcessCpuTracker.update();
                if ("true".equals(SystemProperties.get("events.cpu"))) {
                    int idle;
                    int softIrq;
                    int irq;
                    int iowait;
                    int system;
                    int user = this.mProcessCpuTracker.getLastUserTime();
                    int total = user + (system = this.mProcessCpuTracker.getLastSystemTime()) + (iowait = this.mProcessCpuTracker.getLastIoWaitTime()) + (irq = this.mProcessCpuTracker.getLastIrqTime()) + (softIrq = this.mProcessCpuTracker.getLastSoftIrqTime()) + (idle = this.mProcessCpuTracker.getLastIdleTime());
                    if (total == 0) {
                        total = 1;
                    }
                    EventLog.writeEvent(2721, (user + system + iowait + irq + softIrq) * 100 / total, user * 100 / total, system * 100 / total, iowait * 100 / total, irq * 100 / total, softIrq * 100 / total);
                }
            }
            long[] cpuSpeedTimes = this.mProcessCpuTracker.getLastCpuSpeedTimes();
            BatteryStatsImpl batteryStatsImpl = bstats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    if (haveNewCpuStats && this.mOnBattery) {
                        int perc = bstats.startAddingCpuLocked();
                        int totalUTime = 0;
                        int totalSTime = 0;
                        int N = this.mProcessCpuTracker.countStats();
                        for (int i = 0; i < N; ++i) {
                            BatteryStatsImpl.Uid.Proc ps;
                            ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                            if (!st.working) continue;
                            ProcessRecord pr = this.mPidsSelfLocked.get(st.pid);
                            int otherUTime = st.rel_utime * perc / 100;
                            int otherSTime = st.rel_stime * perc / 100;
                            totalUTime += otherUTime;
                            totalSTime += otherSTime;
                            if (pr != null) {
                                ps = bstats.getProcessStatsLocked(st.name, st.pid);
                                ps.addCpuTimeLocked(st.rel_utime - otherUTime, st.rel_stime - otherSTime);
                                ps.addSpeedStepTimes(cpuSpeedTimes);
                                pr.curCpuTime += (long)((st.rel_utime + st.rel_stime) * 10);
                                continue;
                            }
                            if (st.uid >= 10000) {
                                ps = st.batteryStats;
                                if (ps == null) {
                                    st.batteryStats = ps = bstats.getProcessStatsLocked(st.uid, "(Unknown)");
                                }
                                ps.addCpuTimeLocked(st.rel_utime - otherUTime, st.rel_stime - otherSTime);
                                ps.addSpeedStepTimes(cpuSpeedTimes);
                                continue;
                            }
                            ps = bstats.getProcessStatsLocked(st.name, st.pid);
                            if (ps == null) continue;
                            ps.addCpuTimeLocked(st.rel_utime - otherUTime, st.rel_stime - otherSTime);
                            ps.addSpeedStepTimes(cpuSpeedTimes);
                        }
                        bstats.finishAddingCpuLocked(perc, totalUTime, totalSTime, cpuSpeedTimes);
                    }
                }
                if (this.mLastWriteTime < now - 1800000L) {
                    this.mLastWriteTime = now;
                    this.mBatteryStatsService.getActiveStatistics().writeAsyncLocked();
                }
            }
        }
    }

    @Override
    public void batteryNeedsCpuUpdate() {
        this.updateCpuStatsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batteryPowerChanged(boolean onBattery) {
        this.updateCpuStatsNow();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mOnBattery = onBattery;
            }
        }
    }

    private HashMap<String, IBinder> getCommonServicesLocked() {
        if (this.mAppBindArgs == null) {
            this.mAppBindArgs = new HashMap();
            this.mAppBindArgs.put("package", ServiceManager.getService("package"));
            this.mAppBindArgs.put("window", ServiceManager.getService("window"));
            this.mAppBindArgs.put("alarm", ServiceManager.getService("alarm"));
        }
        return this.mAppBindArgs;
    }

    final void setFocusedActivityLocked(ActivityRecord r) {
        if (this.mFocusedActivity != r) {
            this.mFocusedActivity = r;
            this.mStackSupervisor.setFocusedStack(r);
            if (r != null) {
                this.mWindowManager.setFocusedApp(r.appToken, true);
            }
            this.applyUpdateLockStateLocked(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedStack(int stackId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r;
            ActivityStack stack = this.mStackSupervisor.getStack(stackId);
            if (stack != null && (r = stack.topRunningActivityLocked(null)) != null) {
                this.setFocusedActivityLocked(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActivityDrawn(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mStackSupervisor.isInAnyStackLocked(token);
            if (r != null) {
                r.task.stack.notifyActivityDrawnLocked(r);
            }
        }
    }

    final void applyUpdateLockStateLocked(ActivityRecord r) {
        boolean nextState = r != null && r.immersive;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(37, nextState ? 1 : 0, 0, r));
    }

    final void showAskCompatModeDialogLocked(ActivityRecord r) {
        Message msg = Message.obtain();
        msg.what = 30;
        msg.obj = r.task.askedCompatMode ? null : r;
        this.mHandler.sendMessage(msg);
    }

    private final int updateLruProcessInternalLocked(ProcessRecord app, long now, int index, String what, Object obj, ProcessRecord srcApp) {
        app.lastActivityTime = now;
        if (app.activities.size() > 0) {
            return index;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui < 0) {
            Slog.wtf(TAG, "Adding dependent process " + app + " not on LRU list: " + what + " " + obj + " from " + srcApp);
            return index;
        }
        if (lrui >= index) {
            return index;
        }
        if (lrui >= this.mLruProcessActivityStart) {
            return index;
        }
        this.mLruProcesses.remove(lrui);
        if (index > 0) {
            --index;
        }
        this.mLruProcesses.add(index, app);
        return index;
    }

    final void removeLruProcessLocked(ProcessRecord app) {
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui >= 0) {
            if (lrui <= this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui <= this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
    }

    final void updateLruProcessLocked(ProcessRecord app, boolean activityChange, ProcessRecord client) {
        int j;
        int nextIndex;
        int N;
        long now;
        boolean hasActivity = app.activities.size() > 0 || app.hasClientActivities;
        boolean hasService = false;
        if (!activityChange && hasActivity) {
            return;
        }
        ++this.mLruSeq;
        app.lastActivityTime = now = SystemClock.uptimeMillis();
        if (hasActivity ? (N = this.mLruProcesses.size()) > 0 && this.mLruProcesses.get(N - 1) == app : this.mLruProcessServiceStart > 0 && this.mLruProcesses.get(this.mLruProcessServiceStart - 1) == app) {
            return;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (app.persistent && lrui >= 0) {
            return;
        }
        if (lrui >= 0) {
            if (lrui < this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui < this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
        if (hasActivity) {
            int N2 = this.mLruProcesses.size();
            if (app.activities.size() == 0 && this.mLruProcessActivityStart < N2 - 1) {
                this.mLruProcesses.add(N2 - 1, app);
                int uid = app.info.uid;
                for (int i = N2 - 2; i > this.mLruProcessActivityStart; --i) {
                    ProcessRecord subProc = this.mLruProcesses.get(i);
                    if (subProc.info.uid == uid) {
                        if (this.mLruProcesses.get((int)(i - 1)).info.uid == uid) continue;
                        ProcessRecord tmp = this.mLruProcesses.get(i);
                        this.mLruProcesses.set(i, this.mLruProcesses.get(i - 1));
                        this.mLruProcesses.set(i - 1, tmp);
                        --i;
                        continue;
                    }
                    break;
                }
            } else {
                this.mLruProcesses.add(app);
            }
            nextIndex = this.mLruProcessServiceStart;
        } else {
            int index = this.mLruProcessServiceStart;
            if (client != null) {
                int clientIndex = this.mLruProcesses.lastIndexOf(client);
                if (clientIndex <= lrui) {
                    clientIndex = lrui;
                }
                if (clientIndex >= 0 && index > clientIndex) {
                    index = clientIndex;
                }
            }
            this.mLruProcesses.add(index, app);
            nextIndex = index - 1;
            ++this.mLruProcessActivityStart;
            ++this.mLruProcessServiceStart;
        }
        for (j = app.connections.size() - 1; j >= 0; --j) {
            ConnectionRecord cr = app.connections.valueAt(j);
            if (cr.binding == null || cr.serviceDead || cr.binding.service == null || cr.binding.service.app == null || cr.binding.service.app.lruSeq == this.mLruSeq || cr.binding.service.app.persistent) continue;
            nextIndex = this.updateLruProcessInternalLocked(cr.binding.service.app, now, nextIndex, "service connection", cr, app);
        }
        for (j = app.conProviders.size() - 1; j >= 0; --j) {
            ContentProviderRecord cpr = app.conProviders.get((int)j).provider;
            if (cpr.proc == null || cpr.proc.lruSeq == this.mLruSeq || cpr.proc.persistent) continue;
            nextIndex = this.updateLruProcessInternalLocked(cpr.proc, now, nextIndex, "provider reference", cpr, app);
        }
    }

    final ProcessRecord getProcessRecordLocked(String processName, int uid, boolean keepIfLarge) {
        ProcessRecord proc;
        if (uid == 1000) {
            SparseArray<ProcessRecord> procs = this.mProcessNames.getMap().get(processName);
            if (procs == null) {
                return null;
            }
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                if (!UserHandle.isSameUser(procs.keyAt(i), uid)) continue;
                return procs.valueAt(i);
            }
        }
        if ((proc = this.mProcessNames.get(processName, uid)) != null && !keepIfLarge && this.mLastMemoryLevel > 0 && proc.setProcState >= 13 && proc.lastCachedPss >= this.mProcessList.getCachedRestoreThresholdKb()) {
            if (proc.baseProcessTracker != null) {
                proc.baseProcessTracker.reportCachedKill(proc.pkgList, proc.lastCachedPss);
            }
            this.killUnneededProcessLocked(proc, Long.toString(proc.lastCachedPss) + "k from cached");
        }
        return proc;
    }

    void ensurePackageDexOpt(String packageName) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            if (pm.performDexOpt(packageName)) {
                this.mDidDexOpt = true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    boolean isNextTransitionForward() {
        int transit = this.mWindowManager.getPendingAppTransition();
        return transit == 4102 || transit == 4104 || transit == 4106;
    }

    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, String hostingType, ComponentName hostingName, boolean allowWhileBooting, boolean isolated, boolean keepIfLarge) {
        String hostingNameStr;
        ProcessRecord app = !isolated ? this.getProcessRecordLocked(processName, info.uid, keepIfLarge) : null;
        if (app != null && app.pid > 0) {
            if (!knownToBeDead || app.thread == null) {
                app.addPackage(info.packageName, this.mProcessStats);
                return app;
            }
            this.handleAppDiedLocked(app, true, true);
        }
        String string2 = hostingNameStr = hostingName != null ? hostingName.flattenToShortString() : null;
        if (!isolated) {
            if ((intentFlags & 4) != 0) {
                if (this.mBadProcesses.get(info.processName, info.uid) != null) {
                    return null;
                }
            } else {
                this.mProcessCrashTimes.remove(info.processName, info.uid);
                if (this.mBadProcesses.get(info.processName, info.uid) != null) {
                    EventLog.writeEvent(30016, UserHandle.getUserId(info.uid), info.uid, info.processName);
                    this.mBadProcesses.remove(info.processName, info.uid);
                    if (app != null) {
                        app.bad = false;
                    }
                }
            }
        }
        if (app == null) {
            app = this.newProcessRecordLocked(info, processName, isolated);
            if (app == null) {
                Slog.w(TAG, "Failed making new process record for " + processName + "/" + info.uid + " isolated=" + isolated);
                return null;
            }
            this.mProcessNames.put(processName, app.uid, app);
            if (isolated) {
                this.mIsolatedProcesses.put(app.uid, app);
            }
        } else {
            app.addPackage(info.packageName, this.mProcessStats);
        }
        if (!(this.mProcessesReady || this.isAllowedWhileBooting(info) || allowWhileBooting)) {
            if (!this.mProcessesOnHold.contains(app)) {
                this.mProcessesOnHold.add(app);
            }
            return app;
        }
        this.startProcessLocked(app, hostingType, hostingNameStr);
        return app.pid != 0 ? app : null;
    }

    boolean isAllowedWhileBooting(ApplicationInfo ai) {
        return (ai.flags & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startProcessLocked(ProcessRecord app, String hostingType, String hostingNameStr) {
        if (app.pid > 0 && app.pid != MY_PID) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, app);
            }
            app.setPid(0);
        }
        this.mProcessesOnHold.remove(app);
        this.updateCpuStats();
        try {
            BatteryStatsImpl bs;
            int uid = app.uid;
            int[] gids = null;
            int mountExternal = 0;
            if (!app.isolated) {
                int[] permGids = null;
                try {
                    PackageManager pm = this.mContext.getPackageManager();
                    permGids = pm.getPackageGids(app.info.packageName);
                    if (Environment.isExternalStorageEmulated()) {
                        mountExternal = pm.checkPermission("android.permission.ACCESS_ALL_EXTERNAL_STORAGE", app.info.packageName) == 0 ? 3 : 2;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(TAG, "Unable to retrieve gids", e);
                }
                if (permGids == null) {
                    gids = new int[1];
                } else {
                    gids = new int[permGids.length + 1];
                    System.arraycopy(permGids, 0, gids, 1, permGids.length);
                }
                gids[0] = UserHandle.getSharedAppGid(UserHandle.getAppId(uid));
            }
            if (this.mFactoryTest != 0) {
                if (this.mFactoryTest == 1 && this.mTopComponent != null && app.processName.equals(this.mTopComponent.getPackageName())) {
                    uid = 0;
                }
                if (this.mFactoryTest == 2 && (app.info.flags & 0x10) != 0) {
                    uid = 0;
                }
            }
            int debugFlags = 0;
            if ((app.info.flags & 2) != 0) {
                debugFlags |= 1;
                debugFlags |= 2;
            }
            if ((app.info.flags & 0x4000) != 0 || Zygote.systemInSafeMode) {
                debugFlags |= 8;
            }
            if ("1".equals(SystemProperties.get("debug.checkjni"))) {
                debugFlags |= 2;
            }
            if ("1".equals(SystemProperties.get("debug.jni.logging"))) {
                debugFlags |= 0x10;
            }
            if ("1".equals(SystemProperties.get("debug.assert"))) {
                debugFlags |= 4;
            }
            Process.ProcessStartResult startResult = Process.start("android.app.ActivityThread", app.processName, uid, uid, gids, debugFlags, mountExternal, app.info.targetSdkVersion, app.info.seinfo, null);
            BatteryStatsImpl batteryStatsImpl = bs = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                if (bs.isOnBattery()) {
                    bs.getProcessStatsLocked(app.uid, app.processName).incStartsLocked();
                }
            }
            EventLog.writeEvent(30014, UserHandle.getUserId(uid), startResult.pid, uid, app.processName, hostingType, hostingNameStr != null ? hostingNameStr : "");
            if (app.persistent) {
                Watchdog.getInstance().processStarted(app.processName, startResult.pid);
            }
            StringBuilder buf = this.mStringBuilder;
            buf.setLength(0);
            buf.append("Start proc ");
            buf.append(app.processName);
            buf.append(" for ");
            buf.append(hostingType);
            if (hostingNameStr != null) {
                buf.append(" ");
                buf.append(hostingNameStr);
            }
            buf.append(": pid=");
            buf.append(startResult.pid);
            buf.append(" uid=");
            buf.append(uid);
            buf.append(" gids={");
            if (gids != null) {
                for (int gi = 0; gi < gids.length; ++gi) {
                    if (gi != 0) {
                        buf.append(", ");
                    }
                    buf.append(gids[gi]);
                }
            }
            buf.append("}");
            Slog.i(TAG, buf.toString());
            app.setPid(startResult.pid);
            app.usingWrapper = startResult.usingWrapper;
            app.removed = false;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.put(startResult.pid, app);
                Message msg = this.mHandler.obtainMessage(20);
                msg.obj = app;
                this.mHandler.sendMessageDelayed(msg, startResult.usingWrapper ? 300000L : 10000L);
            }
        }
        catch (RuntimeException e) {
            app.setPid(0);
            Slog.e(TAG, "Failure starting process " + app.processName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUsageStats(ActivityRecord component, boolean resumed) {
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        if (resumed) {
            this.mUsageStatsService.noteResumeComponent(component.realActivity);
            BatteryStatsImpl batteryStatsImpl = stats;
            synchronized (batteryStatsImpl) {
                stats.noteActivityResumedLocked(component.app.uid);
            }
        }
        this.mUsageStatsService.notePauseComponent(component.realActivity);
        BatteryStatsImpl batteryStatsImpl = stats;
        synchronized (batteryStatsImpl) {
            stats.noteActivityPausedLocked(component.app.uid);
        }
    }

    Intent getHomeIntent() {
        Intent intent = new Intent(this.mTopAction, this.mTopData != null ? Uri.parse(this.mTopData) : null);
        intent.setComponent(this.mTopComponent);
        if (this.mFactoryTest != 1) {
            intent.addCategory("android.intent.category.HOME");
        }
        return intent;
    }

    boolean startHomeActivityLocked(int userId) {
        if (this.mHeadless) {
            this.ensureBootCompleted();
            return false;
        }
        if (this.mFactoryTest == 1 && this.mTopAction == null) {
            return false;
        }
        Intent intent = this.getHomeIntent();
        ActivityInfo aInfo = this.resolveActivityInfo(intent, 1024, userId);
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            aInfo = new ActivityInfo(aInfo);
            aInfo.applicationInfo = this.getAppInfoForUser(aInfo.applicationInfo, userId);
            ProcessRecord app = this.getProcessRecordLocked(aInfo.processName, aInfo.applicationInfo.uid, true);
            if (app == null || app.instrumentationClass == null) {
                intent.setFlags(intent.getFlags() | 0x10000000);
                this.mStackSupervisor.startHomeActivity(intent, aInfo);
            }
        }
        return true;
    }

    private ActivityInfo resolveActivityInfo(Intent intent, int flags, int userId) {
        ActivityInfo ai = null;
        ComponentName comp = intent.getComponent();
        try {
            if (comp != null) {
                ai = AppGlobals.getPackageManager().getActivityInfo(comp, flags, userId);
            } else {
                ResolveInfo info = AppGlobals.getPackageManager().resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
                if (info != null) {
                    ai = info.activityInfo;
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return ai;
    }

    void startSetupActivityLocked() {
        if (this.mCheckedForSetup) {
            return;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        if (this.mFactoryTest != 1 && Settings.Global.getInt(resolver, "device_provisioned", 0) != 0) {
            this.mCheckedForSetup = true;
            Intent intent = new Intent("android.intent.action.UPGRADE_SETUP");
            List<ResolveInfo> ris = ActivityManagerService.mSelf.mContext.getPackageManager().queryIntentActivities(intent, 128);
            ResolveInfo ri = null;
            for (int i = 0; ris != null && i < ris.size(); ++i) {
                if ((ris.get((int)i).activityInfo.applicationInfo.flags & 1) == 0) continue;
                ri = ris.get(i);
                break;
            }
            if (ri != null) {
                String vers;
                String string2 = vers = ri.activityInfo.metaData != null ? ri.activityInfo.metaData.getString("android.SETUP_VERSION") : null;
                if (vers == null && ri.activityInfo.applicationInfo.metaData != null) {
                    vers = ri.activityInfo.applicationInfo.metaData.getString("android.SETUP_VERSION");
                }
                String lastVers = Settings.Secure.getString(resolver, "last_setup_shown");
                if (vers != null && !vers.equals(lastVers)) {
                    intent.setFlags(0x10000000);
                    intent.setComponent(new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name));
                    this.mStackSupervisor.startActivityLocked(null, intent, null, ri.activityInfo, null, null, 0, 0, 0, null, 0, null, false, null);
                }
            }
        }
    }

    CompatibilityInfo compatibilityInfoForPackageLocked(ApplicationInfo ai) {
        return this.mCompatModePackages.compatibilityInfoForPackageLocked(ai);
    }

    void enforceNotIsolatedCaller(String caller) {
        if (UserHandle.isIsolated(Binder.getCallingUid())) {
            throw new SecurityException("Isolated process not allowed to call " + caller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrontActivityScreenCompatMode() {
        this.enforceNotIsolatedCaller("getFrontActivityScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getFrontActivityScreenCompatModeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrontActivityScreenCompatMode(int mode) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setFrontActivityScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setFrontActivityScreenCompatModeLocked(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageScreenCompatMode(String packageName) {
        this.enforceNotIsolatedCaller("getPackageScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageScreenCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageScreenCompatMode(String packageName, int mode) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setPackageScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageScreenCompatModeLocked(packageName, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPackageAskScreenCompat(String packageName) {
        this.enforceNotIsolatedCaller("getPackageAskScreenCompat");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageAskCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageAskScreenCompat(String packageName, boolean ask) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setPackageAskScreenCompat");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageAskCompatModeLocked(packageName, ask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProcessesChanged() {
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            N = this.mPendingProcessChanges.size();
            if (this.mActiveProcessChanges.length < N) {
                this.mActiveProcessChanges = new ProcessChangeItem[N];
            }
            this.mPendingProcessChanges.toArray(this.mActiveProcessChanges);
            this.mAvailProcessChanges.addAll(this.mPendingProcessChanges);
            this.mPendingProcessChanges.clear();
        }
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                for (int j = 0; j < N; ++j) {
                    ProcessChangeItem item = this.mActiveProcessChanges[j];
                    if ((item.changes & 1) != 0) {
                        observer.onForegroundActivitiesChanged(item.pid, item.uid, item.foregroundActivities);
                    }
                    if ((item.changes & 2) == 0) continue;
                    observer.onImportanceChanged(item.pid, item.uid, item.importance);
                }
            }
            catch (RemoteException e) {
            }
        }
        this.mProcessObservers.finishBroadcast();
    }

    private void dispatchProcessDied(int pid, int uid) {
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                observer.onProcessDied(pid, uid);
            }
            catch (RemoteException e) {}
        }
        this.mProcessObservers.finishBroadcast();
    }

    final void doPendingActivityLaunchesLocked(boolean doResume) {
        int N = this.mPendingActivityLaunches.size();
        if (N <= 0) {
            return;
        }
        for (int i = 0; i < N; ++i) {
            PendingActivityLaunch pal = this.mPendingActivityLaunches.get(i);
            this.mStackSupervisor.startActivityUncheckedLocked(pal.r, pal.sourceRecord, pal.startFlags, doResume && i == N - 1, null);
        }
        this.mPendingActivityLaunches.clear();
    }

    @Override
    public final int startActivity(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, String profileFile, ParcelFileDescriptor profileFd, Bundle options) {
        return this.startActivityAsUser(caller, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profileFile, profileFd, options, UserHandle.getCallingUserId());
    }

    @Override
    public final int startActivityAsUser(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, String profileFile, ParcelFileDescriptor profileFd, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivity");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "startActivity", null);
        return this.mStackSupervisor.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profileFile, profileFd, null, null, options, userId);
    }

    @Override
    public final IActivityManager.WaitResult startActivityAndWait(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, String profileFile, ParcelFileDescriptor profileFd, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivityAndWait");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "startActivityAndWait", null);
        IActivityManager.WaitResult res = new IActivityManager.WaitResult();
        this.mStackSupervisor.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profileFile, profileFd, res, null, options, UserHandle.getCallingUserId());
        return res;
    }

    @Override
    public final int startActivityWithConfig(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, Configuration config, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivityWithConfig");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "startActivityWithConfig", null);
        int ret = this.mStackSupervisor.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, null, null, null, config, options, userId);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startActivityIntentSender(IApplicationThread caller, IntentSender intent, Intent fillInIntent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int flagsMask, int flagsValues, Bundle options) {
        this.enforceNotIsolatedCaller("startActivityIntentSender");
        if (fillInIntent != null && fillInIntent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        IIntentSender sender = intent.getTarget();
        if (!(sender instanceof PendingIntentRecord)) {
            throw new IllegalArgumentException("Bad PendingIntent object");
        }
        PendingIntentRecord pir = (PendingIntentRecord)sender;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = this.getFocusedStack();
            if (stack.mResumedActivity != null && stack.mResumedActivity.info.applicationInfo.uid == Binder.getCallingUid()) {
                this.mAppSwitchesAllowedTime = 0L;
            }
        }
        int ret = pir.sendInner(0, fillInIntent, resolvedType, null, null, resultTo, resultWho, requestCode, flagsMask, flagsValues, options);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startNextMatchingActivity(IBinder callingActivity, Intent intent, Bundle options) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(callingActivity);
            if (r == null) {
                ActivityOptions.abort(options);
                return false;
            }
            if (r.app == null || r.app.thread == null) {
                ActivityOptions.abort(options);
                return false;
            }
            intent = new Intent(intent);
            intent.setDataAndType(r.intent.getData(), r.intent.getType());
            intent.setComponent(null);
            boolean debug = (intent.getFlags() & 8) != 0;
            ActivityInfo aInfo = null;
            try {
                List<ResolveInfo> resolves = AppGlobals.getPackageManager().queryIntentActivities(intent, r.resolvedType, 66560, UserHandle.getCallingUserId());
                int N = resolves != null ? resolves.size() : 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo rInfo = resolves.get(i);
                    if (!rInfo.activityInfo.packageName.equals(r.packageName) || !rInfo.activityInfo.name.equals(r.info.name)) continue;
                    if (++i < N) {
                        aInfo = resolves.get((int)i).activityInfo;
                    }
                    if (debug) {
                        Slog.v(TAG, "Next matching activity: found current " + r.packageName + "/" + r.info.name);
                        Slog.v(TAG, "Next matching activity: next is " + aInfo.packageName + "/" + aInfo.name);
                    }
                    break;
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            if (aInfo == null) {
                ActivityOptions.abort(options);
                if (debug) {
                    Slog.d(TAG, "Next matching activity: nothing found");
                }
                return false;
            }
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            intent.setFlags(intent.getFlags() & 0xE1FFFFFF);
            boolean wasFinishing = r.finishing;
            r.finishing = true;
            ActivityRecord resultTo = r.resultTo;
            String resultWho = r.resultWho;
            int requestCode = r.requestCode;
            r.resultTo = null;
            if (resultTo != null) {
                resultTo.removeResultsLocked(r, resultWho, requestCode);
            }
            long origId = Binder.clearCallingIdentity();
            int res = this.mStackSupervisor.startActivityLocked(r.app.thread, intent, r.resolvedType, aInfo, resultTo != null ? resultTo.appToken : null, resultWho, requestCode, -1, r.launchedFromUid, r.launchedFromPackage, 0, options, false, null);
            Binder.restoreCallingIdentity(origId);
            r.finishing = wasFinishing;
            return res == 0;
            {
            }
        }
    }

    final int startActivityInPackage(int uid, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, Bundle options, int userId) {
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "startActivityInPackage", null);
        int ret = this.mStackSupervisor.startActivityMayWait(null, uid, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, null, null, null, null, options, userId);
        return ret;
    }

    @Override
    public final int startActivities(IApplicationThread caller, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivities");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "startActivity", null);
        int ret = this.mStackSupervisor.startActivities(caller, -1, callingPackage, intents, resolvedTypes, resultTo, options, userId);
        return ret;
    }

    final int startActivitiesInPackage(int uid, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle options, int userId) {
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "startActivityInPackage", null);
        int ret = this.mStackSupervisor.startActivities(null, uid, callingPackage, intents, resolvedTypes, resultTo, options, userId);
        return ret;
    }

    final void addRecentTaskLocked(TaskRecord task) {
        int N = this.mRecentTasks.size();
        if (N > 0 && this.mRecentTasks.get(0) == task) {
            return;
        }
        for (int i = 0; i < N; ++i) {
            TaskRecord tr = this.mRecentTasks.get(i);
            if (task.userId != tr.userId || (task.affinity == null || !task.affinity.equals(tr.affinity)) && (task.intent == null || !task.intent.filterEquals(tr.intent))) continue;
            tr.disposeThumbnail();
            this.mRecentTasks.remove(i);
            --i;
            --N;
            if (task.intent != null) continue;
            task = tr;
        }
        if (N >= MAX_RECENT_TASKS) {
            this.mRecentTasks.remove(N - 1).disposeThumbnail();
        }
        this.mRecentTasks.add(0, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportActivityFullyDrawn(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return;
            }
            r.reportFullyDrawnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(IBinder token, int requestedOrientation) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.mWindowManager.setAppOrientation(r.appToken, requestedOrientation);
            Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.mConfiguration, r.mayFreezeScreenLocked(r.app) ? r.appToken : null);
            if (config != null) {
                r.frozenBeforeDestroy = true;
                if (!this.updateConfigurationLocked(config, r, false, false)) {
                    this.mStackSupervisor.resumeTopActivitiesLocked();
                }
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return -1;
            }
            return this.mWindowManager.getAppOrientation(r.appToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean finishActivity(IBinder token, int resultCode, Intent resultData) {
        if (resultData != null && resultData.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord next;
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return true;
            }
            if (this.mController != null && (next = r.task.stack.topRunningActivityLocked(token, 0)) != null) {
                boolean resumeOK = true;
                try {
                    resumeOK = this.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
                if (!resumeOK) {
                    return false;
                }
            }
            long origId = Binder.clearCallingIdentity();
            boolean res = r.task.stack.requestFinishActivityLocked(token, resultCode, resultData, "app-request", true);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finishHeavyWeightApp() {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: finishHeavyWeightApp() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mHeavyWeightProcess == null) {
                return;
            }
            ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>(this.mHeavyWeightProcess.activities);
            for (int i = 0; i < activities.size(); ++i) {
                ActivityRecord r = activities.get(i);
                if (r.finishing) continue;
                r.task.stack.finishActivityLocked(r, 0, null, "finish-heavy", true);
            }
            this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
            this.mHeavyWeightProcess = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crashApplication(int uid, int initialPid, String packageName, String message) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: crashApplication() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc = null;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                for (int i = 0; i < this.mPidsSelfLocked.size(); ++i) {
                    ProcessRecord p = this.mPidsSelfLocked.valueAt(i);
                    if (p.uid != uid) continue;
                    if (p.pid == initialPid) {
                        proc = p;
                        break;
                    }
                    if (!p.pkgList.containsKey(packageName)) continue;
                    proc = p;
                }
            }
            if (proc == null) {
                Slog.w(TAG, "crashApplication: nothing for uid=" + uid + " initialPid=" + initialPid + " packageName=" + packageName);
                return;
            }
            if (proc.thread != null) {
                if (proc.pid == Process.myPid()) {
                    Log.w(TAG, "crashApplication: trying to crash self!");
                    return;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    proc.thread.scheduleCrash(message);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finishSubActivity(IBinder token, String resultWho, int requestCode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                r.task.stack.finishSubActivityLocked(r, resultWho, requestCode);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finishActivityAffinity(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            boolean res = false;
            if (r != null) {
                res = r.task.stack.finishActivityAffinityLocked(r);
            }
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean willActivityBeVisible(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                return stack.willActivityBeVisibleLocked(token);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord self = ActivityRecord.isInStackLocked(token);
            if (self == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            if (self.state == ActivityStack.ActivityState.RESUMED || self.state == ActivityStack.ActivityState.PAUSING) {
                this.mWindowManager.overridePendingAppTransition(packageName, enterAnim, exitAnim, null);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    private final void handleAppDiedLocked(ProcessRecord app, boolean restarting, boolean allowRestart) {
        this.cleanUpApplicationRecordLocked(app, restarting, allowRestart, -1);
        if (!restarting) {
            this.removeLruProcessLocked(app);
        }
        if (this.mProfileProc == app) {
            this.clearProfilerLocked();
        }
        boolean hasVisibleActivities = this.mStackSupervisor.handleAppDiedLocked(app);
        app.activities.clear();
        if (app.instrumentationClass != null) {
            Slog.w(TAG, "Crash of app " + app.processName + " running instrumentation " + app.instrumentationClass);
            Bundle info = new Bundle();
            info.putString("shortMsg", "Process crashed.");
            this.finishInstrumentationLocked(app, 0, info);
        }
        if (!restarting && !this.mStackSupervisor.resumeTopActivitiesLocked() && hasVisibleActivities) {
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0);
        }
    }

    private final int getLRURecordIndexForAppLocked(IApplicationThread thread) {
        IBinder threadBinder = thread.asBinder();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.thread.asBinder() != threadBinder) continue;
            return i;
        }
        return -1;
    }

    final ProcessRecord getRecordForAppLocked(IApplicationThread thread) {
        if (thread == null) {
            return null;
        }
        int appIndex = this.getLRURecordIndexForAppLocked(thread);
        return appIndex >= 0 ? this.mLruProcesses.get(appIndex) : null;
    }

    final void doLowMemReportIfNeededLocked(ProcessRecord dyingProc) {
        boolean haveBg = false;
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.setProcState < 11) continue;
            haveBg = true;
            break;
        }
        if (!haveBg) {
            boolean doReport = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (doReport) {
                long now = SystemClock.uptimeMillis();
                if (now < this.mLastMemUsageReportTime + 300000L) {
                    doReport = false;
                } else {
                    this.mLastMemUsageReportTime = now;
                }
            }
            ArrayList<ProcessMemInfo> memInfos = doReport ? new ArrayList<ProcessMemInfo>(this.mLruProcesses.size()) : null;
            EventLog.writeEvent(30017, this.mLruProcesses.size());
            long now = SystemClock.uptimeMillis();
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord rec = this.mLruProcesses.get(i);
                if (rec == dyingProc || rec.thread == null) continue;
                if (doReport) {
                    memInfos.add(new ProcessMemInfo(rec.processName, rec.pid, rec.setAdj, rec.setProcState, rec.adjType, rec.makeAdjReason()));
                }
                if (rec.lastLowMemory + 60000L > now) continue;
                rec.lastRequestedGc = rec.setAdj <= 4 ? 0L : rec.lastLowMemory;
                rec.reportLowMemory = true;
                rec.lastLowMemory = now;
                this.mProcessesToGc.remove(rec);
                this.addProcessToGcListLocked(rec);
            }
            if (doReport) {
                Message msg = this.mHandler.obtainMessage(33, memInfos);
                this.mHandler.sendMessage(msg);
            }
            this.scheduleAppGcsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appDiedLocked(ProcessRecord app, int pid, IApplicationThread thread) {
        BatteryStatsImpl stats;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            stats.noteProcessDiedLocked(app.info.uid, pid);
        }
        if (app.pid == pid && app.thread != null && app.thread.asBinder() == thread.asBinder()) {
            boolean doLowMem;
            boolean doOomAdj = doLowMem = app.instrumentationClass == null;
            if (!app.killedByAm) {
                Slog.i(TAG, "Process " + app.processName + " (pid " + pid + ") has died.");
                this.mAllowLowerMemLevel = true;
            } else {
                this.mAllowLowerMemLevel = false;
                doLowMem = false;
            }
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName);
            this.handleAppDiedLocked(app, false, true);
            if (doOomAdj) {
                this.updateOomAdjLocked();
            }
            if (doLowMem) {
                this.doLowMemReportIfNeededLocked(app);
            }
        } else if (app.pid != pid) {
            Slog.i(TAG, "Process " + app.processName + " (pid " + pid + ") has died and restarted (pid " + app.pid + ").");
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName);
        }
    }

    public static File dumpStackTraces(boolean clearTraces, ArrayList<Integer> firstPids, ProcessCpuTracker processCpuTracker, SparseArray<Boolean> lastPids, String[] nativeProcs) {
        String tracesPath = SystemProperties.get("dalvik.vm.stack-trace-file", null);
        if (tracesPath == null || tracesPath.length() == 0) {
            return null;
        }
        File tracesFile = new File(tracesPath);
        try {
            File tracesDir = tracesFile.getParentFile();
            if (!tracesDir.exists()) {
                tracesFile.mkdirs();
                if (!SELinux.restorecon(tracesDir)) {
                    return null;
                }
            }
            FileUtils.setPermissions(tracesDir.getPath(), 509, -1, -1);
            if (clearTraces && tracesFile.exists()) {
                tracesFile.delete();
            }
            tracesFile.createNewFile();
            FileUtils.setPermissions(tracesFile.getPath(), 438, -1, -1);
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to prepare ANR traces file: " + tracesPath, e);
            return null;
        }
        ActivityManagerService.dumpStackTraces(tracesPath, firstPids, processCpuTracker, lastPids, nativeProcs);
        return tracesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpStackTraces(String tracesPath, ArrayList<Integer> firstPids, ProcessCpuTracker processCpuTracker, SparseArray<Boolean> lastPids, String[] nativeProcs) {
        FileObserver observer = new FileObserver(tracesPath, 8){

            public synchronized void onEvent(int event, String path) {
                this.notify();
            }
        };
        try {
            int[] pids2;
            observer.startWatching();
            if (firstPids != null) {
                try {
                    int num = firstPids.size();
                    for (int i = 0; i < num; ++i) {
                        FileObserver fileObserver = observer;
                        synchronized (fileObserver) {
                            Process.sendSignal(firstPids.get(i), 3);
                            observer.wait(200L);
                            continue;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Log.wtf(TAG, e);
                }
            }
            if (nativeProcs != null && (pids2 = Process.getPidsForCommands(nativeProcs)) != null) {
                for (int pid : pids2) {
                    Debug.dumpNativeBacktraceToFile(pid, tracesPath);
                }
            }
            if (processCpuTracker != null) {
                processCpuTracker.init();
                System.gc();
                processCpuTracker.update();
                try {
                    ProcessCpuTracker pids2 = processCpuTracker;
                    synchronized (pids2) {
                        processCpuTracker.wait(500L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                processCpuTracker.update();
                int N = processCpuTracker.countWorkingStats();
                int numProcs = 0;
                for (int i = 0; i < N && numProcs < 5; ++i) {
                    ProcessCpuTracker.Stats stats = processCpuTracker.getWorkingStats(i);
                    if (lastPids.indexOfKey(stats.pid) < 0) continue;
                    ++numProcs;
                    try {
                        FileObserver pid = observer;
                        synchronized (pid) {
                            Process.sendSignal(stats.pid, 3);
                            observer.wait(200L);
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        Log.wtf(TAG, e);
                    }
                }
            }
            Object var14_25 = null;
            observer.stopWatching();
        }
        catch (Throwable throwable) {
            Object var14_26 = null;
            observer.stopWatching();
            throw throwable;
        }
    }

    final void logAppTooSlow(ProcessRecord app, long startTime, String msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appNotResponding(ProcessRecord app, ActivityRecord activity, ActivityRecord parent, boolean aboveSystem, String annotation) {
        StringBuilder info;
        block35: {
            ArrayList<Integer> firstPids = new ArrayList<Integer>(5);
            SparseArray<Boolean> lastPids = new SparseArray<Boolean>(20);
            if (this.mController != null) {
                try {
                    int res = this.mController.appEarlyNotResponding(app.processName, app.pid, annotation);
                    if (res < 0 && app.pid != MY_PID) {
                        Process.killProcess(app.pid);
                    }
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
            long anrTime = SystemClock.uptimeMillis();
            this.updateCpuStatsNow();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (this.mShuttingDown) {
                    Slog.i(TAG, "During shutdown skipping ANR: " + app + " " + annotation);
                    return;
                }
                if (app.notResponding) {
                    Slog.i(TAG, "Skipping duplicate ANR: " + app + " " + annotation);
                    return;
                }
                if (app.crashing) {
                    Slog.i(TAG, "Crashing app skipping ANR: " + app + " " + annotation);
                    return;
                }
                app.notResponding = true;
                EventLog.writeEvent(30008, app.userId, app.pid, app.processName, app.info.flags, annotation);
                firstPids.add(app.pid);
                int parentPid = app.pid;
                if (parent != null && parent.app != null && parent.app.pid > 0) {
                    parentPid = parent.app.pid;
                }
                if (parentPid != app.pid) {
                    firstPids.add(parentPid);
                }
                if (MY_PID != app.pid && MY_PID != parentPid) {
                    firstPids.add(MY_PID);
                }
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    int pid;
                    ProcessRecord r = this.mLruProcesses.get(i);
                    if (r == null || r.thread == null || (pid = r.pid) <= 0 || pid == app.pid || pid == parentPid || pid == MY_PID) continue;
                    if (r.persistent) {
                        firstPids.add(pid);
                        continue;
                    }
                    lastPids.put(pid, Boolean.TRUE);
                }
            }
            info = new StringBuilder();
            info.setLength(0);
            info.append("ANR in ").append(app.processName);
            if (activity != null && activity.shortComponentName != null) {
                info.append(" (").append(activity.shortComponentName).append(")");
            }
            info.append("\n");
            info.append("PID: ").append(app.pid).append("\n");
            if (annotation != null) {
                info.append("Reason: ").append(annotation).append("\n");
            }
            if (parent != null && parent != activity) {
                info.append("Parent: ").append(parent.shortComponentName).append("\n");
            }
            ProcessCpuTracker processCpuTracker = new ProcessCpuTracker(true);
            File tracesFile = ActivityManagerService.dumpStackTraces(true, firstPids, processCpuTracker, lastPids, Watchdog.NATIVE_STACKS_OF_INTEREST);
            String cpuInfo = null;
            this.updateCpuStatsNow();
            Thread pid = this.mProcessCpuThread;
            synchronized (pid) {
                cpuInfo = this.mProcessCpuTracker.printCurrentState(anrTime);
            }
            info.append(processCpuTracker.printCurrentLoad());
            info.append(cpuInfo);
            info.append(processCpuTracker.printCurrentState(anrTime));
            Slog.e(TAG, info.toString());
            if (tracesFile == null) {
                Process.sendSignal(app.pid, 3);
            }
            this.addErrorToDropBox("anr", app, app.processName, activity, parent, annotation, cpuInfo, tracesFile, null);
            if (this.mController != null) {
                try {
                    int res = this.mController.appNotResponding(app.processName, app.pid, info.toString());
                    if (res == 0) break block35;
                    if (res < 0 && app.pid != MY_PID) {
                        Process.killProcess(app.pid);
                    } else {
                        ActivityManagerService activityManagerService2 = this;
                        synchronized (activityManagerService2) {
                            this.mServices.scheduleServiceTimeoutLocked(app);
                        }
                    }
                    return;
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
        }
        boolean showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!showBackground && !app.isInterestingToUserLocked() && app.pid != MY_PID) {
                this.killUnneededProcessLocked(app, "background ANR");
                return;
            }
            this.makeAppNotRespondingLocked(app, activity != null ? activity.shortComponentName : null, annotation != null ? "ANR " + annotation : "ANR", info.toString());
            Message msg = Message.obtain();
            HashMap<String, Object> map = new HashMap<String, Object>();
            msg.what = 2;
            msg.obj = map;
            msg.arg1 = aboveSystem ? 1 : 0;
            map.put("app", app);
            if (activity != null) {
                map.put("activity", activity);
            }
            this.mHandler.sendMessage(msg);
        }
    }

    final void showLaunchWarningLocked(final ActivityRecord cur, final ActivityRecord next) {
        if (!this.mLaunchWarningShown) {
            this.mLaunchWarningShown = true;
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        final LaunchWarningWindow d = new LaunchWarningWindow(ActivityManagerService.this.mContext, cur, next);
                        d.show();
                        ActivityManagerService.this.mHandler.postDelayed(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                ActivityManagerService activityManagerService = ActivityManagerService.this;
                                synchronized (activityManagerService) {
                                    d.dismiss();
                                    ActivityManagerService.this.mLaunchWarningShown = false;
                                }
                            }
                        }, 4000L);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean clearApplicationUserData(String packageName, IPackageDataObserver observer, int userId) {
        long callingId;
        block15: {
            boolean bl;
            block14: {
                this.enforceNotIsolatedCaller("clearApplicationUserData");
                int uid = Binder.getCallingUid();
                int pid = Binder.getCallingPid();
                userId = this.handleIncomingUser(pid, uid, userId, false, true, "clearApplicationUserData", null);
                callingId = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    int pkgUid = -1;
                    ActivityManagerService activityManagerService = this;
                    synchronized (activityManagerService) {
                        try {
                            pkgUid = pm.getPackageUid(packageName, userId);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        if (pkgUid == -1) {
                            Slog.w(TAG, "Invalid packageName: " + packageName);
                            if (observer != null) {
                                try {
                                    observer.onRemoveCompleted(packageName, false);
                                }
                                catch (RemoteException e) {
                                    Slog.i(TAG, "Observer no longer exists.");
                                }
                            }
                            bl = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 13] lbl27 : MonitorExitStatement: MONITOREXIT : var10_9
                            Object var14_15 = null;
                            break block14;
                        }
                        if (uid != pkgUid) {
                            if (this.checkComponentPermission("android.permission.CLEAR_APP_USER_DATA", pid, uid, -1, true) != 0) throw new SecurityException("PID " + pid + " does not have permission " + "android.permission.CLEAR_APP_USER_DATA" + " to clear data" + " of package " + packageName);
                        }
                        this.forceStopPackageLocked(packageName, pkgUid, "clear data");
                    }
                    try {
                        pm.clearApplicationUserData(packageName, observer, userId);
                        this.removeUriPermissionsForPackageLocked(packageName, userId, true);
                        Intent intent = new Intent("android.intent.action.PACKAGE_DATA_CLEARED", Uri.fromParts("package", packageName, null));
                        intent.putExtra("android.intent.extra.UID", pkgUid);
                        this.broadcastIntentInPackage("android", 1000, intent, null, null, 0, null, null, null, false, false, userId);
                    }
                    catch (RemoteException e) {
                    }
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    Binder.restoreCallingIdentity(callingId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        Object var14_16 = null;
        Binder.restoreCallingIdentity(callingId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void killBackgroundProcesses(String packageName, int userId) {
        long callingId;
        block10: {
            block9: {
                if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0 && this.checkCallingPermission("android.permission.RESTART_PACKAGES") != 0) {
                    String msg = "Permission Denial: killBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
                userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, true, "killBackgroundProcesses", null);
                callingId = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    ActivityManagerService activityManagerService = this;
                    synchronized (activityManagerService) {
                        int appId = -1;
                        try {
                            appId = UserHandle.getAppId(pm.getPackageUid(packageName, 0));
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        if (appId == -1) {
                            Slog.w(TAG, "Invalid packageName: " + packageName);
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 8] lbl21 : MonitorExitStatement: MONITOREXIT : var6_6
                            Object var11_9 = null;
                            break block9;
                        }
                        this.killPackageProcessesLocked(packageName, appId, userId, 5, false, true, true, false, "kill background");
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    Binder.restoreCallingIdentity(callingId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(callingId);
            return;
        }
        Object var11_10 = null;
        Binder.restoreCallingIdentity(callingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killAllBackgroundProcesses() {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0) {
            String msg = "Permission Denial: killAllBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
                int NP = this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.persistent) continue;
                        if (app.removed) {
                            procs.add(app);
                            continue;
                        }
                        if (app.setAdj < 9) continue;
                        app.removed = true;
                        procs.add(app);
                    }
                }
                int N = procs.size();
                for (int i = 0; i < N; ++i) {
                    this.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all background");
                }
                this.mAllowLowerMemLevel = true;
                this.updateOomAdjLocked();
                this.doLowMemReportIfNeededLocked(null);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            Binder.restoreCallingIdentity(callingId);
            throw throwable;
        }
        Binder.restoreCallingIdentity(callingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceStopPackage(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: forceStopPackage() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        int callingPid = Binder.getCallingPid();
        userId = this.handleIncomingUser(callingPid, Binder.getCallingUid(), userId, true, true, "forceStopPackage", null);
        long callingId = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int[] users;
                int[] nArray;
                if (userId == -1) {
                    nArray = this.getUsersLocked();
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = userId;
                }
                for (int user : users = nArray) {
                    int pkgUid = -1;
                    try {
                        pkgUid = pm.getPackageUid(packageName, user);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (pkgUid == -1) {
                        Slog.w(TAG, "Invalid packageName: " + packageName);
                        continue;
                    }
                    try {
                        pm.setPackageStoppedState(packageName, true, user);
                    }
                    catch (RemoteException e) {
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w(TAG, "Failed trying to unstop package " + packageName + ": " + e);
                    }
                    if (!this.isUserRunningLocked(user, false)) continue;
                    this.forceStopPackageLocked(packageName, pkgUid, "from pid " + callingPid);
                }
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            Binder.restoreCallingIdentity(callingId);
            throw throwable;
        }
        Binder.restoreCallingIdentity(callingId);
    }

    @Override
    public void killApplicationWithAppId(String pkg, int appid, String reason) {
        if (pkg == null) {
            return;
        }
        if (appid < 0) {
            Slog.w(TAG, "Invalid appid specified for pkg : " + pkg);
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (callerUid != 1000) {
            throw new SecurityException(callerUid + " cannot kill pkg: " + pkg);
        }
        Message msg = this.mHandler.obtainMessage(22);
        msg.arg1 = appid;
        msg.arg2 = 0;
        Bundle bundle = new Bundle();
        bundle.putString("pkg", pkg);
        bundle.putString("reason", reason);
        msg.obj = bundle;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void closeSystemDialogs(String reason) {
        this.enforceNotIsolatedCaller("closeSystemDialogs");
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            if (uid >= 10000) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                // MONITORENTER : sparseArray
                ProcessRecord proc = this.mPidsSelfLocked.get(pid);
                // MONITOREXIT : sparseArray
                if (proc.curRawAdj > 2) {
                    Slog.w(TAG, "Ignoring closeSystemDialogs " + reason + " from background process " + proc);
                    // MONITOREXIT : activityManagerService
                    Object var12_8 = null;
                    Binder.restoreCallingIdentity(origId);
                    return;
                }
            }
            this.closeSystemDialogsLocked(reason);
            // MONITOREXIT : activityManagerService
            Object var12_9 = null;
            Binder.restoreCallingIdentity(origId);
            return;
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            Binder.restoreCallingIdentity(origId);
            throw throwable;
        }
    }

    void closeSystemDialogsLocked(String reason) {
        Intent intent = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        intent.addFlags(0x50000000);
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        this.mWindowManager.closeSystemDialogs(reason);
        this.mStackSupervisor.closeSystemDialogsLocked();
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, -1, 1000, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessMemoryInfo");
        Debug.MemoryInfo[] infos = new Debug.MemoryInfo[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            int oomAdj;
            ProcessRecord proc;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    proc = this.mPidsSelfLocked.get(pids[i]);
                    oomAdj = proc != null ? proc.setAdj : 0;
                }
            }
            infos[i] = new Debug.MemoryInfo();
            Debug.getMemoryInfo(pids[i], infos[i]);
            if (proc == null) continue;
            activityManagerService = this;
            synchronized (activityManagerService) {
                if (proc.thread != null && proc.setAdj == oomAdj) {
                    proc.baseProcessTracker.addPss(infos[i].getTotalPss(), infos[i].getTotalUss(), false, proc.pkgList);
                }
                continue;
            }
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getProcessPss(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessPss");
        long[] pss = new long[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            int oomAdj;
            ProcessRecord proc;
            Object object;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                object = this.mPidsSelfLocked;
                synchronized (object) {
                    proc = this.mPidsSelfLocked.get(pids[i]);
                    oomAdj = proc != null ? proc.setAdj : 0;
                }
            }
            long[] tmpUss = new long[1];
            pss[i] = Debug.getPss(pids[i], tmpUss);
            if (proc == null) continue;
            object = this;
            synchronized (object) {
                if (proc.thread != null && proc.setAdj == oomAdj) {
                    proc.baseProcessTracker.addPss(pss[i], tmpUss[0], false, proc.pkgList);
                }
                continue;
            }
        }
        return pss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killApplicationProcess(String processName, int uid) {
        if (processName == null) {
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (callerUid == 1000) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord app = this.getProcessRecordLocked(processName, uid, true);
                if (app != null && app.thread != null) {
                    try {
                        app.thread.scheduleSuicide();
                    }
                    catch (RemoteException e) {}
                } else {
                    Slog.w(TAG, "Process/uid not found attempting kill of " + processName + " / " + uid);
                }
            }
        } else {
            throw new SecurityException(callerUid + " cannot kill app process: " + processName);
        }
    }

    private void forceStopPackageLocked(String packageName, int uid, String reason) {
        this.forceStopPackageLocked(packageName, UserHandle.getAppId(uid), false, false, true, false, UserHandle.getUserId(uid), reason);
        Intent intent = new Intent("android.intent.action.PACKAGE_RESTARTED", Uri.fromParts("package", packageName, null));
        if (!this.mProcessesReady) {
            intent.addFlags(0x50000000);
        }
        intent.putExtra("android.intent.extra.UID", uid);
        intent.putExtra("android.intent.extra.user_handle", UserHandle.getUserId(uid));
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, UserHandle.getUserId(uid));
    }

    private void forceStopUserLocked(int userId, String reason) {
        this.forceStopPackageLocked(null, -1, false, false, true, false, userId, reason);
        Intent intent = new Intent("android.intent.action.USER_STOPPED");
        intent.addFlags(0x50000000);
        intent.putExtra("android.intent.extra.user_handle", userId);
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, -1);
    }

    private final boolean killPackageProcessesLocked(String packageName, int appId, int userId, int minOomAdj, boolean callerWillRestart, boolean allowRestart, boolean doit, boolean evenPersistent, String reason) {
        ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
        String procNamePrefix = packageName != null ? packageName + ":" : null;
        int NP = this.mProcessNames.getMap().size();
        for (int ip = 0; ip < NP; ++ip) {
            SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
            int NA = apps.size();
            for (int ia = 0; ia < NA; ++ia) {
                ProcessRecord app = apps.valueAt(ia);
                if (app.persistent && !evenPersistent) continue;
                if (app.removed) {
                    if (!doit) continue;
                    procs.add(app);
                    continue;
                }
                if (app.setAdj < minOomAdj || (packageName != null ? UserHandle.getAppId(app.uid) != appId || userId != -1 && app.userId != userId || !app.pkgList.containsKey(packageName) : app.userId != userId || appId >= 0 && UserHandle.getAppId(app.uid) != appId)) continue;
                if (!doit) {
                    return true;
                }
                app.removed = true;
                procs.add(app);
            }
        }
        int N = procs.size();
        for (int i = 0; i < N; ++i) {
            this.removeProcessLocked((ProcessRecord)procs.get(i), callerWillRestart, allowRestart, reason);
        }
        this.updateOomAdjLocked();
        return N > 0;
    }

    private final boolean forceStopPackageLocked(String name, int appId, boolean callerWillRestart, boolean purgeCache, boolean doit, boolean evenPersistent, int userId, String reason) {
        ArrayList<ContentProviderRecord> providers;
        int i;
        if (userId == -1 && name == null) {
            Slog.w(TAG, "Can't force stop all processes of all users, that is insane!");
        }
        if (appId < 0 && name != null) {
            try {
                appId = UserHandle.getAppId(AppGlobals.getPackageManager().getPackageUid(name, 0));
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (doit) {
            if (name != null) {
                Slog.i(TAG, "Force stopping " + name + " appid=" + appId + " user=" + userId + ": " + reason);
            } else {
                Slog.i(TAG, "Force stopping u" + userId + ": " + reason);
            }
            ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
            for (int ip = pmap.size() - 1; ip >= 0; --ip) {
                SparseArray<Long> ba = pmap.valueAt(ip);
                for (i = ba.size() - 1; i >= 0; --i) {
                    boolean remove = false;
                    int entUid = ba.keyAt(i);
                    if (name != null) {
                        if (userId == -1) {
                            if (UserHandle.getAppId(entUid) == appId) {
                                remove = true;
                            }
                        } else if (entUid == UserHandle.getUid(userId, appId)) {
                            remove = true;
                        }
                    } else if (UserHandle.getUserId(entUid) == userId) {
                        remove = true;
                    }
                    if (!remove) continue;
                    ba.removeAt(i);
                }
                if (ba.size() != 0) continue;
                pmap.removeAt(ip);
            }
        }
        boolean didSomething = this.killPackageProcessesLocked(name, appId, userId, -100, callerWillRestart, true, doit, evenPersistent, name == null ? "stop user " + userId : "stop " + name);
        if (this.mStackSupervisor.forceStopPackageLocked(name, doit, evenPersistent, userId)) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        if (this.mServices.forceStopLocked(name, userId, evenPersistent, doit)) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        if (name == null) {
            this.mStickyBroadcasts.remove(userId);
        }
        if (this.mProviderMap.collectForceStopProviders(name, appId, doit, evenPersistent, userId, providers = new ArrayList<ContentProviderRecord>())) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        int N = providers.size();
        for (i = 0; i < N; ++i) {
            this.removeDyingProviderLocked(null, providers.get(i), true);
        }
        this.removeUriPermissionsForPackageLocked(name, userId, false);
        if (name == null && this.mIntentSenderRecords.size() > 0) {
            Iterator<WeakReference<PendingIntentRecord>> it = this.mIntentSenderRecords.values().iterator();
            while (it.hasNext()) {
                WeakReference<PendingIntentRecord> wpir = it.next();
                if (wpir == null) {
                    it.remove();
                    continue;
                }
                PendingIntentRecord pir = (PendingIntentRecord)wpir.get();
                if (pir == null) {
                    it.remove();
                    continue;
                }
                if (name != null ? UserHandle.getAppId(pir.uid) != appId || userId != -1 && pir.key.userId != userId || !pir.key.packageName.equals(name) : pir.key.userId != userId) continue;
                if (!doit) {
                    return true;
                }
                didSomething = true;
                it.remove();
                pir.canceled = true;
                if (pir.key.activity == null) continue;
                pir.key.activity.pendingResults.remove(pir.ref);
            }
        }
        if (doit) {
            AttributeCache ac;
            if (purgeCache && name != null && (ac = AttributeCache.instance()) != null) {
                ac.removePackage(name);
            }
            if (this.mBooted) {
                this.mStackSupervisor.resumeTopActivitiesLocked();
                this.mStackSupervisor.scheduleIdleLocked();
            }
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeProcessLocked(ProcessRecord app, boolean callerWillRestart, boolean allowRestart, String reason) {
        String name = app.processName;
        int uid = app.uid;
        this.mProcessNames.remove(name, uid);
        this.mIsolatedProcesses.remove(app.uid);
        if (this.mHeavyWeightProcess == app) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
            this.mHeavyWeightProcess = null;
        }
        boolean needRestart = false;
        if (app.pid > 0 && app.pid != MY_PID) {
            int pid = app.pid;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(pid);
                this.mHandler.removeMessages(20, app);
            }
            this.killUnneededProcessLocked(app, reason);
            this.handleAppDiedLocked(app, true, allowRestart);
            this.removeLruProcessLocked(app);
            if (app.persistent && !app.isolated) {
                if (!callerWillRestart) {
                    this.addAppLocked(app.info, false);
                } else {
                    needRestart = true;
                }
            }
        } else {
            this.mRemovedProcesses.add(app);
        }
        return needRestart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processStartTimedOutLocked(ProcessRecord app) {
        int pid = app.pid;
        boolean gone = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord knownApp = this.mPidsSelfLocked.get(pid);
            if (knownApp != null && knownApp.thread == null) {
                this.mPidsSelfLocked.remove(pid);
                gone = true;
            }
        }
        if (gone) {
            Slog.w(TAG, "Process " + app + " failed to attach");
            EventLog.writeEvent(30037, app.userId, pid, app.uid, app.processName);
            this.mProcessNames.remove(app.processName, app.uid);
            this.mIsolatedProcesses.remove(app.uid);
            if (this.mHeavyWeightProcess == app) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
                this.mHeavyWeightProcess = null;
            }
            this.checkAppInLaunchingProvidersLocked(app, true);
            this.mServices.processStartTimedOutLocked(app);
            this.killUnneededProcessLocked(app, "start timeout");
            if (this.mBackupTarget != null && this.mBackupTarget.app.pid == pid) {
                Slog.w(TAG, "Unattached app died before backup, skipping");
                try {
                    IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                    bm.agentDisconnected(app.info.packageName);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (this.isPendingBroadcastProcessLocked(pid)) {
                Slog.w(TAG, "Unattached app died before broadcast acknowledged, skipping");
                this.skipPendingBroadcastLocked(pid);
            }
        } else {
            Slog.w(TAG, "Spurious process start timeout - pid not known for " + app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean attachApplicationLocked(IApplicationThread thread, int pid) {
        List<ProviderInfo> providers;
        ProcessRecord app;
        if (pid != MY_PID && pid >= 0) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                app = this.mPidsSelfLocked.get(pid);
            }
        } else {
            app = null;
        }
        if (app == null) {
            Slog.w(TAG, "No pending application record for pid " + pid + " (IApplicationThread " + thread + "); dropping process");
            EventLog.writeEvent(30033, pid);
            if (pid > 0 && pid != MY_PID) {
                Process.killProcessQuiet(pid);
            } else {
                try {
                    thread.scheduleExit();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return false;
        }
        if (app.thread != null) {
            this.handleAppDiedLocked(app, true, true);
        }
        String processName = app.processName;
        try {
            AppDeathRecipient adr = new AppDeathRecipient(app, pid, thread);
            thread.asBinder().linkToDeath(adr, 0);
            app.deathRecipient = adr;
        }
        catch (RemoteException e) {
            app.resetPackageList(this.mProcessStats);
            this.startProcessLocked(app, "link fail", processName);
            return false;
        }
        EventLog.writeEvent(30010, app.userId, app.pid, app.processName);
        app.makeActive(thread, this.mProcessStats);
        app.setAdj = -100;
        app.curAdj = -100;
        app.setSchedGroup = -1;
        app.curSchedGroup = -1;
        app.forcingToForeground = null;
        app.foregroundServices = false;
        app.hasShownUi = false;
        app.debugging = false;
        app.cached = false;
        this.mHandler.removeMessages(20, app);
        boolean normalMode = this.mProcessesReady || this.isAllowedWhileBooting(app.info);
        List<ProviderInfo> list = providers = normalMode ? this.generateApplicationProvidersLocked(app) : null;
        if (!normalMode) {
            Slog.i(TAG, "Launching preboot mode app: " + app);
        }
        try {
            int testMode = 0;
            if (this.mDebugApp != null && this.mDebugApp.equals(processName)) {
                testMode = this.mWaitForDebugger ? 2 : 1;
                app.debugging = true;
                if (this.mDebugTransient) {
                    this.mDebugApp = this.mOrigDebugApp;
                    this.mWaitForDebugger = this.mOrigWaitForDebugger;
                }
            }
            String profileFile = app.instrumentationProfileFile;
            ParcelFileDescriptor profileFd = null;
            boolean profileAutoStop = false;
            if (this.mProfileApp != null && this.mProfileApp.equals(processName)) {
                this.mProfileProc = app;
                profileFile = this.mProfileFile;
                profileFd = this.mProfileFd;
                profileAutoStop = this.mAutoStopProfiler;
            }
            boolean enableOpenGlTrace = false;
            if (this.mOpenGlTraceApp != null && this.mOpenGlTraceApp.equals(processName)) {
                enableOpenGlTrace = true;
                this.mOpenGlTraceApp = null;
            }
            boolean isRestrictedBackupMode = false;
            if (this.mBackupTarget != null && this.mBackupAppName.equals(processName)) {
                isRestrictedBackupMode = this.mBackupTarget.backupMode == 2 || this.mBackupTarget.backupMode == 3 || this.mBackupTarget.backupMode == 1;
            }
            this.ensurePackageDexOpt(app.instrumentationInfo != null ? app.instrumentationInfo.packageName : app.info.packageName);
            if (app.instrumentationClass != null) {
                this.ensurePackageDexOpt(app.instrumentationClass.getPackageName());
            }
            ApplicationInfo appInfo = app.instrumentationInfo != null ? app.instrumentationInfo : app.info;
            app.compat = this.compatibilityInfoForPackageLocked(appInfo);
            if (profileFd != null) {
                profileFd = profileFd.dup();
            }
            thread.bindApplication(processName, appInfo, providers, app.instrumentationClass, profileFile, profileFd, profileAutoStop, app.instrumentationArguments, app.instrumentationWatcher, app.instrumentationUiAutomationConnection, testMode, enableOpenGlTrace, isRestrictedBackupMode || !normalMode, app.persistent, new Configuration(this.mConfiguration), app.compat, this.getCommonServicesLocked(), this.mCoreSettingsObserver.getCoreSettingsLocked());
            this.updateLruProcessLocked(app, false, null);
            app.lastRequestedGc = app.lastLowMemory = SystemClock.uptimeMillis();
        }
        catch (Exception e) {
            Slog.w(TAG, "Exception thrown during bind!", e);
            app.resetPackageList(this.mProcessStats);
            app.unlinkDeathRecipient();
            this.startProcessLocked(app, "bind fail", processName);
            return false;
        }
        this.mPersistentStartingProcesses.remove(app);
        this.mProcessesOnHold.remove(app);
        boolean badApp = false;
        boolean didSomething = false;
        if (normalMode) {
            try {
                if (this.mStackSupervisor.attachApplicationLocked(app, this.mHeadless)) {
                    didSomething = true;
                }
            }
            catch (Exception e) {
                badApp = true;
            }
        }
        if (!badApp) {
            try {
                didSomething |= this.mServices.attachApplicationLocked(app, processName);
            }
            catch (Exception e) {
                badApp = true;
            }
        }
        if (!badApp && this.isPendingBroadcastProcessLocked(pid)) {
            try {
                didSomething |= this.sendPendingBroadcastsLocked(app);
            }
            catch (Exception e) {
                badApp = true;
            }
        }
        if (!badApp && this.mBackupTarget != null && this.mBackupTarget.appInfo.uid == app.uid) {
            this.ensurePackageDexOpt(this.mBackupTarget.appInfo.packageName);
            try {
                thread.scheduleCreateBackupAgent(this.mBackupTarget.appInfo, this.compatibilityInfoForPackageLocked(this.mBackupTarget.appInfo), this.mBackupTarget.backupMode);
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception scheduling backup agent creation: ");
                e.printStackTrace();
            }
        }
        if (badApp) {
            this.handleAppDiedLocked(app, false, true);
            return false;
        }
        if (!didSomething) {
            this.updateOomAdjLocked();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachApplication(IApplicationThread thread) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingPid = Binder.getCallingPid();
            long origId = Binder.clearCallingIdentity();
            this.attachApplicationLocked(thread, callingPid);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityIdle(IBinder token, Configuration config, boolean stopProfiling) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                ActivityRecord r = this.mStackSupervisor.activityIdleInternalLocked(token, false, config);
                if (stopProfiling && this.mProfileProc == r.app && this.mProfileFd != null) {
                    try {
                        this.mProfileFd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.clearProfilerLocked();
                }
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableScreenAfterBoot() {
        EventLog.writeEvent(3050, SystemClock.uptimeMillis());
        this.mWindowManager.enableScreenAfterBoot();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.updateEventDispatchingLocked();
        }
    }

    @Override
    public void showBootMessage(CharSequence msg, boolean always) {
        this.enforceNotIsolatedCaller("showBootMessage");
        this.mWindowManager.showBootMessage(msg, always);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissKeyguardOnNextActivity() {
        this.enforceNotIsolatedCaller("dismissKeyguardOnNextActivity");
        long token = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (this.mLockScreenShown) {
                    this.mLockScreenShown = false;
                    this.comeOutOfSleepIfNeededLocked();
                }
                this.mStackSupervisor.setDismissKeyguard(true);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finishBooting() {
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String[] pkgs = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                if (pkgs != null) {
                    for (String pkg : pkgs) {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            if (ActivityManagerService.this.forceStopPackageLocked(pkg, -1, false, false, false, false, 0, "finished booting")) {
                                this.setResultCode(-1);
                                return;
                            }
                        }
                    }
                }
            }
        }, pkgFilter);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int NP = this.mProcessesOnHold.size();
            if (NP > 0) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>(this.mProcessesOnHold);
                for (int ip = 0; ip < NP; ++ip) {
                    this.startProcessLocked(procs.get(ip), "on-hold", null);
                }
            }
            if (this.mFactoryTest != 1) {
                Message nmsg = this.mHandler.obtainMessage(27);
                this.mHandler.sendMessageDelayed(nmsg, 900000L);
                SystemProperties.set("sys.boot_completed", "1");
                SystemProperties.set("dev.bootcomplete", "1");
                for (int i = 0; i < this.mStartedUsers.size(); ++i) {
                    UserStartedState uss = this.mStartedUsers.valueAt(i);
                    if (uss.mState != 0) continue;
                    uss.mState = 1;
                    int userId = this.mStartedUsers.keyAt(i);
                    Intent intent = new Intent("android.intent.action.BOOT_COMPLETED", null);
                    intent.putExtra("android.intent.extra.user_handle", userId);
                    intent.addFlags(0x8000000);
                    this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                            ActivityManagerService activityManagerService = ActivityManagerService.this;
                            synchronized (activityManagerService) {
                                ActivityManagerService.this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, false);
                            }
                        }
                    }, 0, null, null, "android.permission.RECEIVE_BOOT_COMPLETED", -1, true, false, MY_PID, 1000, userId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureBootCompleted() {
        boolean enableScreen;
        boolean booting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            booting = this.mBooting;
            this.mBooting = false;
            enableScreen = !this.mBooted;
            this.mBooted = true;
        }
        if (booting) {
            this.finishBooting();
        }
        if (enableScreen) {
            this.enableScreenAfterBoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityResumed(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                ActivityRecord.activityResumedLocked(token);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityPaused(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                stack.activityPausedLocked(token, false);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityStopped(IBinder token, Bundle icicle, Bitmap thumbnail, CharSequence description) {
        if (icicle != null && icicle.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        ActivityRecord r = null;
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                r.task.stack.activityStoppedLocked(r, icicle, thumbnail, description);
            }
        }
        if (r != null) {
            this.sendPendingThumbnail(r, null, null, null, false);
        }
        this.trimApplications();
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityDestroyed(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                stack.activityDestroyedLocked(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCallingPackage(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null ? r.info.packageName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getCallingActivity(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null ? r.intent.getComponent() : null;
        }
    }

    private ActivityRecord getCallingRecordLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r == null) {
            return null;
        }
        return r.resultTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getActivityClassForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.intent.getComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPackageForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.packageName;
        }
    }

    @Override
    public IIntentSender getIntentSender(int type, String packageName, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("getIntentSender");
        if (intents != null) {
            if (intents.length < 1) {
                throw new IllegalArgumentException("Intents array length must be >= 1");
            }
            for (int i = 0; i < intents.length; ++i) {
                Intent intent = intents[i];
                if (intent == null) continue;
                if (intent.hasFileDescriptors()) {
                    throw new IllegalArgumentException("File descriptors passed in Intent");
                }
                if (type == 1 && (intent.getFlags() & 0x2000000) != 0) {
                    throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
                }
                intents[i] = new Intent(intent);
            }
            if (resolvedTypes != null && resolvedTypes.length != intents.length) {
                throw new IllegalArgumentException("Intent array length does not match resolvedTypes length");
            }
        }
        if (options != null && options.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in options");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            int origUserId = userId;
            userId = this.handleIncomingUser(Binder.getCallingPid(), callingUid, userId, type == 1, false, "getIntentSender", null);
            if (origUserId == -2) {
                userId = -2;
            }
            try {
                int uid;
                if (callingUid != 0 && callingUid != 1000 && !UserHandle.isSameApp(callingUid, uid = AppGlobals.getPackageManager().getPackageUid(packageName, UserHandle.getUserId(callingUid)))) {
                    String msg = "Permission Denial: getIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + ", (need uid=" + uid + ")" + " is not allowed to send as package " + packageName;
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
                return this.getIntentSenderLocked(type, packageName, callingUid, userId, token, resultWho, requestCode, intents, resolvedTypes, flags, options);
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
        }
    }

    IIntentSender getIntentSenderLocked(int type, String packageName, int callingUid, int userId, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle options) {
        PendingIntentRecord rec;
        ActivityRecord activity = null;
        if (type == 3) {
            activity = ActivityRecord.isInStackLocked(token);
            if (activity == null) {
                return null;
            }
            if (activity.finishing) {
                return null;
            }
        }
        boolean noCreate = (flags & 0x20000000) != 0;
        boolean cancelCurrent = (flags & 0x10000000) != 0;
        boolean updateCurrent = (flags & 0x8000000) != 0;
        PendingIntentRecord.Key key = new PendingIntentRecord.Key(type, packageName, activity, resultWho, requestCode, intents, resolvedTypes, flags &= 0xC7FFFFFF, options, userId);
        WeakReference<PendingIntentRecord> ref = this.mIntentSenderRecords.get(key);
        PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
        if (rec != null) {
            if (!cancelCurrent) {
                if (updateCurrent) {
                    if (rec.key.requestIntent != null) {
                        rec.key.requestIntent.replaceExtras(intents != null ? intents[intents.length - 1] : null);
                    }
                    if (intents != null) {
                        intents[intents.length - 1] = rec.key.requestIntent;
                        rec.key.allIntents = intents;
                        rec.key.allResolvedTypes = resolvedTypes;
                    } else {
                        rec.key.allIntents = null;
                        rec.key.allResolvedTypes = null;
                    }
                }
                return rec;
            }
            rec.canceled = true;
            this.mIntentSenderRecords.remove(key);
        }
        if (noCreate) {
            return rec;
        }
        rec = new PendingIntentRecord(this, key, callingUid);
        this.mIntentSenderRecords.put(key, rec.ref);
        if (type == 3) {
            if (activity.pendingResults == null) {
                activity.pendingResults = new HashSet();
            }
            activity.pendingResults.add(rec.ref);
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelIntentSender(IIntentSender sender) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            PendingIntentRecord rec = (PendingIntentRecord)sender;
            try {
                int uid = AppGlobals.getPackageManager().getPackageUid(rec.key.packageName, UserHandle.getCallingUserId());
                if (!UserHandle.isSameApp(uid, Binder.getCallingUid())) {
                    String msg = "Permission Denial: cancelIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " is not allowed to cancel packges " + rec.key.packageName;
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
            this.cancelIntentSenderLocked(rec, true);
        }
    }

    void cancelIntentSenderLocked(PendingIntentRecord rec, boolean cleanActivity) {
        rec.canceled = true;
        this.mIntentSenderRecords.remove(rec.key);
        if (cleanActivity && rec.key.activity != null) {
            rec.key.activity.pendingResults.remove(rec.ref);
        }
    }

    @Override
    public String getPackageForIntentSender(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.packageName;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public int getUidForIntentSender(IIntentSender sender) {
        if (sender instanceof PendingIntentRecord) {
            try {
                PendingIntentRecord res = (PendingIntentRecord)sender;
                return res.uid;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public boolean isIntentSenderTargetedToPackage(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            if (res.key.allIntents == null) {
                return false;
            }
            for (int i = 0; i < res.key.allIntents.length; ++i) {
                Intent intent = res.key.allIntents[i];
                if (intent.getPackage() == null || intent.getComponent() == null) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean isIntentSenderAnActivity(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.type == 2;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public Intent getIntentForIntentSender(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.requestIntent != null ? new Intent(res.key.requestIntent) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessLimit(int max) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessLimit()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessLimit = max < 0 ? 24 : max;
            this.mProcessLimitOverride = max;
        }
        this.trimApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProcessLimit() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mProcessLimitOverride;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foregroundTokenDied(ForegroundToken token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ForegroundToken cur = this.mForegroundProcesses.get(token.pid);
                if (cur != token) {
                    return;
                }
                this.mForegroundProcesses.remove(token.pid);
                ProcessRecord pr = this.mPidsSelfLocked.get(token.pid);
                if (pr == null) {
                    return;
                }
                pr.forcingToForeground = null;
                pr.foregroundServices = false;
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessForeground(IBinder token, int pid, boolean isForeground) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessForeground()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean changed = false;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ProcessRecord pr = this.mPidsSelfLocked.get(pid);
                if (pr == null && isForeground) {
                    Slog.w(TAG, "setProcessForeground called on unknown pid: " + pid);
                    return;
                }
                ForegroundToken oldToken = this.mForegroundProcesses.get(pid);
                if (oldToken != null) {
                    oldToken.token.unlinkToDeath(oldToken, 0);
                    this.mForegroundProcesses.remove(pid);
                    if (pr != null) {
                        pr.forcingToForeground = null;
                    }
                    changed = true;
                }
                if (isForeground && token != null) {
                    ForegroundToken newToken = new ForegroundToken(){

                        public void binderDied() {
                            ActivityManagerService.this.foregroundTokenDied(this);
                        }
                    };
                    newToken.pid = pid;
                    newToken.token = token;
                    try {
                        token.linkToDeath(newToken, 0);
                        this.mForegroundProcesses.put(pid, newToken);
                        pr.forcingToForeground = token;
                        changed = true;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            if (changed) {
                this.updateOomAdjLocked();
            }
        }
    }

    int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null) {
            Slog.d(TAG, "checkComponentPermission() adjusting {pid,uid} to {" + tlsIdentity.pid + "," + tlsIdentity.uid + "}");
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        if (pid == MY_PID) {
            return 0;
        }
        return ActivityManager.checkComponentPermission(permission2, uid, owningUid, exported);
    }

    @Override
    public int checkPermission(String permission2, int pid, int uid) {
        if (permission2 == null) {
            return -1;
        }
        return this.checkComponentPermission(permission2, pid, UserHandle.getAppId(uid), -1, true);
    }

    int checkCallingPermission(String permission2) {
        return this.checkPermission(permission2, Binder.getCallingPid(), UserHandle.getAppId(Binder.getCallingUid()));
    }

    void enforceCallingPermission(String permission2, String func) {
        if (this.checkCallingPermission(permission2) == 0) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w(TAG, msg);
        throw new SecurityException(msg);
    }

    private final boolean checkHoldingPermissionsLocked(IPackageManager pm, ProviderInfo pi, Uri uri, int uid, int modeFlags) {
        if (pi.applicationInfo.uid == uid) {
            return true;
        }
        if (!pi.exported) {
            return false;
        }
        boolean readMet = (modeFlags & 1) == 0;
        boolean writeMet = (modeFlags & 2) == 0;
        try {
            if (!readMet && pi.readPermission != null && pm.checkUidPermission(pi.readPermission, uid) == 0) {
                readMet = true;
            }
            if (!writeMet && pi.writePermission != null && pm.checkUidPermission(pi.writePermission, uid) == 0) {
                writeMet = true;
            }
            boolean allowDefaultRead = pi.readPermission == null;
            boolean allowDefaultWrite = pi.writePermission == null;
            PathPermission[] pps = pi.pathPermissions;
            if (pps != null) {
                String path = uri.getPath();
                int i = pps.length;
                while (!(i <= 0 || readMet && writeMet)) {
                    String ppwperm;
                    String pprperm;
                    PathPermission pp;
                    if (!(pp = pps[--i]).match(path)) continue;
                    if (!readMet && (pprperm = pp.getReadPermission()) != null) {
                        if (pm.checkUidPermission(pprperm, uid) == 0) {
                            readMet = true;
                        } else {
                            allowDefaultRead = false;
                        }
                    }
                    if (writeMet || (ppwperm = pp.getWritePermission()) == null) continue;
                    if (pm.checkUidPermission(ppwperm, uid) == 0) {
                        writeMet = true;
                        continue;
                    }
                    allowDefaultWrite = false;
                }
            }
            if (allowDefaultRead) {
                readMet = true;
            }
            if (allowDefaultWrite) {
                writeMet = true;
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return readMet && writeMet;
    }

    private ProviderInfo getProviderInfoLocked(String authority, int userHandle) {
        ProviderInfo pi = null;
        ContentProviderRecord cpr = this.mProviderMap.getProviderByName(authority, userHandle);
        if (cpr != null) {
            pi = cpr.info;
        } else {
            try {
                pi = AppGlobals.getPackageManager().resolveContentProvider(authority, 2048, userHandle);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        return pi;
    }

    private UriPermission findUriPermissionLocked(int targetUid, Uri uri) {
        ArrayMap<Uri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris != null) {
            return targetUris.get(uri);
        }
        return null;
    }

    private UriPermission findOrCreateUriPermissionLocked(String sourcePkg, String targetPkg, int targetUid, Uri uri) {
        UriPermission perm;
        ArrayMap<Uri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris == null) {
            targetUris = Maps.newArrayMap();
            this.mGrantedUriPermissions.put(targetUid, targetUris);
        }
        if ((perm = targetUris.get(uri)) == null) {
            perm = new UriPermission(sourcePkg, targetPkg, targetUid, uri);
            targetUris.put(uri, perm);
        }
        return perm;
    }

    private final boolean checkUriPermissionLocked(Uri uri, int uid, int modeFlags, int minStrength) {
        if (uid == 0) {
            return true;
        }
        ArrayMap<Uri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        UriPermission perm = perms.get(uri);
        if (perm == null) {
            return false;
        }
        return perm.getStrength(modeFlags) >= minStrength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags) {
        this.enforceNotIsolatedCaller("checkUriPermission");
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null) {
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        if (pid == MY_PID) {
            return 0;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkUriPermissionLocked(uri, uid, modeFlags, 1) ? 0 : -1;
        }
    }

    int checkGrantUriPermissionLocked(int callingUid, String targetPkg, Uri uri, int modeFlags, int lastTargetUid) {
        boolean persistable;
        boolean bl = persistable = (modeFlags & 0x40) != 0;
        if ((modeFlags &= 3) == 0) {
            return -1;
        }
        if (targetPkg != null) {
            // empty if block
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (!"content".equals(uri.getScheme())) {
            return -1;
        }
        String authority = uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, UserHandle.getUserId(callingUid));
        if (pi == null) {
            Slog.w(TAG, "No content provider found for permission check: " + uri.toSafeString());
            return -1;
        }
        int targetUid = lastTargetUid;
        if (targetUid < 0 && targetPkg != null) {
            try {
                targetUid = pm.getPackageUid(targetPkg, UserHandle.getUserId(callingUid));
                if (targetUid < 0) {
                    return -1;
                }
            }
            catch (RemoteException ex) {
                return -1;
            }
        }
        if (targetUid >= 0) {
            if (this.checkHoldingPermissionsLocked(pm, pi, uri, targetUid, modeFlags)) {
                return -1;
            }
        } else {
            boolean allowed = pi.exported;
            if ((modeFlags & 1) != 0 && pi.readPermission != null) {
                allowed = false;
            }
            if ((modeFlags & 2) != 0 && pi.writePermission != null) {
                allowed = false;
            }
            if (allowed) {
                return -1;
            }
        }
        if (!pi.grantUriPermissions) {
            throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of Uri permissions (uri " + uri + ")");
        }
        if (pi.uriPermissionPatterns != null) {
            int N = pi.uriPermissionPatterns.length;
            boolean allowed = false;
            for (int i = 0; i < N; ++i) {
                if (pi.uriPermissionPatterns[i] == null || !pi.uriPermissionPatterns[i].match(uri.getPath())) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of permission to path of Uri " + uri);
            }
        }
        if (callingUid != Process.myUid() && !this.checkHoldingPermissionsLocked(pm, pi, uri, callingUid, modeFlags)) {
            int minStrength;
            int n = minStrength = persistable ? 3 : 1;
            if (!this.checkUriPermissionLocked(uri, callingUid, modeFlags, minStrength)) {
                throw new SecurityException("Uid " + callingUid + " does not have permission to uri " + uri);
            }
        }
        return targetUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkGrantUriPermission(int callingUid, String targetPkg, Uri uri, int modeFlags) {
        this.enforceNotIsolatedCaller("checkGrantUriPermission");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkGrantUriPermissionLocked(callingUid, targetPkg, uri, modeFlags, -1);
        }
    }

    void grantUriPermissionUncheckedLocked(int targetUid, String targetPkg, Uri uri, int modeFlags, UriPermissionOwner owner) {
        boolean persistable;
        boolean bl = persistable = (modeFlags & 0x40) != 0;
        if ((modeFlags &= 3) == 0) {
            return;
        }
        String authority = uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, UserHandle.getUserId(targetUid));
        if (pi == null) {
            Slog.w(TAG, "No content provider found for grant: " + uri.toSafeString());
            return;
        }
        UriPermission perm = this.findOrCreateUriPermissionLocked(pi.packageName, targetPkg, targetUid, uri);
        perm.grantModes(modeFlags, persistable, owner);
    }

    void grantUriPermissionLocked(int callingUid, String targetPkg, Uri uri, int modeFlags, UriPermissionOwner owner) {
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        int targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, uri, modeFlags, -1);
        if (targetUid < 0) {
            return;
        }
        this.grantUriPermissionUncheckedLocked(targetUid, targetPkg, uri, modeFlags, owner);
    }

    NeededUriGrants checkGrantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent, int mode, NeededUriGrants needed) {
        int targetUid;
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        if (intent == null) {
            return null;
        }
        Uri data = intent.getData();
        ClipData clip = intent.getClipData();
        if (data == null && clip == null) {
            return null;
        }
        if (data != null && (targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, data, mode, needed != null ? needed.targetUid : -1)) > 0) {
            if (needed == null) {
                needed = new NeededUriGrants(targetPkg, targetUid, mode);
            }
            needed.add(data);
        }
        if (clip != null) {
            for (int i = 0; i < clip.getItemCount(); ++i) {
                NeededUriGrants newNeeded;
                Uri uri = clip.getItemAt(i).getUri();
                if (uri != null) {
                    int targetUid2 = -1;
                    targetUid2 = this.checkGrantUriPermissionLocked(callingUid, targetPkg, uri, mode, needed != null ? needed.targetUid : -1);
                    if (targetUid2 <= 0) continue;
                    if (needed == null) {
                        needed = new NeededUriGrants(targetPkg, targetUid2, mode);
                    }
                    needed.add(uri);
                    continue;
                }
                Intent clipIntent = clip.getItemAt(i).getIntent();
                if (clipIntent == null || (newNeeded = this.checkGrantUriPermissionFromIntentLocked(callingUid, targetPkg, clipIntent, mode, needed)) == null) continue;
                needed = newNeeded;
            }
        }
        return needed;
    }

    void grantUriPermissionUncheckedFromIntentLocked(NeededUriGrants needed, UriPermissionOwner owner) {
        if (needed != null) {
            for (int i = 0; i < needed.size(); ++i) {
                this.grantUriPermissionUncheckedLocked(needed.targetUid, needed.targetPkg, (Uri)needed.get(i), needed.flags, owner);
            }
        }
    }

    void grantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent, UriPermissionOwner owner) {
        NeededUriGrants needed = this.checkGrantUriPermissionFromIntentLocked(callingUid, targetPkg, intent, intent != null ? intent.getFlags() : 0, null);
        if (needed == null) {
            return;
        }
        this.grantUriPermissionUncheckedFromIntentLocked(needed, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermission(IApplicationThread caller, String targetPkg, Uri uri, int modeFlags) {
        this.enforceNotIsolatedCaller("grantUriPermission");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when granting permission to uri " + uri);
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (uri == null) {
                throw new IllegalArgumentException("null uri");
            }
            Preconditions.checkFlagsArgument(modeFlags, 3);
            this.grantUriPermissionLocked(r.uid, targetPkg, uri, modeFlags, null);
        }
    }

    void removeUriPermissionIfNeededLocked(UriPermission perm) {
        ArrayMap<Uri, UriPermission> perms;
        if ((perm.modeFlags & 3) == 0 && (perms = this.mGrantedUriPermissions.get(perm.targetUid)) != null) {
            perms.remove(perm.uri);
            if (perms.size() == 0) {
                this.mGrantedUriPermissions.remove(perm.targetUid);
            }
        }
    }

    private void revokeUriPermissionLocked(int callingUid, Uri uri, int modeFlags) {
        IPackageManager pm = AppGlobals.getPackageManager();
        String authority = uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, UserHandle.getUserId(callingUid));
        if (pi == null) {
            Slog.w(TAG, "No content provider found for permission revoke: " + uri.toSafeString());
            return;
        }
        if (!this.checkHoldingPermissionsLocked(pm, pi, uri, callingUid, modeFlags)) {
            throw new SecurityException("Uid " + callingUid + " does not have permission to uri " + uri);
        }
        boolean persistChanged = false;
        List<String> SEGMENTS = uri.getPathSegments();
        if (SEGMENTS != null) {
            int NS = SEGMENTS.size();
            int N = this.mGrantedUriPermissions.size();
            for (int i = 0; i < N; ++i) {
                ArrayMap<Uri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                Iterator<UriPermission> it = perms.values().iterator();
                block1: while (it.hasNext()) {
                    List<String> targetSegments;
                    UriPermission perm = it.next();
                    Uri targetUri = perm.uri;
                    if (!authority.equals(targetUri.getAuthority()) || (targetSegments = targetUri.getPathSegments()) == null || targetSegments.size() < NS) continue;
                    for (int j = 0; j < NS; ++j) {
                        if (!SEGMENTS.get(j).equals(targetSegments.get(j))) continue block1;
                    }
                    persistChanged |= perm.clearModes(modeFlags, true);
                    if (perm.modeFlags != 0) continue;
                    it.remove();
                }
                if (perms.size() != 0) continue;
                this.mGrantedUriPermissions.remove(this.mGrantedUriPermissions.keyAt(i));
                --N;
                --i;
            }
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeUriPermission(IApplicationThread caller, Uri uri, int modeFlags) {
        this.enforceNotIsolatedCaller("revokeUriPermission");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when revoking permission to uri " + uri);
            }
            if (uri == null) {
                Slog.w(TAG, "revokeUriPermission: null uri");
                return;
            }
            if ((modeFlags &= 3) == 0) {
                return;
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            String authority = uri.getAuthority();
            ProviderInfo pi = this.getProviderInfoLocked(authority, r.userId);
            if (pi == null) {
                Slog.w(TAG, "No content provider found for permission revoke: " + uri.toSafeString());
                return;
            }
            this.revokeUriPermissionLocked(r.uid, uri, modeFlags);
        }
    }

    private void removeUriPermissionsForPackageLocked(String packageName, int userHandle, boolean persistable) {
        if (userHandle == -1 && packageName == null) {
            throw new IllegalArgumentException("Must narrow by either package or user");
        }
        boolean persistChanged = false;
        int size = this.mGrantedUriPermissions.size();
        for (int i = 0; i < size; ++i) {
            if (userHandle != -1 && userHandle != UserHandle.getUserId(this.mGrantedUriPermissions.keyAt(i))) continue;
            Iterator<UriPermission> it = this.mGrantedUriPermissions.valueAt(i).values().iterator();
            while (it.hasNext()) {
                UriPermission perm = it.next();
                if (packageName != null && !perm.sourcePkg.equals(packageName) && !perm.targetPkg.equals(packageName)) continue;
                persistChanged |= perm.clearModes(-1, persistable);
                if (perm.modeFlags != 0) continue;
                it.remove();
            }
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder newUriPermissionOwner(String name) {
        this.enforceNotIsolatedCaller("newUriPermissionOwner");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = new UriPermissionOwner(this, name);
            return owner.getExternalTokenLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermissionFromOwner(IBinder token, int fromUid, String targetPkg, Uri uri, int modeFlags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (fromUid != Binder.getCallingUid() && Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("nice try");
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (uri == null) {
                throw new IllegalArgumentException("null uri");
            }
            this.grantUriPermissionLocked(fromUid, targetPkg, uri, modeFlags, owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeUriPermissionFromOwner(IBinder token, Uri uri, int mode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (uri == null) {
                owner.removeUriPermissionsLocked(mode);
            } else {
                owner.removeUriPermissionLocked(uri, mode);
            }
        }
    }

    private void schedulePersistUriGrants() {
        if (!this.mHandler.hasMessages(38)) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(38), 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGrantedUriPermissions() {
        block8: {
            ArrayList<UriPermission.Snapshot> persist = Lists.newArrayList();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    for (UriPermission perm : this.mGrantedUriPermissions.valueAt(i).values()) {
                        if (perm.persistedModeFlags == 0) continue;
                        persist.add(perm.snapshot());
                    }
                }
            }
            FileOutputStream fos = null;
            try {
                fos = this.mGrantFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                out.startDocument(null, true);
                out.startTag(null, TAG_URI_GRANTS);
                for (UriPermission.Snapshot perm : persist) {
                    out.startTag(null, TAG_URI_GRANT);
                    XmlUtils.writeIntAttribute(out, ATTR_USER_HANDLE, perm.userHandle);
                    out.attribute(null, ATTR_SOURCE_PKG, perm.sourcePkg);
                    out.attribute(null, ATTR_TARGET_PKG, perm.targetPkg);
                    out.attribute(null, ATTR_URI, String.valueOf(perm.uri));
                    XmlUtils.writeIntAttribute(out, ATTR_MODE_FLAGS, perm.persistedModeFlags);
                    XmlUtils.writeLongAttribute(out, ATTR_CREATED_TIME, perm.persistedCreateTime);
                    out.endTag(null, TAG_URI_GRANT);
                }
                out.endTag(null, TAG_URI_GRANTS);
                out.endDocument();
                this.mGrantFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block8;
                this.mGrantFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readGrantedUriPermissionsLocked() {
        long now = System.currentTimeMillis();
        FileInputStream fis = null;
        try {
            try {
                int type;
                fis = this.mGrantFile.openRead();
                XmlPullParser in = Xml.newPullParser();
                in.setInput(fis, null);
                while ((type = in.next()) != 1) {
                    String tag = in.getName();
                    if (type != 2 || !TAG_URI_GRANT.equals(tag)) continue;
                    int userHandle = XmlUtils.readIntAttribute(in, ATTR_USER_HANDLE);
                    String sourcePkg = in.getAttributeValue(null, ATTR_SOURCE_PKG);
                    String targetPkg = in.getAttributeValue(null, ATTR_TARGET_PKG);
                    Uri uri = Uri.parse(in.getAttributeValue(null, ATTR_URI));
                    int modeFlags = XmlUtils.readIntAttribute(in, ATTR_MODE_FLAGS);
                    long createdTime = XmlUtils.readLongAttribute(in, ATTR_CREATED_TIME, now);
                    ProviderInfo pi = this.getProviderInfoLocked(uri.getAuthority(), userHandle);
                    if (pi != null && sourcePkg.equals(pi.packageName)) {
                        int targetUid = -1;
                        try {
                            targetUid = AppGlobals.getPackageManager().getPackageUid(targetPkg, userHandle);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        if (targetUid == -1) continue;
                        UriPermission perm = this.findOrCreateUriPermissionLocked(sourcePkg, targetPkg, targetUid, uri);
                        perm.initPersistedModes(modeFlags, createdTime);
                        continue;
                    }
                    Slog.w(TAG, "Persisted grant for " + uri + " had source " + sourcePkg + " but instead found " + pi);
                }
                Object var18_19 = null;
            }
            catch (FileNotFoundException e) {
                Object var18_20 = null;
                IoUtils.closeQuietly(fis);
                return;
            }
            catch (IOException e) {
                Log.wtf(TAG, "Failed reading Uri grants", e);
                Object var18_21 = null;
                IoUtils.closeQuietly(fis);
                return;
            }
            catch (XmlPullParserException e) {
                Log.wtf(TAG, "Failed reading Uri grants", e);
                Object var18_22 = null;
                IoUtils.closeQuietly(fis);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            IoUtils.closeQuietly(fis);
            throw throwable;
        }
        IoUtils.closeQuietly(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takePersistableUriPermission(Uri uri, int modeFlags) {
        this.enforceNotIsolatedCaller("takePersistableUriPermission");
        Preconditions.checkFlagsArgument(modeFlags, 3);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            UriPermission perm = this.findUriPermissionLocked(callingUid, uri);
            if (perm == null) {
                throw new SecurityException("No permission grant found for UID " + callingUid + " and Uri " + uri.toSafeString());
            }
            boolean persistChanged = perm.takePersistableModes(modeFlags);
            if (persistChanged |= this.maybePrunePersistedUriGrantsLocked(callingUid)) {
                this.schedulePersistUriGrants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePersistableUriPermission(Uri uri, int modeFlags) {
        this.enforceNotIsolatedCaller("releasePersistableUriPermission");
        Preconditions.checkFlagsArgument(modeFlags, 3);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            UriPermission perm = this.findUriPermissionLocked(callingUid, uri);
            if (perm == null) {
                Slog.w(TAG, "No permission grant found for UID " + callingUid + " and Uri " + uri.toSafeString());
                return;
            }
            boolean persistChanged = perm.releasePersistableModes(modeFlags);
            this.removeUriPermissionIfNeededLocked(perm);
            if (persistChanged) {
                this.schedulePersistUriGrants();
            }
        }
    }

    private boolean maybePrunePersistedUriGrantsLocked(int uid) {
        ArrayMap<Uri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        if (perms.size() < 128) {
            return false;
        }
        ArrayList<UriPermission> persisted = Lists.newArrayList();
        for (UriPermission perm : perms.values()) {
            if (perm.persistedModeFlags == 0) continue;
            persisted.add(perm);
        }
        int trimCount = persisted.size() - 128;
        if (trimCount <= 0) {
            return false;
        }
        Collections.sort(persisted, new UriPermission.PersistedTimeComparator());
        for (int i = 0; i < trimCount; ++i) {
            UriPermission perm = (UriPermission)persisted.get(i);
            perm.releasePersistableModes(-1);
            this.removeUriPermissionIfNeededLocked(perm);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<android.content.UriPermission> getPersistedUriPermissions(String packageName, boolean incoming) {
        this.enforceNotIsolatedCaller("getPersistedUriPermissions");
        Preconditions.checkNotNull(packageName, "packageName");
        int callingUid = Binder.getCallingUid();
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            int packageUid = pm.getPackageUid(packageName, UserHandle.getUserId(callingUid));
            if (packageUid != callingUid) {
                throw new SecurityException("Package " + packageName + " does not belong to calling UID " + callingUid);
            }
        }
        catch (RemoteException e) {
            throw new SecurityException("Failed to verify package name ownership");
        }
        ArrayList<android.content.UriPermission> result = Lists.newArrayList();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (incoming) {
                ArrayMap<Uri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
                if (perms == null) {
                    Slog.w(TAG, "No permission grants found for " + packageName);
                } else {
                    int size = perms.size();
                    for (int i = 0; i < size; ++i) {
                        UriPermission perm = perms.valueAt(i);
                        if (!packageName.equals(perm.targetPkg) || perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            } else {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    ArrayMap<Uri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                    int permsSize = perms.size();
                    for (int j = 0; j < permsSize; ++j) {
                        UriPermission perm = perms.valueAt(j);
                        if (!packageName.equals(perm.sourcePkg) || perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            }
        }
        return new ParceledListSlice<android.content.UriPermission>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showWaitingForDebugger(IApplicationThread who, boolean waiting) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app;
            ProcessRecord processRecord = app = who != null ? this.getRecordForAppLocked(who) : null;
            if (app == null) {
                return;
            }
            Message msg = Message.obtain();
            msg.what = 6;
            msg.obj = app;
            msg.arg1 = waiting ? 1 : 0;
            this.mHandler.sendMessage(msg);
        }
    }

    @Override
    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        long homeAppMem = this.mProcessList.getMemLevel(6);
        long cachedAppMem = this.mProcessList.getMemLevel(9);
        outInfo.availMem = Process.getFreeMemory();
        outInfo.totalMem = Process.getTotalMemory();
        outInfo.threshold = homeAppMem;
        outInfo.lowMemory = outInfo.availMem < homeAppMem + (cachedAppMem - homeAppMem) / 2L;
        outInfo.hiddenAppThreshold = cachedAppMem;
        outInfo.secondaryServerThreshold = this.mProcessList.getMemLevel(5);
        outInfo.visibleAppThreshold = this.mProcessList.getMemLevel(1);
        outInfo.foregroundAppThreshold = this.mProcessList.getMemLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum, int flags, IThumbnailReceiver receiver) {
        ArrayList<ActivityManager.RunningTaskInfo> list = new ArrayList<ActivityManager.RunningTaskInfo>();
        PendingThumbnailsRecord pending = new PendingThumbnailsRecord(receiver);
        ActivityRecord topRecord = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.GET_TASKS") != 0) {
                if (receiver != null) {
                    try {
                        receiver.finished();
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                }
                String msg = "Permission Denial: getTasks() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.GET_TASKS";
                Slog.w(TAG, msg);
                throw new SecurityException(msg);
            }
            topRecord = this.mStackSupervisor.getTasksLocked(maxNum, receiver, pending, list);
            if (!pending.pendingRecords.isEmpty()) {
                this.mPendingThumbnails.add(pending);
            }
        }
        if (topRecord != null) {
            try {
                IApplicationThread topThumbnail = topRecord.app.thread;
                topThumbnail.requestThumbnail(topRecord.appToken);
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception thrown when requesting thumbnail", e);
                this.sendPendingThumbnail(null, topRecord.appToken, null, null, true);
            }
        }
        if (pending == null && receiver != null) {
            try {
                receiver.finished();
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        return list;
    }

    TaskRecord getMostRecentTask() {
        return this.mRecentTasks.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags, int userId) {
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "getRecentTasks", null);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.GET_TASKS", "getRecentTasks()");
            boolean detailed = this.checkCallingPermission("android.permission.GET_DETAILED_TASKS") == 0;
            IPackageManager pm = AppGlobals.getPackageManager();
            int N = this.mRecentTasks.size();
            ArrayList<ActivityManager.RecentTaskInfo> res = new ArrayList<ActivityManager.RecentTaskInfo>(maxNum < N ? maxNum : N);
            for (int i = 0; i < N && maxNum > 0; ++i) {
                TaskRecord tr = this.mRecentTasks.get(i);
                if (tr.userId != userId || i != 0 && (flags & 1) == 0 && tr.intent != null && (tr.intent.getFlags() & 0x800000) != 0) continue;
                ActivityManager.RecentTaskInfo rti = new ActivityManager.RecentTaskInfo();
                rti.id = tr.numActivities > 0 ? tr.taskId : -1;
                rti.persistentId = tr.taskId;
                rti.baseIntent = new Intent(tr.intent != null ? tr.intent : tr.affinityIntent);
                if (!detailed) {
                    rti.baseIntent.replaceExtras((Bundle)null);
                }
                rti.origActivity = tr.origActivity;
                rti.description = tr.lastDescription;
                rti.stackId = tr.stack.mStackId;
                if ((flags & 2) != 0) {
                    try {
                        if (rti.origActivity != null ? pm.getActivityInfo(rti.origActivity, 0, userId) == null : rti.baseIntent != null && pm.queryIntentActivities(rti.baseIntent, null, 0, userId) == null) {
                            continue;
                        }
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                res.add(rti);
                --maxNum;
            }
            return res;
        }
    }

    private TaskRecord recentTaskForIdLocked(int id2) {
        int N = this.mRecentTasks.size();
        for (int i = 0; i < N; ++i) {
            TaskRecord tr = this.mRecentTasks.get(i);
            if (tr.taskId != id2) continue;
            return tr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityManager.TaskThumbnails getTaskThumbnails(int id2) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.READ_FRAME_BUFFER", "getTaskThumbnails()");
            TaskRecord tr = this.recentTaskForIdLocked(id2);
            if (tr != null) {
                return tr.getTaskThumbnailsLocked();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getTaskTopThumbnail(int id2) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.READ_FRAME_BUFFER", "getTaskTopThumbnail()");
            TaskRecord tr = this.recentTaskForIdLocked(id2);
            if (tr != null) {
                return tr.getTaskTopThumbnailLocked();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeSubTask(int taskId, int subTaskIndex) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            long ident;
            block7: {
                boolean bl2;
                block6: {
                    this.enforceCallingPermission("android.permission.REMOVE_TASKS", "removeSubTask()");
                    ident = Binder.clearCallingIdentity();
                    try {
                        TaskRecord tr = this.recentTaskForIdLocked(taskId);
                        if (tr != null) {
                            bl2 = tr.removeTaskActivitiesLocked(subTaskIndex, true) != null;
                            Object var9_8 = null;
                            break block6;
                        }
                        bl = false;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        Binder.restoreCallingIdentity(ident);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity(ident);
                return bl2;
            }
            Object var9_9 = null;
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
    }

    private void killUnneededProcessLocked(ProcessRecord pr, String reason) {
        if (!pr.killedByAm) {
            Slog.i(TAG, "Killing " + pr.toShortString() + " (adj " + pr.setAdj + "): " + reason);
            EventLog.writeEvent(30023, pr.userId, pr.pid, pr.processName, pr.setAdj, reason);
            pr.killedByAm = true;
            Process.killProcessQuiet(pr.pid);
        }
    }

    private void cleanUpRemovedTaskLocked(TaskRecord tr, int flags) {
        tr.disposeThumbnail();
        this.mRecentTasks.remove(tr);
        boolean killProcesses = (flags & 1) != 0;
        Intent baseIntent = new Intent(tr.intent != null ? tr.intent : tr.affinityIntent);
        ComponentName component = baseIntent.getComponent();
        if (component == null) {
            Slog.w(TAG, "Now component for base intent of task: " + tr);
            return;
        }
        this.mServices.cleanUpRemovedTaskLocked(tr, component, baseIntent);
        if (killProcesses) {
            int i;
            String pkg = component.getPackageName();
            ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
            ArrayMap<String, SparseArray<ProcessRecord>> pmap = this.mProcessNames.getMap();
            for (i = 0; i < pmap.size(); ++i) {
                SparseArray<ProcessRecord> uids = pmap.valueAt(i);
                for (int j = 0; j < uids.size(); ++j) {
                    ProcessRecord proc = uids.valueAt(j);
                    if (proc.userId != tr.userId || !proc.pkgList.containsKey(pkg)) continue;
                    procs.add(proc);
                }
            }
            for (i = 0; i < procs.size(); ++i) {
                ProcessRecord pr = (ProcessRecord)procs.get(i);
                if (pr == this.mHomeProcess) continue;
                if (pr.setSchedGroup == 0) {
                    this.killUnneededProcessLocked(pr, "remove task");
                    continue;
                }
                pr.waitingToKill = "remove task";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeTask(int taskId, int flags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident;
            block7: {
                TaskRecord tr;
                block9: {
                    boolean bl;
                    block10: {
                        boolean bl2;
                        block8: {
                            this.enforceCallingPermission("android.permission.REMOVE_TASKS", "removeTask()");
                            ident = Binder.clearCallingIdentity();
                            try {
                                tr = this.recentTaskForIdLocked(taskId);
                                if (tr == null) break block7;
                                ActivityRecord r = tr.removeTaskActivitiesLocked(-1, false);
                                if (r != null) {
                                    this.cleanUpRemovedTaskLocked(tr, flags);
                                    bl2 = true;
                                    Object var10_9 = null;
                                    break block8;
                                }
                                if (tr.mActivities.size() != 0) break block9;
                                this.cleanUpRemovedTaskLocked(tr, flags);
                                bl = true;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                Binder.restoreCallingIdentity(ident);
                                throw throwable;
                            }
                        }
                        Binder.restoreCallingIdentity(ident);
                        return bl2;
                    }
                    Object var10_10 = null;
                    Binder.restoreCallingIdentity(ident);
                    return bl;
                }
                Slog.w(TAG, "removeTask: task " + taskId + " does not have activities to remove, " + " but numActivities=" + tr.numActivities + ": " + tr);
            }
            Object var10_11 = null;
            Binder.restoreCallingIdentity(ident);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskToFront(int task, int flags, Bundle options) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskToFront()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), "Task to front")) {
                ActivityOptions.abort(options);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.findTaskToMoveToFrontLocked(task, flags, options);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            ActivityOptions.abort(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskToBack(int taskId) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskToBack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            TaskRecord tr = this.recentTaskForIdLocked(taskId);
            if (tr != null) {
                ActivityStack stack = tr.stack;
                if (stack.mResumedActivity != null && stack.mResumedActivity.task == tr && !this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), "Task to back")) {
                    return;
                }
                long origId = Binder.clearCallingIdentity();
                try {
                    stack.moveTaskToBackLocked(taskId, null);
                    Object var8_6 = null;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    Binder.restoreCallingIdentity(origId);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(origId);
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) {
        this.enforceNotIsolatedCaller("moveActivityTaskToBack");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            int taskId = ActivityRecord.getTaskForActivityLocked(token, !nonRoot);
            if (taskId >= 0) {
                return ActivityRecord.getStackLocked(token).moveTaskToBackLocked(taskId, null);
            }
            Binder.restoreCallingIdentity(origId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskBackwards(int task) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskBackwards()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), "Task backwards")) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.moveTaskBackwardsLocked(task);
            Binder.restoreCallingIdentity(origId);
        }
    }

    private final void moveTaskBackwardsLocked(int task) {
        Slog.e(TAG, "moveTaskBackwards not yet implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int createStack(int taskId, int relativeStackBoxId, int position, float weight) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "createStack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int n;
            long ident = Binder.clearCallingIdentity();
            try {
                int stackId = this.mStackSupervisor.createStack();
                this.mWindowManager.createStack(stackId, relativeStackBoxId, position, weight);
                if (taskId > 0) {
                    this.moveTaskToStack(taskId, stackId, true);
                }
                n = stackId;
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "moveTaskToStack()");
        if (stackId == 0) {
            Slog.e(TAG, "moveTaskToStack: Attempt to move task " + taskId + " to home stack", new RuntimeException("here").fillInStackTrace());
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.moveTaskToStack(taskId, stackId, toTop);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeStackBox(int stackBoxId, float weight) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "resizeStackBox()");
        long ident = Binder.clearCallingIdentity();
        try {
            this.mWindowManager.resizeStackBox(stackBoxId, weight);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ActivityManager.StackInfo> getStacks() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ArrayList<ActivityManager.StackInfo> list = new ArrayList<ActivityManager.StackInfo>();
            ArrayList<ActivityStack> stacks = this.mStackSupervisor.getStacks();
            for (ActivityStack stack : stacks) {
                int stackId;
                ActivityManager.StackInfo stackInfo = new ActivityManager.StackInfo();
                stackInfo.stackId = stackId = stack.mStackId;
                stackInfo.bounds = this.mWindowManager.getStackBounds(stackId);
                ArrayList<TaskRecord> tasks = stack.getAllTasks();
                int numTasks = tasks.size();
                int[] taskIds = new int[numTasks];
                String[] taskNames = new String[numTasks];
                for (int i = 0; i < numTasks; ++i) {
                    TaskRecord task = tasks.get(i);
                    taskIds[i] = task.taskId;
                    taskNames[i] = task.origActivity != null ? task.origActivity.flattenToString() : (task.realActivity != null ? task.realActivity.flattenToString() : (task.getTopActivity() != null ? task.getTopActivity().packageName : "unknown"));
                }
                stackInfo.taskIds = taskIds;
                stackInfo.taskNames = taskNames;
                list.add(stackInfo);
            }
            return list;
        }
    }

    private void addStackInfoToStackBoxInfo(ActivityManager.StackBoxInfo stackBoxInfo, List<ActivityManager.StackInfo> stackInfos) {
        int stackId = stackBoxInfo.stackId;
        if (stackId >= 0) {
            for (ActivityManager.StackInfo stackInfo : stackInfos) {
                if (stackId != stackInfo.stackId) continue;
                stackBoxInfo.stack = stackInfo;
                stackInfos.remove(stackInfo);
                return;
            }
        } else {
            this.addStackInfoToStackBoxInfo(stackBoxInfo.children[0], stackInfos);
            this.addStackInfoToStackBoxInfo(stackBoxInfo.children[1], stackInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.StackBoxInfo> getStackBoxes() {
        Object object;
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getStackBoxes()");
        long ident = Binder.clearCallingIdentity();
        try {
            ArrayList<ActivityManager.StackBoxInfo> stackBoxInfos = this.mWindowManager.getStackBoxInfos();
            object = this;
            synchronized (object) {
                ArrayList<ActivityManager.StackInfo> stackInfos = this.getStacks();
                for (ActivityManager.StackBoxInfo stackBoxInfo : stackBoxInfos) {
                    this.addStackInfoToStackBoxInfo(stackBoxInfo, stackInfos);
                }
            }
            object = stackBoxInfos;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityManager.StackBoxInfo getStackBoxInfo(int stackBoxId) {
        ActivityManagerService activityManagerService;
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getStackBoxInfo()");
        long ident = Binder.clearCallingIdentity();
        try {
            ArrayList<ActivityManager.StackBoxInfo> stackBoxInfos = this.mWindowManager.getStackBoxInfos();
            ActivityManager.StackBoxInfo info = null;
            activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ActivityManager.StackInfo> stackInfos = this.getStacks();
                for (ActivityManager.StackBoxInfo stackBoxInfo : stackBoxInfos) {
                    this.addStackInfoToStackBoxInfo(stackBoxInfo, stackInfos);
                    if (stackBoxInfo.stackBoxId != stackBoxId) continue;
                    info = stackBoxInfo;
                }
            }
            activityManagerService = info;
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return activityManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskForActivity(IBinder token, boolean onlyRoot) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return ActivityRecord.getTaskForActivityLocked(token, onlyRoot);
        }
    }

    @Override
    public void reportThumbnail(IBinder token, Bitmap thumbnail, CharSequence description) {
        long origId = Binder.clearCallingIdentity();
        this.sendPendingThumbnail(null, token, thumbnail, description, true);
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendPendingThumbnail(ActivityRecord r, IBinder token, Bitmap thumbnail, CharSequence description, boolean always) {
        TaskRecord task;
        ArrayList<PendingThumbnailsRecord> receivers = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (r == null && (r = ActivityRecord.isInStackLocked(token)) == null) {
                return;
            }
            if (thumbnail == null && r.thumbHolder != null) {
                thumbnail = r.thumbHolder.lastThumbnail;
                description = r.thumbHolder.lastDescription;
            }
            if (thumbnail == null && !always) {
                return;
            }
            task = r.task;
            int N = this.mPendingThumbnails.size();
            int i = 0;
            while (i < N) {
                PendingThumbnailsRecord pr = this.mPendingThumbnails.get(i);
                if (pr.pendingRecords.remove(r)) {
                    if (receivers == null) {
                        receivers = new ArrayList<PendingThumbnailsRecord>();
                    }
                    receivers.add(pr);
                    if (pr.pendingRecords.size() == 0) {
                        pr.finished = true;
                        this.mPendingThumbnails.remove(i);
                        --N;
                        continue;
                    }
                }
                ++i;
            }
        }
        if (receivers != null) {
            int N = receivers.size();
            for (int i = 0; i < N; ++i) {
                try {
                    PendingThumbnailsRecord pr = (PendingThumbnailsRecord)receivers.get(i);
                    pr.receiver.newThumbnail(task != null ? task.taskId : -1, thumbnail, description);
                    if (!pr.finished) continue;
                    pr.receiver.finished();
                    continue;
                }
                catch (Exception e) {
                    Slog.w(TAG, "Exception thrown when sending thumbnail", e);
                }
            }
        }
    }

    private final List<ProviderInfo> generateApplicationProvidersLocked(ProcessRecord app) {
        List<ProviderInfo> providers = null;
        try {
            providers = AppGlobals.getPackageManager().queryContentProviders(app.processName, app.uid, 3072);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        int userId = app.userId;
        if (providers != null) {
            int N = providers.size();
            app.pubProviders.ensureCapacity(N + app.pubProviders.size());
            for (int i = 0; i < N; ++i) {
                ProviderInfo cpi = providers.get(i);
                boolean singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags);
                if (singleton && UserHandle.getUserId(app.uid) != 0) {
                    providers.remove(i);
                    --N;
                    --i;
                    continue;
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                ContentProviderRecord cpr = this.mProviderMap.getProviderByClass(comp, userId);
                if (cpr == null) {
                    cpr = new ContentProviderRecord(this, cpi, app.info, comp, singleton);
                    this.mProviderMap.putProviderByClass(comp, cpr);
                }
                app.pubProviders.put(cpi.name, cpr);
                if (!cpi.multiprocess || !"android".equals(cpi.packageName)) {
                    app.addPackage(cpi.applicationInfo.packageName, this.mProcessStats);
                }
                this.ensurePackageDexOpt(cpi.applicationInfo.packageName);
            }
        }
        return providers;
    }

    private final String checkContentProviderPermissionLocked(ProviderInfo cpi, ProcessRecord r) {
        ArrayMap<Uri, UriPermission> perms;
        int callingUid;
        int callingPid = r != null ? r.pid : Binder.getCallingPid();
        int n = callingUid = r != null ? r.uid : Binder.getCallingUid();
        if (this.checkComponentPermission(cpi.readPermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        if (this.checkComponentPermission(cpi.writePermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        PathPermission[] pps = cpi.pathPermissions;
        if (pps != null) {
            int i = pps.length;
            while (i > 0) {
                PathPermission pp;
                if (this.checkComponentPermission((pp = pps[--i]).getReadPermission(), callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
                    return null;
                }
                if (this.checkComponentPermission(pp.getWritePermission(), callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) != 0) continue;
                return null;
            }
        }
        if ((perms = this.mGrantedUriPermissions.get(callingUid)) != null) {
            for (Map.Entry<Uri, UriPermission> uri : perms.entrySet()) {
                if (!uri.getKey().getAuthority().equals(cpi.authority)) continue;
                return null;
            }
        }
        String msg = !cpi.exported ? "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ") that is not exported from uid " + cpi.applicationInfo.uid : "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + cpi.readPermission + " or " + cpi.writePermission;
        Slog.w(TAG, msg);
        return msg;
    }

    ContentProviderConnection incProviderCountLocked(ProcessRecord r, ContentProviderRecord cpr, IBinder externalProcessToken, boolean stable) {
        if (r != null) {
            for (int i = 0; i < r.conProviders.size(); ++i) {
                ContentProviderConnection conn = r.conProviders.get(i);
                if (conn.provider != cpr) continue;
                if (stable) {
                    ++conn.stableCount;
                    ++conn.numStableIncs;
                } else {
                    ++conn.unstableCount;
                    ++conn.numUnstableIncs;
                }
                return conn;
            }
            ContentProviderConnection conn = new ContentProviderConnection(cpr, r);
            if (stable) {
                conn.stableCount = 1;
                conn.numStableIncs = 1;
            } else {
                conn.unstableCount = 1;
                conn.numUnstableIncs = 1;
            }
            cpr.connections.add(conn);
            r.conProviders.add(conn);
            return conn;
        }
        cpr.addExternalProcessHandleLocked(externalProcessToken);
        return null;
    }

    boolean decProviderCountLocked(ContentProviderConnection conn, ContentProviderRecord cpr, IBinder externalProcessToken, boolean stable) {
        if (conn != null) {
            cpr = conn.provider;
            if (stable) {
                --conn.stableCount;
            } else {
                --conn.unstableCount;
            }
            if (conn.stableCount == 0 && conn.unstableCount == 0) {
                cpr.connections.remove(conn);
                conn.client.conProviders.remove(conn);
                return true;
            }
            return false;
        }
        cpr.removeExternalProcessHandleLocked(externalProcessToken);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final IActivityManager.ContentProviderHolder getContentProviderImpl(IApplicationThread caller, String name, IBinder token, boolean stable, int userId) {
        ContentProviderRecord cpr;
        ContentProviderConnection conn = null;
        ProviderInfo cpi = null;
        Object object = this;
        synchronized (object) {
            boolean providerRunning;
            ProcessRecord r = null;
            if (caller != null && (r = this.getRecordForAppLocked(caller)) == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when getting content provider " + name);
            }
            cpr = this.mProviderMap.getProviderByName(name, userId);
            boolean bl = providerRunning = cpr != null;
            if (providerRunning) {
                boolean success;
                cpi = cpr.info;
                String msg = this.checkContentProviderPermissionLocked(cpi, r);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                if (r != null && cpr.canRunHere(r)) {
                    IActivityManager.ContentProviderHolder holder = cpr.newHolder(null);
                    holder.provider = null;
                    return holder;
                }
                long origId = Binder.clearCallingIdentity();
                conn = this.incProviderCountLocked(r, cpr, token, stable);
                if (conn != null && conn.stableCount + conn.unstableCount == 1 && cpr.proc != null && r.setAdj <= 2) {
                    this.updateLruProcessLocked(cpr.proc, false, null);
                }
                if (cpr.proc != null && !(success = this.updateOomAdjLocked(cpr.proc))) {
                    Slog.i(TAG, "Existing provider " + cpr.name.flattenToShortString() + " is crashing; detaching " + r);
                    boolean lastRef = this.decProviderCountLocked(conn, cpr, token, stable);
                    this.appDiedLocked(cpr.proc, cpr.proc.pid, cpr.proc.thread);
                    if (!lastRef) {
                        return null;
                    }
                    providerRunning = false;
                    conn = null;
                }
                Binder.restoreCallingIdentity(origId);
            }
            if (!providerRunning) {
                int i;
                boolean firstClass;
                try {
                    cpi = AppGlobals.getPackageManager().resolveContentProvider(name, 3072, userId);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
                if (cpi == null) {
                    return null;
                }
                boolean singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags);
                if (singleton) {
                    userId = 0;
                }
                cpi.applicationInfo = this.getAppInfoForUser(cpi.applicationInfo, userId);
                String msg = this.checkContentProviderPermissionLocked(cpi, r);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                if (!(this.mProcessesReady || this.mDidUpdate || this.mWaitingUpdate || cpi.processName.equals("system"))) {
                    throw new IllegalArgumentException("Attempt to launch content provider before system ready");
                }
                if (this.mStartedUsers.get(userId) == null) {
                    Slog.w(TAG, "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": user " + userId + " is stopped");
                    return null;
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                cpr = this.mProviderMap.getProviderByClass(comp, userId);
                boolean bl2 = firstClass = cpr == null;
                if (firstClass) {
                    try {
                        ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(cpi.applicationInfo.packageName, 1024, userId);
                        if (ai == null) {
                            Slog.w(TAG, "No package info for content provider " + cpi.name);
                            return null;
                        }
                        ai = this.getAppInfoForUser(ai, userId);
                        cpr = new ContentProviderRecord(this, cpi, ai, comp, singleton);
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                }
                if (r != null && cpr.canRunHere(r)) {
                    return cpr.newHolder(null);
                }
                int N = this.mLaunchingProviders.size();
                for (i = 0; i < N && this.mLaunchingProviders.get(i) != cpr; ++i) {
                }
                if (i >= N) {
                    long origId;
                    block46: {
                        IActivityManager.ContentProviderHolder contentProviderHolder;
                        block45: {
                            origId = Binder.clearCallingIdentity();
                            try {
                                try {
                                    AppGlobals.getPackageManager().setPackageStoppedState(cpr.appInfo.packageName, false, userId);
                                }
                                catch (RemoteException e) {
                                }
                                catch (IllegalArgumentException e) {
                                    Slog.w(TAG, "Failed trying to unstop package " + cpr.appInfo.packageName + ": " + e);
                                }
                                ProcessRecord proc = this.getProcessRecordLocked(cpi.processName, cpr.appInfo.uid, false);
                                if (proc != null && proc.thread != null) {
                                    proc.pubProviders.put(cpi.name, cpr);
                                    try {
                                        proc.thread.scheduleInstallProvider(cpi);
                                    }
                                    catch (RemoteException e) {}
                                } else {
                                    proc = this.startProcessLocked(cpi.processName, cpr.appInfo, false, 0, "content provider", new ComponentName(cpi.applicationInfo.packageName, cpi.name), false, false, false);
                                    if (proc == null) {
                                        Slog.w(TAG, "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": process is bad");
                                        contentProviderHolder = null;
                                        Object var23_31 = null;
                                        break block45;
                                    }
                                }
                                cpr.launchingApp = proc;
                                this.mLaunchingProviders.add(cpr);
                                break block46;
                            }
                            catch (Throwable throwable) {
                                Object var23_33 = null;
                                Binder.restoreCallingIdentity(origId);
                                throw throwable;
                            }
                        }
                        Binder.restoreCallingIdentity(origId);
                        return contentProviderHolder;
                    }
                    Object var23_32 = null;
                    Binder.restoreCallingIdentity(origId);
                }
                if (firstClass) {
                    this.mProviderMap.putProviderByClass(comp, cpr);
                }
                this.mProviderMap.putProviderByName(name, cpr);
                conn = this.incProviderCountLocked(r, cpr, token, stable);
                if (conn != null) {
                    conn.waiting = true;
                }
            }
        }
        object = cpr;
        synchronized (object) {
            while (cpr.provider == null) {
                Object var26_35;
                if (cpr.launchingApp == null) {
                    Slog.w(TAG, "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": launching app became null");
                    EventLog.writeEvent(30036, UserHandle.getUserId(cpi.applicationInfo.uid), cpi.applicationInfo.packageName, cpi.applicationInfo.uid, name);
                    return null;
                }
                try {
                    try {
                        if (conn != null) {
                            conn.waiting = true;
                        }
                        cpr.wait();
                    }
                    catch (InterruptedException ex) {
                        var26_35 = null;
                        if (conn == null) continue;
                        conn.waiting = false;
                        continue;
                    }
                    var26_35 = null;
                    if (conn == null) continue;
                    conn.waiting = false;
                }
                catch (Throwable throwable) {
                    var26_35 = null;
                    if (conn == null) throw throwable;
                    conn.waiting = false;
                    throw throwable;
                }
            }
        }
        if (cpr == null) return null;
        IActivityManager.ContentProviderHolder contentProviderHolder = cpr.newHolder(conn);
        return contentProviderHolder;
    }

    @Override
    public final IActivityManager.ContentProviderHolder getContentProvider(IApplicationThread caller, String name, int userId, boolean stable) {
        this.enforceNotIsolatedCaller("getContentProvider");
        if (caller == null) {
            String msg = "null IApplicationThread when getting content provider " + name;
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "getContentProvider", null);
        return this.getContentProviderImpl(caller, name, null, stable, userId);
    }

    @Override
    public IActivityManager.ContentProviderHolder getContentProviderExternal(String name, int userId, IBinder token) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call getContentProviderExternal()");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "getContentProvider", null);
        return this.getContentProviderExternalUnchecked(name, token, userId);
    }

    private IActivityManager.ContentProviderHolder getContentProviderExternalUnchecked(String name, IBinder token, int userId) {
        return this.getContentProviderImpl(null, name, token, true, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContentProvider(IBinder connection, boolean stable) {
        this.enforceNotIsolatedCaller("removeContentProvider");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ContentProviderConnection conn;
            try {
                conn = (ContentProviderConnection)connection;
            }
            catch (ClassCastException e) {
                String msg = "removeContentProvider: " + connection + " not a ContentProviderConnection";
                Slog.w(TAG, msg);
                throw new IllegalArgumentException(msg);
            }
            if (conn == null) {
                throw new NullPointerException("connection is null");
            }
            if (this.decProviderCountLocked(conn, null, null, stable)) {
                this.updateOomAdjLocked();
            }
        }
    }

    @Override
    public void removeContentProviderExternal(String name, IBinder token) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call removeContentProviderExternal()");
        this.removeContentProviderExternalUnchecked(name, token, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContentProviderExternalUnchecked(String name, IBinder token, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ContentProviderRecord cpr = this.mProviderMap.getProviderByName(name, userId);
            if (cpr == null) {
                return;
            }
            ComponentName comp = new ComponentName(cpr.info.packageName, cpr.info.name);
            ContentProviderRecord localCpr = this.mProviderMap.getProviderByClass(comp, userId);
            if (localCpr.hasExternalProcessHandles()) {
                if (localCpr.removeExternalProcessHandleLocked(token)) {
                    this.updateOomAdjLocked();
                } else {
                    Slog.e(TAG, "Attmpt to remove content provider " + localCpr + " with no external reference for token: " + token + ".");
                }
            } else {
                Slog.e(TAG, "Attmpt to remove content provider: " + localCpr + " with no external references.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void publishContentProviders(IApplicationThread caller, List<IActivityManager.ContentProviderHolder> providers) {
        if (providers == null) {
            return;
        }
        this.enforceNotIsolatedCaller("publishContentProviders");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when publishing content providers");
            }
            long origId = Binder.clearCallingIdentity();
            int N = providers.size();
            for (int i = 0; i < N; ++i) {
                ContentProviderRecord dst;
                IActivityManager.ContentProviderHolder src = providers.get(i);
                if (src == null || src.info == null || src.provider == null || (dst = r.pubProviders.get(src.info.name)) == null) continue;
                ComponentName comp = new ComponentName(dst.info.packageName, dst.info.name);
                this.mProviderMap.putProviderByClass(comp, dst);
                String[] names = dst.info.authority.split(";");
                for (int j = 0; j < names.length; ++j) {
                    this.mProviderMap.putProviderByName(names[j], dst);
                }
                int NL = this.mLaunchingProviders.size();
                for (int j = 0; j < NL; ++j) {
                    if (this.mLaunchingProviders.get(j) != dst) continue;
                    this.mLaunchingProviders.remove(j);
                    --j;
                    --NL;
                }
                ContentProviderRecord contentProviderRecord = dst;
                synchronized (contentProviderRecord) {
                    dst.provider = src.provider;
                    dst.proc = r;
                    dst.notifyAll();
                }
                this.updateOomAdjLocked(r);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refContentProvider(IBinder connection, int stable, int unstable) {
        ContentProviderConnection conn;
        try {
            conn = (ContentProviderConnection)connection;
        }
        catch (ClassCastException e) {
            String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
            Slog.w(TAG, msg);
            throw new IllegalArgumentException(msg);
        }
        if (conn == null) {
            throw new NullPointerException("connection is null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (stable > 0) {
                conn.numStableIncs += stable;
            }
            if ((stable = conn.stableCount + stable) < 0) {
                throw new IllegalStateException("stableCount < 0: " + stable);
            }
            if (unstable > 0) {
                conn.numUnstableIncs += unstable;
            }
            if ((unstable = conn.unstableCount + unstable) < 0) {
                throw new IllegalStateException("unstableCount < 0: " + unstable);
            }
            if (stable + unstable <= 0) {
                throw new IllegalStateException("ref counts can't go to zero here: stable=" + stable + " unstable=" + unstable);
            }
            conn.stableCount = stable;
            conn.unstableCount = unstable;
            return !conn.dead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unstableProviderDied(IBinder connection) {
        IContentProvider provider;
        ContentProviderConnection conn;
        try {
            conn = (ContentProviderConnection)connection;
        }
        catch (ClassCastException e) {
            String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
            Slog.w(TAG, msg);
            throw new IllegalArgumentException(msg);
        }
        if (conn == null) {
            throw new NullPointerException("connection is null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            provider = conn.provider.provider;
        }
        if (provider == null) {
            return;
        }
        if (provider.asBinder().pingBinder()) {
            activityManagerService = this;
            synchronized (activityManagerService) {
                Slog.w(TAG, "unstableProviderDied: caller " + Binder.getCallingUid() + " says " + conn + " died, but we don't agree");
                return;
            }
        }
        activityManagerService = this;
        synchronized (activityManagerService) {
            if (conn.provider.provider != provider) {
                return;
            }
            ProcessRecord proc = conn.provider.proc;
            if (proc == null || proc.thread == null) {
                return;
            }
            Slog.i(TAG, "Process " + proc.processName + " (pid " + proc.pid + ") early provider death");
            long ident = Binder.clearCallingIdentity();
            try {
                this.appDiedLocked(proc, proc.pid, proc.thread);
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appNotRespondingViaProvider(IBinder connection) {
        this.enforceCallingPermission("android.permission.REMOVE_TASKS", "appNotRespondingViaProvider()");
        ContentProviderConnection conn = (ContentProviderConnection)connection;
        if (conn == null) {
            Slog.w(TAG, "ContentProviderConnection is null");
            return;
        }
        ProcessRecord host = conn.provider.proc;
        if (host == null) {
            Slog.w(TAG, "Failed to find hosting ProcessRecord");
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.appNotResponding(host, null, null, false, "ContentProvider not responding");
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void installSystemProviders() {
        List<ProviderInfo> providers;
        ActivityManagerService activityManagerService = mSelf;
        synchronized (activityManagerService) {
            ProcessRecord app = ActivityManagerService.mSelf.mProcessNames.get("system", 1000);
            providers = mSelf.generateApplicationProvidersLocked(app);
            if (providers != null) {
                for (int i = providers.size() - 1; i >= 0; --i) {
                    ProviderInfo pi = providers.get(i);
                    if ((pi.applicationInfo.flags & 1) != 0) continue;
                    Slog.w(TAG, "Not installing system proc provider " + pi.name + ": not system .apk");
                    providers.remove(i);
                }
            }
        }
        if (providers != null) {
            mSystemThread.installSystemProviders(providers);
        }
        ActivityManagerService.mSelf.mCoreSettingsObserver = new CoreSettingsObserver(mSelf);
        ActivityManagerService.mSelf.mUsageStatsService.monitorPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getProviderMimeType(Uri uri, int userId) {
        IActivityManager.ContentProviderHolder holder;
        long ident;
        String name;
        block10: {
            String string2;
            this.enforceNotIsolatedCaller("getProviderMimeType");
            userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "getProviderMimeType", null);
            name = uri.getAuthority();
            ident = Binder.clearCallingIdentity();
            holder = null;
            try {
                try {
                    holder = this.getContentProviderExternalUnchecked(name, null, userId);
                    if (holder == null) break block10;
                    string2 = holder.provider.getType(uri);
                    Object var10_8 = null;
                    if (holder != null) {
                        this.removeContentProviderExternalUnchecked(name, null, userId);
                    }
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Content provider dead retrieving " + uri, e);
                    String string3 = null;
                    Object var10_10 = null;
                    if (holder != null) {
                        this.removeContentProviderExternalUnchecked(name, null, userId);
                    }
                    Binder.restoreCallingIdentity(ident);
                    return string3;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (holder != null) {
                    this.removeContentProviderExternalUnchecked(name, null, userId);
                }
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return string2;
        }
        Object var10_9 = null;
        if (holder != null) {
            this.removeContentProviderExternalUnchecked(name, null, userId);
        }
        Binder.restoreCallingIdentity(ident);
        return null;
    }

    final ProcessRecord newProcessRecordLocked(ApplicationInfo info, String customProcess, boolean isolated) {
        int uid;
        BatteryStatsImpl stats;
        String proc;
        block3: {
            proc = customProcess != null ? customProcess : info.processName;
            Object ps = null;
            stats = this.mBatteryStatsService.getActiveStatistics();
            uid = info.uid;
            if (isolated) {
                int userId = UserHandle.getUserId(uid);
                int stepsLeft = 1000;
                do {
                    if (this.mNextIsolatedProcessUid < 99000 || this.mNextIsolatedProcessUid > 99999) {
                        this.mNextIsolatedProcessUid = 99000;
                    }
                    uid = UserHandle.getUid(userId, this.mNextIsolatedProcessUid);
                    ++this.mNextIsolatedProcessUid;
                    if (this.mIsolatedProcesses.indexOfKey(uid) < 0) break block3;
                } while (--stepsLeft > 0);
                return null;
            }
        }
        return new ProcessRecord(stats, info, proc, uid);
    }

    final ProcessRecord addAppLocked(ApplicationInfo info, boolean isolated) {
        ProcessRecord app = !isolated ? this.getProcessRecordLocked(info.processName, info.uid, true) : null;
        if (app == null) {
            app = this.newProcessRecordLocked(info, null, isolated);
            this.mProcessNames.put(info.processName, app.uid, app);
            if (isolated) {
                this.mIsolatedProcesses.put(app.uid, app);
            }
            this.updateLruProcessLocked(app, false, null);
            this.updateOomAdjLocked();
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(info.packageName, false, UserHandle.getUserId(app.uid));
        }
        catch (RemoteException e) {
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Failed trying to unstop package " + info.packageName + ": " + e);
        }
        if ((info.flags & 9) == 9) {
            app.persistent = true;
            app.maxAdj = -12;
        }
        if (app.thread == null && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            this.startProcessLocked(app, "added application", app.processName);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unhandledBack() {
        this.enforceCallingPermission("android.permission.FORCE_BACK", "unhandledBack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                this.getFocusedStack().unhandledBackLocked();
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openContentUri(Uri uri) throws RemoteException {
        this.enforceNotIsolatedCaller("openContentUri");
        int userId = UserHandle.getCallingUserId();
        String name = uri.getAuthority();
        IActivityManager.ContentProviderHolder cph = this.getContentProviderExternalUnchecked(name, null, userId);
        ParcelFileDescriptor pfd = null;
        if (cph != null) {
            sCallerIdentity.set(new Identity(Binder.getCallingPid(), Binder.getCallingUid()));
            try {
                try {
                    pfd = cph.provider.openFile(null, uri, "r", null);
                }
                catch (FileNotFoundException e) {
                    Object var8_7 = null;
                    sCallerIdentity.remove();
                }
                Object var8_6 = null;
                sCallerIdentity.remove();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                sCallerIdentity.remove();
                throw throwable;
            }
            this.removeContentProviderExternalUnchecked(name, null, userId);
        } else {
            Slog.d(TAG, "Failed to get provider for authority '" + name + "'");
        }
        return pfd;
    }

    public boolean isSleepingOrShuttingDown() {
        return this.mSleeping || this.mShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goingToSleep() {
        if (this.checkCallingPermission("android.permission.DEVICE_POWER") != 0) {
            throw new SecurityException("Requires permission android.permission.DEVICE_POWER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mWentToSleep = true;
            this.updateEventDispatchingLocked();
            if (!this.mSleeping) {
                this.mSleeping = true;
                this.mStackSupervisor.goingToSleepLocked();
                this.checkExcessivePowerUsageLocked(false);
                this.mHandler.removeMessages(27);
                Message nmsg = this.mHandler.obtainMessage(27);
                this.mHandler.sendMessageDelayed(nmsg, 900000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown(int timeout) {
        if (this.checkCallingPermission("android.permission.SHUTDOWN") != 0) {
            throw new SecurityException("Requires permission android.permission.SHUTDOWN");
        }
        boolean timedout = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mShuttingDown = true;
            this.updateEventDispatchingLocked();
            timedout = this.mStackSupervisor.shutdownLocked(timeout);
        }
        this.mAppOpsService.shutdown();
        this.mUsageStatsService.shutdown();
        this.mBatteryStatsService.shutdown();
        activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessStats.shutdownLocked();
        }
        return timedout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activitySlept(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                this.mStackSupervisor.activitySleptLocked(r);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    void logLockScreen(String msg) {
    }

    private void comeOutOfSleepIfNeededLocked() {
        if (!this.mWentToSleep && !this.mLockScreenShown && this.mSleeping) {
            this.mSleeping = false;
            this.mStackSupervisor.comeOutOfSleepIfNeededLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakingUp() {
        if (this.checkCallingPermission("android.permission.DEVICE_POWER") != 0) {
            throw new SecurityException("Requires permission android.permission.DEVICE_POWER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mWentToSleep = false;
            this.updateEventDispatchingLocked();
            this.comeOutOfSleepIfNeededLocked();
        }
    }

    private void updateEventDispatchingLocked() {
        this.mWindowManager.setEventDispatching(this.mBooted && !this.mWentToSleep && !this.mShuttingDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockScreenShown(boolean shown) {
        if (this.checkCallingPermission("android.permission.DEVICE_POWER") != 0) {
            throw new SecurityException("Requires permission android.permission.DEVICE_POWER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mLockScreenShown = shown;
                this.comeOutOfSleepIfNeededLocked();
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("Requires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = SystemClock.uptimeMillis() + 5000L;
            this.mDidAppSwitch = false;
            this.mHandler.removeMessages(21);
            Message msg = this.mHandler.obtainMessage(21);
            this.mHandler.sendMessageDelayed(msg, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("Requires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = 0L;
        }
    }

    boolean checkAppSwitchAllowedLocked(int callingPid, int callingUid, String name) {
        if (this.mAppSwitchesAllowedTime < SystemClock.uptimeMillis()) {
            return true;
        }
        int perm = this.checkComponentPermission("android.permission.STOP_APP_SWITCHES", callingPid, callingUid, -1, true);
        if (perm == 0) {
            return true;
        }
        Slog.w(TAG, name + " request from " + callingUid + " stopped");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDebugApp(String packageName, boolean waitForDebugger, boolean persistent) {
        this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDebugApp()");
        long ident = Binder.clearCallingIdentity();
        try {
            if (persistent) {
                ContentResolver resolver = this.mContext.getContentResolver();
                Settings.Global.putString(resolver, "debug_app", packageName);
                Settings.Global.putInt(resolver, "wait_for_debugger", waitForDebugger ? 1 : 0);
            }
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (!persistent) {
                    this.mOrigDebugApp = this.mDebugApp;
                    this.mOrigWaitForDebugger = this.mWaitForDebugger;
                }
                this.mDebugApp = packageName;
                this.mWaitForDebugger = waitForDebugger;
                boolean bl = this.mDebugTransient = !persistent;
                if (packageName != null) {
                    this.forceStopPackageLocked(packageName, -1, false, false, true, true, -1, "set debug app");
                }
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOpenGlTraceApp(ApplicationInfo app, String processName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (app.flags & 2) == 0) {
                throw new SecurityException("Process not debuggable: " + app.packageName);
            }
            this.mOpenGlTraceApp = processName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProfileApp(ApplicationInfo app, String processName, String profileFile, ParcelFileDescriptor profileFd, boolean autoStopProfiler) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (app.flags & 2) == 0) {
                throw new SecurityException("Process not debuggable: " + app.packageName);
            }
            this.mProfileApp = processName;
            this.mProfileFile = profileFile;
            if (this.mProfileFd != null) {
                try {
                    this.mProfileFd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.mProfileFd = null;
            }
            this.mProfileFd = profileFd;
            this.mProfileType = 0;
            this.mAutoStopProfiler = autoStopProfiler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlwaysFinish(boolean enabled) {
        this.enforceCallingPermission("android.permission.SET_ALWAYS_FINISH", "setAlwaysFinish()");
        Settings.Global.putInt(this.mContext.getContentResolver(), "always_finish_activities", enabled ? 1 : 0);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAlwaysFinishActivities = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivityController(IActivityController controller) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "setActivityController()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mController = controller;
            Watchdog.getInstance().setActivityController(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIsMonkey(boolean userIsMonkey) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                int callingPid = Binder.getCallingPid();
                ProcessRecord precessRecord = this.mPidsSelfLocked.get(callingPid);
                if (precessRecord == null) {
                    throw new SecurityException("Unknown process: " + callingPid);
                }
                if (precessRecord.instrumentationUiAutomationConnection == null) {
                    throw new SecurityException("Only an instrumentation process with a UiAutomation can call setUserIsMonkey");
                }
            }
            this.mUserIsMonkey = userIsMonkey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserAMonkey() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mUserIsMonkey || this.mController != null;
        }
    }

    @Override
    public void requestBugReport() {
        this.enforceCallingPermission("android.permission.DUMP", "requestBugReport");
        SystemProperties.set("ctl.start", "bugreport");
    }

    public static long getInputDispatchingTimeoutLocked(ActivityRecord r) {
        return r != null ? ActivityManagerService.getInputDispatchingTimeoutLocked(r.app) : 5000L;
    }

    public static long getInputDispatchingTimeoutLocked(ProcessRecord r) {
        if (r != null && (r.instrumentationClass != null || r.usingWrapper)) {
            return 60000L;
        }
        return 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long inputDispatchingTimedOut(int pid, boolean aboveSystem, String reason) {
        long timeout;
        ProcessRecord proc;
        if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
            throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(pid);
            }
            timeout = ActivityManagerService.getInputDispatchingTimeoutLocked(proc);
        }
        if (!this.inputDispatchingTimedOut(proc, null, null, aboveSystem, reason)) {
            return -1L;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inputDispatchingTimedOut(final ProcessRecord proc, final ActivityRecord activity, final ActivityRecord parent, final boolean aboveSystem, String reason) {
        if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
            throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
        }
        final String annotation = reason == null ? "Input dispatching timed out" : "Input dispatching timed out (" + reason + ")";
        if (proc != null) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (proc.debugging) {
                    return false;
                }
                if (this.mDidDexOpt) {
                    this.mDidDexOpt = false;
                    return false;
                }
                if (proc.instrumentationClass != null) {
                    Bundle info = new Bundle();
                    info.putString("shortMsg", "keyDispatchingTimedOut");
                    info.putString("longMsg", annotation);
                    this.finishInstrumentationLocked(proc, 0, info);
                    return true;
                }
            }
            this.mHandler.post(new Runnable(){

                public void run() {
                    ActivityManagerService.this.appNotResponding(proc, activity, parent, aboveSystem, annotation);
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getAssistContextExtras(int requestType) {
        PendingAssistExtras pae;
        this.enforceCallingPermission("android.permission.GET_TOP_ACTIVITY_INFO", "getAssistContextExtras()");
        Bundle extras = new Bundle();
        Binder binder = this;
        synchronized (binder) {
            ActivityRecord activity = this.getFocusedStack().mResumedActivity;
            if (activity == null) {
                Slog.w(TAG, "getAssistContextExtras failed: no resumed activity");
                return null;
            }
            extras.putString("android.intent.extra.ASSIST_PACKAGE", activity.packageName);
            if (activity.app == null || activity.app.thread == null) {
                Slog.w(TAG, "getAssistContextExtras failed: no process for " + activity);
                return extras;
            }
            if (activity.app.pid == Binder.getCallingPid()) {
                Slog.w(TAG, "getAssistContextExtras failed: request process same as " + activity);
                return extras;
            }
            pae = new PendingAssistExtras(activity);
            try {
                activity.app.thread.requestAssistContextExtras(activity.appToken, pae, requestType);
                this.mPendingAssistExtras.add(pae);
                this.mHandler.postDelayed(pae, 500L);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "getAssistContextExtras failed: crash calling " + activity);
                return extras;
            }
        }
        binder = pae;
        synchronized (binder) {
            while (!pae.haveResult) {
                try {
                    pae.wait();
                }
                catch (InterruptedException e) {}
            }
            if (pae.result != null) {
                extras.putBundle("android.intent.extra.ASSIST_CONTEXT", pae.result);
            }
        }
        binder = this;
        synchronized (binder) {
            this.mPendingAssistExtras.remove(pae);
            this.mHandler.removeCallbacks(pae);
        }
        return extras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportAssistContextExtras(IBinder token, Bundle extras) {
        PendingAssistExtras pae;
        PendingAssistExtras pendingAssistExtras = pae = (PendingAssistExtras)token;
        synchronized (pendingAssistExtras) {
            pae.result = extras;
            pae.haveResult = true;
            pae.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProcessObserver(IProcessObserver observer) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerProcessObserver()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessObservers.register(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProcessObserver(IProcessObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessObservers.unregister(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean convertFromTranslucent(IBinder token) {
        boolean bl;
        long origId;
        block10: {
            boolean bl2;
            block9: {
                boolean bl3;
                block8: {
                    origId = Binder.clearCallingIdentity();
                    try {
                        ActivityManagerService activityManagerService = this;
                        synchronized (activityManagerService) {
                            ActivityRecord r = ActivityRecord.isInStackLocked(token);
                            if (r == null) {
                                bl3 = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl8 : MonitorExitStatement: MONITOREXIT : var4_3
                                Object var9_8 = null;
                                break block8;
                            }
                            if (r.changeWindowTranslucency(true)) {
                                this.mWindowManager.setAppFullscreen(token, true);
                                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0);
                                bl2 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl16 : MonitorExitStatement: MONITOREXIT : var4_3
                                break block9;
                            }
                            bl = false;
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        Binder.restoreCallingIdentity(origId);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity(origId);
                return bl3;
            }
            Object var9_9 = null;
            Binder.restoreCallingIdentity(origId);
            return bl2;
        }
        Object var9_10 = null;
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean convertToTranslucent(IBinder token) {
        boolean bl;
        long origId;
        block10: {
            boolean bl2;
            block9: {
                boolean bl3;
                block8: {
                    origId = Binder.clearCallingIdentity();
                    try {
                        ActivityManagerService activityManagerService = this;
                        synchronized (activityManagerService) {
                            ActivityRecord r = ActivityRecord.isInStackLocked(token);
                            if (r == null) {
                                bl3 = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl8 : MonitorExitStatement: MONITOREXIT : var4_3
                                Object var9_8 = null;
                                break block8;
                            }
                            if (r.changeWindowTranslucency(false)) {
                                r.task.stack.convertToTranslucent(r);
                                this.mWindowManager.setAppFullscreen(token, false);
                                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0);
                                bl2 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var4_3
                                break block9;
                            }
                            bl = false;
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        Binder.restoreCallingIdentity(origId);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity(origId);
                return bl3;
            }
            Object var9_9 = null;
            Binder.restoreCallingIdentity(origId);
            return bl2;
        }
        Object var9_10 = null;
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImmersive(IBinder token, boolean immersive) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            r.immersive = immersive;
            if (r == this.mFocusedActivity) {
                this.applyUpdateLockStateLocked(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isImmersive(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            return r.immersive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTopActivityImmersive() {
        this.enforceNotIsolatedCaller("startActivity");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getFocusedStack().topRunningActivityLocked(null);
            return r != null ? r.immersive : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enterSafeMode() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.mSystemReady) {
                try {
                    AppGlobals.getPackageManager().enterSafeMode();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    public final void showSafeModeOverlay() {
        View v = LayoutInflater.from(this.mContext).inflate(17367179, null);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.type = 2015;
        lp.width = -2;
        lp.height = -2;
        lp.gravity = 8388691;
        lp.format = v.getBackground().getOpacity();
        lp.flags = 24;
        lp.privateFlags |= 0x10;
        ((WindowManager)this.mContext.getSystemService("window")).addView(v, lp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWakeupAlarm(IIntentSender sender) {
        BatteryStatsImpl stats;
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            if (this.mBatteryStatsService.isOnBattery()) {
                this.mBatteryStatsService.enforceCallingPermission();
                PendingIntentRecord rec = (PendingIntentRecord)sender;
                int MY_UID = Binder.getCallingUid();
                int uid = rec.uid == MY_UID ? 1000 : rec.uid;
                BatteryStatsImpl.Uid.Pkg pkg = stats.getPackageStatsLocked(uid, rec.key.packageName);
                pkg.incWakeupsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean killPids(int[] pids, String pReason, boolean secure) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killPids only available to the system");
        }
        String reason = pReason == null ? "Unknown" : pReason;
        boolean killed = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord proc;
            int i;
            int[] types = new int[pids.length];
            int worstType = 0;
            for (i = 0; i < pids.length; ++i) {
                int type;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null) continue;
                types[i] = type = proc.setAdj;
                if (type <= worstType) continue;
                worstType = type;
            }
            if (worstType < 15 && worstType > 9) {
                worstType = 9;
            }
            if (!secure && worstType < 5) {
                worstType = 5;
            }
            Slog.w(TAG, "Killing processes " + reason + " at adjustment " + worstType);
            for (i = 0; i < pids.length; ++i) {
                int adj;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null || (adj = proc.setAdj) < worstType || proc.killedByAm) continue;
                this.killUnneededProcessLocked(proc, reason);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killUid(int uid, String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killUid only available to the system");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.killPackageProcessesLocked(null, UserHandle.getAppId(uid), UserHandle.getUserId(uid), -1, false, true, true, false, reason != null ? reason : "kill uid");
        }
    }

    @Override
    public boolean killProcessesBelowForeground(String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowForeground() only available to system");
        }
        return this.killProcessesBelowAdj(0, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killProcessesBelowAdj(int belowAdj, String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowAdj() only available to system");
        }
        boolean killed = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            int size = this.mPidsSelfLocked.size();
            for (int i = 0; i < size; ++i) {
                int adj;
                int pid = this.mPidsSelfLocked.keyAt(i);
                ProcessRecord proc = this.mPidsSelfLocked.valueAt(i);
                if (proc == null || (adj = proc.setAdj) <= belowAdj || proc.killedByAm) continue;
                this.killUnneededProcessLocked(proc, reason);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hang(IBinder who, boolean allowRestart) {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        IBinder.DeathRecipient death = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void binderDied() {
                11 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
            }
        };
        try {
            who.linkToDeath(death, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "hang: given caller IBinder is already dead.");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Watchdog.getInstance().setAllowRestart(allowRestart);
            Slog.i(TAG, "Hanging system process at request of pid " + Binder.getCallingPid());
            IBinder.DeathRecipient deathRecipient = death;
            synchronized (deathRecipient) {
                while (who.isBinderAlive()) {
                    try {
                        death.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            Watchdog.getInstance().setAllowRestart(true);
        }
    }

    @Override
    public void restart() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        Log.i(TAG, "Sending shutdown broadcast...");
        BroadcastReceiver br = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Log.i(ActivityManagerService.TAG, "Shutting down activity manager...");
                ActivityManagerService.this.shutdown(10000);
                Log.i(ActivityManagerService.TAG, "Shutdown complete, restarting!");
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        };
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
        br.onReceive(this.mContext, intent);
    }

    private long getLowRamTimeSinceIdle(long now) {
        return this.mLowRamTimeSinceLastIdle + (this.mLowRamStartTime > 0L ? now - this.mLowRamStartTime : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performIdleMaintenance() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long now = SystemClock.uptimeMillis();
            long timeSinceLastIdle = now - this.mLastIdleTime;
            long lowRamSinceLastIdle = this.getLowRamTimeSinceIdle(now);
            this.mLastIdleTime = now;
            this.mLowRamTimeSinceLastIdle = 0L;
            if (this.mLowRamStartTime != 0L) {
                this.mLowRamStartTime = now;
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append("Idle maintenance over ");
            TimeUtils.formatDuration(timeSinceLastIdle, sb);
            sb.append(" low RAM for ");
            TimeUtils.formatDuration(lowRamSinceLastIdle, sb);
            Slog.i(TAG, sb.toString());
            boolean doKilling = lowRamSinceLastIdle > timeSinceLastIdle / 3L;
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord proc = this.mLruProcesses.get(i);
                if (proc.notCachedSinceIdle) {
                    if (proc.setProcState <= 2 || proc.setProcState > 7 || !doKilling || proc.initialIdlePss == 0L || proc.lastPss <= proc.initialIdlePss * 3L / 2L) continue;
                    this.killUnneededProcessLocked(proc, "idle maint (pss " + proc.lastPss + " from " + proc.initialIdlePss + ")");
                    continue;
                }
                if (proc.setProcState >= 9) continue;
                proc.notCachedSinceIdle = true;
                proc.initialIdlePss = 0L;
                proc.nextPssTime = ProcessList.computeNextPssTime(proc.curProcState, true, this.mSleeping, now);
            }
            this.mHandler.removeMessages(39);
            this.mHandler.sendEmptyMessageDelayed(39, 120000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startRunning(String pkg, String cls, String action, String data) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mStartRunning) {
                return;
            }
            this.mStartRunning = true;
            this.mTopComponent = pkg != null && cls != null ? new ComponentName(pkg, cls) : null;
            this.mTopAction = action != null ? action : "android.intent.action.MAIN";
            this.mTopData = data;
            if (!this.mSystemReady) {
                return;
            }
        }
        this.systemReady(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        String debugApp = Settings.Global.getString(resolver, "debug_app");
        boolean waitForDebugger = Settings.Global.getInt(resolver, "wait_for_debugger", 0) != 0;
        boolean alwaysFinishActivities = Settings.Global.getInt(resolver, "always_finish_activities", 0) != 0;
        boolean forceRtl = Settings.Global.getInt(resolver, "debug.force_rtl", 0) != 0;
        SystemProperties.set("debug.force_rtl", forceRtl ? "1" : "0");
        Configuration configuration = new Configuration();
        Settings.System.getConfiguration(resolver, configuration);
        if (forceRtl) {
            configuration.setLayoutDirection(configuration.locale);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mDebugApp = this.mOrigDebugApp = debugApp;
            this.mWaitForDebugger = this.mOrigWaitForDebugger = waitForDebugger;
            this.mAlwaysFinishActivities = alwaysFinishActivities;
            this.updateConfigurationLocked(configuration, null, false, true);
        }
    }

    @Override
    public boolean testIsSystemReady() {
        return this.mSystemReady;
    }

    private static File getCalledPreBootReceiversFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "called_pre_boots.dat");
        return fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<ComponentName> readLastDonePreBootReceivers() {
        ArrayList<ComponentName> lastDoneReceivers = new ArrayList<ComponentName>();
        File file = ActivityManagerService.getCalledPreBootReceiversFile();
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(fis, 2048));
        int fvers = dis.readInt();
        if (fvers == 10000) {
            String vers = dis.readUTF();
            String codename = dis.readUTF();
            String build = dis.readUTF();
            if (Build.VERSION.RELEASE.equals(vers) && Build.VERSION.CODENAME.equals(codename) && Build.VERSION.INCREMENTAL.equals(build)) {
                for (int num = dis.readInt(); num > 0; --num) {
                    String pkg = dis.readUTF();
                    String cls = dis.readUTF();
                    lastDoneReceivers.add(new ComponentName(pkg, cls));
                }
            }
        }
        Object var12_13 = null;
        if (fis == null) return lastDoneReceivers;
        try {
            fis.close();
            return lastDoneReceivers;
        }
        catch (IOException e2) {}
        return lastDoneReceivers;
        {
            catch (FileNotFoundException e) {
                Object var12_14 = null;
                if (fis == null) return lastDoneReceivers;
                try {
                    fis.close();
                    return lastDoneReceivers;
                }
                catch (IOException e2) {}
                return lastDoneReceivers;
            }
            catch (IOException e) {
                Slog.w(TAG, "Failure reading last done pre-boot receivers", e);
                Object var12_15 = null;
                if (fis == null) return lastDoneReceivers;
                try {
                    fis.close();
                    return lastDoneReceivers;
                }
                catch (IOException e2) {}
                return lastDoneReceivers;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeLastDonePreBootReceivers(ArrayList<ComponentName> list) {
        block12: {
            File file = ActivityManagerService.getCalledPreBootReceiversFile();
            FileOutputStream fos = null;
            FilterOutputStream dos = null;
            try {
                Slog.i(TAG, "Writing new set of last done pre-boot receivers...");
                fos = new FileOutputStream(file);
                dos = new DataOutputStream(new BufferedOutputStream(fos, 2048));
                ((DataOutputStream)dos).writeInt(10000);
                ((DataOutputStream)dos).writeUTF(Build.VERSION.RELEASE);
                ((DataOutputStream)dos).writeUTF(Build.VERSION.CODENAME);
                ((DataOutputStream)dos).writeUTF(Build.VERSION.INCREMENTAL);
                ((DataOutputStream)dos).writeInt(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    ((DataOutputStream)dos).writeUTF(list.get(i).getPackageName());
                    ((DataOutputStream)dos).writeUTF(list.get(i).getClassName());
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                FileUtils.sync(fos);
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                throw throwable;
            }
            FileUtils.sync(fos);
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            break block12;
            {
                catch (IOException e) {
                    Slog.w(TAG, "Failure writing last done pre-boot receivers", e);
                    file.delete();
                    Object var6_7 = null;
                    FileUtils.sync(fos);
                    if (dos != null) {
                        try {
                            dos.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(final Runnable goingCallback) {
        ProcessRecord proc;
        int i;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mSystemReady) {
                if (goingCallback != null) {
                    goingCallback.run();
                }
                return;
            }
            if (!this.mDidUpdate) {
                if (this.mWaitingUpdate) {
                    return;
                }
                Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
                List<ResolveInfo> ris = null;
                try {
                    ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, 0);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                if (ris != null) {
                    for (int i2 = ris.size() - 1; i2 >= 0; --i2) {
                        if ((ris.get((int)i2).activityInfo.applicationInfo.flags & 1) != 0) continue;
                        ris.remove(i2);
                    }
                    intent.addFlags(0x2000000);
                    ArrayList<ComponentName> lastDoneReceivers = ActivityManagerService.readLastDonePreBootReceivers();
                    final ArrayList<ComponentName> doneReceivers = new ArrayList<ComponentName>();
                    for (int i3 = 0; i3 < ris.size(); ++i3) {
                        ActivityInfo ai = ris.get((int)i3).activityInfo;
                        ComponentName comp = new ComponentName(ai.packageName, ai.name);
                        if (!lastDoneReceivers.contains(comp)) continue;
                        ris.remove(i3);
                        --i3;
                    }
                    int[] users = this.getUsersLocked();
                    for (int i4 = 0; i4 < ris.size(); ++i4) {
                        ActivityInfo ai = ris.get((int)i4).activityInfo;
                        ComponentName comp = new ComponentName(ai.packageName, ai.name);
                        doneReceivers.add(comp);
                        intent.setComponent(comp);
                        for (int j = 0; j < users.length; ++j) {
                            IIntentReceiver.Stub finisher = null;
                            if (i4 == ris.size() - 1 && j == users.length - 1) {
                                finisher = new IIntentReceiver.Stub(){

                                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                                        ActivityManagerService.this.mHandler.post(new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public void run() {
                                                ActivityManagerService activityManagerService = ActivityManagerService.this;
                                                synchronized (activityManagerService) {
                                                    ActivityManagerService.this.mDidUpdate = true;
                                                }
                                                ActivityManagerService.writeLastDonePreBootReceivers(doneReceivers);
                                                ActivityManagerService.this.showBootMessage(ActivityManagerService.this.mContext.getText(17040403), false);
                                                ActivityManagerService.this.systemReady(goingCallback);
                                            }
                                        });
                                    }
                                };
                            }
                            Slog.i(TAG, "Sending system update to " + intent.getComponent() + " for user " + users[j]);
                            this.broadcastIntentLocked(null, null, intent, null, finisher, 0, null, null, null, -1, true, false, MY_PID, 1000, users[j]);
                            if (finisher == null) continue;
                            this.mWaitingUpdate = true;
                        }
                    }
                }
                if (this.mWaitingUpdate) {
                    return;
                }
                this.mDidUpdate = true;
            }
            this.mAppOpsService.systemReady();
            this.mSystemReady = true;
            if (!this.mStartRunning) {
                return;
            }
        }
        ArrayList<ProcessRecord> procsToKill = null;
        Object object = this.mPidsSelfLocked;
        synchronized (object) {
            for (i = this.mPidsSelfLocked.size() - 1; i >= 0; --i) {
                proc = this.mPidsSelfLocked.valueAt(i);
                if (this.isAllowedWhileBooting(proc.info)) continue;
                if (procsToKill == null) {
                    procsToKill = new ArrayList<ProcessRecord>();
                }
                procsToKill.add(proc);
            }
        }
        object = this;
        synchronized (object) {
            if (procsToKill != null) {
                for (i = procsToKill.size() - 1; i >= 0; --i) {
                    proc = (ProcessRecord)procsToKill.get(i);
                    Slog.i(TAG, "Removing system update proc: " + proc);
                    this.removeProcessLocked(proc, true, false, "system update done");
                }
            }
            this.mProcessesReady = true;
        }
        Slog.i(TAG, "System now ready");
        EventLog.writeEvent(3040, SystemClock.uptimeMillis());
        object = this;
        synchronized (object) {
            if (this.mFactoryTest == 1) {
                ResolveInfo ri = this.mContext.getPackageManager().resolveActivity(new Intent("android.intent.action.FACTORY_TEST"), 1024);
                CharSequence errorMsg = null;
                if (ri != null) {
                    ActivityInfo ai = ri.activityInfo;
                    ApplicationInfo app = ai.applicationInfo;
                    if ((app.flags & 1) != 0) {
                        this.mTopAction = "android.intent.action.FACTORY_TEST";
                        this.mTopData = null;
                        this.mTopComponent = new ComponentName(app.packageName, ai.name);
                    } else {
                        errorMsg = this.mContext.getResources().getText(17040223);
                    }
                } else {
                    errorMsg = this.mContext.getResources().getText(17040224);
                }
                if (errorMsg != null) {
                    this.mTopAction = null;
                    this.mTopData = null;
                    this.mTopComponent = null;
                    Message msg = Message.obtain();
                    msg.what = 3;
                    msg.getData().putCharSequence("msg", errorMsg);
                    this.mHandler.sendMessage(msg);
                }
            }
        }
        this.retrieveSettings();
        object = this;
        synchronized (object) {
            this.readGrantedUriPermissionsLocked();
        }
        if (goingCallback != null) {
            goingCallback.run();
        }
        object = this;
        synchronized (object) {
            if (this.mFactoryTest != 1) {
                try {
                    List<ApplicationInfo> apps = AppGlobals.getPackageManager().getPersistentApplications(1024);
                    if (apps != null) {
                        int N = apps.size();
                        for (int i5 = 0; i5 < N; ++i5) {
                            ApplicationInfo info = apps.get(i5);
                            if (info == null || info.packageName.equals("android")) continue;
                            this.addAppLocked(info, false);
                        }
                    }
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
            this.mBooting = true;
            try {
                if (AppGlobals.getPackageManager().hasSystemUidErrors()) {
                    Message msg = Message.obtain();
                    msg.what = 14;
                    this.mHandler.sendMessage(msg);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Intent intent = new Intent("android.intent.action.USER_STARTED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", this.mCurrentUserId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, this.mCurrentUserId);
                intent = new Intent("android.intent.action.USER_STARTING");
                intent.addFlags(0x40000000);
                intent.putExtra("android.intent.extra.user_handle", this.mCurrentUserId);
                this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    }
                }, 0, null, null, "android.permission.INTERACT_ACROSS_USERS", -1, true, false, MY_PID, 1000, -1);
                Object var19_32 = null;
            }
            catch (Throwable throwable) {
                Object var19_33 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            this.mStackSupervisor.resumeTopActivitiesLocked();
            this.sendUserSwitchBroadcastsLocked(-1, this.mCurrentUserId);
        }
    }

    private boolean makeAppCrashingLocked(ProcessRecord app, String shortMsg, String longMsg, String stackTrace) {
        app.crashing = true;
        app.crashingReport = this.generateProcessError(app, 1, null, shortMsg, longMsg, stackTrace);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
        return this.handleAppCrashLocked(app, shortMsg, longMsg, stackTrace);
    }

    private void makeAppNotRespondingLocked(ProcessRecord app, String activity, String shortMsg, String longMsg) {
        app.notResponding = true;
        app.notRespondingReport = this.generateProcessError(app, 2, activity, shortMsg, longMsg, null);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
    }

    private ActivityManager.ProcessErrorStateInfo generateProcessError(ProcessRecord app, int condition, String activity, String shortMsg, String longMsg, String stackTrace) {
        ActivityManager.ProcessErrorStateInfo report = new ActivityManager.ProcessErrorStateInfo();
        report.condition = condition;
        report.processName = app.processName;
        report.pid = app.pid;
        report.uid = app.info.uid;
        report.tag = activity;
        report.shortMsg = shortMsg;
        report.longMsg = longMsg;
        report.stackTrace = stackTrace;
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killAppAtUsersRequest(ProcessRecord app, Dialog fromDialog) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            app.crashing = false;
            app.crashingReport = null;
            app.notResponding = false;
            app.notRespondingReport = null;
            if (app.anrDialog == fromDialog) {
                app.anrDialog = null;
            }
            if (app.waitDialog == fromDialog) {
                app.waitDialog = null;
            }
            if (app.pid > 0 && app.pid != MY_PID) {
                this.handleAppCrashLocked(app, null, null, null);
                this.killUnneededProcessLocked(app, "user request after error");
            }
        }
    }

    private boolean handleAppCrashLocked(ProcessRecord app, String shortMsg, String longMsg, String stackTrace) {
        if (this.mHeadless) {
            Log.e(TAG, "handleAppCrashLocked: " + app.processName);
            return false;
        }
        long now = SystemClock.uptimeMillis();
        Long crashTime = !app.isolated ? this.mProcessCrashTimes.get(app.info.processName, app.uid) : null;
        if (crashTime != null && now < crashTime + 60000L) {
            Slog.w(TAG, "Process " + app.info.processName + " has crashed too many times: killing!");
            EventLog.writeEvent(30032, app.userId, app.info.processName, app.uid);
            this.mStackSupervisor.handleAppCrashLocked(app);
            if (!app.persistent) {
                EventLog.writeEvent(30015, app.userId, app.uid, app.info.processName);
                if (!app.isolated) {
                    this.mBadProcesses.put(app.info.processName, app.uid, new BadProcessInfo(now, shortMsg, longMsg, stackTrace));
                    this.mProcessCrashTimes.remove(app.info.processName, app.uid);
                }
                app.bad = true;
                app.removed = true;
                this.removeProcessLocked(app, false, false, "crash");
                this.mStackSupervisor.resumeTopActivitiesLocked();
                return false;
            }
            this.mStackSupervisor.resumeTopActivitiesLocked();
        } else {
            this.mStackSupervisor.finishTopRunningActivityLocked(app);
        }
        for (int i = app.services.size() - 1; i >= 0; --i) {
            ServiceRecord sr = app.services.valueAt(i);
            ++sr.crashCount;
        }
        ArrayList<ActivityRecord> activities = app.activities;
        if (app == this.mHomeProcess && activities.size() > 0 && (this.mHomeProcess.info.flags & 1) == 0) {
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isHomeActivity()) continue;
                Log.i(TAG, "Clearing package preferred activities from " + r.packageName);
                try {
                    ActivityThread.getPackageManager().clearPackagePreferredActivities(r.packageName);
                    continue;
                }
                catch (RemoteException c) {
                    // empty catch block
                }
            }
        }
        if (!app.isolated) {
            this.mProcessCrashTimes.put(app.info.processName, app.uid, now);
        }
        return true;
    }

    void startAppProblemLocked(ProcessRecord app) {
        app.errorReportReceiver = app.userId == this.mCurrentUserId ? ApplicationErrorReport.getErrorReportReceiver(this.mContext, app.info.packageName, app.info.flags) : null;
        this.skipCurrentReceiverLocked(app);
    }

    void skipCurrentReceiverLocked(ProcessRecord app) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipCurrentReceiverLocked(app);
        }
    }

    @Override
    public void handleApplicationCrash(IBinder app, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "Crash");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        this.handleApplicationCrashInner("crash", r, processName, crashInfo);
    }

    void handleApplicationCrashInner(String eventType, ProcessRecord r, String processName, ApplicationErrorReport.CrashInfo crashInfo) {
        EventLog.writeEvent(30039, Binder.getCallingPid(), UserHandle.getUserId(Binder.getCallingUid()), processName, r == null ? -1 : r.info.flags, crashInfo.exceptionClassName, crashInfo.exceptionMessage, crashInfo.throwFileName, crashInfo.throwLineNumber);
        this.addErrorToDropBox(eventType, r, processName, null, null, null, null, null, crashInfo);
        this.crashApplication(r, crashInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleApplicationStrictModeViolation(IBinder app, int violationMask, StrictMode.ViolationInfo info) {
        ProcessRecord r = this.findAppProcess(app, "StrictMode");
        if (r == null) {
            return;
        }
        if ((violationMask & 0x80) != 0) {
            Integer stackFingerprint = info.hashCode();
            boolean logIt = true;
            HashSet<Integer> hashSet = this.mAlreadyLoggedViolatedStacks;
            synchronized (hashSet) {
                if (this.mAlreadyLoggedViolatedStacks.contains(stackFingerprint)) {
                    logIt = false;
                } else {
                    if (this.mAlreadyLoggedViolatedStacks.size() >= 5000) {
                        this.mAlreadyLoggedViolatedStacks.clear();
                    }
                    this.mAlreadyLoggedViolatedStacks.add(stackFingerprint);
                }
            }
            if (logIt) {
                this.logStrictModeViolationToDropBox(r, info);
            }
        }
        if ((violationMask & 0x20) != 0) {
            AppErrorResult result = new AppErrorResult();
            ActivityManagerService logIt = this;
            synchronized (logIt) {
                long origId = Binder.clearCallingIdentity();
                Message msg = Message.obtain();
                msg.what = 26;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("result", result);
                data.put("app", r);
                data.put("violationMask", violationMask);
                data.put("info", info);
                msg.obj = data;
                this.mHandler.sendMessage(msg);
                Binder.restoreCallingIdentity(origId);
            }
            int res = result.get();
            Slog.w(TAG, "handleApplicationStrictModeViolation; res=" + res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStrictModeViolationToDropBox(ProcessRecord process, StrictMode.ViolationInfo info) {
        boolean needsFlush;
        boolean bufferWasEmpty;
        StringBuilder sb;
        if (info == null) {
            return;
        }
        boolean isSystemApp = process == null || (process.info.flags & 0x81) != 0;
        String processName = process == null ? "unknown" : process.processName;
        final String dropboxTag = isSystemApp ? "system_app_strictmode" : "data_app_strictmode";
        final DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        StringBuilder stringBuilder = sb = isSystemApp ? this.mStrictModeBuffer : new StringBuilder(1024);
        synchronized (stringBuilder) {
            bufferWasEmpty = sb.length() == 0;
            this.appendDropBoxProcessHeaders(process, processName, sb);
            sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
            sb.append("System-App: ").append(isSystemApp).append("\n");
            sb.append("Uptime-Millis: ").append(info.violationUptimeMillis).append("\n");
            if (info.violationNumThisLoop != 0) {
                sb.append("Loop-Violation-Number: ").append(info.violationNumThisLoop).append("\n");
            }
            if (info.numAnimationsRunning != 0) {
                sb.append("Animations-Running: ").append(info.numAnimationsRunning).append("\n");
            }
            if (info.broadcastIntentAction != null) {
                sb.append("Broadcast-Intent-Action: ").append(info.broadcastIntentAction).append("\n");
            }
            if (info.durationMillis != -1) {
                sb.append("Duration-Millis: ").append(info.durationMillis).append("\n");
            }
            if (info.numInstances != -1L) {
                sb.append("Instance-Count: ").append(info.numInstances).append("\n");
            }
            if (info.tags != null) {
                for (String tag : info.tags) {
                    sb.append("Span-Tag: ").append(tag).append("\n");
                }
            }
            sb.append("\n");
            if (info.crashInfo != null && info.crashInfo.stackTrace != null) {
                sb.append(info.crashInfo.stackTrace);
            }
            sb.append("\n");
            needsFlush = sb.length() > 65536;
        }
        if (!isSystemApp || needsFlush) {
            new Thread("Error dump: " + dropboxTag){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String report;
                    StringBuilder stringBuilder = sb;
                    synchronized (stringBuilder) {
                        report = sb.toString();
                        sb.delete(0, sb.length());
                        sb.trimToSize();
                    }
                    if (report.length() != 0) {
                        dbox.addText(dropboxTag, report);
                    }
                }
            }.start();
            return;
        }
        if (!bufferWasEmpty) {
            return;
        }
        new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String errorReport;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                StringBuilder stringBuilder = ActivityManagerService.this.mStrictModeBuffer;
                synchronized (stringBuilder) {
                    errorReport = ActivityManagerService.this.mStrictModeBuffer.toString();
                    if (errorReport.length() == 0) {
                        return;
                    }
                    ActivityManagerService.this.mStrictModeBuffer.delete(0, ActivityManagerService.this.mStrictModeBuffer.length());
                    ActivityManagerService.this.mStrictModeBuffer.trimToSize();
                }
                dbox.addText(dropboxTag, errorReport);
            }
        }.start();
    }

    @Override
    public boolean handleApplicationWtf(IBinder app, String tag, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "WTF");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        EventLog.writeEvent(30040, UserHandle.getUserId(Binder.getCallingUid()), Binder.getCallingPid(), processName, r == null ? -1 : r.info.flags, tag, crashInfo.exceptionMessage);
        this.addErrorToDropBox("wtf", r, processName, null, null, tag, null, null, crashInfo);
        if (r != null && r.pid != Process.myPid() && Settings.Global.getInt(this.mContext.getContentResolver(), "wtf_is_fatal", 0) != 0) {
            this.crashApplication(r, crashInfo);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findAppProcess(IBinder app, String reason) {
        if (app == null) {
            return null;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int NP = this.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                int NA = apps.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord p = apps.valueAt(ia);
                    if (p.thread == null || p.thread.asBinder() != app) continue;
                    return p;
                }
            }
            Slog.w(TAG, "Can't find mystery application for " + reason + " from pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid() + ": " + app);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendDropBoxProcessHeaders(ProcessRecord process, String processName, StringBuilder sb) {
        if (process == null) {
            sb.append("Process: ").append(processName).append("\n");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            sb.append("Process: ").append(processName).append("\n");
            int flags = process.info.flags;
            IPackageManager pm = AppGlobals.getPackageManager();
            sb.append("Flags: 0x").append(Integer.toString(flags, 16)).append("\n");
            for (int ip = 0; ip < process.pkgList.size(); ++ip) {
                String pkg = process.pkgList.keyAt(ip);
                sb.append("Package: ").append(pkg);
                try {
                    PackageInfo pi = pm.getPackageInfo(pkg, 0, UserHandle.getCallingUserId());
                    if (pi != null) {
                        sb.append(" v").append(pi.versionCode);
                        if (pi.versionName != null) {
                            sb.append(" (").append(pi.versionName).append(")");
                        }
                    }
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Error getting package info: " + pkg, e);
                }
                sb.append("\n");
            }
        }
    }

    private static String processClass(ProcessRecord process) {
        if (process == null || process.pid == MY_PID) {
            return "system_server";
        }
        if ((process.info.flags & 1) != 0) {
            return "system_app";
        }
        return "data_app";
    }

    public void addErrorToDropBox(String eventType, ProcessRecord process, String processName, ActivityRecord activity, ActivityRecord parent, String subject, final String report, final File logFile, final ApplicationErrorReport.CrashInfo crashInfo) {
        final String dropboxTag = ActivityManagerService.processClass(process) + "_" + eventType;
        final DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        final StringBuilder sb = new StringBuilder(1024);
        this.appendDropBoxProcessHeaders(process, processName, sb);
        if (activity != null) {
            sb.append("Activity: ").append(activity.shortComponentName).append("\n");
        }
        if (parent != null && parent.app != null && parent.app.pid != process.pid) {
            sb.append("Parent-Process: ").append(parent.app.processName).append("\n");
        }
        if (parent != null && parent != activity) {
            sb.append("Parent-Activity: ").append(parent.shortComponentName).append("\n");
        }
        if (subject != null) {
            sb.append("Subject: ").append(subject).append("\n");
        }
        sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
        if (Debug.isDebuggerConnected()) {
            sb.append("Debugger: Connected\n");
        }
        sb.append("\n");
        Thread worker = new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block20: {
                    if (report != null) {
                        sb.append(report);
                    }
                    if (logFile != null) {
                        try {
                            sb.append(FileUtils.readTextFile(logFile, 262144, "\n\n[[TRUNCATED]]"));
                        }
                        catch (IOException e) {
                            Slog.e("ActivityManager", "Error reading " + logFile, e);
                        }
                    }
                    if (crashInfo != null && crashInfo.stackTrace != null) {
                        sb.append(crashInfo.stackTrace);
                    }
                    setting = "logcat_for_" + dropboxTag;
                    lines = Settings.Global.getInt(ActivityManagerService.this.mContext.getContentResolver(), setting, 0);
                    if (lines > 0) {
                        sb.append("\n");
                        input = null;
                        try {
                            try {
                                logcat = new ProcessBuilder(new String[]{"/system/bin/logcat", "-v", "time", "-b", "events", "-b", "system", "-b", "main", "-t", String.valueOf(lines)}).redirectErrorStream(true).start();
                                try {
                                    logcat.getOutputStream().close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                try {
                                    logcat.getErrorStream().close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                input = new InputStreamReader(logcat.getInputStream());
                                buf = new char[8192];
                                while ((num = input.read(buf)) > 0) {
                                    sb.append(buf, 0, num);
                                }
                                var8_12 = null;
                                if (input == null) break block20;
                            }
                            catch (IOException e) {
                                Slog.e("ActivityManager", "Error running logcat", e);
                                var8_13 = null;
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e) {}
                                }
                                break block20;
                            }
                        }
                        catch (Throwable var7_18) {
                            var8_14 = null;
                            if (input == null) throw var7_18;
                            ** try [egrp 5[TRYBLOCK] [7 : 360->367)] { 
lbl59:
                            // 1 sources

                            input.close();
                            throw var7_18;
lbl61:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var7_18;
                        }
                        try {}
                        catch (IOException e) {}
                        input.close();
                    }
                }
                dbox.addText(dropboxTag, sb.toString());
            }
        };
        if (process == null) {
            worker.run();
        } else {
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crashApplication(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo) {
        long timeMillis = System.currentTimeMillis();
        String shortMsg = crashInfo.exceptionClassName;
        String longMsg = crashInfo.exceptionMessage;
        String stackTrace = crashInfo.stackTrace;
        if (shortMsg != null && longMsg != null) {
            longMsg = shortMsg + ": " + longMsg;
        } else if (shortMsg != null) {
            longMsg = shortMsg;
        }
        AppErrorResult result = new AppErrorResult();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mController != null) {
                try {
                    int pid;
                    String name = r != null ? r.processName : null;
                    int n = pid = r != null ? r.pid : Binder.getCallingPid();
                    if (!this.mController.appCrashed(name, pid, shortMsg, longMsg, timeMillis, crashInfo.stackTrace)) {
                        Slog.w(TAG, "Force-killing crashed app " + name + " at watcher's request");
                        Process.killProcess(pid);
                        return;
                    }
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
            long origId = Binder.clearCallingIdentity();
            if (r != null && r.instrumentationClass != null) {
                Slog.w(TAG, "Error in app " + r.processName + " running instrumentation " + r.instrumentationClass + ":");
                if (shortMsg != null) {
                    Slog.w(TAG, "  " + shortMsg);
                }
                if (longMsg != null) {
                    Slog.w(TAG, "  " + longMsg);
                }
                Bundle info = new Bundle();
                info.putString("shortMsg", shortMsg);
                info.putString("longMsg", longMsg);
                this.finishInstrumentationLocked(r, 0, info);
                Binder.restoreCallingIdentity(origId);
                return;
            }
            if (r == null || !this.makeAppCrashingLocked(r, shortMsg, longMsg, stackTrace)) {
                Binder.restoreCallingIdentity(origId);
                return;
            }
            Message msg = Message.obtain();
            msg.what = 1;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("result", result);
            data.put("app", r);
            msg.obj = data;
            this.mHandler.sendMessage(msg);
            Binder.restoreCallingIdentity(origId);
        }
        int res = result.get();
        Intent appErrorIntent = null;
        ActivityManagerService pid = this;
        synchronized (pid) {
            if (r != null && !r.isolated) {
                this.mProcessCrashTimes.put(r.info.processName, r.uid, SystemClock.uptimeMillis());
            }
            if (res == 1) {
                appErrorIntent = this.createAppErrorIntentLocked(r, timeMillis, crashInfo);
            }
        }
        if (appErrorIntent != null) {
            try {
                this.mContext.startActivityAsUser(appErrorIntent, new UserHandle(r.userId));
            }
            catch (ActivityNotFoundException e) {
                Slog.w(TAG, "bug report receiver dissappeared", e);
            }
        }
    }

    Intent createAppErrorIntentLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        ApplicationErrorReport report = this.createAppErrorReportLocked(r, timeMillis, crashInfo);
        if (report == null) {
            return null;
        }
        Intent result = new Intent("android.intent.action.APP_ERROR");
        result.setComponent(r.errorReportReceiver);
        result.putExtra("android.intent.extra.BUG_REPORT", report);
        result.addFlags(0x10000000);
        return result;
    }

    private ApplicationErrorReport createAppErrorReportLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        if (r.errorReportReceiver == null) {
            return null;
        }
        if (!(r.crashing || r.notResponding || r.forceCrashReport)) {
            return null;
        }
        ApplicationErrorReport report = new ApplicationErrorReport();
        report.packageName = r.info.packageName;
        report.installerPackageName = r.errorReportReceiver.getPackageName();
        report.processName = r.processName;
        report.time = timeMillis;
        boolean bl = report.systemApp = (r.info.flags & 1) != 0;
        if (r.crashing || r.forceCrashReport) {
            report.type = 1;
            report.crashInfo = crashInfo;
        } else if (r.notResponding) {
            report.type = 2;
            report.anrInfo = new ApplicationErrorReport.AnrInfo();
            report.anrInfo.activity = r.notRespondingReport.tag;
            report.anrInfo.cause = r.notRespondingReport.shortMsg;
            report.anrInfo.info = r.notRespondingReport.longMsg;
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.ProcessErrorStateInfo> getProcessesInErrorState() {
        this.enforceNotIsolatedCaller("getProcessesInErrorState");
        ArrayList<ActivityManager.ProcessErrorStateInfo> errList = null;
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", Binder.getCallingUid()) == 0;
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (!allUsers && app.userId != userId || app.thread == null || !app.crashing && !app.notResponding) continue;
                ActivityManager.ProcessErrorStateInfo report = null;
                if (app.crashing) {
                    report = app.crashingReport;
                } else if (app.notResponding) {
                    report = app.notRespondingReport;
                }
                if (report != null) {
                    if (errList == null) {
                        errList = new ArrayList<ActivityManager.ProcessErrorStateInfo>(1);
                    }
                    errList.add(report);
                    continue;
                }
                Slog.w(TAG, "Missing app error report, app = " + app.processName + " crashing = " + app.crashing + " notResponding = " + app.notResponding);
            }
        }
        return errList;
    }

    static int oomAdjToImportance(int adj, ActivityManager.RunningAppProcessInfo currApp) {
        if (adj >= 9) {
            if (currApp != null) {
                currApp.lru = adj - 9 + 1;
            }
            return 400;
        }
        if (adj >= 8) {
            return 300;
        }
        if (adj >= 6) {
            if (currApp != null) {
                currApp.lru = 0;
            }
            return 400;
        }
        if (adj >= 5) {
            return 300;
        }
        if (adj >= 4) {
            return 170;
        }
        if (adj >= 2) {
            return 130;
        }
        if (adj >= 1) {
            return 200;
        }
        return 100;
    }

    private void fillInProcMemInfo(ProcessRecord app, ActivityManager.RunningAppProcessInfo outInfo) {
        outInfo.pid = app.pid;
        outInfo.uid = app.info.uid;
        if (this.mHeavyWeightProcess == app) {
            outInfo.flags |= 1;
        }
        if (app.persistent) {
            outInfo.flags |= 2;
        }
        if (app.activities.size() > 0) {
            outInfo.flags |= 4;
        }
        outInfo.lastTrimLevel = app.trimMemoryLevel;
        int adj = app.curAdj;
        outInfo.importance = ActivityManagerService.oomAdjToImportance(adj, outInfo);
        outInfo.importanceReasonCode = app.adjTypeCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        this.enforceNotIsolatedCaller("getRunningAppProcesses");
        ArrayList<ActivityManager.RunningAppProcessInfo> runList = null;
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", Binder.getCallingUid()) == 0;
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (!allUsers && app.userId != userId || app.thread == null || app.crashing || app.notResponding) continue;
                ActivityManager.RunningAppProcessInfo currApp = new ActivityManager.RunningAppProcessInfo(app.processName, app.pid, app.getPackageList());
                this.fillInProcMemInfo(app, currApp);
                if (app.adjSource instanceof ProcessRecord) {
                    currApp.importanceReasonPid = ((ProcessRecord)app.adjSource).pid;
                    currApp.importanceReasonImportance = ActivityManagerService.oomAdjToImportance(app.adjSourceOom, null);
                } else if (app.adjSource instanceof ActivityRecord) {
                    ActivityRecord r = (ActivityRecord)app.adjSource;
                    if (r.app != null) {
                        currApp.importanceReasonPid = r.app.pid;
                    }
                }
                if (app.adjTarget instanceof ComponentName) {
                    currApp.importanceReasonComponent = (ComponentName)app.adjTarget;
                }
                if (runList == null) {
                    runList = new ArrayList<ActivityManager.RunningAppProcessInfo>();
                }
                runList.add(currApp);
            }
        }
        return runList;
    }

    @Override
    public List<ApplicationInfo> getRunningExternalApplications() {
        this.enforceNotIsolatedCaller("getRunningExternalApplications");
        List<ActivityManager.RunningAppProcessInfo> runningApps = this.getRunningAppProcesses();
        ArrayList<ApplicationInfo> retList = new ArrayList<ApplicationInfo>();
        if (runningApps != null && runningApps.size() > 0) {
            HashSet<String> extList = new HashSet<String>();
            for (ActivityManager.RunningAppProcessInfo app : runningApps) {
                if (app.pkgList == null) continue;
                for (String pkg : app.pkgList) {
                    extList.add(pkg);
                }
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            for (String pkg : extList) {
                try {
                    ApplicationInfo info = pm.getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
                    if ((info.flags & 0x40000) == 0) continue;
                    retList.add(info);
                }
                catch (RemoteException e) {}
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMyMemoryState(ActivityManager.RunningAppProcessInfo outInfo) {
        this.enforceNotIsolatedCaller("getMyMemoryState");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
            }
            this.fillInProcMemInfo(proc, outInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.checkCallingPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        boolean dumpAll = false;
        boolean dumpClient = false;
        String dumpPackage = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-c".equals(opt)) {
                dumpClient = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Activity manager dump options:");
                pw.println("  [-a] [-c] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    a[ctivities]: activity stack state");
                pw.println("    b[roadcasts] [PACKAGE_NAME] [history [-s]]: broadcast state");
                pw.println("    i[ntents] [PACKAGE_NAME]: pending intent state");
                pw.println("    p[rocesses] [PACKAGE_NAME]: process state");
                pw.println("    o[om]: out of memory management");
                pw.println("    prov[iders] [COMP_SPEC ...]: content provider state");
                pw.println("    provider [COMP_SPEC]: provider client-side state");
                pw.println("    s[ervices] [COMP_SPEC ...]: service state");
                pw.println("    service [COMP_SPEC]: service client-side state");
                pw.println("    package [PACKAGE_NAME]: all state related to given package");
                pw.println("    all: dump all activities");
                pw.println("    top: dump the top activity");
                pw.println("  cmd may also be a COMP_SPEC to dump activities.");
                pw.println("  COMP_SPEC may be a component name (com.foo/.myApp),");
                pw.println("    a partial substring in a component name, a");
                pw.println("    hex object identifier.");
                pw.println("  -a: include all available server state.");
                pw.println("  -c: include client state.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        long origId = Binder.clearCallingIdentity();
        boolean more = false;
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("activities".equals(cmd) || "a".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpActivitiesLocked(fd, pw, args, opti, true, dumpClient, null);
                }
            } else if ("broadcasts".equals(cmd) || "b".equals(cmd)) {
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpBroadcastsLocked(fd, pw, args, opti, true, name);
                }
            } else if ("intents".equals(cmd) || "i".equals(cmd)) {
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpPendingIntentsLocked(fd, pw, args, opti, true, name);
                }
            } else if ("processes".equals(cmd) || "p".equals(cmd)) {
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpProcessesLocked(fd, pw, args, opti, true, name);
                }
            } else if ("oom".equals(cmd) || "o".equals(cmd)) {
                ActivityManagerService newArgs = this;
                synchronized (newArgs) {
                    this.dumpOomLocked(fd, pw, args, opti, true);
                }
            } else if ("provider".equals(cmd)) {
                String[] newArgs;
                String name;
                if (opti >= args.length) {
                    name = null;
                    newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                if (!this.dumpProvider(fd, pw, name, newArgs, 0, dumpAll)) {
                    pw.println("No providers match: " + name);
                    pw.println("Use -h for help.");
                }
            } else if ("providers".equals(cmd) || "prov".equals(cmd)) {
                ActivityManagerService newArgs = this;
                synchronized (newArgs) {
                    this.dumpProvidersLocked(fd, pw, args, opti, true, null);
                }
            } else if ("service".equals(cmd)) {
                String[] newArgs;
                String name;
                if (opti >= args.length) {
                    name = null;
                    newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                if (!this.mServices.dumpService(fd, pw, name, newArgs, 0, dumpAll)) {
                    pw.println("No services match: " + name);
                    pw.println("Use -h for help.");
                }
            } else if ("package".equals(cmd)) {
                if (opti >= args.length) {
                    pw.println("package: no package name specified");
                    pw.println("Use -h for help.");
                } else {
                    dumpPackage = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                    args = newArgs;
                    opti = 0;
                    more = true;
                }
            } else if ("services".equals(cmd) || "s".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.mServices.dumpServicesLocked(fd, pw, args, opti, true, dumpClient, null);
                }
            } else if (!this.dumpActivity(fd, pw, cmd, args, opti, dumpAll)) {
                pw.println("Bad activity command, or no activities match: " + cmd);
                pw.println("Use -h for help.");
            }
            if (!more) {
                Binder.restoreCallingIdentity(origId);
                return;
            }
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.dumpPendingIntentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpBroadcastsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpProvidersLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.mServices.dumpServicesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpActivitiesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpProcessesLocked(fd, pw, args, opti, dumpAll, dumpPackage);
        }
        Binder.restoreCallingIdentity(origId);
    }

    void dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printedAnything;
        pw.println("ACTIVITY MANAGER ACTIVITIES (dumpsys activity activities)");
        boolean needSep = printedAnything = this.mStackSupervisor.dumpActivitiesLocked(fd, pw, dumpAll, dumpClient, dumpPackage);
        boolean printed = ActivityStackSupervisor.printThisActivity(pw, this.mFocusedActivity, dumpPackage, needSep, "  mFocusedActivity: ");
        if (printed) {
            printedAnything = true;
            needSep = false;
        }
        if (dumpPackage == null) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            this.mStackSupervisor.dump(pw, "  ");
        }
        if (this.mRecentTasks.size() > 0) {
            boolean printedHeader = false;
            int N = this.mRecentTasks.size();
            for (int i = 0; i < N; ++i) {
                TaskRecord tr = this.mRecentTasks.get(i);
                if (dumpPackage != null && (tr.realActivity == null || !dumpPackage.equals(tr.realActivity))) continue;
                if (!printedHeader) {
                    if (needSep) {
                        pw.println();
                    }
                    pw.println("  Recent tasks:");
                    printedHeader = true;
                    printedAnything = true;
                }
                pw.print("  * Recent #");
                pw.print(i);
                pw.print(": ");
                pw.println(tr);
                if (!dumpAll) continue;
                this.mRecentTasks.get(i).dump(pw, "    ");
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpProcessesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printed;
        boolean printed22;
        boolean needSep = false;
        boolean printedAnything = false;
        int numPers = 0;
        pw.println("ACTIVITY MANAGER RUNNING PROCESSES (dumpsys activity processes)");
        if (dumpAll) {
            int NP = this.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray<ProcessRecord> procs = this.mProcessNames.getMap().valueAt(ip);
                int NA = procs.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord r = procs.valueAt(ia);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!needSep) {
                        pw.println("  All known processes:");
                        needSep = true;
                        printedAnything = true;
                    }
                    pw.print(r.persistent ? "  *PERS*" : "  *APP*");
                    pw.print(" UID ");
                    pw.print(procs.keyAt(ia));
                    pw.print(" ");
                    pw.println(r);
                    r.dump(pw, "    ");
                    if (!r.persistent) continue;
                    ++numPers;
                }
            }
        }
        if (this.mIsolatedProcesses.size() > 0) {
            printed22 = false;
            for (int i = 0; i < this.mIsolatedProcesses.size(); ++i) {
                ProcessRecord r = this.mIsolatedProcesses.valueAt(i);
                if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                if (!printed22) {
                    if (needSep) {
                        pw.println();
                    }
                    pw.println("  Isolated process list (sorted by uid):");
                    printedAnything = true;
                    printed22 = true;
                    needSep = true;
                }
                pw.println(String.format("%sIsolated #%2d: %s", "    ", i, r.toString()));
            }
        }
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            pw.print("  Process LRU list (sorted by oom_adj, ");
            pw.print(this.mLruProcesses.size());
            pw.print(" total, non-act at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessActivityStart);
            pw.print(", non-svc at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessServiceStart);
            pw.println("):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", false, dumpPackage);
            needSep = true;
            printedAnything = true;
        }
        if (dumpAll || dumpPackage != null) {
            SparseArray<ProcessRecord> printed22 = this.mPidsSelfLocked;
            synchronized (printed22) {
                printed = false;
                for (int i = 0; i < this.mPidsSelfLocked.size(); ++i) {
                    ProcessRecord r = this.mPidsSelfLocked.valueAt(i);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  PID mappings:");
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mPidsSelfLocked.keyAt(i));
                    pw.print(": ");
                    pw.println(this.mPidsSelfLocked.valueAt(i));
                }
            }
        }
        if (this.mForegroundProcesses.size() > 0) {
            SparseArray<ProcessRecord> printed22 = this.mPidsSelfLocked;
            synchronized (printed22) {
                printed = false;
                for (int i = 0; i < this.mForegroundProcesses.size(); ++i) {
                    ProcessRecord r = this.mPidsSelfLocked.get(this.mForegroundProcesses.valueAt((int)i).pid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Foreground Processes:");
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mForegroundProcesses.keyAt(i));
                    pw.print(": ");
                    pw.println(this.mForegroundProcesses.valueAt(i));
                }
            }
        }
        if (this.mPersistentStartingProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Persisent processes that are starting:");
            ActivityManagerService.dumpProcessList(pw, this, this.mPersistentStartingProcesses, "    ", "Starting Norm", "Restarting PERS", dumpPackage);
        }
        if (this.mRemovedProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Processes that are being removed:");
            ActivityManagerService.dumpProcessList(pw, this, this.mRemovedProcesses, "    ", "Removed Norm", "Removed PERS", dumpPackage);
        }
        if (this.mProcessesOnHold.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Processes that are on old until the system is ready:");
            ActivityManagerService.dumpProcessList(pw, this, this.mProcessesOnHold, "    ", "OnHold Norm", "OnHold PERS", dumpPackage);
        }
        needSep = this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, dumpPackage);
        if (this.mProcessCrashTimes.getMap().size() > 0) {
            printed22 = false;
            long now = SystemClock.uptimeMillis();
            ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
            int NP = pmap.size();
            for (int ip = 0; ip < NP; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<Long> uids = pmap.valueAt(ip);
                int N = uids.size();
                for (int i = 0; i < N; ++i) {
                    int puid = uids.keyAt(i);
                    ProcessRecord r = this.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed22) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Time since processes crashed:");
                        printed22 = true;
                        printedAnything = true;
                    }
                    pw.print("    Process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": last crashed ");
                    TimeUtils.formatDuration(now - uids.valueAt(i), pw);
                    pw.println(" ago");
                }
            }
        }
        if (this.mBadProcesses.getMap().size() > 0) {
            printed22 = false;
            ArrayMap<String, SparseArray<BadProcessInfo>> pmap = this.mBadProcesses.getMap();
            int NP = pmap.size();
            for (int ip = 0; ip < NP; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<BadProcessInfo> uids = pmap.valueAt(ip);
                int N = uids.size();
                for (int i = 0; i < N; ++i) {
                    int puid = uids.keyAt(i);
                    ProcessRecord r = this.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed22) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Bad processes:");
                        printedAnything = true;
                    }
                    BadProcessInfo info = uids.valueAt(i);
                    pw.print("    Bad process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": crashed at time ");
                    pw.println(info.time);
                    if (info.shortMsg != null) {
                        pw.print("      Short msg: ");
                        pw.println(info.shortMsg);
                    }
                    if (info.longMsg != null) {
                        pw.print("      Long msg: ");
                        pw.println(info.longMsg);
                    }
                    if (info.stack == null) continue;
                    pw.println("      Stack:");
                    int lastPos = 0;
                    for (int pos = 0; pos < info.stack.length(); ++pos) {
                        if (info.stack.charAt(pos) != '\n') continue;
                        pw.print("        ");
                        pw.write(info.stack, lastPos, pos - lastPos);
                        pw.println();
                        lastPos = pos + 1;
                    }
                    if (lastPos >= info.stack.length()) continue;
                    pw.print("        ");
                    pw.write(info.stack, lastPos, info.stack.length() - lastPos);
                    pw.println();
                }
            }
        }
        if (dumpPackage == null) {
            int i;
            pw.println();
            needSep = false;
            pw.println("  mStartedUsers:");
            for (i = 0; i < this.mStartedUsers.size(); ++i) {
                UserStartedState uss = this.mStartedUsers.valueAt(i);
                pw.print("    User #");
                pw.print(uss.mHandle.getIdentifier());
                pw.print(": ");
                uss.dump("", pw);
            }
            pw.print("  mStartedUserArray: [");
            for (i = 0; i < this.mStartedUserArray.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.mStartedUserArray[i]);
            }
            pw.println("]");
            pw.print("  mUserLru: [");
            for (i = 0; i < this.mUserLru.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.mUserLru.get(i));
            }
            pw.println("]");
            if (dumpAll) {
                pw.print("  mStartedUserArray: ");
                pw.println(Arrays.toString(this.mStartedUserArray));
            }
        }
        if (this.mHomeProcess != null && (dumpPackage == null || this.mHomeProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mHomeProcess: " + this.mHomeProcess);
        }
        if (this.mPreviousProcess != null && (dumpPackage == null || this.mPreviousProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        }
        if (dumpAll) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("  mPreviousProcessVisibleTime: ");
            TimeUtils.formatDuration(this.mPreviousProcessVisibleTime, sb);
            pw.println(sb);
        }
        if (this.mHeavyWeightProcess != null && (dumpPackage == null || this.mHeavyWeightProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        if (dumpPackage == null) {
            pw.println("  mConfiguration: " + this.mConfiguration);
        }
        if (dumpAll) {
            pw.println("  mConfigWillChange: " + this.getFocusedStack().mConfigWillChange);
            if (this.mCompatModePackages.getPackages().size() > 0) {
                boolean printed3 = false;
                for (Map.Entry<String, Integer> entry : this.mCompatModePackages.getPackages().entrySet()) {
                    String pkg = entry.getKey();
                    int mode = entry.getValue();
                    if (dumpPackage != null && !dumpPackage.equals(pkg)) continue;
                    if (!printed3) {
                        pw.println("  mScreenCompatPackages:");
                        printed3 = true;
                    }
                    pw.print("    ");
                    pw.print(pkg);
                    pw.print(": ");
                    pw.print(mode);
                    pw.println();
                }
            }
        }
        if (dumpPackage == null) {
            if (this.mSleeping || this.mWentToSleep || this.mLockScreenShown) {
                pw.println("  mSleeping=" + this.mSleeping + " mWentToSleep=" + this.mWentToSleep + " mLockScreenShown " + this.mLockScreenShown);
            }
            if (this.mShuttingDown) {
                pw.println("  mShuttingDown=" + this.mShuttingDown);
            }
        }
        if ((this.mDebugApp != null || this.mOrigDebugApp != null || this.mDebugTransient || this.mOrigWaitForDebugger) && (dumpPackage == null || dumpPackage.equals(this.mDebugApp) || dumpPackage.equals(this.mOrigDebugApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mDebugApp=" + this.mDebugApp + "/orig=" + this.mOrigDebugApp + " mDebugTransient=" + this.mDebugTransient + " mOrigWaitForDebugger=" + this.mOrigWaitForDebugger);
        }
        if (this.mOpenGlTraceApp != null && (dumpPackage == null || dumpPackage.equals(this.mOpenGlTraceApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mOpenGlTraceApp=" + this.mOpenGlTraceApp);
        }
        if (!(this.mProfileApp == null && this.mProfileProc == null && this.mProfileFile == null && this.mProfileFd == null || dumpPackage != null && !dumpPackage.equals(this.mProfileApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mProfileApp=" + this.mProfileApp + " mProfileProc=" + this.mProfileProc);
            pw.println("  mProfileFile=" + this.mProfileFile + " mProfileFd=" + this.mProfileFd);
            pw.println("  mProfileType=" + this.mProfileType + " mAutoStopProfiler=" + this.mAutoStopProfiler);
        }
        if (dumpPackage == null) {
            if (this.mAlwaysFinishActivities || this.mController != null) {
                pw.println("  mAlwaysFinishActivities=" + this.mAlwaysFinishActivities + " mController=" + this.mController);
            }
            if (dumpAll) {
                pw.println("  Total persistent processes: " + numPers);
                pw.println("  mStartRunning=" + this.mStartRunning + " mProcessesReady=" + this.mProcessesReady + " mSystemReady=" + this.mSystemReady);
                pw.println("  mBooting=" + this.mBooting + " mBooted=" + this.mBooted + " mFactoryTest=" + this.mFactoryTest);
                pw.print("  mLastPowerCheckRealtime=");
                TimeUtils.formatDuration(this.mLastPowerCheckRealtime, pw);
                pw.println("");
                pw.print("  mLastPowerCheckUptime=");
                TimeUtils.formatDuration(this.mLastPowerCheckUptime, pw);
                pw.println("");
                pw.println("  mGoingToSleep=" + this.mStackSupervisor.mGoingToSleep);
                pw.println("  mLaunchingActivity=" + this.mStackSupervisor.mLaunchingActivity);
                pw.println("  mAdjSeq=" + this.mAdjSeq + " mLruSeq=" + this.mLruSeq);
                pw.println("  mNumNonCachedProcs=" + this.mNumNonCachedProcs + " (" + this.mLruProcesses.size() + " total)" + " mNumCachedHiddenProcs=" + this.mNumCachedHiddenProcs + " mNumServiceProcs=" + this.mNumServiceProcs + " mNewNumServiceProcs=" + this.mNewNumServiceProcs);
                pw.println("  mAllowLowerMemLevel=" + this.mAllowLowerMemLevel + " mLastMemoryLevel" + this.mLastMemoryLevel + " mLastNumProcesses" + this.mLastNumProcesses);
                long now = SystemClock.uptimeMillis();
                pw.print("  mLastIdleTime=");
                TimeUtils.formatDuration(now, this.mLastIdleTime, pw);
                pw.print(" mLowRamSinceLastIdle=");
                TimeUtils.formatDuration(this.getLowRamTimeSinceIdle(now), pw);
                pw.println();
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    boolean dumpProcessesToGc(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean needSep, boolean dumpAll, String dumpPackage) {
        if (this.mProcessesToGc.size() > 0) {
            boolean printed = false;
            long now = SystemClock.uptimeMillis();
            for (int i = 0; i < this.mProcessesToGc.size(); ++i) {
                ProcessRecord proc = this.mProcessesToGc.get(i);
                if (dumpPackage != null && !dumpPackage.equals(proc.info.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Processes that are waiting to GC:");
                    printed = true;
                }
                pw.print("    Process ");
                pw.println(proc);
                pw.print("      lowMem=");
                pw.print(proc.reportLowMemory);
                pw.print(", last gced=");
                pw.print(now - proc.lastRequestedGc);
                pw.print(" ms ago, last lowMem=");
                pw.print(now - proc.lastLowMemory);
                pw.println(" ms ago");
            }
        }
        return needSep;
    }

    void printOomLevel(PrintWriter pw, String name, int adj) {
        pw.print("    ");
        if (adj >= 0) {
            pw.print(' ');
            if (adj < 10) {
                pw.print(' ');
            }
        } else if (adj > -10) {
            pw.print(' ');
        }
        pw.print(adj);
        pw.print(": ");
        pw.print(name);
        pw.print(" (");
        pw.print(this.mProcessList.getMemLevel(adj) / 1024L);
        pw.println(" kB)");
    }

    boolean dumpOomLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll) {
        boolean needSep = false;
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  OOM levels:");
            this.printOomLevel(pw, "SYSTEM_ADJ", -16);
            this.printOomLevel(pw, "PERSISTENT_PROC_ADJ", -12);
            this.printOomLevel(pw, "FOREGROUND_APP_ADJ", 0);
            this.printOomLevel(pw, "VISIBLE_APP_ADJ", 1);
            this.printOomLevel(pw, "PERCEPTIBLE_APP_ADJ", 2);
            this.printOomLevel(pw, "BACKUP_APP_ADJ", 3);
            this.printOomLevel(pw, "HEAVY_WEIGHT_APP_ADJ", 4);
            this.printOomLevel(pw, "SERVICE_ADJ", 5);
            this.printOomLevel(pw, "HOME_APP_ADJ", 6);
            this.printOomLevel(pw, "PREVIOUS_APP_ADJ", 7);
            this.printOomLevel(pw, "SERVICE_B_ADJ", 8);
            this.printOomLevel(pw, "CACHED_APP_MIN_ADJ", 9);
            this.printOomLevel(pw, "CACHED_APP_MAX_ADJ", 15);
            if (needSep) {
                pw.println();
            }
            pw.print("  Process OOM control (");
            pw.print(this.mLruProcesses.size());
            pw.print(" total, non-act at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessActivityStart);
            pw.print(", non-svc at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessServiceStart);
            pw.println("):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", true, null);
            needSep = true;
        }
        this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, null);
        pw.println();
        pw.println("  mHomeProcess: " + this.mHomeProcess);
        pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        if (this.mHeavyWeightProcess != null) {
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        return true;
    }

    protected boolean dumpProvider(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        return this.mProviderMap.dumpProvider(fd, pw, name, args, opti, dumpAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpActivity(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ArrayList<ActivityRecord> activities;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            activities = this.mStackSupervisor.getDumpActivitiesLocked(name);
        }
        if (activities.size() <= 0) {
            return false;
        }
        String[] newArgs = new String[args.length - opti];
        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
        TaskRecord lastTask = null;
        boolean needSep = false;
        for (int i = activities.size() - 1; i >= 0; --i) {
            ActivityRecord r = activities.get(i);
            if (needSep) {
                pw.println();
            }
            needSep = true;
            ActivityManagerService activityManagerService2 = this;
            synchronized (activityManagerService2) {
                if (lastTask != r.task) {
                    lastTask = r.task;
                    pw.print("TASK ");
                    pw.print(lastTask.affinity);
                    pw.print(" id=");
                    pw.println(lastTask.taskId);
                    if (dumpAll) {
                        lastTask.dump(pw, "  ");
                    }
                }
            }
            this.dumpActivity("  ", fd, pw, activities.get(i), newArgs, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpActivity(String prefix, FileDescriptor fd, PrintWriter pw, ActivityRecord r, String[] args, boolean dumpAll) {
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            pw.print(prefix);
            pw.print("ACTIVITY ");
            pw.print(r.shortComponentName);
            pw.print(" ");
            pw.print(Integer.toHexString(System.identityHashCode(r)));
            pw.print(" pid=");
            if (r.app != null) {
                pw.println(r.app.pid);
            } else {
                pw.println("(not running)");
            }
            if (dumpAll) {
                r.dump(pw, innerPrefix);
            }
        }
        if (r.app != null && r.app.thread != null) {
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd().getFileDescriptor(), r.appToken, innerPrefix, args);
                    tp.go(fd);
                    Object var11_12 = null;
                    tp.kill();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
        }
    }

    void dumpBroadcastsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        boolean onlyHistory = false;
        boolean printedAnything = false;
        if ("history".equals(dumpPackage)) {
            if (opti < args.length && "-s".equals(args[opti])) {
                dumpAll = false;
            }
            onlyHistory = true;
            dumpPackage = null;
        }
        pw.println("ACTIVITY MANAGER BROADCAST STATE (dumpsys activity broadcasts)");
        if (!onlyHistory && dumpAll) {
            if (this.mRegisteredReceivers.size() > 0) {
                boolean printed = false;
                for (ReceiverList r : this.mRegisteredReceivers.values()) {
                    if (dumpPackage != null && (r.app == null || !dumpPackage.equals(r.app.info.packageName))) continue;
                    if (!printed) {
                        pw.println("  Registered Receivers:");
                        needSep = true;
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("  * ");
                    pw.println(r);
                    r.dump(pw, "    ");
                }
            }
            if (this.mReceiverResolver.dump(pw, needSep ? "\n  Receiver Resolver Table:" : "  Receiver Resolver Table:", "    ", dumpPackage, false)) {
                needSep = true;
                printedAnything = true;
            }
        }
        for (BroadcastQueue q : this.mBroadcastQueues) {
            needSep = q.dumpLocked(fd, pw, args, opti, dumpAll, dumpPackage, needSep);
            printedAnything |= needSep;
        }
        needSep = true;
        if (!onlyHistory && this.mStickyBroadcasts != null && dumpPackage == null) {
            for (int user = 0; user < this.mStickyBroadcasts.size(); ++user) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                printedAnything = true;
                pw.print("  Sticky broadcasts for user ");
                pw.print(this.mStickyBroadcasts.keyAt(user));
                pw.println(":");
                StringBuilder sb = new StringBuilder(128);
                for (Map.Entry<String, ArrayList<Intent>> ent : this.mStickyBroadcasts.valueAt(user).entrySet()) {
                    pw.print("  * Sticky action ");
                    pw.print(ent.getKey());
                    if (dumpAll) {
                        pw.println(":");
                        ArrayList<Intent> intents = ent.getValue();
                        int N = intents.size();
                        for (int i = 0; i < N; ++i) {
                            sb.setLength(0);
                            sb.append("    Intent: ");
                            intents.get(i).toShortString(sb, false, true, false, false);
                            pw.println(sb.toString());
                            Bundle bundle = intents.get(i).getExtras();
                            if (bundle == null) continue;
                            pw.print("      ");
                            pw.println(bundle.toString());
                        }
                        continue;
                    }
                    pw.println("");
                }
            }
        }
        if (!onlyHistory && dumpAll) {
            pw.println();
            for (BroadcastQueue queue : this.mBroadcastQueues) {
                pw.println("  mBroadcastsScheduled [" + queue.mQueueName + "]=" + queue.mBroadcastsScheduled);
            }
            pw.println("  mHandler:");
            this.mHandler.dump(new PrintWriterPrinter(pw), "    ");
            needSep = true;
            printedAnything = true;
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpProvidersLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printed;
        boolean printedAnything = false;
        ItemMatcher matcher = new ItemMatcher();
        matcher.build(args, opti);
        pw.println("ACTIVITY MANAGER CONTENT PROVIDERS (dumpsys activity providers)");
        boolean needSep = this.mProviderMap.dumpProvidersLocked(pw, dumpAll, dumpPackage);
        printedAnything |= needSep;
        if (this.mLaunchingProviders.size() > 0) {
            printed = false;
            for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
                ContentProviderRecord r = this.mLaunchingProviders.get(i);
                if (dumpPackage != null && !dumpPackage.equals(r.name.getPackageName())) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Launching content providers:");
                    printed = true;
                    printedAnything = true;
                }
                pw.print("  Launching #");
                pw.print(i);
                pw.print(": ");
                pw.println(r);
            }
        }
        if (this.mGrantedUriPermissions.size() > 0) {
            printed = false;
            int dumpUid = -2;
            if (dumpPackage != null) {
                try {
                    dumpUid = this.mContext.getPackageManager().getPackageUid(dumpPackage, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    dumpUid = -1;
                }
            }
            for (int i = 0; i < this.mGrantedUriPermissions.size(); ++i) {
                int uid = this.mGrantedUriPermissions.keyAt(i);
                if (dumpUid >= -1 && UserHandle.getAppId(uid) != dumpUid) continue;
                ArrayMap<Uri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Granted Uri Permissions:");
                    printed = true;
                    printedAnything = true;
                }
                pw.print("  * UID ");
                pw.print(uid);
                pw.println(" holds:");
                for (UriPermission perm : perms.values()) {
                    pw.print("    ");
                    pw.println(perm);
                    if (!dumpAll) continue;
                    perm.dump(pw, "      ");
                }
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpPendingIntentsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printed = false;
        pw.println("ACTIVITY MANAGER PENDING INTENTS (dumpsys activity intents)");
        if (this.mIntentSenderRecords.size() > 0) {
            for (WeakReference<PendingIntentRecord> ref : this.mIntentSenderRecords.values()) {
                PendingIntentRecord rec;
                PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
                if (dumpPackage != null && (rec == null || !dumpPackage.equals(rec.key.packageName))) continue;
                printed = true;
                if (rec != null) {
                    pw.print("  * ");
                    pw.println(rec);
                    if (!dumpAll) continue;
                    rec.dump(pw, "    ");
                    continue;
                }
                pw.print("  * ");
                pw.println(ref);
            }
        }
        if (!printed) {
            pw.println("  (nothing)");
        }
    }

    private static final int dumpProcessList(PrintWriter pw, ActivityManagerService service, List list, String prefix, String normalLabel, String persistentLabel, String dumpPackage) {
        int N;
        int numPers = 0;
        for (int i = N = list.size() - 1; i >= 0; --i) {
            ProcessRecord r = (ProcessRecord)list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
            pw.println(String.format("%s%s #%2d: %s", prefix, r.persistent ? persistentLabel : normalLabel, i, r.toString()));
            if (!r.persistent) continue;
            ++numPers;
        }
        return numPers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean dumpProcessOomList(PrintWriter pw, ActivityManagerService service, List<ProcessRecord> origList, String prefix, String normalLabel, String persistentLabel, boolean inclDetails, String dumpPackage) {
        ArrayList<Pair<ProcessRecord, Integer>> list = new ArrayList<Pair<ProcessRecord, Integer>>(origList.size());
        for (int i = 0; i < origList.size(); ++i) {
            ProcessRecord r = origList.get(i);
            if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
            list.add(new Pair<ProcessRecord, Integer>(origList.get(i), i));
        }
        if (list.size() <= 0) {
            return false;
        }
        Comparator<Pair<ProcessRecord, Integer>> comparator = new Comparator<Pair<ProcessRecord, Integer>>(){

            @Override
            public int compare(Pair<ProcessRecord, Integer> object1, Pair<ProcessRecord, Integer> object2) {
                if (((ProcessRecord)object1.first).setAdj != ((ProcessRecord)object2.first).setAdj) {
                    return ((ProcessRecord)object1.first).setAdj > ((ProcessRecord)object2.first).setAdj ? -1 : 1;
                }
                if (((Integer)object1.second).intValue() != ((Integer)object2.second).intValue()) {
                    return (Integer)object1.second > (Integer)object2.second ? -1 : 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - service.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - service.mLastPowerCheckUptime;
        for (int i = list.size() - 1; i >= 0; --i) {
            char schedGroup;
            ProcessRecord r = (ProcessRecord)((Pair)list.get((int)i)).first;
            String oomAdj = ProcessList.makeOomAdjString(r.setAdj);
            switch (r.setSchedGroup) {
                case 0: {
                    schedGroup = 'B';
                    break;
                }
                case -1: {
                    schedGroup = 'F';
                    break;
                }
                default: {
                    schedGroup = '?';
                }
            }
            char foreground = r.foregroundActivities ? (char)'A' : (r.foregroundServices ? (char)'S' : ' ');
            String procState = ProcessList.makeProcStateString(r.curProcState);
            pw.print(prefix);
            pw.print(r.persistent ? persistentLabel : normalLabel);
            pw.print(" #");
            int num = origList.size() - 1 - (Integer)((Pair)list.get((int)i)).second;
            if (num < 10) {
                pw.print(' ');
            }
            pw.print(num);
            pw.print(": ");
            pw.print(oomAdj);
            pw.print(' ');
            pw.print(schedGroup);
            pw.print('/');
            pw.print(foreground);
            pw.print('/');
            pw.print(procState);
            pw.print(" trm:");
            if (r.trimMemoryLevel < 10) {
                pw.print(' ');
            }
            pw.print(r.trimMemoryLevel);
            pw.print(' ');
            pw.print(r.toShortString());
            pw.print(" (");
            pw.print(r.adjType);
            pw.println(')');
            if (r.adjSource != null || r.adjTarget != null) {
                pw.print(prefix);
                pw.print("    ");
                if (r.adjTarget instanceof ComponentName) {
                    pw.print(((ComponentName)r.adjTarget).flattenToShortString());
                } else if (r.adjTarget != null) {
                    pw.print(r.adjTarget.toString());
                } else {
                    pw.print("{null}");
                }
                pw.print("<=");
                if (r.adjSource instanceof ProcessRecord) {
                    pw.print("Proc{");
                    pw.print(((ProcessRecord)r.adjSource).toShortString());
                    pw.println("}");
                } else if (r.adjSource != null) {
                    pw.println(r.adjSource.toString());
                } else {
                    pw.println("{null}");
                }
            }
            if (!inclDetails) continue;
            pw.print(prefix);
            pw.print("    ");
            pw.print("oom: max=");
            pw.print(r.maxAdj);
            pw.print(" curRaw=");
            pw.print(r.curRawAdj);
            pw.print(" setRaw=");
            pw.print(r.setRawAdj);
            pw.print(" cur=");
            pw.print(r.curAdj);
            pw.print(" set=");
            pw.println(r.setAdj);
            pw.print(prefix);
            pw.print("    ");
            pw.print("state: cur=");
            pw.print(ProcessList.makeProcStateString(r.curProcState));
            pw.print(" set=");
            pw.print(ProcessList.makeProcStateString(r.setProcState));
            pw.print(" lastPss=");
            pw.print(r.lastPss);
            pw.print(" lastCachedPss=");
            pw.println(r.lastCachedPss);
            pw.print(prefix);
            pw.print("    ");
            pw.print("keeping=");
            pw.print(r.keeping);
            pw.print(" cached=");
            pw.print(r.cached);
            pw.print(" empty=");
            pw.print(r.empty);
            pw.print(" hasAboveClient=");
            pw.println(r.hasAboveClient);
            if (r.keeping) continue;
            if (r.lastWakeTime != 0L) {
                long wtime;
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = service.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    wtime = stats.getProcessWakeTime(r.info.uid, r.pid, curRealtime);
                }
                long timeUsed = wtime - r.lastWakeTime;
                pw.print(prefix);
                pw.print("    ");
                pw.print("keep awake over ");
                TimeUtils.formatDuration(realtimeSince, pw);
                pw.print(" used ");
                TimeUtils.formatDuration(timeUsed, pw);
                pw.print(" (");
                pw.print(timeUsed * 100L / realtimeSince);
                pw.println("%)");
            }
            if (r.lastCpuTime == 0L) continue;
            long timeUsed = r.curCpuTime - r.lastCpuTime;
            pw.print(prefix);
            pw.print("    ");
            pw.print("run cpu over ");
            TimeUtils.formatDuration(uptimeSince, pw);
            pw.print(" used ");
            TimeUtils.formatDuration(timeUsed, pw);
            pw.print(" (");
            pw.print(timeUsed * 100L / uptimeSince);
            pw.println("%)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<ProcessRecord> collectProcesses(PrintWriter pw, int start, String[] args) {
        ArrayList<ProcessRecord> procs;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (args != null && args.length > start && args[start].charAt(0) != '-') {
                procs = new ArrayList();
                int pid = -1;
                try {
                    pid = Integer.parseInt(args[start]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord proc = this.mLruProcesses.get(i);
                    if (proc.pid == pid) {
                        procs.add(proc);
                        continue;
                    }
                    if (!proc.processName.equals(args[start])) continue;
                    procs.add(proc);
                }
                if (procs.size() <= 0) {
                    return null;
                }
            } else {
                procs = new ArrayList<ProcessRecord>(this.mLruProcesses);
            }
        }
        return procs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpGraphicsHardwareUsage(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        pw.println("Applications Graphics Acceleration Info:");
        pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Graphics info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                Object var13_12;
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpGfxInfo(tp.getWriteFd().getFileDescriptor(), args);
                    tp.go(fd);
                    var13_12 = null;
                    tp.kill();
                    continue;
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpDbInfo(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        pw.println("Applications Database Info:");
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Database info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                Object var9_10;
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpDbInfo(tp.getWriteFd().getFileDescriptor(), args);
                    tp.go(fd);
                    var9_10 = null;
                    tp.kill();
                    continue;
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    static final void dumpMemItems(PrintWriter pw, String prefix, String tag, ArrayList<MemItem> items, boolean sort, boolean isCompact) {
        if (sort && !isCompact) {
            Collections.sort(items, new Comparator<MemItem>(){

                @Override
                public int compare(MemItem lhs, MemItem rhs) {
                    if (lhs.pss < rhs.pss) {
                        return 1;
                    }
                    if (lhs.pss > rhs.pss) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (int i = 0; i < items.size(); ++i) {
            MemItem mi = items.get(i);
            if (!isCompact) {
                pw.print(prefix);
                pw.printf("%7d kB: ", mi.pss);
                pw.println(mi.label);
            } else if (mi.isProc) {
                pw.print("proc,");
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.print(mi.id);
                pw.print(",");
                pw.print(mi.pss);
                pw.println(mi.hasActivities ? ",a" : ",e");
            } else {
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.println(mi.pss);
            }
            if (mi.subitems == null) continue;
            ActivityManagerService.dumpMemItems(pw, prefix + "           ", mi.shortLabel, mi.subitems, true, isCompact);
        }
    }

    static final void appendMemBucket(StringBuilder out, long memKB, String label, boolean stackLike) {
        int start = label.lastIndexOf(46);
        start = start >= 0 ? ++start : 0;
        int end = label.length();
        for (int i = 0; i < DUMP_MEM_BUCKETS.length; ++i) {
            if (DUMP_MEM_BUCKETS[i] < memKB) continue;
            long bucket = DUMP_MEM_BUCKETS[i] / 1024L;
            out.append(bucket);
            out.append(stackLike ? "MB." : "MB ");
            out.append(label, start, end);
            return;
        }
        out.append(memKB / 1024L);
        out.append(stackLike ? "MB." : "MB ");
        out.append(label, start, end);
    }

    private final void dumpApplicationMemoryUsageHeader(PrintWriter pw, long uptime, long realtime, boolean isCheckinRequest, boolean isCompact) {
        if (isCheckinRequest || isCompact) {
            pw.print("time,");
            pw.print(uptime);
            pw.print(",");
            pw.println(realtime);
        } else {
            pw.println("Applications Memory Usage (kB):");
            pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpApplicationMemoryUsage(FileDescriptor fd, PrintWriter pw, String prefix, String[] args, boolean brief, PrintWriter categoryPw) {
        String opt;
        int opti;
        boolean dumpDetails = false;
        boolean dumpFullDetails = false;
        boolean dumpDalvik = false;
        boolean oomOnly = false;
        boolean isCompact = false;
        boolean localOnly = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpDetails = true;
                dumpFullDetails = true;
                dumpDalvik = true;
                continue;
            }
            if ("-d".equals(opt)) {
                dumpDalvik = true;
                continue;
            }
            if ("-c".equals(opt)) {
                isCompact = true;
                continue;
            }
            if ("--oom".equals(opt)) {
                oomOnly = true;
                continue;
            }
            if ("--local".equals(opt)) {
                localOnly = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("meminfo dump options: [-a] [-d] [-c] [--oom] [process]");
                pw.println("  -a: include all available information for each process.");
                pw.println("  -d: include dalvik details when dumping process details.");
                pw.println("  -c: dump in a compact machine-parseable representation.");
                pw.println("  --oom: only show processes organized by oom adj.");
                pw.println("  --local: only collect details locally, don't call process.");
                pw.println("If [process] is specified it can be the name or ");
                pw.println("pid of a specific process to dump.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        boolean isCheckinRequest = ActivityManagerService.scanArgs(args, "--checkin");
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        long[] tmpLong = new long[1];
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, opti, args);
        if (procs == null) {
            if (args != null && args.length > opti && args[opti].charAt(0) != '-') {
                ArrayList<ProcessCpuTracker.Stats> nativeProcs = new ArrayList<ProcessCpuTracker.Stats>();
                this.updateCpuStatsNow();
                int findPid = -1;
                try {
                    findPid = Integer.parseInt(args[opti]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                Thread e = this.mProcessCpuThread;
                synchronized (e) {
                    int N = this.mProcessCpuTracker.countStats();
                    for (int i = 0; i < N; ++i) {
                        ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                        if (st.pid != findPid && (st.baseName == null || !st.baseName.equals(args[opti]))) continue;
                        nativeProcs.add(st);
                    }
                }
                if (nativeProcs.size() > 0) {
                    this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, isCheckinRequest, isCompact);
                    Debug.MemoryInfo mi = null;
                    for (int i = nativeProcs.size() - 1; i >= 0; --i) {
                        ProcessCpuTracker.Stats r = (ProcessCpuTracker.Stats)nativeProcs.get(i);
                        int pid = r.pid;
                        if (!isCheckinRequest && dumpDetails) {
                            pw.println("\n** MEMINFO in pid " + pid + " [" + r.baseName + "] **");
                        }
                        if (mi == null) {
                            mi = new Debug.MemoryInfo();
                        }
                        if (dumpDetails || !brief && !oomOnly) {
                            Debug.getMemoryInfo(pid, mi);
                        } else {
                            mi.dalvikPss = (int)Debug.getPss(pid, tmpLong);
                            mi.dalvikPrivateDirty = (int)tmpLong[0];
                        }
                        ActivityThread.dumpMemInfoTable(pw, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, pid, r.baseName, 0L, 0L, 0L, 0L, 0L, 0L);
                        if (!isCheckinRequest) continue;
                        pw.println();
                    }
                    return;
                }
            }
            pw.println("No process found for: " + args[opti]);
            return;
        }
        if (!(brief || oomOnly || procs.size() != 1 && !isCheckinRequest)) {
            dumpDetails = true;
        }
        this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, isCheckinRequest, isCompact);
        String[] innerArgs = new String[args.length - opti];
        System.arraycopy(args, opti, innerArgs, 0, args.length - opti);
        ArrayList<MemItem> procMems = new ArrayList<MemItem>();
        SparseArray<MemItem> procMemsMap = new SparseArray<MemItem>();
        long nativePss = 0L;
        long dalvikPss = 0L;
        long otherPss = 0L;
        long[] miscPss = new long[16];
        long[] oomPss = new long[DUMP_MEM_OOM_LABEL.length];
        ArrayList[] oomProcs = new ArrayList[DUMP_MEM_OOM_LABEL.length];
        long totalPss = 0L;
        long cachedPss = 0L;
        Debug.MemoryInfo mi = null;
        block19: for (int i = procs.size() - 1; i >= 0; --i) {
            boolean hasActivities;
            int oomAdj;
            int pid;
            ProcessRecord r;
            block76: {
                IApplicationThread thread;
                r = procs.get(i);
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    thread = r.thread;
                    pid = r.pid;
                    oomAdj = r.getSetAdjWithServices();
                    hasActivities = r.activities.size() > 0;
                }
                if (thread == null) continue;
                if (!isCheckinRequest && dumpDetails) {
                    pw.println("\n** MEMINFO in pid " + pid + " [" + r.processName + "] **");
                }
                if (mi == null) {
                    mi = new Debug.MemoryInfo();
                }
                if (dumpDetails || !brief && !oomOnly) {
                    Debug.getMemoryInfo(pid, mi);
                } else {
                    mi.dalvikPss = (int)Debug.getPss(pid, tmpLong);
                    mi.dalvikPrivateDirty = (int)tmpLong[0];
                }
                if (dumpDetails) {
                    if (localOnly) {
                        ActivityThread.dumpMemInfoTable(pw, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, pid, r.processName, 0L, 0L, 0L, 0L, 0L, 0L);
                        if (isCheckinRequest) {
                            pw.println();
                        }
                    } else {
                        try {
                            pw.flush();
                            thread.dumpMemInfo(fd, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, innerArgs);
                        }
                        catch (RemoteException e) {
                            if (isCheckinRequest) break block76;
                            pw.println("Got RemoteException!");
                            pw.flush();
                        }
                    }
                }
            }
            long myTotalPss = mi.getTotalPss();
            long myTotalUss = mi.getTotalUss();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (r.thread != null && oomAdj == r.getSetAdjWithServices()) {
                    r.baseProcessTracker.addPss(myTotalPss, myTotalUss, true, r.pkgList);
                }
            }
            if (isCheckinRequest || mi == null) continue;
            totalPss += myTotalPss;
            MemItem pssItem = new MemItem(r.processName + " (pid " + pid + (hasActivities ? " / activities)" : ")"), r.processName, myTotalPss, pid, hasActivities);
            procMems.add(pssItem);
            procMemsMap.put(pid, pssItem);
            nativePss += (long)mi.nativePss;
            dalvikPss += (long)mi.dalvikPss;
            otherPss += (long)mi.otherPss;
            int j = 0;
            while (j < 16) {
                long mem = mi.getOtherPss(j);
                int n = j++;
                miscPss[n] = miscPss[n] + mem;
                otherPss -= mem;
            }
            if (oomAdj >= 9) {
                cachedPss += myTotalPss;
            }
            for (int oomIndex = 0; oomIndex < oomPss.length; ++oomIndex) {
                if (oomAdj > DUMP_MEM_OOM_ADJ[oomIndex] && oomIndex != oomPss.length - 1) continue;
                int n = oomIndex;
                oomPss[n] = oomPss[n] + myTotalPss;
                if (oomProcs[oomIndex] == null) {
                    oomProcs[oomIndex] = new ArrayList();
                }
                oomProcs[oomIndex].add(pssItem);
                continue block19;
            }
        }
        if (!isCheckinRequest && procs.size() > 1) {
            this.updateCpuStatsNow();
            Thread i = this.mProcessCpuThread;
            synchronized (i) {
                int N = this.mProcessCpuTracker.countStats();
                for (int i2 = 0; i2 < N; ++i2) {
                    ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i2);
                    if (st.vsize <= 0L || procMemsMap.indexOfKey(st.pid) >= 0) continue;
                    if (mi == null) {
                        mi = new Debug.MemoryInfo();
                    }
                    if (!brief && !oomOnly) {
                        Debug.getMemoryInfo(st.pid, mi);
                    } else {
                        mi.nativePss = (int)Debug.getPss(st.pid, tmpLong);
                        mi.nativePrivateDirty = (int)tmpLong[0];
                    }
                    long myTotalPss = mi.getTotalPss();
                    totalPss += myTotalPss;
                    MemItem pssItem = new MemItem(st.name + " (pid " + st.pid + ")", st.name, myTotalPss, st.pid, false);
                    procMems.add(pssItem);
                    nativePss += (long)mi.nativePss;
                    dalvikPss += (long)mi.dalvikPss;
                    otherPss += (long)mi.otherPss;
                    int j = 0;
                    while (j < 16) {
                        long mem = mi.getOtherPss(j);
                        int n = j++;
                        miscPss[n] = miscPss[n] + mem;
                        otherPss -= mem;
                    }
                    oomPss[0] = oomPss[0] + myTotalPss;
                    if (oomProcs[0] == null) {
                        oomProcs[0] = new ArrayList();
                    }
                    oomProcs[0].add(pssItem);
                }
            }
            ArrayList<MemItem> catMems = new ArrayList<MemItem>();
            catMems.add(new MemItem("Native", "Native", nativePss, -1));
            catMems.add(new MemItem("Dalvik", "Dalvik", dalvikPss, -2));
            catMems.add(new MemItem("Unknown", "Unknown", otherPss, -3));
            for (int j = 0; j < 16; ++j) {
                String label = Debug.MemoryInfo.getOtherLabel(j);
                catMems.add(new MemItem(label, label, miscPss[j], j));
            }
            ArrayList<MemItem> oomMems = new ArrayList<MemItem>();
            for (int j = 0; j < oomPss.length; ++j) {
                if (oomPss[j] == 0L) continue;
                String label = isCompact ? DUMP_MEM_OOM_COMPACT_LABEL[j] : DUMP_MEM_OOM_LABEL[j];
                MemItem item = new MemItem(label, label, oomPss[j], DUMP_MEM_OOM_ADJ[j]);
                item.subitems = oomProcs[j];
                oomMems.add(item);
            }
            if (!(brief || oomOnly || isCompact)) {
                pw.println();
                pw.println("Total PSS by process:");
                ActivityManagerService.dumpMemItems(pw, "  ", "proc", procMems, true, isCompact);
                pw.println();
            }
            if (!isCompact) {
                pw.println("Total PSS by OOM adjustment:");
            }
            ActivityManagerService.dumpMemItems(pw, "  ", "oom", oomMems, false, isCompact);
            if (!brief && !oomOnly) {
                PrintWriter out;
                PrintWriter printWriter = out = categoryPw != null ? categoryPw : pw;
                if (!isCompact) {
                    out.println();
                    out.println("Total PSS by category:");
                }
                ActivityManagerService.dumpMemItems(out, "  ", "cat", catMems, true, isCompact);
            }
            if (!isCompact) {
                pw.println();
            }
            MemInfoReader memInfo = new MemInfoReader();
            memInfo.readMemInfo();
            if (!brief) {
                if (!isCompact) {
                    pw.print("Total RAM: ");
                    pw.print(memInfo.getTotalSizeKb());
                    pw.println(" kB");
                    pw.print(" Free RAM: ");
                    pw.print(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb());
                    pw.print(" kB (");
                    pw.print(cachedPss);
                    pw.print(" cached pss + ");
                    pw.print(memInfo.getCachedSizeKb());
                    pw.print(" cached + ");
                    pw.print(memInfo.getFreeSizeKb());
                    pw.println(" free)");
                } else {
                    pw.print("ram,");
                    pw.print(memInfo.getTotalSizeKb());
                    pw.print(",");
                    pw.print(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb());
                    pw.print(",");
                    pw.println(totalPss - cachedPss);
                }
            }
            if (!isCompact) {
                pw.print(" Used RAM: ");
                pw.print(totalPss - cachedPss + memInfo.getBuffersSizeKb() + memInfo.getShmemSizeKb() + memInfo.getSlabSizeKb());
                pw.print(" kB (");
                pw.print(totalPss - cachedPss);
                pw.print(" used pss + ");
                pw.print(memInfo.getBuffersSizeKb());
                pw.print(" buffers + ");
                pw.print(memInfo.getShmemSizeKb());
                pw.print(" shmem + ");
                pw.print(memInfo.getSlabSizeKb());
                pw.println(" slab)");
                pw.print(" Lost RAM: ");
                pw.print(memInfo.getTotalSizeKb() - totalPss - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getBuffersSizeKb() - memInfo.getShmemSizeKb() - memInfo.getSlabSizeKb());
                pw.println(" kB");
            }
            if (!brief) {
                if (memInfo.getZramTotalSizeKb() != 0L) {
                    if (!isCompact) {
                        pw.print("     ZRAM: ");
                        pw.print(memInfo.getZramTotalSizeKb());
                        pw.print(" kB physical used for ");
                        pw.print(memInfo.getSwapTotalSizeKb() - memInfo.getSwapFreeSizeKb());
                        pw.print(" kB in swap (");
                        pw.print(memInfo.getSwapTotalSizeKb());
                        pw.println(" kB total swap)");
                    } else {
                        pw.print("zram,");
                        pw.print(memInfo.getZramTotalSizeKb());
                        pw.print(",");
                        pw.print(memInfo.getSwapTotalSizeKb());
                        pw.print(",");
                        pw.println(memInfo.getSwapFreeSizeKb());
                    }
                }
                int[] SINGLE_LONG_FORMAT = new int[]{8224};
                long[] longOut = new long[1];
                Process.readProcFile("/sys/kernel/mm/ksm/pages_shared", SINGLE_LONG_FORMAT, null, longOut, null);
                long shared = longOut[0] * 4096L / 1024L;
                longOut[0] = 0L;
                Process.readProcFile("/sys/kernel/mm/ksm/pages_sharing", SINGLE_LONG_FORMAT, null, longOut, null);
                long sharing = longOut[0] * 4096L / 1024L;
                longOut[0] = 0L;
                Process.readProcFile("/sys/kernel/mm/ksm/pages_unshared", SINGLE_LONG_FORMAT, null, longOut, null);
                long unshared = longOut[0] * 4096L / 1024L;
                longOut[0] = 0L;
                Process.readProcFile("/sys/kernel/mm/ksm/pages_volatile", SINGLE_LONG_FORMAT, null, longOut, null);
                long voltile = longOut[0] * 4096L / 1024L;
                if (!isCompact) {
                    if (sharing != 0L || shared != 0L || unshared != 0L || voltile != 0L) {
                        pw.print("      KSM: ");
                        pw.print(sharing);
                        pw.print(" kB saved from shared ");
                        pw.print(shared);
                        pw.println(" kB");
                        pw.print("           ");
                        pw.print(unshared);
                        pw.print(" kB unshared; ");
                        pw.print(voltile);
                        pw.println(" kB volatile");
                    }
                    pw.print("   Tuning: ");
                    pw.print(ActivityManager.staticGetMemoryClass());
                    pw.print(" (large ");
                    pw.print(ActivityManager.staticGetLargeMemoryClass());
                    pw.print("), oom ");
                    pw.print(this.mProcessList.getMemLevel(15) / 1024L);
                    pw.print(" kB");
                    pw.print(", restore limit ");
                    pw.print(this.mProcessList.getCachedRestoreThresholdKb());
                    pw.print(" kB");
                    if (ActivityManager.isLowRamDeviceStatic()) {
                        pw.print(" (low-ram)");
                    }
                    if (ActivityManager.isHighEndGfx()) {
                        pw.print(" (high-end-gfx)");
                    }
                    pw.println();
                } else {
                    pw.print("ksm,");
                    pw.print(sharing);
                    pw.print(",");
                    pw.print(shared);
                    pw.print(",");
                    pw.print(unshared);
                    pw.print(",");
                    pw.println(voltile);
                    pw.print("tuning,");
                    pw.print(ActivityManager.staticGetMemoryClass());
                    pw.print(',');
                    pw.print(ActivityManager.staticGetLargeMemoryClass());
                    pw.print(',');
                    pw.print(this.mProcessList.getMemLevel(15) / 1024L);
                    if (ActivityManager.isLowRamDeviceStatic()) {
                        pw.print(",low-ram");
                    }
                    if (ActivityManager.isHighEndGfx()) {
                        pw.print(",high-end-gfx");
                    }
                    pw.println();
                }
            }
        }
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeDyingProviderLocked(ProcessRecord proc, ContentProviderRecord cpr, boolean always) {
        boolean inLaunching = this.mLaunchingProviders.contains(cpr);
        if (!inLaunching || always) {
            ContentProviderRecord contentProviderRecord = cpr;
            synchronized (contentProviderRecord) {
                cpr.launchingApp = null;
                cpr.notifyAll();
            }
            this.mProviderMap.removeProviderByClass(cpr.name, UserHandle.getUserId(cpr.uid));
            String[] names = cpr.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                this.mProviderMap.removeProviderByName(names[j], UserHandle.getUserId(cpr.uid));
            }
        }
        for (int i = 0; i < cpr.connections.size(); ++i) {
            ContentProviderConnection conn = cpr.connections.get(i);
            if (conn.waiting && inLaunching && !always) continue;
            ProcessRecord capp = conn.client;
            conn.dead = true;
            if (conn.stableCount > 0) {
                if (capp.persistent || capp.thread == null || capp.pid == 0 || capp.pid == MY_PID) continue;
                this.killUnneededProcessLocked(capp, "depends on provider " + cpr.name.flattenToShortString() + " in dying proc " + (proc != null ? proc.processName : "??"));
                continue;
            }
            if (capp.thread == null || conn.provider.provider == null) continue;
            try {
                capp.thread.unstableProviderDied(conn.provider.provider.asBinder());
            }
            catch (RemoteException e) {
                // empty catch block
            }
            cpr.connections.remove(i);
            conn.client.conProviders.remove(conn);
        }
        if (inLaunching && always) {
            this.mLaunchingProviders.remove(cpr);
        }
        return inLaunching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUpApplicationRecordLocked(ProcessRecord app, boolean restarting, boolean allowRestart, int index) {
        int i;
        if (index >= 0) {
            this.removeLruProcessLocked(app);
        }
        this.mProcessesToGc.remove(app);
        this.mPendingPssProcesses.remove(app);
        if (app.crashDialog != null && !app.forceCrashReport) {
            app.crashDialog.dismiss();
            app.crashDialog = null;
        }
        if (app.anrDialog != null) {
            app.anrDialog.dismiss();
            app.anrDialog = null;
        }
        if (app.waitDialog != null) {
            app.waitDialog.dismiss();
            app.waitDialog = null;
        }
        app.crashing = false;
        app.notResponding = false;
        app.resetPackageList(this.mProcessStats);
        app.unlinkDeathRecipient();
        app.makeInactive(this.mProcessStats);
        app.forcingToForeground = null;
        app.foregroundServices = false;
        app.foregroundActivities = false;
        app.hasShownUi = false;
        app.hasAboveClient = false;
        this.mServices.killServicesLocked(app, allowRestart);
        boolean restart = false;
        for (i = app.pubProviders.size() - 1; i >= 0; --i) {
            boolean always;
            ContentProviderRecord cpr = app.pubProviders.valueAt(i);
            boolean bl = always = app.bad || !allowRestart;
            if (this.removeDyingProviderLocked(app, cpr, always) || always) {
                restart = true;
            }
            cpr.provider = null;
            cpr.proc = null;
        }
        app.pubProviders.clear();
        if (this.checkAppInLaunchingProvidersLocked(app, false)) {
            restart = true;
        }
        if (!app.conProviders.isEmpty()) {
            for (i = 0; i < app.conProviders.size(); ++i) {
                ContentProviderConnection conn = app.conProviders.get(i);
                conn.provider.connections.remove(conn);
            }
            app.conProviders.clear();
        }
        this.skipCurrentReceiverLocked(app);
        for (i = app.receivers.size() - 1; i >= 0; --i) {
            this.removeReceiverLocked(app.receivers.valueAt(i));
        }
        app.receivers.clear();
        if (this.mBackupTarget != null && app.pid == this.mBackupTarget.app.pid) {
            try {
                IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                bm.agentDisconnected(app.info.packageName);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        for (int i2 = this.mPendingProcessChanges.size() - 1; i2 >= 0; --i2) {
            ProcessChangeItem item = this.mPendingProcessChanges.get(i2);
            if (item.pid != app.pid) continue;
            this.mPendingProcessChanges.remove(i2);
            this.mAvailProcessChanges.add(item);
        }
        this.mHandler.obtainMessage(32, app.pid, app.info.uid, null).sendToTarget();
        if (restarting) {
            return;
        }
        if (!app.persistent || app.isolated) {
            this.mProcessNames.remove(app.processName, app.uid);
            this.mIsolatedProcesses.remove(app.uid);
            if (this.mHeavyWeightProcess == app) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
                this.mHeavyWeightProcess = null;
            }
        } else if (!app.removed && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            restart = true;
        }
        this.mProcessesOnHold.remove(app);
        if (app == this.mHomeProcess) {
            this.mHomeProcess = null;
        }
        if (app == this.mPreviousProcess) {
            this.mPreviousProcess = null;
        }
        if (restart && !app.isolated) {
            this.mProcessNames.put(app.processName, app.uid, app);
            this.startProcessLocked(app, "restart", app.processName);
        } else if (app.pid > 0 && app.pid != MY_PID) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, app);
            }
            app.setPid(0);
        }
    }

    boolean checkAppInLaunchingProvidersLocked(ProcessRecord app, boolean alwaysBad) {
        int NL = this.mLaunchingProviders.size();
        boolean restart = false;
        for (int i = 0; i < NL; ++i) {
            ContentProviderRecord cpr = this.mLaunchingProviders.get(i);
            if (cpr.launchingApp != app) continue;
            if (!alwaysBad && !app.bad) {
                restart = true;
                continue;
            }
            this.removeDyingProviderLocked(app, cpr, true);
            NL = this.mLaunchingProviders.size();
            --i;
        }
        return restart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningServiceInfo> getServices(int maxNum, int flags) {
        this.enforceNotIsolatedCaller("getServices");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.getRunningServiceInfoLocked(maxNum, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingIntent getRunningServiceControlPanel(ComponentName name) {
        this.enforceNotIsolatedCaller("getRunningServiceControlPanel");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.getRunningServiceControlPanelLocked(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName startService(IApplicationThread caller, Intent service, String resolvedType, int userId) {
        this.enforceNotIsolatedCaller("startService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            ComponentName res = this.mServices.startServiceLocked(caller, service, resolvedType, callingPid, callingUid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName startServiceInPackage(int uid, Intent service, String resolvedType, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            ComponentName res = this.mServices.startServiceLocked(null, service, resolvedType, -1, uid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopService(IApplicationThread caller, Intent service, String resolvedType, int userId) {
        this.enforceNotIsolatedCaller("stopService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.stopServiceLocked(caller, service, resolvedType, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder peekService(Intent service, String resolvedType) {
        this.enforceNotIsolatedCaller("peekService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.peekServiceLocked(service, resolvedType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopServiceToken(ComponentName className, IBinder token, int startId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.stopServiceTokenLocked(className, token, startId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceForeground(ComponentName className, IBinder token, int id2, Notification notification, boolean removeNotification) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mServices.setServiceForegroundLocked(className, token, id2, notification, removeNotification);
        }
    }

    @Override
    public int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, boolean requireFull, String name, String callerPackage) {
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUserId != userId) {
            if (callingUid != 0 && callingUid != 1000 && (requireFull || this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) != 0) && this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) != 0) {
                if (userId == -3) {
                    userId = callingUserId;
                } else {
                    StringBuilder builder = new StringBuilder(128);
                    builder.append("Permission Denial: ");
                    builder.append(name);
                    if (callerPackage != null) {
                        builder.append(" from ");
                        builder.append(callerPackage);
                    }
                    builder.append(" asks to run as user ");
                    builder.append(userId);
                    builder.append(" but is calling from user ");
                    builder.append(UserHandle.getUserId(callingUid));
                    builder.append("; this requires ");
                    builder.append("android.permission.INTERACT_ACROSS_USERS_FULL");
                    if (!requireFull) {
                        builder.append(" or ");
                        builder.append("android.permission.INTERACT_ACROSS_USERS");
                    }
                    String msg = builder.toString();
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
            }
            if (userId == -2 || userId == -3) {
                userId = this.mCurrentUserId;
            }
            if (!allowAll && userId < 0) {
                throw new IllegalArgumentException("Call does not support special user #" + userId);
            }
        }
        return userId;
    }

    boolean isSingleton(String componentProcessName, ApplicationInfo aInfo, String className, int flags) {
        boolean result = false;
        if (UserHandle.getAppId(aInfo.uid) >= 10000) {
            if ((flags & 0x40000000) != 0) {
                if (ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS", aInfo.uid) != 0) {
                    ComponentName comp = new ComponentName(aInfo.packageName, className);
                    String msg = "Permission Denial: Component " + comp.flattenToShortString() + " requests FLAG_SINGLE_USER, but app does not hold " + "android.permission.INTERACT_ACROSS_USERS";
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
                result = true;
            }
        } else if (componentProcessName == aInfo.packageName) {
            result = (aInfo.flags & 8) != 0;
        } else if ("system".equals(componentProcessName)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bindService(IApplicationThread caller, IBinder token, Intent service, String resolvedType, IServiceConnection connection, int flags, int userId) {
        this.enforceNotIsolatedCaller("bindService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.bindServiceLocked(caller, token, service, resolvedType, connection, flags, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unbindService(IServiceConnection connection) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.unbindServiceLocked(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishService(IBinder token, Intent intent, IBinder service) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                throw new IllegalArgumentException("Invalid service token");
            }
            this.mServices.publishServiceLocked((ServiceRecord)token, intent, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFinished(IBinder token, Intent intent, boolean doRebind) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mServices.unbindFinishedLocked((ServiceRecord)token, intent, doRebind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceDoneExecuting(IBinder token, int type, int startId, int res) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                throw new IllegalArgumentException("Invalid service token");
            }
            this.mServices.serviceDoneExecutingLocked((ServiceRecord)token, type, startId, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bindBackupAgent(ApplicationInfo app, int backupMode) {
        this.enforceCallingPermission("android.permission.BACKUP", "bindBackupAgent");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            BatteryStatsImpl stats;
            BatteryStatsImpl.Uid.Pkg.Serv ss = null;
            BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                ss = stats.getServiceStatsLocked(app.uid, app.packageName, app.name);
            }
            try {
                AppGlobals.getPackageManager().setPackageStoppedState(app.packageName, false, UserHandle.getUserId(app.uid));
            }
            catch (RemoteException e) {
            }
            catch (IllegalArgumentException e) {
                Slog.w(TAG, "Failed trying to unstop package " + app.packageName + ": " + e);
            }
            BackupRecord r = new BackupRecord(ss, app, backupMode);
            ComponentName hostingName = backupMode == 0 ? new ComponentName(app.packageName, app.backupAgentName) : new ComponentName("android", "FullBackupAgent");
            ProcessRecord proc = this.startProcessLocked(app.processName, app, false, 0, "backup", hostingName, false, false, false);
            if (proc == null) {
                Slog.e(TAG, "Unable to start backup agent process " + r);
                return false;
            }
            r.app = proc;
            this.mBackupTarget = r;
            this.mBackupAppName = app.packageName;
            this.updateOomAdjLocked(proc);
            if (proc.thread != null) {
                try {
                    proc.thread.scheduleCreateBackupAgent(app, this.compatibilityInfoForPackageLocked(app), backupMode);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingBackup() {
        this.enforceCallingPermission("android.permission.BACKUP", "clearPendingBackup");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mBackupTarget = null;
            this.mBackupAppName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void backupAgentCreated(String agentPackageName, IBinder agent) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!agentPackageName.equals(this.mBackupAppName)) {
                Slog.e(TAG, "Backup agent created for " + agentPackageName + " but not requested!");
                return;
            }
        }
        long oldIdent = Binder.clearCallingIdentity();
        try {
            try {
                IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                bm.agentConnected(agentPackageName, agent);
            }
            catch (RemoteException e) {
                Object var7_9 = null;
                Binder.restoreCallingIdentity(oldIdent);
                return;
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception trying to deliver BackupAgent binding: ");
                e.printStackTrace();
                Object var7_10 = null;
                Binder.restoreCallingIdentity(oldIdent);
                return;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            Binder.restoreCallingIdentity(oldIdent);
            throw throwable;
        }
        Binder.restoreCallingIdentity(oldIdent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unbindBackupAgent(ApplicationInfo appInfo) {
        if (appInfo == null) {
            Slog.w(TAG, "unbind backup agent for null app");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            block11: {
                block10: {
                    try {
                        if (this.mBackupAppName == null) {
                            Slog.w(TAG, "Unbinding backup agent with no active backup");
                            Object var6_3 = null;
                            this.mBackupTarget = null;
                            this.mBackupAppName = null;
                            return;
                        }
                        if (!this.mBackupAppName.equals(appInfo.packageName)) {
                            Slog.e(TAG, "Unbind of " + appInfo + " but is not the current backup target");
                            break block10;
                        }
                        ProcessRecord proc = this.mBackupTarget.app;
                        this.updateOomAdjLocked(proc);
                        if (proc.thread != null) {
                            try {
                                proc.thread.scheduleDestroyBackupAgent(appInfo, this.compatibilityInfoForPackageLocked(appInfo));
                            }
                            catch (Exception e) {
                                Slog.e(TAG, "Exception when unbinding backup agent:");
                                e.printStackTrace();
                            }
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.mBackupTarget = null;
                        this.mBackupAppName = null;
                        throw throwable;
                    }
                }
                Object var6_4 = null;
                this.mBackupTarget = null;
                this.mBackupAppName = null;
                return;
            }
            Object var6_5 = null;
            this.mBackupTarget = null;
            this.mBackupAppName = null;
            return;
        }
    }

    private final List getStickiesLocked(String action, IntentFilter filter, List cur, int userId) {
        ContentResolver resolver = this.mContext.getContentResolver();
        ArrayMap<String, ArrayList<Intent>> stickies = this.mStickyBroadcasts.get(userId);
        if (stickies == null) {
            return cur;
        }
        ArrayList<Intent> list = stickies.get(action);
        if (list == null) {
            return cur;
        }
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            Intent intent = list.get(i);
            if (filter.match(resolver, intent, true, TAG) < 0) continue;
            if (cur == null) {
                cur = new ArrayList<Intent>();
            }
            cur.add(intent);
        }
        return cur;
    }

    boolean isPendingBroadcastProcessLocked(int pid) {
        return this.mFgBroadcastQueue.isPendingBroadcastProcessLocked(pid) || this.mBgBroadcastQueue.isPendingBroadcastProcessLocked(pid);
    }

    void skipPendingBroadcastLocked(int pid) {
        Slog.w(TAG, "Unattached app died before broadcast acknowledged, skipping");
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipPendingBroadcastLocked(pid);
        }
    }

    boolean sendPendingBroadcastsLocked(ProcessRecord app) {
        boolean didSomething = false;
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            didSomething |= queue.sendPendingBroadcastsLocked(app);
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent registerReceiver(IApplicationThread caller, String callerPackage, IIntentReceiver receiver, IntentFilter filter, String permission2, int userId) {
        this.enforceNotIsolatedCaller("registerReceiver");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Intent sticky;
            int callingPid;
            int callingUid;
            ProcessRecord callerApp = null;
            if (caller != null) {
                callerApp = this.getRecordForAppLocked(caller);
                if (callerApp == null) {
                    throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when registering receiver " + receiver);
                }
                if (callerApp.info.uid != 1000 && !callerApp.pkgList.containsKey(callerPackage) && !"android".equals(callerPackage)) {
                    throw new SecurityException("Given caller package " + callerPackage + " is not running in process " + callerApp);
                }
                callingUid = callerApp.info.uid;
                callingPid = callerApp.pid;
            } else {
                callerPackage = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
            }
            userId = this.handleIncomingUser(callingPid, callingUid, userId, true, true, "registerReceiver", callerPackage);
            List allSticky = null;
            Iterator<String> actions = filter.actionsIterator();
            if (actions != null) {
                while (actions.hasNext()) {
                    String action = actions.next();
                    allSticky = this.getStickiesLocked(action, filter, allSticky, -1);
                    allSticky = this.getStickiesLocked(action, filter, allSticky, UserHandle.getUserId(callingUid));
                }
            } else {
                allSticky = this.getStickiesLocked(null, filter, allSticky, -1);
                allSticky = this.getStickiesLocked(null, filter, allSticky, UserHandle.getUserId(callingUid));
            }
            Intent intent = sticky = allSticky != null ? (Intent)allSticky.get(0) : null;
            if (receiver == null) {
                return sticky;
            }
            ReceiverList rl = this.mRegisteredReceivers.get(receiver.asBinder());
            if (rl == null) {
                rl = new ReceiverList(this, callerApp, callingPid, callingUid, userId, receiver);
                if (rl.app != null) {
                    rl.app.receivers.add(rl);
                } else {
                    try {
                        receiver.asBinder().linkToDeath(rl, 0);
                    }
                    catch (RemoteException e) {
                        return sticky;
                    }
                    rl.linkedToDeath = true;
                }
                this.mRegisteredReceivers.put(receiver.asBinder(), rl);
            } else {
                if (rl.uid != callingUid) {
                    throw new IllegalArgumentException("Receiver requested to register for uid " + callingUid + " was previously registered for uid " + rl.uid);
                }
                if (rl.pid != callingPid) {
                    throw new IllegalArgumentException("Receiver requested to register for pid " + callingPid + " was previously registered for pid " + rl.pid);
                }
                if (rl.userId != userId) {
                    throw new IllegalArgumentException("Receiver requested to register for user " + userId + " was previously registered for user " + rl.userId);
                }
            }
            BroadcastFilter bf = new BroadcastFilter(filter, rl, callerPackage, permission2, callingUid, userId);
            rl.add(bf);
            if (!bf.debugCheck()) {
                Slog.w(TAG, "==> For Dynamic broadast");
            }
            this.mReceiverResolver.addFilter(bf);
            if (allSticky != null) {
                ArrayList<BroadcastFilter> receivers = new ArrayList<BroadcastFilter>();
                receivers.add(bf);
                int N = allSticky.size();
                for (int i = 0; i < N; ++i) {
                    Intent intent2 = (Intent)allSticky.get(i);
                    BroadcastQueue queue = this.broadcastQueueForIntent(intent2);
                    BroadcastRecord r = new BroadcastRecord(queue, intent2, null, null, -1, -1, null, null, -1, receivers, null, 0, null, null, false, true, true, -1);
                    queue.enqueueParallelBroadcastLocked(r);
                    queue.scheduleBroadcastsLocked();
                }
            }
            return sticky;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterReceiver(IIntentReceiver receiver) {
        long origId;
        block9: {
            origId = Binder.clearCallingIdentity();
            try {
                boolean doTrim = false;
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    ReceiverList rl = this.mRegisteredReceivers.get(receiver.asBinder());
                    if (rl != null) {
                        if (rl.curBroadcast != null) {
                            BroadcastRecord r = rl.curBroadcast;
                            boolean doNext = this.finishReceiverLocked(receiver.asBinder(), r.resultCode, r.resultData, r.resultExtras, r.resultAbort);
                            if (doNext) {
                                doTrim = true;
                                r.queue.processNextBroadcast(false);
                            }
                        }
                        if (rl.app != null) {
                            rl.app.receivers.remove(rl);
                        }
                        this.removeReceiverLocked(rl);
                        if (rl.linkedToDeath) {
                            rl.linkedToDeath = false;
                            rl.receiver.asBinder().unlinkToDeath(rl, 0);
                        }
                    }
                    if (!doTrim) break block9;
                }
                this.trimApplications();
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return;
        }
        Object var11_9 = null;
        Binder.restoreCallingIdentity(origId);
    }

    void removeReceiverLocked(ReceiverList rl) {
        this.mRegisteredReceivers.remove(rl.receiver.asBinder());
        int N = rl.size();
        for (int i = 0; i < N; ++i) {
            this.mReceiverResolver.removeFilter((BroadcastFilter)((IntentFilter)rl.get(i)));
        }
    }

    private final void sendPackageBroadcastLocked(int cmd, String[] packages, int userId) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null || userId != -1 && r.userId != userId) continue;
            try {
                r.thread.dispatchPackageBroadcast(cmd, packages);
                continue;
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    private List<ResolveInfo> collectReceiverComponents(Intent intent, String resolvedType, int[] users) {
        List<ResolveInfo> receivers = null;
        try {
            HashSet<ComponentName> singleUserReceivers = null;
            boolean scannedFirstReceivers = false;
            for (int user : users) {
                ComponentName cn;
                ResolveInfo ri;
                int i;
                List<ResolveInfo> newReceivers = AppGlobals.getPackageManager().queryIntentReceivers(intent, resolvedType, 1024, user);
                if (user != 0 && newReceivers != null) {
                    for (i = 0; i < newReceivers.size(); ++i) {
                        ri = newReceivers.get(i);
                        if ((ri.activityInfo.flags & 0x20000000) == 0) continue;
                        newReceivers.remove(i);
                        --i;
                    }
                }
                if (newReceivers != null && newReceivers.size() == 0) {
                    newReceivers = null;
                }
                if (receivers == null) {
                    receivers = newReceivers;
                    continue;
                }
                if (newReceivers == null) continue;
                if (!scannedFirstReceivers) {
                    scannedFirstReceivers = true;
                    for (i = 0; i < receivers.size(); ++i) {
                        ri = receivers.get(i);
                        if ((ri.activityInfo.flags & 0x40000000) == 0) continue;
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet();
                        }
                        singleUserReceivers.add(cn);
                    }
                }
                for (i = 0; i < newReceivers.size(); ++i) {
                    ri = newReceivers.get(i);
                    if ((ri.activityInfo.flags & 0x40000000) != 0) {
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet<ComponentName>();
                        }
                        if (singleUserReceivers.contains(cn)) continue;
                        singleUserReceivers.add(cn);
                        receivers.add(ri);
                        continue;
                    }
                    receivers.add(ri);
                }
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return receivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int broadcastIntentLocked(ProcessRecord callerApp, String callerPackage, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle map, String requiredPermission, int appOp, boolean ordered, boolean sticky, int callingPid, int callingUid, int userId) {
        int NR;
        block56: {
            String ssp;
            Uri data;
            block54: {
                String ssp2;
                block57: {
                    block55: {
                        int uid;
                        block53: {
                            intent = new Intent(intent);
                            intent.addFlags(16);
                            if (resultTo != null && !ordered) {
                                Slog.w(TAG, "Broadcast " + intent + " not ordered but result callback requested!");
                            }
                            if ((userId = this.handleIncomingUser(callingPid, callingUid, userId, true, false, "broadcast", callerPackage)) != -1 && this.mStartedUsers.get(userId) == null && (callingUid != 1000 || (intent.getFlags() & 0x2000000) == 0)) {
                                Slog.w(TAG, "Skipping broadcast of " + intent + ": user " + userId + " is stopped");
                                return 0;
                            }
                            int callingAppId = UserHandle.getAppId(callingUid);
                            if (!(callingAppId == 1000 || callingAppId == 1001 || callingAppId == 2000 || callingAppId == 1002 || callingUid == 0 || callerApp != null && callerApp.persistent)) {
                                try {
                                    if (AppGlobals.getPackageManager().isProtectedBroadcast(intent.getAction())) {
                                        String msg = "Permission Denial: not allowed to send broadcast " + intent.getAction() + " from pid=" + callingPid + ", uid=" + callingUid;
                                        Slog.w(TAG, msg);
                                        throw new SecurityException(msg);
                                    }
                                    if (!"android.appwidget.action.APPWIDGET_CONFIGURE".equals(intent.getAction())) break block53;
                                    if (callerApp == null) {
                                        String msg = "Permission Denial: not allowed to send broadcast " + intent.getAction() + " from unknown caller.";
                                        Slog.w(TAG, msg);
                                        throw new SecurityException(msg);
                                    }
                                    if (intent.getComponent() != null) {
                                        if (!intent.getComponent().getPackageName().equals(callerApp.info.packageName)) {
                                            String msg = "Permission Denial: not allowed to send broadcast " + intent.getAction() + " to " + intent.getComponent().getPackageName() + " from " + callerApp.info.packageName;
                                            Slog.w(TAG, msg);
                                            throw new SecurityException(msg);
                                        }
                                    } else {
                                        intent.setPackage(callerApp.info.packageName);
                                    }
                                }
                                catch (RemoteException e) {
                                    Slog.w(TAG, "Remote exception", e);
                                    return 0;
                                }
                            }
                        }
                        boolean uidRemoved = "android.intent.action.UID_REMOVED".equals(intent.getAction());
                        if (!"android.intent.action.PACKAGE_REMOVED".equals(intent.getAction()) && !"android.intent.action.PACKAGE_CHANGED".equals(intent.getAction()) && !"android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(intent.getAction()) && !uidRemoved) break block54;
                        if (this.checkComponentPermission("android.permission.BROADCAST_PACKAGE_REMOVED", callingPid, callingUid, -1, true) != 0) {
                            String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + "android.permission.BROADCAST_PACKAGE_REMOVED";
                            Slog.w(TAG, msg);
                            throw new SecurityException(msg);
                        }
                        if (!uidRemoved) break block55;
                        Bundle intentExtras = intent.getExtras();
                        int n = uid = intentExtras != null ? intentExtras.getInt("android.intent.extra.UID") : -1;
                        if (uid >= 0) {
                            BatteryStatsImpl bs;
                            BatteryStatsImpl batteryStatsImpl = bs = this.mBatteryStatsService.getActiveStatistics();
                            synchronized (batteryStatsImpl) {
                                bs.removeUidStatsLocked(uid);
                            }
                            this.mAppOpsService.uidRemoved(uid);
                        }
                        break block56;
                    }
                    if (!"android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(intent.getAction())) break block57;
                    String[] list = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    if (list != null && list.length > 0) {
                        for (String pkg : list) {
                            this.forceStopPackageLocked(pkg, -1, false, true, true, false, userId, "storage unmount");
                        }
                        this.sendPackageBroadcastLocked(1, list, userId);
                    }
                    break block56;
                }
                data = intent.getData();
                if (data == null || (ssp2 = data.getSchemeSpecificPart()) == null) break block56;
                boolean removed = "android.intent.action.PACKAGE_REMOVED".equals(intent.getAction());
                if (!intent.getBooleanExtra("android.intent.extra.DONT_KILL_APP", false)) {
                    this.forceStopPackageLocked(ssp2, UserHandle.getAppId(intent.getIntExtra("android.intent.extra.UID", -1)), false, true, true, false, userId, removed ? "pkg removed" : "pkg changed");
                }
                if (removed) {
                    this.sendPackageBroadcastLocked(0, new String[]{ssp2}, userId);
                    if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                        this.mAppOpsService.packageRemoved(intent.getIntExtra("android.intent.extra.UID", -1), ssp2);
                        this.removeUriPermissionsForPackageLocked(ssp2, userId, true);
                    }
                }
                break block56;
            }
            if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction()) && (data = intent.getData()) != null && (ssp = data.getSchemeSpecificPart()) != null) {
                this.mCompatModePackages.handlePackageAddedLocked(ssp, intent.getBooleanExtra("android.intent.extra.REPLACING", false));
            }
        }
        if ("android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
            this.mHandler.sendEmptyMessage(13);
        }
        if ("android.intent.action.CLEAR_DNS_CACHE".equals(intent.getAction())) {
            this.mHandler.sendEmptyMessage(28);
        }
        if ("android.intent.action.PROXY_CHANGE".equals(intent.getAction())) {
            ProxyProperties proxy = (ProxyProperties)intent.getParcelableExtra("proxy");
            this.mHandler.sendMessage(this.mHandler.obtainMessage(29, proxy));
        }
        if (sticky) {
            int i;
            ArrayList<Intent> list;
            ArrayMap<String, ArrayList<Intent>> stickies;
            if (this.checkPermission("android.permission.BROADCAST_STICKY", callingPid, callingUid) != 0) {
                String msg = "Permission Denial: broadcastIntent() requesting a sticky broadcast from pid=" + callingPid + ", uid=" + callingUid + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w(TAG, msg);
                throw new SecurityException(msg);
            }
            if (requiredPermission != null) {
                Slog.w(TAG, "Can't broadcast sticky intent " + intent + " and enforce permission " + requiredPermission);
                return -1;
            }
            if (intent.getComponent() != null) {
                throw new SecurityException("Sticky broadcasts can't target a specific component");
            }
            if (userId != -1 && (stickies = this.mStickyBroadcasts.get(-1)) != null && (list = stickies.get(intent.getAction())) != null) {
                int N = list.size();
                for (int i2 = 0; i2 < N; ++i2) {
                    if (!intent.filterEquals(list.get(i2))) continue;
                    throw new IllegalArgumentException("Sticky broadcast " + intent + " for user " + userId + " conflicts with existing global broadcast");
                }
            }
            if ((stickies = this.mStickyBroadcasts.get(userId)) == null) {
                stickies = new ArrayMap();
                this.mStickyBroadcasts.put(userId, stickies);
            }
            if ((list = stickies.get(intent.getAction())) == null) {
                list = new ArrayList();
                stickies.put(intent.getAction(), list);
            }
            int N = list.size();
            for (i = 0; i < N; ++i) {
                if (!intent.filterEquals(list.get(i))) continue;
                list.set(i, new Intent(intent));
                break;
            }
            if (i >= N) {
                list.add(new Intent(intent));
            }
        }
        int[] users = userId == -1 ? this.mStartedUserArray : new int[]{userId};
        List<ResolveInfo> receivers = null;
        List<BroadcastFilter> registeredReceivers = null;
        if ((intent.getFlags() & 0x40000000) == 0) {
            receivers = this.collectReceiverComponents(intent, resolvedType, users);
        }
        if (intent.getComponent() == null) {
            registeredReceivers = this.mReceiverResolver.queryIntent(intent, resolvedType, false, userId);
        }
        boolean replacePending = (intent.getFlags() & 0x20000000) != 0;
        int n = NR = registeredReceivers != null ? registeredReceivers.size() : 0;
        if (!ordered && NR > 0) {
            boolean replaced;
            BroadcastQueue queue = this.broadcastQueueForIntent(intent);
            BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, resolvedType, requiredPermission, appOp, registeredReceivers, resultTo, resultCode, resultData, map, ordered, sticky, false, userId);
            boolean bl = replaced = replacePending && queue.replaceParallelBroadcastLocked(r);
            if (!replaced) {
                queue.enqueueParallelBroadcastLocked(r);
                queue.scheduleBroadcastsLocked();
            }
            registeredReceivers = null;
            NR = 0;
        }
        int ir = 0;
        if (receivers != null) {
            String[] skipPackages = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction()) || "android.intent.action.PACKAGE_RESTARTED".equals(intent.getAction()) || "android.intent.action.PACKAGE_DATA_CLEARED".equals(intent.getAction())) {
                String pkgName;
                Uri data = intent.getData();
                if (data != null && (pkgName = data.getSchemeSpecificPart()) != null) {
                    skipPackages = new String[]{pkgName};
                }
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(intent.getAction())) {
                skipPackages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (skipPackages != null && skipPackages.length > 0) {
                for (String skipPackage : skipPackages) {
                    if (skipPackage == null) continue;
                    int NT = receivers.size();
                    for (int it = 0; it < NT; ++it) {
                        ResolveInfo curt = receivers.get(it);
                        if (!curt.activityInfo.packageName.equals(skipPackage)) continue;
                        receivers.remove(it);
                        --it;
                        --NT;
                    }
                }
            }
            int NT = receivers != null ? receivers.size() : 0;
            int it = 0;
            ResolveInfo curt = null;
            IntentFilter curr = null;
            while (it < NT && ir < NR) {
                if (curt == null) {
                    curt = receivers.get(it);
                }
                if (curr == null) {
                    curr = registeredReceivers.get(ir);
                }
                if (curr.getPriority() >= curt.priority) {
                    receivers.add(it, (ResolveInfo)((Object)curr));
                    ++ir;
                    curr = null;
                    ++it;
                    ++NT;
                    continue;
                }
                ++it;
                curt = null;
            }
        }
        while (ir < NR) {
            if (receivers == null) {
                receivers = new ArrayList<ResolveInfo>();
            }
            receivers.add((ResolveInfo)((Object)registeredReceivers.get(ir)));
            ++ir;
        }
        if (receivers == null || receivers.size() <= 0) {
            if (resultTo == null) return 0;
        }
        BroadcastQueue queue = this.broadcastQueueForIntent(intent);
        BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, resolvedType, requiredPermission, appOp, receivers, resultTo, resultCode, resultData, map, ordered, sticky, false, userId);
        if (replacePending && queue.replaceOrderedBroadcastLocked(r)) {
            return 0;
        }
        boolean bl = false;
        boolean replaced = bl;
        if (replaced) return 0;
        queue.enqueueOrderedBroadcastLocked(r);
        queue.scheduleBroadcastsLocked();
        return 0;
    }

    final Intent verifyBroadcastLocked(Intent intent) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        int flags = intent.getFlags();
        if (!this.mProcessesReady) {
            if ((flags & 0x4000000) != 0) {
                intent = new Intent(intent);
                intent.addFlags(0x40000000);
            } else if ((flags & 0x40000000) == 0) {
                Slog.e(TAG, "Attempt to launch receivers of broadcast intent " + intent + " before boot completion");
                throw new IllegalStateException("Cannot broadcast before boot completed");
            }
        }
        if ((flags & 0x2000000) != 0) {
            throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
        }
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int broadcastIntent(IApplicationThread caller, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle map, String requiredPermission, int appOp, boolean serialized, boolean sticky, int userId) {
        this.enforceNotIsolatedCaller("broadcastIntent");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            intent = this.verifyBroadcastLocked(intent);
            ProcessRecord callerApp = this.getRecordForAppLocked(caller);
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            int res = this.broadcastIntentLocked(callerApp, callerApp != null ? callerApp.info.packageName : null, intent, resolvedType, resultTo, resultCode, resultData, map, requiredPermission, appOp, serialized, sticky, callingPid, callingUid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int broadcastIntentInPackage(String packageName, int uid, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle map, String requiredPermission, boolean serialized, boolean sticky, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            intent = this.verifyBroadcastLocked(intent);
            long origId = Binder.clearCallingIdentity();
            int res = this.broadcastIntentLocked(null, packageName, intent, resolvedType, resultTo, resultCode, resultData, map, requiredPermission, -1, serialized, sticky, -1, uid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unbroadcastIntent(IApplicationThread caller, Intent intent, int userId) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "removeStickyBroadcast", null);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.BROADCAST_STICKY") != 0) {
                String msg = "Permission Denial: unbroadcastIntent() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w(TAG, msg);
                throw new SecurityException(msg);
            }
            ArrayMap<String, ArrayList<Intent>> stickies = this.mStickyBroadcasts.get(userId);
            if (stickies != null) {
                ArrayList<Intent> list = stickies.get(intent.getAction());
                if (list != null) {
                    int N = list.size();
                    for (int i = 0; i < N; ++i) {
                        if (!intent.filterEquals(list.get(i))) continue;
                        list.remove(i);
                        break;
                    }
                    if (list.size() <= 0) {
                        stickies.remove(intent.getAction());
                    }
                }
                if (stickies.size() <= 0) {
                    this.mStickyBroadcasts.remove(userId);
                }
            }
        }
    }

    private final boolean finishReceiverLocked(IBinder receiver, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort) {
        BroadcastRecord r = this.broadcastRecordForReceiverLocked(receiver);
        if (r == null) {
            Slog.w(TAG, "finishReceiver called but not found on queue");
            return false;
        }
        return r.queue.finishReceiverLocked(r, resultCode, resultData, resultExtras, resultAbort, false);
    }

    void backgroundServicesFinishedLocked(int userId) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.backgroundServicesFinishedLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishReceiver(IBinder who, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort) {
        if (resultExtras != null && resultExtras.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            BroadcastRecord r;
            boolean doNext = false;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                r = this.broadcastRecordForReceiverLocked(who);
                if (r != null) {
                    doNext = r.queue.finishReceiverLocked(r, resultCode, resultData, resultExtras, resultAbort, true);
                }
            }
            if (doNext) {
                r.queue.processNextBroadcast(false);
            }
            this.trimApplications();
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            Binder.restoreCallingIdentity(origId);
            throw throwable;
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startInstrumentation(ComponentName className, String profileFile, int flags, Bundle arguments, IInstrumentationWatcher watcher, IUiAutomationConnection uiAutomationConnection, int userId) {
        this.enforceNotIsolatedCaller("startInstrumentation");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "startInstrumentation", null);
        if (arguments != null && arguments.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            InstrumentationInfo ii = null;
            ApplicationInfo ai = null;
            try {
                ii = this.mContext.getPackageManager().getInstrumentationInfo(className, 1024);
                ai = AppGlobals.getPackageManager().getApplicationInfo(ii.targetPackage, 1024, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
            if (ii == null) {
                this.reportStartInstrumentationFailure(watcher, className, "Unable to find instrumentation info for: " + className);
                return false;
            }
            if (ai == null) {
                this.reportStartInstrumentationFailure(watcher, className, "Unable to find instrumentation target package: " + ii.targetPackage);
                return false;
            }
            int match = this.mContext.getPackageManager().checkSignatures(ii.targetPackage, ii.packageName);
            if (match < 0 && match != -1) {
                String msg = "Permission Denial: starting instrumentation " + className + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingPid() + " not allowed because package " + ii.packageName + " does not have a signature matching the target " + ii.targetPackage;
                this.reportStartInstrumentationFailure(watcher, className, msg);
                throw new SecurityException(msg);
            }
            long origId = Binder.clearCallingIdentity();
            this.forceStopPackageLocked(ii.targetPackage, -1, true, false, true, true, userId, "start instr");
            ProcessRecord app = this.addAppLocked(ai, false);
            app.instrumentationClass = className;
            app.instrumentationInfo = ai;
            app.instrumentationProfileFile = profileFile;
            app.instrumentationArguments = arguments;
            app.instrumentationWatcher = watcher;
            app.instrumentationUiAutomationConnection = uiAutomationConnection;
            app.instrumentationResultClass = className;
            Binder.restoreCallingIdentity(origId);
        }
        return true;
    }

    private void reportStartInstrumentationFailure(IInstrumentationWatcher watcher, ComponentName cn, String report) {
        Slog.w(TAG, report);
        try {
            if (watcher != null) {
                Bundle results = new Bundle();
                results.putString("id", "ActivityManagerService");
                results.putString("Error", report);
                watcher.instrumentationStatus(cn, -1, results);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, e);
        }
    }

    void finishInstrumentationLocked(ProcessRecord app, int resultCode, Bundle results) {
        if (app.instrumentationWatcher != null) {
            try {
                app.instrumentationWatcher.instrumentationFinished(app.instrumentationClass, resultCode, results);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (app.instrumentationUiAutomationConnection != null) {
            try {
                app.instrumentationUiAutomationConnection.shutdown();
            }
            catch (RemoteException re) {
                // empty catch block
            }
            this.mUserIsMonkey = false;
        }
        app.instrumentationWatcher = null;
        app.instrumentationUiAutomationConnection = null;
        app.instrumentationClass = null;
        app.instrumentationInfo = null;
        app.instrumentationProfileFile = null;
        app.instrumentationArguments = null;
        this.forceStopPackageLocked(app.info.packageName, -1, false, false, true, true, app.userId, "finished inst");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishInstrumentation(IApplicationThread target, int resultCode, Bundle results) {
        int userId = UserHandle.getCallingUserId();
        if (results != null && results.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.getRecordForAppLocked(target);
            if (app == null) {
                Slog.w(TAG, "finishInstrumentation: no app for " + target);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.finishInstrumentationLocked(app, resultCode, results);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationInfo getDeviceConfigurationInfo() {
        ConfigurationInfo config = new ConfigurationInfo();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            config.reqTouchScreen = this.mConfiguration.touchscreen;
            config.reqKeyboardType = this.mConfiguration.keyboard;
            config.reqNavigation = this.mConfiguration.navigation;
            if (this.mConfiguration.navigation == 2 || this.mConfiguration.navigation == 3) {
                config.reqInputFeatures |= 2;
            }
            if (this.mConfiguration.keyboard != 0 && this.mConfiguration.keyboard != 1) {
                config.reqInputFeatures |= 1;
            }
            config.reqGlEsVersion = this.GL_ES_VERSION;
        }
        return config;
    }

    ActivityStack getFocusedStack() {
        return this.mStackSupervisor.getFocusedStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration() {
        Configuration ci;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ci = new Configuration(this.mConfiguration);
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePersistentConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
        this.enforceCallingPermission("android.permission.WRITE_SETTINGS", "updateConfiguration()");
        if (values == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            this.updateConfigurationLocked(values, null, true, false);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (values == null && this.mWindowManager != null) {
                values = this.mWindowManager.computeNewConfiguration();
            }
            if (this.mWindowManager != null) {
                this.mProcessList.applyDisplaySize(this.mWindowManager);
            }
            long origId = Binder.clearCallingIdentity();
            if (values != null) {
                Settings.System.clearConfiguration(values);
            }
            this.updateConfigurationLocked(values, null, false, false);
            Binder.restoreCallingIdentity(origId);
        }
    }

    boolean updateConfigurationLocked(Configuration values, ActivityRecord starting, boolean persistent, boolean initLocale) {
        Configuration newConfig;
        if (this.mHeadless) {
            return true;
        }
        int changes = 0;
        if (values != null && (changes = (newConfig = new Configuration(this.mConfiguration)).updateFrom(values)) != 0) {
            EventLog.writeEvent(2719, changes);
            if (values.locale != null && !initLocale) {
                this.saveLocaleLocked(values.locale, !values.locale.equals(this.mConfiguration.locale), values.userSetLocale);
            }
            ++this.mConfigurationSeq;
            if (this.mConfigurationSeq <= 0) {
                this.mConfigurationSeq = 1;
            }
            newConfig.seq = this.mConfigurationSeq;
            this.mConfiguration = newConfig;
            Slog.i(TAG, "Config changes=" + Integer.toHexString(changes) + " " + newConfig);
            Configuration configCopy = new Configuration(this.mConfiguration);
            this.mShowDialogs = ActivityManagerService.shouldShowDialogs(newConfig);
            AttributeCache ac = AttributeCache.instance();
            if (ac != null) {
                ac.updateConfiguration(configCopy);
            }
            mSystemThread.applyConfigurationToResources(configCopy);
            if (persistent && Settings.System.hasInterestingConfigurationChanges(changes)) {
                Message msg = this.mHandler.obtainMessage(4);
                msg.obj = new Configuration(configCopy);
                this.mHandler.sendMessage(msg);
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                try {
                    if (app.thread == null) continue;
                    app.thread.scheduleConfigurationChanged(configCopy);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Intent intent = new Intent("android.intent.action.CONFIGURATION_CHANGED");
            intent.addFlags(0x70000000);
            this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, -1);
            if ((changes & 4) != 0) {
                intent = new Intent("android.intent.action.LOCALE_CHANGED");
                intent.addFlags(0x10000000);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, -1);
            }
        }
        boolean kept = true;
        ActivityStack mainStack = this.mStackSupervisor.getFocusedStack();
        if (changes != 0 && starting == null) {
            starting = mainStack.topRunningActivityLocked(null);
        }
        if (starting != null) {
            kept = mainStack.ensureActivityConfigurationLocked(starting, changes);
            this.mStackSupervisor.ensureActivitiesVisibleLocked(starting, changes);
        }
        if (values != null && this.mWindowManager != null) {
            this.mWindowManager.setNewConfiguration(this.mConfiguration);
        }
        return kept;
    }

    private static final boolean shouldShowDialogs(Configuration config) {
        return config.keyboard != 1 || config.touchscreen != 1;
    }

    private void saveLocaleLocked(Locale l, boolean isDiff, boolean isPersist) {
        if (isDiff) {
            SystemProperties.set("user.language", l.getLanguage());
            SystemProperties.set("user.region", l.getCountry());
        }
        if (isPersist) {
            SystemProperties.set("persist.sys.language", l.getLanguage());
            SystemProperties.set("persist.sys.country", l.getCountry());
            SystemProperties.set("persist.sys.localevar", l.getVariant());
        }
    }

    @Override
    public boolean targetTaskAffinityMatchesActivity(IBinder token, String destAffinity) {
        ActivityRecord srec = ActivityRecord.forToken(token);
        return srec != null && srec.task.affinity != null && srec.task.affinity.equals(destAffinity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean navigateUpTo(IBinder token, Intent destIntent, int resultCode, Intent resultData) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                return stack.navigateUpToLocked(token, destIntent, resultCode, resultData);
            }
            return false;
        }
    }

    @Override
    public int getLaunchedFromUid(IBinder activityToken) {
        ActivityRecord srec = ActivityRecord.forToken(activityToken);
        if (srec == null) {
            return -1;
        }
        return srec.launchedFromUid;
    }

    @Override
    public String getLaunchedFromPackage(IBinder activityToken) {
        ActivityRecord srec = ActivityRecord.forToken(activityToken);
        if (srec == null) {
            return null;
        }
        return srec.launchedFromPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BroadcastQueue isReceivingBroadcast(ProcessRecord app) {
        BroadcastRecord r = app.curReceiver;
        if (r != null) {
            return r.queue;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (BroadcastQueue queue : this.mBroadcastQueues) {
                r = queue.mPendingBroadcast;
                if (r == null || r.curApp != app) continue;
                return queue;
            }
        }
        return null;
    }

    private final int computeOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, long now) {
        int changes;
        int i;
        int procState;
        int schedGroup;
        int adj;
        if (this.mAdjSeq == app.adjSeq) {
            return app.curRawAdj;
        }
        if (app.thread == null) {
            app.adjSeq = this.mAdjSeq;
            app.curSchedGroup = 0;
            app.curProcState = 13;
            app.curRawAdj = 15;
            app.curAdj = 15;
            return 15;
        }
        app.adjTypeCode = 0;
        app.adjSource = null;
        app.adjTarget = null;
        app.empty = false;
        app.cached = false;
        int activitiesSize = app.activities.size();
        if (app.maxAdj <= 0) {
            app.adjType = "fixed";
            app.adjSeq = this.mAdjSeq;
            app.curRawAdj = app.maxAdj;
            app.foregroundActivities = false;
            app.keeping = true;
            app.curSchedGroup = -1;
            app.curProcState = 0;
            app.systemNoUi = true;
            if (app == TOP_APP) {
                app.systemNoUi = false;
            } else if (activitiesSize > 0) {
                for (int j = 0; j < activitiesSize; ++j) {
                    ActivityRecord r = app.activities.get(j);
                    if (!r.visible) continue;
                    app.systemNoUi = false;
                }
            }
            if (!app.systemNoUi) {
                app.curProcState = 1;
            }
            app.curAdj = app.maxAdj;
            return app.curAdj;
        }
        app.keeping = false;
        app.systemNoUi = false;
        boolean foregroundActivities = false;
        boolean interesting = false;
        if (app == TOP_APP) {
            adj = 0;
            schedGroup = -1;
            app.adjType = "top-activity";
            foregroundActivities = true;
            interesting = true;
            procState = 2;
        } else if (app.instrumentationClass != null) {
            adj = 0;
            schedGroup = -1;
            app.adjType = "instrumentation";
            interesting = true;
            procState = 3;
        } else {
            BroadcastQueue queue = this.isReceivingBroadcast(app);
            if (queue != null) {
                adj = 0;
                schedGroup = queue == this.mFgBroadcastQueue ? -1 : 0;
                app.adjType = "broadcast";
                procState = 8;
            } else if (app.executingServices.size() > 0) {
                adj = 0;
                schedGroup = app.execServicesFg ? -1 : 0;
                app.adjType = "exec-service";
                procState = 7;
            } else {
                schedGroup = 0;
                adj = cachedAdj;
                procState = 13;
                app.cached = true;
                app.empty = true;
                app.adjType = "cch-empty";
            }
        }
        if (!foregroundActivities && activitiesSize > 0) {
            for (int j = 0; j < activitiesSize; ++j) {
                ActivityRecord r = app.activities.get(j);
                if (r.app != app) {
                    Slog.w(TAG, "Wtf, activity " + r + " in proc activity list not using proc " + app + "?!?");
                    continue;
                }
                if (r.visible) {
                    if (adj > 1) {
                        adj = 1;
                        app.adjType = "visible";
                    }
                    if (procState > 2) {
                        procState = 2;
                    }
                    schedGroup = -1;
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    break;
                }
                if (r.state == ActivityStack.ActivityState.PAUSING || r.state == ActivityStack.ActivityState.PAUSED) {
                    if (adj > 2) {
                        adj = 2;
                        app.adjType = "pausing";
                    }
                    if (procState > 2) {
                        procState = 2;
                    }
                    schedGroup = -1;
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    continue;
                }
                if (r.state == ActivityStack.ActivityState.STOPPING) {
                    if (adj > 2) {
                        adj = 2;
                        app.adjType = "stopping";
                    }
                    if (!r.finishing && procState > 11) {
                        procState = 11;
                    }
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    continue;
                }
                if (procState <= 11) continue;
                procState = 11;
                app.adjType = "cch-act";
            }
        }
        if (adj > 2) {
            if (app.foregroundServices) {
                adj = 2;
                procState = 3;
                app.cached = false;
                app.adjType = "fg-service";
                schedGroup = -1;
            } else if (app.forcingToForeground != null) {
                adj = 2;
                procState = 3;
                app.cached = false;
                app.adjType = "force-fg";
                app.adjSource = app.forcingToForeground;
                schedGroup = -1;
            }
        }
        if (app.foregroundServices) {
            interesting = true;
        }
        if (app == this.mHeavyWeightProcess) {
            if (adj > 4) {
                adj = 4;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "heavy";
            }
            if (procState > 6) {
                procState = 6;
            }
        }
        if (app == this.mHomeProcess) {
            if (adj > 6) {
                adj = 6;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "home";
            }
            if (procState > 9) {
                procState = 9;
            }
        }
        if (app == this.mPreviousProcess && app.activities.size() > 0) {
            if (adj > 7) {
                adj = 7;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "previous";
            }
            if (procState > 10) {
                procState = 10;
            }
        }
        app.adjSeq = this.mAdjSeq;
        app.curRawAdj = adj;
        app.hasStartedServices = false;
        if (this.mBackupTarget != null && app == this.mBackupTarget.app) {
            if (adj > 3) {
                adj = 3;
                if (procState > 4) {
                    procState = 4;
                }
                app.adjType = "backup";
                app.cached = false;
            }
            if (procState > 5) {
                procState = 5;
            }
        }
        boolean mayBeTop = false;
        for (int is = app.services.size() - 1; is >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --is) {
            ServiceRecord s = app.services.valueAt(is);
            if (s.startRequested) {
                app.hasStartedServices = true;
                if (procState > 7) {
                    procState = 7;
                }
                if (app.hasShownUi && app != this.mHomeProcess) {
                    if (adj > 5) {
                        app.adjType = "cch-started-ui-services";
                    }
                } else {
                    if (now < s.lastActivity + 1800000L && adj > 5) {
                        adj = 5;
                        app.adjType = "started-services";
                        app.cached = false;
                    }
                    if (adj > 5) {
                        app.adjType = "cch-started-services";
                    }
                }
                app.keeping = true;
            }
            for (int conni = s.connections.size() - 1; conni >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --conni) {
                ArrayList<ConnectionRecord> clist = s.connections.valueAt(conni);
                for (int i2 = 0; i2 < clist.size() && (adj > 0 || schedGroup == 0 || procState > 2); ++i2) {
                    ConnectionRecord cr = clist.get(i2);
                    if (cr.binding.client == app) continue;
                    if ((cr.flags & 0x20) == 0) {
                        ProcessRecord client = cr.binding.client;
                        int clientAdj = this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now);
                        int clientProcState = client.curProcState;
                        if (clientProcState >= 11) {
                            clientProcState = 13;
                        }
                        String adjType = null;
                        if ((cr.flags & 0x10) != 0) {
                            if (app.hasShownUi && app != this.mHomeProcess) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-ui-services";
                                }
                                app.cached = false;
                                clientAdj = adj;
                                clientProcState = procState;
                            } else if (now >= s.lastActivity + 1800000L) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-services";
                                }
                                clientAdj = adj;
                            }
                        }
                        if (adj > clientAdj) {
                            if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 2) {
                                adjType = "cch-bound-ui-services";
                            } else {
                                if ((cr.flags & 0x48) != 0) {
                                    adj = clientAdj;
                                } else if ((cr.flags & 0x40000000) != 0 && clientAdj < 2 && adj > 2) {
                                    adj = 2;
                                } else if (clientAdj > 1) {
                                    adj = clientAdj;
                                } else if (adj > 1) {
                                    adj = 1;
                                }
                                if (!client.cached) {
                                    app.cached = false;
                                }
                                if (client.keeping) {
                                    app.keeping = true;
                                }
                                adjType = "service";
                            }
                        }
                        if ((cr.flags & 4) == 0) {
                            if (client.curSchedGroup == -1) {
                                schedGroup = -1;
                            }
                            if (clientProcState <= 2) {
                                if (clientProcState == 2) {
                                    mayBeTop = true;
                                    clientProcState = 13;
                                } else {
                                    clientProcState = 3;
                                }
                            }
                        } else if (clientProcState < 4) {
                            clientProcState = 4;
                        }
                        if (procState > clientProcState) {
                            procState = clientProcState;
                        }
                        if (procState < 4 && (cr.flags & 0x20000000) != 0) {
                            app.pendingUiClean = true;
                        }
                        if (adjType != null) {
                            app.adjType = adjType;
                            app.adjTypeCode = 2;
                            app.adjSource = cr.binding.client;
                            app.adjSourceOom = clientAdj;
                            app.adjTarget = s.name;
                        }
                    }
                    ActivityRecord a = cr.activity;
                    if ((cr.flags & 0x80) == 0 || a == null || adj <= 0 || !a.visible && a.state != ActivityStack.ActivityState.RESUMED && a.state != ActivityStack.ActivityState.PAUSING) continue;
                    adj = 0;
                    if ((cr.flags & 4) == 0) {
                        schedGroup = -1;
                    }
                    app.cached = false;
                    app.adjType = "service";
                    app.adjTypeCode = 2;
                    app.adjSource = a;
                    app.adjSourceOom = adj;
                    app.adjTarget = s.name;
                }
            }
        }
        for (int provi = app.pubProviders.size() - 1; provi >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --provi) {
            ContentProviderRecord cpr = app.pubProviders.valueAt(provi);
            for (i = cpr.connections.size() - 1; i >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --i) {
                ContentProviderConnection conn = cpr.connections.get(i);
                ProcessRecord client = conn.client;
                if (client == app) continue;
                int clientAdj = this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now);
                int clientProcState = client.curProcState;
                if (clientProcState >= 11) {
                    clientProcState = 13;
                }
                if (adj > clientAdj) {
                    if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 2) {
                        app.adjType = "cch-ui-provider";
                    } else {
                        adj = clientAdj > 0 ? clientAdj : 0;
                        app.adjType = "provider";
                    }
                    app.cached &= client.cached;
                    app.keeping |= client.keeping;
                    app.adjTypeCode = 1;
                    app.adjSource = client;
                    app.adjSourceOom = clientAdj;
                    app.adjTarget = cpr.name;
                }
                if (clientProcState <= 2) {
                    if (clientProcState == 2) {
                        mayBeTop = true;
                        clientProcState = 13;
                    } else {
                        clientProcState = 3;
                    }
                }
                if (procState > clientProcState) {
                    procState = clientProcState;
                }
                if (client.curSchedGroup != -1) continue;
                schedGroup = -1;
            }
            if (!cpr.hasExternalProcessHandles()) continue;
            if (adj > 0) {
                adj = 0;
                schedGroup = -1;
                app.cached = false;
                app.keeping = true;
                app.adjType = "provider";
                app.adjTarget = cpr.name;
            }
            if (procState <= 3) continue;
            procState = 3;
        }
        if (mayBeTop && procState > 2) {
            switch (procState) {
                case 3: 
                case 4: 
                case 7: {
                    procState = 3;
                    break;
                }
                default: {
                    procState = 2;
                }
            }
        }
        if (procState >= 13 && app.hasClientActivities) {
            procState = 12;
            app.adjType = "cch-client-act";
        }
        if (adj == 5) {
            if (doingAll) {
                app.serviceb = this.mNewNumAServiceProcs > this.mNumServiceProcs / 3;
                ++this.mNewNumServiceProcs;
                if (!app.serviceb) {
                    if (this.mLastMemoryLevel > 0 && app.lastPss >= this.mProcessList.getCachedRestoreThresholdKb()) {
                        app.serviceHighRam = true;
                        app.serviceb = true;
                    } else {
                        ++this.mNewNumAServiceProcs;
                    }
                } else {
                    app.serviceHighRam = false;
                }
            }
            if (app.serviceb) {
                adj = 8;
            }
        }
        app.curRawAdj = adj;
        if (adj > app.maxAdj) {
            adj = app.maxAdj;
            if (app.maxAdj <= 2) {
                schedGroup = -1;
            }
        }
        if (adj < 9) {
            app.keeping = true;
        }
        adj = app.modifyRawOomAdj(adj);
        app.curProcState = procState;
        int importance = app.memImportance;
        if (importance == 0 || adj != app.curAdj || schedGroup != app.curSchedGroup) {
            app.curAdj = adj;
            app.curSchedGroup = schedGroup;
            importance = !interesting ? 400 : (adj >= 9 ? 400 : (adj >= 8 ? 300 : (adj >= 6 ? 400 : (adj >= 5 ? 300 : (adj >= 4 ? 170 : (adj >= 2 ? 130 : (adj >= 1 ? 200 : (adj >= 0 ? 100 : 50))))))));
        }
        int n = changes = importance != app.memImportance ? 2 : 0;
        if (foregroundActivities != app.foregroundActivities) {
            changes |= 1;
        }
        if (changes != 0) {
            app.memImportance = importance;
            app.foregroundActivities = foregroundActivities;
            ProcessChangeItem item = null;
            for (i = this.mPendingProcessChanges.size() - 1; i >= 0; --i) {
                item = this.mPendingProcessChanges.get(i);
                if (item.pid == app.pid) break;
            }
            if (i < 0) {
                int NA = this.mAvailProcessChanges.size();
                item = NA > 0 ? this.mAvailProcessChanges.remove(NA - 1) : new ProcessChangeItem();
                item.changes = 0;
                item.pid = app.pid;
                item.uid = app.info.uid;
                if (this.mPendingProcessChanges.size() == 0) {
                    this.mHandler.obtainMessage(31).sendToTarget();
                }
                this.mPendingProcessChanges.add(item);
            }
            item.changes |= changes;
            item.importance = importance;
            item.foregroundActivities = foregroundActivities;
        }
        return app.curRawAdj;
    }

    void requestPssLocked(ProcessRecord proc, int procState) {
        if (this.mPendingPssProcesses.contains(proc)) {
            return;
        }
        if (this.mPendingPssProcesses.size() == 0) {
            this.mBgHandler.sendEmptyMessage(1);
        }
        proc.pssProcState = procState;
        this.mPendingPssProcesses.add(proc);
    }

    void requestPssAllProcsLocked(long now, boolean always, boolean memLowered) {
        if (!always && now < this.mLastFullPssTime + (long)(memLowered ? 120000 : 600000)) {
            return;
        }
        this.mLastFullPssTime = now;
        this.mPendingPssProcesses.ensureCapacity(this.mLruProcesses.size());
        this.mPendingPssProcesses.clear();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            if (!memLowered && now <= app.lastStateTime + 600000L) continue;
            app.pssProcState = app.setProcState;
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, true, this.mSleeping, now);
            this.mPendingPssProcesses.add(app);
        }
        this.mBgHandler.sendEmptyMessage(1);
    }

    final void performAppGcLocked(ProcessRecord app) {
        try {
            app.lastRequestedGc = SystemClock.uptimeMillis();
            if (app.thread != null) {
                if (app.reportLowMemory) {
                    app.reportLowMemory = false;
                    app.thread.scheduleLowMemory();
                } else {
                    app.thread.processInBackground();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean canGcNowLocked() {
        boolean processingBroadcasts = false;
        for (BroadcastQueue q : this.mBroadcastQueues) {
            if (q.mParallelBroadcasts.size() == 0 && q.mOrderedBroadcasts.size() == 0) continue;
            processingBroadcasts = true;
        }
        return !processingBroadcasts && (this.mSleeping || this.mStackSupervisor.allResumedActivitiesIdle());
    }

    final void performAppGcsLocked() {
        int N = this.mProcessesToGc.size();
        if (N <= 0) {
            return;
        }
        if (this.canGcNowLocked()) {
            while (this.mProcessesToGc.size() > 0) {
                ProcessRecord proc = this.mProcessesToGc.remove(0);
                if (proc.curRawAdj <= 2 && !proc.reportLowMemory) continue;
                if (proc.lastRequestedGc + 60000L <= SystemClock.uptimeMillis()) {
                    this.performAppGcLocked(proc);
                    this.scheduleAppGcsLocked();
                    return;
                }
                this.addProcessToGcListLocked(proc);
                break;
            }
            this.scheduleAppGcsLocked();
        }
    }

    final void performAppGcsIfAppropriateLocked() {
        if (this.canGcNowLocked()) {
            this.performAppGcsLocked();
            return;
        }
        this.scheduleAppGcsLocked();
    }

    final void scheduleAppGcsLocked() {
        this.mHandler.removeMessages(5);
        if (this.mProcessesToGc.size() > 0) {
            ProcessRecord proc = this.mProcessesToGc.get(0);
            Message msg = this.mHandler.obtainMessage(5);
            long when = proc.lastRequestedGc + 60000L;
            long now = SystemClock.uptimeMillis();
            if (when < now + 5000L) {
                when = now + 5000L;
            }
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    final void addProcessToGcListLocked(ProcessRecord proc) {
        boolean added = false;
        for (int i = this.mProcessesToGc.size() - 1; i >= 0; --i) {
            if (this.mProcessesToGc.get((int)i).lastRequestedGc >= proc.lastRequestedGc) continue;
            added = true;
            this.mProcessesToGc.add(i + 1, proc);
            break;
        }
        if (!added) {
            this.mProcessesToGc.add(0, proc);
        }
    }

    final void scheduleAppGcLocked(ProcessRecord app) {
        long now = SystemClock.uptimeMillis();
        if (app.lastRequestedGc + 60000L > now) {
            return;
        }
        if (!this.mProcessesToGc.contains(app)) {
            this.addProcessToGcListLocked(app);
            this.scheduleAppGcsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkExcessivePowerUsageLocked(boolean doKills) {
        this.updateCpuStatsNow();
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        boolean doWakeKills = doKills;
        boolean doCpuKills = doKills;
        if (this.mLastPowerCheckRealtime == 0L) {
            doWakeKills = false;
        }
        if (this.mLastPowerCheckUptime == 0L) {
            doCpuKills = false;
        }
        if (stats.isScreenOn()) {
            doWakeKills = false;
        }
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - this.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - this.mLastPowerCheckUptime;
        this.mLastPowerCheckRealtime = curRealtime;
        this.mLastPowerCheckUptime = curUptime;
        if (realtimeSince < 300000L) {
            doWakeKills = false;
        }
        if (uptimeSince < 300000L) {
            doCpuKills = false;
        }
        int i = this.mLruProcesses.size();
        while (i > 0) {
            BatteryStatsImpl batteryStatsImpl;
            long wtime;
            ProcessRecord app = this.mLruProcesses.get(--i);
            if (app.keeping) continue;
            BatteryStatsImpl batteryStatsImpl2 = stats;
            synchronized (batteryStatsImpl2) {
                wtime = stats.getProcessWakeTime(app.info.uid, app.pid, curRealtime);
            }
            long wtimeUsed = wtime - app.lastWakeTime;
            long cputimeUsed = app.curCpuTime - app.lastCpuTime;
            if (doWakeKills && realtimeSince > 0L && wtimeUsed * 100L / realtimeSince >= 50L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveWakeLocked(app.info.uid, app.processName, realtimeSince, wtimeUsed);
                }
                this.killUnneededProcessLocked(app, "excessive wake held " + wtimeUsed + " during " + realtimeSince);
                app.baseProcessTracker.reportExcessiveWake(app.pkgList);
                continue;
            }
            if (doCpuKills && uptimeSince > 0L && cputimeUsed * 100L / uptimeSince >= 50L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveCpuLocked(app.info.uid, app.processName, uptimeSince, cputimeUsed);
                }
                this.killUnneededProcessLocked(app, "excessive cpu " + cputimeUsed + " during " + uptimeSince);
                app.baseProcessTracker.reportExcessiveCpu(app.pkgList);
                continue;
            }
            app.lastWakeTime = wtime;
            app.lastCpuTime = app.curCpuTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean applyOomAdjLocked(ProcessRecord app, boolean wasKeeping, ProcessRecord TOP_APP, boolean doingAll, boolean reportingProcessState, long now) {
        boolean success = true;
        if (app.curRawAdj != app.setRawAdj) {
            if (wasKeeping && !app.keeping) {
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    app.lastWakeTime = stats.getProcessWakeTime(app.info.uid, app.pid, SystemClock.elapsedRealtime());
                }
                app.lastCpuTime = app.curCpuTime;
            }
            app.setRawAdj = app.curRawAdj;
        }
        if (app.curAdj != app.setAdj) {
            if (Process.setOomAdj(app.pid, app.curAdj)) {
                app.setAdj = app.curAdj;
            } else {
                success = false;
                Slog.w(TAG, "Failed setting oom adj of " + app + " to " + app.curAdj);
            }
        }
        if (app.setSchedGroup != app.curSchedGroup) {
            app.setSchedGroup = app.curSchedGroup;
            if (app.waitingToKill != null && app.setSchedGroup == 0) {
                this.killUnneededProcessLocked(app, app.waitingToKill);
                success = false;
            } else {
                block23: {
                    long oldId = Binder.clearCallingIdentity();
                    try {
                        try {
                            Process.setProcessGroup(app.pid, app.curSchedGroup);
                        }
                        catch (Exception e) {
                            Slog.w(TAG, "Failed setting process group of " + app.pid + " to " + app.curSchedGroup);
                            e.printStackTrace();
                            Object var13_13 = null;
                            Binder.restoreCallingIdentity(oldId);
                            break block23;
                        }
                        Object var13_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        Binder.restoreCallingIdentity(oldId);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity(oldId);
                }
                Process.setSwappiness(app.pid, app.curSchedGroup <= 0);
            }
        }
        if (app.repProcState != app.curProcState) {
            app.repProcState = app.curProcState;
            if (!reportingProcessState && app.thread != null) {
                try {
                    app.thread.setProcessState(app.repProcState);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        if (app.setProcState < 0 || ProcessList.procStatesDifferForMem(app.curProcState, app.setProcState)) {
            app.lastStateTime = now;
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, true, this.mSleeping, now);
        } else if (now > app.nextPssTime || now > app.lastPssTime + 1800000L && now > app.lastStateTime + 15000L) {
            this.requestPssLocked(app, app.setProcState);
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, false, this.mSleeping, now);
        }
        if (app.setProcState == app.curProcState) return success;
        app.setProcState = app.curProcState;
        if (app.setProcState >= 9) {
            app.notCachedSinceIdle = false;
        }
        if (!doingAll) {
            this.setProcessTrackerState(app, this.mProcessStats.getMemFactorLocked(), now);
            return success;
        }
        app.procStateChanged = true;
        return success;
    }

    private final void setProcessTrackerState(ProcessRecord proc, int memFactor, long now) {
        if (proc.thread != null && proc.baseProcessTracker != null) {
            proc.baseProcessTracker.setState(proc.repProcState, memFactor, now, proc.pkgList);
        }
    }

    private final boolean updateOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, boolean reportingProcessState, long now) {
        if (app.thread == null) {
            return false;
        }
        boolean wasKeeping = app.keeping;
        this.computeOomAdjLocked(app, cachedAdj, TOP_APP, doingAll, now);
        return this.applyOomAdjLocked(app, wasKeeping, TOP_APP, doingAll, reportingProcessState, now);
    }

    private final ActivityRecord resumedAppLocked() {
        return this.mStackSupervisor.resumedAppLocked();
    }

    final boolean updateOomAdjLocked(ProcessRecord app) {
        return this.updateOomAdjLocked(app, false);
    }

    final boolean updateOomAdjLocked(ProcessRecord app, boolean doingProcessState) {
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        boolean wasCached = app.cached;
        ++this.mAdjSeq;
        int cachedAdj = app.curRawAdj >= 9 ? app.curRawAdj : 16;
        boolean success = this.updateOomAdjLocked(app, cachedAdj, TOP_APP, false, doingProcessState, SystemClock.uptimeMillis());
        if (wasCached != app.cached || app.curRawAdj == 16) {
            this.updateOomAdjLocked();
        }
        return success;
    }

    final void updateOomAdjLocked() {
        int cachedFactor;
        int emptyFactor;
        int emptyProcessLimit;
        int cachedProcessLimit;
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        long now = SystemClock.uptimeMillis();
        long oldTime = now - 1800000L;
        int N = this.mLruProcesses.size();
        ++this.mAdjSeq;
        this.mNewNumServiceProcs = 0;
        this.mNewNumAServiceProcs = 0;
        if (this.mProcessLimit <= 0) {
            cachedProcessLimit = 0;
            emptyProcessLimit = 0;
        } else if (this.mProcessLimit == 1) {
            emptyProcessLimit = 1;
            cachedProcessLimit = 0;
        } else {
            emptyProcessLimit = ProcessList.computeEmptyProcessLimit(this.mProcessLimit);
            cachedProcessLimit = this.mProcessLimit - emptyProcessLimit;
        }
        int numSlots = 3;
        int numEmptyProcs = N - this.mNumNonCachedProcs - this.mNumCachedHiddenProcs;
        if (numEmptyProcs > cachedProcessLimit) {
            numEmptyProcs = cachedProcessLimit;
        }
        if ((emptyFactor = numEmptyProcs / numSlots) < 1) {
            emptyFactor = 1;
        }
        if ((cachedFactor = (this.mNumCachedHiddenProcs > 0 ? this.mNumCachedHiddenProcs : 1) / numSlots) < 1) {
            cachedFactor = 1;
        }
        int stepCached = 0;
        int stepEmpty = 0;
        int numCached = 0;
        int numEmpty = 0;
        int numTrimming = 0;
        this.mNumNonCachedProcs = 0;
        this.mNumCachedHiddenProcs = 0;
        int curCachedAdj = 9;
        int nextCachedAdj = curCachedAdj + 1;
        int curEmptyAdj = 9;
        int nextEmptyAdj = curEmptyAdj + 2;
        for (int i = N - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            if (app.killedByAm || app.thread == null) continue;
            app.procStateChanged = false;
            boolean wasKeeping = app.keeping;
            this.computeOomAdjLocked(app, 16, TOP_APP, true, now);
            if (app.curAdj >= 16) {
                switch (app.curProcState) {
                    case 11: 
                    case 12: {
                        app.curRawAdj = curCachedAdj;
                        app.curAdj = app.modifyRawOomAdj(curCachedAdj);
                        if (curCachedAdj == nextCachedAdj || ++stepCached < cachedFactor) break;
                        stepCached = 0;
                        curCachedAdj = nextCachedAdj;
                        if ((nextCachedAdj += 2) <= 15) break;
                        nextCachedAdj = 15;
                        break;
                    }
                    default: {
                        app.curRawAdj = curEmptyAdj;
                        app.curAdj = app.modifyRawOomAdj(curEmptyAdj);
                        if (curEmptyAdj == nextEmptyAdj || ++stepEmpty < emptyFactor) break;
                        stepEmpty = 0;
                        curEmptyAdj = nextEmptyAdj;
                        if ((nextEmptyAdj += 2) <= 15) break;
                        nextEmptyAdj = 15;
                    }
                }
            }
            this.applyOomAdjLocked(app, wasKeeping, TOP_APP, true, false, now);
            switch (app.curProcState) {
                case 11: 
                case 12: {
                    ++this.mNumCachedHiddenProcs;
                    if (++numCached <= cachedProcessLimit) break;
                    this.killUnneededProcessLocked(app, "cached #" + numCached);
                    break;
                }
                case 13: {
                    if (numEmpty > ProcessList.TRIM_EMPTY_APPS && app.lastActivityTime < oldTime) {
                        this.killUnneededProcessLocked(app, "empty for " + (oldTime + 1800000L - app.lastActivityTime) / 1000L + "s");
                        break;
                    }
                    if (++numEmpty <= emptyProcessLimit) break;
                    this.killUnneededProcessLocked(app, "empty #" + numEmpty);
                    break;
                }
                default: {
                    ++this.mNumNonCachedProcs;
                }
            }
            if (app.isolated && app.services.size() <= 0) {
                this.killUnneededProcessLocked(app, "isolated not needed");
            }
            if (app.curProcState < 9 || app.killedByAm) continue;
            ++numTrimming;
        }
        this.mNumServiceProcs = this.mNewNumServiceProcs;
        int numCachedAndEmpty = numCached + numEmpty;
        int memFactor = numCached <= ProcessList.TRIM_CACHED_APPS && numEmpty <= ProcessList.TRIM_EMPTY_APPS ? (numCachedAndEmpty <= 3 ? 3 : (numCachedAndEmpty <= 5 ? 2 : 1)) : 0;
        if (!(memFactor <= this.mLastMemoryLevel || this.mAllowLowerMemLevel && this.mLruProcesses.size() < this.mLastNumProcesses)) {
            memFactor = this.mLastMemoryLevel;
        }
        this.mLastMemoryLevel = memFactor;
        this.mLastNumProcesses = this.mLruProcesses.size();
        boolean allChanged = this.mProcessStats.setMemFactorLocked(memFactor, !this.mSleeping, now);
        int trackerMemFactor = this.mProcessStats.getMemFactorLocked();
        if (memFactor != 0) {
            int fgTrimLevel;
            if (this.mLowRamStartTime == 0L) {
                this.mLowRamStartTime = now;
            }
            int step = 0;
            switch (memFactor) {
                case 3: {
                    fgTrimLevel = 15;
                    break;
                }
                case 2: {
                    fgTrimLevel = 10;
                    break;
                }
                default: {
                    fgTrimLevel = 5;
                }
            }
            int factor = numTrimming / 3;
            int minFactor = 2;
            if (this.mHomeProcess != null) {
                ++minFactor;
            }
            if (this.mPreviousProcess != null) {
                ++minFactor;
            }
            if (factor < minFactor) {
                factor = minFactor;
            }
            int curLevel = 80;
            for (int i = N - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerState(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if (app.curProcState >= 9 && !app.killedByAm) {
                    if (app.trimMemoryLevel < curLevel && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(curLevel);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = curLevel;
                    if (++step < factor) continue;
                    step = 0;
                    switch (curLevel) {
                        case 80: {
                            curLevel = 60;
                            break;
                        }
                        case 60: {
                            curLevel = 40;
                        }
                    }
                    continue;
                }
                if (app.curProcState == 6) {
                    if (app.trimMemoryLevel < 40 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(40);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = 40;
                    continue;
                }
                if ((app.curProcState >= 4 || app.systemNoUi) && app.pendingUiClean) {
                    int level = 20;
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.pendingUiClean = false;
                }
                if (app.trimMemoryLevel < fgTrimLevel && app.thread != null) {
                    try {
                        app.thread.scheduleTrimMemory(fgTrimLevel);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                app.trimMemoryLevel = fgTrimLevel;
            }
        } else {
            if (this.mLowRamStartTime != 0L) {
                this.mLowRamTimeSinceLastIdle += now - this.mLowRamStartTime;
                this.mLowRamStartTime = 0L;
            }
            for (int i = N - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerState(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if ((app.curProcState >= 4 || app.systemNoUi) && app.pendingUiClean) {
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.pendingUiClean = false;
                }
                app.trimMemoryLevel = 0;
            }
        }
        if (this.mAlwaysFinishActivities) {
            this.mStackSupervisor.scheduleDestroyAllActivities(null, "always-finish");
        }
        if (allChanged) {
            this.requestPssAllProcsLocked(now, false, this.mProcessStats.isMemFactorLowered());
        }
        if (this.mProcessStats.shouldWriteNowLocked(now)) {
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ActivityManagerService.this.mProcessStats.writeStateAsyncLocked();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trimApplications() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mRemovedProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mRemovedProcesses.get(i);
                if (app.activities.size() != 0 || app.curReceiver != null || app.services.size() != 0) continue;
                Slog.i(TAG, "Exiting empty application process " + app.processName + " (" + (app.thread != null ? app.thread.asBinder() : null) + ")\n");
                if (app.pid > 0 && app.pid != MY_PID) {
                    EventLog.writeEvent(30023, app.userId, app.pid, app.processName, app.setAdj, "empty");
                    app.killedByAm = true;
                    Process.killProcessQuiet(app.pid);
                } else {
                    try {
                        app.thread.scheduleExit();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.cleanUpApplicationRecordLocked(app, false, true, -1);
                this.mRemovedProcesses.remove(i);
                if (!app.persistent || !app.persistent) continue;
                this.addAppLocked(app.info, false);
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalPersistentProcesses(int sig) throws RemoteException {
        if (sig != 10) {
            throw new SecurityException("Only SIGNAL_USR1 is allowed");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.SIGNAL_PERSISTENT_PROCESSES") != 0) {
                throw new SecurityException("Requires permission android.permission.SIGNAL_PERSISTENT_PROCESSES");
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord r = this.mLruProcesses.get(i);
                if (r.thread == null || !r.persistent) continue;
                Process.sendSignal(r.pid, sig);
            }
        }
    }

    private void stopProfilerLocked(ProcessRecord proc, String path, int profileType) {
        if (proc == null || proc == this.mProfileProc) {
            proc = this.mProfileProc;
            path = this.mProfileFile;
            profileType = this.mProfileType;
            this.clearProfilerLocked();
        }
        if (proc == null) {
            return;
        }
        try {
            proc.thread.profilerControl(false, path, null, profileType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Process disappeared");
        }
    }

    private void clearProfilerLocked() {
        if (this.mProfileFd != null) {
            try {
                this.mProfileFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mProfileApp = null;
        this.mProfileProc = null;
        this.mProfileFile = null;
        this.mProfileType = 0;
        this.mAutoStopProfiler = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean profileControl(String process, int userId, boolean start, String path, ParcelFileDescriptor fd, int profileType) throws RemoteException {
        try {
            try {
                boolean bl;
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (start && fd == null) {
                        throw new IllegalArgumentException("null fd");
                    }
                    ProcessRecord proc = null;
                    if (process != null) {
                        proc = this.findProcessLocked(process, userId, "profileControl");
                    }
                    if (start) {
                        if (proc == null) throw new IllegalArgumentException("Unknown process: " + process);
                        if (proc.thread == null) {
                            throw new IllegalArgumentException("Unknown process: " + process);
                        }
                    }
                    if (start) {
                        this.stopProfilerLocked(null, null, 0);
                        this.setProfileApp(proc.info, proc.processName, path, fd, false);
                        this.mProfileProc = proc;
                        this.mProfileType = profileType;
                        try {
                            fd = fd.dup();
                        }
                        catch (IOException e) {
                            fd = null;
                        }
                        proc.thread.profilerControl(start, path, fd, profileType);
                        fd = null;
                        this.mProfileFd = null;
                    } else {
                        this.stopProfilerLocked(proc, path, profileType);
                        if (fd != null) {
                            try {
                                fd.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    bl = true;
                }
                Object var12_14 = null;
                if (fd == null) return bl;
                try {
                    fd.close();
                    return bl;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return bl;
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Process disappeared");
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (fd == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            fd.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findProcessLocked(String process, int userId, String callName) {
        ArrayMap<String, SparseArray<ProcessRecord>> all;
        SparseArray<ProcessRecord> procs;
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, true, callName, null);
        ProcessRecord proc = null;
        try {
            int pid = Integer.parseInt(process);
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(pid);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (proc == null && (procs = (all = this.mProcessNames.getMap()).get(process)) != null && procs.size() > 0) {
            proc = procs.valueAt(0);
            if (userId != -1 && proc.userId != userId) {
                for (int i = 1; i < procs.size(); ++i) {
                    ProcessRecord thisProc = procs.valueAt(i);
                    if (thisProc.userId != userId) continue;
                    proc = thisProc;
                    break;
                }
            }
        }
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dumpHeap(String process, int userId, boolean managed, String path, ParcelFileDescriptor fd) throws RemoteException {
        try {
            try {
                boolean bl;
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (fd == null) {
                        throw new IllegalArgumentException("null fd");
                    }
                    ProcessRecord proc = this.findProcessLocked(process, userId, "dumpHeap");
                    if (proc == null) throw new IllegalArgumentException("Unknown process: " + process);
                    if (proc.thread == null) {
                        throw new IllegalArgumentException("Unknown process: " + process);
                    }
                    boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
                    if (!isDebuggable && (proc.info.flags & 2) == 0) {
                        throw new SecurityException("Process not debuggable: " + proc);
                    }
                    proc.thread.dumpHeap(managed, path, fd);
                    fd = null;
                    bl = true;
                }
                Object var12_11 = null;
                if (fd == null) return bl;
                try {
                    fd.close();
                    return bl;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return bl;
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Process disappeared");
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (fd == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            fd.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
        }
    }

    void onCoreSettingsChange(Bundle settings) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord processRecord = this.mLruProcesses.get(i);
            try {
                if (processRecord.thread == null) continue;
                processRecord.thread.setCoreSettings(settings);
                continue;
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean switchUser(final int userId) {
        long ident;
        block22: {
            boolean bl;
            block21: {
                boolean bl2;
                block20: {
                    if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
                        String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
                        Slog.w(TAG, msg);
                        throw new SecurityException(msg);
                    }
                    ident = Binder.clearCallingIdentity();
                    try {
                        ActivityManagerService activityManagerService = this;
                        synchronized (activityManagerService) {
                            boolean homeInFront;
                            Intent intent;
                            int oldUserId = this.mCurrentUserId;
                            if (oldUserId == userId) {
                                bl2 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 19, 4] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
                                Object var14_8 = null;
                                break block20;
                            }
                            UserInfo userInfo = this.getUserManagerLocked().getUserInfo(userId);
                            if (userInfo == null) {
                                Slog.w(TAG, "No user info for user #" + userId);
                                bl = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 18, 4] lbl22 : MonitorExitStatement: MONITOREXIT : var4_4
                                break block21;
                            }
                            this.mWindowManager.startFreezingScreen(17432653, 17432652);
                            boolean needStart = false;
                            if (this.mStartedUsers.get(userId) == null) {
                                this.mStartedUsers.put(userId, new UserStartedState(new UserHandle(userId), false));
                                this.updateStartedUserArrayLocked();
                                needStart = true;
                            }
                            this.mCurrentUserId = userId;
                            Integer userIdInt = userId;
                            this.mUserLru.remove(userIdInt);
                            this.mUserLru.add(userIdInt);
                            this.mWindowManager.setCurrentUser(userId);
                            this.mWindowManager.lockNow(null);
                            final UserStartedState uss = this.mStartedUsers.get(userId);
                            if (uss.mState == 2) {
                                uss.mState = 1;
                                this.updateStartedUserArrayLocked();
                                needStart = true;
                            } else if (uss.mState == 3) {
                                uss.mState = 0;
                                this.updateStartedUserArrayLocked();
                                needStart = true;
                            }
                            this.mHandler.removeMessages(34);
                            this.mHandler.removeMessages(36);
                            this.mHandler.sendMessage(this.mHandler.obtainMessage(34, oldUserId, userId, uss));
                            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(36, oldUserId, userId, uss), 2000L);
                            if (needStart) {
                                intent = new Intent("android.intent.action.USER_STARTED");
                                intent.addFlags(0x50000000);
                                intent.putExtra("android.intent.extra.user_handle", userId);
                                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, userId);
                            }
                            if ((userInfo.flags & 0x10) == 0) {
                                if (userId != 0) {
                                    intent = new Intent("android.intent.action.USER_INITIALIZE");
                                    intent.addFlags(0x10000000);
                                    this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                                        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                                            ActivityManagerService.this.userInitialized(uss, userId);
                                        }
                                    }, 0, null, null, null, -1, true, false, MY_PID, 1000, userId);
                                    uss.initializing = true;
                                } else {
                                    this.getUserManagerLocked().makeInitialized(userInfo.id);
                                }
                            }
                            if (homeInFront = this.mStackSupervisor.switchUserLocked(userId, uss)) {
                                this.startHomeActivityLocked(userId);
                            } else {
                                this.mStackSupervisor.resumeTopActivitiesLocked();
                            }
                            EventLogTags.writeAmSwitchUser(userId);
                            this.getUserManagerLocked().userForeground(userId);
                            this.sendUserSwitchBroadcastsLocked(oldUserId, userId);
                            if (needStart) {
                                Intent intent2 = new Intent("android.intent.action.USER_STARTING");
                                intent2.addFlags(0x40000000);
                                intent2.putExtra("android.intent.extra.user_handle", userId);
                                this.broadcastIntentLocked(null, null, intent2, null, new IIntentReceiver.Stub(){

                                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                                    }
                                }, 0, null, null, "android.permission.INTERACT_ACROSS_USERS", -1, true, false, MY_PID, 1000, -1);
                            }
                        }
                        break block22;
                    }
                    catch (Throwable throwable) {
                        Object var14_11 = null;
                        Binder.restoreCallingIdentity(ident);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity(ident);
                return bl2;
            }
            Object var14_9 = null;
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        Object var14_10 = null;
        Binder.restoreCallingIdentity(ident);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUserSwitchBroadcastsLocked(int oldUserId, int newUserId) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent;
            if (oldUserId >= 0) {
                intent = new Intent("android.intent.action.USER_BACKGROUND");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", oldUserId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, oldUserId);
            }
            if (newUserId >= 0) {
                intent = new Intent("android.intent.action.USER_FOREGROUND");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", newUserId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, false, false, MY_PID, 1000, newUserId);
                intent = new Intent("android.intent.action.USER_SWITCHED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", newUserId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, "android.permission.MANAGE_USERS", -1, false, false, MY_PID, 1000, -1);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchUserSwitch(final UserStartedState uss, final int oldUserId, final int newUserId) {
        final int N = this.mUserSwitchObservers.beginBroadcast();
        if (N > 0) {
            IRemoteCallback.Stub callback = new IRemoteCallback.Stub(){
                int mCount = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void sendResult(Bundle data) throws RemoteException {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        if (ActivityManagerService.this.mCurUserSwitchCallback == this) {
                            ++this.mCount;
                            if (this.mCount == N) {
                                ActivityManagerService.this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
                            }
                        }
                    }
                }
            };
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                uss.switching = true;
                this.mCurUserSwitchCallback = callback;
            }
            for (int i = 0; i < N; ++i) {
                try {
                    this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitching(newUserId, callback);
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        } else {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeoutUserSwitch(UserStartedState uss, int oldUserId, int newUserId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Slog.w(TAG, "User switch timeout: from " + oldUserId + " to " + newUserId);
            this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
        }
    }

    void sendContinueUserSwitchLocked(UserStartedState uss, int oldUserId, int newUserId) {
        this.mCurUserSwitchCallback = null;
        this.mHandler.removeMessages(36);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(35, oldUserId, newUserId, uss));
    }

    void userInitialized(UserStartedState uss, int newUserId) {
        this.completeSwitchAndInitalize(uss, newUserId, true, false);
    }

    void continueUserSwitch(UserStartedState uss, int oldUserId, int newUserId) {
        this.completeSwitchAndInitalize(uss, newUserId, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeSwitchAndInitalize(UserStartedState uss, int newUserId, boolean clearInitializing, boolean clearSwitching) {
        boolean unfrozen = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (clearInitializing) {
                uss.initializing = false;
                this.getUserManagerLocked().makeInitialized(uss.mHandle.getIdentifier());
            }
            if (clearSwitching) {
                uss.switching = false;
            }
            if (!uss.switching && !uss.initializing) {
                this.mWindowManager.stopFreezingScreen();
                unfrozen = true;
            }
        }
        if (unfrozen) {
            int N = this.mUserSwitchObservers.beginBroadcast();
            for (int i = 0; i < N; ++i) {
                try {
                    this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitchComplete(newUserId);
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mUserSwitchObservers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserSwitch(UserStartedState uss) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (uss.mState == 0 && this.mStartedUsers.get(uss.mHandle.getIdentifier()) == uss) {
                uss.mState = 1;
                int userId = uss.mHandle.getIdentifier();
                Intent intent = new Intent("android.intent.action.BOOT_COMPLETED", null);
                intent.putExtra("android.intent.extra.user_handle", userId);
                intent.addFlags(0x8000000);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, "android.permission.RECEIVE_BOOT_COMPLETED", -1, true, false, MY_PID, 1000, userId);
            }
            int num = this.mUserLru.size();
            int i = 0;
            while (num > 3 && i < this.mUserLru.size()) {
                Integer oldUserId = this.mUserLru.get(i);
                UserStartedState oldUss = this.mStartedUsers.get(oldUserId);
                if (oldUss == null) {
                    this.mUserLru.remove(i);
                    --num;
                    continue;
                }
                if (oldUss.mState == 2 || oldUss.mState == 3) {
                    --num;
                    ++i;
                    continue;
                }
                if (oldUserId == 0 || oldUserId == this.mCurrentUserId) {
                    ++i;
                    continue;
                }
                this.stopUserLocked(oldUserId, null);
                --num;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopUser(int userId, IStopUserCallback callback) {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        if (userId <= 0) {
            throw new IllegalArgumentException("Can't stop primary user " + userId);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.stopUserLocked(userId, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopUserLocked(final int userId, final IStopUserCallback callback) {
        if (this.mCurrentUserId == userId) {
            return -2;
        }
        final UserStartedState uss = this.mStartedUsers.get(userId);
        if (uss == null) {
            if (callback != null) {
                this.mHandler.post(new Runnable(){

                    public void run() {
                        try {
                            callback.userStopped(userId);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            }
            return 0;
        }
        if (callback != null) {
            uss.mStopCallbacks.add(callback);
        }
        if (uss.mState != 2 && uss.mState != 3) {
            uss.mState = 2;
            this.updateStartedUserArrayLocked();
            long ident = Binder.clearCallingIdentity();
            try {
                Intent stoppingIntent = new Intent("android.intent.action.USER_STOPPING");
                stoppingIntent.addFlags(0x40000000);
                stoppingIntent.putExtra("android.intent.extra.user_handle", userId);
                stoppingIntent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
                final Intent shutdownIntent = new Intent("android.intent.action.ACTION_SHUTDOWN");
                final IIntentReceiver.Stub shutdownReceiver = new IIntentReceiver.Stub(){

                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        ActivityManagerService.this.finishUserStop(uss);
                    }
                };
                IIntentReceiver.Stub stoppingReceiver = new IIntentReceiver.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            if (uss.mState != 2) {
                                return;
                            }
                            uss.mState = 3;
                        }
                        ActivityManagerService.this.broadcastIntentLocked(null, null, shutdownIntent, null, shutdownReceiver, 0, null, null, null, -1, true, false, MY_PID, 1000, userId);
                    }
                };
                this.broadcastIntentLocked(null, null, stoppingIntent, null, stoppingReceiver, 0, null, null, "android.permission.INTERACT_ACROSS_USERS", -1, true, false, MY_PID, 1000, -1);
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            {
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStop(UserStartedState uss) {
        boolean stopped;
        ArrayList<IStopUserCallback> callbacks;
        int userId = uss.mHandle.getIdentifier();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            callbacks = new ArrayList<IStopUserCallback>(uss.mStopCallbacks);
            if (this.mStartedUsers.get(userId) != uss) {
                stopped = false;
            } else if (uss.mState != 3) {
                stopped = false;
            } else {
                stopped = true;
                this.mStartedUsers.remove(userId);
                this.mUserLru.remove((Object)userId);
                this.updateStartedUserArrayLocked();
                this.forceStopUserLocked(userId, "finish user");
            }
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                if (stopped) {
                    callbacks.get(i).userStopped(userId);
                    continue;
                }
                callbacks.get(i).userStopAborted(userId);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        this.mStackSupervisor.removeUserLocked(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getCurrentUser() {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0 && this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: getCurrentUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.getUserManagerLocked().getUserInfo(this.mCurrentUserId);
        }
    }

    int getCurrentUserIdLocked() {
        return this.mCurrentUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserRunning(int userId, boolean orStopped) {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.isUserRunningLocked(userId, orStopped);
        }
    }

    boolean isUserRunningLocked(int userId, boolean orStopped) {
        UserStartedState state = this.mStartedUsers.get(userId);
        if (state == null) {
            return false;
        }
        if (orStopped) {
            return true;
        }
        return state.mState != 2 && state.mState != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRunningUserIds() {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mStartedUserArray;
        }
    }

    private void updateStartedUserArrayLocked() {
        UserStartedState uss;
        int i;
        int num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.mState == 2 || uss.mState == 3) continue;
            ++num;
        }
        this.mStartedUserArray = new int[num];
        num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.mState == 2 || uss.mState == 3) continue;
            this.mStartedUserArray[num] = this.mStartedUsers.keyAt(i);
            ++num;
        }
    }

    @Override
    public void registerUserSwitchObserver(IUserSwitchObserver observer) {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: registerUserSwitchObserver() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        this.mUserSwitchObservers.register(observer);
    }

    @Override
    public void unregisterUserSwitchObserver(IUserSwitchObserver observer) {
        this.mUserSwitchObservers.unregister(observer);
    }

    private boolean userExists(int userId) {
        if (userId == 0) {
            return true;
        }
        UserManagerService ums = this.getUserManagerLocked();
        return ums != null ? ums.getUserInfo(userId) != null : false;
    }

    int[] getUsersLocked() {
        int[] nArray;
        UserManagerService ums = this.getUserManagerLocked();
        if (ums != null) {
            nArray = ums.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        return nArray;
    }

    UserManagerService getUserManagerLocked() {
        if (this.mUserManager == null) {
            IBinder b = ServiceManager.getService("user");
            this.mUserManager = (UserManagerService)IUserManager.Stub.asInterface(b);
        }
        return this.mUserManager;
    }

    private int applyUserId(int uid, int userId) {
        return UserHandle.getUid(userId, uid);
    }

    ApplicationInfo getAppInfoForUser(ApplicationInfo info, int userId) {
        if (info == null) {
            return null;
        }
        ApplicationInfo newInfo = new ApplicationInfo(info);
        newInfo.uid = this.applyUserId(info.uid, userId);
        newInfo.dataDir = USER_DATA_DIR + userId + "/" + info.packageName;
        return newInfo;
    }

    ActivityInfo getActivityInfoForUser(ActivityInfo aInfo, int userId) {
        if (aInfo == null || userId < 1 && aInfo.applicationInfo.uid < 100000) {
            return aInfo;
        }
        ActivityInfo info = new ActivityInfo(aInfo);
        info.applicationInfo = this.getAppInfoForUser(info.applicationInfo, userId);
        return info;
    }

    static {
        DUMP_MEM_BUCKETS = new long[]{5120L, 7168L, 10240L, 15360L, 20480L, 30720L, 40960L, 81920L, 122880L, 163840L, 204800L, 256000L, 307200L, 358400L, 409600L, 512000L, 614400L, 819200L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1400000L};
        DUMP_MEM_OOM_ADJ = new int[]{-17, -16, -12, 0, 1, 2, 3, 4, 5, 6, 7, 8, 15};
        DUMP_MEM_OOM_LABEL = new String[]{"Native", "System", "Persistent", "Foreground", "Visible", "Perceptible", "Heavy Weight", "Backup", "A Services", "Home", "Previous", "B Services", "Cached"};
        DUMP_MEM_OOM_COMPACT_LABEL = new String[]{"native", "sys", "pers", "fore", "vis", "percept", "heavy", "backup", "servicea", "home", "prev", "serviceb", "cached"};
    }

    static final class MemItem {
        final boolean isProc;
        final String label;
        final String shortLabel;
        final long pss;
        final int id;
        final boolean hasActivities;
        ArrayList<MemItem> subitems;

        public MemItem(String _label, String _shortLabel, long _pss, int _id, boolean _hasActivities) {
            this.isProc = true;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.id = _id;
            this.hasActivities = _hasActivities;
        }

        public MemItem(String _label, String _shortLabel, long _pss, int _id) {
            this.isProc = false;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.id = _id;
            this.hasActivities = false;
        }
    }

    static class ItemMatcher {
        ArrayList<ComponentName> components;
        ArrayList<String> strings;
        ArrayList<Integer> objects;
        boolean all = true;

        ItemMatcher() {
        }

        void build(String name) {
            ComponentName componentName = ComponentName.unflattenFromString(name);
            if (componentName != null) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                this.components.add(componentName);
                this.all = false;
            } else {
                int objectId = 0;
                try {
                    objectId = Integer.parseInt(name, 16);
                    if (this.objects == null) {
                        this.objects = new ArrayList();
                    }
                    this.objects.add(objectId);
                    this.all = false;
                }
                catch (RuntimeException e) {
                    if (this.strings == null) {
                        this.strings = new ArrayList();
                    }
                    this.strings.add(name);
                    this.all = false;
                }
            }
        }

        int build(String[] args, int opti) {
            while (opti < args.length) {
                String name = args[opti];
                if ("--".equals(name)) {
                    return opti + 1;
                }
                this.build(name);
                ++opti;
            }
            return opti;
        }

        boolean match(Object object, ComponentName comp) {
            int i;
            if (this.all) {
                return true;
            }
            if (this.components != null) {
                for (i = 0; i < this.components.size(); ++i) {
                    if (!this.components.get(i).equals(comp)) continue;
                    return true;
                }
            }
            if (this.objects != null) {
                for (i = 0; i < this.objects.size(); ++i) {
                    if (System.identityHashCode(object) != this.objects.get(i)) continue;
                    return true;
                }
            }
            if (this.strings != null) {
                String flat = comp.flattenToString();
                for (int i2 = 0; i2 < this.strings.size(); ++i2) {
                    if (!flat.contains(this.strings.get(i2))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NeededUriGrants
    extends ArrayList<Uri> {
        final String targetPkg;
        final int targetUid;
        final int flags;

        NeededUriGrants(String targetPkg, int targetUid, int flags) {
            this.targetPkg = targetPkg;
            this.targetUid = targetUid;
            this.flags = flags;
        }
    }

    class IntentFirewallInterface
    implements IntentFirewall.AMSInterface {
        IntentFirewallInterface() {
        }

        public int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
            return ActivityManagerService.this.checkComponentPermission(permission2, pid, uid, owningUid, exported);
        }

        public Object getAMSLock() {
            return ActivityManagerService.this;
        }
    }

    static class PermissionController
    extends IPermissionController.Stub {
        ActivityManagerService mActivityManagerService;

        PermissionController(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        public boolean checkPermission(String permission2, int pid, int uid) {
            return this.mActivityManagerService.checkPermission(permission2, pid, uid) == 0;
        }
    }

    static class CpuBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        CpuBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump cpuinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            Thread thread = this.mActivityManagerService.mProcessCpuThread;
            synchronized (thread) {
                pw.print(this.mActivityManagerService.mProcessCpuTracker.printCurrentLoad());
                pw.print(this.mActivityManagerService.mProcessCpuTracker.printCurrentState(SystemClock.uptimeMillis()));
            }
        }
    }

    static class DbBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        DbBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump dbinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpDbInfo(fd, pw, args);
        }
    }

    static class GraphicsBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        GraphicsBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump gfxinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpGraphicsHardwareUsage(fd, pw, args);
        }
    }

    static class MemBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        MemBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump meminfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpApplicationMemoryUsage(fd, pw, "  ", args, false, null);
        }
    }

    static class AThread
    extends Thread {
        ActivityManagerService mService;
        Looper mLooper;
        boolean mReady = false;

        public AThread() {
            super(ActivityManagerService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            Process.setThreadPriority(-2);
            Process.setCanSelfBackground(false);
            ActivityManagerService m = new ActivityManagerService();
            AThread aThread = this;
            synchronized (aThread) {
                this.mService = m;
                this.mLooper = Looper.myLooper();
                Watchdog.getInstance().addThread(new Handler(this.mLooper), this.getName());
                this.notifyAll();
            }
            aThread = this;
            synchronized (aThread) {
                while (!this.mReady) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (StrictMode.conditionallyEnableDebugLogging()) {
                Slog.i(ActivityManagerService.TAG, "Enabled StrictMode logging for AThread's Looper");
            }
            Looper.loop();
        }
    }

    private final class AppDeathRecipient
    implements IBinder.DeathRecipient {
        final ProcessRecord mApp;
        final int mPid;
        final IApplicationThread mAppThread;

        AppDeathRecipient(ProcessRecord app, int pid, IApplicationThread thread) {
            this.mApp = app;
            this.mPid = pid;
            this.mAppThread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.appDiedLocked(this.mApp, this.mPid, this.mAppThread);
            }
        }
    }

    static class ProcessChangeItem {
        static final int CHANGE_ACTIVITIES = 1;
        static final int CHANGE_IMPORTANCE = 2;
        int changes;
        int uid;
        int pid;
        int importance;
        boolean foregroundActivities;

        ProcessChangeItem() {
        }
    }

    private class Identity {
        public int pid;
        public int uid;

        Identity(int _pid, int _uid) {
            this.pid = _pid;
            this.uid = _uid;
        }
    }

    abstract class ForegroundToken
    implements IBinder.DeathRecipient {
        int pid;
        IBinder token;

        ForegroundToken() {
        }
    }

    static final class BadProcessInfo {
        final long time;
        final String shortMsg;
        final String longMsg;
        final String stack;

        BadProcessInfo(long time, String shortMsg, String longMsg, String stack) {
            this.time = time;
            this.shortMsg = shortMsg;
            this.longMsg = longMsg;
            this.stack = stack;
        }
    }

    public class PendingAssistExtras
    extends Binder
    implements Runnable {
        public final ActivityRecord activity;
        public boolean haveResult = false;
        public Bundle result = null;

        public PendingAssistExtras(ActivityRecord _activity) {
            this.activity = _activity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Slog.w(ActivityManagerService.TAG, "getAssistContextExtras failed: timeout retrieving from " + this.activity);
            PendingAssistExtras pendingAssistExtras = this;
            synchronized (pendingAssistExtras) {
                this.haveResult = true;
                this.notifyAll();
            }
        }
    }

    static class PendingActivityLaunch {
        final ActivityRecord r;
        final ActivityRecord sourceRecord;
        final int startFlags;
        final ActivityStack stack;

        PendingActivityLaunch(ActivityRecord _r, ActivityRecord _sourceRecord, int _startFlags, ActivityStack _stack) {
            this.r = _r;
            this.sourceRecord = _sourceRecord;
            this.startFlags = _startFlags;
            this.stack = _stack;
        }
    }
}

