/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.util.Slog;
import android.view.WindowManager;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

final class AppNotRespondingDialog
extends BaseErrorDialog {
    private static final String TAG = "AppNotRespondingDialog";
    static final int FORCE_CLOSE = 1;
    static final int WAIT = 2;
    static final int WAIT_AND_REPORT = 3;
    private final ActivityManagerService mService;
    private final ProcessRecord mProc;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            Intent appErrorIntent = null;
            switch (msg.what) {
                case 1: {
                    AppNotRespondingDialog.this.mService.killAppAtUsersRequest(AppNotRespondingDialog.this.mProc, AppNotRespondingDialog.this);
                    break;
                }
                case 2: 
                case 3: {
                    ActivityManagerService activityManagerService = AppNotRespondingDialog.this.mService;
                    synchronized (activityManagerService) {
                        ProcessRecord app = AppNotRespondingDialog.this.mProc;
                        if (msg.what == 3) {
                            appErrorIntent = AppNotRespondingDialog.this.mService.createAppErrorIntentLocked(app, System.currentTimeMillis(), null);
                        }
                        app.notResponding = false;
                        app.notRespondingReport = null;
                        if (app.anrDialog == AppNotRespondingDialog.this) {
                            app.anrDialog = null;
                        }
                        ((AppNotRespondingDialog)AppNotRespondingDialog.this).mService.mServices.scheduleServiceTimeoutLocked(app);
                        break;
                    }
                }
            }
            if (appErrorIntent != null) {
                try {
                    AppNotRespondingDialog.this.getContext().startActivity(appErrorIntent);
                }
                catch (ActivityNotFoundException e) {
                    Slog.w(AppNotRespondingDialog.TAG, "bug report receiver dissappeared", e);
                }
            }
        }
    };

    public AppNotRespondingDialog(ActivityManagerService service, Context context, ProcessRecord app, ActivityRecord activity, boolean aboveSystem) {
        super(context);
        int resid;
        this.mService = service;
        this.mProc = app;
        Resources res = context.getResources();
        this.setCancelable(false);
        CharSequence name1 = activity != null ? activity.info.loadLabel(context.getPackageManager()) : null;
        CharSequence name2 = null;
        if (app.pkgList.size() == 1 && (name2 = context.getPackageManager().getApplicationLabel(app.info)) != null) {
            if (name1 != null) {
                resid = 0x1040400;
            } else {
                name1 = name2;
                name2 = app.processName;
                resid = 17040386;
            }
        } else if (name1 != null) {
            name2 = app.processName;
            resid = 0x1040401;
        } else {
            name1 = app.processName;
            resid = 17040387;
        }
        this.setMessage(name2 != null ? res.getString(resid, ((Object)name1).toString(), name2.toString()) : res.getString(resid, ((Object)name1).toString()));
        this.setButton(-1, res.getText(0x1040404), this.mHandler.obtainMessage(1));
        this.setButton(-2, res.getText(17040390), this.mHandler.obtainMessage(2));
        if (app.errorReportReceiver != null) {
            this.setButton(-3, res.getText(17040389), this.mHandler.obtainMessage(3));
        }
        this.setTitle(res.getText(17040383));
        if (aboveSystem) {
            this.getWindow().setType(2010);
        }
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.setTitle("Application Not Responding: " + app.info.processName);
        attrs.privateFlags = 272;
        this.getWindow().setAttributes(attrs);
    }

    public void onStop() {
    }
}

