/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.AppGlobals;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.BaseNetworkStateTracker;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.net.NetworkInfo;
import android.net.RouteInfo;
import android.os.Binder;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemService;
import android.os.UserHandle;
import android.os.UserManager;
import android.security.KeyStore;
import android.util.Log;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;
import com.android.server.ConnectivityService;
import com.android.server.net.BaseNetworkObserver;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;

public class Vpn
extends BaseNetworkStateTracker {
    private static final String TAG = "Vpn";
    private static final boolean LOGD = true;
    private final ConnectivityService.VpnCallback mCallback;
    private String mPackage = "[Legacy VPN]";
    private String mInterface;
    private Connection mConnection;
    private LegacyVpnRunner mLegacyVpnRunner;
    private PendingIntent mStatusIntent;
    private volatile boolean mEnableNotif = true;
    private volatile boolean mEnableTeardown = true;
    private final IConnectivityManager mConnService;
    private VpnConfig mConfig;
    @GuardedBy(value="this")
    private SparseBooleanArray mVpnUsers = null;
    private BroadcastReceiver mUserIntentReceiver = null;
    private final int mUserId;
    private INetworkManagementEventObserver mObserver = new BaseNetworkObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interfaceStatusChanged(String interfaze, boolean up) {
            Vpn vpn = Vpn.this;
            synchronized (vpn) {
                if (!up && Vpn.this.mLegacyVpnRunner != null) {
                    Vpn.this.mLegacyVpnRunner.check(interfaze);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interfaceRemoved(String interfaze) {
            Vpn vpn = Vpn.this;
            synchronized (vpn) {
                if (interfaze.equals(Vpn.this.mInterface) && Vpn.this.jniCheck(interfaze) == 0) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        int size = Vpn.this.mVpnUsers.size();
                        boolean forwardDns = ((Vpn)Vpn.this).mConfig.dnsServers != null && ((Vpn)Vpn.this).mConfig.dnsServers.size() != 0;
                        for (int i = 0; i < size; ++i) {
                            int user = Vpn.this.mVpnUsers.keyAt(i);
                            Vpn.this.mCallback.clearUserForwarding(Vpn.this.mInterface, user, forwardDns);
                            Vpn.this.hideNotification(user);
                        }
                        Vpn.this.mVpnUsers = null;
                        Vpn.this.mCallback.clearMarkedForwarding(Vpn.this.mInterface);
                        Vpn.this.mCallback.restore();
                        Object var10_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        Binder.restoreCallingIdentity(token);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity(token);
                    Vpn.this.mInterface = null;
                    if (Vpn.this.mConnection != null) {
                        Vpn.this.mContext.unbindService(Vpn.this.mConnection);
                        Vpn.this.mConnection = null;
                        Vpn.this.updateState(NetworkInfo.DetailedState.DISCONNECTED, "interfaceRemoved");
                    } else if (Vpn.this.mLegacyVpnRunner != null) {
                        Vpn.this.mLegacyVpnRunner.exit();
                        Vpn.this.mLegacyVpnRunner = null;
                    }
                }
            }
        }
    };

    public Vpn(Context context, ConnectivityService.VpnCallback callback, INetworkManagementService netService, IConnectivityManager connService, int userId) {
        super(8);
        this.mContext = context;
        this.mCallback = callback;
        this.mConnService = connService;
        this.mUserId = userId;
        try {
            netService.registerObserver(this.mObserver);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Problem registering observer", e);
        }
        if (userId == 0) {
            this.mUserIntentReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                    if (userId == -10000) {
                        return;
                    }
                    if ("android.intent.action.USER_ADDED".equals(action)) {
                        Vpn.this.onUserAdded(userId);
                    } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                        Vpn.this.onUserRemoved(userId);
                    }
                }
            };
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.USER_ADDED");
            intentFilter.addAction("android.intent.action.USER_REMOVED");
            this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        }
    }

    public void setEnableNotifications(boolean enableNotif) {
        this.mEnableNotif = enableNotif;
    }

    public void setEnableTeardown(boolean enableTeardown) {
        this.mEnableTeardown = enableTeardown;
    }

    protected void startMonitoringInternal() {
    }

    public boolean teardown() {
        throw new UnsupportedOperationException();
    }

    public boolean reconnect() {
        throw new UnsupportedOperationException();
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.unknown";
    }

    private void updateState(NetworkInfo.DetailedState detailedState, String reason) {
        Log.d(TAG, "setting state=" + (Object)((Object)detailedState) + ", reason=" + reason);
        this.mNetworkInfo.setDetailedState(detailedState, reason, null);
        this.mCallback.onStateChanged(new NetworkInfo(this.mNetworkInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean prepare(String oldPackage, String newPackage) {
        if (oldPackage != null && !oldPackage.equals(this.mPackage)) {
            return false;
        }
        if (newPackage == null || newPackage.equals(this.mPackage) && !newPackage.equals("[Legacy VPN]")) {
            return true;
        }
        this.enforceControlPermission();
        if (this.mInterface != null) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mCallback.restore();
                int size = this.mVpnUsers.size();
                boolean forwardDns = this.mConfig.dnsServers != null && this.mConfig.dnsServers.size() != 0;
                for (int i = 0; i < size; ++i) {
                    int user = this.mVpnUsers.keyAt(i);
                    this.mCallback.clearUserForwarding(this.mInterface, user, forwardDns);
                    this.hideNotification(user);
                }
                this.mCallback.clearMarkedForwarding(this.mInterface);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            this.jniReset(this.mInterface);
            this.mInterface = null;
            this.mVpnUsers = null;
        }
        if (this.mConnection != null) {
            try {
                this.mConnection.mService.transact(0xFFFFFF, Parcel.obtain(), null, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
        } else if (this.mLegacyVpnRunner != null) {
            this.mLegacyVpnRunner.exit();
            this.mLegacyVpnRunner = null;
        }
        Log.i(TAG, "Switched from " + this.mPackage + " to " + newPackage);
        this.mPackage = newPackage;
        this.mConfig = null;
        this.updateState(NetworkInfo.DetailedState.IDLE, "prepare");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protect(ParcelFileDescriptor socket, String interfaze) throws Exception {
        PackageManager pm = this.mContext.getPackageManager();
        int appUid = pm.getPackageUid(this.mPackage, this.mUserId);
        if (Binder.getCallingUid() != appUid) {
            throw new SecurityException("Unauthorized Caller");
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mCallback.protect(socket);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
        this.jniProtect(socket.getFd(), interfaze);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ParcelFileDescriptor establish(VpnConfig config) {
        UserManager mgr = UserManager.get(this.mContext);
        PackageManager pm = this.mContext.getPackageManager();
        ApplicationInfo app = null;
        try {
            app = AppGlobals.getPackageManager().getApplicationInfo(this.mPackage, 0, this.mUserId);
            if (Binder.getCallingUid() != app.uid) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        Intent intent = new Intent("android.net.VpnService");
        intent.setClassName(this.mPackage, config.user);
        long token = Binder.clearCallingIdentity();
        try {
            try {
                UserInfo user = mgr.getUserInfo(this.mUserId);
                if (user.isRestricted()) {
                    throw new SecurityException("Restricted users cannot establish VPNs");
                }
                ResolveInfo info = AppGlobals.getPackageManager().resolveService(intent, null, 0, this.mUserId);
                if (info == null) {
                    throw new SecurityException("Cannot find " + config.user);
                }
                if (!"android.permission.BIND_VPN_SERVICE".equals(info.serviceInfo.permission)) {
                    throw new SecurityException(config.user + " does not require " + "android.permission.BIND_VPN_SERVICE");
                }
                Object var11_12 = null;
            }
            catch (RemoteException e) {
                throw new SecurityException("Cannot find " + config.user);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
        ParcelFileDescriptor tun = ParcelFileDescriptor.adoptFd(this.jniCreate(config.mtu));
        try {
            this.updateState(NetworkInfo.DetailedState.CONNECTING, "establish");
            String interfaze = this.jniGetName(tun.getFd());
            StringBuilder builder = new StringBuilder();
            for (LinkAddress address : config.addresses) {
                builder.append(" " + address);
            }
            if (this.jniSetAddresses(interfaze, builder.toString()) < 1) {
                throw new IllegalArgumentException("At least one address must be specified");
            }
            Connection connection = new Connection();
            if (!this.mContext.bindServiceAsUser(intent, connection, 1, new UserHandle(this.mUserId))) {
                throw new IllegalStateException("Cannot bind " + config.user);
            }
            if (this.mConnection != null) {
                this.mContext.unbindService(this.mConnection);
            }
            if (this.mInterface != null && !this.mInterface.equals(interfaze)) {
                this.jniReset(this.mInterface);
            }
            this.mConnection = connection;
            this.mInterface = interfaze;
            config.user = this.mPackage;
            config.interfaze = this.mInterface;
            config.startTime = SystemClock.elapsedRealtime();
            this.mConfig = config;
            this.mVpnUsers = new SparseBooleanArray();
            token = Binder.clearCallingIdentity();
            try {
                this.mCallback.setMarkedForwarding(this.mInterface);
                this.mCallback.setRoutes(interfaze, config.routes);
                this.mCallback.override(this.mInterface, config.dnsServers, config.searchDomains);
                this.addVpnUserLocked(this.mUserId);
                Object var14_19 = null;
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            {
            }
        }
        catch (RuntimeException e) {
            this.updateState(NetworkInfo.DetailedState.FAILED, "establish");
            IoUtils.closeQuietly(tun);
            try {
                this.mCallback.clearMarkedForwarding(this.mInterface);
            }
            catch (Exception ingored) {
                // empty catch block
            }
            throw e;
        }
        Log.i(TAG, "Established by " + config.user + " on " + this.mInterface);
        if (this.mUserId == 0) {
            token = Binder.clearCallingIdentity();
            try {
                for (UserInfo user : mgr.getUsers()) {
                    if (!user.isRestricted()) continue;
                    try {
                        this.addVpnUserLocked(user.id);
                    }
                    catch (Exception e) {
                        Log.wtf(TAG, "Failed to add user " + user.id + " to owner's VPN");
                    }
                }
                Object var16_22 = null;
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            {
            }
        }
        this.updateState(NetworkInfo.DetailedState.AUTHENTICATING, "establish");
        return tun;
    }

    private boolean isRunningLocked() {
        return this.mVpnUsers != null;
    }

    private void addVpnUserLocked(int user) {
        this.enforceControlPermission();
        if (!this.isRunningLocked()) {
            throw new IllegalStateException("VPN is not active");
        }
        boolean forwardDns = this.mConfig.dnsServers != null && this.mConfig.dnsServers.size() != 0;
        this.mCallback.addUserForwarding(this.mInterface, user, forwardDns);
        this.mVpnUsers.put(user, true);
        if (!this.mPackage.equals("[Legacy VPN]")) {
            PackageManager pm = this.mContext.getPackageManager();
            ApplicationInfo app = null;
            try {
                app = AppGlobals.getPackageManager().getApplicationInfo(this.mPackage, 0, this.mUserId);
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Invalid application");
            }
            String label = ((Object)app.loadLabel(pm)).toString();
            Drawable icon = app.loadIcon(pm);
            Bitmap bitmap = null;
            if (icon.getIntrinsicWidth() > 0 && icon.getIntrinsicHeight() > 0) {
                int width = this.mContext.getResources().getDimensionPixelSize(0x1050005);
                int height = this.mContext.getResources().getDimensionPixelSize(17104902);
                icon.setBounds(0, 0, width, height);
                bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                Canvas c = new Canvas(bitmap);
                icon.draw(c);
                c.setBitmap(null);
            }
            this.showNotification(label, bitmap, user);
        } else {
            this.showNotification(null, null, user);
        }
    }

    private void removeVpnUserLocked(int user) {
        this.enforceControlPermission();
        if (!this.isRunningLocked()) {
            throw new IllegalStateException("VPN is not active");
        }
        boolean forwardDns = this.mConfig.dnsServers != null && this.mConfig.dnsServers.size() != 0;
        this.mCallback.clearUserForwarding(this.mInterface, user, forwardDns);
        this.mVpnUsers.delete(user);
        this.hideNotification(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserAdded(int userId) {
        Vpn vpn = this;
        synchronized (vpn) {
            UserManager mgr = UserManager.get(this.mContext);
            UserInfo user = mgr.getUserInfo(userId);
            if (user.isRestricted()) {
                try {
                    this.addVpnUserLocked(userId);
                }
                catch (Exception e) {
                    Log.wtf(TAG, "Failed to add restricted user to owner", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(int userId) {
        Vpn vpn = this;
        synchronized (vpn) {
            UserManager mgr = UserManager.get(this.mContext);
            UserInfo user = mgr.getUserInfo(userId);
            if (user.isRestricted()) {
                try {
                    this.removeVpnUserLocked(userId);
                }
                catch (Exception e) {
                    Log.wtf(TAG, "Failed to remove restricted user to owner", e);
                }
            }
        }
    }

    public VpnConfig getVpnConfig() {
        this.enforceControlPermission();
        return this.mConfig;
    }

    @Deprecated
    public synchronized void interfaceStatusChanged(String iface, boolean up) {
        try {
            this.mObserver.interfaceStatusChanged(iface, up);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enforceControlPermission() {
        long token;
        block6: {
            if (Binder.getCallingUid() == 1000) {
                return;
            }
            int appId = UserHandle.getAppId(Binder.getCallingUid());
            token = Binder.clearCallingIdentity();
            try {
                try {
                    PackageManager pm = this.mContext.getPackageManager();
                    ApplicationInfo app = pm.getApplicationInfo("com.android.vpndialogs", 0);
                    if ((app.flags & 1) == 0 || appId != app.uid) break block6;
                    Object var7_6 = null;
                }
                catch (Exception e) {
                    Object var7_8 = null;
                    Binder.restoreCallingIdentity(token);
                    throw new SecurityException("Unauthorized Caller");
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            return;
        }
        Object var7_7 = null;
        Binder.restoreCallingIdentity(token);
        throw new SecurityException("Unauthorized Caller");
    }

    private void showNotification(String label, Bitmap icon, int user) {
        if (!this.mEnableNotif) {
            return;
        }
        this.mStatusIntent = VpnConfig.getIntentForStatusPanel(this.mContext);
        NotificationManager nm = (NotificationManager)this.mContext.getSystemService("notification");
        if (nm != null) {
            String title = label == null ? this.mContext.getString(17040565) : this.mContext.getString(17040566, label);
            String text = this.mConfig.session == null ? this.mContext.getString(17040567) : this.mContext.getString(17040568, this.mConfig.session);
            Notification notification = new Notification.Builder(this.mContext).setSmallIcon(17303157).setLargeIcon(icon).setContentTitle(title).setContentText(text).setContentIntent(this.mStatusIntent).setDefaults(0).setOngoing(true).build();
            nm.notifyAsUser(null, 17303157, notification, new UserHandle(user));
        }
    }

    private void hideNotification(int user) {
        if (!this.mEnableNotif) {
            return;
        }
        this.mStatusIntent = null;
        NotificationManager nm = (NotificationManager)this.mContext.getSystemService("notification");
        if (nm != null) {
            nm.cancelAsUser(null, 17303157, new UserHandle(user));
        }
    }

    private native int jniCreate(int var1);

    private native String jniGetName(int var1);

    private native int jniSetAddresses(String var1, String var2);

    private native int jniSetRoutes(String var1, String var2);

    private native void jniReset(String var1);

    private native int jniCheck(String var1);

    private native void jniProtect(int var1, String var2);

    private static RouteInfo findIPv4DefaultRoute(LinkProperties prop) {
        for (RouteInfo route : prop.getAllRoutes()) {
            if (!route.isDefaultRoute() || !(route.getGateway() instanceof Inet4Address)) continue;
            return route;
        }
        throw new IllegalStateException("Unable to find IPv4 default gateway");
    }

    public void startLegacyVpn(VpnProfile profile, KeyStore keyStore, LinkProperties egress) {
        byte[] value;
        this.enforceControlPermission();
        if (!keyStore.isUnlocked()) {
            throw new IllegalStateException("KeyStore isn't unlocked");
        }
        RouteInfo ipv4DefaultRoute = Vpn.findIPv4DefaultRoute(egress);
        String gateway = ipv4DefaultRoute.getGateway().getHostAddress();
        String iface = ipv4DefaultRoute.getInterface();
        String privateKey = "";
        String userCert = "";
        String caCert = "";
        String serverCert = "";
        if (!profile.ipsecUserCert.isEmpty()) {
            privateKey = "USRPKEY_" + profile.ipsecUserCert;
            value = keyStore.get("USRCERT_" + profile.ipsecUserCert);
            String string2 = userCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (!profile.ipsecCaCert.isEmpty()) {
            value = keyStore.get("CACERT_" + profile.ipsecCaCert);
            String string3 = caCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (!profile.ipsecServerCert.isEmpty()) {
            value = keyStore.get("USRCERT_" + profile.ipsecServerCert);
            String string4 = serverCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (privateKey == null || userCert == null || caCert == null || serverCert == null) {
            throw new IllegalStateException("Cannot load credentials");
        }
        String[] racoon = null;
        switch (profile.type) {
            case 1: {
                racoon = new String[]{iface, profile.server, "udppsk", profile.ipsecIdentifier, profile.ipsecSecret, "1701"};
                break;
            }
            case 2: {
                racoon = new String[]{iface, profile.server, "udprsa", privateKey, userCert, caCert, serverCert, "1701"};
                break;
            }
            case 3: {
                racoon = new String[]{iface, profile.server, "xauthpsk", profile.ipsecIdentifier, profile.ipsecSecret, profile.username, profile.password, "", gateway};
                break;
            }
            case 4: {
                racoon = new String[]{iface, profile.server, "xauthrsa", privateKey, userCert, caCert, serverCert, profile.username, profile.password, "", gateway};
                break;
            }
            case 5: {
                racoon = new String[]{iface, profile.server, "hybridrsa", caCert, serverCert, profile.username, profile.password, "", gateway};
            }
        }
        String[] mtpd = null;
        switch (profile.type) {
            case 0: {
                mtpd = new String[]{iface, "pptp", profile.server, "1723", "name", profile.username, "password", profile.password, "linkname", "vpn", "refuse-eap", "nodefaultroute", "usepeerdns", "idle", "1800", "mtu", "1400", "mru", "1400", profile.mppe ? "+mppe" : "nomppe"};
                break;
            }
            case 1: 
            case 2: {
                mtpd = new String[]{iface, "l2tp", profile.server, "1701", profile.l2tpSecret, "name", profile.username, "password", profile.password, "linkname", "vpn", "refuse-eap", "nodefaultroute", "usepeerdns", "idle", "1800", "mtu", "1400", "mru", "1400"};
            }
        }
        VpnConfig config = new VpnConfig();
        config.legacy = true;
        config.user = profile.key;
        config.interfaze = iface;
        config.session = profile.name;
        config.addLegacyRoutes(profile.routes);
        if (!profile.dnsServers.isEmpty()) {
            config.dnsServers = Arrays.asList(profile.dnsServers.split(" +"));
        }
        if (!profile.searchDomains.isEmpty()) {
            config.searchDomains = Arrays.asList(profile.searchDomains.split(" +"));
        }
        this.startLegacyVpn(config, racoon, mtpd);
    }

    private synchronized void startLegacyVpn(VpnConfig config, String[] racoon, String[] mtpd) {
        this.stopLegacyVpn();
        this.prepare(null, "[Legacy VPN]");
        this.updateState(NetworkInfo.DetailedState.CONNECTING, "startLegacyVpn");
        this.mLegacyVpnRunner = new LegacyVpnRunner(config, racoon, mtpd);
        this.mLegacyVpnRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void stopLegacyVpn() {
        if (this.mLegacyVpnRunner == null) return;
        this.mLegacyVpnRunner.exit();
        this.mLegacyVpnRunner = null;
        String string2 = "LegacyVpnRunner";
        synchronized ("LegacyVpnRunner") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized LegacyVpnInfo getLegacyVpnInfo() {
        this.enforceControlPermission();
        if (this.mLegacyVpnRunner == null) {
            return null;
        }
        LegacyVpnInfo info = new LegacyVpnInfo();
        info.key = this.mConfig.user;
        info.state = LegacyVpnInfo.stateFromNetworkInfo(this.mNetworkInfo);
        if (this.mNetworkInfo.isConnected()) {
            info.intent = this.mStatusIntent;
        }
        return info;
    }

    public VpnConfig getLegacyVpnConfig() {
        if (this.mLegacyVpnRunner != null) {
            return this.mConfig;
        }
        return null;
    }

    private class LegacyVpnRunner
    extends Thread {
        private static final String TAG = "LegacyVpnRunner";
        private final String[] mDaemons;
        private final String[][] mArguments;
        private final LocalSocket[] mSockets;
        private final String mOuterInterface;
        private final AtomicInteger mOuterConnection;
        private long mTimer;
        private final BroadcastReceiver mBroadcastReceiver;

        public LegacyVpnRunner(VpnConfig config, String[] racoon, String[] mtpd) {
            super(TAG);
            this.mOuterConnection = new AtomicInteger(-1);
            this.mTimer = -1L;
            this.mBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    NetworkInfo info;
                    if (!Vpn.this.mEnableTeardown) {
                        return;
                    }
                    if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") && intent.getIntExtra("networkType", -1) == LegacyVpnRunner.this.mOuterConnection.get() && (info = (NetworkInfo)intent.getExtra("networkInfo")) != null && !info.isConnectedOrConnecting()) {
                        try {
                            Vpn.this.mObserver.interfaceStatusChanged(LegacyVpnRunner.this.mOuterInterface, false);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                }
            };
            Vpn.this.mConfig = config;
            this.mDaemons = new String[]{"racoon", "mtpd"};
            this.mArguments = new String[][]{racoon, mtpd};
            this.mSockets = new LocalSocket[this.mDaemons.length];
            this.mOuterInterface = ((Vpn)Vpn.this).mConfig.interfaze;
            try {
                this.mOuterConnection.set(Vpn.this.mConnService.findConnectionTypeForIface(this.mOuterInterface));
            }
            catch (Exception e) {
                this.mOuterConnection.set(-1);
            }
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            Vpn.this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        }

        public void check(String interfaze) {
            if (interfaze.equals(this.mOuterInterface)) {
                Log.i(TAG, "Legacy VPN is going down with " + interfaze);
                this.exit();
            }
        }

        public void exit() {
            this.interrupt();
            for (LocalSocket socket : this.mSockets) {
                IoUtils.closeQuietly(socket);
            }
            Vpn.this.updateState(NetworkInfo.DetailedState.DISCONNECTED, "exit");
            try {
                Vpn.this.mContext.unregisterReceiver(this.mBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.v(TAG, "Waiting");
            String string2 = TAG;
            synchronized (TAG) {
                Log.v(TAG, "Executing");
                this.execute();
                this.monitorDaemons();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void checkpoint(boolean yield) throws InterruptedException {
            long now = SystemClock.elapsedRealtime();
            if (this.mTimer == -1L) {
                this.mTimer = now;
                Thread.sleep(1L);
            } else if (now - this.mTimer <= 60000L) {
                Thread.sleep(yield ? 200L : 1L);
            } else {
                Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, "checkpoint");
                throw new IllegalStateException("Time is up");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void execute() {
            int i;
            File state;
            boolean initFinished = false;
            try {
                try {
                    this.checkpoint(false);
                    for (String daemon : this.mDaemons) {
                        while (!SystemService.isStopped(daemon)) {
                            this.checkpoint(true);
                        }
                    }
                    state = new File("/data/misc/vpn/state");
                    state.delete();
                    if (state.exists()) {
                        throw new IllegalStateException("Cannot delete the state");
                    }
                    new File("/data/misc/vpn/abort").delete();
                    initFinished = true;
                    boolean restart = false;
                    for (String[] arguments : this.mArguments) {
                        restart = restart || arguments != null;
                    }
                    if (!restart) {
                        Vpn.this.updateState(NetworkInfo.DetailedState.DISCONNECTED, "execute");
                        Object var22_20 = null;
                        if (!initFinished) {
                            for (String daemon : this.mDaemons) {
                                SystemService.stop(daemon);
                            }
                        }
                        if (initFinished) {
                            if (Vpn.this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTING) return;
                        }
                        Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, "execute");
                        return;
                    }
                    Vpn.this.updateState(NetworkInfo.DetailedState.CONNECTING, "execute");
                    block24: for (i = 0; i < this.mDaemons.length; ++i) {
                        String[] arguments = this.mArguments[i];
                        if (arguments == null) continue;
                        String daemon = this.mDaemons[i];
                        SystemService.start(daemon);
                        while (!SystemService.isRunning(daemon)) {
                            this.checkpoint(true);
                        }
                        this.mSockets[i] = new LocalSocket();
                        LocalSocketAddress address = new LocalSocketAddress(daemon, LocalSocketAddress.Namespace.RESERVED);
                        while (true) {
                            try {
                                this.mSockets[i].connect(address);
                            }
                            catch (Exception e) {
                                this.checkpoint(true);
                                continue;
                            }
                            break;
                        }
                        this.mSockets[i].setSoTimeout(500);
                        OutputStream out = this.mSockets[i].getOutputStream();
                        for (String argument : arguments) {
                            byte[] bytes = argument.getBytes(StandardCharsets.UTF_8);
                            if (bytes.length >= 65535) {
                                throw new IllegalArgumentException("Argument is too large");
                            }
                            out.write(bytes.length >> 8);
                            out.write(bytes.length);
                            out.write(bytes);
                            this.checkpoint(false);
                        }
                        out.write(255);
                        out.write(255);
                        out.flush();
                        InputStream in = this.mSockets[i].getInputStream();
                        while (true) {
                            try {
                                if (in.read() == -1) {
                                    continue block24;
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.checkpoint(true);
                        }
                    }
                }
                catch (Exception e) {
                    Log.i(TAG, "Aborting", e);
                    try {
                        Vpn.this.mCallback.clearMarkedForwarding(((Vpn)Vpn.this).mConfig.interfaze);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.exit();
                    Object var22_22 = null;
                    if (!initFinished) {
                        for (String daemon : this.mDaemons) {
                            SystemService.stop(daemon);
                        }
                    }
                    if (initFinished) {
                        if (Vpn.this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTING) return;
                    }
                    Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, "execute");
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var22_23 = null;
                if (!initFinished) {
                    for (String daemon : this.mDaemons) {
                        SystemService.stop(daemon);
                    }
                }
                if (initFinished) {
                    if (Vpn.this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTING) throw throwable;
                }
                Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, "execute");
                throw throwable;
            }
            while (true) {
                if (!state.exists()) {
                } else {
                    String searchDomains;
                    String dnsServers;
                    String[] parameters = FileUtils.readTextFile(state, 0, null).split("\n", -1);
                    if (parameters.length != 6) {
                        throw new IllegalStateException("Cannot parse the state");
                    }
                    ((Vpn)Vpn.this).mConfig.interfaze = parameters[0].trim();
                    Vpn.this.mConfig.addLegacyAddresses(parameters[1]);
                    if (((Vpn)Vpn.this).mConfig.routes == null || ((Vpn)Vpn.this).mConfig.routes.isEmpty()) {
                        Vpn.this.mConfig.addLegacyRoutes(parameters[2]);
                    }
                    if (!(((Vpn)Vpn.this).mConfig.dnsServers != null && ((Vpn)Vpn.this).mConfig.dnsServers.size() != 0 || (dnsServers = parameters[3].trim()).isEmpty())) {
                        ((Vpn)Vpn.this).mConfig.dnsServers = Arrays.asList(dnsServers.split(" "));
                    }
                    if (!(((Vpn)Vpn.this).mConfig.searchDomains != null && ((Vpn)Vpn.this).mConfig.searchDomains.size() != 0 || (searchDomains = parameters[4].trim()).isEmpty())) {
                        ((Vpn)Vpn.this).mConfig.searchDomains = Arrays.asList(searchDomains.split(" "));
                    }
                    long token = Binder.clearCallingIdentity();
                    try {
                        Vpn.this.mCallback.setMarkedForwarding(((Vpn)Vpn.this).mConfig.interfaze);
                        Vpn.this.mCallback.setRoutes(((Vpn)Vpn.this).mConfig.interfaze, ((Vpn)Vpn.this).mConfig.routes);
                        Object var15_51 = null;
                        Binder.restoreCallingIdentity(token);
                    }
                    catch (Throwable throwable) {
                        Object var15_52 = null;
                        Binder.restoreCallingIdentity(token);
                        throw throwable;
                    }
                    Vpn vpn = Vpn.this;
                    synchronized (vpn) {
                        ((Vpn)Vpn.this).mConfig.startTime = SystemClock.elapsedRealtime();
                        this.checkpoint(false);
                        if (Vpn.this.jniCheck(((Vpn)Vpn.this).mConfig.interfaze) == 0) {
                            throw new IllegalStateException(((Vpn)Vpn.this).mConfig.interfaze + " is gone");
                        }
                        Vpn.this.mInterface = ((Vpn)Vpn.this).mConfig.interfaze;
                        Vpn.this.mVpnUsers = new SparseBooleanArray();
                        token = Binder.clearCallingIdentity();
                        try {
                            Vpn.this.mCallback.override(Vpn.this.mInterface, ((Vpn)Vpn.this).mConfig.dnsServers, ((Vpn)Vpn.this).mConfig.searchDomains);
                            Vpn.this.addVpnUserLocked(Vpn.this.mUserId);
                            Object var17_54 = null;
                            Binder.restoreCallingIdentity(token);
                        }
                        catch (Throwable throwable) {
                            Object var17_55 = null;
                            Binder.restoreCallingIdentity(token);
                            throw throwable;
                        }
                        UserManager mgr = UserManager.get(Vpn.this.mContext);
                        token = Binder.clearCallingIdentity();
                        try {
                            for (UserInfo user : mgr.getUsers()) {
                                if (!user.isRestricted()) continue;
                                try {
                                    Vpn.this.addVpnUserLocked(user.id);
                                }
                                catch (Exception e) {
                                    Log.wtf(TAG, "Failed to add user " + user.id + " to owner's VPN");
                                }
                            }
                            Object var19_57 = null;
                            Binder.restoreCallingIdentity(token);
                        }
                        catch (Throwable throwable) {
                            Object var19_58 = null;
                            Binder.restoreCallingIdentity(token);
                            throw throwable;
                        }
                        Log.i(TAG, "Connected!");
                        Vpn.this.updateState(NetworkInfo.DetailedState.CONNECTED, "execute");
                    }
                    Object var22_21 = null;
                    if (!initFinished) {
                        for (String daemon : this.mDaemons) {
                            SystemService.stop(daemon);
                        }
                    }
                    if (initFinished) {
                        if (Vpn.this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTING) return;
                    }
                    Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, "execute");
                    return;
                }
                for (i = 0; i < this.mDaemons.length; ++i) {
                    String daemon = this.mDaemons[i];
                    if (this.mArguments[i] == null || SystemService.isRunning(daemon)) continue;
                    throw new IllegalStateException(daemon + " is dead");
                }
                this.checkpoint(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void monitorDaemons() {
            if (!Vpn.this.mNetworkInfo.isConnected()) {
                return;
            }
            try {
                try {}
                catch (InterruptedException e) {
                    Log.d(TAG, "interrupted during monitorDaemons(); stopping services");
                    Object var3_4 = null;
                    String[] arr$ = this.mDaemons;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) {
                            Vpn.this.updateState(NetworkInfo.DetailedState.DISCONNECTED, "babysit");
                            return;
                        }
                        String daemon = arr$[i$];
                        SystemService.stop(daemon);
                        ++i$;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                String[] arr$ = this.mDaemons;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        Vpn.this.updateState(NetworkInfo.DetailedState.DISCONNECTED, "babysit");
                        throw throwable;
                    }
                    String daemon = arr$[i$];
                    SystemService.stop(daemon);
                    ++i$;
                }
            }
            block6: while (true) {
                Thread.sleep(2000L);
                int i = 0;
                while (true) {
                    if (i >= this.mDaemons.length) continue block6;
                    if (this.mArguments[i] != null && SystemService.isStopped(this.mDaemons[i])) {
                        Object var3_3 = null;
                        for (String daemon : this.mDaemons) {
                            SystemService.stop(daemon);
                        }
                        Vpn.this.updateState(NetworkInfo.DetailedState.DISCONNECTED, "babysit");
                        return;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private class Connection
    implements ServiceConnection {
        private IBinder mService;

        private Connection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mService = service;
        }

        public void onServiceDisconnected(ComponentName name) {
            this.mService = null;
        }
    }
}

