/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.firewall;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.PatternMatcher;
import com.android.server.firewall.Filter;
import com.android.server.firewall.FilterFactory;
import com.android.server.firewall.IntentFirewall;
import java.io.IOException;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class StringFilter
implements Filter {
    private static final String ATTR_EQUALS = "equals";
    private static final String ATTR_STARTS_WITH = "startsWith";
    private static final String ATTR_CONTAINS = "contains";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_REGEX = "regex";
    private static final String ATTR_IS_NULL = "isNull";
    private final ValueProvider mValueProvider;
    public static final ValueProvider COMPONENT = new ValueProvider("component"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            if (resolvedComponent != null) {
                return resolvedComponent.flattenToString();
            }
            return null;
        }
    };
    public static final ValueProvider COMPONENT_NAME = new ValueProvider("component-name"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            if (resolvedComponent != null) {
                return resolvedComponent.getClassName();
            }
            return null;
        }
    };
    public static final ValueProvider COMPONENT_PACKAGE = new ValueProvider("component-package"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            if (resolvedComponent != null) {
                return resolvedComponent.getPackageName();
            }
            return null;
        }
    };
    public static final FilterFactory ACTION = new ValueProvider("action"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            return intent.getAction();
        }
    };
    public static final ValueProvider DATA = new ValueProvider("data"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            Uri data = intent.getData();
            if (data != null) {
                return data.toString();
            }
            return null;
        }
    };
    public static final ValueProvider MIME_TYPE = new ValueProvider("mime-type"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            return resolvedType;
        }
    };
    public static final ValueProvider SCHEME = new ValueProvider("scheme"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            Uri data = intent.getData();
            if (data != null) {
                return data.getScheme();
            }
            return null;
        }
    };
    public static final ValueProvider SSP = new ValueProvider("scheme-specific-part"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            Uri data = intent.getData();
            if (data != null) {
                return data.getSchemeSpecificPart();
            }
            return null;
        }
    };
    public static final ValueProvider HOST = new ValueProvider("host"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            Uri data = intent.getData();
            if (data != null) {
                return data.getHost();
            }
            return null;
        }
    };
    public static final ValueProvider PATH = new ValueProvider("path"){

        public String getValue(ComponentName resolvedComponent, Intent intent, String resolvedType) {
            Uri data = intent.getData();
            if (data != null) {
                return data.getPath();
            }
            return null;
        }
    };

    private StringFilter(ValueProvider valueProvider) {
        this.mValueProvider = valueProvider;
    }

    public static StringFilter readFromXml(ValueProvider valueProvider, XmlPullParser parser) throws IOException, XmlPullParserException {
        StringFilter filter = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            StringFilter newFilter = StringFilter.getFilter(valueProvider, parser, i);
            if (newFilter == null) continue;
            if (filter != null) {
                throw new XmlPullParserException("Multiple string filter attributes found");
            }
            filter = newFilter;
        }
        if (filter == null) {
            filter = new IsNullFilter(valueProvider, false);
        }
        return filter;
    }

    private static StringFilter getFilter(ValueProvider valueProvider, XmlPullParser parser, int attributeIndex) {
        String attributeName = parser.getAttributeName(attributeIndex);
        switch (attributeName.charAt(0)) {
            case 'e': {
                if (!attributeName.equals(ATTR_EQUALS)) {
                    return null;
                }
                return new EqualsFilter(valueProvider, parser.getAttributeValue(attributeIndex));
            }
            case 'i': {
                if (!attributeName.equals(ATTR_IS_NULL)) {
                    return null;
                }
                return new IsNullFilter(valueProvider, parser.getAttributeValue(attributeIndex));
            }
            case 's': {
                if (!attributeName.equals(ATTR_STARTS_WITH)) {
                    return null;
                }
                return new StartsWithFilter(valueProvider, parser.getAttributeValue(attributeIndex));
            }
            case 'c': {
                if (!attributeName.equals(ATTR_CONTAINS)) {
                    return null;
                }
                return new ContainsFilter(valueProvider, parser.getAttributeValue(attributeIndex));
            }
            case 'p': {
                if (!attributeName.equals(ATTR_PATTERN)) {
                    return null;
                }
                return new PatternStringFilter(valueProvider, parser.getAttributeValue(attributeIndex));
            }
            case 'r': {
                if (!attributeName.equals(ATTR_REGEX)) {
                    return null;
                }
                return new RegexFilter(valueProvider, parser.getAttributeValue(attributeIndex));
            }
        }
        return null;
    }

    protected abstract boolean matchesValue(String var1);

    public boolean matches(IntentFirewall ifw, ComponentName resolvedComponent, Intent intent, int callerUid, int callerPid, String resolvedType, int receivingUid) {
        String value = this.mValueProvider.getValue(resolvedComponent, intent, resolvedType);
        return this.matchesValue(value);
    }

    private static class IsNullFilter
    extends StringFilter {
        private final boolean mIsNull;

        public IsNullFilter(ValueProvider valueProvider, String attrValue) {
            super(valueProvider);
            this.mIsNull = Boolean.parseBoolean(attrValue);
        }

        public IsNullFilter(ValueProvider valueProvider, boolean isNull) {
            super(valueProvider);
            this.mIsNull = isNull;
        }

        public boolean matchesValue(String value) {
            return value == null == this.mIsNull;
        }
    }

    private static class RegexFilter
    extends StringFilter {
        private final Pattern mPattern;

        public RegexFilter(ValueProvider valueProvider, String attrValue) {
            super(valueProvider);
            this.mPattern = Pattern.compile(attrValue);
        }

        public boolean matchesValue(String value) {
            return value != null && this.mPattern.matcher(value).matches();
        }
    }

    private static class PatternStringFilter
    extends StringFilter {
        private final PatternMatcher mPattern;

        public PatternStringFilter(ValueProvider valueProvider, String attrValue) {
            super(valueProvider);
            this.mPattern = new PatternMatcher(attrValue, 2);
        }

        public boolean matchesValue(String value) {
            return value != null && this.mPattern.match(value);
        }
    }

    private static class StartsWithFilter
    extends StringFilter {
        private final String mFilterValue;

        public StartsWithFilter(ValueProvider valueProvider, String attrValue) {
            super(valueProvider);
            this.mFilterValue = attrValue;
        }

        public boolean matchesValue(String value) {
            return value != null && value.startsWith(this.mFilterValue);
        }
    }

    private static class ContainsFilter
    extends StringFilter {
        private final String mFilterValue;

        public ContainsFilter(ValueProvider valueProvider, String attrValue) {
            super(valueProvider);
            this.mFilterValue = attrValue;
        }

        public boolean matchesValue(String value) {
            return value != null && value.contains(this.mFilterValue);
        }
    }

    private static class EqualsFilter
    extends StringFilter {
        private final String mFilterValue;

        public EqualsFilter(ValueProvider valueProvider, String attrValue) {
            super(valueProvider);
            this.mFilterValue = attrValue;
        }

        public boolean matchesValue(String value) {
            return value != null && value.equals(this.mFilterValue);
        }
    }

    private static abstract class ValueProvider
    extends FilterFactory {
        protected ValueProvider(String tag) {
            super(tag);
        }

        public Filter newFilter(XmlPullParser parser) throws IOException, XmlPullParserException {
            return StringFilter.readFromXml(this, parser);
        }

        public abstract String getValue(ComponentName var1, Intent var2, String var3);
    }
}

