/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.Preconditions;
import com.android.server.ConnectivityService;
import com.android.server.EventLogTags;
import com.android.server.connectivity.Vpn;
import java.util.List;

public class LockdownVpnTracker {
    private static final String TAG = "LockdownVpnTracker";
    private static final int MAX_ERROR_COUNT = 4;
    private static final String ACTION_LOCKDOWN_RESET = "com.android.server.action.LOCKDOWN_RESET";
    private static final String ACTION_VPN_SETTINGS = "android.net.vpn.SETTINGS";
    private static final String EXTRA_PICK_LOCKDOWN = "android.net.vpn.PICK_LOCKDOWN";
    private final Context mContext;
    private final INetworkManagementService mNetService;
    private final ConnectivityService mConnService;
    private final Vpn mVpn;
    private final VpnProfile mProfile;
    private final Object mStateLock = new Object();
    private final PendingIntent mConfigIntent;
    private final PendingIntent mResetIntent;
    private String mAcceptedEgressIface;
    private String mAcceptedIface;
    private List<LinkAddress> mAcceptedSourceAddr;
    private int mErrorCount;
    private BroadcastReceiver mResetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            LockdownVpnTracker.this.reset();
        }
    };

    public static boolean isEnabled() {
        return KeyStore.getInstance().contains("LOCKDOWN_VPN");
    }

    public LockdownVpnTracker(Context context, INetworkManagementService netService, ConnectivityService connService, Vpn vpn, VpnProfile profile) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mNetService = Preconditions.checkNotNull(netService);
        this.mConnService = Preconditions.checkNotNull(connService);
        this.mVpn = Preconditions.checkNotNull(vpn);
        this.mProfile = Preconditions.checkNotNull(profile);
        Intent configIntent = new Intent(ACTION_VPN_SETTINGS);
        configIntent.putExtra(EXTRA_PICK_LOCKDOWN, true);
        this.mConfigIntent = PendingIntent.getActivity(this.mContext, 0, configIntent, 0);
        Intent resetIntent = new Intent(ACTION_LOCKDOWN_RESET);
        resetIntent.addFlags(0x40000000);
        this.mResetIntent = PendingIntent.getBroadcast(this.mContext, 0, resetIntent, 0);
    }

    private void handleStateChangedLocked() {
        boolean egressChanged;
        Slog.d(TAG, "handleStateChanged()");
        NetworkInfo egressInfo = this.mConnService.getActiveNetworkInfoUnfiltered();
        LinkProperties egressProp = this.mConnService.getActiveLinkProperties();
        NetworkInfo vpnInfo = this.mVpn.getNetworkInfo();
        VpnConfig vpnConfig = this.mVpn.getLegacyVpnConfig();
        boolean egressDisconnected = egressInfo == null || NetworkInfo.State.DISCONNECTED.equals((Object)egressInfo.getState());
        boolean bl = egressChanged = egressProp == null || !TextUtils.equals(this.mAcceptedEgressIface, egressProp.getInterfaceName());
        if (egressDisconnected || egressChanged) {
            this.clearSourceRulesLocked();
            this.mAcceptedEgressIface = null;
            this.mVpn.stopLegacyVpn();
        }
        if (egressDisconnected) {
            this.hideNotification();
            return;
        }
        int egressType = egressInfo.getType();
        if (vpnInfo.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
            EventLogTags.writeLockdownVpnError(egressType);
        }
        if (this.mErrorCount > 4) {
            this.showNotification(17040571, 17303158);
        } else if (egressInfo.isConnected() && !vpnInfo.isConnectedOrConnecting()) {
            if (this.mProfile.isValidLockdownProfile()) {
                Slog.d(TAG, "Active network connected; starting VPN");
                EventLogTags.writeLockdownVpnConnecting(egressType);
                this.showNotification(17040569, 17303158);
                this.mAcceptedEgressIface = egressProp.getInterfaceName();
                try {
                    this.mVpn.startLegacyVpn(this.mProfile, KeyStore.getInstance(), egressProp);
                }
                catch (IllegalStateException e) {
                    this.mAcceptedEgressIface = null;
                    Slog.e(TAG, "Failed to start VPN", e);
                    this.showNotification(17040571, 17303158);
                }
            } else {
                Slog.e(TAG, "Invalid VPN profile; requires IP-based server and DNS");
                this.showNotification(17040571, 17303158);
            }
        } else if (vpnInfo.isConnected() && vpnConfig != null) {
            String iface = vpnConfig.interfaze;
            List<LinkAddress> sourceAddrs = vpnConfig.addresses;
            if (TextUtils.equals(iface, this.mAcceptedIface) && ((Object)sourceAddrs).equals(this.mAcceptedSourceAddr)) {
                return;
            }
            Slog.d(TAG, "VPN connected using iface=" + iface + ", sourceAddr=" + sourceAddrs.toString());
            EventLogTags.writeLockdownVpnConnected(egressType);
            this.showNotification(17040570, 17303157);
            try {
                this.clearSourceRulesLocked();
                this.mNetService.setFirewallInterfaceRule(iface, true);
                for (LinkAddress addr : sourceAddrs) {
                    this.mNetService.setFirewallEgressSourceRule(addr.toString(), true);
                }
                this.mErrorCount = 0;
                this.mAcceptedIface = iface;
                this.mAcceptedSourceAddr = sourceAddrs;
            }
            catch (RemoteException e) {
                throw new RuntimeException("Problem setting firewall rules", e);
            }
            this.mConnService.sendConnectedBroadcast(this.augmentNetworkInfo(egressInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.initLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLocked() {
        Slog.d(TAG, "initLocked()");
        this.mVpn.setEnableNotifications(false);
        this.mVpn.setEnableTeardown(false);
        IntentFilter resetFilter = new IntentFilter(ACTION_LOCKDOWN_RESET);
        this.mContext.registerReceiver(this.mResetReceiver, resetFilter, "android.permission.CONNECTIVITY_INTERNAL", null);
        try {
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 500, true);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 4500, true);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 1701, true);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Problem setting firewall rules", e);
        }
        Object object = this.mStateLock;
        synchronized (object) {
            this.handleStateChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.shutdownLocked();
        }
    }

    private void shutdownLocked() {
        Slog.d(TAG, "shutdownLocked()");
        this.mAcceptedEgressIface = null;
        this.mErrorCount = 0;
        this.mVpn.stopLegacyVpn();
        try {
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 500, false);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 4500, false);
            this.mNetService.setFirewallEgressDestRule(this.mProfile.server, 1701, false);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Problem setting firewall rules", e);
        }
        this.clearSourceRulesLocked();
        this.hideNotification();
        this.mContext.unregisterReceiver(this.mResetReceiver);
        this.mVpn.setEnableNotifications(true);
        this.mVpn.setEnableTeardown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.shutdownLocked();
            this.initLocked();
            this.handleStateChangedLocked();
        }
    }

    private void clearSourceRulesLocked() {
        try {
            if (this.mAcceptedIface != null) {
                this.mNetService.setFirewallInterfaceRule(this.mAcceptedIface, false);
                this.mAcceptedIface = null;
            }
            if (this.mAcceptedSourceAddr != null) {
                for (LinkAddress addr : this.mAcceptedSourceAddr) {
                    this.mNetService.setFirewallEgressSourceRule(addr.toString(), false);
                }
                this.mAcceptedSourceAddr = null;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Problem setting firewall rules", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNetworkInfoChanged(NetworkInfo info) {
        Object object = this.mStateLock;
        synchronized (object) {
            this.handleStateChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVpnStateChanged(NetworkInfo info) {
        if (info.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
            ++this.mErrorCount;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            this.handleStateChangedLocked();
        }
    }

    public NetworkInfo augmentNetworkInfo(NetworkInfo info) {
        if (info.isConnected()) {
            NetworkInfo vpnInfo = this.mVpn.getNetworkInfo();
            info = new NetworkInfo(info);
            info.setDetailedState(vpnInfo.getDetailedState(), vpnInfo.getReason(), null);
        }
        return info;
    }

    private void showNotification(int titleRes, int iconRes) {
        Notification.Builder builder = new Notification.Builder(this.mContext);
        builder.setWhen(0L);
        builder.setSmallIcon(iconRes);
        builder.setContentTitle(this.mContext.getString(titleRes));
        builder.setContentText(this.mContext.getString(17040572));
        builder.setContentIntent(this.mConfigIntent);
        builder.setPriority(-1);
        builder.setOngoing(true);
        builder.addAction(17302364, this.mContext.getString(17040575), this.mResetIntent);
        NotificationManager.from(this.mContext).notify(TAG, 0, builder.build());
    }

    private void hideNotification() {
        NotificationManager.from(this.mContext).cancel(TAG, 0);
    }
}

