/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.IProcessObserver;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.NetworkIdentity;
import android.net.NetworkInfo;
import android.net.NetworkPolicy;
import android.net.NetworkPolicyManager;
import android.net.NetworkQuotaInfo;
import android.net.NetworkState;
import android.net.NetworkTemplate;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.INetworkManagementService;
import android.os.IPowerManager;
import android.os.Message;
import android.os.MessageQueue;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.text.format.Time;
import android.util.AtomicFile;
import android.util.Log;
import android.util.NtpTrustedTime;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.TrustedTime;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.net.BaseNetworkObserver;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NetworkPolicyManagerService
extends INetworkPolicyManager.Stub {
    private static final String TAG = "NetworkPolicy";
    private static final boolean LOGD = false;
    private static final boolean LOGV = false;
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADDED_SNOOZE = 2;
    private static final int VERSION_ADDED_RESTRICT_BACKGROUND = 3;
    private static final int VERSION_ADDED_METERED = 4;
    private static final int VERSION_SPLIT_SNOOZE = 5;
    private static final int VERSION_ADDED_TIMEZONE = 6;
    private static final int VERSION_ADDED_INFERRED = 7;
    private static final int VERSION_SWITCH_APP_ID = 8;
    private static final int VERSION_ADDED_NETWORK_ID = 9;
    private static final int VERSION_SWITCH_UID = 10;
    private static final int VERSION_LATEST = 10;
    public static final int TYPE_WARNING = 1;
    public static final int TYPE_LIMIT = 2;
    public static final int TYPE_LIMIT_SNOOZED = 3;
    private static final String TAG_POLICY_LIST = "policy-list";
    private static final String TAG_NETWORK_POLICY = "network-policy";
    private static final String TAG_UID_POLICY = "uid-policy";
    private static final String TAG_APP_POLICY = "app-policy";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_RESTRICT_BACKGROUND = "restrictBackground";
    private static final String ATTR_NETWORK_TEMPLATE = "networkTemplate";
    private static final String ATTR_SUBSCRIBER_ID = "subscriberId";
    private static final String ATTR_NETWORK_ID = "networkId";
    private static final String ATTR_CYCLE_DAY = "cycleDay";
    private static final String ATTR_CYCLE_TIMEZONE = "cycleTimezone";
    private static final String ATTR_WARNING_BYTES = "warningBytes";
    private static final String ATTR_LIMIT_BYTES = "limitBytes";
    private static final String ATTR_LAST_SNOOZE = "lastSnooze";
    private static final String ATTR_LAST_WARNING_SNOOZE = "lastWarningSnooze";
    private static final String ATTR_LAST_LIMIT_SNOOZE = "lastLimitSnooze";
    private static final String ATTR_METERED = "metered";
    private static final String ATTR_INFERRED = "inferred";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_APP_ID = "appId";
    private static final String ATTR_POLICY = "policy";
    private static final String TAG_ALLOW_BACKGROUND = "NetworkPolicy:allowBackground";
    private static final String ACTION_ALLOW_BACKGROUND = "com.android.server.net.action.ALLOW_BACKGROUND";
    private static final String ACTION_SNOOZE_WARNING = "com.android.server.net.action.SNOOZE_WARNING";
    private static final long TIME_CACHE_MAX_AGE = 86400000L;
    private static final int MSG_RULES_CHANGED = 1;
    private static final int MSG_METERED_IFACES_CHANGED = 2;
    private static final int MSG_FOREGROUND_ACTIVITIES_CHANGED = 3;
    private static final int MSG_PROCESS_DIED = 4;
    private static final int MSG_LIMIT_REACHED = 5;
    private static final int MSG_RESTRICT_BACKGROUND_CHANGED = 6;
    private static final int MSG_ADVISE_PERSIST_THRESHOLD = 7;
    private static final int MSG_SCREEN_ON_CHANGED = 8;
    private final Context mContext;
    private final IActivityManager mActivityManager;
    private final IPowerManager mPowerManager;
    private final INetworkStatsService mNetworkStats;
    private final INetworkManagementService mNetworkManager;
    private final TrustedTime mTime;
    private IConnectivityManager mConnManager;
    private INotificationManager mNotifManager;
    private final Object mRulesLock = new Object();
    private volatile boolean mScreenOn;
    private volatile boolean mRestrictBackground;
    private final boolean mSuppressDefaultPolicy;
    private HashMap<NetworkTemplate, NetworkPolicy> mNetworkPolicy = Maps.newHashMap();
    private HashMap<NetworkPolicy, String[]> mNetworkRules = Maps.newHashMap();
    private SparseIntArray mUidPolicy = new SparseIntArray();
    private SparseIntArray mUidRules = new SparseIntArray();
    private HashSet<String> mMeteredIfaces = Sets.newHashSet();
    private HashSet<NetworkTemplate> mOverLimitNotified = Sets.newHashSet();
    private HashSet<String> mActiveNotifs = Sets.newHashSet();
    private SparseBooleanArray mUidForeground = new SparseBooleanArray();
    private SparseArray<SparseBooleanArray> mUidPidForeground = new SparseArray();
    private final RemoteCallbackList<INetworkPolicyListener> mListeners = new RemoteCallbackList();
    private final Handler mHandler;
    private final AtomicFile mPolicyFile;
    private IProcessObserver mProcessObserver = new IProcessObserver.Stub(){

        public void onForegroundActivitiesChanged(int pid, int uid, boolean foregroundActivities) {
            NetworkPolicyManagerService.this.mHandler.obtainMessage(3, pid, uid, foregroundActivities).sendToTarget();
        }

        public void onImportanceChanged(int pid, int uid, int importance) {
        }

        public void onProcessDied(int pid, int uid) {
            NetworkPolicyManagerService.this.mHandler.obtainMessage(4, pid, uid).sendToTarget();
        }
    };
    private BroadcastReceiver mScreenReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.mHandler.obtainMessage(8).sendToTarget();
        }
    };
    private BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                Object object = NetworkPolicyManagerService.this.mRulesLock;
                synchronized (object) {
                    NetworkPolicyManagerService.this.updateRulesForUidLocked(uid);
                }
            }
        }
    };
    private BroadcastReceiver mUidRemovedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.mUidPolicy.delete(uid);
                NetworkPolicyManagerService.this.updateRulesForUidLocked(uid);
                NetworkPolicyManagerService.this.writePolicyLocked();
            }
        }
    };
    private BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if (userId == -1) {
                return;
            }
            NetworkPolicyManagerService.this.removePoliciesForUserLocked(userId);
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateRulesForRestrictBackgroundLocked();
            }
        }
    };
    private BroadcastReceiver mStatsReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                NetworkPolicyManagerService.this.updateNotificationsLocked();
            }
        }
    };
    private BroadcastReceiver mAllowReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.setRestrictBackground(false);
        }
    };
    private BroadcastReceiver mSnoozeWarningReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkTemplate template = (NetworkTemplate)intent.getParcelableExtra("android.net.NETWORK_TEMPLATE");
            NetworkPolicyManagerService.this.performSnooze(template, 1);
        }
    };
    private BroadcastReceiver mWifiConfigReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            int reason = intent.getIntExtra("changeReason", 0);
            if (reason == 1) {
                WifiConfiguration config = (WifiConfiguration)intent.getParcelableExtra("wifiConfiguration");
                if (config.SSID != null) {
                    NetworkTemplate template = NetworkTemplate.buildTemplateWifi(config.SSID);
                    Object object = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (object) {
                        if (NetworkPolicyManagerService.this.mNetworkPolicy.containsKey(template)) {
                            NetworkPolicyManagerService.this.mNetworkPolicy.remove(template);
                            NetworkPolicyManagerService.this.writePolicyLocked();
                        }
                    }
                }
            }
        }
    };
    private BroadcastReceiver mWifiStateReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            NetworkInfo netInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (!netInfo.isConnected()) {
                return;
            }
            WifiInfo info = (WifiInfo)intent.getParcelableExtra("wifiInfo");
            boolean meteredHint = info.getMeteredHint();
            NetworkTemplate template = NetworkTemplate.buildTemplateWifi(info.getSSID());
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicy policy = (NetworkPolicy)NetworkPolicyManagerService.this.mNetworkPolicy.get(template);
                if (policy == null && meteredHint) {
                    policy = new NetworkPolicy(template, -1, "UTC", -1L, -1L, -1L, -1L, meteredHint, true);
                    NetworkPolicyManagerService.this.addNetworkPolicyLocked(policy);
                } else if (policy != null && policy.inferred) {
                    policy.metered = meteredHint;
                    NetworkPolicyManagerService.this.updateNetworkRulesLocked();
                }
            }
        }
    };
    private INetworkManagementEventObserver mAlertObserver = new BaseNetworkObserver(){

        public void limitReached(String limitName, String iface) {
            NetworkPolicyManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkPolicyManagerService.TAG);
            if (!"globalAlert".equals(limitName)) {
                NetworkPolicyManagerService.this.mHandler.obtainMessage(5, iface).sendToTarget();
            }
        }
    };
    private BroadcastReceiver mConnReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.ensureActiveMobilePolicyLocked();
                NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                NetworkPolicyManagerService.this.updateNetworkRulesLocked();
                NetworkPolicyManagerService.this.updateNotificationsLocked();
            }
        }
    };
    private Handler.Callback mHandlerCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    int uidRules = msg.arg2;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onUidRulesChanged(uid, uidRules);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 2: {
                    String[] meteredIfaces = (String[])msg.obj;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onMeteredIfacesChanged(meteredIfaces);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 3: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    boolean foregroundActivities = (Boolean)msg.obj;
                    Object listener = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (listener) {
                        SparseBooleanArray pidForeground = (SparseBooleanArray)NetworkPolicyManagerService.this.mUidPidForeground.get(uid);
                        if (pidForeground == null) {
                            pidForeground = new SparseBooleanArray(2);
                            NetworkPolicyManagerService.this.mUidPidForeground.put(uid, pidForeground);
                        }
                        pidForeground.put(pid, foregroundActivities);
                        NetworkPolicyManagerService.this.computeUidForegroundLocked(uid);
                    }
                    return true;
                }
                case 4: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    Object foregroundActivities = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (foregroundActivities) {
                        SparseBooleanArray pidForeground = (SparseBooleanArray)NetworkPolicyManagerService.this.mUidPidForeground.get(uid);
                        if (pidForeground != null) {
                            pidForeground.delete(pid);
                            NetworkPolicyManagerService.this.computeUidForegroundLocked(uid);
                        }
                    }
                    return true;
                }
                case 5: {
                    String iface = (String)msg.obj;
                    NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
                    Object uid = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (uid) {
                        if (NetworkPolicyManagerService.this.mMeteredIfaces.contains(iface)) {
                            try {
                                NetworkPolicyManagerService.this.mNetworkStats.forceUpdate();
                            }
                            catch (RemoteException e) {
                                // empty catch block
                            }
                            NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                            NetworkPolicyManagerService.this.updateNotificationsLocked();
                        }
                    }
                    return true;
                }
                case 6: {
                    boolean restrictBackground = msg.arg1 != 0;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onRestrictBackgroundChanged(restrictBackground);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 7: {
                    long lowestRule = (Long)msg.obj;
                    try {
                        long persistThreshold = lowestRule / 1000L;
                        NetworkPolicyManagerService.this.mNetworkStats.advisePersistThreshold(persistThreshold);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    return true;
                }
                case 8: {
                    NetworkPolicyManagerService.this.updateScreenOn();
                    return true;
                }
            }
            return false;
        }
    };

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, IPowerManager powerManager, INetworkStatsService networkStats, INetworkManagementService networkManagement) {
        this(context, activityManager, powerManager, networkStats, networkManagement, NtpTrustedTime.getInstance(context), NetworkPolicyManagerService.getSystemDir(), false);
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, IPowerManager powerManager, INetworkStatsService networkStats, INetworkManagementService networkManagement, TrustedTime time, File systemDir, boolean suppressDefaultPolicy) {
        this.mContext = Preconditions.checkNotNull(context, "missing context");
        this.mActivityManager = Preconditions.checkNotNull(activityManager, "missing activityManager");
        this.mPowerManager = Preconditions.checkNotNull(powerManager, "missing powerManager");
        this.mNetworkStats = Preconditions.checkNotNull(networkStats, "missing networkStats");
        this.mNetworkManager = Preconditions.checkNotNull(networkManagement, "missing networkManagement");
        this.mTime = Preconditions.checkNotNull(time, "missing TrustedTime");
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this.mHandlerCallback);
        this.mSuppressDefaultPolicy = suppressDefaultPolicy;
        this.mPolicyFile = new AtomicFile(new File(systemDir, "netpolicy.xml"));
    }

    public void bindConnectivityManager(IConnectivityManager connManager) {
        this.mConnManager = Preconditions.checkNotNull(connManager, "missing IConnectivityManager");
    }

    public void bindNotificationManager(INotificationManager notifManager) {
        this.mNotifManager = Preconditions.checkNotNull(notifManager, "missing INotificationManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        if (!this.isBandwidthControlEnabled()) {
            Slog.w(TAG, "bandwidth controls disabled, unable to enforce policy");
            return;
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            this.readPolicyLocked();
            if (this.mRestrictBackground) {
                this.updateRulesForRestrictBackgroundLocked();
                this.updateNotificationsLocked();
            }
        }
        this.updateScreenOn();
        try {
            this.mActivityManager.registerProcessObserver(this.mProcessObserver);
            this.mNetworkManager.registerObserver(this.mAlertObserver);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        IntentFilter screenFilter = new IntentFilter();
        screenFilter.addAction("android.intent.action.SCREEN_ON");
        screenFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mContext.registerReceiver(this.mScreenReceiver, screenFilter);
        IntentFilter connFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.mContext.registerReceiver(this.mConnReceiver, connFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addDataScheme("package");
        this.mContext.registerReceiver(this.mPackageReceiver, packageFilter, null, this.mHandler);
        this.mContext.registerReceiver(this.mUidRemovedReceiver, new IntentFilter("android.intent.action.UID_REMOVED"), null, this.mHandler);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_ADDED");
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
        IntentFilter statsFilter = new IntentFilter("com.android.server.action.NETWORK_STATS_UPDATED");
        this.mContext.registerReceiver(this.mStatsReceiver, statsFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
        IntentFilter allowFilter = new IntentFilter(ACTION_ALLOW_BACKGROUND);
        this.mContext.registerReceiver(this.mAllowReceiver, allowFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
        IntentFilter snoozeWarningFilter = new IntentFilter(ACTION_SNOOZE_WARNING);
        this.mContext.registerReceiver(this.mSnoozeWarningReceiver, snoozeWarningFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
        IntentFilter wifiConfigFilter = new IntentFilter("android.net.wifi.CONFIGURED_NETWORKS_CHANGE");
        this.mContext.registerReceiver(this.mWifiConfigReceiver, wifiConfigFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter wifiStateFilter = new IntentFilter("android.net.wifi.STATE_CHANGE");
        this.mContext.registerReceiver(this.mWifiStateReceiver, wifiStateFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
    }

    private void updateNotificationsLocked() {
        HashSet<String> beforeNotifs = Sets.newHashSet();
        beforeNotifs.addAll(this.mActiveNotifs);
        this.mActiveNotifs.clear();
        long currentTime = this.currentTimeMillis();
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            long end;
            if (!this.isTemplateRelevant(policy.template) || !policy.hasCycle()) continue;
            long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            if (policy.isOverLimit(totalBytes)) {
                if (policy.lastLimitSnooze >= start) {
                    this.enqueueNotification(policy, 3, totalBytes);
                    continue;
                }
                this.enqueueNotification(policy, 2, totalBytes);
                this.notifyOverLimitLocked(policy.template);
                continue;
            }
            this.notifyUnderLimitLocked(policy.template);
            if (!policy.isOverWarning(totalBytes) || policy.lastWarningSnooze >= start) continue;
            this.enqueueNotification(policy, 1, totalBytes);
        }
        if (this.mRestrictBackground) {
            this.enqueueRestrictedNotification(TAG_ALLOW_BACKGROUND);
        }
        for (String tag : beforeNotifs) {
            if (this.mActiveNotifs.contains(tag)) continue;
            this.cancelNotification(tag);
        }
    }

    private boolean isTemplateRelevant(NetworkTemplate template) {
        TelephonyManager tele = TelephonyManager.from(this.mContext);
        switch (template.getMatchRule()) {
            case 1: 
            case 2: 
            case 3: {
                if (tele.getSimState() == 5) {
                    return Objects.equals(tele.getSubscriberId(), template.getSubscriberId());
                }
                return false;
            }
        }
        return true;
    }

    private void notifyOverLimitLocked(NetworkTemplate template) {
        if (!this.mOverLimitNotified.contains(template)) {
            this.mContext.startActivity(NetworkPolicyManagerService.buildNetworkOverLimitIntent(template));
            this.mOverLimitNotified.add(template);
        }
    }

    private void notifyUnderLimitLocked(NetworkTemplate template) {
        this.mOverLimitNotified.remove(template);
    }

    private String buildNotificationTag(NetworkPolicy policy, int type) {
        return "NetworkPolicy:" + policy.template.hashCode() + ":" + type;
    }

    private void enqueueNotification(NetworkPolicy policy, int type, long totalBytes) {
        String tag = this.buildNotificationTag(policy, type);
        Notification.Builder builder = new Notification.Builder(this.mContext);
        builder.setOnlyAlertOnce(true);
        builder.setWhen(0L);
        Resources res = this.mContext.getResources();
        switch (type) {
            case 1: {
                CharSequence title = res.getText(17040666);
                String body = res.getString(17040667);
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent snoozeIntent = NetworkPolicyManagerService.buildSnoozeWarningIntent(policy.template);
                builder.setDeleteIntent(PendingIntent.getBroadcast(this.mContext, 0, snoozeIntent, 0x8000000));
                Intent viewIntent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, viewIntent, 0x8000000));
                break;
            }
            case 2: {
                CharSequence title;
                CharSequence body = res.getText(17040672);
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040668);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040669);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040670);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040671);
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setOngoing(true);
                builder.setSmallIcon(17302916);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent intent = NetworkPolicyManagerService.buildNetworkOverLimitIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
            case 3: {
                CharSequence title;
                long overBytes = totalBytes - policy.limitBytes;
                String body = res.getString(17040677, Formatter.formatFileSize(this.mContext, overBytes));
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040673);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040674);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040675);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040676);
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setOngoing(true);
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent intent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
        }
        try {
            String packageName = this.mContext.getPackageName();
            int[] idReceived = new int[1];
            this.mNotifManager.enqueueNotificationWithTag(packageName, packageName, tag, 0, builder.getNotification(), idReceived, 0);
            this.mActiveNotifs.add(tag);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void enqueueRestrictedNotification(String tag) {
        Resources res = this.mContext.getResources();
        Notification.Builder builder = new Notification.Builder(this.mContext);
        CharSequence title = res.getText(17040678);
        String body = res.getString(17040679);
        builder.setOnlyAlertOnce(true);
        builder.setOngoing(true);
        builder.setSmallIcon(17301624);
        builder.setTicker(title);
        builder.setContentTitle(title);
        builder.setContentText(body);
        Intent intent = NetworkPolicyManagerService.buildAllowBackgroundDataIntent();
        builder.setContentIntent(PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000));
        try {
            String packageName = this.mContext.getPackageName();
            int[] idReceived = new int[1];
            this.mNotifManager.enqueueNotificationWithTag(packageName, packageName, tag, 0, builder.getNotification(), idReceived, 0);
            this.mActiveNotifs.add(tag);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void cancelNotification(String tag) {
        try {
            String packageName = this.mContext.getPackageName();
            this.mNotifManager.cancelNotificationWithTag(packageName, tag, 0, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void updateNetworkEnabledLocked() {
        long currentTime = this.currentTimeMillis();
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            long end;
            if (policy.limitBytes == -1L || !policy.hasCycle()) {
                this.setNetworkTemplateEnabled(policy.template, true);
                continue;
            }
            long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            boolean overLimitWithoutSnooze = policy.isOverLimit(totalBytes) && policy.lastLimitSnooze < start;
            boolean networkEnabled = !overLimitWithoutSnooze;
            this.setNetworkTemplateEnabled(policy.template, networkEnabled);
        }
    }

    private void setNetworkTemplateEnabled(NetworkTemplate template, boolean enabled) {
        TelephonyManager tele = TelephonyManager.from(this.mContext);
        switch (template.getMatchRule()) {
            case 1: 
            case 2: 
            case 3: {
                if (tele.getSimState() != 5 || !Objects.equals(tele.getSubscriberId(), template.getSubscriberId())) break;
                this.setPolicyDataEnable(0, enabled);
                this.setPolicyDataEnable(6, enabled);
                break;
            }
            case 4: {
                this.setPolicyDataEnable(1, enabled);
                break;
            }
            case 5: {
                this.setPolicyDataEnable(9, enabled);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected template");
            }
        }
    }

    private void updateNetworkRulesLocked() {
        NetworkIdentity ident;
        NetworkState[] states;
        try {
            states = this.mConnManager.getAllNetworkState();
        }
        catch (RemoteException e) {
            return;
        }
        HashMap<NetworkIdentity, String> networks = Maps.newHashMap();
        for (NetworkState state : states) {
            if (!state.networkInfo.isConnected()) continue;
            String iface = state.linkProperties.getInterfaceName();
            ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
            networks.put(ident, iface);
        }
        this.mNetworkRules.clear();
        ArrayList<String> ifaceList = Lists.newArrayList();
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            ifaceList.clear();
            for (Map.Entry entry : networks.entrySet()) {
                ident = (NetworkIdentity)entry.getKey();
                if (!policy.template.matches(ident)) continue;
                String iface = (String)entry.getValue();
                ifaceList.add(iface);
            }
            if (ifaceList.size() <= 0) continue;
            String[] ifaces = ifaceList.toArray(new String[ifaceList.size()]);
            this.mNetworkRules.put(policy, ifaces);
        }
        long lowestRule = Long.MAX_VALUE;
        HashSet newMeteredIfaces = Sets.newHashSet();
        long currentTime = this.currentTimeMillis();
        for (NetworkPolicy policy : this.mNetworkRules.keySet()) {
            boolean hasLimit;
            long totalBytes;
            long start;
            String[] ifaces = this.mNetworkRules.get(policy);
            if (policy.hasCycle()) {
                start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
                totalBytes = this.getTotalBytes(policy.template, start, currentTime);
            } else {
                start = Long.MAX_VALUE;
                totalBytes = 0L;
            }
            boolean hasWarning = policy.warningBytes != -1L;
            boolean bl = hasLimit = policy.limitBytes != -1L;
            if (hasLimit || policy.metered) {
                long quotaBytes = !hasLimit ? Long.MAX_VALUE : (policy.lastLimitSnooze >= start ? Long.MAX_VALUE : Math.max(1L, policy.limitBytes - totalBytes));
                if (ifaces.length > 1) {
                    Slog.w(TAG, "shared quota unsupported; generating rule for each iface");
                }
                for (String iface : ifaces) {
                    this.removeInterfaceQuota(iface);
                    this.setInterfaceQuota(iface, quotaBytes);
                    newMeteredIfaces.add(iface);
                }
            }
            if (hasWarning && policy.warningBytes < lowestRule) {
                lowestRule = policy.warningBytes;
            }
            if (!hasLimit || policy.limitBytes >= lowestRule) continue;
            lowestRule = policy.limitBytes;
        }
        this.mHandler.obtainMessage(7, lowestRule).sendToTarget();
        for (String iface : this.mMeteredIfaces) {
            if (newMeteredIfaces.contains(iface)) continue;
            this.removeInterfaceQuota(iface);
        }
        this.mMeteredIfaces = newMeteredIfaces;
        String[] meteredIfaces = this.mMeteredIfaces.toArray(new String[this.mMeteredIfaces.size()]);
        this.mHandler.obtainMessage(2, meteredIfaces).sendToTarget();
    }

    private void ensureActiveMobilePolicyLocked() {
        if (this.mSuppressDefaultPolicy) {
            return;
        }
        TelephonyManager tele = TelephonyManager.from(this.mContext);
        if (tele.getSimState() != 5) {
            return;
        }
        String subscriberId = tele.getSubscriberId();
        NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false);
        boolean mobileDefined = false;
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            if (!policy.template.matches(probeIdent)) continue;
            mobileDefined = true;
        }
        if (!mobileDefined) {
            Slog.i(TAG, "no policy for active mobile network; generating default policy");
            long warningBytes = (long)this.mContext.getResources().getInteger(17694785) * 0x100000L;
            Time time = new Time();
            time.setToNow();
            int cycleDay = time.monthDay;
            String cycleTimezone = time.timezone;
            NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll(subscriberId);
            NetworkPolicy policy = new NetworkPolicy(template, cycleDay, cycleTimezone, warningBytes, -1L, -1L, -1L, true, true);
            this.addNetworkPolicyLocked(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPolicyLocked() {
        this.mNetworkPolicy.clear();
        this.mUidPolicy.clear();
        FileInputStream fis = null;
        try {
            try {
                int type;
                fis = this.mPolicyFile.openRead();
                XmlPullParser in = Xml.newPullParser();
                in.setInput(fis, null);
                int version = 1;
                while ((type = in.next()) != 1) {
                    String tag = in.getName();
                    if (type != 2) continue;
                    if (TAG_POLICY_LIST.equals(tag)) {
                        version = XmlUtils.readIntAttribute(in, ATTR_VERSION);
                        if (version >= 3) {
                            this.mRestrictBackground = XmlUtils.readBooleanAttribute(in, ATTR_RESTRICT_BACKGROUND);
                            continue;
                        }
                        this.mRestrictBackground = false;
                        continue;
                    }
                    if (TAG_NETWORK_POLICY.equals(tag)) {
                        boolean metered;
                        int networkTemplate = XmlUtils.readIntAttribute(in, ATTR_NETWORK_TEMPLATE);
                        String subscriberId = in.getAttributeValue(null, ATTR_SUBSCRIBER_ID);
                        String networkId = version >= 9 ? in.getAttributeValue(null, ATTR_NETWORK_ID) : null;
                        int cycleDay = XmlUtils.readIntAttribute(in, ATTR_CYCLE_DAY);
                        String cycleTimezone = version >= 6 ? in.getAttributeValue(null, ATTR_CYCLE_TIMEZONE) : "UTC";
                        long warningBytes = XmlUtils.readLongAttribute(in, ATTR_WARNING_BYTES);
                        long limitBytes = XmlUtils.readLongAttribute(in, ATTR_LIMIT_BYTES);
                        long lastLimitSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_LIMIT_SNOOZE) : (version >= 2 ? XmlUtils.readLongAttribute(in, ATTR_LAST_SNOOZE) : -1L);
                        if (version >= 4) {
                            metered = XmlUtils.readBooleanAttribute(in, ATTR_METERED);
                        } else {
                            switch (networkTemplate) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    metered = true;
                                    break;
                                }
                                default: {
                                    metered = false;
                                }
                            }
                        }
                        long lastWarningSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_WARNING_SNOOZE) : -1L;
                        boolean inferred = version >= 7 ? XmlUtils.readBooleanAttribute(in, ATTR_INFERRED) : false;
                        NetworkTemplate template = new NetworkTemplate(networkTemplate, subscriberId, networkId);
                        this.mNetworkPolicy.put(template, new NetworkPolicy(template, cycleDay, cycleTimezone, warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, metered, inferred));
                        continue;
                    }
                    if (TAG_UID_POLICY.equals(tag)) {
                        int uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                        int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                        if (UserHandle.isApp(uid)) {
                            this.setUidPolicyUnchecked(uid, policy, false);
                            continue;
                        }
                        Slog.w(TAG, "unable to apply policy to UID " + uid + "; ignoring");
                        continue;
                    }
                    if (!TAG_APP_POLICY.equals(tag)) continue;
                    int appId = XmlUtils.readIntAttribute(in, ATTR_APP_ID);
                    int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                    int uid = UserHandle.getUid(0, appId);
                    if (UserHandle.isApp(uid)) {
                        this.setUidPolicyUnchecked(uid, policy, false);
                        continue;
                    }
                    Slog.w(TAG, "unable to apply policy to UID " + uid + "; ignoring");
                }
                Object var23_24 = null;
            }
            catch (FileNotFoundException e) {
                this.upgradeLegacyBackgroundData();
                Object var23_25 = null;
                IoUtils.closeQuietly(fis);
                return;
            }
            catch (IOException e) {
                Log.wtf(TAG, "problem reading network policy", e);
                Object var23_26 = null;
                IoUtils.closeQuietly(fis);
                return;
            }
            catch (XmlPullParserException e) {
                Log.wtf(TAG, "problem reading network policy", e);
                Object var23_27 = null;
                IoUtils.closeQuietly(fis);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var23_28 = null;
            IoUtils.closeQuietly(fis);
            throw throwable;
        }
        IoUtils.closeQuietly(fis);
    }

    private void upgradeLegacyBackgroundData() {
        boolean bl = this.mRestrictBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "background_data", 1) != 1;
        if (this.mRestrictBackground) {
            Intent broadcast = new Intent("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED");
            this.mContext.sendBroadcastAsUser(broadcast, UserHandle.ALL);
        }
    }

    private void writePolicyLocked() {
        block6: {
            FileOutputStream fos = null;
            try {
                fos = this.mPolicyFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                out.startDocument(null, true);
                out.startTag(null, TAG_POLICY_LIST);
                XmlUtils.writeIntAttribute(out, ATTR_VERSION, 10);
                XmlUtils.writeBooleanAttribute(out, ATTR_RESTRICT_BACKGROUND, this.mRestrictBackground);
                for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
                    String networkId;
                    NetworkTemplate template = policy.template;
                    out.startTag(null, TAG_NETWORK_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_NETWORK_TEMPLATE, template.getMatchRule());
                    String subscriberId = template.getSubscriberId();
                    if (subscriberId != null) {
                        out.attribute(null, ATTR_SUBSCRIBER_ID, subscriberId);
                    }
                    if ((networkId = template.getNetworkId()) != null) {
                        out.attribute(null, ATTR_NETWORK_ID, networkId);
                    }
                    XmlUtils.writeIntAttribute(out, ATTR_CYCLE_DAY, policy.cycleDay);
                    out.attribute(null, ATTR_CYCLE_TIMEZONE, policy.cycleTimezone);
                    XmlUtils.writeLongAttribute(out, ATTR_WARNING_BYTES, policy.warningBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LIMIT_BYTES, policy.limitBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_WARNING_SNOOZE, policy.lastWarningSnooze);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_LIMIT_SNOOZE, policy.lastLimitSnooze);
                    XmlUtils.writeBooleanAttribute(out, ATTR_METERED, policy.metered);
                    XmlUtils.writeBooleanAttribute(out, ATTR_INFERRED, policy.inferred);
                    out.endTag(null, TAG_NETWORK_POLICY);
                }
                for (int i = 0; i < this.mUidPolicy.size(); ++i) {
                    int uid = this.mUidPolicy.keyAt(i);
                    int policy = this.mUidPolicy.valueAt(i);
                    if (policy == 0) continue;
                    out.startTag(null, TAG_UID_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_UID, uid);
                    XmlUtils.writeIntAttribute(out, ATTR_POLICY, policy);
                    out.endTag(null, TAG_UID_POLICY);
                }
                out.endTag(null, TAG_POLICY_LIST);
                out.endDocument();
                this.mPolicyFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block6;
                this.mPolicyFile.failWrite(fos);
            }
        }
    }

    public void setUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        this.setUidPolicyUnchecked(uid, policy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUidPolicyUnchecked(int uid, int policy, boolean persist) {
        Object object = this.mRulesLock;
        synchronized (object) {
            int oldPolicy = this.getUidPolicy(uid);
            this.mUidPolicy.put(uid, policy);
            this.updateRulesForUidLocked(uid);
            if (persist) {
                this.writePolicyLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUidPolicy(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mUidPolicy.get(uid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUidsWithPolicy(int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        int[] uids = new int[]{};
        Object object = this.mRulesLock;
        synchronized (object) {
            for (int i = 0; i < this.mUidPolicy.size(); ++i) {
                int uid = this.mUidPolicy.keyAt(i);
                int uidPolicy = this.mUidPolicy.valueAt(i);
                if (uidPolicy != policy) continue;
                uids = ArrayUtils.appendInt(uids, uid);
            }
        }
        return uids;
    }

    private void removePoliciesForUserLocked(int userId) {
        int[] uids = new int[]{};
        for (int i = 0; i < this.mUidPolicy.size(); ++i) {
            int uid = this.mUidPolicy.keyAt(i);
            if (UserHandle.getUserId(uid) != userId) continue;
            uids = ArrayUtils.appendInt(uids, uid);
        }
        if (uids.length > 0) {
            for (int uid : uids) {
                this.mUidPolicy.delete(uid);
                this.updateRulesForUidLocked(uid);
            }
            this.writePolicyLocked();
        }
    }

    public void registerListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.register(listener);
    }

    public void unregisterListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkPolicies(NetworkPolicy[] policies) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.maybeRefreshTrustedTime();
        Object object = this.mRulesLock;
        synchronized (object) {
            this.mNetworkPolicy.clear();
            for (NetworkPolicy policy : policies) {
                this.mNetworkPolicy.put(policy.template, policy);
            }
            this.updateNetworkEnabledLocked();
            this.updateNetworkRulesLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
    }

    private void addNetworkPolicyLocked(NetworkPolicy policy) {
        this.mNetworkPolicy.put(policy.template, policy);
        this.updateNetworkEnabledLocked();
        this.updateNetworkRulesLocked();
        this.updateNotificationsLocked();
        this.writePolicyLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkPolicy[] getNetworkPolicies() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mNetworkPolicy.values().toArray(new NetworkPolicy[this.mNetworkPolicy.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snoozeLimit(NetworkTemplate template) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            this.performSnooze(template, 2);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSnooze(NetworkTemplate template, int type) {
        this.maybeRefreshTrustedTime();
        long currentTime = this.currentTimeMillis();
        Object object = this.mRulesLock;
        synchronized (object) {
            NetworkPolicy policy = this.mNetworkPolicy.get(template);
            if (policy == null) {
                throw new IllegalArgumentException("unable to find policy for " + template);
            }
            switch (type) {
                case 1: {
                    policy.lastWarningSnooze = currentTime;
                    break;
                }
                case 2: {
                    policy.lastLimitSnooze = currentTime;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected type");
                }
            }
            this.updateNetworkEnabledLocked();
            this.updateNetworkRulesLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestrictBackground(boolean restrictBackground) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.maybeRefreshTrustedTime();
        Object object = this.mRulesLock;
        synchronized (object) {
            this.mRestrictBackground = restrictBackground;
            this.updateRulesForRestrictBackgroundLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
        this.mHandler.obtainMessage(6, restrictBackground ? 1 : 0, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRestrictBackground() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mRestrictBackground;
        }
    }

    private NetworkPolicy findPolicyForNetworkLocked(NetworkIdentity ident) {
        for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
            if (!policy.template.matches(ident)) continue;
            return policy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkQuotaInfo getNetworkQuotaInfo(NetworkState state) {
        NetworkQuotaInfo networkQuotaInfo;
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            networkQuotaInfo = this.getNetworkQuotaInfoUnchecked(state);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
        return networkQuotaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkQuotaInfo getNetworkQuotaInfoUnchecked(NetworkState state) {
        NetworkPolicy policy;
        NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
        Object object = this.mRulesLock;
        synchronized (object) {
            policy = this.findPolicyForNetworkLocked(ident);
        }
        if (policy == null || !policy.hasCycle()) {
            return null;
        }
        long currentTime = this.currentTimeMillis();
        long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
        long end = currentTime;
        long totalBytes = this.getTotalBytes(policy.template, start, end);
        long softLimitBytes = policy.warningBytes != -1L ? policy.warningBytes : -1L;
        long hardLimitBytes = policy.limitBytes != -1L ? policy.limitBytes : -1L;
        return new NetworkQuotaInfo(totalBytes, softLimitBytes, hardLimitBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNetworkMetered(NetworkState state) {
        NetworkPolicy policy;
        NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
        if (ident.getRoaming()) {
            return true;
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            policy = this.findPolicyForNetworkLocked(ident);
        }
        if (policy != null) {
            return policy.metered;
        }
        int type = state.networkInfo.getType();
        return ConnectivityManager.isNetworkTypeMobile(type) || type == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        IndentingPrintWriter fout = new IndentingPrintWriter((Writer)writer, "  ");
        HashSet<String> argSet = new HashSet<String>();
        for (String arg : args) {
            argSet.add(arg);
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            if (argSet.contains("--unsnooze")) {
                for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
                    policy.clearSnooze();
                }
                this.updateNetworkEnabledLocked();
                this.updateNetworkRulesLocked();
                this.updateNotificationsLocked();
                this.writePolicyLocked();
                fout.println("Cleared snooze timestamps");
                return;
            }
            fout.print("Restrict background: ");
            fout.println(this.mRestrictBackground);
            fout.println("Network policies:");
            fout.increaseIndent();
            for (NetworkPolicy policy : this.mNetworkPolicy.values()) {
                fout.println(policy.toString());
            }
            fout.decreaseIndent();
            fout.println("Policy for UIDs:");
            fout.increaseIndent();
            int size = this.mUidPolicy.size();
            for (int i = 0; i < size; ++i) {
                int uid = this.mUidPolicy.keyAt(i);
                int policy = this.mUidPolicy.valueAt(i);
                fout.print("UID=");
                fout.print(uid);
                fout.print(" policy=");
                NetworkPolicyManager.dumpPolicy(fout, policy);
                fout.println();
            }
            fout.decreaseIndent();
            SparseBooleanArray knownUids = new SparseBooleanArray();
            NetworkPolicyManagerService.collectKeys(this.mUidForeground, knownUids);
            NetworkPolicyManagerService.collectKeys(this.mUidRules, knownUids);
            fout.println("Status for known UIDs:");
            fout.increaseIndent();
            size = knownUids.size();
            for (int i = 0; i < size; ++i) {
                int uid = knownUids.keyAt(i);
                fout.print("UID=");
                fout.print(uid);
                fout.print(" foreground=");
                int foregroundIndex = this.mUidPidForeground.indexOfKey(uid);
                if (foregroundIndex < 0) {
                    fout.print("UNKNOWN");
                } else {
                    NetworkPolicyManagerService.dumpSparseBooleanArray(fout, this.mUidPidForeground.valueAt(foregroundIndex));
                }
                fout.print(" rules=");
                int rulesIndex = this.mUidRules.indexOfKey(uid);
                if (rulesIndex < 0) {
                    fout.print("UNKNOWN");
                } else {
                    NetworkPolicyManager.dumpRules(fout, this.mUidRules.valueAt(rulesIndex));
                }
                fout.println();
            }
            fout.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUidForeground(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mUidForeground.get(uid, false) && this.mScreenOn;
        }
    }

    private void computeUidForegroundLocked(int uid) {
        boolean oldUidForeground;
        SparseBooleanArray pidForeground = this.mUidPidForeground.get(uid);
        boolean uidForeground = false;
        int size = pidForeground.size();
        for (int i = 0; i < size; ++i) {
            if (!pidForeground.valueAt(i)) continue;
            uidForeground = true;
            break;
        }
        if ((oldUidForeground = this.mUidForeground.get(uid, false)) != uidForeground) {
            this.mUidForeground.put(uid, uidForeground);
            this.updateRulesForUidLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScreenOn() {
        Object object = this.mRulesLock;
        synchronized (object) {
            try {
                this.mScreenOn = this.mPowerManager.isScreenOn();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.updateRulesForScreenLocked();
        }
    }

    private void updateRulesForScreenLocked() {
        int size = this.mUidForeground.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mUidForeground.valueAt(i)) continue;
            int uid = this.mUidForeground.keyAt(i);
            this.updateRulesForUidLocked(uid);
        }
    }

    private void updateRulesForRestrictBackgroundLocked() {
        PackageManager pm = this.mContext.getPackageManager();
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        List<UserInfo> users = um.getUsers();
        List<ApplicationInfo> apps = pm.getInstalledApplications(8704);
        for (UserInfo user : users) {
            for (ApplicationInfo app : apps) {
                int uid = UserHandle.getUid(user.id, app.uid);
                this.updateRulesForUidLocked(uid);
            }
        }
        this.updateRulesForUidLocked(1013);
        this.updateRulesForUidLocked(1019);
    }

    private static boolean isUidValidForRules(int uid) {
        return uid == 1013 || uid == 1019 || UserHandle.isApp(uid);
    }

    private void updateRulesForUidLocked(int uid) {
        if (!NetworkPolicyManagerService.isUidValidForRules(uid)) {
            return;
        }
        int uidPolicy = this.getUidPolicy(uid);
        boolean uidForeground = this.isUidForeground(uid);
        int uidRules = 0;
        if (!uidForeground && (uidPolicy & 1) != 0) {
            uidRules = 1;
        }
        if (!uidForeground && this.mRestrictBackground) {
            uidRules = 1;
        }
        if (uidRules == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, uidRules);
        }
        boolean rejectMetered = (uidRules & 1) != 0;
        this.setUidNetworkRules(uid, rejectMetered);
        this.mHandler.obtainMessage(1, uid, uidRules).sendToTarget();
        try {
            this.mNetworkStats.setUidForeground(uid, uidForeground);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void setInterfaceQuota(String iface, long quotaBytes) {
        try {
            this.mNetworkManager.setInterfaceQuota(iface, quotaBytes);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting interface quota", e);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void removeInterfaceQuota(String iface) {
        try {
            this.mNetworkManager.removeInterfaceQuota(iface);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem removing interface quota", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setUidNetworkRules(int uid, boolean rejectOnQuotaInterfaces) {
        try {
            this.mNetworkManager.setUidNetworkRules(uid, rejectOnQuotaInterfaces);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting uid rules", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setPolicyDataEnable(int networkType, boolean enabled) {
        try {
            this.mConnManager.setPolicyDataEnable(networkType, enabled);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private long getTotalBytes(NetworkTemplate template, long start, long end) {
        try {
            return this.mNetworkStats.getNetworkTotalBytes(template, start, end);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "problem reading network stats: " + e);
            return 0L;
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBandwidthControlEnabled() {
        boolean bl;
        long token = Binder.clearCallingIdentity();
        try {
            bl = this.mNetworkManager.isBandwidthControlEnabled();
            Object var6_4 = null;
        }
        catch (RemoteException e) {
            boolean bl2;
            try {
                bl2 = false;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            return bl2;
        }
        Binder.restoreCallingIdentity(token);
        return bl;
    }

    private void maybeRefreshTrustedTime() {
        if (this.mTime.getCacheAge() > 86400000L) {
            this.mTime.forceRefresh();
        }
    }

    private long currentTimeMillis() {
        return this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
    }

    private static Intent buildAllowBackgroundDataIntent() {
        return new Intent(ACTION_ALLOW_BACKGROUND);
    }

    private static Intent buildSnoozeWarningIntent(NetworkTemplate template) {
        Intent intent = new Intent(ACTION_SNOOZE_WARNING);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildNetworkOverLimitIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.net.NetworkOverLimitActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildViewDataUsageIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.settings", "com.android.settings.Settings$DataUsageSummaryActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    public void addIdleHandler(MessageQueue.IdleHandler handler) {
        this.mHandler.getLooper().getQueue().addIdleHandler(handler);
    }

    private static void collectKeys(SparseIntArray source, SparseBooleanArray target) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            target.put(source.keyAt(i), true);
        }
    }

    private static void collectKeys(SparseBooleanArray source, SparseBooleanArray target) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            target.put(source.keyAt(i), true);
        }
    }

    private static void dumpSparseBooleanArray(PrintWriter fout, SparseBooleanArray value) {
        fout.print("[");
        int size = value.size();
        for (int i = 0; i < size; ++i) {
            fout.print(value.keyAt(i) + "=" + value.valueAt(i));
            if (i >= size - 1) continue;
            fout.print(",");
        }
        fout.print("]");
    }
}

