/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.SparseBooleanArray;
import com.android.server.pm.PackageManagerService;

class PackageVerificationState {
    private final PackageManagerService.InstallArgs mArgs;
    private final SparseBooleanArray mSufficientVerifierUids;
    private final int mRequiredVerifierUid;
    private boolean mSufficientVerificationComplete;
    private boolean mSufficientVerificationPassed;
    private boolean mRequiredVerificationComplete;
    private boolean mRequiredVerificationPassed;
    private boolean mExtendedTimeout;

    public PackageVerificationState(int requiredVerifierUid, PackageManagerService.InstallArgs args) {
        this.mRequiredVerifierUid = requiredVerifierUid;
        this.mArgs = args;
        this.mSufficientVerifierUids = new SparseBooleanArray();
        this.mExtendedTimeout = false;
    }

    public PackageManagerService.InstallArgs getInstallArgs() {
        return this.mArgs;
    }

    public void addSufficientVerifier(int uid) {
        this.mSufficientVerifierUids.put(uid, true);
    }

    public boolean setVerifierResponse(int uid, int code) {
        if (uid == this.mRequiredVerifierUid) {
            this.mRequiredVerificationComplete = true;
            switch (code) {
                case 2: {
                    this.mSufficientVerifierUids.clear();
                }
                case 1: {
                    this.mRequiredVerificationPassed = true;
                    break;
                }
                default: {
                    this.mRequiredVerificationPassed = false;
                }
            }
            return true;
        }
        if (this.mSufficientVerifierUids.get(uid)) {
            if (code == 1) {
                this.mSufficientVerificationComplete = true;
                this.mSufficientVerificationPassed = true;
            }
            this.mSufficientVerifierUids.delete(uid);
            if (this.mSufficientVerifierUids.size() == 0) {
                this.mSufficientVerificationComplete = true;
            }
            return true;
        }
        return false;
    }

    public boolean isVerificationComplete() {
        if (!this.mRequiredVerificationComplete) {
            return false;
        }
        if (this.mSufficientVerifierUids.size() == 0) {
            return true;
        }
        return this.mSufficientVerificationComplete;
    }

    public boolean isInstallAllowed() {
        if (!this.mRequiredVerificationPassed) {
            return false;
        }
        if (this.mSufficientVerificationComplete) {
            return this.mSufficientVerificationPassed;
        }
        return true;
    }

    public void extendTimeout() {
        if (!this.mExtendedTimeout) {
            this.mExtendedTimeout = true;
        }
    }

    public boolean timeoutExtended() {
        return this.mExtendedTimeout;
    }
}

