/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.os.Environment;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SELinuxMMAC {
    private static final String TAG = "SELinuxMMAC";
    private static final boolean DEBUG_POLICY = false;
    private static final boolean DEBUG_POLICY_INSTALL = false;
    private static HashMap<Signature, Policy> sSigSeinfo = new HashMap();
    private static String sDefaultSeinfo = null;
    private static final File[] INSTALL_POLICY_FILE = new File[]{new File(Environment.getDataDirectory(), "security/mac_permissions.xml"), new File(Environment.getRootDirectory(), "etc/security/mac_permissions.xml"), null};

    private static void flushInstallPolicy() {
        sSigSeinfo.clear();
        sDefaultSeinfo = null;
    }

    public static boolean readInstallPolicy() {
        return SELinuxMMAC.readInstallPolicy(INSTALL_POLICY_FILE);
    }

    public static boolean readInstallPolicy(File policyFile) {
        return SELinuxMMAC.readInstallPolicy(new File[]{policyFile, null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean readInstallPolicy(File[] policyFiles) {
        String defaultSeinfo;
        HashMap<Signature, Policy> sigSeinfo;
        block23: {
            sigSeinfo = new HashMap<Signature, Policy>();
            defaultSeinfo = null;
            FileReader policyFile = null;
            int i = 0;
            while (policyFile == null && policyFiles != null && policyFiles[i] != null) {
                try {
                    policyFile = new FileReader(policyFiles[i]);
                    break;
                }
                catch (FileNotFoundException e) {
                    Slog.d(TAG, "Couldn't find install policy " + policyFiles[i].getPath());
                    ++i;
                }
            }
            if (policyFile == null) {
                Slog.d(TAG, "No policy file found. All seinfo values will be null.");
                return false;
            }
            Slog.d(TAG, "Using install policy file " + policyFiles[i].getPath());
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(policyFile);
            XmlUtils.beginDocument(parser, "policy");
            while (true) {
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) break;
                String tagName = parser.getName();
                if ("signer".equals(tagName)) {
                    Signature signature;
                    String cert = parser.getAttributeValue(null, "signature");
                    if (cert == null) {
                        Slog.w(TAG, "<signer> without signature at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    try {
                        signature = new Signature(cert);
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w(TAG, "<signer> with bad signature at " + parser.getPositionDescription(), e);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    Policy policy = SELinuxMMAC.readPolicyTags(parser);
                    if (!policy.isValid()) continue;
                    sigSeinfo.put(signature, policy);
                    continue;
                }
                if ("default".equals(tagName)) {
                    defaultSeinfo = SELinuxMMAC.readSeinfoTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
            }
            Object var11_16 = null;
            try {
                policyFile.close();
            }
            catch (IOException e2) {}
            break block23;
            {
                catch (XmlPullParserException e) {
                    Slog.w(TAG, "Got exception parsing ", e);
                    boolean bl = false;
                    Object var11_17 = null;
                    try {
                        policyFile.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (IOException e) {
                    boolean bl;
                    try {
                        Slog.w(TAG, "Got exception parsing ", e);
                        bl = false;
                        Object var11_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_19 = null;
                        try {
                            policyFile.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        policyFile.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
        }
        SELinuxMMAC.flushInstallPolicy();
        sSigSeinfo = sigSeinfo;
        sDefaultSeinfo = defaultSeinfo;
        return true;
    }

    private static Policy readPolicyTags(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        Policy policy = new Policy();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = SELinuxMMAC.parseSeinfo(parser);
                if (seinfo != null) {
                    policy.putSeinfo(seinfo);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if ("package".equals(tagName)) {
                String pkg = parser.getAttributeValue(null, "name");
                if (!SELinuxMMAC.validatePackageName(pkg)) {
                    Slog.w(TAG, "<package> without valid name at " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String seinfo = SELinuxMMAC.readSeinfoTag(parser);
                if (seinfo == null) continue;
                policy.putPkg(pkg, seinfo);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return policy;
    }

    private static String readSeinfoTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        String seinfo = null;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                seinfo = SELinuxMMAC.parseSeinfo(parser);
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return seinfo;
    }

    private static String parseSeinfo(XmlPullParser parser) {
        String seinfoValue = parser.getAttributeValue(null, "value");
        if (!SELinuxMMAC.validateValue(seinfoValue)) {
            Slog.w(TAG, "<seinfo> without valid value at " + parser.getPositionDescription());
            seinfoValue = null;
        }
        return seinfoValue;
    }

    private static boolean validatePackageName(String name) {
        if (name == null) {
            return false;
        }
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return false;
        }
        return hasSep;
    }

    private static boolean validateValue(String name) {
        if (name == null) {
            return false;
        }
        int N = name.length();
        if (N == 0) {
            return false;
        }
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean assignSeinfoValue(PackageParser.Package pkg) {
        if ((pkg.applicationInfo.flags & 1) != 0 || (pkg.applicationInfo.flags & 0x80) != 0) {
            for (Signature s : pkg.mSignatures) {
                String seinfo;
                Policy policy;
                if (s == null || (policy = sSigSeinfo.get(s)) == null || (seinfo = policy.checkPolicy(pkg.packageName)) == null) continue;
                pkg.applicationInfo.seinfo = seinfo;
                return true;
            }
        }
        pkg.applicationInfo.seinfo = sDefaultSeinfo;
        return sDefaultSeinfo != null;
    }

    static class Policy {
        private String seinfo = null;
        private final HashMap<String, String> pkgMap = new HashMap();

        Policy() {
        }

        void putSeinfo(String seinfoValue) {
            this.seinfo = seinfoValue;
        }

        void putPkg(String pkg, String seinfoValue) {
            this.pkgMap.put(pkg, seinfoValue);
        }

        boolean isValid() {
            return this.seinfo != null || !this.pkgMap.isEmpty();
        }

        String checkPolicy(String pkgName) {
            String seinfoValue = this.pkgMap.get(pkgName);
            if (seinfoValue != null) {
                return seinfoValue;
            }
            return this.seinfo;
        }
    }
}

