/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.usb.UsbSettingsManager;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;

public class UsbHostManager {
    private static final String TAG = UsbHostManager.class.getSimpleName();
    private static final boolean LOG = false;
    private final HashMap<String, UsbDevice> mDevices = new HashMap();
    private final String[] mHostBlacklist;
    private final Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private UsbSettingsManager mCurrentSettings;

    public UsbHostManager(Context context) {
        this.mContext = context;
        this.mHostBlacklist = context.getResources().getStringArray(0x1070017);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSettings(UsbSettingsManager settings) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentSettings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbSettingsManager getCurrentSettings() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentSettings;
        }
    }

    private boolean isBlackListed(String deviceName) {
        int count = this.mHostBlacklist.length;
        for (int i = 0; i < count; ++i) {
            if (!deviceName.startsWith(this.mHostBlacklist[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isBlackListed(int clazz, int subClass, int protocol) {
        if (clazz == 9) {
            return true;
        }
        return clazz == 3 && subClass == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usbDeviceAdded(String deviceName, int vendorID, int productID, int deviceClass, int deviceSubclass, int deviceProtocol, String manufacturerName, String productName, String serialNumber, int[] interfaceValues, int[] endpointValues) {
        if (this.isBlackListed(deviceName) || this.isBlackListed(deviceClass, deviceSubclass, deviceProtocol)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDevices.get(deviceName) != null) {
                Slog.w(TAG, "device already on mDevices list: " + deviceName);
                return;
            }
            int numInterfaces = interfaceValues.length / 5;
            Parcelable[] interfaces = new UsbInterface[numInterfaces];
            try {
                int ival = 0;
                int eval = 0;
                for (int intf = 0; intf < numInterfaces; ++intf) {
                    int interfaceId = interfaceValues[ival++];
                    int interfaceClass = interfaceValues[ival++];
                    int interfaceSubclass = interfaceValues[ival++];
                    int interfaceProtocol = interfaceValues[ival++];
                    int numEndpoints = interfaceValues[ival++];
                    Parcelable[] endpoints = new UsbEndpoint[numEndpoints];
                    for (int endp = 0; endp < numEndpoints; ++endp) {
                        int address = endpointValues[eval++];
                        int attributes = endpointValues[eval++];
                        int maxPacketSize = endpointValues[eval++];
                        int interval = endpointValues[eval++];
                        endpoints[endp] = new UsbEndpoint(address, attributes, maxPacketSize, interval);
                    }
                    if (this.isBlackListed(interfaceClass, interfaceSubclass, interfaceProtocol)) {
                        return;
                    }
                    interfaces[intf] = new UsbInterface(interfaceId, interfaceClass, interfaceSubclass, interfaceProtocol, endpoints);
                }
            }
            catch (Exception e) {
                Slog.e(TAG, "error parsing USB descriptors", e);
                return;
            }
            UsbDevice device = new UsbDevice(deviceName, vendorID, productID, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber, interfaces);
            this.mDevices.put(deviceName, device);
            this.getCurrentSettings().deviceAttached(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usbDeviceRemoved(String deviceName) {
        Object object = this.mLock;
        synchronized (object) {
            UsbDevice device = this.mDevices.remove(deviceName);
            if (device != null) {
                this.getCurrentSettings().deviceDetached(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            Runnable runnable = new Runnable(){

                public void run() {
                    UsbHostManager.this.monitorUsbHostBus();
                }
            };
            new Thread(null, runnable, "UsbService host thread").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDeviceList(Bundle devices) {
        Object object = this.mLock;
        synchronized (object) {
            for (String name : this.mDevices.keySet()) {
                devices.putParcelable(name, this.mDevices.get(name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor openDevice(String deviceName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBlackListed(deviceName)) {
                throw new SecurityException("USB device is on a restricted bus");
            }
            UsbDevice device = this.mDevices.get(deviceName);
            if (device == null) {
                throw new IllegalArgumentException("device " + deviceName + " does not exist or is restricted");
            }
            this.getCurrentSettings().checkPermission(device);
            return this.nativeOpenDevice(deviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("  USB Host State:");
            for (String name : this.mDevices.keySet()) {
                pw.println("    " + name + ": " + this.mDevices.get(name));
            }
        }
    }

    private native void monitorUsbHostBus();

    private native ParcelFileDescriptor nativeOpenDevice(String var1);
}

