/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.os.Binder;
import android.os.Environment;
import android.os.UserHandle;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.Xml;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UsbSettingsManager {
    private static final String TAG = "UsbSettingsManager";
    private static final boolean DEBUG = false;
    private static final File sSingleUserSettingsFile = new File("/data/system/usb_device_manager.xml");
    private final UserHandle mUser;
    private final AtomicFile mSettingsFile;
    private final Context mContext;
    private final Context mUserContext;
    private final PackageManager mPackageManager;
    private final HashMap<String, SparseBooleanArray> mDevicePermissionMap = new HashMap();
    private final HashMap<UsbAccessory, SparseBooleanArray> mAccessoryPermissionMap = new HashMap();
    private final HashMap<DeviceFilter, String> mDevicePreferenceMap = new HashMap();
    private final HashMap<AccessoryFilter, String> mAccessoryPreferenceMap = new HashMap();
    private final Object mLock = new Object();
    MyPackageMonitor mPackageMonitor = new MyPackageMonitor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbSettingsManager(Context context, UserHandle user) {
        try {
            this.mUserContext = context.createPackageContextAsUser("android", 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Missing android package");
        }
        this.mContext = context;
        this.mPackageManager = this.mUserContext.getPackageManager();
        this.mUser = user;
        this.mSettingsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(user.getIdentifier()), "usb_device_manager.xml"));
        Object object = this.mLock;
        synchronized (object) {
            if (UserHandle.OWNER.equals(user)) {
                this.upgradeSingleUserLocked();
            }
            this.readSettingsLocked();
        }
        this.mPackageMonitor.register(this.mUserContext, null, true);
    }

    private void readPreference(XmlPullParser parser) throws XmlPullParserException, IOException {
        String packageName = null;
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!"package".equals(parser.getAttributeName(i))) continue;
            packageName = parser.getAttributeValue(i);
            break;
        }
        XmlUtils.nextElement(parser);
        if ("usb-device".equals(parser.getName())) {
            DeviceFilter filter = DeviceFilter.read(parser);
            this.mDevicePreferenceMap.put(filter, packageName);
        } else if ("usb-accessory".equals(parser.getName())) {
            AccessoryFilter filter = AccessoryFilter.read(parser);
            this.mAccessoryPreferenceMap.put(filter, packageName);
        }
        XmlUtils.nextElement(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeSingleUserLocked() {
        if (sSingleUserSettingsFile.exists()) {
            block9: {
                this.mDevicePreferenceMap.clear();
                this.mAccessoryPreferenceMap.clear();
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(sSingleUserSettingsFile);
                        XmlPullParser parser = Xml.newPullParser();
                        parser.setInput(fis, null);
                        XmlUtils.nextElement(parser);
                        while (parser.getEventType() != 1) {
                            String tagName = parser.getName();
                            if ("preference".equals(tagName)) {
                                this.readPreference(parser);
                                continue;
                            }
                            XmlUtils.nextElement(parser);
                        }
                        Object var5_6 = null;
                    }
                    catch (IOException e) {
                        Log.wtf(TAG, "Failed to read single-user settings", e);
                        Object var5_7 = null;
                        IoUtils.closeQuietly(fis);
                        break block9;
                    }
                    catch (XmlPullParserException e) {
                        Log.wtf(TAG, "Failed to read single-user settings", e);
                        Object var5_8 = null;
                        IoUtils.closeQuietly(fis);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    IoUtils.closeQuietly(fis);
                    throw throwable;
                }
                IoUtils.closeQuietly(fis);
            }
            this.writeSettingsLocked();
            sSingleUserSettingsFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readSettingsLocked() {
        this.mDevicePreferenceMap.clear();
        this.mAccessoryPreferenceMap.clear();
        FileInputStream stream = null;
        try {
            try {
                stream = this.mSettingsFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(stream, null);
                XmlUtils.nextElement(parser);
                while (parser.getEventType() != 1) {
                    String tagName = parser.getName();
                    if ("preference".equals(tagName)) {
                        this.readPreference(parser);
                        continue;
                    }
                    XmlUtils.nextElement(parser);
                }
                Object var5_6 = null;
            }
            catch (FileNotFoundException e) {
                Object var5_7 = null;
                IoUtils.closeQuietly(stream);
                return;
            }
            catch (Exception e) {
                Slog.e(TAG, "error reading settings file, deleting to start fresh", e);
                this.mSettingsFile.delete();
                Object var5_8 = null;
                IoUtils.closeQuietly(stream);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            IoUtils.closeQuietly(stream);
            throw throwable;
        }
        IoUtils.closeQuietly(stream);
    }

    private void writeSettingsLocked() {
        block4: {
            FileOutputStream fos = null;
            try {
                fos = this.mSettingsFile.startWrite();
                FastXmlSerializer serializer = new FastXmlSerializer();
                serializer.setOutput(fos, "utf-8");
                serializer.startDocument(null, true);
                serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                serializer.startTag(null, "settings");
                for (DeviceFilter deviceFilter : this.mDevicePreferenceMap.keySet()) {
                    serializer.startTag(null, "preference");
                    serializer.attribute(null, "package", this.mDevicePreferenceMap.get(deviceFilter));
                    deviceFilter.write(serializer);
                    serializer.endTag(null, "preference");
                }
                for (AccessoryFilter accessoryFilter : this.mAccessoryPreferenceMap.keySet()) {
                    serializer.startTag(null, "preference");
                    serializer.attribute(null, "package", this.mAccessoryPreferenceMap.get(accessoryFilter));
                    accessoryFilter.write(serializer);
                    serializer.endTag(null, "preference");
                }
                serializer.endTag(null, "settings");
                serializer.endDocument();
                this.mSettingsFile.finishWrite(fos);
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to write settings", e);
                if (fos == null) break block4;
                this.mSettingsFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean packageMatchesLocked(ResolveInfo info, String metaDataName, UsbDevice device, UsbAccessory accessory) {
        XmlResourceParser parser;
        block13: {
            boolean bl;
            block12: {
                boolean bl2;
                block11: {
                    ActivityInfo ai = info.activityInfo;
                    parser = null;
                    try {
                        try {
                            parser = ai.loadXmlMetaData(this.mPackageManager, metaDataName);
                            if (parser == null) {
                                Slog.w(TAG, "no meta-data for " + info);
                                boolean bl3 = false;
                                Object var11_10 = null;
                                if (parser == null) return bl3;
                                parser.close();
                                return bl3;
                            }
                            XmlUtils.nextElement(parser);
                            while (parser.getEventType() != 1) {
                                Object filter;
                                String tagName = parser.getName();
                                if (device != null && "usb-device".equals(tagName)) {
                                    filter = DeviceFilter.read(parser);
                                    if (((DeviceFilter)filter).matches(device)) {
                                        bl2 = true;
                                        break block11;
                                    }
                                } else if (accessory != null && "usb-accessory".equals(tagName) && ((AccessoryFilter)(filter = AccessoryFilter.read(parser))).matches(accessory)) {
                                    bl = true;
                                    break block12;
                                }
                                XmlUtils.nextElement(parser);
                            }
                            break block13;
                        }
                        catch (Exception e) {
                            Slog.w(TAG, "Unable to load component info " + info.toString(), e);
                            Object var11_14 = null;
                            if (parser == null) return false;
                            parser.close();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        if (parser == null) throw throwable;
                        parser.close();
                        throw throwable;
                    }
                }
                Object var11_11 = null;
                if (parser == null) return bl2;
                parser.close();
                return bl2;
            }
            Object var11_12 = null;
            if (parser == null) return bl;
            parser.close();
            return bl;
        }
        Object var11_13 = null;
        if (parser == null) return false;
        parser.close();
        return false;
    }

    private final ArrayList<ResolveInfo> getDeviceMatchesLocked(UsbDevice device, Intent intent) {
        ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>();
        List<ResolveInfo> resolveInfos = this.mPackageManager.queryIntentActivities(intent, 128);
        int count = resolveInfos.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = resolveInfos.get(i);
            if (!this.packageMatchesLocked(resolveInfo, intent.getAction(), device, null)) continue;
            matches.add(resolveInfo);
        }
        return matches;
    }

    private final ArrayList<ResolveInfo> getAccessoryMatchesLocked(UsbAccessory accessory, Intent intent) {
        ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>();
        List<ResolveInfo> resolveInfos = this.mPackageManager.queryIntentActivities(intent, 128);
        int count = resolveInfos.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = resolveInfos.get(i);
            if (!this.packageMatchesLocked(resolveInfo, intent.getAction(), null, accessory)) continue;
            matches.add(resolveInfo);
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceAttached(UsbDevice device) {
        String defaultPackage;
        ArrayList<ResolveInfo> matches;
        Intent intent = new Intent("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intent.putExtra("device", device);
        intent.addFlags(0x10000000);
        Object object = this.mLock;
        synchronized (object) {
            matches = this.getDeviceMatchesLocked(device, intent);
            defaultPackage = this.mDevicePreferenceMap.get(new DeviceFilter(device));
        }
        this.mUserContext.sendBroadcast(intent);
        this.resolveActivity(intent, matches, defaultPackage, device, null);
    }

    public void deviceDetached(UsbDevice device) {
        this.mDevicePermissionMap.remove(device.getDeviceName());
        Intent intent = new Intent("android.hardware.usb.action.USB_DEVICE_DETACHED");
        intent.putExtra("device", device);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessoryAttached(UsbAccessory accessory) {
        String defaultPackage;
        ArrayList<ResolveInfo> matches;
        Intent intent = new Intent("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        intent.putExtra("accessory", accessory);
        intent.addFlags(0x10000000);
        Object object = this.mLock;
        synchronized (object) {
            matches = this.getAccessoryMatchesLocked(accessory, intent);
            defaultPackage = this.mAccessoryPreferenceMap.get(new AccessoryFilter(accessory));
        }
        this.resolveActivity(intent, matches, defaultPackage, null, accessory);
    }

    public void accessoryDetached(UsbAccessory accessory) {
        this.mAccessoryPermissionMap.remove(accessory);
        Intent intent = new Intent("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
        intent.putExtra("accessory", accessory);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void resolveActivity(Intent intent, ArrayList<ResolveInfo> matches, String defaultPackage, UsbDevice device, UsbAccessory accessory) {
        int count = matches.size();
        if (count == 0) {
            String uri;
            if (accessory != null && (uri = accessory.getUri()) != null && uri.length() > 0) {
                Intent dialogIntent = new Intent();
                dialogIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbAccessoryUriActivity");
                dialogIntent.addFlags(0x10000000);
                dialogIntent.putExtra("accessory", accessory);
                dialogIntent.putExtra("uri", uri);
                try {
                    this.mUserContext.startActivityAsUser(dialogIntent, this.mUser);
                }
                catch (ActivityNotFoundException e) {
                    Slog.e(TAG, "unable to start UsbAccessoryUriActivity");
                }
            }
            return;
        }
        ResolveInfo defaultRI = null;
        if (count == 1 && defaultPackage == null) {
            ResolveInfo rInfo = matches.get(0);
            if (rInfo.activityInfo != null && rInfo.activityInfo.applicationInfo != null && (rInfo.activityInfo.applicationInfo.flags & 1) != 0) {
                defaultRI = rInfo;
            }
        }
        if (defaultRI == null && defaultPackage != null) {
            for (int i = 0; i < count; ++i) {
                ResolveInfo rInfo = matches.get(i);
                if (rInfo.activityInfo == null || !defaultPackage.equals(rInfo.activityInfo.packageName)) continue;
                defaultRI = rInfo;
                break;
            }
        }
        if (defaultRI != null) {
            if (device != null) {
                this.grantDevicePermission(device, defaultRI.activityInfo.applicationInfo.uid);
            } else if (accessory != null) {
                this.grantAccessoryPermission(accessory, defaultRI.activityInfo.applicationInfo.uid);
            }
            try {
                intent.setComponent(new ComponentName(defaultRI.activityInfo.packageName, defaultRI.activityInfo.name));
                this.mUserContext.startActivityAsUser(intent, this.mUser);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "startActivity failed", e);
            }
        } else {
            Intent resolverIntent = new Intent();
            resolverIntent.addFlags(0x10000000);
            if (count == 1) {
                resolverIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbConfirmActivity");
                resolverIntent.putExtra("rinfo", matches.get(0));
                if (device != null) {
                    resolverIntent.putExtra("device", device);
                } else {
                    resolverIntent.putExtra("accessory", accessory);
                }
            } else {
                resolverIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbResolverActivity");
                resolverIntent.putParcelableArrayListExtra("rlist", matches);
                resolverIntent.putExtra("android.intent.extra.INTENT", intent);
            }
            try {
                this.mUserContext.startActivityAsUser(resolverIntent, this.mUser);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "unable to start activity " + resolverIntent);
            }
        }
    }

    private boolean clearCompatibleMatchesLocked(String packageName, DeviceFilter filter) {
        boolean changed = false;
        for (DeviceFilter test : this.mDevicePreferenceMap.keySet()) {
            if (!filter.matches(test)) continue;
            this.mDevicePreferenceMap.remove(test);
            changed = true;
        }
        return changed;
    }

    private boolean clearCompatibleMatchesLocked(String packageName, AccessoryFilter filter) {
        boolean changed = false;
        for (AccessoryFilter test : this.mAccessoryPreferenceMap.keySet()) {
            if (!filter.matches(test)) continue;
            this.mAccessoryPreferenceMap.remove(test);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePackageUpdateLocked(String packageName, ActivityInfo aInfo, String metaDataName) {
        boolean changed;
        XmlResourceParser parser;
        block14: {
            parser = null;
            changed = false;
            parser = aInfo.loadXmlMetaData(this.mPackageManager, metaDataName);
            if (parser != null) break block14;
            boolean bl = false;
            Object var9_9 = null;
            if (parser != null) {
                parser.close();
            }
            return bl;
        }
        try {
            try {
                XmlUtils.nextElement(parser);
                while (parser.getEventType() != 1) {
                    Object filter;
                    String tagName = parser.getName();
                    if ("usb-device".equals(tagName)) {
                        filter = DeviceFilter.read(parser);
                        if (this.clearCompatibleMatchesLocked(packageName, (DeviceFilter)filter)) {
                            changed = true;
                        }
                    } else if ("usb-accessory".equals(tagName) && this.clearCompatibleMatchesLocked(packageName, (AccessoryFilter)(filter = AccessoryFilter.read(parser)))) {
                        changed = true;
                    }
                    XmlUtils.nextElement(parser);
                }
                Object var9_10 = null;
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception e) {
                Slog.w(TAG, "Unable to load component info " + aInfo.toString(), e);
                Object var9_11 = null;
                if (parser != null) {
                    parser.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (parser != null) {
                parser.close();
            }
            throw throwable;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageUpdate(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            PackageInfo info;
            boolean changed = false;
            try {
                info = this.mPackageManager.getPackageInfo(packageName, 129);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.e(TAG, "handlePackageUpdate could not find package " + packageName, e);
                return;
            }
            ActivityInfo[] activities = info.activities;
            if (activities == null) {
                return;
            }
            for (int i = 0; i < activities.length; ++i) {
                if (this.handlePackageUpdateLocked(packageName, activities[i], "android.hardware.usb.action.USB_DEVICE_ATTACHED")) {
                    changed = true;
                }
                if (!this.handlePackageUpdateLocked(packageName, activities[i], "android.hardware.usb.action.USB_ACCESSORY_ATTACHED")) continue;
                changed = true;
            }
            if (changed) {
                this.writeSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(UsbDevice device) {
        Object object = this.mLock;
        synchronized (object) {
            int uid = Binder.getCallingUid();
            if (uid == 1000) {
                return true;
            }
            SparseBooleanArray uidList = this.mDevicePermissionMap.get(device.getDeviceName());
            if (uidList == null) {
                return false;
            }
            return uidList.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(UsbAccessory accessory) {
        Object object = this.mLock;
        synchronized (object) {
            int uid = Binder.getCallingUid();
            if (uid == 1000) {
                return true;
            }
            SparseBooleanArray uidList = this.mAccessoryPermissionMap.get(accessory);
            if (uidList == null) {
                return false;
            }
            return uidList.get(uid);
        }
    }

    public void checkPermission(UsbDevice device) {
        if (!this.hasPermission(device)) {
            throw new SecurityException("User has not given permission to device " + device);
        }
    }

    public void checkPermission(UsbAccessory accessory) {
        if (!this.hasPermission(accessory)) {
            throw new SecurityException("User has not given permission to accessory " + accessory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requestPermissionDialog(Intent intent, String packageName, PendingIntent pi) {
        int uid = Binder.getCallingUid();
        try {
            ApplicationInfo aInfo = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (aInfo.uid != uid) {
                throw new IllegalArgumentException("package " + packageName + " does not match caller's uid " + uid);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("package " + packageName + " not found");
        }
        long identity = Binder.clearCallingIdentity();
        intent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbPermissionActivity");
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.INTENT", pi);
        intent.putExtra("package", packageName);
        intent.putExtra("android.intent.extra.UID", uid);
        try {
            try {
                this.mUserContext.startActivityAsUser(intent, this.mUser);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "unable to start UsbPermissionActivity");
                Object var9_9 = null;
                Binder.restoreCallingIdentity(identity);
                return;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Binder.restoreCallingIdentity(identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(identity);
    }

    public void requestPermission(UsbDevice device, String packageName, PendingIntent pi) {
        Intent intent = new Intent();
        if (this.hasPermission(device)) {
            intent.putExtra("device", device);
            intent.putExtra("permission", true);
            try {
                pi.send(this.mUserContext, 0, intent);
            }
            catch (PendingIntent.CanceledException e) {
                // empty catch block
            }
            return;
        }
        intent.putExtra("device", device);
        this.requestPermissionDialog(intent, packageName, pi);
    }

    public void requestPermission(UsbAccessory accessory, String packageName, PendingIntent pi) {
        Intent intent = new Intent();
        if (this.hasPermission(accessory)) {
            intent.putExtra("accessory", accessory);
            intent.putExtra("permission", true);
            try {
                pi.send(this.mUserContext, 0, intent);
            }
            catch (PendingIntent.CanceledException e) {
                // empty catch block
            }
            return;
        }
        intent.putExtra("accessory", accessory);
        this.requestPermissionDialog(intent, packageName, pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDevicePackage(UsbDevice device, String packageName) {
        DeviceFilter filter = new DeviceFilter(device);
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (packageName == null) {
                changed = this.mDevicePreferenceMap.remove(filter) != null;
            } else {
                boolean bl = changed = !packageName.equals(this.mDevicePreferenceMap.get(filter));
                if (changed) {
                    this.mDevicePreferenceMap.put(filter, packageName);
                }
            }
            if (changed) {
                this.writeSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessoryPackage(UsbAccessory accessory, String packageName) {
        AccessoryFilter filter = new AccessoryFilter(accessory);
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (packageName == null) {
                changed = this.mAccessoryPreferenceMap.remove(filter) != null;
            } else {
                boolean bl = changed = !packageName.equals(this.mAccessoryPreferenceMap.get(filter));
                if (changed) {
                    this.mAccessoryPreferenceMap.put(filter, packageName);
                }
            }
            if (changed) {
                this.writeSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantDevicePermission(UsbDevice device, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            String deviceName = device.getDeviceName();
            SparseBooleanArray uidList = this.mDevicePermissionMap.get(deviceName);
            if (uidList == null) {
                uidList = new SparseBooleanArray(1);
                this.mDevicePermissionMap.put(deviceName, uidList);
            }
            uidList.put(uid, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccessoryPermission(UsbAccessory accessory, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            SparseBooleanArray uidList = this.mAccessoryPermissionMap.get(accessory);
            if (uidList == null) {
                uidList = new SparseBooleanArray(1);
                this.mAccessoryPermissionMap.put(accessory, uidList);
            }
            uidList.put(uid, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDefaults(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDevicePreferenceMap.values().contains(packageName)) {
                return true;
            }
            return this.mAccessoryPreferenceMap.values().contains(packageName);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDefaults(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.clearPackageDefaultsLocked(packageName)) {
                this.writeSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearPackageDefaultsLocked(String packageName) {
        boolean cleared = false;
        Object object = this.mLock;
        synchronized (object) {
            Object key;
            int i;
            Object[] keys;
            if (this.mDevicePreferenceMap.containsValue(packageName)) {
                keys = this.mDevicePreferenceMap.keySet().toArray();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!packageName.equals(this.mDevicePreferenceMap.get(key))) continue;
                    this.mDevicePreferenceMap.remove(key);
                    cleared = true;
                }
            }
            if (this.mAccessoryPreferenceMap.containsValue(packageName)) {
                keys = this.mAccessoryPreferenceMap.keySet().toArray();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!packageName.equals(this.mAccessoryPreferenceMap.get(key))) continue;
                    this.mAccessoryPreferenceMap.remove(key);
                    cleared = true;
                }
            }
            return cleared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            int count;
            SparseBooleanArray uidList;
            pw.println("  Device permissions:");
            for (String string2 : this.mDevicePermissionMap.keySet()) {
                pw.print("    " + string2 + ": ");
                uidList = this.mDevicePermissionMap.get(string2);
                count = uidList.size();
                for (i = 0; i < count; ++i) {
                    pw.print(Integer.toString(uidList.keyAt(i)) + " ");
                }
                pw.println("");
            }
            pw.println("  Accessory permissions:");
            for (UsbAccessory usbAccessory : this.mAccessoryPermissionMap.keySet()) {
                pw.print("    " + usbAccessory + ": ");
                uidList = this.mAccessoryPermissionMap.get(usbAccessory);
                count = uidList.size();
                for (i = 0; i < count; ++i) {
                    pw.print(Integer.toString(uidList.keyAt(i)) + " ");
                }
                pw.println("");
            }
            pw.println("  Device preferences:");
            for (DeviceFilter deviceFilter : this.mDevicePreferenceMap.keySet()) {
                pw.println("    " + deviceFilter + ": " + this.mDevicePreferenceMap.get(deviceFilter));
            }
            pw.println("  Accessory preferences:");
            for (AccessoryFilter accessoryFilter : this.mAccessoryPreferenceMap.keySet()) {
                pw.println("    " + accessoryFilter + ": " + this.mAccessoryPreferenceMap.get(accessoryFilter));
            }
        }
    }

    private class MyPackageMonitor
    extends PackageMonitor {
        private MyPackageMonitor() {
        }

        public void onPackageAdded(String packageName, int uid) {
            UsbSettingsManager.this.handlePackageUpdate(packageName);
        }

        public boolean onPackageChanged(String packageName, int uid, String[] components) {
            UsbSettingsManager.this.handlePackageUpdate(packageName);
            return false;
        }

        public void onPackageRemoved(String packageName, int uid) {
            UsbSettingsManager.this.clearDefaults(packageName);
        }
    }

    private static class AccessoryFilter {
        public final String mManufacturer;
        public final String mModel;
        public final String mVersion;

        public AccessoryFilter(String manufacturer, String model, String version) {
            this.mManufacturer = manufacturer;
            this.mModel = model;
            this.mVersion = version;
        }

        public AccessoryFilter(UsbAccessory accessory) {
            this.mManufacturer = accessory.getManufacturer();
            this.mModel = accessory.getModel();
            this.mVersion = accessory.getVersion();
        }

        public static AccessoryFilter read(XmlPullParser parser) throws XmlPullParserException, IOException {
            String manufacturer = null;
            String model = null;
            String version = null;
            int count = parser.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                String name = parser.getAttributeName(i);
                String value = parser.getAttributeValue(i);
                if ("manufacturer".equals(name)) {
                    manufacturer = value;
                    continue;
                }
                if ("model".equals(name)) {
                    model = value;
                    continue;
                }
                if (!"version".equals(name)) continue;
                version = value;
            }
            return new AccessoryFilter(manufacturer, model, version);
        }

        public void write(XmlSerializer serializer) throws IOException {
            serializer.startTag(null, "usb-accessory");
            if (this.mManufacturer != null) {
                serializer.attribute(null, "manufacturer", this.mManufacturer);
            }
            if (this.mModel != null) {
                serializer.attribute(null, "model", this.mModel);
            }
            if (this.mVersion != null) {
                serializer.attribute(null, "version", this.mVersion);
            }
            serializer.endTag(null, "usb-accessory");
        }

        public boolean matches(UsbAccessory acc) {
            if (this.mManufacturer != null && !acc.getManufacturer().equals(this.mManufacturer)) {
                return false;
            }
            if (this.mModel != null && !acc.getModel().equals(this.mModel)) {
                return false;
            }
            return this.mVersion == null || acc.getVersion().equals(this.mVersion);
        }

        public boolean matches(AccessoryFilter f) {
            if (this.mManufacturer != null && !f.mManufacturer.equals(this.mManufacturer)) {
                return false;
            }
            if (this.mModel != null && !f.mModel.equals(this.mModel)) {
                return false;
            }
            return this.mVersion == null || f.mVersion.equals(this.mVersion);
        }

        public boolean equals(Object obj) {
            if (this.mManufacturer == null || this.mModel == null || this.mVersion == null) {
                return false;
            }
            if (obj instanceof AccessoryFilter) {
                AccessoryFilter filter = (AccessoryFilter)obj;
                return this.mManufacturer.equals(filter.mManufacturer) && this.mModel.equals(filter.mModel) && this.mVersion.equals(filter.mVersion);
            }
            if (obj instanceof UsbAccessory) {
                UsbAccessory accessory = (UsbAccessory)obj;
                return this.mManufacturer.equals(accessory.getManufacturer()) && this.mModel.equals(accessory.getModel()) && this.mVersion.equals(accessory.getVersion());
            }
            return false;
        }

        public int hashCode() {
            return (this.mManufacturer == null ? 0 : this.mManufacturer.hashCode()) ^ (this.mModel == null ? 0 : this.mModel.hashCode()) ^ (this.mVersion == null ? 0 : this.mVersion.hashCode());
        }

        public String toString() {
            return "AccessoryFilter[mManufacturer=\"" + this.mManufacturer + "\", mModel=\"" + this.mModel + "\", mVersion=\"" + this.mVersion + "\"]";
        }
    }

    private static class DeviceFilter {
        public final int mVendorId;
        public final int mProductId;
        public final int mClass;
        public final int mSubclass;
        public final int mProtocol;
        public final String mManufacturerName;
        public final String mProductName;
        public final String mSerialNumber;

        public DeviceFilter(int vid, int pid, int clasz, int subclass, int protocol, String manufacturer, String product, String serialnum) {
            this.mVendorId = vid;
            this.mProductId = pid;
            this.mClass = clasz;
            this.mSubclass = subclass;
            this.mProtocol = protocol;
            this.mManufacturerName = manufacturer;
            this.mProductName = product;
            this.mSerialNumber = serialnum;
        }

        public DeviceFilter(UsbDevice device) {
            this.mVendorId = device.getVendorId();
            this.mProductId = device.getProductId();
            this.mClass = device.getDeviceClass();
            this.mSubclass = device.getDeviceSubclass();
            this.mProtocol = device.getDeviceProtocol();
            this.mManufacturerName = device.getManufacturerName();
            this.mProductName = device.getProductName();
            this.mSerialNumber = device.getSerialNumber();
        }

        public static DeviceFilter read(XmlPullParser parser) throws XmlPullParserException, IOException {
            int vendorId = -1;
            int productId = -1;
            int deviceClass = -1;
            int deviceSubclass = -1;
            int deviceProtocol = -1;
            String manufacturerName = null;
            String productName = null;
            String serialNumber = null;
            int count = parser.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                String name = parser.getAttributeName(i);
                String value = parser.getAttributeValue(i);
                if ("manufacturer-name".equals(name)) {
                    manufacturerName = value;
                    continue;
                }
                if ("product-name".equals(name)) {
                    productName = value;
                    continue;
                }
                if ("serial-number".equals(name)) {
                    serialNumber = value;
                    continue;
                }
                int intValue = -1;
                int radix = 10;
                if (value != null && value.length() > 2 && value.charAt(0) == '0' && (value.charAt(1) == 'x' || value.charAt(1) == 'X')) {
                    radix = 16;
                    value = value.substring(2);
                }
                try {
                    intValue = Integer.parseInt(value, radix);
                }
                catch (NumberFormatException e) {
                    Slog.e(UsbSettingsManager.TAG, "invalid number for field " + name, e);
                    continue;
                }
                if ("vendor-id".equals(name)) {
                    vendorId = intValue;
                    continue;
                }
                if ("product-id".equals(name)) {
                    productId = intValue;
                    continue;
                }
                if ("class".equals(name)) {
                    deviceClass = intValue;
                    continue;
                }
                if ("subclass".equals(name)) {
                    deviceSubclass = intValue;
                    continue;
                }
                if (!"protocol".equals(name)) continue;
                deviceProtocol = intValue;
            }
            return new DeviceFilter(vendorId, productId, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber);
        }

        public void write(XmlSerializer serializer) throws IOException {
            serializer.startTag(null, "usb-device");
            if (this.mVendorId != -1) {
                serializer.attribute(null, "vendor-id", Integer.toString(this.mVendorId));
            }
            if (this.mProductId != -1) {
                serializer.attribute(null, "product-id", Integer.toString(this.mProductId));
            }
            if (this.mClass != -1) {
                serializer.attribute(null, "class", Integer.toString(this.mClass));
            }
            if (this.mSubclass != -1) {
                serializer.attribute(null, "subclass", Integer.toString(this.mSubclass));
            }
            if (this.mProtocol != -1) {
                serializer.attribute(null, "protocol", Integer.toString(this.mProtocol));
            }
            if (this.mManufacturerName != null) {
                serializer.attribute(null, "manufacturer-name", this.mManufacturerName);
            }
            if (this.mProductName != null) {
                serializer.attribute(null, "product-name", this.mProductName);
            }
            if (this.mSerialNumber != null) {
                serializer.attribute(null, "serial-number", this.mSerialNumber);
            }
            serializer.endTag(null, "usb-device");
        }

        private boolean matches(int clasz, int subclass, int protocol) {
            return !(this.mClass != -1 && clasz != this.mClass || this.mSubclass != -1 && subclass != this.mSubclass || this.mProtocol != -1 && protocol != this.mProtocol);
        }

        public boolean matches(UsbDevice device) {
            if (this.mVendorId != -1 && device.getVendorId() != this.mVendorId) {
                return false;
            }
            if (this.mProductId != -1 && device.getProductId() != this.mProductId) {
                return false;
            }
            if (this.mManufacturerName != null && device.getManufacturerName() == null) {
                return false;
            }
            if (this.mProductName != null && device.getProductName() == null) {
                return false;
            }
            if (this.mSerialNumber != null && device.getSerialNumber() == null) {
                return false;
            }
            if (this.mManufacturerName != null && device.getManufacturerName() != null && !this.mManufacturerName.equals(device.getManufacturerName())) {
                return false;
            }
            if (this.mProductName != null && device.getProductName() != null && !this.mProductName.equals(device.getProductName())) {
                return false;
            }
            if (this.mSerialNumber != null && device.getSerialNumber() != null && !this.mSerialNumber.equals(device.getSerialNumber())) {
                return false;
            }
            if (this.matches(device.getDeviceClass(), device.getDeviceSubclass(), device.getDeviceProtocol())) {
                return true;
            }
            int count = device.getInterfaceCount();
            for (int i = 0; i < count; ++i) {
                UsbInterface intf = device.getInterface(i);
                if (!this.matches(intf.getInterfaceClass(), intf.getInterfaceSubclass(), intf.getInterfaceProtocol())) continue;
                return true;
            }
            return false;
        }

        public boolean matches(DeviceFilter f) {
            if (this.mVendorId != -1 && f.mVendorId != this.mVendorId) {
                return false;
            }
            if (this.mProductId != -1 && f.mProductId != this.mProductId) {
                return false;
            }
            if (f.mManufacturerName != null && this.mManufacturerName == null) {
                return false;
            }
            if (f.mProductName != null && this.mProductName == null) {
                return false;
            }
            if (f.mSerialNumber != null && this.mSerialNumber == null) {
                return false;
            }
            if (this.mManufacturerName != null && f.mManufacturerName != null && !this.mManufacturerName.equals(f.mManufacturerName)) {
                return false;
            }
            if (this.mProductName != null && f.mProductName != null && !this.mProductName.equals(f.mProductName)) {
                return false;
            }
            if (this.mSerialNumber != null && f.mSerialNumber != null && !this.mSerialNumber.equals(f.mSerialNumber)) {
                return false;
            }
            return this.matches(f.mClass, f.mSubclass, f.mProtocol);
        }

        public boolean equals(Object obj) {
            if (this.mVendorId == -1 || this.mProductId == -1 || this.mClass == -1 || this.mSubclass == -1 || this.mProtocol == -1) {
                return false;
            }
            if (obj instanceof DeviceFilter) {
                DeviceFilter filter = (DeviceFilter)obj;
                if (filter.mVendorId != this.mVendorId || filter.mProductId != this.mProductId || filter.mClass != this.mClass || filter.mSubclass != this.mSubclass || filter.mProtocol != this.mProtocol) {
                    return false;
                }
                if (filter.mManufacturerName != null && this.mManufacturerName == null || filter.mManufacturerName == null && this.mManufacturerName != null || filter.mProductName != null && this.mProductName == null || filter.mProductName == null && this.mProductName != null || filter.mSerialNumber != null && this.mSerialNumber == null || filter.mSerialNumber == null && this.mSerialNumber != null) {
                    return false;
                }
                return !(filter.mManufacturerName != null && this.mManufacturerName != null && !this.mManufacturerName.equals(filter.mManufacturerName) || filter.mProductName != null && this.mProductName != null && !this.mProductName.equals(filter.mProductName)) && (filter.mSerialNumber == null || this.mSerialNumber == null || this.mSerialNumber.equals(filter.mSerialNumber));
            }
            if (obj instanceof UsbDevice) {
                UsbDevice device = (UsbDevice)obj;
                if (device.getVendorId() != this.mVendorId || device.getProductId() != this.mProductId || device.getDeviceClass() != this.mClass || device.getDeviceSubclass() != this.mSubclass || device.getDeviceProtocol() != this.mProtocol) {
                    return false;
                }
                if (this.mManufacturerName != null && device.getManufacturerName() == null || this.mManufacturerName == null && device.getManufacturerName() != null || this.mProductName != null && device.getProductName() == null || this.mProductName == null && device.getProductName() != null || this.mSerialNumber != null && device.getSerialNumber() == null || this.mSerialNumber == null && device.getSerialNumber() != null) {
                    return false;
                }
                return !(device.getManufacturerName() != null && !this.mManufacturerName.equals(device.getManufacturerName()) || device.getProductName() != null && !this.mProductName.equals(device.getProductName())) && (device.getSerialNumber() == null || this.mSerialNumber.equals(device.getSerialNumber()));
            }
            return false;
        }

        public int hashCode() {
            return (this.mVendorId << 16 | this.mProductId) ^ (this.mClass << 16 | this.mSubclass << 8 | this.mProtocol);
        }

        public String toString() {
            return "DeviceFilter[mVendorId=" + this.mVendorId + ",mProductId=" + this.mProductId + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mManufacturerName=" + this.mManufacturerName + ",mProductName=" + this.mProductName + ",mSerialNumber=" + this.mSerialNumber + "]";
        }
    }
}

