/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wifi;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.DhcpInfo;
import android.net.DhcpResults;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.wifi.BatchedScanResult;
import android.net.wifi.BatchedScanSettings;
import android.net.wifi.IWifiManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiStateMachine;
import android.net.wifi.WifiWatchdogStateMachine;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.AsyncChannel;
import com.android.server.am.BatteryStatsService;
import com.android.server.wifi.WifiController;
import com.android.server.wifi.WifiNotificationController;
import com.android.server.wifi.WifiSettingsStore;
import com.android.server.wifi.WifiTrafficPoller;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WifiService
extends IWifiManager.Stub {
    private static final String TAG = "WifiService";
    private static final boolean DBG = false;
    final WifiStateMachine mWifiStateMachine;
    private final Context mContext;
    final LockList mLocks = new LockList();
    private int mFullHighPerfLocksAcquired;
    private int mFullHighPerfLocksReleased;
    private int mFullLocksAcquired;
    private int mFullLocksReleased;
    private int mScanLocksAcquired;
    private int mScanLocksReleased;
    private final List<Multicaster> mMulticasters = new ArrayList<Multicaster>();
    private int mMulticastEnabled;
    private int mMulticastDisabled;
    private final IBatteryStats mBatteryStats;
    private final AppOpsManager mAppOps;
    private String mInterfaceName;
    private WifiNotificationController mNotificationController;
    private WifiTrafficPoller mTrafficPoller;
    final WifiSettingsStore mSettingsStore;
    final boolean mBatchedScanSupported;
    private AsyncChannel mWifiStateMachineChannel;
    private ClientHandler mClientHandler;
    WifiStateMachineHandler mWifiStateMachineHandler;
    private WifiWatchdogStateMachine mWifiWatchdogStateMachine;
    private WifiController mWifiController;
    private final List<BatchedScanRequest> mBatchedScanners = new ArrayList<BatchedScanRequest>();
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                WifiService.this.mWifiController.sendMessage(155650);
            } else if (action.equals("android.intent.action.USER_PRESENT")) {
                WifiService.this.mWifiController.sendMessage(155660);
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                WifiService.this.mWifiController.sendMessage(155651);
            } else if (action.equals("android.intent.action.BATTERY_CHANGED")) {
                int pluggedType = intent.getIntExtra("plugged", 0);
                WifiService.this.mWifiController.sendMessage(155652, pluggedType, 0, null);
            } else if (action.equals("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", 0);
                WifiService.this.mWifiStateMachine.sendBluetoothAdapterStateChange(state);
            } else if (action.equals("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED")) {
                boolean emergencyMode = intent.getBooleanExtra("phoneinECMState", false);
                WifiService.this.mWifiController.sendMessage(155649, emergencyMode ? 1 : 0, 0);
            }
        }
    };

    public WifiService(Context context) {
        this.mContext = context;
        this.mInterfaceName = SystemProperties.get("wifi.interface", "wlan0");
        this.mWifiStateMachine = new WifiStateMachine(this.mContext, this.mInterfaceName);
        this.mWifiStateMachine.enableRssiPolling(true);
        this.mBatteryStats = BatteryStatsService.getService();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mNotificationController = new WifiNotificationController(this.mContext, this.mWifiStateMachine);
        this.mTrafficPoller = new WifiTrafficPoller(this.mContext, this.mInterfaceName);
        this.mSettingsStore = new WifiSettingsStore(this.mContext);
        HandlerThread wifiThread = new HandlerThread(TAG);
        wifiThread.start();
        this.mClientHandler = new ClientHandler(wifiThread.getLooper());
        this.mWifiStateMachineHandler = new WifiStateMachineHandler(wifiThread.getLooper());
        this.mWifiController = new WifiController(this.mContext, this, wifiThread.getLooper());
        this.mWifiController.start();
        this.mBatchedScanSupported = this.mContext.getResources().getBoolean(0x1110019);
        this.registerForScanModeChange();
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (WifiService.this.mSettingsStore.handleAirplaneModeToggled()) {
                    WifiService.this.mWifiController.sendMessage(155657);
                }
            }
        }, new IntentFilter("android.intent.action.AIRPLANE_MODE"));
        this.registerForBroadcasts();
    }

    public void checkAndStartWifi() {
        boolean wifiEnabled = this.mSettingsStore.isWifiToggleEnabled();
        Slog.i(TAG, "WifiService starting up with Wi-Fi " + (wifiEnabled ? "enabled" : "disabled"));
        if (wifiEnabled) {
            this.setWifiEnabled(wifiEnabled);
        }
        this.mWifiWatchdogStateMachine = WifiWatchdogStateMachine.makeWifiWatchdogStateMachine(this.mContext);
    }

    @Override
    public boolean pingSupplicant() {
        this.enforceAccessPermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncPingSupplicant(this.mWifiStateMachineChannel);
        }
        Slog.e(TAG, "mWifiStateMachineChannel is not initialized");
        return false;
    }

    @Override
    public void startScan(WorkSource workSource) {
        this.enforceChangePermission();
        if (workSource != null) {
            this.enforceWorkSourcePermission();
            workSource.clearNames();
        }
        this.mWifiStateMachine.startScan(Binder.getCallingUid(), workSource);
    }

    @Override
    public boolean isBatchedScanSupported() {
        return this.mBatchedScanSupported;
    }

    @Override
    public void pollBatchedScan() {
        this.enforceChangePermission();
        if (!this.mBatchedScanSupported) {
            return;
        }
        this.mWifiStateMachine.requestBatchedScanPoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestBatchedScan(BatchedScanSettings requested, IBinder binder, WorkSource workSource) {
        this.enforceChangePermission();
        if (workSource != null) {
            this.enforceWorkSourcePermission();
            workSource.clearNames();
        }
        if (!this.mBatchedScanSupported) {
            return false;
        }
        if ((requested = new BatchedScanSettings(requested)).isInvalid()) {
            return false;
        }
        BatchedScanRequest r = new BatchedScanRequest(requested, binder, workSource);
        List<BatchedScanRequest> list = this.mBatchedScanners;
        synchronized (list) {
            this.mBatchedScanners.add(r);
            this.resolveBatchedScannersLocked();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchedScanResult> getBatchedScanResults(String callingPackage) {
        long ident;
        block6: {
            int userId;
            block5: {
                ArrayList<BatchedScanResult> arrayList;
                this.enforceAccessPermission();
                if (!this.mBatchedScanSupported) {
                    return new ArrayList<BatchedScanResult>();
                }
                userId = UserHandle.getCallingUserId();
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    if (this.mAppOps.noteOp(10, uid, callingPackage) == 0) break block5;
                    arrayList = new ArrayList<BatchedScanResult>();
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(ident);
                return arrayList;
            }
            int currentUser = ActivityManager.getCurrentUser();
            if (userId == currentUser) break block6;
            ArrayList<BatchedScanResult> arrayList = new ArrayList<BatchedScanResult>();
            Object var9_8 = null;
            Binder.restoreCallingIdentity(ident);
            return arrayList;
        }
        List<BatchedScanResult> list = this.mWifiStateMachine.syncGetBatchedScanResultsList();
        Object var9_9 = null;
        Binder.restoreCallingIdentity(ident);
        return list;
    }

    @Override
    public void stopBatchedScan(BatchedScanSettings settings) {
        this.enforceChangePermission();
        if (!this.mBatchedScanSupported) {
            return;
        }
        this.stopBatchedScan(settings, WifiService.getCallingUid(), WifiService.getCallingPid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBatchedScan(BatchedScanSettings settings, int uid, int pid) {
        ArrayList<BatchedScanRequest> found = new ArrayList<BatchedScanRequest>();
        List<BatchedScanRequest> list = this.mBatchedScanners;
        synchronized (list) {
            for (BatchedScanRequest r : this.mBatchedScanners) {
                if (!r.isSameApp(uid, pid) || settings != null && !settings.equals(r.settings)) continue;
                found.add(r);
                if (settings == null) continue;
                break;
            }
            for (BatchedScanRequest r : found) {
                this.mBatchedScanners.remove(r);
            }
            if (found.size() != 0) {
                this.resolveBatchedScannersLocked();
            }
        }
    }

    private void resolveBatchedScannersLocked() {
        BatchedScanSettings setting = new BatchedScanSettings();
        WorkSource responsibleWorkSource = null;
        int responsibleUid = 0;
        double responsibleCsph = 0.0;
        if (this.mBatchedScanners.size() == 0) {
            this.mWifiStateMachine.setBatchedScanSettings(null, 0, 0, null);
            return;
        }
        for (BatchedScanRequest r : this.mBatchedScanners) {
            int currentChannelCount;
            BatchedScanSettings s = r.settings;
            if (s.channelSet == null || s.channelSet.isEmpty()) {
                currentChannelCount = 20;
            } else {
                currentChannelCount = s.channelSet.size();
                if (s.channelSet.contains("A")) {
                    currentChannelCount += 8;
                }
                if (s.channelSet.contains("B")) {
                    currentChannelCount += 10;
                }
            }
            int currentScanInterval = s.scanIntervalSec == Integer.MAX_VALUE ? 30 : s.scanIntervalSec;
            double currentCsph = 3600 * currentChannelCount / currentScanInterval;
            if (currentCsph > responsibleCsph) {
                responsibleUid = r.uid;
                responsibleWorkSource = r.workSource;
                responsibleCsph = currentCsph;
            }
            if (s.maxScansPerBatch != Integer.MAX_VALUE && s.maxScansPerBatch < setting.maxScansPerBatch) {
                setting.maxScansPerBatch = s.maxScansPerBatch;
            }
            if (s.maxApPerScan != Integer.MAX_VALUE && (setting.maxApPerScan == Integer.MAX_VALUE || s.maxApPerScan > setting.maxApPerScan)) {
                setting.maxApPerScan = s.maxApPerScan;
            }
            if (s.scanIntervalSec != Integer.MAX_VALUE && s.scanIntervalSec < setting.scanIntervalSec) {
                setting.scanIntervalSec = s.scanIntervalSec;
            }
            if (s.maxApForDistance != Integer.MAX_VALUE && (setting.maxApForDistance == Integer.MAX_VALUE || s.maxApForDistance > setting.maxApForDistance)) {
                setting.maxApForDistance = s.maxApForDistance;
            }
            if (s.channelSet != null && s.channelSet.size() != 0) {
                if (setting.channelSet != null && setting.channelSet.size() == 0) continue;
                if (setting.channelSet == null) {
                    setting.channelSet = new ArrayList<String>();
                }
                for (String i : s.channelSet) {
                    if (setting.channelSet.contains(i)) continue;
                    setting.channelSet.add(i);
                }
                continue;
            }
            if (setting.channelSet != null && setting.channelSet.size() == 0) continue;
            setting.channelSet = new ArrayList<String>();
        }
        setting.constrain();
        this.mWifiStateMachine.setBatchedScanSettings(setting, responsibleUid, (int)responsibleCsph, responsibleWorkSource);
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE", TAG);
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
    }

    private void enforceWorkSourcePermission() {
        this.mContext.enforceCallingPermission("android.permission.UPDATE_DEVICE_STATS", TAG);
    }

    private void enforceMulticastChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_MULTICAST_STATE", TAG);
    }

    private void enforceConnectivityInternalPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", "ConnectivityService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setWifiEnabled(boolean enable) {
        long ident;
        block3: {
            boolean bl;
            this.enforceChangePermission();
            Slog.d(TAG, "setWifiEnabled: " + enable + " pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            ident = Binder.clearCallingIdentity();
            try {
                if (this.mSettingsStore.handleWifiToggled(enable)) break block3;
                bl = true;
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        Object var6_5 = null;
        Binder.restoreCallingIdentity(ident);
        this.mWifiController.sendMessage(155656);
        return true;
    }

    @Override
    public int getWifiEnabledState() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetWifiState();
    }

    @Override
    public void setWifiApEnabled(WifiConfiguration wifiConfig, boolean enabled) {
        this.enforceChangePermission();
        if (wifiConfig == null || wifiConfig.isValid()) {
            this.mWifiController.obtainMessage(155658, enabled ? 1 : 0, 0, wifiConfig).sendToTarget();
        } else {
            Slog.e(TAG, "Invalid WifiConfiguration");
        }
    }

    @Override
    public int getWifiApEnabledState() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetWifiApState();
    }

    @Override
    public WifiConfiguration getWifiApConfiguration() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetWifiApConfiguration();
    }

    @Override
    public void setWifiApConfiguration(WifiConfiguration wifiConfig) {
        this.enforceChangePermission();
        if (wifiConfig == null) {
            return;
        }
        if (wifiConfig.isValid()) {
            this.mWifiStateMachine.setWifiApConfiguration(wifiConfig);
        } else {
            Slog.e(TAG, "Invalid WifiConfiguration");
        }
    }

    @Override
    public boolean isScanAlwaysAvailable() {
        this.enforceAccessPermission();
        return this.mSettingsStore.isScanAlwaysAvailable();
    }

    @Override
    public void disconnect() {
        this.enforceChangePermission();
        this.mWifiStateMachine.disconnectCommand();
    }

    @Override
    public void reconnect() {
        this.enforceChangePermission();
        this.mWifiStateMachine.reconnectCommand();
    }

    @Override
    public void reassociate() {
        this.enforceChangePermission();
        this.mWifiStateMachine.reassociateCommand();
    }

    @Override
    public List<WifiConfiguration> getConfiguredNetworks() {
        this.enforceAccessPermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncGetConfiguredNetworks(this.mWifiStateMachineChannel);
        }
        Slog.e(TAG, "mWifiStateMachineChannel is not initialized");
        return null;
    }

    @Override
    public int addOrUpdateNetwork(WifiConfiguration config) {
        this.enforceChangePermission();
        if (config.proxySettings == WifiConfiguration.ProxySettings.PAC) {
            this.enforceConnectivityInternalPermission();
        }
        if (config.isValid()) {
            if (this.mWifiStateMachineChannel != null) {
                return this.mWifiStateMachine.syncAddOrUpdateNetwork(this.mWifiStateMachineChannel, config);
            }
            Slog.e(TAG, "mWifiStateMachineChannel is not initialized");
            return -1;
        }
        Slog.e(TAG, "bad network configuration");
        return -1;
    }

    @Override
    public boolean removeNetwork(int netId) {
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncRemoveNetwork(this.mWifiStateMachineChannel, netId);
        }
        Slog.e(TAG, "mWifiStateMachineChannel is not initialized");
        return false;
    }

    @Override
    public boolean enableNetwork(int netId, boolean disableOthers) {
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncEnableNetwork(this.mWifiStateMachineChannel, netId, disableOthers);
        }
        Slog.e(TAG, "mWifiStateMachineChannel is not initialized");
        return false;
    }

    @Override
    public boolean disableNetwork(int netId) {
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncDisableNetwork(this.mWifiStateMachineChannel, netId);
        }
        Slog.e(TAG, "mWifiStateMachineChannel is not initialized");
        return false;
    }

    @Override
    public WifiInfo getConnectionInfo() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncRequestConnectionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScanResult> getScanResults(String callingPackage) {
        long ident;
        block5: {
            int userId;
            block4: {
                ArrayList<ScanResult> arrayList;
                this.enforceAccessPermission();
                userId = UserHandle.getCallingUserId();
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    if (this.mAppOps.noteOp(10, uid, callingPackage) == 0) break block4;
                    arrayList = new ArrayList<ScanResult>();
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    Binder.restoreCallingIdentity(ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(ident);
                return arrayList;
            }
            int currentUser = ActivityManager.getCurrentUser();
            if (userId == currentUser) break block5;
            ArrayList<ScanResult> arrayList = new ArrayList<ScanResult>();
            Object var9_8 = null;
            Binder.restoreCallingIdentity(ident);
            return arrayList;
        }
        List<ScanResult> list = this.mWifiStateMachine.syncGetScanResultsList();
        Object var9_9 = null;
        Binder.restoreCallingIdentity(ident);
        return list;
    }

    @Override
    public boolean saveConfiguration() {
        boolean result = true;
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncSaveConfig(this.mWifiStateMachineChannel);
        }
        Slog.e(TAG, "mWifiStateMachineChannel is not initialized");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCountryCode(String countryCode, boolean persist) {
        Slog.i(TAG, "WifiService trying to set country code to " + countryCode + " with persist set to " + persist);
        this.enforceChangePermission();
        long token = Binder.clearCallingIdentity();
        try {
            this.mWifiStateMachine.setCountryCode(countryCode, persist);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrequencyBand(int band, boolean persist) {
        this.enforceChangePermission();
        if (!this.isDualBandSupported()) {
            return;
        }
        Slog.i(TAG, "WifiService trying to set frequency band to " + band + " with persist set to " + persist);
        long token = Binder.clearCallingIdentity();
        try {
            this.mWifiStateMachine.setFrequencyBand(band, persist);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    @Override
    public int getFrequencyBand() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.getFrequencyBand();
    }

    @Override
    public boolean isDualBandSupported() {
        return this.mContext.getResources().getBoolean(0x1110017);
    }

    @Override
    public DhcpInfo getDhcpInfo() {
        InetAddress serverAddress;
        this.enforceAccessPermission();
        DhcpResults dhcpResults = this.mWifiStateMachine.syncGetDhcpResults();
        if (dhcpResults.linkProperties == null) {
            return null;
        }
        DhcpInfo info = new DhcpInfo();
        for (LinkAddress la : dhcpResults.linkProperties.getLinkAddresses()) {
            InetAddress addr = la.getAddress();
            if (!(addr instanceof Inet4Address)) continue;
            info.ipAddress = NetworkUtils.inetAddressToInt((Inet4Address)addr);
            break;
        }
        for (RouteInfo r : dhcpResults.linkProperties.getRoutes()) {
            LinkAddress dest;
            if (r.isDefaultRoute()) {
                InetAddress gateway = r.getGateway();
                if (!(gateway instanceof Inet4Address)) continue;
                info.gateway = NetworkUtils.inetAddressToInt((Inet4Address)gateway);
                continue;
            }
            if (r.hasGateway() || !((dest = r.getDestination()).getAddress() instanceof Inet4Address)) continue;
            info.netmask = NetworkUtils.prefixLengthToNetmaskInt(dest.getNetworkPrefixLength());
        }
        int dnsFound = 0;
        for (InetAddress dns : dhcpResults.linkProperties.getDnses()) {
            if (!(dns instanceof Inet4Address)) continue;
            if (dnsFound == 0) {
                info.dns1 = NetworkUtils.inetAddressToInt((Inet4Address)dns);
            } else {
                info.dns2 = NetworkUtils.inetAddressToInt((Inet4Address)dns);
            }
            if (++dnsFound <= 1) continue;
            break;
        }
        if ((serverAddress = dhcpResults.serverAddress) instanceof Inet4Address) {
            info.serverAddress = NetworkUtils.inetAddressToInt((Inet4Address)serverAddress);
        }
        info.leaseDuration = dhcpResults.leaseDuration;
        return info;
    }

    @Override
    public void startWifi() {
        this.enforceConnectivityInternalPermission();
        this.mWifiStateMachine.setDriverStart(true);
        this.mWifiStateMachine.reconnectCommand();
    }

    @Override
    public void captivePortalCheckComplete() {
        this.enforceConnectivityInternalPermission();
        this.mWifiStateMachine.captivePortalCheckComplete();
    }

    @Override
    public void stopWifi() {
        this.enforceConnectivityInternalPermission();
        this.mWifiStateMachine.setDriverStart(false);
    }

    @Override
    public void addToBlacklist(String bssid) {
        this.enforceChangePermission();
        this.mWifiStateMachine.addToBlacklist(bssid);
    }

    @Override
    public void clearBlacklist() {
        this.enforceChangePermission();
        this.mWifiStateMachine.clearBlacklist();
    }

    @Override
    public void enableTdls(String remoteAddress, boolean enable) {
        TdlsTaskParams params = new TdlsTaskParams();
        params.remoteIpAddress = remoteAddress;
        params.enable = enable;
        new TdlsTask().execute(params);
    }

    @Override
    public void enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) {
        this.mWifiStateMachine.enableTdls(remoteMacAddress, enable);
    }

    @Override
    public Messenger getWifiServiceMessenger() {
        this.enforceAccessPermission();
        this.enforceChangePermission();
        return new Messenger(this.mClientHandler);
    }

    @Override
    public Messenger getWifiStateMachineMessenger() {
        this.enforceAccessPermission();
        this.enforceChangePermission();
        return this.mWifiStateMachine.getMessenger();
    }

    @Override
    public String getConfigFile() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.getConfigFile();
    }

    private void registerForScanModeChange() {
        ContentObserver contentObserver = new ContentObserver(null){

            public void onChange(boolean selfChange) {
                WifiService.this.mSettingsStore.handleWifiScanAlwaysAvailableToggled();
                WifiService.this.mWifiController.sendMessage(155655);
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("wifi_scan_always_enabled"), false, contentObserver);
    }

    private void registerForBroadcasts() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, intentFilter);
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WifiService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Wi-Fi is " + this.mWifiStateMachine.syncGetWifiStateByName());
        pw.println("Stay-awake conditions: " + Settings.Global.getInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", 0));
        pw.println("mMulticastEnabled " + this.mMulticastEnabled);
        pw.println("mMulticastDisabled " + this.mMulticastDisabled);
        this.mWifiController.dump(fd, pw, args);
        this.mSettingsStore.dump(fd, pw, args);
        this.mNotificationController.dump(fd, pw, args);
        this.mTrafficPoller.dump(fd, pw, args);
        pw.println("Latest scan results:");
        List<ScanResult> scanResults = this.mWifiStateMachine.syncGetScanResultsList();
        if (scanResults != null && scanResults.size() != 0) {
            pw.println("  BSSID              Frequency   RSSI  Flags             SSID");
            for (ScanResult r : scanResults) {
                pw.printf("  %17s  %9d  %5d  %-16s  %s%n", r.BSSID, r.frequency, r.level, r.capabilities, r.SSID == null ? "" : r.SSID);
            }
        }
        pw.println();
        pw.println("Locks acquired: " + this.mFullLocksAcquired + " full, " + this.mFullHighPerfLocksAcquired + " full high perf, " + this.mScanLocksAcquired + " scan");
        pw.println("Locks released: " + this.mFullLocksReleased + " full, " + this.mFullHighPerfLocksReleased + " full high perf, " + this.mScanLocksReleased + " scan");
        pw.println();
        pw.println("Locks held:");
        this.mLocks.dump(pw);
        this.mWifiWatchdogStateMachine.dump(fd, pw, args);
        pw.println();
        this.mWifiStateMachine.dump(fd, pw, args);
        pw.println();
    }

    void enforceWakeSourcePermission(int uid, int pid) {
        if (uid == Process.myUid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", pid, uid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireWifiLock(IBinder binder, int lockMode, String tag, WorkSource ws) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        if (lockMode != 1 && lockMode != 2 && lockMode != 3) {
            Slog.e(TAG, "Illegal argument, lockMode= " + lockMode);
            return false;
        }
        if (ws != null && ws.size() == 0) {
            ws = null;
        }
        if (ws != null) {
            this.enforceWakeSourcePermission(Binder.getCallingUid(), Binder.getCallingPid());
        }
        if (ws == null) {
            ws = new WorkSource(Binder.getCallingUid());
        }
        WifiLock wifiLock = new WifiLock(lockMode, tag, binder, ws);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return this.acquireWifiLockLocked(wifiLock);
        }
    }

    private void noteAcquireWifiLock(WifiLock wifiLock) throws RemoteException {
        switch (wifiLock.mMode) {
            case 1: 
            case 2: 
            case 3: {
                this.mBatteryStats.noteFullWifiLockAcquiredFromSource(wifiLock.mWorkSource);
            }
        }
    }

    private void noteReleaseWifiLock(WifiLock wifiLock) throws RemoteException {
        switch (wifiLock.mMode) {
            case 1: 
            case 2: 
            case 3: {
                this.mBatteryStats.noteFullWifiLockReleasedFromSource(wifiLock.mWorkSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireWifiLockLocked(WifiLock wifiLock) {
        boolean bl;
        this.mLocks.addLock(wifiLock);
        long ident = Binder.clearCallingIdentity();
        try {
            this.noteAcquireWifiLock(wifiLock);
            switch (wifiLock.mMode) {
                case 1: {
                    ++this.mFullLocksAcquired;
                    break;
                }
                case 3: {
                    ++this.mFullHighPerfLocksAcquired;
                    break;
                }
                case 2: {
                    ++this.mScanLocksAcquired;
                }
            }
            this.mWifiController.sendMessage(155654);
            bl = true;
            Object var7_5 = null;
        }
        catch (RemoteException e) {
            boolean bl2;
            try {
                bl2 = false;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl2;
        }
        Binder.restoreCallingIdentity(ident);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) {
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        if (ws != null && ws.size() == 0) {
            ws = null;
        }
        if (ws != null) {
            this.enforceWakeSourcePermission(uid, pid);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                LockList lockList = this.mLocks;
                synchronized (lockList) {
                    int index = this.mLocks.findLockByBinder(lock);
                    if (index < 0) {
                        throw new IllegalArgumentException("Wifi lock not active");
                    }
                    WifiLock wl = (WifiLock)this.mLocks.mList.get(index);
                    this.noteReleaseWifiLock(wl);
                    wl.mWorkSource = ws != null ? new WorkSource(ws) : new WorkSource(uid);
                    this.noteAcquireWifiLock(wl);
                }
            }
            catch (RemoteException e) {
                Object var12_11 = null;
                Binder.restoreCallingIdentity(ident);
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseWifiLock(IBinder lock) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return this.releaseWifiLockLocked(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean releaseWifiLockLocked(IBinder lock) {
        WifiLock wifiLock = this.mLocks.removeLock(lock);
        boolean hadLock = wifiLock != null;
        long ident = Binder.clearCallingIdentity();
        try {
            block9: {
                try {
                    if (!hadLock) break block9;
                    this.noteReleaseWifiLock(wifiLock);
                    switch (wifiLock.mMode) {
                        case 1: {
                            ++this.mFullLocksReleased;
                            break;
                        }
                        case 3: {
                            ++this.mFullHighPerfLocksReleased;
                            break;
                        }
                        case 2: {
                            ++this.mScanLocksReleased;
                            break;
                        }
                    }
                    this.mWifiController.sendMessage(155654);
                }
                catch (RemoteException e) {
                    Object var8_6 = null;
                    Binder.restoreCallingIdentity(ident);
                    return hadLock;
                }
            }
            Object var8_5 = null;
            Binder.restoreCallingIdentity(ident);
            return hadLock;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeMulticastFiltering() {
        this.enforceMulticastChangePermission();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            if (this.mMulticasters.size() != 0) {
                return;
            }
            this.mWifiStateMachine.startFilteringMulticastV4Packets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void acquireMulticastLock(IBinder binder, String tag) {
        this.enforceMulticastChangePermission();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            ++this.mMulticastEnabled;
            this.mMulticasters.add(new Multicaster(tag, binder));
            this.mWifiStateMachine.stopFilteringMulticastV4Packets();
        }
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.mBatteryStats.noteWifiMulticastEnabled(uid);
            }
            catch (RemoteException e) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity(ident);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseMulticastLock() {
        this.enforceMulticastChangePermission();
        int uid = Binder.getCallingUid();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            ++this.mMulticastDisabled;
            int size = this.mMulticasters.size();
            for (int i = size - 1; i >= 0; --i) {
                Multicaster m = this.mMulticasters.get(i);
                if (m == null || m.getUid() != uid) continue;
                this.removeMulticasterLocked(i, uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeMulticasterLocked(int i, int uid) {
        Multicaster removed = this.mMulticasters.remove(i);
        if (removed != null) {
            removed.unlinkDeathRecipient();
        }
        if (this.mMulticasters.size() == 0) {
            this.mWifiStateMachine.startFilteringMulticastV4Packets();
        }
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.mBatteryStats.noteWifiMulticastDisabled(uid);
            }
            catch (RemoteException e) {
                Object var8_6 = null;
                Binder.restoreCallingIdentity(ident);
                return;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMulticastEnabled() {
        this.enforceAccessPermission();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            return this.mMulticasters.size() > 0;
        }
    }

    private class Multicaster
    extends DeathRecipient {
        Multicaster(String tag, IBinder binder) {
            super(Binder.getCallingUid(), tag, binder, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Slog.e(WifiService.TAG, "Multicaster binderDied");
            List list = WifiService.this.mMulticasters;
            synchronized (list) {
                int i = WifiService.this.mMulticasters.indexOf(this);
                if (i != -1) {
                    WifiService.this.removeMulticasterLocked(i, this.mMode);
                }
            }
        }

        public String toString() {
            return "Multicaster{" + this.mTag + " binder=" + this.mBinder + "}";
        }

        public int getUid() {
            return this.mMode;
        }
    }

    private abstract class DeathRecipient
    implements IBinder.DeathRecipient {
        String mTag;
        int mMode;
        IBinder mBinder;
        WorkSource mWorkSource;

        DeathRecipient(int mode, String tag, IBinder binder, WorkSource ws) {
            this.mTag = tag;
            this.mMode = mode;
            this.mBinder = binder;
            this.mWorkSource = ws;
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        void unlinkDeathRecipient() {
            this.mBinder.unlinkToDeath(this, 0);
        }
    }

    class LockList {
        private List<WifiLock> mList = new ArrayList<WifiLock>();

        private LockList() {
        }

        synchronized boolean hasLocks() {
            return !this.mList.isEmpty();
        }

        synchronized int getStrongestLockMode() {
            if (this.mList.isEmpty()) {
                return 1;
            }
            if (WifiService.this.mFullHighPerfLocksAcquired > WifiService.this.mFullHighPerfLocksReleased) {
                return 3;
            }
            if (WifiService.this.mFullLocksAcquired > WifiService.this.mFullLocksReleased) {
                return 1;
            }
            return 2;
        }

        synchronized void updateWorkSource(WorkSource ws) {
            for (int i = 0; i < WifiService.this.mLocks.mList.size(); ++i) {
                ws.add(WifiService.this.mLocks.mList.get((int)i).mWorkSource);
            }
        }

        private void addLock(WifiLock lock) {
            if (this.findLockByBinder(lock.mBinder) < 0) {
                this.mList.add(lock);
            }
        }

        private WifiLock removeLock(IBinder binder) {
            int index = this.findLockByBinder(binder);
            if (index >= 0) {
                WifiLock ret = this.mList.remove(index);
                ret.unlinkDeathRecipient();
                return ret;
            }
            return null;
        }

        private int findLockByBinder(IBinder binder) {
            int size = this.mList.size();
            for (int i = size - 1; i >= 0; --i) {
                if (this.mList.get((int)i).mBinder != binder) continue;
                return i;
            }
            return -1;
        }

        private void dump(PrintWriter pw) {
            for (WifiLock l : this.mList) {
                pw.print("    ");
                pw.println(l);
            }
        }
    }

    private class WifiLock
    extends DeathRecipient {
        WifiLock(int lockMode, String tag, IBinder binder, WorkSource ws) {
            super(lockMode, tag, binder, ws);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            LockList lockList = WifiService.this.mLocks;
            synchronized (lockList) {
                WifiService.this.releaseWifiLockLocked(this.mBinder);
            }
        }

        public String toString() {
            return "WifiLock{" + this.mTag + " type=" + this.mMode + " binder=" + this.mBinder + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TdlsTask
    extends AsyncTask<TdlsTaskParams, Integer, Integer> {
        TdlsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected Integer doInBackground(TdlsTaskParams ... params) {
            block17: {
                BufferedReader reader;
                block16: {
                    TdlsTaskParams param = params[0];
                    String remoteIpAddress = param.remoteIpAddress.trim();
                    boolean enable = param.enable;
                    String macAddress = null;
                    reader = null;
                    reader = new BufferedReader(new FileReader("/proc/net/arp"));
                    String line = reader.readLine();
                    while ((line = reader.readLine()) != null) {
                        String[] tokens = line.split("[ ]+");
                        if (tokens.length < 6) continue;
                        String ip = tokens[0];
                        String mac = tokens[3];
                        if (!remoteIpAddress.equals(ip)) continue;
                        macAddress = mac;
                        break;
                    }
                    if (macAddress == null) {
                        Slog.w(WifiService.TAG, "Did not find remoteAddress {" + remoteIpAddress + "} in " + "/proc/net/arp");
                        break block16;
                    }
                    WifiService.this.enableTdlsWithMacAddress(macAddress, enable);
                }
                Object var12_13 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block17;
                }
                catch (IOException e2) {}
                break block17;
                {
                    catch (FileNotFoundException e) {
                        Slog.e(WifiService.TAG, "Could not open /proc/net/arp to lookup mac address");
                        Object var12_14 = null;
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block17;
                        }
                        catch (IOException e2) {}
                        break block17;
                    }
                    catch (IOException e) {
                        Slog.e(WifiService.TAG, "Could not read /proc/net/arp to lookup mac address");
                        Object var12_15 = null;
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block17;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return 0;
        }
    }

    class TdlsTaskParams {
        public String remoteIpAddress;
        public boolean enable;

        TdlsTaskParams() {
        }
    }

    private class BatchedScanRequest
    extends DeathRecipient {
        final BatchedScanSettings settings;
        final int uid;
        final int pid;
        final WorkSource workSource;

        BatchedScanRequest(BatchedScanSettings settings, IBinder binder, WorkSource ws) {
            super(0, null, binder, null);
            this.settings = settings;
            this.uid = Binder.getCallingUid();
            this.pid = Binder.getCallingPid();
            this.workSource = ws;
        }

        public void binderDied() {
            WifiService.this.stopBatchedScan(this.settings, this.uid, this.pid);
        }

        public String toString() {
            return "BatchedScanRequest{settings=" + this.settings + ", binder=" + this.mBinder + "}";
        }

        public boolean isSameApp(int uid, int pid) {
            return this.uid == uid && this.pid == pid;
        }
    }

    private class WifiStateMachineHandler
    extends Handler {
        private AsyncChannel mWsmChannel;

        WifiStateMachineHandler(Looper looper) {
            super(looper);
            this.mWsmChannel = new AsyncChannel();
            this.mWsmChannel.connect(WifiService.this.mContext, (Handler)this, WifiService.this.mWifiStateMachine.getHandler());
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        WifiService.this.mWifiStateMachineChannel = this.mWsmChannel;
                        break;
                    }
                    Slog.e(WifiService.TAG, "WifiStateMachine connection failure, error=" + msg.arg1);
                    WifiService.this.mWifiStateMachineChannel = null;
                    break;
                }
                case 69636: {
                    Slog.e(WifiService.TAG, "WifiStateMachine channel lost, msg.arg1 =" + msg.arg1);
                    WifiService.this.mWifiStateMachineChannel = null;
                    this.mWsmChannel.connect(WifiService.this.mContext, (Handler)this, WifiService.this.mWifiStateMachine.getHandler());
                    break;
                }
                default: {
                    Slog.d(WifiService.TAG, "WifiStateMachineHandler.handleMessage ignoring msg=" + msg);
                }
            }
        }
    }

    private class ClientHandler
    extends Handler {
        ClientHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        WifiService.this.mTrafficPoller.addClient(msg.replyTo);
                        break;
                    }
                    Slog.e(WifiService.TAG, "Client connection failure, error=" + msg.arg1);
                    break;
                }
                case 69636: {
                    if (msg.arg1 == 2) {
                        // empty if block
                    }
                    WifiService.this.mTrafficPoller.removeClient(msg.replyTo);
                    break;
                }
                case 69633: {
                    AsyncChannel ac = new AsyncChannel();
                    ac.connect(WifiService.this.mContext, (Handler)this, msg.replyTo);
                    break;
                }
                case 151553: 
                case 151559: {
                    WifiConfiguration config = (WifiConfiguration)msg.obj;
                    int networkId = msg.arg1;
                    if (config != null && config.isValid()) {
                        if (config.proxySettings != WifiConfiguration.ProxySettings.PAC) {
                            WifiService.this.mWifiStateMachine.sendMessage(Message.obtain(msg));
                            break;
                        }
                        Slog.e(WifiService.TAG, "ClientHandler.handleMessage cannot process msg with PAC");
                        if (msg.what == 151553) {
                            this.replyFailed(msg, 151554);
                            break;
                        }
                        this.replyFailed(msg, 151560);
                        break;
                    }
                    if (config == null && networkId != -1) {
                        WifiService.this.mWifiStateMachine.sendMessage(Message.obtain(msg));
                        break;
                    }
                    Slog.e(WifiService.TAG, "ClientHandler.handleMessage ignoring invalid msg=" + msg);
                    if (msg.what == 151553) {
                        this.replyFailed(msg, 151554);
                        break;
                    }
                    this.replyFailed(msg, 151560);
                    break;
                }
                case 151556: 
                case 151562: 
                case 151566: 
                case 151569: 
                case 151572: {
                    WifiService.this.mWifiStateMachine.sendMessage(Message.obtain(msg));
                    break;
                }
                default: {
                    Slog.d(WifiService.TAG, "ClientHandler.handleMessage ignoring msg=" + msg);
                }
            }
        }

        private void replyFailed(Message msg, int what) {
            Message reply = msg.obtain();
            reply.what = what;
            reply.arg1 = 8;
            try {
                msg.replyTo.send(reply);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }
}

