/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import android.app.UiAutomation;
import android.os.SystemClock;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.uiautomator.core.UiAutomatorBridge;
import com.android.uiautomator.core.UiSelector;

class QueryController {
    private static final String LOG_TAG = QueryController.class.getSimpleName();
    private static final boolean DEBUG = Log.isLoggable(LOG_TAG, 3);
    private static final boolean VERBOSE = Log.isLoggable(LOG_TAG, 2);
    private final UiAutomatorBridge mUiAutomatorBridge;
    private final Object mLock = new Object();
    private String mLastActivityName = null;
    private int mPatternCounter = 0;
    private int mPatternIndexer = 0;
    private int mLogIndent = 0;
    private int mLogParentIndent = 0;
    private String mLastTraversedText = "";

    public QueryController(UiAutomatorBridge bridge) {
        this.mUiAutomatorBridge = bridge;
        bridge.setOnAccessibilityEventListener(new UiAutomation.OnAccessibilityEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAccessibilityEvent(AccessibilityEvent event) {
                Object object = QueryController.this.mLock;
                synchronized (object) {
                    switch (event.getEventType()) {
                        case 32: {
                            if (event.getText() == null || event.getText().size() <= 0 || event.getText().get(0) == null) break;
                            QueryController.this.mLastActivityName = ((Object)event.getText().get(0)).toString();
                            break;
                        }
                        case 131072: {
                            if (event.getText() != null && event.getText().size() > 0 && event.getText().get(0) != null) {
                                QueryController.this.mLastTraversedText = ((Object)event.getText().get(0)).toString();
                            }
                            if (!DEBUG) break;
                            Log.d(LOG_TAG, "Last text selection reported: " + QueryController.this.mLastTraversedText);
                        }
                    }
                    QueryController.this.mLock.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastTraversedText() {
        this.mUiAutomatorBridge.waitForIdle();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastTraversedText.length() > 0) {
                return this.mLastTraversedText;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLastTraversedText() {
        this.mUiAutomatorBridge.waitForIdle();
        Object object = this.mLock;
        synchronized (object) {
            this.mLastTraversedText = "";
        }
    }

    private void initializeNewSearch() {
        this.mPatternCounter = 0;
        this.mPatternIndexer = 0;
        this.mLogIndent = 0;
        this.mLogParentIndent = 0;
    }

    public int getPatternCount(UiSelector selector) {
        this.findAccessibilityNodeInfo(selector, true);
        return this.mPatternCounter;
    }

    public AccessibilityNodeInfo findAccessibilityNodeInfo(UiSelector selector) {
        return this.findAccessibilityNodeInfo(selector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccessibilityNodeInfo findAccessibilityNodeInfo(UiSelector selector, boolean isCounting) {
        this.mUiAutomatorBridge.waitForIdle();
        this.initializeNewSearch();
        if (DEBUG) {
            Log.d(LOG_TAG, "Searching: " + selector);
        }
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityNodeInfo rootNode = this.getRootNode();
            if (rootNode == null) {
                Log.e(LOG_TAG, "Cannot proceed when root node is null. Aborted search");
                return null;
            }
            UiSelector uiSelector = new UiSelector(selector);
            return this.translateCompoundSelector(uiSelector, rootNode, isCounting);
        }
    }

    protected AccessibilityNodeInfo getRootNode() {
        int maxRetry = 4;
        long waitInterval = 250L;
        AccessibilityNodeInfo rootNode = null;
        for (int x = 0; x < 4; ++x) {
            rootNode = this.mUiAutomatorBridge.getRootInActiveWindow();
            if (rootNode != null) {
                return rootNode;
            }
            if (x >= 3) continue;
            Log.e(LOG_TAG, "Got null root node from accessibility - Retrying...");
            SystemClock.sleep(250L);
        }
        return rootNode;
    }

    private AccessibilityNodeInfo translateCompoundSelector(UiSelector selector, AccessibilityNodeInfo fromNode, boolean isCounting) {
        if (selector.hasContainerSelector()) {
            if (selector.getContainerSelector().hasContainerSelector()) {
                fromNode = this.translateCompoundSelector(selector.getContainerSelector(), fromNode, false);
                this.initializeNewSearch();
            } else {
                fromNode = this.translateReqularSelector(selector.getContainerSelector(), fromNode);
            }
        } else {
            fromNode = this.translateReqularSelector(selector, fromNode);
        }
        if (fromNode == null) {
            if (DEBUG) {
                Log.d(LOG_TAG, "Container selector not found: " + selector.dumpToString(false));
            }
            return null;
        }
        if (selector.hasPatternSelector()) {
            fromNode = this.translatePatternSelector(selector.getPatternSelector(), fromNode, isCounting);
            if (isCounting) {
                Log.i(LOG_TAG, String.format("Counted %d instances of: %s", this.mPatternCounter, selector));
                return null;
            }
            if (fromNode == null) {
                if (DEBUG) {
                    Log.d(LOG_TAG, "Pattern selector not found: " + selector.dumpToString(false));
                }
                return null;
            }
        }
        if ((selector.hasContainerSelector() || selector.hasPatternSelector()) && (selector.hasChildSelector() || selector.hasParentSelector())) {
            fromNode = this.translateReqularSelector(selector, fromNode);
        }
        if (fromNode == null) {
            if (DEBUG) {
                Log.d(LOG_TAG, "Object Not Found for selector " + selector);
            }
            return null;
        }
        Log.i(LOG_TAG, String.format("Matched selector: %s <<==>> [%s]", selector, fromNode));
        return fromNode;
    }

    private AccessibilityNodeInfo translateReqularSelector(UiSelector selector, AccessibilityNodeInfo fromNode) {
        return this.findNodeRegularRecursive(selector, fromNode, 0);
    }

    private AccessibilityNodeInfo findNodeRegularRecursive(UiSelector subSelector, AccessibilityNodeInfo fromNode, int index) {
        if (subSelector.isMatchFor(fromNode, index)) {
            if (DEBUG) {
                Log.d(LOG_TAG, this.formatLog(String.format("%s", subSelector.dumpToString(false))));
            }
            if (subSelector.isLeaf()) {
                return fromNode;
            }
            if (subSelector.hasChildSelector()) {
                ++this.mLogIndent;
                if ((subSelector = subSelector.getChildSelector()) == null) {
                    Log.e(LOG_TAG, "Error: A child selector without content");
                    return null;
                }
            } else if (subSelector.hasParentSelector()) {
                ++this.mLogIndent;
                if ((subSelector = subSelector.getParentSelector()) == null) {
                    Log.e(LOG_TAG, "Error: A parent selector without content");
                    return null;
                }
                if ((fromNode = fromNode.getParent()) == null) {
                    return null;
                }
            }
        }
        int childCount = fromNode.getChildCount();
        boolean hasNullChild = false;
        for (int i = 0; i < childCount; ++i) {
            AccessibilityNodeInfo childNode = fromNode.getChild(i);
            if (childNode == null) {
                Log.w(LOG_TAG, String.format("AccessibilityNodeInfo returned a null child (%d of %d)", i, childCount));
                if (!hasNullChild) {
                    Log.w(LOG_TAG, String.format("parent = %s", fromNode.toString()));
                }
                hasNullChild = true;
                continue;
            }
            if (!childNode.isVisibleToUser()) {
                if (!VERBOSE) continue;
                Log.v(LOG_TAG, String.format("Skipping invisible child: %s", childNode.toString()));
                continue;
            }
            AccessibilityNodeInfo retNode = this.findNodeRegularRecursive(subSelector, childNode, i);
            if (retNode == null) continue;
            return retNode;
        }
        return null;
    }

    private AccessibilityNodeInfo translatePatternSelector(UiSelector subSelector, AccessibilityNodeInfo fromNode, boolean isCounting) {
        if (subSelector.hasPatternSelector()) {
            this.mPatternIndexer = isCounting ? -1 : subSelector.getInstance();
            if ((subSelector = subSelector.getPatternSelector()) == null) {
                Log.e(LOG_TAG, "Pattern portion of the selector is null or not defined");
                return null;
            }
            this.mLogParentIndent = ++this.mLogIndent;
            return this.findNodePatternRecursive(subSelector, fromNode, 0, subSelector);
        }
        Log.e(LOG_TAG, "Selector must have a pattern selector defined");
        return null;
    }

    private AccessibilityNodeInfo findNodePatternRecursive(UiSelector subSelector, AccessibilityNodeInfo fromNode, int index, UiSelector originalPattern) {
        if (subSelector.isMatchFor(fromNode, index)) {
            if (subSelector.isLeaf()) {
                if (this.mPatternIndexer == 0) {
                    if (DEBUG) {
                        Log.d(LOG_TAG, this.formatLog(String.format("%s", subSelector.dumpToString(false))));
                    }
                    return fromNode;
                }
                if (DEBUG) {
                    Log.d(LOG_TAG, this.formatLog(String.format("%s", subSelector.dumpToString(false))));
                }
                ++this.mPatternCounter;
                --this.mPatternIndexer;
                subSelector = originalPattern;
                this.mLogIndent = this.mLogParentIndent;
            } else {
                if (DEBUG) {
                    Log.d(LOG_TAG, this.formatLog(String.format("%s", subSelector.dumpToString(false))));
                }
                if (subSelector.hasChildSelector()) {
                    ++this.mLogIndent;
                    if ((subSelector = subSelector.getChildSelector()) == null) {
                        Log.e(LOG_TAG, "Error: A child selector without content");
                        return null;
                    }
                } else if (subSelector.hasParentSelector()) {
                    ++this.mLogIndent;
                    if ((subSelector = subSelector.getParentSelector()) == null) {
                        Log.e(LOG_TAG, "Error: A parent selector without content");
                        return null;
                    }
                    if ((fromNode = fromNode.getParent()) == null) {
                        return null;
                    }
                }
            }
        }
        int childCount = fromNode.getChildCount();
        boolean hasNullChild = false;
        for (int i = 0; i < childCount; ++i) {
            AccessibilityNodeInfo childNode = fromNode.getChild(i);
            if (childNode == null) {
                Log.w(LOG_TAG, String.format("AccessibilityNodeInfo returned a null child (%d of %d)", i, childCount));
                if (!hasNullChild) {
                    Log.w(LOG_TAG, String.format("parent = %s", fromNode.toString()));
                }
                hasNullChild = true;
                continue;
            }
            if (!childNode.isVisibleToUser()) {
                if (!DEBUG) continue;
                Log.d(LOG_TAG, String.format("Skipping invisible child: %s", childNode.toString()));
                continue;
            }
            AccessibilityNodeInfo retNode = this.findNodePatternRecursive(subSelector, childNode, i, originalPattern);
            if (retNode == null) continue;
            return retNode;
        }
        return null;
    }

    public AccessibilityNodeInfo getAccessibilityRootNode() {
        return this.mUiAutomatorBridge.getRootInActiveWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getCurrentActivityName() {
        this.mUiAutomatorBridge.waitForIdle();
        Object object = this.mLock;
        synchronized (object) {
            return this.mLastActivityName;
        }
    }

    public String getCurrentPackageName() {
        this.mUiAutomatorBridge.waitForIdle();
        AccessibilityNodeInfo rootNode = this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        return rootNode.getPackageName() != null ? ((Object)rootNode.getPackageName()).toString() : null;
    }

    private String formatLog(String str) {
        StringBuilder l = new StringBuilder();
        for (int space = 0; space < this.mLogIndent; ++space) {
            l.append(". . ");
        }
        if (this.mLogIndent > 0) {
            l.append(String.format(". . [%d]: %s", this.mPatternCounter, str));
        } else {
            l.append(String.format(". . [%d]: %s", this.mPatternCounter, str));
        }
        return l.toString();
    }
}

