/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.UiAutomation;
import android.content.IContentProvider;
import android.database.Cursor;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Binder;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Log;
import android.view.Display;
import android.view.IWindowManager;
import com.android.uiautomator.core.UiAutomatorBridge;

public class ShellUiAutomatorBridge
extends UiAutomatorBridge {
    private static final String LOG_TAG = ShellUiAutomatorBridge.class.getSimpleName();

    public ShellUiAutomatorBridge(UiAutomation uiAutomation) {
        super(uiAutomation);
    }

    public Display getDefaultDisplay() {
        return DisplayManagerGlobal.getInstance().getRealDisplay(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSystemLongPressTime() {
        long longPressTimeout = 0L;
        try {
            IContentProvider provider = null;
            Cursor cursor = null;
            IActivityManager activityManager = ActivityManagerNative.getDefault();
            String providerName = Settings.Secure.CONTENT_URI.getAuthority();
            Binder token = new Binder();
            try {
                IActivityManager.ContentProviderHolder holder = activityManager.getContentProviderExternal(providerName, 0, token);
                if (holder == null) {
                    throw new IllegalStateException("Could not find provider: " + providerName);
                }
                provider = holder.provider;
                cursor = provider.query(null, Settings.Secure.CONTENT_URI, new String[]{"value"}, "name=?", new String[]{"long_press_timeout"}, null, null);
                if (cursor.moveToFirst()) {
                    longPressTimeout = cursor.getInt(0);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (provider != null) {
                    activityManager.removeContentProviderExternal(providerName, token);
                }
            }
        }
        catch (RemoteException e) {
            String message = "Error reading long press timeout setting.";
            Log.e(LOG_TAG, message, e);
            throw new RuntimeException(message, e);
        }
        return longPressTimeout;
    }

    public int getRotation() {
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        int ret = -1;
        try {
            ret = wm.getRotation();
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error getting screen rotation", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public boolean isScreenOn() {
        IPowerManager pm = IPowerManager.Stub.asInterface(ServiceManager.getService("power"));
        boolean ret = false;
        try {
            ret = pm.isScreenOn();
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error getting screen status", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

