/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import android.app.UiAutomation;
import android.graphics.Point;
import android.os.Build;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.uiautomator.core.AccessibilityNodeInfoDumper;
import com.android.uiautomator.core.Configurator;
import com.android.uiautomator.core.Tracer;
import com.android.uiautomator.core.UiAutomatorBridge;
import com.android.uiautomator.core.UiWatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class UiDevice {
    private static final String LOG_TAG = UiDevice.class.getSimpleName();
    private static final long KEY_PRESS_EVENT_TIMEOUT = 1000L;
    private final HashMap<String, UiWatcher> mWatchers = new HashMap();
    private final List<String> mWatchersTriggers = new ArrayList<String>();
    private boolean mInWatcherContext = false;
    private UiAutomatorBridge mUiAutomationBridge;
    private static UiDevice sDevice;

    private UiDevice() {
    }

    public void initialize(UiAutomatorBridge uiAutomatorBridge) {
        this.mUiAutomationBridge = uiAutomatorBridge;
    }

    boolean isInWatcherContext() {
        return this.mInWatcherContext;
    }

    UiAutomatorBridge getAutomatorBridge() {
        if (this.mUiAutomationBridge == null) {
            throw new RuntimeException("UiDevice not initialized");
        }
        return this.mUiAutomationBridge;
    }

    public void setCompressedLayoutHeirarchy(boolean compressed) {
        this.getAutomatorBridge().setCompressedLayoutHierarchy(compressed);
    }

    public static UiDevice getInstance() {
        if (sDevice == null) {
            sDevice = new UiDevice();
        }
        return sDevice;
    }

    public Point getDisplaySizeDp() {
        Tracer.trace(new Object[0]);
        Display display = this.getAutomatorBridge().getDefaultDisplay();
        Point p = new Point();
        display.getRealSize(p);
        DisplayMetrics metrics = new DisplayMetrics();
        display.getRealMetrics(metrics);
        float dpx = (float)p.x / metrics.density;
        float dpy = (float)p.y / metrics.density;
        p.x = Math.round(dpx);
        p.y = Math.round(dpy);
        return p;
    }

    public String getProductName() {
        Tracer.trace(new Object[0]);
        return Build.PRODUCT;
    }

    public String getLastTraversedText() {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getQueryController().getLastTraversedText();
    }

    public void clearLastTraversedText() {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getQueryController().clearLastTraversedText();
    }

    public boolean pressMenu() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKeyAndWaitForEvent(82, 0, 2048, 1000L);
    }

    public boolean pressBack() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKeyAndWaitForEvent(4, 0, 2048, 1000L);
    }

    public boolean pressHome() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKeyAndWaitForEvent(3, 0, 2048, 1000L);
    }

    public boolean pressSearch() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(84);
    }

    public boolean pressDPadCenter() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(23);
    }

    public boolean pressDPadDown() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(20);
    }

    public boolean pressDPadUp() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(19);
    }

    public boolean pressDPadLeft() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(21);
    }

    public boolean pressDPadRight() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(22);
    }

    public boolean pressDelete() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(67);
    }

    public boolean pressEnter() {
        Tracer.trace(new Object[0]);
        return this.pressKeyCode(66);
    }

    public boolean pressKeyCode(int keyCode) {
        Tracer.trace(keyCode);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKey(keyCode, 0);
    }

    public boolean pressKeyCode(int keyCode, int metaState) {
        Tracer.trace(keyCode, metaState);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().sendKey(keyCode, metaState);
    }

    public boolean pressRecentApps() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().toggleRecentApps();
    }

    public boolean openNotification() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().openNotification();
    }

    public boolean openQuickSettings() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getInteractionController().openQuickSettings();
    }

    public int getDisplayWidth() {
        Tracer.trace(new Object[0]);
        Display display = this.getAutomatorBridge().getDefaultDisplay();
        Point p = new Point();
        display.getSize(p);
        return p.x;
    }

    public int getDisplayHeight() {
        Tracer.trace(new Object[0]);
        Display display = this.getAutomatorBridge().getDefaultDisplay();
        Point p = new Point();
        display.getSize(p);
        return p.y;
    }

    public boolean click(int x, int y) {
        Tracer.trace(x, y);
        if (x >= this.getDisplayWidth() || y >= this.getDisplayHeight()) {
            return false;
        }
        return this.getAutomatorBridge().getInteractionController().clickNoSync(x, y);
    }

    public boolean swipe(int startX, int startY, int endX, int endY, int steps) {
        Tracer.trace(startX, startY, endX, endY, steps);
        return this.getAutomatorBridge().getInteractionController().swipe(startX, startY, endX, endY, steps);
    }

    public boolean drag(int startX, int startY, int endX, int endY, int steps) {
        Tracer.trace(startX, startY, endX, endY, steps);
        return this.getAutomatorBridge().getInteractionController().swipe(startX, startY, endX, endY, steps, true);
    }

    public boolean swipe(Point[] segments, int segmentSteps) {
        Tracer.trace(segments, segmentSteps);
        return this.getAutomatorBridge().getInteractionController().swipe(segments, segmentSteps);
    }

    public void waitForIdle() {
        Tracer.trace(new Object[0]);
        this.waitForIdle(Configurator.getInstance().getWaitForIdleTimeout());
    }

    public void waitForIdle(long timeout) {
        Tracer.trace(timeout);
        this.getAutomatorBridge().waitForIdle(timeout);
    }

    @Deprecated
    public String getCurrentActivityName() {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getQueryController().getCurrentActivityName();
    }

    public String getCurrentPackageName() {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getQueryController().getCurrentPackageName();
    }

    public void registerWatcher(String name, UiWatcher watcher) {
        Tracer.trace(name, watcher);
        if (this.mInWatcherContext) {
            throw new IllegalStateException("Cannot register new watcher from within another");
        }
        this.mWatchers.put(name, watcher);
    }

    public void removeWatcher(String name) {
        Tracer.trace(name);
        if (this.mInWatcherContext) {
            throw new IllegalStateException("Cannot remove a watcher from within another");
        }
        this.mWatchers.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWatchers() {
        Tracer.trace(new Object[0]);
        if (this.mInWatcherContext) {
            return;
        }
        for (String watcherName : this.mWatchers.keySet()) {
            UiWatcher watcher = this.mWatchers.get(watcherName);
            if (watcher == null) continue;
            try {
                this.mInWatcherContext = true;
                if (!watcher.checkForCondition()) continue;
                this.setWatcherTriggered(watcherName);
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Exceuting watcher: " + watcherName, e);
            }
            finally {
                this.mInWatcherContext = false;
            }
        }
    }

    public void resetWatcherTriggers() {
        Tracer.trace(new Object[0]);
        this.mWatchersTriggers.clear();
    }

    public boolean hasWatcherTriggered(String watcherName) {
        Tracer.trace(watcherName);
        return this.mWatchersTriggers.contains(watcherName);
    }

    public boolean hasAnyWatcherTriggered() {
        Tracer.trace(new Object[0]);
        return this.mWatchersTriggers.size() > 0;
    }

    private void setWatcherTriggered(String watcherName) {
        Tracer.trace(watcherName);
        if (!this.hasWatcherTriggered(watcherName)) {
            this.mWatchersTriggers.add(watcherName);
        }
    }

    public boolean isNaturalOrientation() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        int ret = this.getAutomatorBridge().getRotation();
        return ret == 0 || ret == 2;
    }

    public int getDisplayRotation() {
        Tracer.trace(new Object[0]);
        this.waitForIdle();
        return this.getAutomatorBridge().getRotation();
    }

    public void freezeRotation() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().freezeRotation();
    }

    public void unfreezeRotation() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().unfreezeRotation();
    }

    public void setOrientationLeft() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().setRotationLeft();
        this.waitForIdle();
    }

    public void setOrientationRight() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().setRotationRight();
        this.waitForIdle();
    }

    public void setOrientationNatural() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().setRotationNatural();
        this.waitForIdle();
    }

    public void wakeUp() throws RemoteException {
        Tracer.trace(new Object[0]);
        if (this.getAutomatorBridge().getInteractionController().wakeDevice()) {
            SystemClock.sleep(500L);
        }
    }

    public boolean isScreenOn() throws RemoteException {
        Tracer.trace(new Object[0]);
        return this.getAutomatorBridge().getInteractionController().isScreenOn();
    }

    public void sleep() throws RemoteException {
        Tracer.trace(new Object[0]);
        this.getAutomatorBridge().getInteractionController().sleepDevice();
    }

    public void dumpWindowHierarchy(String fileName) {
        Tracer.trace(fileName);
        AccessibilityNodeInfo root = this.getAutomatorBridge().getQueryController().getAccessibilityRootNode();
        if (root != null) {
            Display display = this.getAutomatorBridge().getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            AccessibilityNodeInfoDumper.dumpWindowToFile(root, new File(new File(Environment.getDataDirectory(), "local/tmp"), fileName), display.getRotation(), size.x, size.y);
        }
    }

    public boolean waitForWindowUpdate(final String packageName, long timeout) {
        Tracer.trace(packageName, timeout);
        if (packageName != null && !packageName.equals(this.getCurrentPackageName())) {
            return false;
        }
        Runnable emptyRunnable = new Runnable(){

            public void run() {
            }
        };
        UiAutomation.AccessibilityEventFilter checkWindowUpdate = new UiAutomation.AccessibilityEventFilter(){

            public boolean accept(AccessibilityEvent t) {
                if (t.getEventType() == 2048) {
                    return packageName == null || packageName.equals(t.getPackageName());
                }
                return false;
            }
        };
        try {
            this.getAutomatorBridge().executeCommandAndWaitForAccessibilityEvent(emptyRunnable, checkWindowUpdate, timeout);
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "waitForWindowUpdate: general exception from bridge", e);
            return false;
        }
        return true;
    }

    public boolean takeScreenshot(File storePath) {
        Tracer.trace(storePath);
        return this.takeScreenshot(storePath, 1.0f, 90);
    }

    public boolean takeScreenshot(File storePath, float scale, int quality) {
        Tracer.trace(storePath, Float.valueOf(scale), quality);
        return this.getAutomatorBridge().takeScreenshot(storePath, quality);
    }
}

