/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.core;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.uiautomator.core.AccessibilityNodeInfoHelper;
import com.android.uiautomator.core.Configurator;
import com.android.uiautomator.core.InteractionController;
import com.android.uiautomator.core.QueryController;
import com.android.uiautomator.core.Tracer;
import com.android.uiautomator.core.UiDevice;
import com.android.uiautomator.core.UiObjectNotFoundException;
import com.android.uiautomator.core.UiSelector;

public class UiObject {
    private static final String LOG_TAG = UiObject.class.getSimpleName();
    @Deprecated
    protected static final long WAIT_FOR_SELECTOR_TIMEOUT = 10000L;
    protected static final long WAIT_FOR_SELECTOR_POLL = 1000L;
    protected static final long WAIT_FOR_WINDOW_TMEOUT = 5500L;
    protected static final int SWIPE_MARGIN_LIMIT = 5;
    @Deprecated
    protected static final long WAIT_FOR_EVENT_TMEOUT = 3000L;
    protected static final int FINGER_TOUCH_HALF_WIDTH = 20;
    private final UiSelector mSelector;
    private final Configurator mConfig = Configurator.getInstance();

    public UiObject(UiSelector selector) {
        this.mSelector = selector;
    }

    public final UiSelector getSelector() {
        Tracer.trace(new Object[0]);
        return new UiSelector(this.mSelector);
    }

    QueryController getQueryController() {
        return UiDevice.getInstance().getAutomatorBridge().getQueryController();
    }

    InteractionController getInteractionController() {
        return UiDevice.getInstance().getAutomatorBridge().getInteractionController();
    }

    public UiObject getChild(UiSelector selector) throws UiObjectNotFoundException {
        Tracer.trace(selector);
        return new UiObject(this.getSelector().childSelector(selector));
    }

    public UiObject getFromParent(UiSelector selector) throws UiObjectNotFoundException {
        Tracer.trace(selector);
        return new UiObject(this.getSelector().fromParent(selector));
    }

    public int getChildCount() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.getChildCount();
    }

    protected AccessibilityNodeInfo findAccessibilityNodeInfo(long timeout) {
        AccessibilityNodeInfo node = null;
        long startMills = SystemClock.uptimeMillis();
        long currentMills = 0L;
        while (currentMills <= timeout && (node = this.getQueryController().findAccessibilityNodeInfo(this.getSelector())) == null) {
            UiDevice.getInstance().runWatchers();
            currentMills = SystemClock.uptimeMillis() - startMills;
            if (timeout <= 0L) continue;
            SystemClock.sleep(1000L);
        }
        return node;
    }

    public boolean dragTo(UiObject destObj, int steps) throws UiObjectNotFoundException {
        Rect srcRect = this.getVisibleBounds();
        Rect dstRect = destObj.getVisibleBounds();
        return this.getInteractionController().swipe(srcRect.centerX(), srcRect.centerY(), dstRect.centerX(), dstRect.centerY(), steps, true);
    }

    public boolean dragTo(int destX, int destY, int steps) throws UiObjectNotFoundException {
        Rect srcRect = this.getVisibleBounds();
        return this.getInteractionController().swipe(srcRect.centerX(), srcRect.centerY(), destX, destY, steps, true);
    }

    public boolean swipeUp(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.height() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.centerX(), rect.bottom - 5, rect.centerX(), rect.top + 5, steps);
    }

    public boolean swipeDown(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.height() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.centerX(), rect.top + 5, rect.centerX(), rect.bottom - 5, steps);
    }

    public boolean swipeLeft(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.width() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.right - 5, rect.centerY(), rect.left + 5, rect.centerY(), steps);
    }

    public boolean swipeRight(int steps) throws UiObjectNotFoundException {
        Tracer.trace(steps);
        Rect rect = this.getVisibleBounds();
        if (rect.width() <= 10) {
            return false;
        }
        return this.getInteractionController().swipe(rect.left + 5, rect.centerY(), rect.right - 5, rect.centerY(), steps);
    }

    private Rect getVisibleBounds(AccessibilityNodeInfo node) {
        if (node == null) {
            return null;
        }
        int w = UiDevice.getInstance().getDisplayWidth();
        int h = UiDevice.getInstance().getDisplayHeight();
        Rect nodeRect = AccessibilityNodeInfoHelper.getVisibleBoundsInScreen(node, w, h);
        AccessibilityNodeInfo scrollableParentNode = this.getScrollableParent(node);
        if (scrollableParentNode == null) {
            return nodeRect;
        }
        Rect parentRect = AccessibilityNodeInfoHelper.getVisibleBoundsInScreen(scrollableParentNode, w, h);
        nodeRect.intersect(parentRect);
        return nodeRect;
    }

    private AccessibilityNodeInfo getScrollableParent(AccessibilityNodeInfo node) {
        AccessibilityNodeInfo parent = node;
        while (parent != null) {
            if ((parent = parent.getParent()) == null || !parent.isScrollable()) continue;
            return parent;
        }
        return null;
    }

    public boolean click() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickAndSync(rect.centerX(), rect.centerY(), this.mConfig.getActionAcknowledgmentTimeout());
    }

    public boolean clickAndWaitForNewWindow() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        return this.clickAndWaitForNewWindow(5500L);
    }

    public boolean clickAndWaitForNewWindow(long timeout) throws UiObjectNotFoundException {
        Tracer.trace(timeout);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickAndWaitForNewWindow(rect.centerX(), rect.centerY(), this.mConfig.getActionAcknowledgmentTimeout());
    }

    public boolean clickTopLeft() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickNoSync(rect.left + 5, rect.top + 5);
    }

    public boolean longClickBottomRight() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().longTapNoSync(rect.right - 5, rect.bottom - 5);
    }

    public boolean clickBottomRight() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().clickNoSync(rect.right - 5, rect.bottom - 5);
    }

    public boolean longClick() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().longTapNoSync(rect.centerX(), rect.centerY());
    }

    public boolean longClickTopLeft() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        return this.getInteractionController().longTapNoSync(rect.left + 5, rect.top + 5);
    }

    public String getText() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        String retVal = this.safeStringReturn(node.getText());
        Log.d(LOG_TAG, String.format("getText() = %s", retVal));
        return retVal;
    }

    public String getClassName() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        String retVal = this.safeStringReturn(node.getClassName());
        Log.d(LOG_TAG, String.format("getClassName() = %s", retVal));
        return retVal;
    }

    public String getContentDescription() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return this.safeStringReturn(node.getContentDescription());
    }

    public boolean setText(String text) throws UiObjectNotFoundException {
        Tracer.trace(text);
        this.clearTextField();
        return this.getInteractionController().sendText(text);
    }

    public void clearTextField() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        this.getInteractionController().longTapNoSync(rect.left + 20, rect.centerY());
        UiObject selectAll = new UiObject(new UiSelector().descriptionContains("Select all"));
        if (selectAll.waitForExists(50L)) {
            selectAll.click();
        }
        SystemClock.sleep(250L);
        this.getInteractionController().sendKey(67, 0);
    }

    public boolean isChecked() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isChecked();
    }

    public boolean isSelected() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isSelected();
    }

    public boolean isCheckable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isCheckable();
    }

    public boolean isEnabled() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isEnabled();
    }

    public boolean isClickable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isClickable();
    }

    public boolean isFocused() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isFocused();
    }

    public boolean isFocusable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isFocusable();
    }

    public boolean isScrollable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isScrollable();
    }

    public boolean isLongClickable() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return node.isLongClickable();
    }

    public String getPackageName() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return this.safeStringReturn(node.getPackageName());
    }

    public Rect getVisibleBounds() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        return this.getVisibleBounds(node);
    }

    public Rect getBounds() throws UiObjectNotFoundException {
        Tracer.trace(new Object[0]);
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect nodeRect = new Rect();
        node.getBoundsInScreen(nodeRect);
        return nodeRect;
    }

    public boolean waitForExists(long timeout) {
        Tracer.trace(timeout);
        return this.findAccessibilityNodeInfo(timeout) != null;
    }

    public boolean waitUntilGone(long timeout) {
        Tracer.trace(timeout);
        long startMills = SystemClock.uptimeMillis();
        long currentMills = 0L;
        while (currentMills <= timeout) {
            if (this.findAccessibilityNodeInfo(0L) == null) {
                return true;
            }
            currentMills = SystemClock.uptimeMillis() - startMills;
            if (timeout <= 0L) continue;
            SystemClock.sleep(1000L);
        }
        return false;
    }

    public boolean exists() {
        Tracer.trace(new Object[0]);
        return this.waitForExists(0L);
    }

    private String safeStringReturn(CharSequence cs) {
        if (cs == null) {
            return "";
        }
        return ((Object)cs).toString();
    }

    public boolean pinchOut(int percent, int steps) throws UiObjectNotFoundException {
        percent = percent < 0 ? 1 : (percent > 100 ? 100 : percent);
        float percentage = (float)percent / 100.0f;
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        if (rect.width() <= 40) {
            throw new IllegalStateException("Object width is too small for operation");
        }
        Point startPoint1 = new Point(rect.centerX() - 20, rect.centerY());
        Point startPoint2 = new Point(rect.centerX() + 20, rect.centerY());
        Point endPoint1 = new Point(rect.centerX() - (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        Point endPoint2 = new Point(rect.centerX() + (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        return this.performTwoPointerGesture(startPoint1, startPoint2, endPoint1, endPoint2, steps);
    }

    public boolean pinchIn(int percent, int steps) throws UiObjectNotFoundException {
        percent = percent < 0 ? 0 : (percent > 100 ? 100 : percent);
        float percentage = (float)percent / 100.0f;
        AccessibilityNodeInfo node = this.findAccessibilityNodeInfo(this.mConfig.getWaitForSelectorTimeout());
        if (node == null) {
            throw new UiObjectNotFoundException(this.getSelector().toString());
        }
        Rect rect = this.getVisibleBounds(node);
        if (rect.width() <= 40) {
            throw new IllegalStateException("Object width is too small for operation");
        }
        Point startPoint1 = new Point(rect.centerX() - (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        Point startPoint2 = new Point(rect.centerX() + (int)((float)(rect.width() / 2) * percentage), rect.centerY());
        Point endPoint1 = new Point(rect.centerX() - 20, rect.centerY());
        Point endPoint2 = new Point(rect.centerX() + 20, rect.centerY());
        return this.performTwoPointerGesture(startPoint1, startPoint2, endPoint1, endPoint2, steps);
    }

    public boolean performTwoPointerGesture(Point startPoint1, Point startPoint2, Point endPoint1, Point endPoint2, int steps) {
        if (steps == 0) {
            steps = 1;
        }
        float stepX1 = (endPoint1.x - startPoint1.x) / steps;
        float stepY1 = (endPoint1.y - startPoint1.y) / steps;
        float stepX2 = (endPoint2.x - startPoint2.x) / steps;
        float stepY2 = (endPoint2.y - startPoint2.y) / steps;
        int eventX1 = startPoint1.x;
        int eventY1 = startPoint1.y;
        int eventX2 = startPoint2.x;
        int eventY2 = startPoint2.y;
        MotionEvent.PointerCoords[] points1 = new MotionEvent.PointerCoords[steps + 2];
        MotionEvent.PointerCoords[] points2 = new MotionEvent.PointerCoords[steps + 2];
        for (int i = 0; i < steps + 1; ++i) {
            MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
            p1.x = eventX1;
            p1.y = eventY1;
            p1.pressure = 1.0f;
            p1.size = 1.0f;
            points1[i] = p1;
            MotionEvent.PointerCoords p2 = new MotionEvent.PointerCoords();
            p2.x = eventX2;
            p2.y = eventY2;
            p2.pressure = 1.0f;
            p2.size = 1.0f;
            points2[i] = p2;
            eventX1 = (int)((float)eventX1 + stepX1);
            eventY1 = (int)((float)eventY1 + stepY1);
            eventX2 = (int)((float)eventX2 + stepX2);
            eventY2 = (int)((float)eventY2 + stepY2);
        }
        MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
        p1.x = endPoint1.x;
        p1.y = endPoint1.y;
        p1.pressure = 1.0f;
        p1.size = 1.0f;
        points1[steps + 1] = p1;
        MotionEvent.PointerCoords p2 = new MotionEvent.PointerCoords();
        p2.x = endPoint2.x;
        p2.y = endPoint2.y;
        p2.pressure = 1.0f;
        p2.size = 1.0f;
        points2[steps + 1] = p2;
        return this.performMultiPointerGesture(points1, points2);
    }

    public boolean performMultiPointerGesture(MotionEvent.PointerCoords[] ... touches) {
        return this.getInteractionController().performMultiPointerGesture(touches);
    }
}

