/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.testrunner;

import android.app.IInstrumentationWatcher;
import android.content.ComponentName;
import android.os.Bundle;
import android.os.Debug;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.SystemClock;
import android.test.RepetitiveTest;
import android.util.Log;
import com.android.uiautomator.core.ShellUiAutomatorBridge;
import com.android.uiautomator.core.Tracer;
import com.android.uiautomator.core.UiAutomationShellWrapper;
import com.android.uiautomator.core.UiDevice;
import com.android.uiautomator.testrunner.IAutomationSupport;
import com.android.uiautomator.testrunner.TestCaseCollector;
import com.android.uiautomator.testrunner.UiAutomatorTestCase;
import com.android.uiautomator.testrunner.UiAutomatorTestCaseFilter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.textui.ResultPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiAutomatorTestRunner {
    private static final String LOGTAG = UiAutomatorTestRunner.class.getSimpleName();
    private static final int EXIT_OK = 0;
    private static final int EXIT_EXCEPTION = -1;
    private static final String HANDLER_THREAD_NAME = "UiAutomatorHandlerThread";
    private boolean mDebug;
    private boolean mMonkey;
    private Bundle mParams = null;
    private UiDevice mUiDevice;
    private List<String> mTestClasses = null;
    private final FakeInstrumentationWatcher mWatcher = new FakeInstrumentationWatcher();
    private final IAutomationSupport mAutomationSupport = new IAutomationSupport(){

        public void sendStatus(int resultCode, Bundle status) {
            UiAutomatorTestRunner.this.mWatcher.instrumentationStatus(null, resultCode, status);
        }
    };
    private final List<TestListener> mTestListeners = new ArrayList<TestListener>();
    private HandlerThread mHandlerThread;

    public void run(List<String> testClasses, Bundle params, boolean debug, boolean monkey) {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable ex) {
                Log.e(LOGTAG, "uncaught exception", ex);
                Bundle results = new Bundle();
                results.putString("shortMsg", ex.getClass().getName());
                results.putString("longMsg", ex.getMessage());
                UiAutomatorTestRunner.this.mWatcher.instrumentationFinished(null, 0, results);
                System.exit(-1);
            }
        });
        this.mTestClasses = testClasses;
        this.mParams = params;
        this.mDebug = debug;
        this.mMonkey = monkey;
        this.start();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        TestCaseCollector collector = this.getTestCaseCollector(this.getClass().getClassLoader());
        try {
            collector.addTestClasses(this.mTestClasses);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.mDebug) {
            Debug.waitForDebugger();
        }
        this.mHandlerThread = new HandlerThread(HANDLER_THREAD_NAME);
        this.mHandlerThread.setDaemon(true);
        this.mHandlerThread.start();
        UiAutomationShellWrapper automationWrapper = new UiAutomationShellWrapper();
        automationWrapper.connect();
        long startTime = SystemClock.uptimeMillis();
        TestResult testRunResult = new TestResult();
        String outputFormat = this.mParams.getString("outputFormat");
        List<TestCase> testCases = collector.getTestCases();
        Bundle testRunOutput = new Bundle();
        ResultReporter resultPrinter = "simple".equals(outputFormat) ? new SimpleResultPrinter(System.out, true) : new WatcherResultPrinter(testCases.size());
        try {
            automationWrapper.setRunAsMonkey(this.mMonkey);
            this.mUiDevice = UiDevice.getInstance();
            this.mUiDevice.initialize(new ShellUiAutomatorBridge(automationWrapper.getUiAutomation()));
            String traceType = this.mParams.getString("traceOutputMode");
            if (traceType != null) {
                Tracer.Mode mode = Tracer.Mode.valueOf(Tracer.Mode.class, traceType);
                if (mode == Tracer.Mode.FILE || mode == Tracer.Mode.ALL) {
                    String filename = this.mParams.getString("traceLogFilename");
                    if (filename == null) {
                        throw new RuntimeException("Name of log file not specified. Please specify it using traceLogFilename parameter");
                    }
                    Tracer.getInstance().setOutputFilename(filename);
                }
                Tracer.getInstance().setOutputMode(mode);
            }
            testRunResult.addListener(resultPrinter);
            for (TestListener listener : this.mTestListeners) {
                testRunResult.addListener(listener);
            }
            for (TestCase testCase : testCases) {
                this.prepareTestCase(testCase);
                testCase.run(testRunResult);
            }
        }
        catch (Throwable t) {
            resultPrinter.printUnexpectedError(t);
            testRunOutput.putString("shortMsg", t.getMessage());
        }
        finally {
            long runTime = SystemClock.uptimeMillis() - startTime;
            resultPrinter.print(testRunResult, runTime, testRunOutput);
            automationWrapper.disconnect();
            automationWrapper.setRunAsMonkey(false);
            this.mHandlerThread.quit();
        }
    }

    protected TestCaseCollector getTestCaseCollector(ClassLoader classLoader) {
        return new TestCaseCollector(classLoader, this.getTestCaseFilter());
    }

    public UiAutomatorTestCaseFilter getTestCaseFilter() {
        return new UiAutomatorTestCaseFilter();
    }

    protected void addTestListener(TestListener listener) {
        if (!this.mTestListeners.contains(listener)) {
            this.mTestListeners.add(listener);
        }
    }

    protected void removeTestListener(TestListener listener) {
        this.mTestListeners.remove(listener);
    }

    protected void prepareTestCase(TestCase testCase) {
        ((UiAutomatorTestCase)testCase).setAutomationSupport(this.mAutomationSupport);
        ((UiAutomatorTestCase)testCase).setUiDevice(this.mUiDevice);
        ((UiAutomatorTestCase)testCase).setParams(this.mParams);
    }

    private class SimpleResultPrinter
    extends ResultPrinter
    implements ResultReporter {
        private final boolean mFullOutput;

        public SimpleResultPrinter(PrintStream writer, boolean fullOutput) {
            super(writer);
            this.mFullOutput = fullOutput;
        }

        public void print(TestResult result, long runTime, Bundle testOutput) {
            this.printHeader(runTime);
            if (this.mFullOutput) {
                this.printErrors(result);
                this.printFailures(result);
            }
            this.printFooter(result);
        }

        public void printUnexpectedError(Throwable t) {
            if (this.mFullOutput) {
                this.getWriter().printf("Test run aborted due to unexpected exeption: %s", t.getMessage());
                t.printStackTrace(this.getWriter());
            }
        }
    }

    private class WatcherResultPrinter
    implements ResultReporter {
        private static final String REPORT_KEY_NUM_TOTAL = "numtests";
        private static final String REPORT_KEY_NAME_CLASS = "class";
        private static final String REPORT_KEY_NUM_CURRENT = "current";
        private static final String REPORT_KEY_NAME_TEST = "test";
        private static final String REPORT_KEY_NUM_ITERATIONS = "numiterations";
        private static final String REPORT_VALUE_ID = "UiAutomatorTestRunner";
        private static final String REPORT_KEY_STACK = "stack";
        private static final int REPORT_VALUE_RESULT_START = 1;
        private static final int REPORT_VALUE_RESULT_ERROR = -1;
        private static final int REPORT_VALUE_RESULT_FAILURE = -2;
        private final Bundle mResultTemplate = new Bundle();
        Bundle mTestResult;
        int mTestNum = 0;
        int mTestResultCode = 0;
        String mTestClass = null;
        private final SimpleResultPrinter mPrinter;
        private final ByteArrayOutputStream mStream;
        private final PrintStream mWriter;

        public WatcherResultPrinter(int numTests) {
            this.mResultTemplate.putString("id", REPORT_VALUE_ID);
            this.mResultTemplate.putInt(REPORT_KEY_NUM_TOTAL, numTests);
            this.mStream = new ByteArrayOutputStream();
            this.mWriter = new PrintStream(this.mStream);
            this.mPrinter = new SimpleResultPrinter(this.mWriter, false);
        }

        public void startTest(Test test) {
            String testClass = test.getClass().getName();
            String testName = ((TestCase)test).getName();
            this.mTestResult = new Bundle(this.mResultTemplate);
            this.mTestResult.putString(REPORT_KEY_NAME_CLASS, testClass);
            this.mTestResult.putString(REPORT_KEY_NAME_TEST, testName);
            this.mTestResult.putInt(REPORT_KEY_NUM_CURRENT, ++this.mTestNum);
            if (testClass != null && !testClass.equals(this.mTestClass)) {
                this.mTestResult.putString("stream", String.format("\n%s:", testClass));
                this.mTestClass = testClass;
            } else {
                this.mTestResult.putString("stream", "");
            }
            Method testMethod = null;
            try {
                testMethod = test.getClass().getMethod(testName, new Class[0]);
                if (testMethod.isAnnotationPresent(RepetitiveTest.class)) {
                    int numIterations = testMethod.getAnnotation(RepetitiveTest.class).numIterations();
                    this.mTestResult.putInt(REPORT_KEY_NUM_ITERATIONS, numIterations);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            UiAutomatorTestRunner.this.mAutomationSupport.sendStatus(1, this.mTestResult);
            this.mTestResultCode = 0;
            this.mPrinter.startTest(test);
        }

        public void addError(Test test, Throwable t) {
            this.mTestResult.putString(REPORT_KEY_STACK, BaseTestRunner.getFilteredTrace(t));
            this.mTestResultCode = -1;
            this.mTestResult.putString("stream", String.format("\nError in %s:\n%s", ((TestCase)test).getName(), BaseTestRunner.getFilteredTrace(t)));
            this.mPrinter.addError(test, t);
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.mTestResult.putString(REPORT_KEY_STACK, BaseTestRunner.getFilteredTrace((Throwable)((Object)t)));
            this.mTestResultCode = -2;
            this.mTestResult.putString("stream", String.format("\nFailure in %s:\n%s", ((TestCase)test).getName(), BaseTestRunner.getFilteredTrace((Throwable)((Object)t))));
            this.mPrinter.addFailure(test, t);
        }

        public void endTest(Test test) {
            if (this.mTestResultCode == 0) {
                this.mTestResult.putString("stream", ".");
            }
            UiAutomatorTestRunner.this.mAutomationSupport.sendStatus(this.mTestResultCode, this.mTestResult);
            this.mPrinter.endTest(test);
        }

        public void print(TestResult result, long runTime, Bundle testOutput) {
            this.mPrinter.print(result, runTime, testOutput);
            testOutput.putString("stream", String.format("\nTest results for %s=%s", this.getClass().getSimpleName(), this.mStream.toString()));
            this.mWriter.close();
            UiAutomatorTestRunner.this.mAutomationSupport.sendStatus(-1, testOutput);
        }

        public void printUnexpectedError(Throwable t) {
            this.mWriter.println(String.format("Test run aborted due to unexpected exception: %s", t.getMessage()));
            t.printStackTrace(this.mWriter);
        }
    }

    private static interface ResultReporter
    extends TestListener {
        public void print(TestResult var1, long var2, Bundle var4);

        public void printUnexpectedError(Throwable var1);
    }

    private class FakeInstrumentationWatcher
    implements IInstrumentationWatcher {
        private final boolean mRawMode = true;

        private FakeInstrumentationWatcher() {
        }

        public IBinder asBinder() {
            throw new UnsupportedOperationException("I'm just a fake!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void instrumentationStatus(ComponentName name, int resultCode, Bundle results) {
            FakeInstrumentationWatcher fakeInstrumentationWatcher = this;
            synchronized (fakeInstrumentationWatcher) {
                String pretty = null;
                if (pretty != null) {
                    System.out.print(pretty);
                } else {
                    if (results != null) {
                        for (String key : results.keySet()) {
                            System.out.println("INSTRUMENTATION_STATUS: " + key + "=" + results.get(key));
                        }
                    }
                    System.out.println("INSTRUMENTATION_STATUS_CODE: " + resultCode);
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void instrumentationFinished(ComponentName name, int resultCode, Bundle results) {
            FakeInstrumentationWatcher fakeInstrumentationWatcher = this;
            synchronized (fakeInstrumentationWatcher) {
                String pretty = null;
                if (pretty != null) {
                    System.out.println(pretty);
                } else {
                    if (results != null) {
                        for (String key : results.keySet()) {
                            System.out.println("INSTRUMENTATION_RESULT: " + key + "=" + results.get(key));
                        }
                    }
                    System.out.println("INSTRUMENTATION_CODE: " + resultCode);
                }
                this.notifyAll();
            }
        }
    }
}

