/*
 * Decompiled with CFR 0.152.
 */
package com.android.webview.chromium;

import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.GeolocationPermissions;
import android.webkit.WebIconDatabase;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewProvider;
import com.android.webview.chromium.CookieManagerAdapter;
import com.android.webview.chromium.DrawGLFunctor;
import com.android.webview.chromium.GeolocationPermissionsAdapter;
import com.android.webview.chromium.GraphicsUtils;
import com.android.webview.chromium.ResourceProvider;
import com.android.webview.chromium.WebIconDatabaseAdapter;
import com.android.webview.chromium.WebStorageAdapter;
import com.android.webview.chromium.WebViewChromium;
import com.android.webview.chromium.WebViewDatabaseAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.chromium.android_webview.AwBrowserContext;
import org.chromium.android_webview.AwBrowserProcess;
import org.chromium.android_webview.AwContents;
import org.chromium.android_webview.AwCookieManager;
import org.chromium.android_webview.AwDevToolsServer;
import org.chromium.android_webview.AwQuotaManagerBridge;
import org.chromium.android_webview.AwSettings;
import org.chromium.base.PathService;
import org.chromium.base.ThreadUtils;
import org.chromium.content.app.ContentMain;
import org.chromium.content.app.LibraryLoader;
import org.chromium.content.browser.ContentViewStatics;
import org.chromium.content.browser.ResourceExtractor;
import org.chromium.content.common.CommandLine;
import org.chromium.content.common.ProcessInitException;

public class WebViewChromiumFactoryProvider
implements WebViewFactoryProvider {
    private static final String CHROMIUM_PREFS_NAME = "WebViewChromiumPrefs";
    private static final String COMMAND_LINE_FILE = "/data/local/tmp/webview-command-line";
    private final Object mLock = new Object();
    private AwBrowserContext mBrowserContext;
    private WebViewFactoryProvider.Statics mStaticMethods;
    private GeolocationPermissionsAdapter mGeolocationPermissions;
    private CookieManagerAdapter mCookieManager;
    private WebIconDatabaseAdapter mWebIconDatabase;
    private WebStorageAdapter mWebStorage;
    private WebViewDatabaseAdapter mWebViewDatabase;
    private AwDevToolsServer mDevToolsServer;
    private ArrayList<WeakReference<WebViewChromium>> mWebViewsToStart = new ArrayList();
    private boolean mStarted;

    public WebViewChromiumFactoryProvider() {
        AwBrowserProcess.loadLibrary();
        System.loadLibrary("webviewchromium_plat_support");
        ThreadUtils.setWillOverrideUiThread();
    }

    private void initPlatSupportLibrary() {
        DrawGLFunctor.setChromiumAwDrawGLFunction(AwContents.getAwDrawGLFunction());
        AwContents.setAwDrawSWFunctionTable(GraphicsUtils.getDrawSWFunctionTable());
        AwContents.setAwDrawGLFunctionTable(GraphicsUtils.getDrawGLFunctionTable());
    }

    private void ensureChromiumStartedLocked(boolean onMainThread) {
        assert (Thread.holdsLock(this.mLock));
        if (this.mStarted) {
            return;
        }
        Looper looper = !onMainThread ? Looper.myLooper() : Looper.getMainLooper();
        Log.v("WebViewChromium", "Binding Chromium to the " + (onMainThread ? "main" : "background") + " looper " + looper);
        ThreadUtils.setUiThread(looper);
        if (ThreadUtils.runningOnUiThread()) {
            this.startChromiumLocked();
            return;
        }
        ThreadUtils.postOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = WebViewChromiumFactoryProvider.this.mLock;
                synchronized (object) {
                    WebViewChromiumFactoryProvider.this.startChromiumLocked();
                }
            }
        });
        while (!this.mStarted) {
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void startChromiumLocked() {
        assert (Thread.holdsLock(this.mLock) && ThreadUtils.runningOnUiThread());
        this.mLock.notifyAll();
        if (this.mStarted) {
            return;
        }
        if (Build.IS_DEBUGGABLE) {
            CommandLine.initFromFile(COMMAND_LINE_FILE);
        } else {
            CommandLine.init(null);
        }
        CommandLine cl = CommandLine.getInstance();
        cl.appendSwitch("enable-dcheck");
        if (!cl.hasSwitch("disable-webview-gl-mode")) {
            cl.appendSwitch("testing-webview-gl-mode");
        }
        Application context = ActivityThread.currentApplication();
        if (((Context)context).getApplicationInfo().targetSdkVersion < 19) {
            cl.appendSwitch("enable-webview-classic-workarounds");
        }
        ResourceExtractor.setMandatoryPaksToExtract("");
        try {
            LibraryLoader.ensureInitialized();
        }
        catch (ProcessInitException e) {
            throw new RuntimeException("Error initializing WebView library", e);
        }
        PathService.override(3, "/system/lib/");
        int DIR_RESOURCE_PAKS_ANDROID = 3003;
        PathService.override(3003, "/system/framework/webview/paks");
        AwBrowserProcess.start(ActivityThread.currentApplication());
        this.initPlatSupportLibrary();
        if (Build.IS_DEBUGGABLE) {
            this.setWebContentsDebuggingEnabled(true);
        }
        this.mStarted = true;
        for (WeakReference<WebViewChromium> wvc : this.mWebViewsToStart) {
            WebViewChromium w = (WebViewChromium)wvc.get();
            if (w == null) continue;
            w.startYourEngine();
        }
        this.mWebViewsToStart.clear();
        this.mWebViewsToStart = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewFactoryProvider.Statics getStatics() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStaticMethods == null) {
                this.ensureChromiumStartedLocked(true);
                this.mStaticMethods = new WebViewFactoryProvider.Statics(){

                    public String findAddress(String addr) {
                        return ContentViewStatics.findAddress(addr);
                    }

                    public void setPlatformNotificationsEnabled(boolean enable) {
                    }

                    public String getDefaultUserAgent(Context context) {
                        return AwSettings.getDefaultUserAgent();
                    }

                    public void setWebContentsDebuggingEnabled(boolean enable) {
                        if (!Build.IS_DEBUGGABLE) {
                            WebViewChromiumFactoryProvider.this.setWebContentsDebuggingEnabled(enable);
                        }
                    }
                };
            }
        }
        return this.mStaticMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewProvider createWebView(WebView webView, WebView.PrivateAccess privateAccess) {
        WebViewChromium wvc = new WebViewChromium(this, webView, privateAccess);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWebViewsToStart != null) {
                this.mWebViewsToStart.add(new WeakReference<WebViewChromium>(wvc));
            }
        }
        ResourceProvider.registerResources(webView.getContext());
        return wvc;
    }

    boolean hasStarted() {
        return this.mStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startYourEngines(boolean onMainThread) {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureChromiumStartedLocked(onMainThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeolocationPermissions getGeolocationPermissions() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mGeolocationPermissions == null) {
                this.ensureChromiumStartedLocked(true);
                this.mGeolocationPermissions = new GeolocationPermissionsAdapter(this.getBrowserContextLocked().getGeolocationPermissions());
            }
        }
        return this.mGeolocationPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AwBrowserContext getBrowserContext() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getBrowserContextLocked();
        }
    }

    private AwBrowserContext getBrowserContextLocked() {
        assert (Thread.holdsLock(this.mLock));
        assert (this.mStarted);
        if (this.mBrowserContext == null) {
            this.mBrowserContext = new AwBrowserContext(ActivityThread.currentApplication().getSharedPreferences(CHROMIUM_PREFS_NAME, 0));
        }
        return this.mBrowserContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CookieManager getCookieManager() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCookieManager == null) {
                if (!this.mStarted) {
                    ContentMain.initApplicationContext(ActivityThread.currentApplication());
                }
                this.mCookieManager = new CookieManagerAdapter(new AwCookieManager());
            }
        }
        return this.mCookieManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebIconDatabase getWebIconDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWebIconDatabase == null) {
                this.ensureChromiumStartedLocked(true);
                this.mWebIconDatabase = new WebIconDatabaseAdapter();
            }
        }
        return this.mWebIconDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebStorage getWebStorage() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWebStorage == null) {
                this.ensureChromiumStartedLocked(true);
                this.mWebStorage = new WebStorageAdapter(AwQuotaManagerBridge.getInstance());
            }
        }
        return this.mWebStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewDatabase getWebViewDatabase(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWebViewDatabase == null) {
                this.ensureChromiumStartedLocked(true);
                AwBrowserContext browserContext = this.getBrowserContextLocked();
                this.mWebViewDatabase = new WebViewDatabaseAdapter(browserContext.getFormDatabase(), browserContext.getHttpAuthDatabase(context));
            }
        }
        return this.mWebViewDatabase;
    }

    private void setWebContentsDebuggingEnabled(boolean enable) {
        if (Looper.myLooper() != ThreadUtils.getUiThreadLooper()) {
            throw new RuntimeException("Toggling of Web Contents Debugging must be done on the UI thread");
        }
        if (this.mDevToolsServer == null) {
            if (!enable) {
                return;
            }
            this.mDevToolsServer = new AwDevToolsServer();
        }
        this.mDevToolsServer.setRemoteDebuggingEnabled(enable);
    }
}

