/*
 * Decompiled with CFR 0.152.
 */
package com.android.webview.chromium;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.net.http.ErrorStrings;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsDialogHelper;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.android.webview.chromium.UnimplementedWebViewApi;
import com.android.webview.chromium.WebViewChromium;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import org.chromium.android_webview.AwContentsClient;
import org.chromium.android_webview.AwHttpAuthHandler;
import org.chromium.android_webview.InterceptedRequestData;
import org.chromium.android_webview.JsPromptResultReceiver;
import org.chromium.android_webview.JsResultReceiver;
import org.chromium.base.ThreadUtils;
import org.chromium.content.common.TraceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewContentsClientAdapter
extends AwContentsClient {
    private static final String TAG = "WebViewCallback";
    private static final boolean TRACE = false;
    private final WebView mWebView;
    private WebViewClient mWebViewClient;
    private WebChromeClient mWebChromeClient;
    private WebView.FindListener mFindListener;
    private WebView.PictureListener mPictureListener;
    private DownloadListener mDownloadListener;
    private Handler mUiThreadHandler;
    private SoftReference<Bitmap> mCachedDefaultVideoPoster;
    private static final int NEW_WEBVIEW_CREATED = 100;

    WebViewContentsClientAdapter(WebView webView) {
        if (webView == null) {
            throw new IllegalArgumentException("webView can't be null");
        }
        this.mWebView = webView;
        this.setWebViewClient(null);
        this.mUiThreadHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        WebView.WebViewTransport t = (WebView.WebViewTransport)msg.obj;
                        WebView newWebView = t.getWebView();
                        if (newWebView == WebViewContentsClientAdapter.this.mWebView) {
                            throw new IllegalArgumentException("Parent WebView cannot host it's own popup window. Please use WebSettings.setSupportMultipleWindows(false)");
                        }
                        if (newWebView != null && newWebView.copyBackForwardList().getSize() != 0) {
                            throw new IllegalArgumentException("New WebView for popup window must not have been previously navigated.");
                        }
                        WebViewChromium.completeWindowCreation(WebViewContentsClientAdapter.this.mWebView, newWebView);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        };
    }

    void setWebViewClient(WebViewClient client) {
        this.mWebViewClient = client != null ? client : new NullWebViewClient();
    }

    void setWebChromeClient(WebChromeClient client) {
        this.mWebChromeClient = client;
    }

    void setDownloadListener(DownloadListener listener) {
        this.mDownloadListener = listener;
    }

    void setFindListener(WebView.FindListener listener) {
        this.mFindListener = listener;
    }

    void setPictureListener(WebView.PictureListener listener) {
        this.mPictureListener = listener;
    }

    @Override
    public void getVisitedHistory(ValueCallback<String[]> callback) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.getVisitedHistory(callback);
        }
        TraceEvent.end();
    }

    @Override
    public void doUpdateVisitedHistory(String url, boolean isReload) {
        TraceEvent.begin();
        this.mWebViewClient.doUpdateVisitedHistory(this.mWebView, url, isReload);
        TraceEvent.end();
    }

    @Override
    public void onProgressChanged(int progress) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onProgressChanged(this.mWebView, progress);
        }
        TraceEvent.end();
    }

    @Override
    public InterceptedRequestData shouldInterceptRequest(String url) {
        TraceEvent.begin();
        WebResourceResponse response = this.mWebViewClient.shouldInterceptRequest(this.mWebView, url);
        TraceEvent.end();
        if (response == null) {
            return null;
        }
        return new InterceptedRequestData(response.getMimeType(), response.getEncoding(), response.getData());
    }

    @Override
    public boolean shouldOverrideUrlLoading(String url) {
        TraceEvent.begin();
        boolean result = this.mWebViewClient.shouldOverrideUrlLoading(this.mWebView, url);
        TraceEvent.end();
        return result;
    }

    @Override
    public void onUnhandledKeyEvent(KeyEvent event) {
        TraceEvent.begin();
        this.mWebViewClient.onUnhandledKeyEvent(this.mWebView, event);
        TraceEvent.end();
    }

    @Override
    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        boolean result;
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            result = this.mWebChromeClient.onConsoleMessage(consoleMessage);
            String message = consoleMessage.message();
            if (result && message != null && message.startsWith("[blocked]")) {
                Log.e(TAG, "Blocked URL: " + message);
            }
        } else {
            result = false;
        }
        TraceEvent.end();
        return result;
    }

    @Override
    public void onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting) {
        if (this.mFindListener == null) {
            return;
        }
        TraceEvent.begin();
        this.mFindListener.onFindResultReceived(activeMatchOrdinal, numberOfMatches, isDoneCounting);
        TraceEvent.end();
    }

    @Override
    public void onNewPicture(Picture picture) {
        if (this.mPictureListener == null) {
            return;
        }
        TraceEvent.begin();
        this.mPictureListener.onNewPicture(this.mWebView, picture);
        TraceEvent.end();
    }

    @Override
    public void onLoadResource(String url) {
        TraceEvent.begin();
        this.mWebViewClient.onLoadResource(this.mWebView, url);
        TraceEvent.end();
    }

    @Override
    public boolean onCreateWindow(boolean isDialog, boolean isUserGesture) {
        Message m = this.mUiThreadHandler.obtainMessage(100, this.mWebView.new WebView.WebViewTransport());
        TraceEvent.begin();
        boolean result = this.mWebChromeClient != null ? this.mWebChromeClient.onCreateWindow(this.mWebView, isDialog, isUserGesture, m) : false;
        TraceEvent.end();
        return result;
    }

    @Override
    public void onCloseWindow() {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onCloseWindow(this.mWebView);
        }
        TraceEvent.end();
    }

    @Override
    public void onRequestFocus() {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onRequestFocus(this.mWebView);
        }
        TraceEvent.end();
    }

    @Override
    public void onReceivedTouchIconUrl(String url, boolean precomposed) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onReceivedTouchIconUrl(this.mWebView, url, precomposed);
        }
        TraceEvent.end();
    }

    @Override
    public void onReceivedIcon(Bitmap bitmap) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onReceivedIcon(this.mWebView, bitmap);
        }
        TraceEvent.end();
    }

    @Override
    public void onPageStarted(String url) {
        TraceEvent.begin();
        this.mWebViewClient.onPageStarted(this.mWebView, url, this.mWebView.getFavicon());
        TraceEvent.end();
    }

    @Override
    public void onPageFinished(String url) {
        TraceEvent.begin();
        this.mWebViewClient.onPageFinished(this.mWebView, url);
        TraceEvent.end();
        if (this.mPictureListener != null) {
            ThreadUtils.postOnUiThreadDelayed(new Runnable(){

                public void run() {
                    UnimplementedWebViewApi.invoke();
                    if (WebViewContentsClientAdapter.this.mPictureListener != null) {
                        WebViewContentsClientAdapter.this.mPictureListener.onNewPicture(WebViewContentsClientAdapter.this.mWebView, new Picture());
                    }
                }
            }, 100L);
        }
    }

    @Override
    public void onReceivedError(int errorCode, String description, String failingUrl) {
        if (description == null || description.isEmpty()) {
            description = ErrorStrings.getString(errorCode, this.mWebView.getContext());
        }
        TraceEvent.begin();
        this.mWebViewClient.onReceivedError(this.mWebView, errorCode, description, failingUrl);
        TraceEvent.end();
    }

    @Override
    public void onReceivedTitle(String title) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onReceivedTitle(this.mWebView, title);
        }
        TraceEvent.end();
    }

    @Override
    public boolean shouldOverrideKeyEvent(KeyEvent event) {
        if (event.isSystem()) {
            return true;
        }
        TraceEvent.begin();
        boolean result = this.mWebViewClient.shouldOverrideKeyEvent(this.mWebView, event);
        TraceEvent.end();
        return result;
    }

    public void onStartContentIntent(Context context, String contentUrl) {
        TraceEvent.begin();
        this.mWebViewClient.shouldOverrideUrlLoading(this.mWebView, contentUrl);
        TraceEvent.end();
    }

    @Override
    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
        }
        TraceEvent.end();
    }

    @Override
    public void onGeolocationPermissionsHidePrompt() {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onGeolocationPermissionsHidePrompt();
        }
        TraceEvent.end();
    }

    @Override
    public void handleJsAlert(String url, String message, JsResultReceiver receiver) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            JsPromptResult res = new JsPromptResultReceiverAdapter(receiver).getPromptResult();
            if (!this.mWebChromeClient.onJsAlert(this.mWebView, url, message, res)) {
                new JsDialogHelper(res, 1, null, message, url).showDialog(this.mWebView.getContext());
            }
        } else {
            receiver.cancel();
        }
        TraceEvent.end();
    }

    @Override
    public void handleJsBeforeUnload(String url, String message, JsResultReceiver receiver) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            JsPromptResult res = new JsPromptResultReceiverAdapter(receiver).getPromptResult();
            if (!this.mWebChromeClient.onJsBeforeUnload(this.mWebView, url, message, res)) {
                new JsDialogHelper(res, 4, null, message, url).showDialog(this.mWebView.getContext());
            }
        } else {
            receiver.cancel();
        }
        TraceEvent.end();
    }

    @Override
    public void handleJsConfirm(String url, String message, JsResultReceiver receiver) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            JsPromptResult res = new JsPromptResultReceiverAdapter(receiver).getPromptResult();
            if (!this.mWebChromeClient.onJsConfirm(this.mWebView, url, message, res)) {
                new JsDialogHelper(res, 2, null, message, url).showDialog(this.mWebView.getContext());
            }
        } else {
            receiver.cancel();
        }
        TraceEvent.end();
    }

    @Override
    public void handleJsPrompt(String url, String message, String defaultValue, JsPromptResultReceiver receiver) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            JsPromptResult res = new JsPromptResultReceiverAdapter(receiver).getPromptResult();
            if (!this.mWebChromeClient.onJsPrompt(this.mWebView, url, message, defaultValue, res)) {
                new JsDialogHelper(res, 3, defaultValue, message, url).showDialog(this.mWebView.getContext());
            }
        } else {
            receiver.cancel();
        }
        TraceEvent.end();
    }

    @Override
    public void onReceivedHttpAuthRequest(AwHttpAuthHandler handler, String host, String realm) {
        TraceEvent.begin();
        this.mWebViewClient.onReceivedHttpAuthRequest(this.mWebView, new AwHttpAuthHandlerAdapter(handler), host, realm);
        TraceEvent.end();
    }

    @Override
    public void onReceivedSslError(final ValueCallback<Boolean> callback, SslError error) {
        SslErrorHandler handler = new SslErrorHandler(){

            public void proceed() {
                this.postProceed(true);
            }

            public void cancel() {
                this.postProceed(false);
            }

            private void postProceed(final boolean proceed) {
                this.post(new Runnable(){

                    public void run() {
                        callback.onReceiveValue(proceed);
                    }
                });
            }
        };
        TraceEvent.begin();
        this.mWebViewClient.onReceivedSslError(this.mWebView, handler, error);
        TraceEvent.end();
    }

    @Override
    public void onReceivedLoginRequest(String realm, String account, String args) {
        TraceEvent.begin();
        this.mWebViewClient.onReceivedLoginRequest(this.mWebView, realm, account, args);
        TraceEvent.end();
    }

    @Override
    public void onFormResubmission(Message dontResend, Message resend) {
        TraceEvent.begin();
        this.mWebViewClient.onFormResubmission(this.mWebView, dontResend, resend);
        TraceEvent.end();
    }

    @Override
    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
        if (this.mDownloadListener != null) {
            TraceEvent.begin();
            this.mDownloadListener.onDownloadStart(url, userAgent, contentDisposition, mimeType, contentLength);
            TraceEvent.end();
        }
    }

    @Override
    public void onScaleChangedScaled(float oldScale, float newScale) {
        TraceEvent.begin();
        this.mWebViewClient.onScaleChanged(this.mWebView, oldScale, newScale);
        TraceEvent.end();
    }

    @Override
    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback cb) {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onShowCustomView(view, cb);
        }
        TraceEvent.end();
    }

    @Override
    public void onHideCustomView() {
        TraceEvent.begin();
        if (this.mWebChromeClient != null) {
            this.mWebChromeClient.onHideCustomView();
        }
        TraceEvent.end();
    }

    @Override
    protected View getVideoLoadingProgressView() {
        TraceEvent.begin();
        View result = this.mWebChromeClient != null ? this.mWebChromeClient.getVideoLoadingProgressView() : null;
        TraceEvent.end();
        return result;
    }

    @Override
    public Bitmap getDefaultVideoPoster() {
        TraceEvent.begin();
        Bitmap result = null;
        if (this.mWebChromeClient != null) {
            result = this.mWebChromeClient.getDefaultVideoPoster();
        }
        if (result == null) {
            if (this.mCachedDefaultVideoPoster != null) {
                result = (Bitmap)this.mCachedDefaultVideoPoster.get();
            }
            if (result == null) {
                Bitmap poster = BitmapFactory.decodeResource(this.mWebView.getContext().getResources(), 17302319);
                result = Bitmap.createBitmap(poster.getWidth(), poster.getHeight(), poster.getConfig());
                result.eraseColor(-7829368);
                Canvas canvas = new Canvas(result);
                canvas.drawBitmap(poster, 0.0f, 0.0f, null);
                this.mCachedDefaultVideoPoster = new SoftReference<Bitmap>(result);
            }
        }
        TraceEvent.end();
        return result;
    }

    private static class AwHttpAuthHandlerAdapter
    extends HttpAuthHandler {
        private AwHttpAuthHandler mAwHandler;

        public AwHttpAuthHandlerAdapter(AwHttpAuthHandler awHandler) {
            this.mAwHandler = awHandler;
        }

        public void proceed(String username, String password) {
            if (username == null) {
                username = "";
            }
            if (password == null) {
                password = "";
            }
            this.mAwHandler.proceed(username, password);
        }

        public void cancel() {
            this.mAwHandler.cancel();
        }

        public boolean useHttpAuthUsernamePassword() {
            return this.mAwHandler.isFirstAttempt();
        }
    }

    private static class JsPromptResultReceiverAdapter
    implements JsResult.ResultReceiver {
        private JsPromptResultReceiver mChromePromptResultReceiver;
        private JsResultReceiver mChromeResultReceiver;
        private final JsPromptResult mPromptResult = new JsPromptResult(this);

        public JsPromptResultReceiverAdapter(JsPromptResultReceiver receiver) {
            this.mChromePromptResultReceiver = receiver;
        }

        public JsPromptResultReceiverAdapter(JsResultReceiver receiver) {
            this.mChromeResultReceiver = receiver;
        }

        public JsPromptResult getPromptResult() {
            return this.mPromptResult;
        }

        public void onJsResultComplete(JsResult result) {
            if (this.mChromePromptResultReceiver != null) {
                if (this.mPromptResult.getResult()) {
                    this.mChromePromptResultReceiver.confirm(this.mPromptResult.getStringResult());
                } else {
                    this.mChromePromptResultReceiver.cancel();
                }
            } else if (this.mPromptResult.getResult()) {
                this.mChromeResultReceiver.confirm();
            } else {
                this.mChromeResultReceiver.cancel();
            }
        }
    }

    static class NullWebViewClient
    extends WebViewClient {
        NullWebViewClient() {
        }

        public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
            int keyCode = event.getKeyCode();
            return keyCode == 82 || keyCode == 3 || keyCode == 4 || keyCode == 5 || keyCode == 6 || keyCode == 26 || keyCode == 79 || keyCode == 27 || keyCode == 80 || keyCode == 25 || keyCode == 164 || keyCode == 24;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Intent intent;
            try {
                intent = Intent.parseUri(url, 1);
            }
            catch (URISyntaxException ex) {
                Log.w(WebViewContentsClientAdapter.TAG, "Bad URI " + url + ": " + ex.getMessage());
                return false;
            }
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.setComponent(null);
            intent.putExtra("com.android.browser.application_id", view.getContext().getPackageName());
            try {
                view.getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException ex) {
                Log.w(WebViewContentsClientAdapter.TAG, "No application can handle " + url);
                return false;
            }
            return true;
        }
    }
}

