/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util;

import android.content.Context;
import android.drm.DrmConvertedStatus;
import android.drm.DrmManagerClient;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DrmConvertSession {
    private DrmManagerClient mDrmClient;
    private int mConvertSessionId;
    private static final String TAG = "DrmConvertSession";

    private DrmConvertSession(DrmManagerClient drmClient, int convertSessionId) {
        this.mDrmClient = drmClient;
        this.mConvertSessionId = convertSessionId;
    }

    public static DrmConvertSession open(Context context, String mimeType) {
        DrmManagerClient drmClient = null;
        int convertSessionId = -1;
        if (context != null && mimeType != null && !mimeType.equals("")) {
            try {
                drmClient = new DrmManagerClient(context);
                try {
                    convertSessionId = drmClient.openConvertSession(mimeType);
                }
                catch (IllegalArgumentException e) {
                    Log.w(TAG, "Conversion of Mimetype: " + mimeType + " is not supported.", e);
                }
                catch (IllegalStateException e) {
                    Log.w(TAG, "Could not access Open DrmFramework.", e);
                }
            }
            catch (IllegalArgumentException e) {
                Log.w(TAG, "DrmManagerClient instance could not be created, context is Illegal.");
            }
            catch (IllegalStateException e) {
                Log.w(TAG, "DrmManagerClient didn't initialize properly.");
            }
        }
        if (drmClient == null || convertSessionId < 0) {
            return null;
        }
        return new DrmConvertSession(drmClient, convertSessionId);
    }

    public byte[] convert(byte[] inBuffer, int size) {
        byte[] result = null;
        if (inBuffer != null) {
            DrmConvertedStatus convertedStatus = null;
            try {
                if (size != inBuffer.length) {
                    byte[] buf = new byte[size];
                    System.arraycopy(inBuffer, 0, buf, 0, size);
                    convertedStatus = this.mDrmClient.convertData(this.mConvertSessionId, buf);
                } else {
                    convertedStatus = this.mDrmClient.convertData(this.mConvertSessionId, inBuffer);
                }
                if (convertedStatus != null && convertedStatus.statusCode == 1 && convertedStatus.convertedData != null) {
                    result = convertedStatus.convertedData;
                }
            }
            catch (IllegalArgumentException e) {
                Log.w(TAG, "Buffer with data to convert is illegal. Convertsession: " + this.mConvertSessionId, e);
            }
            catch (IllegalStateException e) {
                Log.w(TAG, "Could not convert data. Convertsession: " + this.mConvertSessionId, e);
            }
        } else {
            throw new IllegalArgumentException("Parameter inBuffer is null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int close(String filename) {
        DrmConvertedStatus convertedStatus = null;
        int result = 491;
        if (this.mDrmClient == null) return result;
        if (this.mConvertSessionId < 0) return result;
        try {
            convertedStatus = this.mDrmClient.closeConvertSession(this.mConvertSessionId);
            if (convertedStatus == null) return 406;
            if (convertedStatus.statusCode != 1) return 406;
            if (convertedStatus.convertedData == null) {
                return 406;
            }
            RandomAccessFile rndAccessFile = null;
            rndAccessFile = new RandomAccessFile(filename, "rw");
            rndAccessFile.seek(convertedStatus.offset);
            rndAccessFile.write(convertedStatus.convertedData);
            result = 200;
            Object var7_6 = null;
            if (rndAccessFile == null) return result;
            try {
                rndAccessFile.close();
                return result;
            }
            catch (IOException e2) {
                result = 492;
                Log.w(TAG, "Failed to close File:" + filename + ".", e2);
            }
            return result;
            {
                catch (FileNotFoundException e) {
                    result = 492;
                    Log.w(TAG, "File: " + filename + " could not be found.", e);
                    Object var7_7 = null;
                    if (rndAccessFile == null) return result;
                    try {
                        rndAccessFile.close();
                        return result;
                    }
                    catch (IOException e2) {
                        result = 492;
                        Log.w(TAG, "Failed to close File:" + filename + ".", e2);
                    }
                    return result;
                }
                catch (IOException e) {
                    result = 492;
                    Log.w(TAG, "Could not access File: " + filename + " .", e);
                    Object var7_8 = null;
                    if (rndAccessFile == null) return result;
                    try {
                        rndAccessFile.close();
                        return result;
                    }
                    catch (IOException e2) {
                        result = 492;
                        Log.w(TAG, "Failed to close File:" + filename + ".", e2);
                    }
                    return result;
                }
                catch (IllegalArgumentException e) {
                    result = 492;
                    Log.w(TAG, "Could not open file in mode: rw", e);
                    Object var7_9 = null;
                    if (rndAccessFile == null) return result;
                    try {
                        rndAccessFile.close();
                        return result;
                    }
                    catch (IOException e2) {
                        result = 492;
                        Log.w(TAG, "Failed to close File:" + filename + ".", e2);
                    }
                    return result;
                }
                catch (SecurityException e) {
                    Log.w(TAG, "Access to File: " + filename + " was denied denied by SecurityManager.", e);
                    Object var7_10 = null;
                    if (rndAccessFile == null) return result;
                    try {
                        rndAccessFile.close();
                        return result;
                    }
                    catch (IOException e2) {
                        result = 492;
                        Log.w(TAG, "Failed to close File:" + filename + ".", e2);
                    }
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (rndAccessFile == null) throw throwable;
                try {
                    rndAccessFile.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    result = 492;
                    Log.w(TAG, "Failed to close File:" + filename + ".", e2);
                }
                throw throwable;
            }
        }
        catch (IllegalStateException e) {
            Log.w(TAG, "Could not close convertsession. Convertsession: " + this.mConvertSessionId, e);
        }
        return result;
    }
}

