/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class Shorts {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short value) {
        return value;
    }

    public static short checkedCast(long value) {
        short result = (short)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", value);
        return result;
    }

    public static short saturatedCast(long value) {
        if (value > 32767L) {
            return Short.MAX_VALUE;
        }
        if (value < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)value;
    }

    public static int compare(short a, short b) {
        return a - b;
    }

    public static boolean contains(short[] array2, short target) {
        for (short value : array2) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(short[] array2, short target) {
        return Shorts.indexOf(array2, target, 0, array2.length);
    }

    private static int indexOf(short[] array2, short target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array2, short[] target) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array2.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array2[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array2, short target) {
        return Shorts.lastIndexOf(array2, target, 0, array2.length);
    }

    private static int lastIndexOf(short[] array2, short target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static short min(short ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        short min = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min) continue;
            min = array2[i];
        }
        return min;
    }

    public static short max(short ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        short max = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max) continue;
            max = array2[i];
        }
        return max;
    }

    public static short[] concat(short[] ... arrays) {
        int length = 0;
        for (short[] array2 : arrays) {
            length += array2.length;
        }
        short[] result = new short[length];
        int pos = 0;
        for (short[] array3 : arrays) {
            System.arraycopy(array3, 0, result, pos, array3.length);
            pos += array3.length;
        }
        return result;
    }

    @GwtIncompatible(value="doesn't work")
    public static byte[] toByteArray(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    @GwtIncompatible(value="doesn't work")
    public static short fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 2, "array too small: %s < %s", bytes.length, 2);
        return Shorts.fromBytes(bytes[0], bytes[1]);
    }

    @GwtIncompatible(value="doesn't work")
    public static short fromBytes(byte b1, byte b2) {
        return (short)(b1 << 8 | b2 & 0xFF);
    }

    public static short[] ensureCapacity(short[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Shorts.copyOf(array2, minLength + padding) : array2;
    }

    private static short[] copyOf(short[] original, int length) {
        short[] copy = new short[length];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, length));
        return copy;
    }

    public static String join(String separator, short ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 6);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static short[] toArray(Collection<Short> collection) {
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        short[] array2 = new short[len];
        for (int i = 0; i < len; ++i) {
            array2[i] = (Short)Preconditions.checkNotNull(boxedArray[i]);
        }
        return array2;
    }

    public static List<Short> asList(short ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(backingArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements RandomAccess,
    Serializable {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ShortArrayAsList(short[] array2) {
            this(array2, 0, array2.length);
        }

        ShortArrayAsList(short[] array2, int start, int end) {
            this.array = array2;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Short get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Short && Shorts.indexOf(this.array, (Short)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.indexOf(this.array, (Short)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.lastIndexOf(this.array, (Short)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int index, Short element) {
            Preconditions.checkElementIndex(index, this.size());
            short oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Short> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList that = (ShortArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Shorts.hashCode(this.array[i]);
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 6);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            System.arraycopy(this.array, this.start, result, 0, size);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] left, short[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Shorts.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

