/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Job;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class Dispatcher {
    private final ThreadPoolExecutor executorService = new ThreadPoolExecutor(8, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Map<Object, List<Job>> enqueuedJobs = new LinkedHashMap<Object, List<Job>>();

    Dispatcher() {
    }

    public synchronized void enqueue(HttpURLConnection connection, Request request, Response.Receiver responseReceiver) {
        Job job = new Job(this, connection, request, responseReceiver);
        List<Job> jobsForTag = this.enqueuedJobs.get(request.tag());
        if (jobsForTag == null) {
            jobsForTag = new ArrayList<Job>(2);
            this.enqueuedJobs.put(request.tag(), jobsForTag);
        }
        jobsForTag.add(job);
        this.executorService.execute(job);
    }

    public synchronized void cancel(Object tag) {
        List<Job> jobs = this.enqueuedJobs.remove(tag);
        if (jobs == null) {
            return;
        }
        for (Job job : jobs) {
            this.executorService.remove(job);
        }
    }

    synchronized void finished(Job job) {
        List<Job> jobs = this.enqueuedJobs.get(job.request.tag());
        if (jobs != null) {
            jobs.remove(job);
        }
    }

    static class RealResponseBody
    extends Response.Body {
        private final HttpURLConnection connection;
        private final InputStream in;

        RealResponseBody(HttpURLConnection connection, InputStream in) {
            this.connection = connection;
            this.in = in;
        }

        public String contentType() {
            return this.connection.getHeaderField("Content-Type");
        }

        public long contentLength() {
            return this.connection.getContentLength();
        }

        public InputStream byteStream() throws IOException {
            return this.in;
        }
    }
}

