/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

final class Hpack {
    static final int PREFIX_5_BITS = 31;
    static final int PREFIX_6_BITS = 63;
    static final int PREFIX_7_BITS = 127;
    static final int PREFIX_8_BITS = 255;
    static final List<String> INITIAL_CLIENT_TO_SERVER_HEADER_TABLE = Arrays.asList(":scheme", "http", ":scheme", "https", ":host", "", ":path", "/", ":method", "GET", "accept", "", "accept-charset", "", "accept-encoding", "", "accept-language", "", "cookie", "", "if-modified-since", "", "user-agent", "", "referer", "", "authorization", "", "allow", "", "cache-control", "", "connection", "", "content-length", "", "content-type", "", "date", "", "expect", "", "from", "", "if-match", "", "if-none-match", "", "if-range", "", "if-unmodified-since", "", "max-forwards", "", "proxy-authorization", "", "range", "", "via", "");
    static final List<String> INITIAL_SERVER_TO_CLIENT_HEADER_TABLE = Arrays.asList(":status", "200", "age", "", "cache-control", "", "content-length", "", "content-type", "", "date", "", "etag", "", "expires", "", "last-modified", "", "server", "", "set-cookie", "", "vary", "", "via", "", "access-control-allow-origin", "", "accept-ranges", "", "allow", "", "connection", "", "content-disposition", "", "content-encoding", "", "content-language", "", "content-location", "", "content-range", "", "link", "", "location", "", "proxy-authenticate", "", "refresh", "", "retry-after", "", "strict-transport-security", "", "transfer-encoding", "", "www-authenticate", "");

    private Hpack() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Writer {
        private final OutputStream out;

        Writer(OutputStream out) {
            this.out = out;
        }

        public void writeHeaders(List<String> nameValueBlock) throws IOException {
            int size = nameValueBlock.size();
            for (int i = 0; i < size; i += 2) {
                this.out.write(96);
                this.writeString(nameValueBlock.get(i));
                this.writeString(nameValueBlock.get(i + 1));
            }
        }

        public void writeInt(int value, int prefixMask, int bits) throws IOException {
            if (value < prefixMask) {
                this.out.write(bits | value);
                return;
            }
            this.out.write(bits | prefixMask);
            value -= prefixMask;
            while (value >= 128) {
                int b = value & 0x7F;
                this.out.write(b | 0x80);
                value >>>= 7;
            }
            this.out.write(value);
        }

        public void writeString(String headerName) throws IOException {
            byte[] bytes = headerName.getBytes("UTF-8");
            this.writeInt(bytes.length, 255, 0);
            this.out.write(bytes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Reader {
        private final long maxBufferSize = 4096L;
        private final DataInputStream in;
        private final BitSet referenceSet = new BitSet();
        private final List<String> headerTable;
        private final List<String> emittedHeaders = new ArrayList<String>();
        private long bufferSize = 4096L;
        private long bytesLeft = 0L;

        Reader(DataInputStream in, boolean client) {
            this.in = in;
            this.headerTable = new ArrayList<String>(client ? INITIAL_CLIENT_TO_SERVER_HEADER_TABLE : INITIAL_SERVER_TO_CLIENT_HEADER_TABLE);
        }

        public void readHeaders(int byteCount) throws IOException {
            this.bytesLeft += (long)byteCount;
            while (this.bytesLeft > 0L) {
                int index;
                int b = this.readByte();
                if ((b & 0x80) != 0) {
                    index = this.readInt(b, 127);
                    this.readIndexedHeader(index);
                    continue;
                }
                if (b == 96) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                if ((b & 0xE0) == 96) {
                    index = this.readInt(b, 31);
                    this.readLiteralHeaderWithoutIndexingIndexedName(index - 1);
                    continue;
                }
                if (b == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((b & 0xE0) == 64) {
                    index = this.readInt(b, 31);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(index - 1);
                    continue;
                }
                if (b == 0) {
                    this.readLiteralHeaderWithSubstitutionIndexingNewName();
                    continue;
                }
                if ((b & 0xC0) == 0) {
                    index = this.readInt(b, 63);
                    this.readLiteralHeaderWithSubstitutionIndexingIndexedName(index - 1);
                    continue;
                }
                throw new AssertionError();
            }
        }

        public void emitReferenceSet() {
            int i = this.referenceSet.nextSetBit(0);
            while (i != -1) {
                this.emittedHeaders.add(this.getName(i));
                this.emittedHeaders.add(this.getValue(i));
                i = this.referenceSet.nextSetBit(i + 1);
            }
        }

        public List<String> getAndReset() {
            ArrayList<String> result = new ArrayList<String>(this.emittedHeaders);
            this.emittedHeaders.clear();
            return result;
        }

        private void readIndexedHeader(int index) {
            if (this.referenceSet.get(index)) {
                this.referenceSet.clear(index);
            } else {
                this.referenceSet.set(index);
                this.emittedHeaders.add(this.getName(index));
                this.emittedHeaders.add(this.getValue(index));
            }
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int index) throws IOException {
            String name = this.getName(index);
            String value = this.readString();
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            String name = this.readString();
            String value = this.readString();
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int nameIndex) throws IOException {
            int index = this.headerTable.size();
            String name = this.getName(nameIndex);
            String value = this.readString();
            this.appendToHeaderTable(name, value);
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
            this.referenceSet.set(index);
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            int index = this.headerTable.size();
            String name = this.readString();
            String value = this.readString();
            this.appendToHeaderTable(name, value);
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
            this.referenceSet.set(index);
        }

        private void readLiteralHeaderWithSubstitutionIndexingIndexedName(int nameIndex) throws IOException {
            int index = this.readInt(this.readByte(), 255);
            String name = this.getName(nameIndex);
            String value = this.readString();
            this.replaceInHeaderTable(index, name, value);
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
            this.referenceSet.set(index);
        }

        private void readLiteralHeaderWithSubstitutionIndexingNewName() throws IOException {
            String name = this.readString();
            int index = this.readInt(this.readByte(), 255);
            String value = this.readString();
            this.replaceInHeaderTable(index, name, value);
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
            this.referenceSet.set(index);
        }

        private String getName(int index) {
            return this.headerTable.get(index * 2);
        }

        private String getValue(int index) {
            return this.headerTable.get(index * 2 + 1);
        }

        private void appendToHeaderTable(String name, String value) {
            this.insertIntoHeaderTable(this.headerTable.size() * 2, name, value);
        }

        private void replaceInHeaderTable(int index, String name, String value) {
            this.remove(index);
            this.insertIntoHeaderTable(index, name, value);
        }

        private void insertIntoHeaderTable(int index, String name, String value) {
            int delta = 32 + name.length() + value.length();
            while (this.bufferSize + (long)delta > 4096L) {
                this.remove(0);
                --index;
            }
            if ((long)delta > 4096L) {
                return;
            }
            if (index == 0) {
                index = 0;
            }
            this.headerTable.add(index * 2, name);
            this.headerTable.add(index * 2 + 1, value);
            this.bufferSize += (long)delta;
        }

        private void remove(int index) {
            String name = this.headerTable.remove(index * 2);
            String value = this.headerTable.remove(index * 2);
            this.bufferSize -= (long)(32 + name.length() + value.length());
        }

        private int readByte() throws IOException {
            --this.bytesLeft;
            return this.in.readByte() & 0xFF;
        }

        int readInt(int firstByte, int prefixMask) throws IOException {
            int b;
            int prefix = firstByte & prefixMask;
            if (prefix < prefixMask) {
                return prefix;
            }
            int result = prefixMask;
            int shift = 0;
            while (((b = this.readByte()) & 0x80) != 0) {
                result += (b & 0x7F) << shift;
                shift += 7;
            }
            return result += b << shift;
        }

        public String readString() throws IOException {
            int firstByte = this.readByte();
            int length = this.readInt(firstByte, 255);
            byte[] encoded = new byte[length];
            this.bytesLeft -= (long)length;
            this.in.readFully(encoded);
            return new String(encoded, "UTF-8");
        }
    }
}

