/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import libcore.util.SneakyThrow;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] buf;
    private int pos;

    public BufferedWriter(Writer out) {
        this(out, 8192);
    }

    public BufferedWriter(Writer out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.out = out;
        this.buf = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Throwable thrown;
            block9: {
                if (this.isClosed()) {
                    return;
                }
                thrown = null;
                try {
                    this.flushInternal();
                }
                catch (Throwable e) {
                    thrown = e;
                }
                this.buf = null;
                try {
                    this.out.close();
                }
                catch (Throwable e) {
                    if (thrown != null) break block9;
                    thrown = e;
                }
            }
            this.out = null;
            if (thrown != null) {
                SneakyThrow.sneakyThrow(thrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.flushInternal();
            this.out.flush();
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("BufferedWriter is closed");
        }
    }

    private void flushInternal() throws IOException {
        if (this.pos > 0) {
            this.out.write(this.buf, 0, this.pos);
        }
        this.pos = 0;
    }

    private boolean isClosed() {
        return this.out == null;
    }

    public void newLine() throws IOException {
        this.write(System.lineSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buffer, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (buffer == null) {
                throw new NullPointerException("buffer == null");
            }
            Arrays.checkOffsetAndCount(buffer.length, offset, count);
            if (this.pos == 0 && count >= this.buf.length) {
                this.out.write(buffer, offset, count);
                return;
            }
            int available = this.buf.length - this.pos;
            if (count < available) {
                available = count;
            }
            if (available > 0) {
                System.arraycopy(buffer, offset, this.buf, this.pos, available);
                this.pos += available;
            }
            if (this.pos == this.buf.length) {
                this.out.write(this.buf, 0, this.buf.length);
                this.pos = 0;
                if (count > available) {
                    offset += available;
                    if ((available = count - available) >= this.buf.length) {
                        this.out.write(buffer, offset, available);
                        return;
                    }
                    System.arraycopy(buffer, offset, this.buf, this.pos, available);
                    this.pos += available;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos >= this.buf.length) {
                this.out.write(this.buf, 0, this.buf.length);
                this.pos = 0;
            }
            this.buf[this.pos++] = (char)oneChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (count <= 0) {
                return;
            }
            if (offset < 0 || offset > str.length() - count) {
                throw new StringIndexOutOfBoundsException(str, offset, count);
            }
            if (this.pos == 0 && count >= this.buf.length) {
                char[] chars = new char[count];
                str.getChars(offset, offset + count, chars, 0);
                this.out.write(chars, 0, count);
                return;
            }
            int available = this.buf.length - this.pos;
            if (count < available) {
                available = count;
            }
            if (available > 0) {
                str.getChars(offset, offset + available, this.buf, this.pos);
                this.pos += available;
            }
            if (this.pos == this.buf.length) {
                this.out.write(this.buf, 0, this.buf.length);
                this.pos = 0;
                if (count > available) {
                    offset += available;
                    if ((available = count - available) >= this.buf.length) {
                        char[] chars = new char[count];
                        str.getChars(offset, offset + available, chars, 0);
                        this.out.write(chars, 0, available);
                        return;
                    }
                    str.getChars(offset, offset + available, this.buf, this.pos);
                    this.pos += available;
                }
            }
        }
    }
}

